//  
//  by Michael Lewis & Luke Nakatsukasa
//  for Internet Raytracing Competition Nov-Dec 2000
//
//  Persistance of Vision Raytracer
//  World definition file.
//
//  Contains 2 lights, 13 textures and 97 primitives.
//
//  This file was generated by MORAY V2.5b.wat
//


camera {  //  Camera StdCam
  location  <17.918, -45.584, 3.000>
  direction <0.0,     0.0,  1.9679>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  look_at   <-0.146, 1.274, 0.648>
}

// *******  L I G H T S *******
light_source { // AreaL001
  <-1.485, -13.886, -0.562>
  color  rgb<1.000, 1.000, 1.000>
  area_light <14.227, 0.000, 0.000>, <0.000, -7.191, -2.444>, 3, 3
  adaptive 1
  jitter
}


light_source {   // EngineGlow
  <2.436, 0.478, -1.675>
  color rgb <1.000, 1.000, 1.000>
}

light_source {   // EngineGlow1
  <2.208, -0.583, -2.653>
  color rgb <1.000, 1.000, 1.000>
}

light_source {   // EngineGlow2
  <1.664, 0.304, -3.446>
  color rgb <1.000, 1.000, 1.000>
}

light_source {   // EngineGlow3
  <1.812, 1.411, -2.625>
  color rgb <1.000, 1.000, 1.000>
}

light_source {   // Light3
  <0.376, -6.266, 10.316>
  color rgb <1.000, 1.000, 1.000>
}


// ********  TEXTURES  *******
//

#include "titanium.inc"



// ********  REFERENCED OBJECTS  *******



// ********  OBJECTS  *******

#declare Dome = difference {
  sphere { // IglooDome
    <0,0,0>,1
    texture {
      Snow
    }
    scale 4.0
    translate  <0.819987, -12.030421, -7.404448>
  }
  box { // DomeClip
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Snow
    }
    scale <4.493495, 4.213578, 2.068733>
    translate  <0.873374, -12.012149, -9.5061>
  }
}
#declare IglooTunnel = difference {
  cylinder { // Tunnel
    <0,0,1>, <0,0,0>, 1 
    texture {
      Snow
    }
    scale <1.0, 1.506242, 3.924954>
    rotate -90.0*x
    translate  <0.960711, -18.902726, -6.468648>
  }
  box { // TunnelClip
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Snow
    }
    scale <1.240608, 2.29373, 1.0>
    translate  <0.962433, -16.874733, -7.521233>
  }
  translate  <-0.262012, -0.281246, -1.068733>
}
union { // Igloo
  object { Dome }
  object { IglooTunnel }
  scale 0.6
  translate  <-0.698699, -3.429867, -1.799972>
}




union { // SnowMan
  sphere { // SnowmanHead
    <0,0,0>,1
    texture {
      Snow
    }
    translate  <-6.818168, -10.752862, -2.383241>
  }
  sphere { // Eye1
    <0,0,0>,1
    texture {
      Coal
    }
    scale 0.1
    translate  <-6.684365, -11.691473, -1.968857>
  }
  sphere { // Eye2
    <0,0,0>,1
    texture {
      Coal
    }
    scale 0.1
    translate  <-6.027984, -11.349758, -1.925406>
  }
  cone { // SnowNose
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      Carrot
    }
    scale <-0.174417, -0.10645, -1.134766>
    rotate <-100.077705, 0.961767, -155.295029>
    translate  <-5.922819, -12.465677, -2.35277>
  }
  sphere { // Bitty1
    <0,0,0>,1
    texture {
      Coal
    }
    scale 0.09
    translate  <-6.998754, -11.716298, -2.69253>
  }
  sphere { // Bitty2
    <0,0,0>,1
    texture {
      Coal
    }
    scale 0.09
    translate  <-6.835451, -11.68105, -2.894476>
  }
  sphere { // Bitty3
    <0,0,0>,1
    texture {
      Coal
    }
    scale 0.09
    translate  <-6.639647, -11.552848, -3.024831>
  }
  sphere { // Bitty4
    <0,0,0>,1
    texture {
      Coal
    }
    scale 0.09
    translate  <-6.162668, -11.36122, -2.983866>
  }
  sphere { // Bitty5
    <0,0,0>,1
    texture {
      Coal
    }
    scale 0.09
    translate  <-5.898936, -11.158762, -2.822885>
  }
  sphere { // SnowMid
    <0,0,0>,1
    texture {
      Snow
    }
    scale <1.2, 1.2, 1.1556>
    translate  <-6.821926, -10.749439, -4.329863>
  }
  sphere { // SnowButt
    <0,0,0>,1
    texture {
      Snow
    }
    scale 1.5
    translate  <-6.791688, -10.638465, -6.053414>
  }
}

box { // Backdrop
  <-1, -1, -1>, <1, 1, 1>
  texture {
    BkGrnd
    translate <-.5,-.5,0>
    scale <2,2,1>
    rotate <90,0,0>
  }
  scale <37.953873, -0.25044, 21.577082>
  rotate 21.724716*z
  translate  <-6.648405, 28.7848, 0.0>
}


#declare Canvas1 = difference {
  torus { // CTorus1
    1.5, 0.5  rotate -x*90
    texture {
      Canvas
    }
    scale <1.161415, 2.447632, 5.589029>
    rotate -90.0*y
    translate  <10.0, 4.76797, 21.599601>
  }
  box { // Clip1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Canvas
    }
    scale <2.860417, 1.553516, 2.549586>
    translate  <9.977883, 8.430045, 21.468223>
  }
  box { // Clip2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Canvas
    }
    scale <2.860417, 1.456667, 4.906248>
    rotate <-90.0, 0.0, 0.0>
    translate  <9.977883, 4.426948, 22.533563>
  }
  box { // Clip3
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Canvas
    }
    scale <2.860417, 1.553516, 2.549586>
    translate  <9.977883, 1.069511, 21.403657>
  }
}
#declare Canvas2 = difference {
  torus { // CTorus2
    1.5, 0.5  rotate -x*90
    texture {
      Canvas
    }
    scale <1.161415, 2.447632, 5.589029>
    rotate -90.0*y
    translate  <10.0, 4.76797, 21.599601>
  }
  box { // Clip4
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Canvas
    }
    scale <2.860417, 1.553516, 2.549586>
    translate  <9.977883, 8.430045, 21.468223>
  }
  box { // Clip5
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Canvas
    }
    scale <2.860417, 1.456667, 4.906248>
    rotate <-90.0, 0.0, 0.0>
    translate  <9.977883, 4.426948, 22.533563>
  }
  box { // Clip6
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Canvas
    }
    scale <2.860417, 1.553516, 2.549586>
    translate  <9.977883, 1.069511, 21.403657>
  }
  translate  <0.0, -4.487343, -0.064566>
}
#declare HalfHoop1 = difference {
  cylinder { // Hoop1
    <0,0,1>, <0,0,0>, 1 
    texture {
      Rusty_Iron1
    }
    scale <2.956118, 1.888645, 0.25751>
    rotate -90.0*x
    translate  <0.051959, -11.595184, -1.257487>
  }
  box { // HoopClip1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Canvas
    }
    scale <4.090296, 1.0, 0.965663>
    translate  <0.592643, -11.222205, -2.919246>
  }
  rotate <0.0, 0.0, 0.0>
  translate  <9.666377, 13.889599, 20.577664>
}
#declare HalfHoop2 = difference {
  cylinder { // Hoop2
    <0,0,1>, <0,0,0>, 1 
    texture {
      Rusty_Iron1
    }
    scale <2.956118, 1.888645, 0.25751>
    rotate -90.0*x
    translate  <0.06423, -11.463979, -1.183863>
  }
  box { // HoopClip2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Canvas
    }
    scale <4.090296, 1.0, 0.965663>
    translate  <0.592643, -11.222205, -2.851338>
  }
  rotate <0.0, 0.0, 0.0>
  translate  <9.623588, 9.414644, 20.478048>
}
#declare HalfHoop3 = difference {
  cylinder { // Hoop3
    <0,0,1>, <0,0,0>, 1 
    texture {
      Rusty_Iron1
    }
    scale <2.956118, 1.888645, 0.25751>
    rotate -90.0*x
    translate  <0.076501, -11.463979, -1.220675>
  }
  box { // HoopClip3
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Canvas
    }
    scale <4.090296, 1.0, 0.965663>
    translate  <0.592643, -11.222205, -2.873974>
  }
  rotate <0.0, 0.0, 0.0>
  translate  <9.617853, 18.176794, 20.54637>
}
#declare WagonCanvas = union {
  object { Canvas1 }
  object { Canvas2 }
  object { HalfHoop1 }
  object { HalfHoop2 }
  object { HalfHoop3 }
  box { // SideCanvas
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Canvas
    }
    scale <2.660794, 4.379686, 0.646287>
    rotate <0.0, 0.0, 0.0>
    translate  <9.932838, 2.4868, 19.145009>
  }
  box { // TinyCanvas1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Canvas
    }
    scale 0.1
    rotate <0.0, -12.052985, 0.0>
    translate  <7.331468, 6.631995, 19.709386>
  }
  box { // TinyCanvas2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Canvas
    }
    scale 0.1
    rotate <0.0, -12.052985, 0.0>
    translate  <7.325331, 2.430218, 19.732022>
  }
}
#declare WheelRim = difference {
  cylinder { // OutWheel1
    <0,0,1>, <0,0,0>, 1 
    texture {
      Tom_Wood1
    }
    scale <1.5, 1.5, 0.35>
    rotate <-90.0, 0.0, -90.0>
    translate  <-2.448901, -9.135056, -2.499225>
  }
  cylinder { // InWheel1
    <0,0,1>, <0,0,0>, 1 
    texture {
      Tom_Wood1
    }
    scale <1.2, 1.2, 0.4>
    rotate <-90.0, 0.0, -90.0>
    translate  <-2.484624, -9.135056, -2.499225>
  }
  translate  -0.577755*x
}
#declare Wheel1 = union {
  object { WheelRim }
  cylinder { // Spoke1
    <0,0,1>, <0,0,0>, 1 
    texture {
      Tom_Wood1
    }
    scale <0.1, 0.1, 1.0>
    translate  <-2.839989, -9.134079, -2.226753>
  }
  cylinder { // Spoke2
    <0,0,1>, <0,0,0>, 1 
    texture {
      Tom_Wood1
    }
    scale <0.1, 0.1, 1.0>
    rotate <-45.0, 0.0, 0.0>
    translate  <-2.839989, -8.917345, -2.298997>
  }
  cylinder { // Spoke3
    <0,0,1>, <0,0,0>, 1 
    texture {
      Tom_Wood1
    }
    scale <0.1, 0.1, 1.0>
    rotate -90.0*x
    translate  <-2.839989, -8.830651, -2.515731>
  }
  cylinder { // Spoke4
    <0,0,1>, <0,0,0>, 1 
    texture {
      Tom_Wood1
    }
    scale <0.1, 0.1, 1.0>
    translate  <-2.839989, -9.134079, -3.787237>
  }
  cylinder { // Spoke5
    <0,0,1>, <0,0,0>, 1 
    texture {
      Tom_Wood1
    }
    scale <0.1, 0.1, 1.0>
    rotate -135.0*x
    translate  <-2.839989, -8.946243, -2.718016>
  }
  cylinder { // Spoke6
    <0,0,1>, <0,0,0>, 1 
    texture {
      Tom_Wood1
    }
    scale <0.1, 0.1, 1.0>
    rotate 45.0*x
    translate  <-2.839989, -9.350813, -2.298997>
  }
  cylinder { // Spoke7
    <0,0,1>, <0,0,0>, 1 
    texture {
      Tom_Wood1
    }
    scale <0.1, 0.1, 1.0>
    rotate 90.0*x
    translate  <-2.839989, -9.350813, -2.515731>
  }
  cylinder { // Spoke8
    <0,0,1>, <0,0,0>, 1 
    texture {
      Tom_Wood1
    }
    scale <0.1, 0.1, 1.0>
    rotate 135.0*x
    translate  <-2.839989, -9.293017, -2.67467>
  }
}
#declare WheelRim1 = difference {
  cylinder { // OutWheel2
    <0,0,1>, <0,0,0>, 1 
    texture {
      Tom_Wood1
    }
    scale <1.5, 1.5, 0.35>
    rotate <-90.0, 0.0, -90.0>
    translate  <-2.448901, -9.135056, -2.499225>
  }
  cylinder { // InWheel2
    <0,0,1>, <0,0,0>, 1 
    texture {
      Tom_Wood1
    }
    scale <1.2, 1.2, 0.4>
    rotate <-90.0, 0.0, -90.0>
    translate  <-2.466762, -9.135056, -2.499225>
  }
  translate  -0.577755*x
}
#declare Wheel2 = union {
  object { WheelRim1 }
  cylinder { // Spoke9
    <0,0,1>, <0,0,0>, 1 
    texture {
      Tom_Wood1
    }
    scale <0.1, 0.1, 1.0>
    translate  <-2.839989, -9.134079, -2.226753>
  }
  cylinder { // Spoke10
    <0,0,1>, <0,0,0>, 1 
    texture {
      Tom_Wood1
    }
    scale <0.1, 0.1, 1.0>
    rotate <-45.0, 0.0, 0.0>
    translate  <-2.839989, -8.917345, -2.298997>
  }
  cylinder { // Spoke11
    <0,0,1>, <0,0,0>, 1 
    texture {
      Tom_Wood1
    }
    scale <0.1, 0.1, 1.0>
    rotate -90.0*x
    translate  <-2.839989, -8.830651, -2.515731>
  }
  cylinder { // Spoke12
    <0,0,1>, <0,0,0>, 1 
    texture {
      Tom_Wood1
    }
    scale <0.1, 0.1, 1.0>
    translate  <-2.839989, -9.134079, -3.787237>
  }
  cylinder { // Spoke13
    <0,0,1>, <0,0,0>, 1 
    texture {
      Tom_Wood1
    }
    scale <0.1, 0.1, 1.0>
    rotate -135.0*x
    translate  <-2.839989, -8.946243, -2.718016>
  }
  cylinder { // Spoke14
    <0,0,1>, <0,0,0>, 1 
    texture {
      Tom_Wood1
    }
    scale <0.1, 0.1, 1.0>
    rotate 45.0*x
    translate  <-2.839989, -9.350813, -2.298997>
  }
  cylinder { // Spoke15
    <0,0,1>, <0,0,0>, 1 
    texture {
      Tom_Wood1
    }
    scale <0.1, 0.1, 1.0>
    rotate 90.0*x
    translate  <-2.839989, -9.350813, -2.515731>
  }
  cylinder { // Spoke16
    <0,0,1>, <0,0,0>, 1 
    texture {
      Tom_Wood1
    }
    scale <0.1, 0.1, 1.0>
    rotate 135.0*x
    translate  <-2.839989, -9.293017, -2.67467>
  }
  translate  6.439182*x
}
#declare FrontWheels = union {
  cylinder { // Axle1
    <0,0,1>, <0,0,0>, 1 
    texture {
      Tom_Wood1
    }
    scale <0.35, 0.35, 7.0>
    rotate <-90.0, 0.0, -90.0>
    translate  <-3.12764, -9.135056, -2.499225>
  }
  object { Wheel1 }
  object { Wheel2 }
  translate  <9.624449, 14.446942, 19.562137>
}
#declare WheelRim2 = difference {
  cylinder { // OutWheel3
    <0,0,1>, <0,0,0>, 1 
    texture {
      Tom_Wood1
    }
    scale <1.5, 1.5, 0.35>
    rotate <-90.0, 0.0, -90.0>
    translate  <-2.448901, -9.135056, -2.499225>
  }
  cylinder { // InWheel3
    <0,0,1>, <0,0,0>, 1 
    texture {
      Tom_Wood1
    }
    scale <1.2, 1.2, 0.4>
    rotate <-90.0, 0.0, -90.0>
    translate  <-2.466762, -9.135056, -2.499225>
  }
  translate  -0.577755*x
}
#declare Wheel3 = union {
  object { WheelRim2 }
  cylinder { // Spoke17
    <0,0,1>, <0,0,0>, 1 
    texture {
      Tom_Wood1
    }
    scale <0.1, 0.1, 1.0>
    translate  <-2.839989, -9.134079, -2.226753>
  }
  cylinder { // Spoke18
    <0,0,1>, <0,0,0>, 1 
    texture {
      Tom_Wood1
    }
    scale <0.1, 0.1, 1.0>
    rotate <-45.0, 0.0, 0.0>
    translate  <-2.839989, -8.917345, -2.298997>
  }
  cylinder { // Spoke19
    <0,0,1>, <0,0,0>, 1 
    texture {
      Tom_Wood1
    }
    scale <0.1, 0.1, 1.0>
    rotate -90.0*x
    translate  <-2.839989, -8.830651, -2.515731>
  }
  cylinder { // Spoke20
    <0,0,1>, <0,0,0>, 1 
    texture {
      Tom_Wood1
    }
    scale <0.1, 0.1, 1.0>
    translate  <-2.839989, -9.134079, -3.787237>
  }
  cylinder { // Spoke21
    <0,0,1>, <0,0,0>, 1 
    texture {
      Tom_Wood1
    }
    scale <0.1, 0.1, 1.0>
    rotate -135.0*x
    translate  <-2.839989, -8.946243, -2.718016>
  }
  cylinder { // Spoke22
    <0,0,1>, <0,0,0>, 1 
    texture {
      Tom_Wood1
    }
    scale <0.1, 0.1, 1.0>
    rotate 45.0*x
    translate  <-2.839989, -9.350813, -2.298997>
  }
  cylinder { // Spoke23
    <0,0,1>, <0,0,0>, 1 
    texture {
      Tom_Wood1
    }
    scale <0.1, 0.1, 1.0>
    rotate 90.0*x
    translate  <-2.839989, -9.350813, -2.515731>
  }
  cylinder { // Spoke24
    <0,0,1>, <0,0,0>, 1 
    texture {
      Tom_Wood1
    }
    scale <0.1, 0.1, 1.0>
    rotate 135.0*x
    translate  <-2.839989, -9.293017, -2.67467>
  }
}
#declare WheelRim3 = difference {
  cylinder { // OutWheel4
    <0,0,1>, <0,0,0>, 1 
    texture {
      Tom_Wood1
    }
    scale <1.5, 1.5, 0.35>
    rotate <-90.0, 0.0, -90.0>
    translate  <-2.448901, -9.135056, -2.499225>
  }
  cylinder { // InWheel4
    <0,0,1>, <0,0,0>, 1 
    texture {
      Tom_Wood1
    }
    scale <1.2, 1.2, 0.4>
    rotate <-90.0, 0.0, -90.0>
    translate  <-2.466762, -9.135056, -2.499225>
  }
  translate  -0.577755*x
}
#declare Wheel4 = union {
  object { WheelRim3 }
  cylinder { // Spoke25
    <0,0,1>, <0,0,0>, 1 
    texture {
      Tom_Wood1
    }
    scale <0.1, 0.1, 1.0>
    translate  <-2.839989, -9.134079, -2.226753>
  }
  cylinder { // Spoke26
    <0,0,1>, <0,0,0>, 1 
    texture {
      Tom_Wood1
    }
    scale <0.1, 0.1, 1.0>
    rotate <-45.0, 0.0, 0.0>
    translate  <-2.839989, -8.917345, -2.298997>
  }
  cylinder { // Spoke27
    <0,0,1>, <0,0,0>, 1 
    texture {
      Tom_Wood1
    }
    scale <0.1, 0.1, 1.0>
    rotate -90.0*x
    translate  <-2.839989, -8.830651, -2.515731>
  }
  cylinder { // Spoke28
    <0,0,1>, <0,0,0>, 1 
    texture {
      Tom_Wood1
    }
    scale <0.1, 0.1, 1.0>
    translate  <-2.839989, -9.134079, -3.787237>
  }
  cylinder { // Spoke29
    <0,0,1>, <0,0,0>, 1 
    texture {
      Tom_Wood1
    }
    scale <0.1, 0.1, 1.0>
    rotate -135.0*x
    translate  <-2.839989, -8.946243, -2.718016>
  }
  cylinder { // Spoke30
    <0,0,1>, <0,0,0>, 1 
    texture {
      Tom_Wood1
    }
    scale <0.1, 0.1, 1.0>
    rotate 45.0*x
    translate  <-2.839989, -9.350813, -2.298997>
  }
  cylinder { // Spoke31
    <0,0,1>, <0,0,0>, 1 
    texture {
      Tom_Wood1
    }
    scale <0.1, 0.1, 1.0>
    rotate 90.0*x
    translate  <-2.839989, -9.350813, -2.515731>
  }
  cylinder { // Spoke32
    <0,0,1>, <0,0,0>, 1 
    texture {
      Tom_Wood1
    }
    scale <0.1, 0.1, 1.0>
    rotate 135.0*x
    translate  <-2.839989, -9.293017, -2.67467>
  }
  translate  6.439182*x
}
#declare BackWheels = union {
  cylinder { // Axle2
    <0,0,1>, <0,0,0>, 1 
    texture {
      Tom_Wood1
    }
    scale <0.35, 0.35, 7.0>
    rotate <-90.0, 0.0, -90.0>
    translate  <-3.12764, -9.135056, -2.499225>
  }
  object { Wheel3 }
  object { Wheel4 }
  translate  <9.624449, 8.546942, 19.562137>
}
#declare Wagon = union {
  box { // WagonBox
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Tom_Wood1
    }
    scale <2.96676, 4.493377, 0.519287>
    translate  <9.98484, 2.456472, 18.093777>
  }
  object { WagonCanvas }
  object { FrontWheels }
  object { BackWheels }
  translate  <-9.624449, -14.646942, -19.562137>
}
#declare Flame1 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.000000, 0.111961, 1.035639>, <-1.000000, -0.438039, 1.035639>, <-0.550000, -0.888039, 1.035639>, <0.000000, -0.888039, 1.035639>, 
      <-1.503950, -0.110586, 1.531401>, <-1.499373, -0.883133, 1.535639>, <-0.502550, -1.865111, 1.535639>, <0.247682, -1.866744, 1.535639>, 
      <-0.424152, -0.104515, 2.001737>, <-0.424635, -0.416327, 2.035639>, <0.340187, -0.247538, 2.035639>, <0.402838, -0.094043, 2.016154>, 
      <-0.023385, 0.078510, 6.363255>, <0.020849, 0.066635, 3.562832>, <-0.018264, 0.121861, 9.055499>, <-0.009415, 0.163821, 8.580336>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.888039, 1.035639>, <0.550000, -0.888039, 1.035639>, <1.000000, -0.438039, 1.035639>, <1.000000, 0.111961, 1.035639>, 
      <0.247682, -1.866744, 1.535639>, <0.997913, -1.868378, 1.535639>, <1.658199, -0.885952, 1.535639>, <1.664392, -0.139136, 1.535639>, 
      <0.402838, -0.094043, 2.016154>, <0.465488, 0.059452, 1.996668>, <0.153668, -0.099991, 1.967836>, <0.185681, 0.042154, 1.955122>, 
      <-0.009415, 0.163821, 8.580336>, <-0.000565, 0.205782, 8.105173>, <0.009197, 0.109110, 8.186639>, <0.009739, 0.104823, 8.658241>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.000000, 0.111961, 1.035639>, <1.000000, 0.661961, 1.035639>, <0.256890, 0.536596, 1.035639>, <-0.146555, 0.824279, 1.035639>, 
      <1.664392, -0.139136, 1.535639>, <1.670585, 0.607681, 1.535639>, <1.005950, 1.633046, 1.535639>, <0.251780, 1.607065, 1.896717>, 
      <0.185681, 0.042154, 1.955122>, <0.217694, 0.184300, 1.942409>, <0.322025, 0.040827, 2.009658>, <-0.012282, 0.576394, 1.997222>, 
      <0.009739, 0.104823, 8.658241>, <0.010281, 0.100537, 9.129842>, <-0.075952, 0.107729, 9.188125>, <-0.037524, 0.083734, 5.896338>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.146555, 0.824279, 1.035639>, <-0.550000, 1.111961, 1.035639>, <-1.000000, 0.661961, 1.035639>, <-1.000000, 0.111961, 1.035639>, 
      <0.251780, 1.607065, 1.896717>, <-0.502390, 1.581085, 2.257795>, <-1.508527, 0.661961, 1.527164>, <-1.503950, -0.110586, 1.531401>, 
      <-0.012282, 0.576394, 1.997222>, <-0.346589, 1.111961, 1.984786>, <-0.423669, 0.207297, 1.967836>, <-0.424152, -0.104515, 2.001737>, 
      <-0.037524, 0.083734, 5.896338>, <0.000904, 0.059739, 2.604552>, <-0.067618, 0.090384, 9.163677>, <-0.023385, 0.078510, 6.363255>
    }
  }
  texture {
    Glow
    scale 9
  }
  scale 0.5
  rotate <-180.0, 89.509018, 90.0>
  translate  <0.0, -2.009855, 0.977494>
}
#declare Flame2 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.000000, 0.111961, 1.035639>, <-1.000000, -0.438039, 1.035639>, <-0.550000, -0.888039, 1.035639>, <0.000000, -0.888039, 1.035639>, 
      <-1.503950, -0.110586, 1.531401>, <-1.499373, -0.883133, 1.535639>, <-0.502550, -1.865111, 1.535639>, <0.247682, -1.866744, 1.535639>, 
      <-0.424152, -0.104515, 2.001737>, <-0.424635, -0.416327, 2.035639>, <0.340187, -0.247538, 2.035639>, <0.402838, -0.094043, 2.016154>, 
      <-0.023385, 0.078510, 6.363255>, <0.020849, 0.066635, 3.562832>, <-0.018264, 0.121861, 9.055499>, <-0.009415, 0.163821, 8.580336>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.888039, 1.035639>, <0.550000, -0.888039, 1.035639>, <1.000000, -0.438039, 1.035639>, <1.000000, 0.111961, 1.035639>, 
      <0.247682, -1.866744, 1.535639>, <0.997913, -1.868378, 1.535639>, <1.658199, -0.885952, 1.535639>, <1.664392, -0.139136, 1.535639>, 
      <0.402838, -0.094043, 2.016154>, <0.465488, 0.059452, 1.996668>, <0.153668, -0.099991, 1.967836>, <0.185681, 0.042154, 1.955122>, 
      <-0.009415, 0.163821, 8.580336>, <-0.000565, 0.205782, 8.105173>, <0.009197, 0.109110, 8.186639>, <0.009739, 0.104823, 8.658241>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.000000, 0.111961, 1.035639>, <1.000000, 0.661961, 1.035639>, <0.256890, 0.536596, 1.035639>, <-0.146555, 0.824279, 1.035639>, 
      <1.664392, -0.139136, 1.535639>, <1.670585, 0.607681, 1.535639>, <1.005950, 1.633046, 1.535639>, <0.251780, 1.607065, 1.896717>, 
      <0.185681, 0.042154, 1.955122>, <0.217694, 0.184300, 1.942409>, <0.322025, 0.040827, 2.009658>, <-0.012282, 0.576394, 1.997222>, 
      <0.009739, 0.104823, 8.658241>, <0.010281, 0.100537, 9.129842>, <-0.075952, 0.107729, 9.188125>, <-0.037524, 0.083734, 5.896338>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.146555, 0.824279, 1.035639>, <-0.550000, 1.111961, 1.035639>, <-1.000000, 0.661961, 1.035639>, <-1.000000, 0.111961, 1.035639>, 
      <0.251780, 1.607065, 1.896717>, <-0.502390, 1.581085, 2.257795>, <-1.508527, 0.661961, 1.527164>, <-1.503950, -0.110586, 1.531401>, 
      <-0.012282, 0.576394, 1.997222>, <-0.346589, 1.111961, 1.984786>, <-0.423669, 0.207297, 1.967836>, <-0.424152, -0.104515, 2.001737>, 
      <-0.037524, 0.083734, 5.896338>, <0.000904, 0.059739, 2.604552>, <-0.067618, 0.090384, 9.163677>, <-0.023385, 0.078510, 6.363255>
    }
  }
  texture {
    Glow
    scale 9
  }
  scale 0.5
  rotate <-180.0, 89.509018, 90.0>
  translate  <1.000424, -2.009855, 0.032649>
}
#declare Flame3 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.000000, 0.111961, 1.035639>, <-1.000000, -0.438039, 1.035639>, <-0.550000, -0.888039, 1.035639>, <0.000000, -0.888039, 1.035639>, 
      <-1.503950, -0.110586, 1.531401>, <-1.499373, -0.883133, 1.535639>, <-0.502550, -1.865111, 1.535639>, <0.247682, -1.866744, 1.535639>, 
      <-0.424152, -0.104515, 2.001737>, <-0.424635, -0.416327, 2.035639>, <0.340187, -0.247538, 2.035639>, <0.402838, -0.094043, 2.016154>, 
      <-0.023385, 0.078510, 6.363255>, <0.020849, 0.066635, 3.562832>, <-0.018264, 0.121861, 9.055499>, <-0.009415, 0.163821, 8.580336>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.888039, 1.035639>, <0.550000, -0.888039, 1.035639>, <1.000000, -0.438039, 1.035639>, <1.000000, 0.111961, 1.035639>, 
      <0.247682, -1.866744, 1.535639>, <0.997913, -1.868378, 1.535639>, <1.658199, -0.885952, 1.535639>, <1.664392, -0.139136, 1.535639>, 
      <0.402838, -0.094043, 2.016154>, <0.465488, 0.059452, 1.996668>, <0.153668, -0.099991, 1.967836>, <0.185681, 0.042154, 1.955122>, 
      <-0.009415, 0.163821, 8.580336>, <-0.000565, 0.205782, 8.105173>, <0.009197, 0.109110, 8.186639>, <0.009739, 0.104823, 8.658241>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.000000, 0.111961, 1.035639>, <1.000000, 0.661961, 1.035639>, <0.256890, 0.536596, 1.035639>, <-0.146555, 0.824279, 1.035639>, 
      <1.664392, -0.139136, 1.535639>, <1.670585, 0.607681, 1.535639>, <1.005950, 1.633046, 1.535639>, <0.251780, 1.607065, 1.896717>, 
      <0.185681, 0.042154, 1.955122>, <0.217694, 0.184300, 1.942409>, <0.322025, 0.040827, 2.009658>, <-0.012282, 0.576394, 1.997222>, 
      <0.009739, 0.104823, 8.658241>, <0.010281, 0.100537, 9.129842>, <-0.075952, 0.107729, 9.188125>, <-0.037524, 0.083734, 5.896338>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.146555, 0.824279, 1.035639>, <-0.550000, 1.111961, 1.035639>, <-1.000000, 0.661961, 1.035639>, <-1.000000, 0.111961, 1.035639>, 
      <0.251780, 1.607065, 1.896717>, <-0.502390, 1.581085, 2.257795>, <-1.508527, 0.661961, 1.527164>, <-1.503950, -0.110586, 1.531401>, 
      <-0.012282, 0.576394, 1.997222>, <-0.346589, 1.111961, 1.984786>, <-0.423669, 0.207297, 1.967836>, <-0.424152, -0.104515, 2.001737>, 
      <-0.037524, 0.083734, 5.896338>, <0.000904, 0.059739, 2.604552>, <-0.067618, 0.090384, 9.163677>, <-0.023385, 0.078510, 6.363255>
    }
  }
  texture {
    Glow
    scale 9
  }
  scale 0.5
  rotate <-180.0, 89.509018, 90.0>
  translate  <-0.981898, -2.009855, -0.004404>
}
#declare Flame4 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.000000, 0.111961, 1.035639>, <-1.000000, -0.438039, 1.035639>, <-0.550000, -0.888039, 1.035639>, <0.000000, -0.888039, 1.035639>, 
      <-1.503950, -0.110586, 1.531401>, <-1.499373, -0.883133, 1.535639>, <-0.502550, -1.865111, 1.535639>, <0.247682, -1.866744, 1.535639>, 
      <-0.424152, -0.104515, 2.001737>, <-0.424635, -0.416327, 2.035639>, <0.340187, -0.247538, 2.035639>, <0.402838, -0.094043, 2.016154>, 
      <-0.023385, 0.078510, 6.363255>, <0.020849, 0.066635, 3.562832>, <-0.018264, 0.121861, 9.055499>, <-0.009415, 0.163821, 8.580336>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.888039, 1.035639>, <0.550000, -0.888039, 1.035639>, <1.000000, -0.438039, 1.035639>, <1.000000, 0.111961, 1.035639>, 
      <0.247682, -1.866744, 1.535639>, <0.997913, -1.868378, 1.535639>, <1.658199, -0.885952, 1.535639>, <1.664392, -0.139136, 1.535639>, 
      <0.402838, -0.094043, 2.016154>, <0.465488, 0.059452, 1.996668>, <0.153668, -0.099991, 1.967836>, <0.185681, 0.042154, 1.955122>, 
      <-0.009415, 0.163821, 8.580336>, <-0.000565, 0.205782, 8.105173>, <0.009197, 0.109110, 8.186639>, <0.009739, 0.104823, 8.658241>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.000000, 0.111961, 1.035639>, <1.000000, 0.661961, 1.035639>, <0.256890, 0.536596, 1.035639>, <-0.146555, 0.824279, 1.035639>, 
      <1.664392, -0.139136, 1.535639>, <1.670585, 0.607681, 1.535639>, <1.005950, 1.633046, 1.535639>, <0.251780, 1.607065, 1.896717>, 
      <0.185681, 0.042154, 1.955122>, <0.217694, 0.184300, 1.942409>, <0.322025, 0.040827, 2.009658>, <-0.012282, 0.576394, 1.997222>, 
      <0.009739, 0.104823, 8.658241>, <0.010281, 0.100537, 9.129842>, <-0.075952, 0.107729, 9.188125>, <-0.037524, 0.083734, 5.896338>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.146555, 0.824279, 1.035639>, <-0.550000, 1.111961, 1.035639>, <-1.000000, 0.661961, 1.035639>, <-1.000000, 0.111961, 1.035639>, 
      <0.251780, 1.607065, 1.896717>, <-0.502390, 1.581085, 2.257795>, <-1.508527, 0.661961, 1.527164>, <-1.503950, -0.110586, 1.531401>, 
      <-0.012282, 0.576394, 1.997222>, <-0.346589, 1.111961, 1.984786>, <-0.423669, 0.207297, 1.967836>, <-0.424152, -0.104515, 2.001737>, 
      <-0.037524, 0.083734, 5.896338>, <0.000904, 0.059739, 2.604552>, <-0.067618, 0.090384, 9.163677>, <-0.023385, 0.078510, 6.363255>
    }
  }
  texture {
    Glow
    scale 9
  }
  scale 0.5
  rotate <-180.0, 89.509018, 90.0>
  translate  <0.018526, -2.009855, -0.986302>
}
#declare Rocket = union {
  cone { // Engine4
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      Checkers
    }
    scale <0.75, 0.75, 4.0>
    rotate 90.0*x
    translate  <-0.003782, 1.369911, -1.004502>
  }
  cone { // Engine3
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      Checkers
    }
    scale <0.75, 0.75, 4.0>
    rotate 90.0*x
    translate  <-1.008767, 1.369911, -0.008572>
  }
  cone { // Engine2
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      Checkers
    }
    scale <0.75, 0.75, 4.0>
    rotate 90.0*x
    translate  <-0.003782, 1.369911, 0.987359>
  }
  cone { // Engine1
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      Checkers
    }
    scale <0.75, 0.75, 4.0>
    rotate 90.0*x
    translate  <1.001202, 1.369911, 0.000482>
  }
  cone { // Nose
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      Checkers
    }
    scale <1.0, 1.0, 4.0>
    rotate 90.0*x
    translate  18.0*y
  }
  cylinder { // Body
    <0,0,1>, <0,0,0>, 1 
    texture {
      Checkers
    }
    scale <1.0, 1.0, 14.0>
    rotate -90.0*x
  }
  cone { // Fin1
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      Checkers
    }
    scale <0.1, 1.0, 4.0>
    rotate 90.0*x
    translate  <0.0, 10.0, 1.0>
  }
  cone { // Fin2
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      Checkers
    }
    scale <0.1, 1.0, 4.0>
    rotate 90.0*x
    translate  <0.0, 10.0, -1.0>
  }
  cone { // Fin3
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      Checkers
    }
    scale <0.1, 1.0, 4.0>
    rotate <90.0, 90.0, 0.0>
    translate  <1.0, 10.0, 0.0>
  }
  cone { // Fin4
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      Checkers
    }
    scale <0.1, 1.0, 4.0>
    rotate <90.0, 90.0, 0.0>
    translate  <-1.0, 10.0, 0.0>
  }
  object { Flame1 }
  object { Flame2 }
  object { Flame3 }
  object { Flame4 }
  translate  -1.514686*z
}
union { // Scene
  cylinder { // Cable
    <0,0,1>, <0,0,0>, 1 
    texture {
      CableText
    }
    scale <0.1, 0.1, 5.5>
    rotate -90.0*x
    translate  <0.020769, -7.831972, -1.584677>
  }
  object { Wagon }
  object { Rocket }
  rotate <24.085556, 0.0, 101.584747>
}
