#version unofficial MegaPov 0.6;
// basic scene construction


#declare Final_Lights		= on;
#declare Building_Test		= off;
#declare Background_Scene	= on;  
#declare Fast_Columns		= off;


#include "colors.inc"

#default{
	texture{
	pigment{White}
	}
}
background {White}

camera {
	location <0,2,-10>
	look_at  <0,2,0>
}  

box {<100,100,-11><-100,-100,-12> pigment {rgb <.6,.6,.5>}}

light_source {<-3000,5000,5000> color White}
 
global_settings { 
radiosity{
    pretrace_start 0.08
    pretrace_end   0.02
    count 80             // CHANGE range from 20 to 150
    nearest_count 5      // CHANGE range from 3 to 10
    error_bound 1        // CHANGE - range from 1 to 3 - should correspond with pretrace_end
                         //   1 : pretrace_end = 0.02
                         //   3 : pretrace_end = 0.08
                         //   use pretrace_start = 0.08
                         // you can go lower than 1, but then you probably will want to set
                         // pretrace_end to 0.01, which is really slow
    recursion_limit 4    // CHANGE
    
    low_error_factor .5  // leave this
    gray_threshold 0.0   // leave this
    minimum_reuse 0.015  // leave this
    brightness 1         // leave this
    
    adc_bailout 0.01/2   // CHANGE - use adc_bailout = 0.01 / brightest_ambient_object
  }
}



// end radiosity stuff
#if (Fast_Columns = on)
	#declare Column1 = cylinder {<0,0,0><0,4,0>,.3}
#else
	#include "column.inc" 
#end


#declare Arch1 = 
union {
	difference {
		box {<-2.5,0,-.5><2.5,5,.5>}
		cylinder {<0,0,-.6><0,0,.6>,1.8} 
		
		cylinder {<0,0,-.4><0,0,.4>,1.85}
		cylinder {<0,0,-.3><0,0,.3>,1.95}
	}
	
	box {<-2.5,0,-.6><-1.7,.1,.5>}
	box {<-2.5,.4,-.6><-1.7,.45,.5>}
	box {<-2.5,.45,-.65><-1.65,.5,.5>} 
	
	box {<2.5,0,-.6><1.7,.1,.5>}
	box {<2.5,.4,-.6><1.7,.45,.5>}
	box {<2.5,.45,-.65><1.65,.5,.5>}
}

#declare Wall_Module1 =
union {

object {Column1 translate <-2,0,0>}
object {Column1 scale <-1,1,1> translate <2,0,0>}
object {Arch1 translate <0,4,0>} 

difference {
	box {<-2.5,0,1><2.5,6.5,.5> normal{quilted 2 scale .2}} 
	box {<1.4,.5,.4><-1.4,3.5,1.1>} 
	cylinder {<0,3.5,.4><0,3.5,1.1>,1.4}
}  

difference {
	union {
		box {<1.5,.51,1><-1.5,3.5,.45>}
		cylinder {<0,3.5,1><0,3.5,.45>,1.5} 
	} 
	box {<1.39,.5,.4><-1.39,3.5,1.1>} 
	cylinder {<0,3.5,.4><0,3.5,1.1>,1.39}
}

box {<-1.5,.51,1><1.5,.4,.4>}

#if (Final_Lights = on)

light_source {
    <0,2.1,0.01>
	color Gray30
	area_light
	<1.3,-1.5,0><-1.3,1.5,0>
	4,4 
	adaptive 1
	jitter 
	fade_distance 12
	fade_power 2
}

#end

}

object {Wall_Module1}
object {Wall_Module1 translate <5,0,0>}
object {Wall_Module1 translate <-5,0,0>}

// WINDOW FLOOR
box {<-10,0,-.8><10,-.2,1>}
box {<-10,-.05,-.85><10,-.15,1>}

// FRONT WALL 
box {<-10,-.2,-.7><10,-10,1>}

// steps
box {<-10,-.5,-.7><10,-5,-1>} 
box {<-10,-.8,-1><10,-5,-1.3>} 
box {<-10,-1.1,-1.3><10,-5,-1.6>}  

box {<-10,-.49,-.75><10,-.6,-1>} 
box {<-10,-.79,-1><10,-.9,-1.35>} 
box {<-10,-1.09,-1.3><10,-1.2,-1.65>}  

// logo
#declare Logo =
text
{
  ttf             // font type (only TrueType format for now)
  "times.ttf",  // Microsoft Windows-format TrueType font file name
  "XIII",      // the string to create
  2,              // the extrusion depth
  0               // inter-character spacing
}


// holy child stand
#include "jesus.inc"

#declare Holy_Stand = 
union {
	box {<-2.6,0,-2.6><2.6,-0.25,2.6>} 
	box {<-2.5,-0.25,-2.5><2.5,-10,2.5> normal{quilted .5 scale .2 turbulence .2}} 
	 
	box {<-2.05,.4,-1.05><2.05,.5,1.05>}
	box {<-2,0,-1><2,.4,1>}   
	
	object {Logo scale .35 translate <1.25,.075,-1.05>}
	
	object {Jesus scale 4 rotate <0,-80,0> translate <1,.5,0>}

}

object {Holy_Stand translate <-5,.25,-2.8>}



// the landscape to the rear

#if (Background_Scene = on)

#declare Land_Form =
height_field
{
  tga              
  "landscape.tga" 
  smooth
  texture {    
  	pigment{
  	gradient y
  	color_map {
  		[0.0 rgb <.7,.7,.7>]
  		[1.0 rgb <1,1,1>]
  	}}
  }
  translate <-.5,0,-.5>
  scale <500,50,100>
  translate <0,-30,200>
}  

object {Land_Form}

#if (Building_Test = on)

#declare Build_x_min = 2;
#declare Build_z_min = 2;
#declare Build_y_min = 5;

#declare Build_x_max = 10;
#declare Build_z_max = 10;
#declare Build_y_max = 15;

#declare Zone_x_min = -250;
#declare Zone_z_min = 175;

#declare Zone_x_max = 250;
#declare Zone_z_max = 300; 

#declare Rand13 = seed(13);

#declare Zone_x_range = (Zone_x_max - Zone_x_min);
#declare Zone_z_range = (Zone_z_max - Zone_z_min); 

#declare Build_x_range = (Build_x_max - Build_x_min);
#declare Build_y_range = (Build_y_max - Build_y_min);
#declare Build_z_range = (Build_z_max - Build_z_min);

#macro Rand_Point () 

	#local Rand_value_x = (Zone_x_min + (rand(Rand13) *  Zone_x_range));
	#local Rand_value_z = (Zone_z_min + (rand(Rand13) *  Zone_z_range));
	
	#local Test_Point_1 = <Rand_value_x,1000,Rand_value_z>;  
	#local Test_Point_2 = <0,-1,0>;
	
	#declare Inter = trace ( Land_Form, Test_Point_1, Test_Point_2); 
	
	#if (Inter.x != 0)
		#if (Inter.y != 0)
			#if (Inter.z != 0) 
	
				Draw_Building (Inter)
			#end
		#end	
	#end
#end 

#macro Draw_Building (Origin)

	#local Rand_value_x = (Build_x_min + (rand(Rand13) *  Build_x_range));
	#local Rand_value_y = (Build_y_min + (rand(Rand13) *  Build_y_range));
	#local Rand_value_z = (Build_z_min + (rand(Rand13) *  Build_z_range)); 
	
	#local Draw_Point_1 = <(Origin.x - (Rand_value_x / 2)),(Origin.y - 15),(Origin.z - (Rand_value_z / 2))>; 
	#local Draw_Point_2 = <(Origin.x + (Rand_value_x / 2)),(Origin.y + Rand_value_y),(Origin.z + (Rand_value_z / 2))>;
	
	#write (Bfile, "\nbox {",Draw_Point_1,Draw_Point_2,"pigment{Gray40}}") 

#end

#local Building_Qty = 400;
#local Count1 = 0;

#fopen Bfile "bfile.inc" write
#while (Count1 < Building_Qty)
   
	Rand_Point ()   
	#local Count1 = (Count1 + 1); 
	
#end  
#fclose Bfile

#end

fog {
	fog_type 1 
	distance 200
	color White
} 

#include "bfile.inc" 
#end



// the characters

#include "woman1.inc"  
object {Woman1 scale 7 rotate <0,60,0> translate <-1,-1.5,-1>} 

#include "arab2.inc"  
object {Arab2 scale 7 rotate <0,70,0> translate <0.5,-2.5,-2>}


#include "arab1.inc"
object {Arab1 scale 7 rotate <0,75,0> translate <-2,-2.75,-3>}

#include "death.pov"
object {Death scale <-7,7,7> rotate <0,90,0> translate <2.5,0.3,.5>}


#include "woman2.inc"  
object {Woman2 scale 7 rotate <0,-15,0> translate <2.5,-2.75,-2>} 

