// detailed column

#macro CBase (Origin,Size)

box {((<-0.225,0,-0.225> * Size)+ Origin)((<0.225,0.075,0.225> * Size) + Origin)}
cylinder {((<0,0.075,0> * Size) + Origin)((<0,0.125,0> * Size) + Origin),(0.2  * Size)}
torus {(0.2 * Size),(0.025 * Size) sturm translate ((<0,0.1,0> * Size) + Origin)}
difference {
    cylinder {((<0,0.125,0> * Size) + Origin)((<0,0.175,0> * Size) + Origin),(0.175 * Size)}
    torus {(0.175 * Size),(0.025 * Size) sturm translate ((<0,0.175,0>  * Size) + Origin)}
}
	
#end


#declare C_Cut =
torus {.3,.025 
	sturm 
	scale <1,1.5,1>
	matrix < 1.0, 0.25, 0.0,
             0.0, 1.0, 0.0,
             0.0, 0.0, 1.0,
             0.0, 0.0, 0.0 >
}  

#local Count1 = 0;
#local Qty = 30;
#local Dist = (4 / Qty);

#declare Column1 =
union {

difference {
	cylinder {<0,.35,0><0,3.65,0>,.3}   
	#while (Count1 < Qty)
		object {C_Cut translate <0,(Count1 * Dist),0>} 
		#local Count1 = (Count1 + 1);
	#end
}

#declare CBase2 =
union {
	CBase (<0,0,0>,2)
}

object {CBase2}
object {CBase2 scale <1,-1,1> translate <0,4,0>}

}