//**************************************************************************************************
//*                                                                                                *
//* Persistence of Vision Ray Tracer Scene Description File Vers: 3.1                              *
//* version unofficial MegaPov 0.6                                                                 *
//* File: Ange                                                                                     *
//* Desc: Angels are Women                                                                       *
//*                                                                                                *
//* Date: Janvier - Fevrier 2001                                                                   *
//* Auth: Eric Ouvrard / eric.ouvrard@wanadoo.fr                                                   *
//*                                                                                                *
//**************************************************************************************************

#version unofficial MegaPov 0.7;

//**************************************************************************************************
//*			CAMERA									   *
//**************************************************************************************************

camera
        {
        location <0.0,0.36,-1.0>
        look_at <0.0,0.36,10.0>
        }

//**************************************************************************************************
//*			LUMIERES								   *
//**************************************************************************************************

light_source
        { < 0.01,0.525,-0.6> rgb <0.94,0.94,1.00> shadowless}
        
light_source
        { <0,0.5, 0.0 > rgb<0.0,0.4,0.8> shadowless}

light_source
        {
          <0, 0, -2 >  
          color rgb <0.8,0.4,0.0>       
          spotlight               
          point_at <0.0,0.5,0.0>     
          radius 2                
          tightness 100            
          falloff 8
          jitter              
        }

//**************************************************************************************************
//*			Textures 								   *
//**************************************************************************************************

#declare Ange_Texture = texture
        {
        pigment
                {
                image_map
                        {
                        tga "Angetex.tga"
                        }
                }
        finish
                {
                ambient 0.4
                diffuse 0.6
                phong 0.06
                phong_size 40
                }
        } 

#declare Ange_Texture_OBJuvPOVskin = texture {Ange_Texture}
#declare Ange_Texture_OBJuvPOVnipple = texture {Ange_Texture}
#declare Ange_Texture_OBJuvPOVlips = texture {Ange_Texture finish {reflection 0.1 phong 0.3 phong_size 20}}
#declare Ange_Texture_OBJuvPOVeyeBrow = texture {Ange_Texture finish {reflection 0.1 phong 0.8 phong_size 50}}
#declare Ange_Texture_OBJuvPOVinnerMouth = texture {Ange_Texture}
#declare Ange_Texture_OBJuvPOVtongue = texture {Ange_Texture}
#declare Ange_Texture_OBJuvPOVteeth = texture {Ange_Texture}
#declare Ange_Texture_OBJuvPOVlashes = texture {Ange_Texture}
#declare Ange_Texture_OBJuvPOVpupil = texture {Ange_Texture finish {reflection 0.1 phong 0.8 phong_size 50}}
#declare Ange_Texture_OBJuvPOViris = texture {Ange_Texture finish {ambient 0.3 diffuse 0.6 reflection 0.3 phong 0.8 phong_size 50}}
#declare Ange_Texture_OBJuvPOVeyeball = texture {Ange_Texture}
#declare Ange_Texture_OBJuvPOVfingerNails = texture {Ange_Texture}
#declare Ange_Texture_OBJuvPOVtoenail = texture {Ange_Texture}

//**************************************************************************************************

#declare Cheveux_Texture = texture
        {
        pigment
                {
                image_map
                        {
                        png "Cheveux.png"
                        }
                }
        finish
                {
                ambient 0.3
                diffuse 0.6
                phong 0.1
                phong_size 120
                }
        }
        
#declare Cheveux_Texture_Cheveuxdefault = texture {Cheveux_Texture}
#declare Cheveux_Texture_Cheveuxhair = texture {Cheveux_Texture}

//**************************************************************************************************  

#declare Ailestex1 = texture
        {
        pigment
                {
                image_map
                        {
                        png "Ailestex.png"
                        }
                }
        normal
                {
                bump_map
                       {
                        tga "Bump_Ailes.tga"
                        }
                bump_size 1.0
                }
        finish
                {
                ambient 0.4
                diffuse 0.6
                phong 0.1
                phong_size 120
                }
        }

#declare Ailestex2 = texture {Ailestex1} 

//**************************************************************************************************

#declare Angelo_texture = texture
        {
        pigment
                {
                image_map
                        {
                        tga "Angelo.tga"
                        }
                }
        finish
                {
                ambient 0.3
                diffuse 0.6
                phong 0.06
                phong_size 40
                }
        }  
        
#declare Angelo_texture_OBJuvPOVdefault = texture {Angelo_texture}
#declare Angelo_texture_OBJuvPOVskin = texture {Angelo_texture}
#declare Angelo_texture_OBJuvPOVlashes = texture {Angelo_texture}
#declare Angelo_texture_OBJuvPOVlips = texture {Angelo_texture}
#declare Angelo_texture_OBJuvPOVinnerMouth = texture {Angelo_texture}
#declare Angelo_texture_OBJuvPOVpupil = texture {Angelo_texture}
#declare Angelo_texture_OBJuvPOViris = texture {Angelo_texture finish {ambient 0.3 diffuse 0.6 reflection 0.3 phong 0.8 phong_size 50}}
#declare Angelo_texture_OBJuvPOVeyewhite = texture {Angelo_texture}

//**************************************************************************************************
#declare Ailes_Texture =  texture
        {      
        pigment
                {
                color rgb <1,1,1>
                }      
        finish
                {
                ambient 0.4
                diffuse 0.6
                phong 0.1
                phong_size 120.0
                }
        } 

#declare AilesAngelo_texture = texture {Ailes_Texture}
#declare AilesAngelo_texture_OBJuvPOVTop = texture {AilesAngelo_texture}
#declare AilesAngelo_texture_OBJuvPOVBottom = texture {AilesAngelo_texture}

//**************************************************************************************************

#declare Eau = material
        {   
        texture
                {      
                pigment
                        {
                        color rgbf <0.9,0.9,1.0,1>
                        }      
                normal
                        {
                        ripples , 0.8
                        turbulence 0.6
                        ramp_wave
                        rotate x*45
                        }      
                finish
                        {
                        ambient 0.0
                        diffuse 0.0
                        phong 0.6
                        phong_size 200
                        reflection 0.4
                        }
                }   
        interior
                {
                ior 1.33
                }
        }
        
//**************************************************************************************************        

#declare Sol = texture
        {      
        pigment
                {
                color rgb <0.9,0.9,1.0>
                }      
        normal
                {
                ripples , 0.8
                turbulence 0.6
                ramp_wave
                rotate x*45
                }
        finish
                {
                ambient 0.2
                diffuse 0.4
                }
        }
       
//**************************************************************************************************
//*			Declaration d'Objets							   *
//**************************************************************************************************

#declare Ange = #include "Ange.inc"
#declare Ailes = #include "ailes.inc"
#declare Angelo = #include "Angelo.inc"
#declare AilesAngelo = #include "AilesAngelo.inc"
#declare Cheveux =  #include "Cheveux.inc"

//**************************************************************************************************
//*			Mise en place et visualisation 						   *
//**************************************************************************************************

object {Ange}
object {Cheveux}
object {Ailes scale 0.95 translate <0.0095,0.19,0.11>}
object {Angelo translate <0.7,0.7,0.5>}
object {Angelo scale <-1,1,1> translate <-0.7,0.7,0.5>}
object {AilesAngelo translate <0.7,0.7,0.5>}
object {AilesAngelo scale <-1,1,1> translate <-0.7,0.7,0.5>}

//**********************Aureole*********************************************************************

#declare galaxy_object_name = "Star1"
#declare galaxy_colour1 = <0.5,1.0,1.5>;
#declare galaxy_object_scale = 2;
#declare galaxy_object_position = <16,0.5,1>;
#include "GALAXY.OBJ"

//********************** Ciel **********************************************************************

sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color rgb <0.3,0.6,0.9>] [1.0 color rgb 1.0] }
  }
}

//********************** Ocean ********************************************************************* 

sphere {0,1 scale 10.02 translate <0,-10,0> material {Eau scale 0.04} no_shadow hollow }  
sphere {0,1 scale 10.00 translate <0,-10,0> texture  {Sol scale 0.04} no_shadow}  

