// =========================================
// mBook macro 1.2
// -----------------------------------------
// Copyright Gilles Tran 2000
// -----------------------------------------
// Feel free to use and modify
// -----------------------------------------
// This macro creates a closed book
// The book is enclosed in the box {<0,0,0>,<xBook,yBook,zBook>}
// The book has a title chosen randomly in the "titles.txt" file and its title is
// written in a font chosen randomly in the "fonts.txt file.
// typeBook=0 creates old style books, with rounded binding, dark colors and gold trim
// typeBook=1 creates modern style books, with flat binding and funky colors
// flatratio is the flatness of the binding (this variable is set by the typeBook variable)
// -----------------------------------------
// Notes
// -----------------------------------------
// Randomness : if you don't local a seed before launching the macro, it will default to rd=seed(0)
// #local rd=seed(0) before the macro is used
// -----------------------------------------
// This macro requires a list of titles and a list of fonts
// The titles are stored in "titles.txt"
// The fonts are stored in "fonts.txt"
// You can add as many titles and fonts as you want provided that you separate them with commas
// -----------------------------------------

// =========================================
// Initialises the title list
// -----------------------------------------
#declare nTitles=0;
#fopen fTitles "titles.txt" read // list of book titles
#while (defined(fTitles)) // read once to get the number of titles
        #read(fTitles,dummy)
        #declare nTitles=nTitles+1;
#end
#fclose fTitles

#declare bookTitles=array[nTitles]   // List of titles
#declare bookTitlesLength=array[nTitles] // List of title length
#declare i=0;
#fopen fTitles "titles.txt" read // second to put the titles and their length into an array
#while (defined(fTitles))
        #read(fTitles,dummy)
        #declare bookTitles[i]=dummy 
        #declare bookTitlesLength[i]=strlen(dummy);
        #declare i=i+1;
#end
#fclose fTitles

// =========================================
// Initialises the font list
// -----------------------------------------
#declare nFonts=0;
#fopen fFonts "fonts.txt" read
#while (defined(fFonts))
        #read(fFonts,dummy)
        #declare nFonts=nFonts+1;
#end
#fclose fFonts
#declare bookFonts=array[nFonts]
#declare i=0;
#fopen fFonts "fonts.txt" read
#while (defined(fFonts))
        #read(fFonts,dummy)
        #declare bookFonts[i]=dummy
        #declare i=i+1;
#end
#fclose fFonts

// =========================================
// mBook macro 1.2
// -----------------------------------------
#macro mBook(xBook,yBook,zBook,typeBook,typePattern)
#ifndef (rd) #declare rd=seed(0); #end // a seed must be declared
#local colBook=array[6]{Red,Red,Red,Red,Red,Red}
#local eCover=xBook/20; // thickness of the cover
union{    
        // -------------------------------------------
        // Book types
        // -------------------------------------------
        #switch (typeBook)
        // -------------------------------------------
        #case (0) // old book
        // -------------------------------------------
                #local flatratio=0.3+(0.3*rand(rd));                  
                #local colBook[0]=rgb <1+0.3*rand(rd),0.3+0.3*rand(rd),0.2*rand(rd)>*0.2; // dark red
                #local colBook[1]=rgb <0.2+0.5*rand(rd),0.8+0.3*rand(rd),0.4*rand(rd)>*0.2; // dark green
                #local colBook[2]=rgb <0.858824+0.2*rand(rd),0.576471+0.2*rand(rd), 0.439216+0.2*rand(rd)>*0.3 ; //flesh
                #local colBook[3]=rgb <1.2+0.2*rand(rd),0.2+0.2*rand(rd),0.1+0.2*rand(rd)>*0.4; // dark red
                #local colBook[4]=rgb <1.3+0.2*rand(rd),1+0.2*rand(rd),0.2+0.5*rand(rd)>*0.5; // light brown
                #local colBook[5]=rgb<1+rand(rd)*0.2,1+rand(rd)*0.2,rand(rd)*0.2>*0.8; // gold color
                
                #local colPage=rgb<0.9+0.1*rand(rd),0.8+0.1*rand(rd),0.8>; // yellowish
                
                #local finCover=finish{metallic brilliance 3 ambient 0.01 diffuse 0.4 specular 0.3 roughness 0.1}
                #local finPage=finish{ambient 0.1 diffuse 0.5 specular 0.1 roughness 0.1}
                #local colDom=colBook[max(0,int(rand(rd)*5-0.001))];  
                #local colTrim_1=colBook[max(0,int(rand(rd)*3-0.001))];
                #local colTrim_2=colBook[5];                     
                #local pigBinder=mpatBinder(typePattern,colDom,colTrim_1,colTrim_2)
                #local txtCover=texture{pigment{color colDom} finish{finCover}}
                #local txtBinding=texture{
                       pigment{pigBinder}
                       finish{finCover}
                       scale <xBook,yBook,yBook>
                }
                #local txtTitle=texture{
                        pigment{color colBook[5]}
                        finish{finCover}
                }
                #local txtPage=texture{
                        pigment{
                                gradient x
                                turbulence 0.1
                                color_map{
                                        [0 color colPage]
                                        [1 color colPage*0.7]
                                }
                        }
                        finish{finPage}
                        scale xBook*rand(rd)*0.06
                        translate x*xBook
                }
        #break
        // -------------------------------------------
        #case (1) // modern book
        // -------------------------------------------
                #switch (rand(rd))        
                        #range (0,0.2)
                                #local colBook_1=White*1.5;
                        #break
                        #range (0.2,0.3)
                                #local colBook_1=Black;
                        #break
                        #else
                                #local colBook_1=rgb <rand(rd),rand(rd),rand(rd)>;
                #end
                #local colBook_2=rgb <rand(rd),rand(rd),rand(rd)>*2;        
                #switch (rand(rd))        
                        #range (0,0.3)
                                #local colTitle=White*2;
                        #break
                        #range (0.3,0.6)
                                #local colTitle=Black;
                        #break
                        #else
                                #local colTitle=rgb <1-colBook_1.x,1-colBook_1.y,1-colBook_1.z>;
                #end
                #local flatratio=rand(rd)*0.2;
                #local colPage=rgb<0.9+0.1*rand(rd),0.9+0.1*rand(rd),0.9>*1.1;
                #local finCover=finish{ambient 0.1 diffuse 0.4 specular 0.4 roughness 0.01}
                #local finPage=finish{ambient 0.1 diffuse 0.5 specular 0.1 roughness 0.1}
                #local txtCover=texture{
                        pigment{brick color colBook_1,color colBook_2 brick_size <1+rand(rd),1+rand(rd),1+rand(rd)> mortar rand(rd)}
                       finish{finCover}
                       scale yBook*rand(rd)
                       translate y*yBook*rand(rd)
                }
                #local txtTitle=texture{
                        pigment{color colTitle}
                        finish{finCover}
                }
                #local txtBinding=texture{
                        pigment{
                                gradient y
                                color_map{
                                        [0 color colBook_2]
                                        [0.3 color colBook_2]
                                        [0.3 color colBook_1]
                                        [1.0 color colBook_1]
                                        }
                                }
                       finish{finCover}
                       scale yBook*(1+rand(rd))
                       translate y*yBook*(3+(rand(rd)))
                       
                }
                #local txtPage=texture{
                        pigment{
                                gradient x
                                turbulence 0.1
                                color_map{
                                        [0 color colPage]
                                        [1 color colPage*0.7]
                                }
                        }
                        finish{finPage}
                        scale xBook*rand(rd)*0.06
                        translate x*xBook
                }
        #break
        // -------------------------------------------
        #else // single random color and random flatness
        // -------------------------------------------
                #local flatratio=rand(rd);
                #local colBook_1=rgb <rand(rd),rand(rd),rand(rd)>;
                #local colBook_2=rgb <1-colBook_1.x,1-colBook_1.y,1-colBook_1.z>;
                #switch (rand(rd))        
                        #range (0,0.3)
                                #local colTitle=White*2;
                        #break
                        #range (0.3,0.6)
                                #local colTitle=Black;
                        #break
                        #else
                                #local colTitle=colBook_2;
                #end
                #local colPage=rgb<0.9+0.1*rand(rd),0.9+0.1*rand(rd),0.9+0.1*rand(rd)>*1.1;
                #local finCover=finish{ambient 0.1 diffuse 0.4 specular 0.4 roughness 0.01}
                #local finPage=finish{ambient 0.1 diffuse 0.5 specular 0.1 roughness 0.1}
                #local txtCover=texture{
                        pigment{color colBook_1}
                        finish{finCover}
                }
                #local txtTitle=texture{
                        pigment{color colTitle}
                        finish{finCover}
                }
                #local txtBinding=texture{
                        pigment{color colBook_1}
                        finish{finCover}
                }
                #local txtPage=texture{
                        pigment{colPage}
                        finish{finPage}
                }
        #end
        // -------------------------------------------
        // Book parameters
        // -------------------------------------------
        #local rCover=eCover*0.5; // radius of cover thickness
        #local rBinding=xBook*0.5;  // radius of binding
        #local zBinding=rBinding*flatratio; // thickness of binding
        #local zCover=zBook-rCover-zBinding;
        #local yCover=yBook-eCover;
        #local zPage=zCover-4*eCover;
        #local yPage=yBook-4*eCover;
        #local xPage=xBook-2*eCover;

        // -------------------------------------------
        // front cover
        // -------------------------------------------
        union{
                box{0,<eCover,yCover,zCover>}          
                union{
                        cylinder{0,z*zCover,rCover translate <0,yCover,0>}
                        cylinder{0,z*zCover,rCover translate <0,0,0>} 
/*                          
                        cylinder{0,y*yCover,rCover translate z*zCover}
                        sphere{0,rCover translate <0,0,zCover>}
                        sphere{0,rCover translate <0,yCover,zCover>}
*/                        
                        translate x*rCover
                }                                     
                translate <rBinding-eCover,rCover,zBinding>
        }
        // -------------------------------------------
        // back cover
        // -------------------------------------------
        union{
                box{0,<eCover,yCover,zCover>}          
                union{
                        cylinder{0,z*zCover,rCover translate <0,yCover,0>}
                        cylinder{0,z*zCover,rCover translate <0,0,0>}
/*                        
                        cylinder{0,y*yCover,rCover translate z*zCover}
                        sphere{0,rCover translate <0,0,zCover>}
                        sphere{0,rCover translate <0,yCover,zCover>}
*/                        
                        translate x*rCover
                }                                     
                translate <rBinding-eCover,rCover,zBinding>
                scale <-1,1,1>
        }          
        
        // -------------------------------------------
        // binding
        // -------------------------------------------
        union{
                // -------------------------------------------
                // Book title on the binding
                // This part needs to be rewritten for use with the text functions in Megapov
                // -------------------------------------------   
                #if (typeBook=0) 
                        #local titleSize=0.4+0.3*rand(rd);
                #else 
                        #local titleSize=0.7+0.3*rand(rd);
                #end
                #local iBook=int(rand(rd)*nTitles);
                #local rtext=bookTitles[iBook]
                #local nLetters=bookTitlesLength[iBook]/1.8;
                #local titleBook=
                        text{ttf bookFonts[rand(rd)*nFonts] rtext 1,0
                        translate <-nLetters/2,-0.3,0>
                        scale <yBook*0.8*titleSize/nLetters,min(yBook*0.8*titleSize/nLetters,xBook),rCover>
                }
                
                object{titleBook rotate z*90 translate <0,yBook/2,zBinding-rBinding*flatratio> texture{txtTitle}}
                
                difference{               
                        union{
                                cylinder{0,y*yCover,rBinding}
                                torus{rBinding-rCover,rCover sturm}
                                torus{rBinding-rCover,rCover  sturm translate y*yCover}
                        }
                        cylinder{-rCover*2*y,y*(yCover+rCover)*1.1,rBinding-eCover}
                        plane{z,0 inverse}                
                        scale <1,1,flatratio>
                        translate <0,rCover,zBinding>
                        texture{txtBinding translate -x*xBook*0.5}
                } 
                
        }
        // -------------------------------------------
        // pages        
        // -------------------------------------------

        union{
                difference{
                        box{0,<xPage,yPage,zPage>}
                        cylinder{-y*0.1,y*yPage*1.1,xPage*0.5 scale <1,1,flatratio*rand(rd)> translate <xPage*0.5,0,zPage>}
                }
                difference{
                        cylinder{0,y*yPage,xPage*0.5}
                        cylinder{-y*0.1,y*yPage*1.1,xPage*0.5 scale <1,1,0.5> translate -z*0.5*xPage}
                        scale <1,1,flatratio> translate x*xPage*0.5
                }                                                            
                
                translate <-xPage*0.5,2*eCover,zBinding>
                texture{txtPage}
        } 
        
        translate x*xBook*0.5
        texture{txtCover}
}
#end  

// -----------------------------------------
// end of mBook macro
// =========================================

// =========================================
// mRandomText macro 1.0
// -----------------------------------------
// Copyright Gilles Tran 1999
// -----------------------------------------
// This macro creates a random text of nLetters letters
// -----------------------------------------
// local the font path and names before using this file.
// For example :
// #local fontpath="\windows\fonts\\"
// #local fontname_1="arial.ttf"
// #local fontname_2="times.ttf"
// -----------------------------------------
#macro mRandomText(nLetters)
        #local rtext=""
        #if (rand(rd)<0.5)
                #local fontname=concat(fontpath,fontname_1)
        #else
                #local fontname=concat(fontpath,fontname_2)
        #end                
//                #warning fontname
        #local i=0;
        #if (rand(rd)<0.5)
                #local asciistart=65; // majuscule
        #else
                #local asciistart=97; // minuscule
        #end
        #while (i<nLetters)
                #local rtext=concat(rtext,chr(asciistart+int(27*rand(rd))))
                #local i=i+1;                  
        #end
        text{ttf fontname rtext 1,0}
#end
// -----------------------------------------
// end of mRandomText macro
// =========================================
// =========================================
// mpatBinder macro 1.0
// -----------------------------------------
// This macro defines several patterns for an old book binder
// it returns the pattern typePattern
// colDom is the dominant color
// colTrim_1 is a secondary color
// colTrim_2 is a third color, usually gold             
// 
// the macro returns a pigment color starting on <0,0,0> going to <1,1,1>
#macro mpatBinder(typePattern,colDom,colTrim_1,colTrim_2)
#local yvar=rand(rd)*0.25; // this variable is used to "slide" the pattern vertically so that the stripes change place
pigment{
        #switch (typePattern)
        #case (0) // dom/gold/black/gold/trim/gold/dom
                gradient y
                #declare p1=pigment{
                        gradient y
                        color_map{
                                [0 color colDom*0.8]
                                [0.1 color colDom]
                                [0.5+yvar color colDom]
                                [0.5+yvar color colTrim_2]
                                [0.52+yvar color colTrim_2]
                                [0.52+yvar color colDom*0.01]
                                [0.6+yvar color colDom*0.01]
                                [0.6+yvar color colTrim_2]
                                [0.62+yvar color colTrim_2]
                                [0.62+yvar color colTrim_1]
                                [0.75+yvar color colTrim_1]
                                [0.75+yvar color colTrim_2]
                                [0.77+yvar color colTrim_2]
                                [0.77+yvar color colDom]
                                [1 color colDom*0.8]
                        }
                }
                #declare p2=pigment{
                                spherical
                                translate y*0.5
                                color_map{
                                        [0 colDom*0.01]
                                        [0.7+yvar colDom*0.01]
                                        [0.7+yvar colTrim_2]
                                        [1 colTrim_2]
                                }
                        scale 0.08
                        translate x*0.5 
                        translate y*(0.52+yvar)
                }                          
                pigment_map{
                        [0 p1]
                        [0.52+yvar p1]
                        [0.52+yvar p2]
                        [0.6+yvar p2]
                        [0.6+yvar p1]
                        [1 p1]
                }
        #break        
        
        #case (1) // dom/gold/black/gold/trim boxed
                boxed          
                translate y
                warp{repeat y*2} 
                scale <0.5,2/((int(rand(rd)*5)+1)*4),1>
                translate x*0.5 
                color_map{
                        [0 colDom]
                        [0.3+yvar colDom]
                        [0.3+yvar colTrim_2]
                        [0.35+yvar colTrim_2]
                        [0.35+yvar colDom*0.01]
                        [0.4+yvar colDom*0.01]
                        [0.4+yvar colTrim_2]
                        [0.45+yvar colTrim_2]
                        [0.45+yvar colTrim_1]
                        [1 colTrim_1]
                }
        #break        
        
        #case (2) // dom/gold/dom/gold/dom/gold/black/gold/dom/gold/dom
                gradient y
                #declare p1=pigment{
                        gradient y
                        color_map{
                                [0 color colDom*0.8]
                                [0.05+yvar color colDom]
                                [0.05+yvar color colTrim_2]
                                [0.06+yvar color colTrim_2]
                                [0.06+yvar color colDom]
                                [0.22+yvar color colDom]
                                [0.22+yvar color colTrim_2]
                                [0.23+yvar color colTrim_2]
                                [0.23+yvar color colDom]
                                [0.50+yvar color colDom]
                                [0.50+yvar color colTrim_2]
                                [0.51+yvar color colTrim_2]
                                [0.51+yvar color colDom*0.01]
                                [0.72+yvar color colDom*0.01]
                                [0.72+yvar color colTrim_2]
                                [0.73+yvar color colTrim_2]
                                [0.73+yvar color colDom]
                                [0.84+yvar color colDom]
                                [0.84+yvar color colTrim_2]
                                [0.85+yvar color colTrim_2]
                                [0.85+yvar color colDom]
                                [1 color colDom*0.8]
                        }
                }
                #declare p2=pigment{
                                spherical
                                translate x
                                warp{repeat x*2}
                                color_map{
                                        [0 colDom*0.01]
                                        [0.7+yvar colDom*0.01]
                                        [0.7+yvar colTrim_2]
                                        [1 colTrim_2]
                                }
                        scale 0.5
                        scale 0.21
                        translate x*0.5 
                        translate y*(0.51+yvar+0.21/2)
                }                          
                pigment_map{
                        [0 p1]
                        [0.51+yvar p1]
                        [0.51+yvar p2]
                        [0.72+yvar p2]
                        [0.72+yvar p1]
                        [1 p1]
                }
        #break        
        #case (3) // dom/gold/ dom /gold /dom  rims
                gradient y
                #declare p1=pigment{
                        gradient y
                        scale 0.1+yvar
                        color_map{
                                [0 colDom*0.7]
                                [1 colDom]
                        }
                }
                #declare p2=pigment{colTrim_2}
                #declare p3=pigment{
                        gradient y
                        triangle_wave
                        scale rand(rd)*0.5
                        color_map{
                                [0 colDom*0.4]
                                [0.4 colDom]
                                [1 colDom*1.3]
                        }
                }

                pigment_map{
                        [0.00 p1]
                        [yvar p1]
                        [yvar p2]
                        [0.02+yvar p2]
                        [0.02+yvar p3]
                        [1-yvar-0.02 p3]
                        [1-yvar-0.02 p2]
                        [1-yvar p2]
                        [1-yvar p1 scale -1 translate y]
                        [1.00 p1 scale -1 translate y]
                }
        #break        
        #case (4) // dom/gold/ rims /gold /dom losange
                gradient y
                #declare p1=pigment{
                        gradient y
                        color_map{
                                [0 colDom*0.7]
                                [0.7 colDom]
                                [0.7 colTrim_2]
                                [1 colTrim_2]
                        }
                        scale 0.1
                }
                #declare p3=pigment{
                        gradient y
                        color_map{
                                [0 colTrim_2]
                                [0.1 colTrim_2]
                                [0.1 colDom]
                                [1 colDom*0.3]
                        }
                        scale 0.2
                        translate y*0.8
                }
                #declare p2=pigment{
                                boxed           
                                rotate z*45
                                translate y
                                warp{repeat y*2} 
                                scale <0.5,2/((int(rand(rd)*5)+1)*4),1>
//                                scale <0.5,2/8,1>
                                translate x*0.5 
                                color_map{
                                        [0 colDom]
                                        [0.4+yvar colDom]
                                        [0.4+yvar colTrim_2]
                                        [0.45+yvar colTrim_2]
                                        [0.45+yvar colDom*0.01]
                                        [0.5+yvar colDom*0.01]
                                        [0.5+yvar colTrim_2]
                                        [0.65+yvar colTrim_2]
                                        [0.65+yvar colTrim_1]
                                        [1 colTrim_1]
                                }
                        scale <1,0.7,1>
                        translate y*0.1
                }
                pigment_map{
                        [0 p1]
                        [0.1 p1]
                        [0.1 p2]
                        [0.8 p2]
                        [0.8 p3]
                        [1 p3]
                }

        #break

        #case (5) // black/gold/speckled dom/gold/black
                gradient y
                #declare p1=pigment{colDom*0.001}
                #declare p2=pigment{colTrim_2}
                #declare p3=pigment{
                        bozo
                        translate yvar*10
                        color_map{
                                [0 colDom]
                                [0.7 colDom]
                                [0.7 colDom*0.3]
                                [1 colDom*0.3]
                        }
                        scale rand(rd)*0.05
                }
                pigment_map{
                        [0.00 p1]
                        [yvar p1]
                        [yvar p2]
                        [0.02+yvar p2]
                        [0.02+yvar p3]
                        [1-yvar-0.08 p3]
                        [1-yvar-0.08 p2]
                        [1-yvar-0.06 p2]
                        [1-yvar-0.06 p1]
                        [1-yvar-0.04 p1]
                        [1-yvar-0.03 p2]
                        [1-yvar p2]
                        [1-yvar p1 scale -1 translate y]
                        [1.00 p1 scale -1 translate y]
                }
        #break
        #case (6) // black/gold/agate dom/gold/black
                gradient y
                #declare p0=pigment{colDom*0.001}
                #declare p1=pigment{colDom}
                #declare p2=pigment{colTrim_2}
                #declare p3=pigment{
                        agate
                        translate yvar*10
                        color_map{
                                [0 colTrim_1]
                                [0.7 colTrim_1]
                                [0.7 colTrim_1*0.3]
                                [1 colTrim_1*0.3]
                        }
                        scale rand(rd)*0.1
                }
                pigment_map{
                        [0.00 p3]
                        [yvar p3]
                        [yvar p2]
                        [0.02+yvar p2]
                        [0.02+yvar p1]
                        [1-yvar-0.08 p1]
                        [1-yvar-0.08 p2]
                        [1-yvar-0.06 p2]
                        [1-yvar-0.06 p0]
                        [1-yvar-0.02 p0]
                        [1-yvar-0.02 p2]
                        [1-yvar p2]
                        [1-yvar p3 scale -1 translate y]
                        [1.00 p3 scale -1 translate y]
                }
        #break
        #case (7) 
                gradient y
                #declare p0=pigment{colDom*0.001}
                #declare p1=pigment{colDom}
                #declare p2=pigment{colTrim_2}
                #declare p3=pigment{
                        crackle
                        translate yvar*10
                        color_map{
                                [0 colTrim_2]
                                [0.025 colTrim_2]
                                [0.025 colDom*0.3]
                                [1 colDom*0.3]
                        }
                        scale <0.1,0.03,0.1>*4
                }
                pigment_map{
                        [0.00 p0]
                        [yvar*0.1 p0]
                        [yvar*0.1 p2]
                        [yvar*0.1+0.01 p2]
                        [yvar*0.1+0.01 p3]
                        [1-yvar-0.08 p3]
                        [1-yvar-0.08 p2]
                        [1-yvar-0.06 p2]
                        [1-yvar-0.06 p0]
                        [1-yvar-0.02 p0]
                        [1-yvar-0.02 p2]
                        [1-yvar p2]
                        [1-yvar p0 scale -1 translate y]
                        [1.00 p0 scale -1 translate y]
                }
        #break
        #case (8) 
                gradient y   
                turbulence 0.01
                scale <yvar,1,1>
//                #declare colDom=rgb<0.7+yvar,0.7+yvar*0.5,0.7>;
                #declare p0=pigment{
                        gradient x 
                        turbulence 1                     
                        triangle_wave
                        color_map{
                                [0 colDom*1.5]
                                [1 colDom*0.3*1.5]
                        }
                }
                #declare p1=pigment{
                        gradient x 
                        turbulence 1                     
                        triangle_wave
                        color_map{
                                [0 colDom*0.5]
                                [1 colDom*0.3*0.5]
                        }
                }
                #declare p2=pigment{
                        gradient x                      
                        turbulence 1
                        triangle_wave
                        color_map{
                                [0 colDom]
                                [1 colDom*0.3]
                        }
                }
                pigment_map{
                        [0.00 p0]
                        [0.02 p1]
                        [0.5 p2]
                        [1.00-yvar-0.1 p2]
                        [1.00-yvar-0.1 p0]
                        [1.00-yvar-0.01 p0]
                        [1.00-yvar p1]
                        [0.99 p1]
                        [1.00 p0]
                }
        #break
        #case (9) 
                gradient y   
                turbulence 0.01
                #declare p0=pigment{
                        gradient x 
                        turbulence 1                     
                        triangle_wave
                        color_map{
                                [0 colDom*1.5]
                                [1 colDom*0.3*1.5]
                        }
                }
                #declare p1=pigment{
                        gradient x 
                        turbulence 1                     
                        scale <yvar,1,1>
                        triangle_wave
                        color_map{
                                [0 colDom*0.5]
                                [1 colDom*0.3*0.5]
                        }
                }
                #declare p2=pigment{
                        gradient x                      
                        turbulence 1
                        scale <yvar,1,1>
                        triangle_wave
                        color_map{
                                [0 colDom]
                                [1 colDom*0.3]
                        }
                }
                #declare p3=pigment{
                        spherical
                        color_map{
                                [0 colDom*0.3]
                                [0.6 colDom*0.3]
                                [0.6 colTrim_2]
                                [1 colTrim_2]
                        }        
                        translate y*0.5
                        scale 0.3*<1,0.3,1>
                        translate y*(0.02+yvar*0.5)
                        translate x*0.5
                }
                pigment_map{
                        [0.00 p0]
                        [0.02 p1]
                        [0.02+yvar*0.5 p1]
                        [0.02+yvar*0.5 p3]
                        [0.22+yvar*0.5 p3]
                        [0.22+yvar*0.5 p2]
                        [0.99 p1]
                        [1.00 p0]
                }
        #break
        #else
                gradient y   
                turbulence 0.01
                #declare p0=pigment{
                        agate
                        translate yvar*10
                        color_map{
                                [0 colDom*1.5]
                                [1 colDom*0.3*1.5]
                        }
                }
                #declare p1=pigment{
                        agate
                        triangle_wave
                        translate yvar*10
                        color_map{
                                [0 colDom*0.5]
                                [1 colDom*0.3*0.5]
                        }
                }
                #declare p2=pigment{
                        agate
                        translate yvar*10
                        triangle_wave
                        color_map{
                                [0 colDom]
                                [1 colDom*0.3]
                        }
                }
                #declare p3=pigment{
                        gradient x
                        turbulence 0.3
                        triangle_wave
                        scale <yvar,1,1>
                        color_map{
                                [0 colDom*0.3]
                                [0.6 colDom*0.3]
                                [0.6 colTrim_2]
                                [1 colTrim_2]
                        }        
                }
                pigment_map{
                        [0.00 p0]
                        [0.02 p1]
                        [0.02+yvar*0.2 p1]
                        [0.02+yvar*0.2 p3]
                        [0.22+yvar*0.2 p3]
                        [0.22+yvar*0.2 p2]
                        [0.99 p1]
                        [1.00 p0]
                }
        #end
}              
#end
// -----------------------------------------
// end of mpatBinder macro
// =========================================
