#version unofficial megapov 0.6;

#include "colors.inc"
#include "woods.inc"


//===================================
//===================================
//	SCENE OPTIONS
//===================================
//===================================

// media settings
#declare Use_media = on;
#declare Med_int = 2;
#declare Med_samp = 80;
#declare Med_thre = .1;
#declare Med_conf = .80;
#declare Med_var = 1/100;

// area_light settings
#declare Use_area = on;
#declare Nb_area1 = 6;
#declare Nb_area2 = 6;
#declare Adap_area = 2;

// radiosity settings
#declare Use_rad = on;
#declare Rad_count = 300;
#declare Rad_error = .05;
#declare Rad_rec = 1;
#declare Rad_bright = 1.0;

// objects options
#declare Use_HF_Plancher = on;
#declare Use_Lamp = on;
#declare Use_Lit = on;
#declare Use_Bureau = on;
#declare Use_Pendule = on;
#declare Use_Miroir = off;
#declare Use_Boites = on;
#declare Use_Icones = on;

// sPatch meshes
#declare IMPORT_SPATCH = on;
#declare Use_Pot = on;
#declare Use_Traversin = on;
#declare Use_Carafe = on;

// Gilles Tran's macros
#declare Use_Books = on;

// ClothRay meshes
#declare Use_Drap = off;
#declare Use_Tabouret = off;
#declare Use_Rideau = off;

// Poser meshes
#declare Use_Eve = off;
#declare Use_Teddy = off;
#declare Use_HeartBox = off;
#declare Use_Chaussures = off;
#declare Use_Sandales = off;



//===================================
//===================================
//	SETTINGS
//===================================
//===================================
global_settings {
	max_trace_level 30
	adc_bailout 0.1
#if (Use_rad)
	ini_option "+QR"
//	assumed_gamma 1.5
	radiosity{
		count Rad_count
		nearest_count 3
		error_bound Rad_error
		recursion_limit Rad_rec
		brightness Rad_bright

		pretrace_start  .1
		pretrace_end  .005

		low_error_factor .5
		gray_threshold 0.2
		minimum_reuse 0.015
		normal on

		max_sample 1
		adc_bailout 0.1
	}
	//ambient_light 0.0
#end
}

#if (Use_rad)
#default { texture { finish { ambient -.2 diffuse 1.1 } } }
#else
#default { texture { finish { ambient .3 diffuse .7 } } }
#end


#declare Coins = 2;

#declare Xfond1 = -150;
#declare Xfond2 =  200;
#declare Yfond1 =    0;
#declare Yfond2 =  100;
#declare Yfond3 =  220;
#declare Zfond1 =  400;
#declare Afond  =   30;
#declare Xfen1 =    55;
#declare Xfen2 =   115;


//===================================
//	LIGHTS
//===================================

// from the window
light_source { 1000000*y color rgb<.55, .75, 1>*1.7
	rotate x*50 rotate y*10
	media_interaction off
	media_attenuation off
}

#declare Lamp_Pos = <Xfond1+46, 70, Zfond1-140+40>;

#if (Use_Lamp)
#include "oillamp.inc"
union {
	object { OilLamp }
	light_source { (Ht_OL_Body+3)*y color rgb <1, .95, .6>*1.7
		fade_distance 200
		fade_power 1
		media_interaction off
		media_attenuation on
#if (Use_area)
		area_light 5*x, 5*z, Nb_area1, Nb_area2
		orient
		circular
		jitter
		adaptive Adap_area
#end
	}
	translate Lamp_Pos
}

glow {
	location 0
	size 1
	fade_power 1
	type 0
	color rgb <1,1,.6>*.5
	scale <2, 1.5, 2>
	warp { turbulence .4 }
	translate Lamp_Pos + (Ht_OL_Body+3)*y
}

glow {
	location 0
	size 2
	fade_power 2
	type 0
	color rgb <1,1,.6>*.3
	scale <1, 2, 1>
	warp { turbulence .4 }
	translate Lamp_Pos + (Ht_OL_Body+4)*y
}


#else
light_source { Lamp_Pos + 20*y color rgb <1, .95, .6>*1.7
	fade_distance 180
	fade_power 2
	media_interaction off
	media_attenuation on
#if (Use_area)
	area_light 5*y, 5*x, Nb_area1, Nb_area2
	orient
	circular
	jitter
	adaptive Adap_area
#end
}
#end

#if (Use_rad = off)

light_source { <90, 50, -50>, color rgb<.45,.55,1>*.45 shadowless }

#end


//===================================
//	CAMERA
//===================================

camera {
//	location <140, 50, -50>
//	location <160, 70, -50>
	location <160, 80, -50>
	right x*16/9
	up y
	angle 40
	look_at <60, 60, 200>
}

/*
camera {
	location <100, 50, Zfond1-50>
	right x*4/3
	up y
	angle 10
	look_at <Xfond1, Yfond2, Zfond1>
}
*/

//===================================
//	MEDIA
//===================================


#if (Use_media)
box { <Xfond1-10, Yfond1-10, -100>, <Xfond2+10, Yfond3+10, Zfond1+14>
	hollow
	pigment { rgbt 1 }
	interior {
		media {
			intervals Med_int
			scattering { 3, color rgb .008 extinction 0.12 }
			method 3
			samples Med_samp, Med_samp
			aa_threshold Med_thre
			variance Med_var
			confidence Med_conf
		}
	}
}
#end

//===================================
//	MURS
//===================================

#declare Pat_Crack = pigment {
	bozo
	warp { turbulence .2 octaves 3 omega .3 lambda 2 }
	scale 2
	warp { turbulence .7 octaves 3 omega .3 lambda 2 }
	scale 2
	warp { turbulence 1 octaves 3 omega .3 lambda 2 }
	scale 6
	warp { turbulence 1 octaves 3 omega .3 lambda 2 }
	color_map {[0 rgb 0][1 rgb 1]}
}

#declare N_Crack = normal {
	bozo
	warp { turbulence .2 octaves 3 omega .3 lambda 2 }
	scale 2
	warp { turbulence .7 octaves 3 omega .3 lambda 2 }
	scale 2
	warp { turbulence 1 octaves 3 omega .3 lambda 2 }
	scale 6
	warp { turbulence 1 octaves 3 omega .3 lambda 2 }
	slope_map {
		[.4900 <.5, 0>]
		[.5000 <.5, .5>]
		[.6000 <1, .5>]
		[.6000 <1, -3>]
		[.6001 <0, -3>]
		[.6001 <0, 0>]
		[.9999 <0, 0>]
	}
}

#declare T_Mur_1 = texture {
	pigment { pigment_pattern { Pat_Crack } color_map {[0.6001 color rgb .7][0.6001 color rgb .85]} }
	normal { average
		normal_map {
			[4 N_Crack ]
			[1 granite 1.2 poly_wave 2 scale .5 ]
			[1 wrinkles 1.5 poly_wave 2 scale 10 ]
			[1 wrinkles 1.3 poly_wave 2 scale 2 ]
			[1 dents -1.8 poly_wave 2 scale 2 ]
		}
	}
}
texture {
	pigment {
		wrinkles
		color_map {
			[0 rgbt 1][.3 rgbt 1]
			[.65 rgbt <.6,.3,.2,.8>][1 rgbt <.5,.2,.1,.6>]
		}
		scale <20, 40, 20>
	}
	normal { bumps .6 scale .5 }
}
texture {
	pigment {
		pigment_pattern {
			planar
			scale <5, 5, 5>
			warp { turbulence .6 octaves 2 lambda 2 }
			scale <1/3, 4, 1/3>
			color_map { [0 rgb 0][1 rgb 1] }
		}
		pigment_map {
			[0 rgbt 1 ]
			[.4 wrinkles
				scale <3, 5, 3>
				color_map {
					[0 rgbt 1][.3 rgbt 1]
					[.65 rgbt <.5,.3,.1,.7>][1 rgbt <.4,.25,.10,.5>]
				} ]
		}
	}
}


#declare T_Mur_1a = texture { pigment { color rgb 1 } }


/*
#declare T_Mur_I = texture {
	pigment { image_map { ppm "concrete" interpolate 2 } scale <300, 300*365/737, 1> }
	normal { bump_map { ppm "concrete" interpolate 2 } bump_size .05 scale <300, 300*365/737, 1> }
	finish { brilliance .8 }
	translate Xfond1*x + Yfond1*y
}

*/

// mur du fond
union {
	union {
		box { <Xfond1, Yfond1, Zfond1>, <Xfen1-Coins, Yfond3, Zfond1+15> }
		box { <Xfen1, Yfond1, Zfond1+Coins>, <Xfen1-Coins, Yfond3, Zfond1+15> }
		cylinder { <Xfen1-Coins, Yfond1, Zfond1+Coins>, <Xfen1-Coins, Yfond2, Zfond1+Coins>, Coins }
		difference {
			#local R = 5*Coins;
			#local H1 = R*sin(radians(Afond));
			#local Z1 = R*(1-cos(radians(Afond)));
			#local H2 = H1 - Z1/tan(radians(Afond));
			box { <Xfond1, 0, -Z1>, <Xfen1, H1, Z1> }
			cylinder { <Xfond1-.01, 0, -R>, <Xfen1+.01, 0, -R>, R }
			intersection {
				torus { R+Coins, R }
				box { <0, -R-0.01, 0>, <2*R+Coins+.01, R+0.01, -2*R-Coins-.01> }
				translate <Xfen1-Coins, 0, Coins>
			}
		    translate <0, Yfond2-H2, Zfond1>
		}
//		texture { T_Mur_1 }
	}
	union {
		box { <Xfond2, Yfond1, Zfond1>, <Xfen2+Coins, Yfond3, Zfond1+15> }
		box { <Xfen2, Yfond1, Zfond1+Coins>, <Xfen2+Coins, Yfond3, Zfond1+15> }
		cylinder { <Xfen2+Coins, Yfond1, Zfond1+Coins>, <Xfen2+Coins, Yfond2, Zfond1+Coins>, Coins }
		difference {
			#local R = 5*Coins;
			#local H1 = R*sin(radians(Afond));
			#local Z1 = R*(1-cos(radians(Afond)));
			#local H2 = H1 - Z1/tan(radians(Afond));
			box { <Xfen2-.01, 0, -Z1>, <Xfond2, H1, Z1> }
			cylinder { <Xfen2-.02, 0, -R>, <Xfond2+.01, 0, -R>, R }
			intersection {
				torus { R+Coins, R }
				box { <0, -R-0.01, 0>, <-2*R-Coins-.01, R+0.01, -2*R-Coins-.01> }
				translate <Xfen2+Coins, 0, Coins>
			}
		    translate <0, Yfond2-H2, Zfond1>
		}
//		texture { T_Mur_1 }
	}
	union {
		box { <Xfond1, Yfond2, Zfond1>, <Xfen1-Coins, Yfond3+20, Zfond1+50> }
		box { <Xfen1, Yfond2, Zfond1+Coins>, <Xfen1-Coins, Yfond3+20, Zfond1+50> }
		cylinder { <Xfen1-Coins, Yfond2, Zfond1+Coins>, <Xfen1-Coins, Yfond3+20, Zfond1+Coins>, Coins }
//		texture { T_Mur_1 }
		translate -Yfond2*y -Zfond1*z
		rotate -Afond*x
		translate Yfond2*y + Zfond1*z
		clipped_by { box {<Xfond1-1, Yfond1, 0>, <Xfen1+1, Yfond3, Zfond1+15>} }
	}
	union {
		box { <Xfond2, Yfond2, Zfond1>, <Xfen2+Coins, Yfond3+20, Zfond1+15> }
		box { <Xfen2, Yfond2, Zfond1+Coins>, <Xfen2-Coins, Yfond3+20, Zfond1+15> }
		cylinder { <Xfen2+Coins, Yfond2, Zfond1+Coins>, <Xfen2+Coins, Yfond3+20, Zfond1+Coins>, Coins }
//		texture { T_Mur_1 }
		translate -Yfond2*y -Zfond1*z
		rotate -Afond*x
		translate Yfond2*y + Zfond1*z
		clipped_by { box {<Xfond2+1, Yfond1, 0>, <Xfen2-1, Yfond3, Zfond1+15>} }
	}
	union {
		box { <Xfen1-Coins, Yfond1, Zfond1>, <Xfen2+Coins, Yfond2-Coins, Zfond1+15> }
		box { <Xfen1-Coins, Yfond1, Zfond1+Coins>, <Xfen2+Coins, Yfond2, Zfond1+15> }
		cylinder { <Xfen1-Coins, Yfond2-Coins, Zfond1+Coins>, <Xfen2+Coins, Yfond2-Coins, Zfond1+Coins>, Coins }
//		texture { T_Mur_1 }
	}
	box {<Xfen1, Yfond2, Zfond1+12.2>, <Xfen1+6, Yfond3, Zfond1+15.9>}
	box {<Xfen2, Yfond2, Zfond1+12.2>, <Xfen2-6, Yfond3, Zfond1+15.9>}
	texture { T_Mur_1 }
}


// mur gauche
box { <Xfond1, Yfond1, Zfond1>, <Xfond1 - 15, Yfond3, -51> texture { T_Mur_1 } }

// mur droite
box { <Xfond2, Yfond1, Zfond1>, <Xfond2 + 15, Yfond3, -51> texture { T_Mur_1 } }

// plafond
box { <Xfond1, Yfond3, Zfond1+15>, <Xfond2, Yfond3+15, -51> texture { T_Mur_1a } }

// mur derriere
box { <Xfond1, Yfond1, -55>, <Xfond2, Yfond3, -51> texture { T_Mur_1 finish { diffuse .5 }} }


//===================================
//	FENETRE
//===================================
#declare Fhaut = Yfond3 - Yfond2 - 10;

#declare M_Vitre = material {
	texture {
		pigment { color rgbf 1 }
		normal { bumps .1 scale .5 }
		finish {
			ambient 0 diffuse 0
			reflection .1
			specular .8 roughness .001
			conserve_energy
		}
	}
	interior {
		ior 1.5
	}
}

#declare T_Fenetre = texture { pigment { color rgb .95 } }
texture {
	pigment {
		wrinkles
		color_map {
			[0 rgbt 1][.45 rgbt 1]
			[.55 rgbt <.5,.3,.2,.4>][1 rgbt <.4,.2,.1,.1>]
		}
		scale <.1, 10, .1>
	}
	normal { wrinkles .9 scale <.3, 3, .3> }
}

#declare T_Fenetre2 = texture {
	pigment { color rgb .97 }
	normal { crackle poly_wave .5 scale .5 }
}


#declare Fenetre = union {
	box { <-25, 0, -1>, <25, Fhaut, 1> material { M_Vitre } }
	box { <-25, 0, -2>, <-20, Fhaut, 2> texture { T_Fenetre } }
	box { <20, 0, -2>, <25, Fhaut, 2> texture { T_Fenetre } }
	box { <-03, 0, -2>, <03, Fhaut, 2> texture { T_Fenetre } }
	box { <-20, 0, -1.99>, <20, 5, 1.99> texture { T_Fenetre rotate z*90 } }
	box { <-20, Fhaut-5, -1.99>, <20, Fhaut, 1.99> texture { T_Fenetre rotate z*90 } }
	box { <-20, 5+(Fhaut-10)*1/3-1, -1.5>, <20, 5+(Fhaut-10)*1/3+1, 1.5> texture { T_Fenetre rotate z*90 } }
	box { <-20, 5+(Fhaut-10)*2/3-1, -1.5>, <20, 5+(Fhaut-10)*2/3+1, 1.5> texture { T_Fenetre rotate z*90 } }
	union {
		box { <-1.5, -3, 0>, <1.5, 3, -1> }
		union {
			sphere { 0, 1 }
			sphere { 0, .75 translate -z*.5 }
			scale <1, 4, .5>
			translate -2*z
		}
		cylinder { -z, -2*z, .5 }
		translate <0, 5+(Fhaut-10)*1/3, -2>
		texture { T_Fenetre2 }
	}
}

object { Fenetre
	translate <Xfen1+5+25, Yfond2+1, Zfond1+14>
}

box { <Xfen1-1, Yfond3-5, Zfond1+12.2>, <Xfen2+1, Yfond3, Zfond1+17> texture { T_Mur_1 } }
box { <Xfen1-1, Yfond2, Zfond1+12.2>, <Xfen2+1, Yfond2+1, Zfond1+17> texture { T_Mur_1 } }

#if (Use_Rideau)

#declare Rideau = mesh {
	#include "rideau_s.msh"
	uv_mapping
	texture {
		pigment {
			color rgb <.70, .80, 1>
		}
		normal {
			quilted .02 control0 1 control1 1
			sine_wave
			scale <1, 3, 1>
		}
		scale <.005, .005, 1>
	}
	scale <.5, 1, .5>
}

#local ridmin = min_extent(Rideau);
#local ridmax = max_extent(Rideau);

object { Rideau
	translate <-ridmin.x, -ridmin.y, -ridmax.z>
	translate <Xfen1, Yfond2+2, Zfond1+11>
}

#end



//===================================
//	PLANCHER
//===================================

#include "plancher.inc"


//===================================
//	LIT
//===================================

#if (Use_Lit)

#include "lit.inc"

#if (Use_Drap)
#declare Drap = mesh {
	#include "drap_s.msh"
	uv_mapping
	texture {
		pigment {
			gradient x
			pigment_map {
				[.01 color rgb 1 ]
				[.01 gradient y color_map { [.01 color rgb 1][.01 color rgbf <.95, .95, .95, .1>] [.99 color rgbf <.95, .95, .95, .1>] [.99 color rgb 1]} ]
				[.99 gradient y color_map { [.01 color rgb 1][.01 color rgbf <.95, .95, .95, .1>] [.99 color rgbf <.95, .95, .95, .1>] [.99 color rgb 1]} ]
				[.99 color rgb 1 ]
			}
		}
	}
	double_illuminate
}
#end

#if (Use_Traversin)
#declare Traversin = #include "Traversin.inc"
#end

union {
	object { Lit }
#if (Use_Traversin)
	object { Traversin rotate -x*25 translate 5*y translate 56.5*y + 40*x + (180-12)*z }
#end
#if (Use_Drap)
	object { Drap
			scale <-1.05, 1, 1.05>
			translate 40.5*y - 2*z
			translate 1.5*y+82.5*x
	}
#end
	rotate -y
	translate <Xfond2-81, 0, Zfond1-182>
}

#end

//===================================
//	PETITE CROIX AU MUR
//===================================

#if (Use_Lit)

#declare Croix = union {
	box { <-1, 0, -1>, <1, 16, 0> texture {T_Wood22 scale .4 rotate x*90} }
	box { <-5, 10, -.99>, <5, 12, -0.01> texture {T_Wood22 scale .4 rotate y*90} }
	union {
		torus { .40, .09 rotate x*90 rotate y*90 }
		torus { .7, .1 rotate x*90 rotate y*3 translate y*(.31+.60) }
		cylinder { -.2*z, -.1*z, .4 rotate x*5 rotate y*7 translate y*(.31+.60+.60-0.2) }
		cylinder { -.1*z, 2*z, .2 rotate x*5 rotate y*7 translate y*(.31+.60+.60-0.2) }
		texture { T_VieuxFer scale .3 }
		translate 16*y - .5*z
	}
}

object { Croix
	translate <-3+(Xfen1+Xfen2)/2, Yfond2 - 25, Zfond1-.05>
}

#end

//===================================
//	BUREAU
//===================================

#if (Use_Bureau = off)
union {
	box { <0, 65, 0>, <50, 70, 100> }
	box { <2, 0, 2>, <7, 65, 7> }
	box { <43, 0, 2>, <48, 65, 7> }
	box { <2, 0, 93>, <7, 65, 98> }
	box { <43, 0, 93>, <48, 65, 98> }
	texture { T_Wood22 }
	translate <Xfond1+1, 0, Zfond1-140>
}

#else

#include "tables.inc"
object { Bureau
	translate <Xfond1+1, 0, Zfond1-140>
}
#end


#if (Use_Books)

#include "MakeBook.inc"
// mBook(xBook,yBook,zBook,typeBook,typePattern)
#local stb=seed(4321);
union {
	#local tempi = 0;
	#while (tempi < 15)
		object {
			#local temp = 2.5+1.5*rand(stb);
			mBook(temp,25+3*rand(stb),20+2*rand(stb), 0, mod(int(rand(stb)*4321),10))
			translate -10*y -10*z
			rotate (-15+30*rand(stb))*x
			translate (8+4*rand(stb))*y + (8+4*rand(stb))*z
			translate tempi*x
		}
		#local tempi = tempi+temp;
	#end
	rotate z*90
	rotate -90*y
	translate <Xfond1+30, 70, Zfond1-140+40>
}
#end

//===================================
//	TABLE DE CHEVET
//===================================
#if (Use_Bureau)

object { Chevet rotate y*2 translate <Xfond2-81-41, 0, Zfond1-32>}

#if (Use_Books)
object {
	#declare rd=seed(13);
	mBook(3,20,15, 0, 3)
	rotate z*90
	rotate y*12
	translate (hautC12+hautC3)*y + 22*x - 1*z
	translate <Xfond2-81-41, 0, Zfond1-32>
}

#end

#end


//===================================
//	ETAGERES
//===================================
#if (Use_Bureau)

object { Etageres rotate y*.1 translate <Xfond1+2, 0, Zfond1-21>}

#local htE1 = 90;
#local htE2 = 15;
#local htE3 = 30;
#local epE = 2;

#if (Use_Books)

#include "MakeShelf.inc"

// mShelf(xShelf,yShelf,zShelf,nSet,typeShelf,slackShelf,xBook,sdxBook,sdyBook,sdzBook)
#declare typeBook = 0;
object {
	mShelf(60,25,20,3,1,0.3,4,.3,5,3)
	translate <Xfond1+2, 0, Zfond1-21>
	translate 2*epE*x + (htE2+2*htE3+epE)*y + 18*z
}
object {
	mShelf(120-3*epE,25,20,4,1,0.8,4,.3,5,3)
	translate <Xfond1+2, 0, Zfond1-21>
	translate 2*epE*x + (htE2+htE3+epE)*y + 18*z
}
#end

#if (Use_Teddy)
#include "teddy.inc"
object { TeddyB translate <Xfond1+2, 0, Zfond1-21> translate <55+2*epE, (htE2+2*htE3+epE), 9>  }
#end


#if (Use_Pendule)
#include "pendule.inc"
object { Pendule rotate 5*y translate <Xfond1+2, 0, Zfond1-21> translate <85+2*epE, (htE2+2*htE3+epE), 10> }
#end


#if (Use_HeartBox)
#include "HeartBox.inc"
object { HeartBox
	translate <Xfond1+2, 0, Zfond1>
	translate <32+2*epE, (htE2+epE), 0>
}
#end

#if (Use_Miroir)
#include "miroir.inc"
object { Miroir
	rotate 12*x
	translate <Xfond1+2, 0, Zfond1>
	translate <45+2*epE, (htE2+epE), -htM*sin(radians(12))>
}
#end

#if (Use_Boites)
#include "boites.inc"
object { BoiteBiscuits(21, 8, 15, <1.1,1.1,1.1>, "boite1")
	rotate 5*y
	translate <Xfond1+2, 0, Zfond1>
	translate <68+2*epE, (htE2+epE), -19>
}
object { BoiteBiscuits(21, 8, 15, <1.1,0.8,0.7>, "boite2")
	rotate -5*y
	translate <Xfond1+2, 0, Zfond1>
	translate <92+2*epE, (htE2+epE), -19>
}
object { BoiteBiscuits(21, 8, 15, <1.1,1.1,0.8>, "boite3")
	rotate -2*y
	translate <Xfond1+2, 0, Zfond1>
	translate <81+2*epE, (htE2+epE)+8+(15/15)-(15/100), -18>
}
#end

#end


//===================================
//	TABOURET
//===================================
#if (Use_Tabouret)

#include "tabouret.inc"
object { EnsempleTabouretRobe
	rotate -15*y
	translate <Xfond1+100, 0, Zfond1-140+10>
}

#else
union {
	cylinder { 33*y, 40*y, 15 }
	intersection {
		cylinder { -5*y, 35*y, 3 translate -35*y rotate x*20 translate 35*y - 10*z }
		box { <-3.1, 0, -25>, <3.1, 40, 0> }
	}
	intersection {
		cylinder { -5*y, 35*y, 3 translate -35*y rotate x*20 translate 35*y - 10*z }
		box { <-3.1, 0, -25>, <3.1, 40, 0> }
		rotate y*120
	}
	intersection {
		cylinder { -5*y, 35*y, 3 translate -35*y rotate x*20 translate 35*y - 10*z }
		box { <-3.1, 0, -25>, <3.1, 40, 0> }
		rotate -y*120
	}
	rotate y*15
	texture { T_Wood22 }
	translate <Xfond1+100, 0, Zfond1-140+10>
}
#end

//===================================
//	POT DE CHAMBRE, ETC
//===================================
#if (Use_Pot)

#declare Pot = #include "PotChambre.inc"
object { Pot scale 1.25 rotate -y*88 translate <Xfond2-81+15, .1, Zfond1-150>}

#end

#if (Use_Carafe)

#declare Carafe = #include "carafe.inc"
#declare Bassinoire = #include "bassinoire.inc"
union {
	object {Carafe}
	object {Bassinoire}
	rotate y*15
	translate <Xfen1-55, .1, Zfond1-25>
}

#end

//===================================
//	GODASSES
//===================================
#if (Use_Chaussures)
#include "Chaussures.inc"
object {
	Chaussures
	rotate -15*y
	translate <Xfond1 + 115, .1, Zfond1-140-50>
}
#end

#if (Use_Sandales)
#include "Sandale.inc"
object {
	Sandales
	rotate 10*y
	translate <Xfond2 - 100, .1, Zfond1-115>
}
object {
	Sandales
	rotate 5*y
	scale <1,1,-1>
	translate <Xfond2 - 100, .1, Zfond1-115>
}
#end


//===================================
//	Icones
//===================================
#if (Use_Icones)

#include "icons.inc"

// une sur le mur de gauche
object {
	Icone(15, 15*341/256, 3, 1, "icon01_256x341", T_Wood10)
	rotate -90*y
	rotate -z*1
	translate <Xfond1, 115, Zfond1-140+45>
}

#if (Use_Bureau)
// une sur l'etagere
object {
	Icone(14, 14*235/185, 2, 1, "icon02_185x235", T_Wood8)
	rotate x*10
	translate <Xfond1+2, 0, Zfond1> translate <90+2*epE, (htE2+2*htE3+epE), -(4+14*235/185)*sin(radians(10))>
}

// une sur la table de chevet
object {
	Icone(10, 10*276/100, 2, 1, "icon03_100x276", T_Wood32)
	rotate x*12
	translate (hautC12+hautC3)*y + 15*x - (4+10*276/100)*sin(radians(12))*z
	translate <Xfond2-81-41, 0, Zfond1-32>
}
#end

#end

//===================================
//	Eve
//===================================

#if (Use_Eve)

#include "Pepette.inc"
object { Eve
    scale 100
    rotate -170*y
    translate <Xfen1-10, 0, Zfond1-70>
}    

#end
