#version unofficial megapov 0.6;

#include "colors.inc"
#include "woods.inc"
#include "metals.inc"

#declare test_tables_inc = off;


#macro BarreChanfrein(Lng, Ht, Lrg, Ch)

difference {
    box { 0, <Lng, Ht, Lrg> }
    plane { x, 0 rotate  z*45 translate <0, Ch, 0> }
    plane { x, 0 rotate -z*45 translate <0, Ht-Ch, 0> }
    plane { -x, 0 rotate z*45 translate <Lng, Ht-Ch, 0> }
    plane { -x, 0 rotate -z*45 translate <Lng, Ch, 0> }
    plane { y, 0 rotate  x*45 translate <0, Ch, 0> }
    plane { y, 0 rotate -x*45 translate <0, Ch, Lrg> }
    plane { -y, 0 rotate x*45 translate <0, Ht-Ch, Lrg> }
    plane { -y, 0 rotate -x*45 translate <0, Ht-Ch, 0> }
    plane { z, 0 rotate  y*45 translate <0, 0, Ch> }
    plane { z, 0 rotate -y*45 translate <Lng, 0, Ch> }
    plane { -z, 0 rotate y*45 translate <Lng, 0, Lrg-Ch> }
    plane { -z, 0 rotate -y*45 translate <0, 0, Lrg-Ch> }
	bounded_by {box {<-.001, -.001, -.001>, <Lng+.001, Ht+.001, Lrg+.001>}}
}

#end


//===================================
//	BUREAU
//===================================

#declare Bureau = union {

    // planche
    union {
		// box { <0, 65, 0>, <60, 70, 100> }
	    union {
			object { BarreChanfrein(14.9, 5, 99.9, .5) translate -50*z rotate  .2*x rotate    -z translate 49.98*z }
			object { BarreChanfrein(14.9, 5,100.1, .5) translate -50*z rotate -.1*x rotate  .5*z translate 50.02*z + 15*x }
			object { BarreChanfrein(14.9, 5, 99.9, .5) translate -50*z rotate  .1*x rotate -.5*z translate 50.00*z + 30*x }
			object { BarreChanfrein(14.9, 5,100.0, .5) translate -50*z rotate -.2*x rotate  .5*z translate 49.97*z + 45*x }
			texture { T_Wood22 scale 10 }
		}

		union {
			object { BarreChanfrein(50, 3, 10, .5) translate -25*x rotate  .2*z translate 30*x + 5*z -3*y }
			object { BarreChanfrein(50, 3, 10, .5) translate -25*x rotate  -.3*z translate 30*x + 85*z -3*y }
			texture { T_Wood22 scale 10 rotate y*89 }
		}
		translate 65*y
	}

    // pieds
	object { BarreChanfrein(5, 63, 8, .5) rotate  x*.2 rotate  y*1 translate  6*z + 10*x }
	object { BarreChanfrein(5, 63, 8, .5) rotate -x*.1 rotate -y*2 translate 86*z + 10*x }
	object { BarreChanfrein(5, 63, 8, .5) rotate -z*.1 rotate -y*1 translate  6*z + 45*x }
	object { BarreChanfrein(5, 63, 8, .5) rotate  z*.2 rotate  y*2 translate 86*z + 45*x }

	object { BarreChanfrein(32, 3, 7, .3) translate  6.5*z + 14*x + 10*y }
	object { BarreChanfrein(32, 3, 7, .3) translate 86.5*z + 14*x + 10*y }

	texture { T_Wood22 scale 10 rotate x*87}
}



//===================================
//	TABLE DE CHEVET
//===================================

#declare hautC1 = 30;
#declare hautC2 = 20;
#declare hautC12 = hautC1 + hautC2;
#declare hautC3 = 1;
#declare xC1 = 30;
#declare zC1 = 20;
#declare epC = 1;
#declare xP1 = 3;
#declare zP1 = 3;

#declare Tiroir = union {
	box { <xP1*.5, 0, 0>, <xC1-xP1*.5, hautC2-.1, -epC+.1> }
	difference {
		box { <epC+xP1*.5, epC, 0>, <xC1-xP1*.5-epC, hautC2-epC, zC1-2*epC> }
		box { <2*epC+xP1*.5, 2*epC, epC>, <xC1-xP1*.5-2*epC, hautC2, zC1-3*epC> }
	}
	union {
		cylinder { 0, -1.5*epC*z, epC*.4 }
		sphere { 0, epC scale <1,1,.5> translate -1.5*epC*z }
		translate <xC1/2, hautC2/2, -epC/2>
	}
	texture { T_Wood22 scale 10 rotate x*87 }
}

#declare Chevet = union {
	// pieds
	object { BarreChanfrein(xP1, hautC12, zP1, xP1*.05) translate .1*x+.1*z}
	object { BarreChanfrein(xP1, hautC12, zP1, xP1*.05) translate (xC1-xP1-.1)*x +.1*z}
	object { BarreChanfrein(xP1, hautC12, zP1, xP1*.05) translate .1*x + (zC1-zP1-.1)*z }
	object { BarreChanfrein(xP1, hautC12, zP1, xP1*.05) translate (xC1-xP1-.1)*x + (zC1-zP1-.1)*z }
	// cotes
	box { <.2, hautC1, zP1-.1>, <epC, hautC12, zC1-zP1+.1> }
	box { <xC1-.2, hautC1, zP1-.2>, <xC1-epC, hautC12, zC1-zP1+.1> }
	box { <xP1-.1, hautC1, zC1-.2>, <xC1-xP1+.1, hautC12, zC1-epC> }
	// dessus
	object { BarreChanfrein(xC1+epC, hautC3, zC1+epC, hautC3*.05) translate <-epC/2, hautC12, -epC/2> texture { T_Wood22 scale 10 } }
	object { Tiroir rotate y*1 translate <0, hautC1, -5> }
	texture { T_Wood22 scale 10 rotate x*87 }
}


//===================================
//	ETAGERES
//===================================

#local lngE1 = 120;
#local lrgE1 = 20;
#local htE1 = 90;
#local htE2 = 15;
#local htE3 = 30;
#local epE = 2;

#declare T_WoodE = texture { T_Wood26 scale 10 }

#declare Etagere1 = union {
	object { BarreChanfrein(lngE1-4*epE-.4, epE, lrgE1, epE*.1) translate (2*epE+.2)*x }
	object { BarreChanfrein(2*epE+.4, epE, lrgE1-6*epE-.2, epE*.1) translate (3*epE+.1)*z }
	object { BarreChanfrein(2*epE+.4, epE, lrgE1-6*epE-.2, epE*.1) scale <-1,1,1> translate lngE1*x + (3*epE+.1)*z }
}

#declare Montant1 = difference {
	object { BarreChanfrein(epE, htE1, lrgE1, epE*.1) }
	box { 0, <epE+.2, epE+.2, lrgE1-6*epE> translate <epE-.1, htE2, 3*epE> }
	box { 0, <epE+.2, epE+.2, lrgE1-6*epE> translate <epE-.1, htE2+htE3, 3*epE> }
	box { 0, <epE+.2, epE+.2, lrgE1-6*epE> translate <epE-.1, htE2+2*htE3, 3*epE> }
}

#declare Etageres = union {
	object { Montant1 translate epE*x texture { T_WoodE rotate x*87  } }
	object { Montant1 translate (lngE1-2*epE)*x texture { T_WoodE rotate x*87 } }
	object { Etagere1 translate htE2*y texture { T_WoodE rotate x*87 rotate y*90 } }
	object { Etagere1 translate (htE2+htE3)*y texture { T_WoodE rotate x*87 rotate y*90 } }
	object { Etagere1 translate (htE2+2*htE3)*y texture { T_WoodE rotate x*87 rotate y*90 } }
}

//============================
// SCENE DE TEST
//============================

#if (test_tables_inc)

//===================================
//	LIGHTS
//===================================

light_source { <300, 400, -200> color rgb<1, .95, .85>*2
	spotlight
	radius 10
	falloff 20
	point_at <40, 30, 90>
}

light_source { <30, 50, -130>, color rgb<.45,.55,1>*.45 shadowless }


//===================================
//	CAMERA
//===================================

camera {
	location <50, 110, -100>
	right x*4
	up y*3
	angle 40
	look_at <25, 50, 100>
}

plane { y, 0
	texture { T_Wood21 scale 250 }
}

plane { -z, 0
	texture { pigment { rgb .75 } }
	translate 185*z
}

plane { x, 0
	texture { pigment { rgb .75 } }
	translate -100*x
}

//fog { fog_type 1 color rgb 0 distance 3000 }

//object { Bureau }
//object { Chevet }
object { Etageres translate 100*z - 50*x }

#include "MakeShelf.inc"
#include "MakeBook.inc"

// mShelf(xShelf,yShelf,zShelf,nSet,typeShelf,slackShelf,xBook,sdxBook,sdyBook,sdzBook)

#declare typeBook = 0;
object {
	mShelf(80,25,20,3,1,0.3,4,.3,5,3)
	translate 100*z - 50*x
	translate 2*epE*x + (htE2+2*htE3+epE)*y + 18*z
}
object {
	mShelf(120-3*epE,25,20,4,1,0.7,4,.3,5,3)
	translate 100*z - 50*x
	translate 2*epE*x + (htE2+htE3+epE)*y + 18*z
}


#end
