#include "colors.inc"
#include "textures.inc"

#declare debugMode=0;

#declare gaussStat = array[9] {0.0,0.1,0.5,0.9,1.0,0.9,0.5,0.1,0.0} // Gauss-like

#if (debugMode>0)
camera {
  location <0, 3, -5>
  look_at <0, 3.5, 0.5>
  scale 1
}
background { color Black }

// light_source { <50, 200, -100> colour White }
/*
light_source { <0, 15, 0> colour Gray80 
    fade_power 1
    fade_distance 10
}
light_source { <0.8, 16, -0.1> colour Gray30 
    fade_power 1
    fade_distance 10
}
light_source { <-0.3, 17, 0.6> colour Gray30 
    fade_power 1
    fade_distance 10
}
*/
#end

#declare rs = seed(2);
#declare bhrs = seed(111);

#macro leftpart(size)
bicubic_patch {
//#declare radius
    type 1 flatness 0.001 u_steps 3 v_steps 3,
    // from top to bottom, from left to right
    <-0.3, 3.1, 0.3>
    <-0.3, 3.2, 0>
    < -0.3, 3.2, -0.5>
    < 0, 3.3, -0.5>
    // second row
    #if (holdsSomething>0)
    <-1.5, 2, 1>
    <  -1, 2, 0>
    <-0.5, 2, -0.5>
    <   0, 2, -0.5>
    #else
    <  -1, 2, 1>
    <-1.7, 2, 0.4>
    <-0.8, 2, -0.5>
    <   0, 2, -0.5>
    #end
    // third row
    <-0.7, 1, 0.7>
    <-0.5, 1, 0>
    <-0.3, 1, -0.5>
    < 0.0, 1, -0.5>
    // fourth row
    <-1.5, 0, 0.5>
    <-1.0, 0, 0>
    <-0.5, 0, -0.5>
    < 0.0, 0, -0.5>
}
#end

#macro forepart(size)
bicubic_patch {
//#declare radius
    type 1 flatness 0.001 u_steps 3 v_steps 3,
    // from top to bottom, from left to right
    <-0.3, 3.15, 0.3>
    <-0.2, 3.05, 0.5>
    < 0.2, 3.05, 0.5>
    < 0.3, 3.15, 0.3>
    // second row
    <-0.7, 2, 0.6>
    <-0.3, 2, 0.7>
    < 0.3, 2, 0.7>
    < 0.7, 2, 0.6>
    #declare rm=rand(rs)*0.8-0.2;
    // third row
    <-0.7, 1+rm/2, 0.5>
    <-0.3, 1-rm/4, 0.7>
    < 0.3, 1-rm/4, 0.7>
    < 0.7, 1+rm/2, 0.5>
    // fourth row
    <-1.0, 0+rm, 0.4>
    < 0.5, 0-rm/2, 0.8>
    < 0.5, 0-rm/2, 0.8>
    < 1.0, 0+rm, 0.4>
}
#end


#macro et()
union {
    union {
        sphere {
            <0,0,0> 0.1
            translate <0.13,3.51,0.3>
        }
        sphere {
            <0,0,0> 0.1
            translate <-0.13,3.51,0.3>
        }
        pigment {color Gray40}
        finish {
            phong 0.9
        }
    }
union {
    sphere {
        <0,3.5,0> 0.4
    }       
    sphere {
        <0,2,0> 1
        scale <0.4,1.2,0.3>
    }
    // legs
    sphere {
        <0,0,0> 1
        scale <0.2,1,0.2>
        rotate z*-15
        translate <-0.4,0.76,0>
    }
    sphere {
        <0,0,0> 1
        scale <0.2,1,0.2>
        rotate z*15
        translate <0.4,0.76,0>
    }
    // arms
    sphere {
        <0,0,0> 0.6
        scale <0.2,0.8,0.2>
        rotate x*-20
        rotate z*-20
        translate <-0.4,2.6,0.16>
    }
    sphere {
        <0,0,0> 0.6
        scale <0.2,0.8,0.2>
        rotate x*-20
        rotate z*20
        translate <0.4,2.5,0.16>
    }
    // forearm
        sphere {
            <0,0,0> 0.4
            scale <0.2,1,0.2>
            rotate x*-30
            rotate z*20
            translate <0.66,2.1,0.46>
        }
    #if (rand(bhrs) <0.15)
        sphere {
            <0,0,0> 0.4
            scale <0.2,1,0.2>
            rotate x*-30
            rotate z*-20
            translate <-0.66,2.1,0.46>
        }
        #declare holdsSomething=0;
    #else
        sphere {
            <0,0,0> 0.4
            scale <0.2,1,0.2>
            rotate x*30
            rotate z*20
            translate <-0.66,2.44,0.46>
        }
        #declare holdsSomething=1;
    #end
    pigment {color rgb <1,0.6,0.3>}
    normal {
        bumps
        scale 0.08    
        bump_size 0.18
    }
}
#if (holdsSomething>0)
    union {
        #declare rr=0.02+rand(bhrs)*0.03;
        #declare endP=2.7;
        #declare innerRadius=0.15;
        cylinder {
            <0,0,0> <0,endP,0> rr
        }
        difference {
            torus {
                innerRadius, rr
                rotate x*90
            }
            cylinder {
                <0,0,0> <-2,0,0> 1
            }
            translate <0,innerRadius-rr,0>
            rotate z*(30*rand(bhrs)+20)
            translate <0,endP,0>
            rotate y*rand(bhrs)*360
        }
        translate <-0.8,0,0.62+rr>
        pigment {
            Dark_Wood
        }
    }
#end
}
#end

#macro cap()
union{
    #declare r=0.4;
    #declare rm=0.025;
    #declare pos=<0,0,0>;
    #declare dPos=<0,0.05,-0.008>;
    #declare ddPos=<0.005 *(rand(rs)-0.5),-0.001,-0.008 * rand(rs)>;
    #while (r > 0)
        cone {
             pos, r, pos+3*dPos, r-rm
        }
        #declare pos=pos+dPos;
        #declare dPos=dPos+ddPos;
        #declare r=r-rm;
    #end
    sphere {
        pos, 0.15
        pigment {lastPigment}
        normal {
            bumps
            scale 0.02    
            bump_size 1
        }
    }
    pigment {
        lastPigment
        /*
        #alternative (rand(rs))
        #case (0.2) Blue
        #case (0.2) Magenta
        #case (0.2) Cyan
        #case (0.2) White
        #case (0.2) Black
        #end
        */
    }
}
#end

#macro buddy(size)
#if (layoutUp.y < 0.6)
    #declare layoutSuccess=0;
#end
#declare ls=sqrt((layoutPosition.x*layoutPosition.x)+(layoutPosition.z*layoutPosition.z));
#if (ls < 10)
    #declare layoutSuccess=0;
#end
#if (layoutPosition.y > 8)
    #declare layoutSuccess=0;
#end
union {
    object {et()}
    union {
        #declare lastPigment= 
            pigment {
                color rgb <0.5+rand(rs)*0.5,0.5+rand(rs)*0.5,0.5+rand(rs)*0.5>
                *0.6
            }
        object {leftpart(1) translate x*0.001}
        #declare holdsSomething=0;
        object {leftpart(1) scale <-1,1,1> translate x*-0.001}
        object {forepart(1)}
        pigment {
            lastPigment
        }
        normal { wrinkles 1 scale <0.24,3,0.35> translate z*1000*rand(rs)}
    }
    object {cap() translate y*3.6}
    scale size
    #if (rand(bhrs)>0.5)
        scale <-1,1,1>
    #end   
    #declare rotY=-90-180/pi*atan2(layoutPosition.z,layoutPosition.x);
    rotate y*(rotY + makevalue(gaussStat, 0, 30, rs))
}
#end

#if (debugMode>0)
#declare layoutPosition=<-1,0,-1>;
#declare layoutSuccess=1;
#declare layoutUp=<0,0,0>;

light_source { <0, 15, -10> colour White
    fade_power 1
    fade_distance 20
}
object {buddy(1)}
box {
    <-5+1,-10,-5/2+1> <5-1,0,5/2-1>
    pigment {color White}
}
#end
