#include "colors.inc"
#include "textures.inc"

#declare debugMode=0;

#declare gaussStat = array[9] {0.0,0.1,0.5,0.9,1.0,0.9,0.5,0.1,0.0} // Gauss-like

#if (debugMode>0)
camera {
  location <0, 1, -2>
  look_at <0, 0, 0>
  scale 1
}
background { color Black }

//light_source { <0, 0.5, 0> colour White }

light_source { <0, -15, 0> colour Gray80 
    fade_power 1
    fade_distance 10
}
/*
light_source { <0.8, 16, -0.1> colour Gray30 
    fade_power 1
    fade_distance 10
}
light_source { <-0.3, 17, 0.6> colour Gray30 
    fade_power 1
    fade_distance 10
}
*/
#end

#declare diamond=
intersection {
    #declare i=0;
    #declare ni=12;
    #while (i < ni)
        box {
            <0,0,-2> <4,4,2>
            rotate z*30
            rotate y*i/8*360
        }
        box {
            <0,0,-2> <4,4,2>
            rotate z*10
            translate <-0.295,0,0>
            rotate y*(i+0.5)/ni*360
        }
        box {
            <0,0,-2> <4,4,2>
            rotate z*-26
            translate <-0.73,0.17,0>
            rotate y*i/ni*360
            // pigment {color Red}
        }
        box {
            <0,0,-2> <4,4,2>
            rotate z*-70 
            translate <-0.5,0.8,0>
            rotate y*(i+0.5)/8*360
        }
        
        #declare i=i+1;
    #end
    box {
        <-2,0,-2> <2,0.9,2>
    }
    //scale <1,0.7,1>
     finish {
        ambient 0.8
        diffuse 0.1
        reflection 0.1
        // ior 1.45
        specular 0.8
        roughness 0.0003
        phong 1 
        phong_size 400
    }
    interior {
        ior 1.5
        //refraction 0.9
    }
    pigment {
        // rgbf <0.1, 0.7, 0.8, 0.8>
        rgbf <0.77, 0.98, 0.48, 0.5>
        //rgbf<1.0, 1.0, 1.0, 0.2>
    }
}

#if (debugMode>0)
    object {diamond translate y*-0.5 rotate y*10}
    box {<-10,-2,0> <10,5,1> pigment {color White } translate z*2}
#end