#include "colors.inc"
#include "textures.inc"
#include "golds.inc"
#include "stones.inc"


#declare camera_location = < 20, 20, -50> ;
#declare camera_look_at = < 0, 29, 10> ;
#declare effect_location = < -9, 40, 10> ;
#declare effect_type = "Sun"
#declare effect_colour = <0.8,0.498039,0.196078>;

#include "Lens.inc"

/*
camera{
    //location <0,55,10>
    location <20, 20, -50>
    //location <0,50,-50>
    //location <-8000,16000,-16000>
    look_at <0,29,10>
    //look_at <-8000,16000,-16000>
    
}
*/


#declare CornerStone = difference {
    box { <0,0,0>, <2,2,-2> }
    union {
        box { <-0.1,0,0>,<2.1,2.5,1>
            rotate x*15
            translate z*-3
        }
        box { <0,0,0.1>,<1,2.5,-2.1>
            rotate z*15
            translate x*2
        }
    }
}

#declare WallStone =  difference {
    box { <0,0,0>, <2,2,-2> }
    box { <-0.1,0,0>,<2.1,2.5,1>
            rotate x*15
            translate z*-3
        }
}

box {
    <-10000,1000,-10000>
    <10000,2000,10000>
    pigment {
      bozo
      turbulence 0.65
      octaves 6
      omega 0.7
      lambda 2
      scale 2000
      color_map {
          [0.0 0.1 color rgb <0.85, 0.85, 0.85>
                   color rgb <0.75, 0.75, 0.75>]
          [0.1 0.5 color rgb <0.75, 0.75, 0.75>
                   color rgbt <1, 1, 1, 1>]
          [0.5 1.0 color rgbt <1, 1, 1, 1>
                   color rgbt <1, 1, 1, 1>]
      }
      scale <0.5, 0.2, 0.5>
      translate <-800,0,-1000>
    }
    finish { ambient 1.5 } 
    //hollow on
}


light_source{ <-11000,18000,-16000> White }
light_source{ 
    <-80,160,-160> White 
    fade_distance 500 
} 

height_field {
    tga "hfgen.tga"
    smooth
    //normal { bumps 1 scale 1 }
    pigment {
        marble//gradient y
        rotate z*90
        scale .01
        turbulence .3
        color_map {
            [0  color NewTan*1.1 ]
            [.2 color NewTan*1.05 ]
            [.4 color NewTan ]
            [.6 color NewTan ]
            [.8 color NewTan*1.05 ]
            [1 color NewTan*1.1 ]
            
        }
    }
    translate <-.5, 0, -.5>
    scale <500, 200, 500>
    
}    

#declare Temple = difference {
    union {
        #declare ht=0;
        #declare dx=10;
        #declare dz=10;
        #while ( ht < 12 )
            object { CornerStone translate <dx,ht,-dz> }
            object { CornerStone rotate y*90 translate <-dx,ht,-dz>}
            object { CornerStone rotate y*-90 translate <dx,ht,dz>}
            object { CornerStone rotate y*180 translate <-dx,ht,dz>}
            #declare wdth=dx;
            #while ( wdth > 0 )
                object { WallStone translate <wdth-2.07,ht,-dz> }
                object { WallStone translate <-wdth,ht,-dz> }
                object { WallStone rotate y*90 translate <-dx,ht,-wdth+2.07> }
                object { WallStone rotate y*90 translate <-dx,ht,wdth> }
                object { WallStone rotate y*-90 translate <dx,ht,wdth-2.07> }
                object { WallStone rotate y*-90 translate <dx,ht,-wdth> }
                
                object { WallStone rotate y*180 translate <wdth,ht,dz> }
                object { WallStone rotate y*180 translate <-wdth+2.07,ht,dz> }
                #declare wdth=wdth-2.1;
            #end            
            #declare ht=ht+2.07;
            #declare dx=dx-(sin(34*.01745));
            #declare dz=dz-(sin(34*.01745));
        #end
        
        box { <-10,12,10>,<10,14,-10> 
            texture {
                brick texture {Starfield}, texture {T_Gold_1A}
                brick_size 2
                mortar .07
                rotate y*90
                translate x*-1
            } 
        } 
        sphere {<0,12,0>, 8} 
    }
    box { <-2.5,0,0>,<2.5,8,-12> }
    texture { T_Gold_2A }
}                  


#declare Stairs = union {
    #declare sz=41;
    #declare ht = 1;
    #while ( ht < 29 )
        box {
            <-sz,ht,-sz>
            <sz,ht+1,sz>
        }    
        #declare ht=ht+1;
        #declare sz=sz-1;
    #end
}


object {
    Temple
    translate <0,31,15>
    
}

object {
    Stairs
    translate <0,3,15>
    normal { bumps .2 scale .1 }
    pigment { color NewTan }
}     

     

sphere { 
    <-6000,8000,12000>,400
    pigment { color Gray70 }
    finish { diffuse 40 }
}

fog {
    distance 2000
    color SkyBlue 
    fog_type 2
    fog_offset 3000 
    fog_alt 1
  }


sphere {
        0, 1
        pigment { rgbt 1 }
        interior {
            media {
                emission color Gold*1
                intervals 10
                density {
                    spherical
                    scale 1
                    color_map {
                        [ 0 color rgb 0 ]
                        [ 1 color rgb 1 ]
                    }
                }
            }
        } 
    scale 800
    translate <-11000,18000,-16000>
    hollow
    }




