#declare AntLeg = union {
    cylinder{0, <0, 0, -0.5>, 0.075}
    sphere{<0, 0, -0.5>, 0.075}
    union{
        difference{
            sphere{0, 0.075 scale<1, 1, 10>}
            plane{z, 0}
        }              
        sphere{0, 0.075}
        translate -z*0.075*10
        rotate x*45
        translate -z*0.5
    }  
    union{   
        cone{0, 0.05, <0, 0, -0.8>, 0.06}
        sphere{0, 0.05}
        sphere{<0, 0, -0.8>, 0.06} 
        translate z*0.8
        rotate -x*45
        translate <0, -0.015, -1.59>
    }
    cone{0, 0.04, <0, 0, -0.3>, 0.05 rotate -x*30 translate<0, -0.03, -1.6>} 
    cone{0, 0.03, <0, 0, -0.2>, 0.05 rotate -x*15 translate<0, -0.18, -1.85>}
    cone{0, 0.03, <0, 0, -0.2>, 0.05 translate<0, -0.23, -2>}  
    sphere{<0, 0, -0.2>, 0.05 translate<0, -0.23, -2>}
} 

#declare Ant = union { 
    union { // back
        sphere{0, 0.5}
        difference {
            sphere{0, 0.5 scale <2, 1, 1>}
            plane{x, 0}
        }  
        texture{ 
            pigment{color rgb <0.55, 0.3, 0.2>} 
            finish{ambient 0 diffuse 0.7 phong 1 phong_size 30}
            normal {  
                quilted 0.4
                control0 0.67 control1 0.6
            }              
            scale <1, 1, 3>
            translate z*1
            scale<0.3, 1, 1>
        }
        scale <1, 0.8, 1>  
        translate y*0.5   
    }  
    
    union { // middle
        sphere{0, 0.4}
        difference {
            sphere{0, 0.4 scale <1.6, 1, 1>}
            plane{x, 0}
        }        
        texture{ 
            pigment{color rgb<0.65, 0.35, 0.2>} 
            finish{ambient 0 diffuse 0.7 phong 0.7 phong_size 30}
        } 
        
        scale<1, 0.7, 1>   
        translate <-1, 0.5, 0>   
    }  
        
    union { // head
        union {
            sphere{0, 0.4}
            difference {
                sphere{0, 0.4 scale <1.6, 1, 1>}
                plane{-x, 0}
            }               
            texture{ 
                pigment{color rgb<0.75, 0.35, 0.2>} 
                finish{ambient 0 diffuse 0.7 phong 1 phong_size 15}
            }
            
            scale<1, 0.8, 1>
        }   
        // eyes       
        union{
            sphere{0, 0.08 translate <0.1, 0.25, -0.3>}
            sphere{0, 0.08 translate <0.1, 0.25, 0.3>} 
            
            texture{ 
                pigment{color rgb 0} 
                finish{ambient 0 diffuse 0.7 phong 1 phong_size 10}
            } 
        }
        //moustache                   
        union {
            cylinder{0, <0, 0.5, 0>, 0.04}
            sphere{<0, 0.5, 0>, 0.04}  
            union{
                cone{0, 0.04, <-0.4, 0, 0>, 0.05}
                sphere{<-0.4, 0, 0>, 0.05}      
                rotate z*40
                translate y*0.5
            }
            
            rotate<-20, 0, -45>
            translate<-0.1, 0.25, -0.1>
        }
        union {
            cylinder{0, <0, 0.5, 0>, 0.04}
            sphere{<0, 0.5, 0>, 0.04}  
            union{
                cone{0, 0.04, <-0.4, 0, 0>, 0.05}
                sphere{<-0.4, 0, 0>, 0.05}      
                rotate z*40
                translate y*0.5
            }
            
            rotate<20, 0, -45>
            translate<-0.1, 0.25, 0.1>
        }
        
        rotate z*25
        translate <-1.65, 0.7, 0>   
    }        
    object{AntLeg rotate -y*45 translate<-0.9, 0.26, 0>}
    object{AntLeg rotate y*(180+45) translate<-0.9, 0.26, 0>}
    object{AntLeg rotate -y*10 translate<-0.94, 0.26, 0>}
    object{AntLeg rotate y*(180+10) translate<-0.94, 0.26, 0>} 
    object{AntLeg rotate y*45 translate<-0.94, 0.26, 0>}
    object{AntLeg rotate y*(180-45) translate<-0.94, 0.26, 0>}
    
    translate x*1
    
    texture{ 
        pigment{color rgb <0.55, 0.3, 0.2>} 
        finish{ambient 0 diffuse 0.7 phong 1 phong_size 30}
    } 
    scale 0.1
}   

#macro Crowd(rows, cols)
    #local cntr = 0;
    #local cntc = 0; 
	#local lseed = seed(1000);
	#local ang = 0;
	#local xc = 0; 
	#local zc = 0;
	#while (cntr < rows) 
	    #declare cntc = 0;
	    #while (cntc < cols)
	        #local rnd = rand(lseed);
	        #if(rnd > 0.5)  
	        	#local ang = 40*rnd;
	            #local xc = 0.4 * cntc + (0.15 * rnd); 
	            #local zc = 0.4 * cntr + (0.15 * rnd);
	        #else 
	        	#local ang = -50*rnd;
	            #local xc = 0.4 * cntc - (0.15 * rnd); 
	            #local zc = 0.4 * cntr - (0.15 * rnd);
	        #end 
	        object{
	            Ant 
	            rotate y*ang
	            translate <xc, 0, zc>
	        }
	        #local cntc = cntc + 1;
	    #end                  
	    #local cntr = cntr + 1;
	#end  
#end  

#declare AntRow = union{
    #local num = 20;
    #local cnt = 0;
	#local xc = 0; 
	#while (cnt < num) 
	    #local xc = cnt * 0.55;
	    object{
	        Ant
	        scale 1.5
	        translate <xc, 0, 0>
	    }
	    #local cnt = cnt + 1;
	#end  
}