//****************************************************************************
//
// Author: Ali Lakhia
// File:   lwalls.inc
// Date:   January 15th, 2001
//
//***************************************************************************/

// Constant variables
#declare Lower_lights_color = rgbft <170/255, 190/255, 170/255, 0, 200/255>;
#declare Wall_length = 1.56;
#declare Wall_depth = 1.4;
#declare Lower_wall_height = 2.4;

// Ceiling for lower section walls
#declare Lower_dome_ceiling = box
{
  <-Wall_length/2, -0.2, -Wall_depth/2>,
  <Wall_length/2, -0.16, Wall_depth/2>
}

// Lights for lower dome
#declare Lower_dome_lights = union
{
  #if (Extra_lights_on)
    light_source {
      <0, 0, 0> 
      color Lower_lights_color
      spotlight
      point_at <0, -2, 0>
      fade_distance 0.6
      fade_power 1
      radius ros
      falloff fos
      tightness 10
      media_attenuation on
    }
  #end
  
  difference
  {
      Create_halo(Lower_lights_color, 1, 1)
      box {
        <-.75, -0.02, -.75>, 
        <.75, -.75, .75>
        pigment { Clear }
      }
      no_shadow
      scale <.38, 2.5, .6>
      translate <0, -2.5, 0>
  }
}

// Dome for lower wall, that sits on lower ceiling. Create from top to bottom
#declare Lower_dome = union
{
  cylinder {
    <0, 0, 0>,
    <0, -0.16, 0>,
    0.6
    open
  }
  cone {
    <0, 0, 0>,
    0.6,
    <0, 0.6, 0>,
    0.04
    open
  }
  cone {
    <0, 0.6, 0>,
    0.04,
    <0, 0.76, 0>,
    0
    open
    texture { T_Gold_1B }
  }
  object {
    Lower_dome_ceiling
    texture { offwhite_concrete }
  }
  #if (Lights_on > 0)
    object {
      Lower_dome_lights
      translate <0, -0.2, 0>
    }
  #end
}

// Lower pillar
#declare Lower_pillar = union 
{
  cylinder {
    0,
    <0, 1.2, 0>,
    0.08
    open
  }
  torus { .08, 0.04 translate y*1.2 }
  texture { very_light_brown_concrete }
}

// Lower arch dentiles
#declare Lower_arch_dentile = box
{
  <-0.001, 0.001, -0.001>,
  <0.078, -0.11, 0.161>
}

// Macro for generating dentiles along positive x-axis.
#macro Lower_arch_dentiles (NumberOfDentiles)
  #declare NumberOfDentiles=NumberOfDentiles-1;
  #while (NumberOfDentiles >= 0)
    object {Lower_arch_dentile translate NumberOfDentiles*0.156*x}
    #declare NumberOfDentiles=NumberOfDentiles-1;
  #end
#end

// Lower arch with dentiles
#macro Lower_arch(Draw_wall_dentiles)
  difference
  {
    box {
      <0, 0, 0>,
      #if (Draw_wall_dentiles)
        <Wall_length, 1.2, 0.16>
      #else
        <Wall_length, 1.039, 0.16>
      #end
    }
    sphere {
      <0.16 + (Wall_length-0.16)/2, 0, 0>,
      0.7001
    }
    #if (Draw_wall_dentiles)
      union {
        Lower_arch_dentiles(10)
        translate <0, 1.2, 0>
      }
    #end
    texture {
      brown_tiled_concrete 
    }
  }
#end

// Lower section that contains pillar, arch, ceiling and dome, 
// without dentiles
#macro Lower_section(Draw_wall_dentiles)
  union
  {
    object {
      Lower_pillar
      translate <0.08, 0, 0.08>
    }
    object {
      Lower_arch(Draw_wall_dentiles)
      translate 1.2*y
    }
    object {
      Lower_dome
      texture { offwhite_concrete }
      translate <Wall_length/2, Lower_wall_height, 0.78>
    }
  }
#end

// Macro for generating sections along positive x-axis.
#macro Lower_wall (NumberOfSections, Draw_wall_dentiles)
  #local sections = NumberOfSections;
  #while (sections > 0)
    #declare sections=sections-1;
    object {
      Lower_section(Draw_wall_dentiles)
      translate <sections*Wall_length, 0, sections*0.0001>
    }
  #end
#end

// Macro for creating a wall that is generated along X & Z axis.
#macro Create_lower_wall(Number_x, Number_z)
  #local dentiles = 0;
  #local num_x = Number_x;
  #local num_z = Number_z;
  union
  {
    #while (num_z > 0)
      #local num_z = num_z-1;
      #if (num_z = 0)
        #local dentiles = 1;
      #end
      union {
        Lower_wall(num_x, dentiles)
        translate num_z*Wall_depth*z
      }
    #end
  }
#end

#if (!Draw_walls_lower)
  // Redefine macro to creating bounding box for testing
  #macro Create_lower_wall(Number_x, Number_z)
    box {
      0,
      <Number_x*Wall_length, Lower_wall_height, Number_z*Wall_depth>
    }
  #end
#end