#version unofficial megapov 0.6;

#include "metals.inc"

#declare AltarTex =
 texture {
  pigment {
   granite
   turbulence 0.7
   color_map {
    [0.00 color rgb<0.000, 0.000, 0.000>]
    [0.45 color rgb<0.078, 0.039, 0.067>]
    [0.45 color rgb<0.255, 0.294, 0.322>]
    [1.00 color rgb<0.157, 0.118, 0.129>]
   }
   scale <0.4, 0.4, 0.4>
  }
  finish {
   ambient 0.3
   brilliance 1.5
   specular 0.8 roughness 0.003
  }
  scale 0.5
 }
 texture {
  pigment {
   granite
   turbulence 0.2
   color_map {
    [0.00 color rgbf<0.659, 0.659, 0.698, 0.792>]
    [0.25 color rgbf<0.498, 0.498, 0.549, 0.949>]
    [0.25 color rgbf<1.000, 1.000, 1.000, 1.000>]
    [1.00 color rgbf<1.000, 1.000, 1.000, 1.000>]
   }
   translate <33.0, 20.0, 0.0>
   rotate <0.3, 0.2, 0.3>
  }
  finish {
   ambient 0.3
   brilliance 2.5
   specular 0.9 roughness 0.01
  } 
  scale 0.5
 }                          

// Black granite with red and gold flecks
#declare Black_Granite =
 texture {
  pigment {
   granite
   color_map {
    [0.00 color rgb<0.000, 0.000, 0.000>]
    [0.35 color rgb<0.000, 0.000, 0.000>]
    [0.50 color rgb<0.576, 0.169, 0.169>]
    [0.65 color rgb<0.000, 0.000, 0.000>]
    [1.00 color rgb<0.000, 0.000, 0.000>]
   }
  }
  finish {
   specular 0.75    roughness 0.01
  }
 }
 texture {
  pigment {
   granite
   color_map {
    [0.00 color rgbt<1.000, 1.000, 1.000, 1.000>]
    [0.15 color rgbt<1.000, 1.000, 1.000, 1.000>]
    [0.20 color rgbt<1.000, 0.827, 0.302, 0.2>]
    [0.25 color rgbt<1.000, 1.000, 1.000, 1.000>]
    [1.00 color rgbt<1.000, 1.000, 1.000, 1.000>]
   }
  }
  finish {       
   diffuse 0.6 brilliance 2
   specular 0.75 roughness 0.01        
  }
 }

#declare Black_Granite2 =
 texture {
  pigment {
   granite
   color_map {
    [0.00 color rgb<0.000, 0.000, 0.000>]
    [0.35 color rgb<0.000, 0.000, 0.000>]
    [0.50 color rgb<0.576, 0.169, 0.169>]
    [0.65 color rgb<0.000, 0.000, 0.000>]
    [1.00 color rgb<0.000, 0.000, 0.000>]
   }
  }
  finish {
   specular 0.5    roughness 0.002
  }
 }
 texture {
  pigment {
   granite
   color_map {
    [0.00 color rgbt<1.000, 1.000, 1.000, 1.000>]
    [0.15 color rgbt<1.000, 1.000, 1.000, 1.000>]
    [0.20 color rgbt<1.000, 0.827, 0.302, 0.2>]
    [0.25 color rgbt<1.000, 1.000, 1.000, 1.000>]
    [1.00 color rgbt<1.000, 1.000, 1.000, 1.000>]
   }
  }
  finish {       
   diffuse 0.6 brilliance 2
   specular 0.5 roughness 0.002        
  }
 }

#declare ShinyBladeTex = 
 texture {
  pigment {
    bozo
    turbulence 1.0 omega 1.0
    color_map {
      [0.00 color rgb<0.598, 0.598, 0.598>]
      [1.00 color rgb<1.000, 1.000, 1.000>]
    }
    scale <1.0, 50.0, 1.0>*0.1
  }
  finish {
    ambient 0.15
    diffuse 0.65
    brilliance 1.5
    specular 0.8 roughness 0.03
    reflection 0.85 
    metallic           
    reflect_metallic
  }
}

#declare BladeTex = 
 texture {
  pigment {
    bozo
    turbulence 1.0 omega 1.0
    color_map {
      [0.00 color rgb<0.598, 0.598, 0.598>]
      [1.00 color rgb<1.000, 1.000, 1.000>]
    }
    scale <1.0, 50.0, 1.0>*0.1
  }
  finish {
    ambient 0.15
    diffuse 0.65
    brilliance 1.5
    specular 0.7 roughness 0.06
    reflection 0.15
    metallic    
    reflect_metallic
  }
}

#declare RuneTex=
 texture {
  pigment { rgb <0.75,0,0.1> }
  finish {
   ambient 0.15
   diffuse 0.7
   reflection 0.2
   specular 0.7
   roughness 0.002
   metallic
  }
 }
 //texture {T_Gold_2B}

#declare Ruby= 
 material {
  texture {
   pigment {
    rgbf<0.7,0,0,0.4>
   }
   finish {
    specular 0.8
    roughness 0.001
    diffuse 0.6
    reflection 0.6
    ambient 0.3
   }
  }
  interior {ior 1.77}
 }

#declare T_LightWood =
texture {
  pigment {
    wood
    turbulence 0.15
    color_map
    {
      [0.00 color rgb<0.600, 0.400, 0.200>]
      [0.22 color rgb<0.600, 0.400, 0.200>]
      [0.34 color rgb<0.412, 0.227, 0.020>]
      [0.39 color rgb<0.514, 0.333, 0.153>]
      [0.63 color rgb<0.600, 0.400, 0.200>]
      [0.82 color rgb<0.412, 0.227, 0.020>]
      [1.00 color rgb<0.600, 0.400, 0.200>]
    }
    scale <1,1,30>
    translate <1.0, 0.0, 0.0>
  } 
  normal {
   wood 0.2 
   turbulence 0.02
  }
  finish {
    ambient 0.3
    diffuse 0.82
    phong 0.15    phong_size 10
  }
  scale <1.5, 1.5, 1.5> 
  rotate x*-90
}
texture {
  pigment
  {
    granite
    turbulence 1.0
    color_map
    {
      [0.00 color rgbf<0.498, 0.349, 0.000, 1.000>]
      [0.39 color rgbf<0.478, 0.329, 0.000, 1.000>]
      [0.60 color rgbf<0.478, 0.329, 0.000, 0.686>]
      [0.84 color rgbf<0.486, 0.337, 0.000, 0.486>]
      [0.94 color rgb<0.486, 0.337, 0.000>]
      [1.00 color rgb<0.498, 0.349, 0.000>]
    }
    scale <1.0, 15.0, 1.0>
  }
  finish {
    ambient 0.2
  }
}

#declare P_WoodGrain1A = pigment {
  wood
  turbulence 0.04
  octaves 3
  scale <0.15, .15, 1>
  rotate x*90
}

#declare M_Wood15A = colour_map {
  [0.00 0.25 color rgb < 0.504, 0.310, 0.078> * 0.7
  color rgb < 0.531, 0.325, 0.090> * 0.8 ]
  [0.25 0.40 color rgb < 0.531, 0.325, 0.090> * 0.8
  color rgb < 0.547, 0.333, 0.090> * 0.5 ]
  [0.40 0.50 color rgb < 0.547, 0.333, 0.090> * 0.5
  color rgb < 0.504, 0.310, 0.075> * 0.6 ]
  [0.50 0.70 color rgb < 0.504, 0.310, 0.075> * 0.6 
  color rgb < 0.559, 0.322, 0.102> * 0.4 ]
  [0.70 0.98 color rgb < 0.559, 0.322, 0.102> * 0.4
  color rgb < 0.531, 0.325, 0.086> * 0.4 ]
  [0.98 1.00 color rgb < 0.531, 0.325, 0.086> * 0.4
  color rgb < 0.504, 0.310, 0.078> * 0.7 ]
}

#declare P_WoodGrain1B = pigment {
  wood
  turbulence <0.1, 0.5, 1>
  octaves 5
  lambda 3.25
  scale <0.25, .25, 1>
  rotate <5, 10, 5>
  translate -x*2
  rotate x*90
}

#declare M_Wood15B = colour_map {
  [0.00 0.25 color rgbt < 0.404, 0.210, 0.078, 0.20>
  color rgbt < 0.431, 0.225, 0.090, 0.80>]
  [0.25 0.40 color rgbt < 0.431, 0.225, 0.090, 0.80>
  color rgbt < 0.447, 0.233, 0.090, 0.20>]
  [0.40 0.50 color rgbt < 0.447, 0.233, 0.090, 0.20>
  color rgbt < 0.404, 0.210, 0.075, 0.60>]
  [0.50 0.70 color rgbt < 0.404, 0.210, 0.075, 0.60>
  color rgbt < 0.459, 0.222, 0.102, 0.20>]
  [0.70 0.98 color rgbt < 0.459, 0.222, 0.102, 0.20>
  color rgbt < 0.431, 0.225, 0.086, 0.40>]
  [0.98 1.00 color rgbt < 0.431, 0.225, 0.086, 0.40>
  color rgbt < 0.404, 0.210, 0.078, 0.10>]
}

#declare T_DarkWood = 
 texture {
  pigment {
   P_WoodGrain1A 
   color_map {
    M_Wood15A 
   }
  }
 }
 texture {
  pigment {
   P_WoodGrain1B 
   color_map {
    M_Wood15B 
   }
  }
 }
                                   
#declare Leather = 
 texture {
  pigment {rgb <0.85,0.53,0.10>*0.6}
  finish {
   ambient < 0.200, 0.200, 0.200 >
   diffuse 0.50
   brilliance 1.00
   phong 0.20
   phong_size 50.00
   crand 0.100
  }
 }                                   

#declare Leather2 = 
 texture {
  pigment {VeryDarkBrown*0.6}
  finish {
   ambient 0.2
   diffuse 0.50
   brilliance 1.00
   phong 0
   phong_size 50.00
   crand 0.500
  }
  normal {
   bumps 0.1
   scale 0.1
  }
 }

#declare Mortar=   
 texture {
  pigment {rgb <0.9,0.9,1>}
  finish { ambient 0.15
           diffuse 0.45
           specular 0.1
           roughness 0.35
           crand 0.2
         }
 }

#declare BrickTextureArray=array[4]

// >>> TdG_Sandstone (from File "Sandstone.inc") <<<
#declare BrickTextureArray[0] = 
 texture {
  pigment {
    granite
    pigment_map {
      [0.000 color rgb <0.996, 0.969, 0.8>]
      [0.154 color rgb <0.996, 0.682, 0.604>]
      [0.308 color rgb <0.906, 0.82, 0.714>]
      [0.444 color rgb <0.816, 0.631, 0.537>]
      [0.615 color rgb <0.89, 0.792, 0.675>]
      [0.812 color rgb <0.973, 0.627, 0.627>]
      [1.000 color rgb <0.996, 0.969, 0.8>]
    }
    turbulence 0.6
    ramp_wave
    scale <200.0, 3.0, 150.0>
    rotate -5.0 * z
  }
  normal {
    bozo , 5.0
    bump_size 0.8
    turbulence 0.7
    ramp_wave
    rotate -90.0 * x
  }
 }
 texture {
  pigment {
    granite
    pigment_map {
      [0.000 color rgb <0.027, 0.012, 0.012>]
      [0.034 color rgbf <0.851, 0.812, 0.741, 0.235>]
      [0.342 color rgbf <0.71164, 0.694, 0.82, 0.839>]
      [0.462 color rgbf <0.631, 0.506, 0.471, 0.608>]
      [0.632 color rgbf <0.851, 0.812, 0.741, 0.922>]
      [0.983 color rgb <0.027, 0.012, 0.012>]
      [1.000 color rgb <0.996, 0.969, 0.8>]
    }
    turbulence 0.6
    ramp_wave
    scale <150.0, 3.0, 200.0>
    rotate <5.0, -10.0, 0.0>
  }
  normal {
    bozo , 5.0
    bump_size 0.8
    turbulence 0.8
    ramp_wave
    rotate -90.0 * x
  }
 }
 texture {
  pigment {
    granite
    pigment_map {
      [0.000 color rgbf <0.0, 0.0, 0.0, 0.6>]
      [0.040 color rgbf <0.0, 0.0, 0.0, 1.0>]
      [0.041 color rgbf <0.55, 0.09, 0.09, 0.8>]
      [0.970 color rgbf <0.33, 0.33, 0.33, 0.9>]
      [0.971 color rgbf <0.0, 0.0, 0.0, 0.9>]
      [1.000 color rgbf <0.0, 0.0, 0.0, 1.0>]
    }
    turbulence 0.85
    ramp_wave
    scale <1.0, 2.0, 1.4>
    rotate <-10.0, 0.0, 20.0>
  }
  finish {
    phong 0.1 phong_size 10
    brilliance 3
  }
 }

// >>> T_Stone12 (from File "stones1.inc") <<<

// Constants from file "stones1.inc"
#declare T_Grnt23 = texture {
  pigment {
    marble
    turbulence 0.5
    color_map {
      [0.000, 0.178 color rgbf <0.831, 0.631, 0.569, 0.000>
      color rgbf <0.925, 0.831, 0.714, 0.000>]
      [0.178, 0.356 color rgbf <0.925, 0.831, 0.714, 0.000>
      color rgbf <0.871, 0.702, 0.659, 0.000>]
      [0.356, 0.525 color rgbf <0.871, 0.702, 0.659, 0.000>
      color rgbf <0.831, 0.631, 0.569, 0.000>]
      [0.525, 0.729 color rgbf <0.831, 0.631, 0.569, 0.000>
      color rgbf <0.937, 0.882, 0.820, 0.000>]
      [0.729, 1.001 color rgbf <0.937, 0.882, 0.820, 0.000>
      color rgbf <0.831, 0.631, 0.569, 0.000>]
    }
  }
}
#declare T_Grnt0a = texture {
  pigment {
    granite
    turbulence 0.6
    color_map {
      [0.000, 0.153 color rgbf <0.729, 0.502, 0.451, 0.306>
      color rgbf <0.769, 0.686, 0.592, 0.792>]
      [0.153, 0.398 color rgbf <0.769, 0.686, 0.592, 0.792>
      color rgbf <0.843, 0.753, 0.718, 0.396>]
      [0.398, 0.559 color rgbf <0.843, 0.753, 0.718, 0.396>
      color rgbf <0.780, 0.667, 0.561, 0.976>]
      [0.559, 0.729 color rgbf <0.780, 0.667, 0.561, 0.976>
      color rgbf <0.741, 0.659, 0.576, 0.820>]
      [0.729, 1.001 color rgbf <0.741, 0.659, 0.576, 0.820>
      color rgbf <0.729, 0.502, 0.451, 0.306>]
    }
  }
}

#declare BrickTextureArray[1] = 
 texture {
  T_Grnt23 scale <1, 5, 1> rotate <0, 0, 50>
  finish {
    ambient 0.2 crand 0.03
  }
 }
 texture {
  T_Grnt0a scale <1, 3, 2> rotate <0, 0, -30>
  finish {
    phong 1.0 phong_size 90
  }
 }


// >>> T_Stone4 (from File "stones1.inc") <<<

// Constants from file "stones1.inc"
#declare T_Grnt6 = texture {
  pigment {
    granite
    turbulence 0.5
    color_map {
      [0.000, 0.153 color rgbf <0.545, 0.380, 0.345, 0.000>
      color rgbf <0.588, 0.475, 0.333, 0.000>]
      [0.153, 0.398 color rgbf <0.588, 0.475, 0.333, 0.000>
      color rgbf <0.675, 0.478, 0.404, 0.000>]
      [0.398, 0.559 color rgbf <0.675, 0.478, 0.404, 0.000>
      color rgbf <0.757, 0.635, 0.522, 0.000>]
      [0.559, 0.729 color rgbf <0.757, 0.635, 0.522, 0.000>
      color rgbf <0.659, 0.549, 0.443, 0.000>]
      [0.729, 1.001 color rgbf <0.659, 0.549, 0.443, 0.000>
      color rgbf <0.545, 0.380, 0.345, 0.000>]
    }
  }
} 

#declare T_Grnt10a = texture {
  pigment {
    granite
    turbulence 0.6
    color_map {
      [0.000, 0.179 color rgbf <0.843, 0.655, 0.655, 0.455>
      color rgbf <0.886, 0.769, 0.627, 0.608>]
      [0.179, 0.368 color rgbf <0.886, 0.769, 0.627, 0.608>
      color rgbf <0.906, 0.820, 0.714, 0.392>]
      [0.368, 0.538 color rgbf <0.906, 0.820, 0.714, 0.392>
      color rgbf <0.851, 0.671, 0.671, 0.659>]
      [0.538, 0.744 color rgbf <0.851, 0.671, 0.671, 0.659>
      color rgbf <0.890, 0.792, 0.675, 0.392>]
      [0.744, 0.983 color rgbf <0.890, 0.792, 0.675, 0.392>
      color rgbf <0.827, 0.612, 0.612, 0.706>]
      [0.983, 1.001 color rgbf <0.827, 0.612, 0.612, 0.706>
      color rgbf <0.843, 0.655, 0.655, 0.455>]
    }
  }
}

#declare BrickTextureArray[2] = 
 texture {
  T_Grnt6 scale <1.5, 3, 2> rotate <0, 0, 40>
  finish {
   diffuse 0.5
  }
 }
 texture {
  T_Grnt10a scale <1, 3, 2> rotate <0, 0, -30>
  finish {
   phong 0.1 phong_size 10
   brilliance 3
  }
 }

#declare BrickTextureArray[3] = 
 texture {
  pigment {
   marble
   colour_map {
    [0.000 0.154 colour rgb<0.690,0.612,0.569> colour rgb<0.737,0.596,0.522>]
    [0.154 0.368 colour rgb<0.737,0.596,0.522> colour rgb<0.776,0.702,0.624>]
    [0.368 0.538 colour rgb<0.776,0.702,0.624> colour rgb<0.796,0.678,0.643>]
    [0.538 0.846 colour rgb<0.796,0.678,0.643> colour rgb<0.690,0.612,0.569>]
    [0.846 0.932 colour rgb<0.690,0.612,0.569> colour rgb<0.773,0.612,0.569>]
    [0.932 1.001 colour rgb<0.773,0.612,0.569> colour rgb<0.690,0.612,0.569>]
   }
   turbulence 0.4
  } 
  finish {
    phong 0.1 phong_size 10
    brilliance 3
  }
 }
