// Persistence Of Vision raytracer version 3.01g

// von Michael Laube

// Pergamon.pov

#include "shapes.inc"
#include "colors.inc"
#include "textures.inc"
#include "stones.inc"
#include "skies.inc"
#include "mauer.inc" // Wall.inc from unknown?
#include "finish.inc"
#include "my_columns.inc" // from the great Nathan OBrien

//****************  Kamera von oben  **********************
/*camera {
   direction <   0.0,   0.0,   1.5>
   up        <   0.0,   1.1,   0.0>
   right     <   1.3333,   0.0,   0.0>
   translate <   0.0, 1050.0,  120.0>
   look_at   <   0.0,   0.0,  120.1>
} */
//****************  Kamera von vorne  *********************
camera {
   //direction <   0.0,   0.0,   1.5>
   //up        <   0.0,   1.1,   0.0>
   right     <   1.33,    0.0,   0.0>
   translate < 0,  80, -350>//<   0.0,  80.0,-350.0 >
   look_at   < 0,  80,  170>
}
//****************  Kamera von innen  *********************
/*camera {
   direction <   0.0,   0.0,   1.5>
   up        <   0.0,   1.1,   0.0>
   right     <   1.3333,   0.0,   0.0>
   translate <-290.0,  10.0,  140.0>
   look_at   < 290.0,  10.0,  140.0>
}*/

//light_source { <0.0,  50.0,  500.0> colour White}
light_source { < 250.0,  300.0, -250.0> colour White}
light_source { <-250.0,  300.0, -250.0> colour White}

// A cloud texture by: Jussi Kantola
#declare CloudColors = color_map {
    [0.0 0.1 color SkyBlue color SkyBlue]
   [0.70 color rgb <4/5, 4/5, 5/6>]
   [1.0 color White]
}

#declare CloudTexture = texture {
   pigment{
      bozo
      turbulence 0.5
      octaves 3
      lambda 6
      color_map { CloudColors }
   }
   finish { ambient 1 diffuse 0 }
   scale 1/6
}
sphere {
   <0, 0, 0>, 1
   texture { CloudTexture }
   scale <18799.999237, 1879.999924, 18799.999237>
}
//----------------------------------------------------------------------
//                     Altar
//----------------------------------------------------------------------
#declare Stufen = object {     //Stairs
union {                        
box { <-205.0,  -1.0,   0.0>, < 205.0,   3.0, 350.0>texture { T_Stone17 scale <25,25,25>}}//Stufe 1
box { <-200.0,   3.0,   5.0>, < 200.0,   6.0, 345.0>texture { T_Stone8 scale <25,25,25>}}
box { <-195.0,   6.0,  10.0>, < 195.0,   9.0, 340.0>texture { T_Stone17 scale <25,25,25>}}
box { <-190.0,   9.0,  15.0>, < 190.0,  12.0, 335.0>texture { T_Stone8 scale <25,25,25>}}
box { <-117.0,  12.0,  20.0>, < 117.0,  15.0, 200.0>texture { T_Stone17 scale <25,25,25>}}
box { <-120.0,  15.0,  25.0>, < 120.0,  18.0, 200.0>texture { T_Stone8 scale <25,25,25>}}
box { <-120.0,  18.0,  30.0>, < 120.0,  21.0, 200.0>texture { T_Stone17 scale <25,25,25>}}
box { <-120.0,  21.0,  35.0>, < 120.0,  24.0, 200.0>texture { T_Stone8 scale <25,25,25>}}
box { <-120.0,  24.0,  40.0>, < 120.0,  27.0, 200.0>texture { T_Stone17 scale <25,25,25>}}
box { <-120.0,  27.0,  45.0>, < 120.0,  30.0, 200.0>texture { T_Stone8 scale <25,25,25>}}
box { <-120.0,  30.0,  50.0>, < 120.0,  33.0, 200.0>texture { T_Stone17 scale <25,25,25>}}
box { <-120.0,  33.0,  55.0>, < 120.0,  36.0, 200.0>texture { T_Stone8 scale <25,25,25>}}
box { <-120.0,  36.0,  60.0>, < 120.0,  39.0, 200.0>texture { T_Stone17 scale <25,25,25>}}
box { <-120.0,  39.0,  65.0>, < 120.0,  42.0, 200.0>texture { T_Stone8 scale <25,25,25>}}
box { <-120.0,  42.0,  70.0>, < 120.0,  45.0, 200.0>texture { T_Stone17 scale <25,25,25>}}
box { <-120.0,  45.0,  75.0>, < 120.0,  48.0, 200.0>texture { T_Stone8 scale <25,25,25>}}
box { <-120.0,  48.0,  80.0>, < 120.0,  51.0, 200.0>texture { T_Stone17 scale <25,25,25>}}
box { <-120.0,  51.0,  85.0>, < 120.0,  54.0, 200.0>texture { T_Stone8 scale <25,25,25>}}
box { <-120.0,  54.0,  90.0>, < 120.0,  57.0, 200.0>texture { T_Stone17 scale <25,25,25>}}
box { <-120.0,  57.0,  95.0>, < 120.0,  60.0, 200.0>texture { T_Stone8 scale <25,25,25>}}
box { <-120.0,  60.0, 100.0>, < 120.0,  63.0, 200.0>texture { T_Stone17 scale <25,25,25>}}
box { <-120.0,  63.0, 105.0>, < 120.0,  66.0, 200.0>texture { T_Stone8 scale <25,25,25>}}
box { <-120.0,  66.0, 110.0>, < 120.0,  69.0, 200.0>texture { T_Stone17 scale <25,25,25>}}
box { <-120.0,  69.0, 115.0>, < 120.0,  72.0, 200.0>texture { T_Stone8 scale <25,25,25>}}
box { <-120.0,  72.0, 120.0>, < 120.0,  75.0, 200.0>texture { T_Stone17 scale <25,25,25>}}
box { <-120.0,  75.0, 125.0>, < 120.0,  78.0, 200.0>texture { T_Stone8 scale <25,25,25>}}
}}

#declare Sockel1 = object { intersection {
box { < -35.0, 12.0,  20.0>,<   35.0,  15.0, 329.0>}
cylinder { < -35.1, 15.0,  20.0 > <  35.1,  15.0,  20.0 > 1.0 inverse}
cylinder { < -35.0, 15.0,  19.9 > < -35.0,  15.0, 329.1 > 1.0 inverse}
cylinder { <  35.0, 15.0,  19.9 > <  35.0,  15.0, 329.1 > 1.0 inverse}
cylinder { < -35.0, 15.0, 329.1 > <  35.0,  15.0, 329.1 > 1.0 inverse} 
}}
#declare Sockel1h = object { intersection {
box { < -120.0, 12.0,  250.0>,<  120.0,  15.0, 329.0>}
cylinder { < -120.0, 15.0, 329.1 > <  120.0,  15.0, 329.1 > 1.0 inverse}
}}
#declare Sockel2 = object {
box { <-33.8,  15.0,  21.2>, < 33.8, 33.0, 327.8>}
}
#declare Sockel2h = object {
box { <-120.0,  15.0, 250.0>, < 120.0, 33.0, 327.8>}
}
#declare Sockel3 = object { intersection {
box { < -35.0, 33.0,  19.0>,<   35.0,  35.0, 330.0>}
cylinder { < -35.1, 35.0,  19.0 > <  35.1,  35.0,  19.0 > 1.0 inverse}
cylinder { < -35.0, 35.0,  18.9 > < -35.0,  35.0, 330.1 > 1.0 inverse}
cylinder { <  35.0, 35.0,  18.9 > <  35.0,  35.0, 330.1 > 1.0 inverse}
cylinder { < -35.0, 35.0, 330.1 > <  35.0,  35.0, 330.1 > 1.0 inverse}
}}
#declare Sockel3h = object { intersection {
box { < -120.0, 33.0,  250.0>,<  120.0,  35.0, 330.0>}
cylinder { < -120.0, 35.0, 330.1 > < 120.0,  35.0, 330.1 > 1.0 inverse}
}}
#declare Sockel4 = object { intersection {
box { < -34.0, 35.0,  20.0>,<   34.0,  36.0, 328.0>}
cylinder { < -34.1, 36.0,  20.0 > <  34.1,  36.0,  20.0 > 1.0 inverse}
cylinder { < -34.0, 36.0,  19.9 > < -34.0,  36.0, 328.1 > 1.0 inverse}
cylinder { <  34.0, 36.0,  19.9 > <  34.0,  36.0, 328.1 > 1.0 inverse}
cylinder { < -34.1, 36.0, 328.0 > <  34.1,  36.0, 328.0 > 1.0 inverse}
}}
#declare Sockel4h = object { intersection {
box { < -120.0, 35.0, 250.0>,<  120.0,  36.0, 328.0>}
cylinder { < -120.0, 36.0,  328.0 > < 120.0,  36.0, 328.0 > 1.0 inverse}
}}
#declare Fries = object {
box { <-32.8,  36.0,  21.2>, < 32.8, 69.0, 327.8>}
}
#declare Friesh = object {
box { <-120.0,  36.0, 250.0>, < 120.0, 69.0, 327.8>}
}

#declare Sockel5 = object { intersection {
box { < -37.0,  69.0,  18.0>,<  37.0,  75.0, 332.0>}
cylinder { < -37.1, 69.0,  18.0 > <  37.1,  69.0,  18.0 > 2.0 inverse}
cylinder { < -37.0, 69.0,  17.9 > < -37.0,  69.0, 332.1 > 2.0 inverse}
cylinder { <  37.0, 69.0,  17.9 > <  37.0,  69.0, 332.1 > 2.0 inverse}
cylinder { < -37.0, 69.0, 332.1 > <  37.0,  69.0, 332.1 > 2.0 inverse}
cylinder { < -37.1, 75.0,  18.0 > <  37.1,  75.0,  18.0 > 2.0 inverse}
cylinder { < -37.0, 75.0,  17.9 > < -37.0,  75.0, 332.1 > 2.0 inverse}
cylinder { <  37.0, 75.0,  17.9 > <  37.0,  75.0, 332.1 > 2.0 inverse}
cylinder { < -37.0, 75.0, 332.1 > <  37.0,  75.0, 332.1 > 2.0 inverse}

cylinder { < -37.1, 72.0,  18.0 > <  37.1,  72.0,  18.0 > 1 inverse pigment {Brown_Agate}}
cylinder { < -37.1, 72.0,  18.0 > < -37.1,  72.0, 332.0 > 1 inverse pigment {Brown_Agate}}
cylinder { <  37.1, 72.0,  18.0 > <  37.1,  72.0, 332.0 > 1 inverse pigment {Brown_Agate}}
cylinder { < -37.1, 72.0, 332.0 > <  37.1,  72.0, 332.0 > 1 inverse pigment {Brown_Agate}}
}}
#declare Sockel5h = object { intersection {
box { < -120.0,  69.0, 250.0>,< 120.0,  75.0, 332.0>}
cylinder { < -121.0, 69.0, 332.1 > < 121.0,  69.0, 332.1 > 2.0 inverse}
cylinder { < -121.0, 75.0, 332.1 > < 121.0,  75.0, 332.1 > 2.0 inverse}
cylinder { < -121.0, 72.0, 332.1 > < 121.0,  72.0, 332.1 > 1.0 inverse pigment {Brown_Agate}}
}}

#declare Sockel6 = object { intersection {
box { < -35.0,  75.0,  20.0>,<  35.0,  78.0, 330.0>}
cylinder { < -35.1, 78.0,  20.0 > <  35.1,  78.0,  20.0 > 1.5 inverse }
cylinder { < -35.0, 78.0,  19.9 > < -35.0,  78.0, 330.1 > 1.5 inverse }
cylinder { <  35.0, 78.0,  19.9 > <  35.0,  78.0, 330.1 > 1.5 inverse }
cylinder { < -35.0, 78.0, 330.1 > <  35.0,  78.0, 330.1 > 1.5 inverse }
}}
#declare Sockel6h = object { intersection {
box { < -120.0,  75.0,  250.0>,< 120.0,  78.0, 330.0>}
cylinder { < -120.0, 78.0, 330.1 > < 120.0,  78.0, 330.1 > 1.5 inverse }
}}
#declare Sockel7 = object { intersection {
box { < -183.0,  78.0,  22.0>,< 183.0,  81.0, 328.0>}
box { <-117.0, 77.9,  21.9 >,< 117.0,  81.1,  130.0 > inverse}
}}

//-------------------------------------------------------------------
//                      Dach / Roof
//-------------------------------------------------------------------
#declare Dach1 = object { intersection {
box { < -183.0, 120.0,  22.0>,< 183.0,  124.0, 328.0>}
box { < -117.0, 119.9,  21.9>,< 117.0,  124.1, 130.0 > inverse}
box { < -117.0, 119.9, 175.0>,< 117.0,  124.1, 277.0>inverse}
texture { T_Stone17 scale <8.0,8.0,8.0>}}}

#declare Dach2 = object { intersection {
box { < -188.0, 124.0, 17.0>,<  188.0, 127.0, 333.0>}
box { < -112.0, 123.9, 16.0>,<  112.0, 127.1, 125.0>inverse}
box { < -112.0, 123.9,181.0>,<  114.0, 127.1, 272.0>inverse}
cylinder { <-188.0, 124.0,  17.0 > < 188.0, 124.0,  17.0 > 2.0 inverse}// vorne
cylinder { <-188.0, 124.0,  17.0 > <-188.0, 124.0, 333.0 > 2.0 inverse}// links
cylinder { < 188.0, 124.0,  17.0 > < 188.0, 124.0, 333.0 > 2.0 inverse}// rechts
cylinder { <-188.0, 124.0, 333.0 > < 188.0, 124.0, 333.0 > 2.0 inverse}// hinten
cylinder { <-112.0, 124.0,  17.0 > <-112.0, 124.0, 125.0 > 2.0 inverse}// links innen
cylinder { < 112.0, 124.0,  17.0 > < 112.0, 124.0, 125.0 > 2.0 inverse}// rechts innen
cylinder { <-112.0, 124.0, 125.0 > < 112.0, 124.0, 125.0 > 2.0 inverse}// vorne mitte
sphere   { <-112.0, 124.0, 125.0>, 2.0 inverse}
sphere   { < 112.0, 124.0, 125.0>, 2.0 inverse}
cylinder { <-112.0, 124.0, 181.0 > < 112.0, 124.0, 181.0 > 2.0 inverse}// innen vorne
cylinder { <-112.0, 124.0, 272.0 > < 112.0, 124.0, 272.0 > 2.0 inverse}// innen hinten
cylinder { <-112.0, 124.0, 181.0 > <-112.0, 124.0, 272.0 > 2.0 inverse}// innen links
cylinder { < 112.0, 124.0, 181.0 > < 112.0, 124.0, 272.0 > 2.0 inverse}// innen vorne
sphere   { <-112.0, 124.0, 181.0>, 2.0 inverse}
sphere   { < 112.0, 124.0, 181.0>, 2.0 inverse}
sphere   { <-112.0, 124.0, 272.0>, 2.0 inverse}
sphere   { < 112.0, 124.0, 272.0>, 2.0 inverse}
texture { T_Stone17 scale <8.0,8.0,8.0>}}}

#declare Dach3 = object { intersection {
box { < -182.0, 127.0,  23.0>,< 182.0,  130.0, 327.0>}
box { < -118.0, 126.9,  22.9>,< 118.0,  130.1, 131.0 > inverse}
box { < -118.0, 126.9, 174.0>,< 118.0,  130.1, 278.0>inverse}
texture { T_Stone18 scale <8.0,8.0,8.0>}}}
            
cylinder { <-177, 125.5,  17.1 > <-177, 125.5,  22.0 > 1.5 texture {T_Stone9}}
cylinder { <-166, 125.5,  17.1 > <-166, 125.5,  22.0 > 1.5 texture {T_Stone9}}
cylinder { <-155, 125.5,  17.1 > <-155, 125.5,  22.0 > 1.5 texture {T_Stone9}}
cylinder { <-144, 125.5,  17.1 > <-144, 125.5,  22.0 > 1.5 texture {T_Stone9}}
cylinder { <-133, 125.5,  17.1 > <-133, 125.5,  22.0 > 1.5 texture {T_Stone9}}
cylinder { <-122, 125.5,  17.1 > <-122, 125.5,  22.0 > 1.5 texture {T_Stone9}}
cylinder { < 177, 125.5,  17.1 > < 177, 125.5,  22.0 > 1.5 texture {T_Stone9}}
cylinder { < 166, 125.5,  17.1 > < 166, 125.5,  22.0 > 1.5 texture {T_Stone9}}
cylinder { < 155, 125.5,  17.1 > < 155, 125.5,  22.0 > 1.5 texture {T_Stone9}}
cylinder { < 144, 125.5,  17.1 > < 144, 125.5,  22.0 > 1.5 texture {T_Stone9}}
cylinder { < 133, 125.5,  17.1 > < 133, 125.5,  22.0 > 1.5 texture {T_Stone9}}
cylinder { < 122, 125.5,  17.1 > < 122, 125.5,  22.0 > 1.5 texture {T_Stone9}}

cylinder { <-112.1, 125.5,  28 > <-115, 125.5,  28.0 > 1.5 texture {T_Stone9}}
cylinder { <-112.1, 125.5,  39 > <-115, 125.5,  39.0 > 1.5 texture {T_Stone9}}
cylinder { <-112.1, 125.5,  50 > <-115, 125.5,  50.0 > 1.5 texture {T_Stone9}}
cylinder { <-112.1, 125.5,  61 > <-115, 125.5,  61.0 > 1.5 texture {T_Stone9}}
cylinder { <-112.1, 125.5,  72 > <-115, 125.5,  72.0 > 1.5 texture {T_Stone9}}
cylinder { <-112.1, 125.5,  83 > <-115, 125.5,  83.0 > 1.5 texture {T_Stone9}}
cylinder { <-112.1, 125.5,  94 > <-115, 125.5,  94.0 > 1.5 texture {T_Stone9}}
cylinder { <-112.1, 125.5, 105 > <-115, 125.5, 105.0 > 1.5 texture {T_Stone9}}
cylinder { <-112.1, 125.5, 116 > <-115, 125.5, 116.0 > 1.5 texture {T_Stone9}}
cylinder { < 112.1, 125.5,  28 > < 115, 125.5,  28.0 > 1.5 texture {T_Stone9}}
cylinder { < 112.1, 125.5,  39 > < 115, 125.5,  39.0 > 1.5 texture {T_Stone9}}
cylinder { < 112.1, 125.5,  50 > < 115, 125.5,  50.0 > 1.5 texture {T_Stone9}}
cylinder { < 112.1, 125.5,  61 > < 115, 125.5,  61.0 > 1.5 texture {T_Stone9}}
cylinder { < 112.1, 125.5,  72 > < 115, 125.5,  72.0 > 1.5 texture {T_Stone9}}
cylinder { < 112.1, 125.5,  83 > < 115, 125.5,  83.0 > 1.5 texture {T_Stone9}}
cylinder { < 112.1, 125.5,  94 > < 115, 125.5,  94.0 > 1.5 texture {T_Stone9}}
cylinder { < 112.1, 125.5, 105 > < 115, 125.5, 105.0 > 1.5 texture {T_Stone9}}
cylinder { < 112.1, 125.5, 116 > < 115, 125.5, 116.0 > 1.5 texture {T_Stone9}}

cylinder { <-112.1, 125.5,  28 > <-115, 125.5,  28.0 > 1.5 texture {T_Stone9}}
cylinder { <-112.1, 125.5,  39 > <-115, 125.5,  39.0 > 1.5 texture {T_Stone9}}
cylinder { <-112.1, 125.5,  50 > <-115, 125.5,  50.0 > 1.5 texture {T_Stone9}}
cylinder { <-112.1, 125.5,  61 > <-115, 125.5,  61.0 > 1.5 texture {T_Stone9}}
cylinder { <-112.1, 125.5,  72 > <-115, 125.5,  72.0 > 1.5 texture {T_Stone9}}
cylinder { <-112.1, 125.5,  83 > <-115, 125.5,  83.0 > 1.5 texture {T_Stone9}}
cylinder { <-112.1, 125.5,  94 > <-115, 125.5,  94.0 > 1.5 texture {T_Stone9}}
cylinder { <-112.1, 125.5, 105 > <-115, 125.5, 105.0 > 1.5 texture {T_Stone9}}
cylinder { <-112.1, 125.5, 116 > <-115, 125.5, 116.0 > 1.5 texture {T_Stone9}}
cylinder { < 112.1, 125.5,  28 > < 115, 125.5,  28.0 > 1.5 texture {T_Stone9}}
cylinder { < 112.1, 125.5,  39 > < 115, 125.5,  39.0 > 1.5 texture {T_Stone9}}
cylinder { < 112.1, 125.5,  50 > < 115, 125.5,  50.0 > 1.5 texture {T_Stone9}}
cylinder { < 112.1, 125.5,  61 > < 115, 125.5,  61.0 > 1.5 texture {T_Stone9}}
cylinder { < 112.1, 125.5,  72 > < 115, 125.5,  72.0 > 1.5 texture {T_Stone9}}
cylinder { < 112.1, 125.5,  83 > < 115, 125.5,  83.0 > 1.5 texture {T_Stone9}}
cylinder { < 112.1, 125.5,  94 > < 115, 125.5,  94.0 > 1.5 texture {T_Stone9}}
cylinder { < 112.1, 125.5, 105 > < 115, 125.5, 105.0 > 1.5 texture {T_Stone9}}
cylinder { < 112.1, 125.5, 116 > < 115, 125.5, 116.0 > 1.5 texture {T_Stone9}}

cylinder { < -99, 125.5, 125.1 > < -99, 125.5, 134.0 > 1.5 texture {T_Stone9}}
cylinder { < -88, 125.5, 125.1 > < -88, 125.5, 134.0 > 1.5 texture {T_Stone9}}
cylinder { < -77, 125.5, 125.1 > < -77, 125.5, 134.0 > 1.5 texture {T_Stone9}}
cylinder { < -66, 125.5, 125.1 > < -66, 125.5, 134.0 > 1.5 texture {T_Stone9}}
cylinder { < -55, 125.5, 125.1 > < -55, 125.5, 134.0 > 1.5 texture {T_Stone9}}
cylinder { < -44, 125.5, 125.1 > < -44, 125.5, 134.0 > 1.5 texture {T_Stone9}}
cylinder { < -33, 125.5, 125.1 > < -33, 125.5, 134.0 > 1.5 texture {T_Stone9}}
cylinder { < -22, 125.5, 125.1 > < -22, 125.5, 134.0 > 1.5 texture {T_Stone9}}
cylinder { < -11, 125.5, 125.1 > < -11, 125.5, 134.0 > 1.5 texture {T_Stone9}}
cylinder { <   0, 125.5, 125.1 > <   0, 125.5, 134.0 > 1.5 texture {T_Stone9}}
cylinder { <  11, 125.5, 125.1 > <  11, 125.5, 134.0 > 1.5 texture {T_Stone9}}
cylinder { <  22, 125.5, 125.1 > <  22, 125.5, 134.0 > 1.5 texture {T_Stone9}}
cylinder { <  33, 125.5, 125.1 > <  33, 125.5, 134.0 > 1.5 texture {T_Stone9}}
cylinder { <  44, 125.5, 125.1 > <  44, 125.5, 134.0 > 1.5 texture {T_Stone9}}
cylinder { <  55, 125.5, 125.1 > <  55, 125.5, 134.0 > 1.5 texture {T_Stone9}}
cylinder { <  66, 125.5, 125.1 > <  66, 125.5, 134.0 > 1.5 texture {T_Stone9}}
cylinder { <  77, 125.5, 125.1 > <  77, 125.5, 134.0 > 1.5 texture {T_Stone9}}
cylinder { <  88, 125.5, 125.1 > <  88, 125.5, 134.0 > 1.5 texture {T_Stone9}}
cylinder { <  99, 125.5, 125.1 > <  99, 125.5, 134.0 > 1.5 texture {T_Stone9}}


cylinder { <-187.9, 125.5,  28 > <-184, 125.5,  28.0 > 1.5 texture {T_Stone9}}
cylinder { <-187.9, 125.5,  39 > <-184, 125.5,  39.0 > 1.5 texture {T_Stone9}}
cylinder { <-187.9, 125.5,  50 > <-184, 125.5,  50.0 > 1.5 texture {T_Stone9}}
cylinder { <-187.9, 125.5,  61 > <-184, 125.5,  61.0 > 1.5 texture {T_Stone9}}
cylinder { <-187.9, 125.5,  72 > <-184, 125.5,  72.0 > 1.5 texture {T_Stone9}}
cylinder { <-187.9, 125.5,  83 > <-184, 125.5,  83.0 > 1.5 texture {T_Stone9}}
cylinder { <-187.9, 125.5,  94 > <-184, 125.5,  94.0 > 1.5 texture {T_Stone9}}
cylinder { <-187.9, 125.5, 105 > <-184, 125.5, 105.0 > 1.5 texture {T_Stone9}}
cylinder { <-187.9, 125.5, 116 > <-184, 125.5, 116.0 > 1.5 texture {T_Stone9}}
cylinder { <-187.9, 125.5, 127 > <-184, 125.5, 127.0 > 1.5 texture {T_Stone9}}
cylinder { <-187.9, 125.5, 138 > <-184, 125.5, 138.0 > 1.5 texture {T_Stone9}}
cylinder { <-187.9, 125.5, 149 > <-184, 125.5, 149.0 > 1.5 texture {T_Stone9}}
cylinder { <-187.9, 125.5, 160 > <-184, 125.5, 160.0 > 1.5 texture {T_Stone9}}
cylinder { <-187.9, 125.5, 171 > <-184, 125.5, 171.0 > 1.5 texture {T_Stone9}}
cylinder { <-187.9, 125.5, 182 > <-184, 125.5, 182.0 > 1.5 texture {T_Stone9}}
cylinder { <-187.9, 125.5, 193 > <-184, 125.5, 193.0 > 1.5 texture {T_Stone9}}
cylinder { <-187.9, 125.5, 204 > <-184, 125.5, 204.0 > 1.5 texture {T_Stone9}}
cylinder { <-187.9, 125.5, 215 > <-184, 125.5, 215.0 > 1.5 texture {T_Stone9}}
cylinder { <-187.9, 125.5, 226 > <-184, 125.5, 226.0 > 1.5 texture {T_Stone9}}
cylinder { <-187.9, 125.5, 237 > <-184, 125.5, 237.0 > 1.5 texture {T_Stone9}}
cylinder { <-187.9, 125.5, 248 > <-184, 125.5, 248.0 > 1.5 texture {T_Stone9}}
cylinder { <-187.9, 125.5, 259 > <-184, 125.5, 259.0 > 1.5 texture {T_Stone9}}
cylinder { <-187.9, 125.5, 270 > <-184, 125.5, 270.0 > 1.5 texture {T_Stone9}}
cylinder { <-187.9, 125.5, 281 > <-184, 125.5, 281.0 > 1.5 texture {T_Stone9}}
cylinder { <-187.9, 125.5, 292 > <-184, 125.5, 292.0 > 1.5 texture {T_Stone9}}
cylinder { <-187.9, 125.5, 303 > <-184, 125.5, 303.0 > 1.5 texture {T_Stone9}}
cylinder { <-187.9, 125.5, 314 > <-184, 125.5, 314.0 > 1.5 texture {T_Stone9}}
cylinder { <-187.9, 125.5, 325 > <-184, 125.5, 325.0 > 1.5 texture {T_Stone9}}

cylinder { < 187.9, 125.5,  28 > < 184, 125.5,  28.0 > 1.5 texture {T_Stone9}}
cylinder { < 187.9, 125.5,  39 > < 184, 125.5,  39.0 > 1.5 texture {T_Stone9}}
cylinder { < 187.9, 125.5,  50 > < 184, 125.5,  50.0 > 1.5 texture {T_Stone9}}
cylinder { < 187.9, 125.5,  61 > < 184, 125.5,  61.0 > 1.5 texture {T_Stone9}}
cylinder { < 187.9, 125.5,  72 > < 184, 125.5,  72.0 > 1.5 texture {T_Stone9}}
cylinder { < 187.9, 125.5,  83 > < 184, 125.5,  83.0 > 1.5 texture {T_Stone9}}
cylinder { < 187.9, 125.5,  94 > < 184, 125.5,  94.0 > 1.5 texture {T_Stone9}}
cylinder { < 187.9, 125.5, 105 > < 184, 125.5, 105.0 > 1.5 texture {T_Stone9}}
cylinder { < 187.9, 125.5, 116 > < 184, 125.5, 116.0 > 1.5 texture {T_Stone9}}
cylinder { < 187.9, 125.5, 127 > < 184, 125.5, 127.0 > 1.5 texture {T_Stone9}}
cylinder { < 187.9, 125.5, 138 > < 184, 125.5, 138.0 > 1.5 texture {T_Stone9}}
cylinder { < 187.9, 125.5, 149 > < 184, 125.5, 149.0 > 1.5 texture {T_Stone9}}
cylinder { < 187.9, 125.5, 160 > < 184, 125.5, 160.0 > 1.5 texture {T_Stone9}}
cylinder { < 187.9, 125.5, 171 > < 184, 125.5, 171.0 > 1.5 texture {T_Stone9}}
cylinder { < 187.9, 125.5, 182 > < 184, 125.5, 182.0 > 1.5 texture {T_Stone9}}
cylinder { < 187.9, 125.5, 193 > < 184, 125.5, 193.0 > 1.5 texture {T_Stone9}}
cylinder { < 187.9, 125.5, 204 > < 184, 125.5, 204.0 > 1.5 texture {T_Stone9}}
cylinder { < 187.9, 125.5, 215 > < 184, 125.5, 215.0 > 1.5 texture {T_Stone9}}
cylinder { < 187.9, 125.5, 226 > < 184, 125.5, 226.0 > 1.5 texture {T_Stone9}}
cylinder { < 187.9, 125.5, 237 > < 184, 125.5, 237.0 > 1.5 texture {T_Stone9}}
cylinder { < 187.9, 125.5, 248 > < 184, 125.5, 248.0 > 1.5 texture {T_Stone9}}
cylinder { < 187.9, 125.5, 259 > < 184, 125.5, 259.0 > 1.5 texture {T_Stone9}}
cylinder { < 187.9, 125.5, 270 > < 184, 125.5, 270.0 > 1.5 texture {T_Stone9}}
cylinder { < 187.9, 125.5, 281 > < 184, 125.5, 281.0 > 1.5 texture {T_Stone9}}
cylinder { < 187.9, 125.5, 292 > < 184, 125.5, 292.0 > 1.5 texture {T_Stone9}}
cylinder { < 187.9, 125.5, 303 > < 184, 125.5, 303.0 > 1.5 texture {T_Stone9}}
cylinder { < 187.9, 125.5, 314 > < 184, 125.5, 314.0 > 1.5 texture {T_Stone9}}
cylinder { < 187.9, 125.5, 325 > < 184, 125.5, 325.0 > 1.5 texture {T_Stone9}}

cylinder { <-177, 125.5, 332.9 > <-177, 125.5, 329.0 > 1.5 texture {T_Stone9}}
cylinder { <-166, 125.5, 332.9 > <-166, 125.5, 329.0 > 1.5 texture {T_Stone9}}
cylinder { <-155, 125.5, 332.9 > <-155, 125.5, 329.0 > 1.5 texture {T_Stone9}}
cylinder { <-144, 125.5, 332.9 > <-144, 125.5, 329.0 > 1.5 texture {T_Stone9}}
cylinder { <-133, 125.5, 332.9 > <-133, 125.5, 329.0 > 1.5 texture {T_Stone9}}
cylinder { <-122, 125.5, 332.9 > <-122, 125.5, 329.0 > 1.5 texture {T_Stone9}}
cylinder { <-111, 125.5, 332.9 > <-111, 125.5, 329.0 > 1.5 texture {T_Stone9}}
cylinder { < -99, 125.5, 332.9 > < -99, 125.5, 329.0 > 1.5 texture {T_Stone9}}
cylinder { < -88, 125.5, 332.9 > < -88, 125.5, 329.0 > 1.5 texture {T_Stone9}}
cylinder { < -77, 125.5, 332.9 > < -77, 125.5, 329.0 > 1.5 texture {T_Stone9}}
cylinder { < -66, 125.5, 332.9 > < -66, 125.5, 329.0 > 1.5 texture {T_Stone9}}
cylinder { < -55, 125.5, 332.9 > < -55, 125.5, 329.0 > 1.5 texture {T_Stone9}}
cylinder { < -44, 125.5, 332.9 > < -44, 125.5, 329.0 > 1.5 texture {T_Stone9}}
cylinder { < -33, 125.5, 332.9 > < -33, 125.5, 329.0 > 1.5 texture {T_Stone9}}
cylinder { < -22, 125.5, 332.9 > < -22, 125.5, 329.0 > 1.5 texture {T_Stone9}}
cylinder { < -11, 125.5, 332.9 > < -11, 125.5, 329.0 > 1.5 texture {T_Stone9}}
cylinder { <   0, 125.5, 332.9 > <   0, 125.5, 329.0 > 1.5 texture {T_Stone9}}
cylinder { <  11, 125.5, 332.9 > <  11, 125.5, 329.0 > 1.5 texture {T_Stone9}}
cylinder { <  22, 125.5, 332.9 > <  22, 125.5, 329.0 > 1.5 texture {T_Stone9}}
cylinder { <  33, 125.5, 332.9 > <  33, 125.5, 329.0 > 1.5 texture {T_Stone9}}
cylinder { <  44, 125.5, 332.9 > <  44, 125.5, 329.0 > 1.5 texture {T_Stone9}}
cylinder { <  55, 125.5, 332.9 > <  55, 125.5, 329.0 > 1.5 texture {T_Stone9}}
cylinder { <  66, 125.5, 332.9 > <  66, 125.5, 329.0 > 1.5 texture {T_Stone9}}
cylinder { <  77, 125.5, 332.9 > <  77, 125.5, 329.0 > 1.5 texture {T_Stone9}}
cylinder { <  88, 125.5, 332.9 > <  88, 125.5, 329.0 > 1.5 texture {T_Stone9}}
cylinder { <  99, 125.5, 332.9 > <  99, 125.5, 329.0 > 1.5 texture {T_Stone9}}
cylinder { < 111, 125.5, 332.9 > < 111, 125.5, 329.0 > 1.5 texture {T_Stone9}}
cylinder { < 122, 125.5, 332.9 > < 122, 125.5, 329.0 > 1.5 texture {T_Stone9}}
cylinder { < 133, 125.5, 332.9 > < 133, 125.5, 329.0 > 1.5 texture {T_Stone9}}
cylinder { < 144, 125.5, 332.9 > < 144, 125.5, 329.0 > 1.5 texture {T_Stone9}}
cylinder { < 155, 125.5, 332.9 > < 155, 125.5, 329.0 > 1.5 texture {T_Stone9}}
cylinder { < 166, 125.5, 332.9 > < 166, 125.5, 329.0 > 1.5 texture {T_Stone9}}
cylinder { < 177, 125.5, 332.9 > < 177, 125.5, 329.0 > 1.5 texture {T_Stone9}}

object { union {
object {Stufen}
object {Sockel1 translate < 150, 0,0> texture { T_Stone17 scale <20.0,20.0,20.0>}}
object {Sockel1 translate <-150, 0,0> texture { T_Stone17 scale <20.0,20.0,20.0>}}
object {Sockel1h texture { T_Stone17 scale <8.0,8.0,8.0>}}
object {Sockel2 translate < 150, 0,0> texture { T_Stone17 scale <8.0,8.0,8.0>}}
object {Sockel2 translate <-150, 0,0> texture { T_Stone17 scale <8.0,8.0,8.0>}}
object {Sockel2h texture { T_Stone17 scale <8.0,8.0,8.0>}}
object {Sockel3 translate < 150, 0,0> texture { T_Stone17 scale <8.0,8.0,8.0>}}
object {Sockel3 translate <-150, 0,0> texture { T_Stone17 scale <8.0,8.0,8.0>}}
object {Sockel3h texture { T_Stone17 scale <8.0,8.0,8.0>}}
object {Sockel4 translate < 150, 0,0> texture { T_Stone17 scale <8.0,8.0,8.0>}}
object {Sockel4 translate <-150, 0,0> texture { T_Stone17 scale <8.0,8.0,8.0>}}
object {Sockel4h texture { T_Stone17 scale <8.0,8.0,8.0>}}
object {Fries translate < 150, 0,0> texture { T_Stone10 scale <8.0,8.0,8.0>}}
object {Fries translate <-150, 0,0> texture { T_Stone10 scale <8.0,8.0,8.0>}}
object {Friesh texture { T_Stone10 scale <8.0,8.0,8.0>}}
object {Sockel5 translate < 150, 0,0> texture { T_Stone17 scale <8.0,8.0,8.0>}}
object {Sockel5 translate <-150, 0,0> texture { T_Stone17 scale <8.0,8.0,8.0>}}
object {Sockel5h texture { T_Stone17 scale <8.0,8.0,8.0>}}
object {Sockel6 translate < 150, 0,0> texture { T_Stone17 scale <8.0,8.0,8.0>}}
object {Sockel6 translate <-150, 0,0> texture { T_Stone17 scale <8.0,8.0,8.0>}}
object {Sockel6h texture { T_Stone17 scale <8.0,8.0,8.0>}}
object {Sockel7 texture { T_Stone17 scale <8.0,8.0,8.0>}}
object {Dach1 translate <0, 0,0> texture { T_Stone17 scale <8.0,8.0,8.0>}}
object {Dach2 translate <0, 0,0> texture { T_Stone17 scale <8.0,8.0,8.0>}}
object {Dach3 translate <0, 0,0> texture { T_Stone16 scale <8.0,8.0,8.0>}}
}}

#declare Saeule = object {column_ionic
scale <11,15,11>}
//-------------------------------------------------------
//      Linke Saeulengruppe  
//-------------------------------------------------------
object {Saeule translate <-180, 81.0,  25.0>}
object {Saeule translate <-160, 81.0,  25.0>}
object {Saeule translate <-140, 81.0,  25.0>}
object {Saeule translate <-120, 81.0,  25.0>}

object {Saeule rotate y*90 translate <-120, 81.0,  45>}
object {Saeule rotate y*90 translate <-120, 81.0,  65>}
object {Saeule rotate y*90 translate <-120, 81.0,  85>}
object {Saeule rotate y*90 translate <-120, 81.0, 105>}
object {Saeule rotate y*90 translate <-120, 81.0, 125>}
//-------------------------------------------------------
//      rechte Saeulengruppe   
//-------------------------------------------------------
object {Saeule translate < 180, 81.0,  25.0>}
object {Saeule translate < 160, 81.0,  25.0>}
object {Saeule translate < 140, 81.0,  25.0>}
object {Saeule translate < 120, 81.0,  25.0>}

object {Saeule rotate y*90 translate < 120, 81.0,  45>}
object {Saeule rotate y*90 translate < 120, 81.0,  65>}
object {Saeule rotate y*90 translate < 120, 81.0,  85>}
object {Saeule rotate y*90 translate < 120, 81.0, 105>}
object {Saeule rotate y*90 translate < 120, 81.0, 125>} 
//-------------------------------------------------------
//    mittlere Saeulengruppe vorne 
//-------------------------------------------------------
object {Saeule translate < -10, 81.0, 133.0>}
object {Saeule translate < -30, 81.0, 133.0>}
object {Saeule translate < -50, 81.0, 133.0>}
object {Saeule translate < -70, 81.0, 133.0>}
object {Saeule translate < -90, 81.0, 133.0>}
object {Saeule translate <-110, 81.0, 133.0>}
object {Saeule translate <  10, 81.0, 133.0>}
object {Saeule translate <  30, 81.0, 133.0>}
object {Saeule translate <  50, 81.0, 133.0>}
object {Saeule translate <  70, 81.0, 133.0>}
object {Saeule translate <  90, 81.0, 133.0>}
object {Saeule translate < 110, 81.0, 133.0>}
//-------------------------------------------------------
//    mittlere Saeulengruppe hinten   
//-------------------------------------------------------
object {Saeule translate < -10, 81.0, 173.0>}
object {Saeule translate < -30, 81.0, 173.0>}
object {Saeule translate < -50, 81.0, 173.0>}
object {Saeule translate < -70, 81.0, 173.0>}
object {Saeule translate < -90, 81.0, 173.0>}
object {Saeule translate <-110, 81.0, 173.0>}
object {Saeule translate <  10, 81.0, 173.0>}
object {Saeule translate <  30, 81.0, 173.0>}
object {Saeule translate <  50, 81.0, 173.0>}
object {Saeule translate <  70, 81.0, 173.0>}
object {Saeule translate <  90, 81.0, 173.0>}
object {Saeule translate < 110, 81.0, 173.0>}
//-------------------------------------------------------
//    hintere Saeulengruppe hinten
//-------------------------------------------------------
object {Saeule translate <   0, 81.0, 325.0>}
object {Saeule translate < -20, 81.0, 325.0>}
object {Saeule translate < -40, 81.0, 325.0>}
object {Saeule translate < -60, 81.0, 325.0>}
object {Saeule translate < -80, 81.0, 325.0>}
object {Saeule translate <-100, 81.0, 325.0>}
object {Saeule translate <-120, 81.0, 325.0>}
object {Saeule translate <-140, 81.0, 325.0>}
object {Saeule translate <-160, 81.0, 325.0>}
object {Saeule translate <-180, 81.0, 325.0>}
object {Saeule translate <  20, 81.0, 325.0>}
object {Saeule translate <  40, 81.0, 325.0>}
object {Saeule translate <  60, 81.0, 325.0>}
object {Saeule translate <  80, 81.0, 325.0>}
object {Saeule translate < 100, 81.0, 325.0>}
object {Saeule translate < 120, 81.0, 325.0>}
object {Saeule translate < 140, 81.0, 325.0>}
object {Saeule translate < 160, 81.0, 325.0>}
object {Saeule translate < 180, 81.0, 325.0>}
//-------------------------------------------------------
//    hintere Saeulengruppe vorne
//-------------------------------------------------------
object {Saeule translate <   0, 81.0, 280.0>}
object {Saeule translate < -20, 81.0, 280.0>}
object {Saeule translate < -40, 81.0, 280.0>}
object {Saeule translate < -60, 81.0, 280.0>}
object {Saeule translate < -80, 81.0, 280.0>}
object {Saeule translate <-100, 81.0, 280.0>}
object {Saeule translate <  20, 81.0, 280.0>}
object {Saeule translate <  40, 81.0, 280.0>}
object {Saeule translate <  60, 81.0, 280.0>}
object {Saeule translate <  80, 81.0, 280.0>}
object {Saeule translate < 100, 81.0, 280.0>}
//-------------------------------------------------------
//    mittlere Saeulengruppe links 
//-------------------------------------------------------
object {Saeule rotate y*90 translate <-120.0, 81.0, 185>}
object {Saeule rotate y*90 translate <-120.0, 81.0, 205>}
object {Saeule rotate y*90 translate <-120.0, 81.0, 225>}
object {Saeule rotate y*90 translate <-120.0, 81.0, 245>}
object {Saeule rotate y*90 translate <-120.0, 81.0, 265>}
//-------------------------------------------------------
//      mittlere Saeulengruppe rechts
//-------------------------------------------------------
object {Saeule rotate y*90 translate < 120.0, 81.0, 185>}
object {Saeule rotate y*90 translate < 120.0, 81.0, 205>}
object {Saeule rotate y*90 translate < 120.0, 81.0, 225>}
object {Saeule rotate y*90 translate < 120.0, 81.0, 245>}
object {Saeule rotate y*90 translate < 120.0, 81.0, 265>}
//-------------------------------------------------------
//            Saeulengruppe links                     
//-------------------------------------------------------
object {Saeule rotate y*90 translate <-180.0, 81.0,  45>}
object {Saeule rotate y*90 translate <-180.0, 81.0,  65>}
object {Saeule rotate y*90 translate <-180.0, 81.0,  85>}
object {Saeule rotate y*90 translate <-180.0, 81.0, 105>}
object {Saeule rotate y*90 translate <-180.0, 81.0, 125>}
object {Saeule rotate y*90 translate <-180.0, 81.0, 145>}
object {Saeule rotate y*90 translate <-180.0, 81.0, 165>}
object {Saeule rotate y*90 translate <-180.0, 81.0, 185>}
object {Saeule rotate y*90 translate <-180.0, 81.0, 205>}
object {Saeule rotate y*90 translate <-180.0, 81.0, 225>}
object {Saeule rotate y*90 translate <-180.0, 81.0, 245>}
object {Saeule rotate y*90 translate <-180.0, 81.0, 265>}
object {Saeule rotate y*90 translate <-180.0, 81.0, 285>}
object {Saeule rotate y*90 translate <-180.0, 81.0, 305>}
//-------------------------------------------------------
//            Saeulengruppe rechts                     
//-------------------------------------------------------
object {Saeule rotate y*90 translate < 180.0, 81.0,  45>}
object {Saeule rotate y*90 translate < 180.0, 81.0,  65>}
object {Saeule rotate y*90 translate < 180.0, 81.0,  85>}
object {Saeule rotate y*90 translate < 180.0, 81.0, 105>}
object {Saeule rotate y*90 translate < 180.0, 81.0, 125>}
object {Saeule rotate y*90 translate < 180.0, 81.0, 145>}
object {Saeule rotate y*90 translate < 180.0, 81.0, 165>}
object {Saeule rotate y*90 translate < 180.0, 81.0, 185>}
object {Saeule rotate y*90 translate < 180.0, 81.0, 205>}
object {Saeule rotate y*90 translate < 180.0, 81.0, 225>}
object {Saeule rotate y*90 translate < 180.0, 81.0, 245>}
object {Saeule rotate y*90 translate < 180.0, 81.0, 265>}
object {Saeule rotate y*90 translate < 180.0, 81.0, 285>}
object {Saeule rotate y*90 translate < 180.0, 81.0, 305>}

// This is a Test with the #while function for the Columns
// it works but carefull, the parsing need a lot of time (30 min.)
/*#declare Start_z1 = 45;
#declare End_z1 = 305;
#declare Step_z1 = 20;
#while (Start_z1 <End_z1 + Step_z1)
object {Saeule translate <-180.0, 81.0,  Start_z1>}
object {Saeule translate < 180.0, 81.0,  Start_z1>}
#declare Start_z1 = Start_z1 + 1;
#end*/

/*********************************************/
/*                 Fussboden                 */
/*********************************************/
plane { <0, 1.1, 0>, -1
    pigment { Jade
    //scale < 200.0,200.0,200.0>
    }
  }

#declare StoneWallStoneTexture=
 texture 
  { 
   Gold_Texture }

#declare MortarTexture=
 texture  
  {  
   pigment { Jade} 
   normal { dents scale 0.1 } 
   finish { crand 0.05 } scale 0.2 
  }
object
 {
  stone_wall( 1, 
              40,60, 
              1,2,
              3,2,
              <0.25,0.25>, 0.1,
              StoneWallStoneTexture, MortarTexture 
             ) 

  scale <400,220,1>
  rotate <90,90,0>
 translate <-110,0,-5>
 }
 difference {
    box { <-5, -2.1, 0.1>, <5, 2.1, 1>
      texture { T_Stone10 scale <1,1,1>}
    }text { ttf "Antquab.ttf" "The" 0.15, 0
      pigment { BrightGold }
      finish { reflection .25 specular 1 }
      translate < -0.8,0.8,0>
    }
    text { ttf "Antquab.ttf" "Pergamon Altar" 0.15, 0
      pigment { BrightGold }
      finish { reflection .25 specular 1 }
      translate <-3.4,-0.2,0>
    }
    
    text { ttf "Antquab.ttf" "by Michael Laube" 0.15, 0
      pigment { BrightGold }
      finish { reflection .25 specular 1 }
      translate <-4,-1.5,0>
    }
    cylinder { < -4.8, 0, 0 > < 4.8, 0, 0 > 0.12 pigment { BrightGold }translate < 0,1.9,0>}
    cylinder { < -4.8, 0, 0 > < 4.8, 0, 0 > 0.12 pigment { BrightGold }translate < 0,-1.9,0>}
    cylinder { < -4.8,-1.9, 0 > <-4.8, 1.9 0 > 0.12 pigment { BrightGold }translate < 0,0,0>}
    cylinder { <  4.8,-1.9, 0 > < 4.8, 1.9 0 > 0.12 pigment { BrightGold }translate < 0,0,0>}
 scale <6.6,8,1>
 //rotate x*45
 translate <-150,53,21>
  }
//-----------------------------------------------
//---------------- Balustre.inc from Danneel Luc 
//-----------------------------------------------
#declare Deco = texture { T_Stone18 }
#declare Base = 
	 texture { T_Stone8
         scale <8,8,8> //}
         }
#declare Number = 5; //nombre de ballustres.
#include "Balustre.inc"

union {
object { Pilier_gauche }
object { Rang translate x*35}
object { Pilier_centre translate x*(35+(Number*25))}
object { Rang translate x*((35*2)+(Number*25))}
object { Pilier_centre translate x*(35+(Number*57))}
object { Rang translate x*((35*3)+(Number*50))}
object { Pilier_centre translate x*(35+(Number*89))}
object { Rang translate x*((35*4)+(Number*75))}
object { Pilier_droit translate x*((35*5)+(Number*92))}
rotate y*-90
scale <0.3,0.3,0.3>
translate <-165,-1,-200>
}
union {
object { Pilier_gauche }
object { Rang translate x*35}
object { Pilier_centre translate x*(35+(Number*25))}
object { Rang translate x*((35*2)+(Number*25))}
object { Pilier_centre translate x*(35+(Number*57))}
object { Rang translate x*((35*3)+(Number*50))}
object { Pilier_centre translate x*(35+(Number*89))}
object { Rang translate x*((35*4)+(Number*75))}
object { Pilier_droit translate x*((35*5)+(Number*92))}
rotate y*90
scale <0.3,0.3,0.3>
translate < 165,-1,2>
} 
//----------------------------------------------------
//               Berg/Mountain
//----------------------------------------------------
 height_field {
    tga "MountLo1.tga"
    smooth
    scale <2550,600, 2550>
    translate <-1600,-2,300>
    texture { T_Grnt23a scale <60,60,60> }//Brown_Agate }//color rgb <.9,1,1> }
      }
height_field {
    tga "MountLo1.tga"
    smooth
    scale <2850,800, 2850>
    translate <-1600,-2,300>
    texture { T_Stone8 scale <60,60,60> }//Brown_Agate }//color rgb <.9,1,1> }
      }      
//-------------------------------------------
//              Schale
//-------------------------------------------  
lathe { 
  linear_spline
  19
  <0.018405, -1.088616>,
  <0.452624, -1.08623>,
  <0.661213, -1.017485>,
  <0.857873, -0.8784>,
  <0.989383, -0.664194>,
  <1.13341, -0.46042>,
  <1.366053, -0.331629>,
  <1.557805, -0.238684>,
  <1.740607, -0.225927>,
  <1.744937, -0.114923>,
  <1.576959, -0.119804>,
  <1.367498, -0.202592>,
  <1.163119, -0.315175>,
  <1.069218, -0.386902>,
  <0.873107, -0.615557>,
  <0.74443, -0.81051>,
  <0.581323, -0.936886>,
  <0.420771, -0.97813>,
  <0.011588, -0.976823>
  //rotate <90,0,90>
  texture {
    T_Stone8
  }
  scale <15,15,15>
  rotate <0,0,0>
  translate  <0, 95, 220>
}   

// here begins the Fake_the_Fire.inc from Toni Bratincevic (Thanks for this .inc)                                      
// E-MAIL  : tbrat@mail.geocities.com                                
// HOMEPAGE: http://members.xoom.com/Intercepto

global_settings { max_trace_level 20 }

#declare cam_position = <0.0,0.0,-10.0 >;

#declare fake_the_smoke = on;          // on - 2D effects; off - 3D effects (not implemented yet)
#declare smoke_start_point = <0,10,0>; // start point of fire or smoke
#declare smoke_to_x = 12;               // x size of fire
#declare smoke_to_y = 4;               // y size ...
#declare smoke_to_y_exponent = 2;      // linear or exponential aproach to end point
#declare max_dispersion = 2;           // at first sample this is 0 and rise as it aproach end smpl

#declare smoke_samples = 200;          // samples - particles - discs

#declare smoke_start_radius = 0.3;     // radius of disc at first sample
#declare smoke_end_radius = 1.2;       // radius of disc at last sample

#declare rs = seed (4525);             // seed for random number generator
#declare intensity = 1.5;              // color*intensity
#declare ambientlght = 4;              // set ambient value to x
#declare counter = 0;                  // oh my god, it is Mr. Counter! :-)

// SET THE TYPE OF TEXTURE
#declare Pig_Type = 1;                 // pigment types; for now 4 of them

// USE RANDOM COLORS IN PIGMENTS OR
#declare rand_color = off;             // you can use gradient through colors or rand color
#declare RRMult = 0.9;                 // multiplyer of rand number for red color
#declare GRMult = 0.9;                 // multiplyer of rand number for green color
#declare BRMult = 0.9;                 // multiplyer of rand number for blue color

// ... GRADIENT FROM COLORS
#declare num_of_colors = 4;                     // set number of colors 
#declare grad_colors = array [num_of_colors]    // array for your colors
#declare grad_colors [0] = <1,1,.7>;            // set the first color
#declare grad_colors [1] = <.65,.65,.6>;           // ... second color
#declare grad_colors [2] = <0.4,0.4,.3>;         // ... third color
#declare grad_colors [3] = <0.2,0.2,0.15>;    // ... fourth color


#macro calculate_color ()
   #if (rand_color)
     #declare flame_color = <rand (rs)*RRMult,rand(rs)*GRMult,rand(rs)*BRMult>;
   #else
     #declare wh_color = int((num_of_colors-1)*counter);
     #declare fc_mult = counter*(num_of_colors-1)-wh_color;
     #declare fcol1 = (1-fc_mult)*grad_colors [wh_color];
     #declare fcol2 = fc_mult*grad_colors [wh_color+1];
     #declare flame_color = intensity*(fcol1+fcol2)/2; 
   #end
#end

#macro calculate_position ()
   #declare x_vector = counter*smoke_to_x; 
   #declare y_vector = pow(counter,smoke_to_y_exponent)*smoke_to_y;
   #declare z_vector = vrotate(<0,0,counter*(max_dispersion)*rand(rs)>,<rand(rs)*360,0,0>);
   //#declare z_vector = <0,0,(max_dispersion/2)-(max_dispersion*rand(rs))>;
   #declare radi = smoke_start_radius+(counter*(smoke_end_radius-smoke_start_radius));
   #declare sample_position = <x_vector,0,0>+z_vector+<0,y_vector,0>;
#end

#macro F_Pigment ()
  #switch (Pig_Type)
  #case (1)
    pigment {
       spherical
       pigment_map {
          [ 0.10 color rgb 0 transmit 1 ]
          [ 0.85
             wrinkles
             color_map {
                [ 0 color rgb flame_color ]
                [ 1 color rgb flame_color*0.3 ]
             }
             scale <0.2,0.2,0.2>
             translate <rand(rs),rand(rs),rand(rs)>*20
          ]
       }
       scale radi/1.25
       translate sample_position 
       turbulence 0.2
       octaves 6
       lambda 2
       omega 0.8
    }
  #break
  #case (2)
    pigment {
       spherical
       pigment_map {
          [ 0.4 color rgb 0 transmit 1 ]
          [ 0.5 color rgb flame_color  ]
          [ 0.6 color rgb 0 transmit 1 ]
       }
       scale radi/1.25
       translate sample_position 
    }
  #break
  #case (3)
    pigment {
       spherical
       pigment_map {
          [ 0.3 color rgb 0 transmit 1 ]
          [ 0.7 
            spiral1 5
            color_map {
               [ 0.4 color rgb 0 transmit 1 ]
               [ 0.8 color rgb flame_color transmit 0.5 ]
            }
          ]
       }
       scale radi/1.25
       translate sample_position 
    }
  #break
  #case (4)
    pigment {
       spherical
       pigment_map {
          [ 0.3 color rgb 0 transmit 1 ]
          [ 0.7 
            spotted
            color_map {
               [ 0.4 color rgb flame_color transmit 0.95  ]
               [ 0.8 color rgb flame_color*0.5 transmit 0.4 ]
            }
            scale 0.5          ]
       }
       scale radi/1.25
       translate sample_position 
    }
  #break
  #end
#end

#macro F_Smoke ()
 disc {
    sample_position,
    cam_position,
    radi,0
    F_Pigment ()
    finish { ambient ambientlght }
    no_shadow
 }
#end

#macro T_Smoke ()
 sphere {
    sample_position, radi
    material {
      texture {
        pigment { color rgb 1 transmit 1 }
        finish { ambient 1 diffuse 0 }
      }
      interior {
        media {
           emission 1
           density {
              spherical
              density_map {
                 [ 0.10 color rgb 0 ]
                 [ 0.85
                   wrinkles
                   color_map {
                      [ 0.2 color rgb flame_color-(flame_color*(xmov_rand/smoke_to.x)) ]
                      [ 0.8 color rgb (flame_color-(flame_color*(xmov_rand/smoke_to.x)))*0.3 ]
                   }
                   scale <0.4,0.4,0.4>
                   translate <rand(rs),rand(rs),rand(rs)>*50
                 ]
                 [ 0.9 color rgb flame_color ]
              }
              scale radi/1.25
              translate <xmov_rand,ymov_rand,zmov>
              turbulence 0.2
              octaves 6
              lambda 2
              omega 0.8
           }
        }
      }
    }
    no_shadow
    hollow
 }
#end

#macro do_you_smoke ()
  union {
    #while (counter<1)
      calculate_position ()
      calculate_color ()
      #if (fake_the_smoke)
        F_Smoke ()
      #else
        T_Smoke ()
      #end
      #declare counter = counter + 1/smoke_samples;
    #end
    translate smoke_start_point
    hollow
  }
#end

object {do_you_smoke () scale <15,15,15>
rotate <0,0,90>
translate <150,90,220>}

//---------------------------------------------------
//              Vase  Objects on the roof
//---------------------------------------------------
#declare Vase = lathe {
  linear_spline
  35
  <-0.008862, -1.558964>,
  <0.622461, -1.559594>,
  <0.62304, -1.481595>,
  <0.145876, -1.48364>,
  <0.149489, -1.242093>,
  <0.297515, -1.185261>,
  <0.446855, -1.103893>,
  <0.583387, -0.991226>,
  <0.706286, -0.871743>,
  <0.850034, -0.704158>,
  <0.987185, -0.519591>,
  <1.130988, -0.256055>,
  <1.264567, 0.007482>,
  <1.311995, 0.247403>,
  <1.407587, 0.223884>,
  <1.510031, 0.273908>,
  <1.558987, 0.379418>,
  <1.559518, 0.487045>,
  <1.537895, 0.572518>,
  <1.448047, 0.623186>,
  <1.347268, 0.602672>,
  <1.351794, 0.842392>,
  <1.34905, 0.979068>,
  <1.279314, 0.977858>,
  <1.278249, 0.803995>,
  <1.248106, 0.539601>,
  <1.22166, 0.280515>,
  <1.163774, 0.024842>,
  <1.039422, -0.215488>,
  <0.903924, -0.469382>,
  <0.748088, -0.654878>,
  <0.637053, -0.803275>,
  <0.479952, -0.957494>,
  <0.271673, -1.09538>,
  <0.008862, -1.178732>
  rotate <90,0,90>
  texture {
    T_Grnt26
  }
  scale <4.0, 4.0, 4.0>}
  
object {Vase  
  rotate <-90,0,0>
  translate <-179,136,26>
}
object {Vase  
  rotate <-90,0,0>
  translate <-122,136,26>
}

object {Vase  
  rotate <-90,0,0>
  translate < 179,136,26>
}
object {Vase  
  rotate <-90,0,0>
  translate < 122,136,26>
}
//=========================================
// Leaf & Tree examples for the MakeTree macro
// (c) 1999 Gilles Tran tran@inapg.inra.fr
//=========================================   
// Bush example
// The bush effect is obtained by using an upward vpush <0,1,0>
// and by having the branch length increase at each level (instead of decreasing as usual)
//-----------------------------------------
// This file calls the MakeTree and MakeLeaf macros
// and defines the textures and parameters
// Set the [dofile] parameter to "true"
// when you want to create the final file
//-----------------------------------------
#include "colors.inc"
#include "txttree.inc"
#include "maketree.pov" // tree & leaf macro
//=========================================
// Camera & light
//-----------------------------------------
//#declare PdV=<0, 4 , -110>;
//#declare PdA=<0,25,0>;
//camera {location  PdV  direction <0.0 , 0.0 , 1.7 >  up y right 4*x/3  look_at PdA}
//-----------------------------------------
//light_source{PdV color White*0.5  shadowless}
//light_source{<130,40,-200> color White*1.8}
//=========================================
// Tree macro Parameters
//-----------------------------------------
// These parameters must be declared before calling the tree macro
//-----------------------------------------
#declare dofile=false;//true;    // true creates a tree file ; false otherwise
#declare dotexture=true;  // true creates a textured tree (with the texture following the branch); false otherwise
#declare ftname="gttree4.inc" // file name for tree
#declare fvname="gtfoliage4.inc" // file name for tree foliage
#declare ffname="gtleaf4.inc" // file name for individual leaf (mesh)
#declare txtTree=texture{txtTree_5} // Bark texture

//-----------------------------------------
// Random streams
// one stream for branches and another one for leaves
// so that the leafed tree has the same structure as the leafless one
//-----------------------------------------
#declare rsd=211;      // random seed
//#declare rsd=212;      // random seed
//#declare rsd=213;      // random seed
#declare rd=seed(rsd);  // random stream for branches
#declare rdl=seed(rsd); // separate random stream for leaves

//-----------------------------------------
// Tree structure parameters        
// test with low level0 and nseg0 (3 or 4)
// High (>=6) recursion levels [level0] gives more complex trees
// High (>=6) segment numbers [nseg0] gives smoother trees
//-----------------------------------------
#declare level0=4;      // recursion level
#declare nseg0=12;       // initial number of branch segments (decreases of one at each level)
#declare nb=4;          // max number of branches per level
#declare dotop=false;   // if true, generates an extra branch on top of trunk (sometimes necessary to give more verticality)

#declare lb0=3;        // initial branch length
#declare rb0=1;         // initial branch radius
#declare ab0=95;        // initial branch angle (x angle between the trunk and the first branch)
#declare qlb=1.6;       // branch length decrease ratio (1=constant length)
#declare qrb=0.6;       // branch radius decrease ratio (1=constant radius)
#declare qab=0.6;       // branch angle decrease ratio (1=constant angle)
#declare stdax=10;      // stdev of x angle (angle x = ax+(0.5-rand)*stdax)
#declare stday=10;      // stdev of y angle (angle y = ay+(0.5-rand)*stday)

#declare branchproba=0.8; // probability of branch apparition 
#declare jb=0.1;        // secondary branches start after this ratio of branch length

#declare fgnarl=0.4;    // gnarledness factor - keep it low <0.8
#declare stdlseg=0.1;     // stddev of branch segment length (0...1) (adds more randomness to branch length)

#declare twigproba=0; // probability to have a twig on a trunk segment

#declare v0=<0,1,0>;    // initial direction - change to give an initial orientation
#declare pos0=<0,0,0>;  // initial trunk position (no need to change this one)

//-----------------------------------------
// constraints parameters
//-----------------------------------------
#declare vpush=<0,1,0>;// direction of push (wind, gravity...) <0,-1,0> = gravity ; <0,1,0> = antigravity
#declare fpush=1;       // force of push
#declare aboveground=0.5; // constrains the branches above this level 
#declare belowsky=1000;  // constrains the branches below this level 

//-----------------------------------------
// root parameters
//-----------------------------------------
#declare rootproba=1;   // probability of root 0=no root ; 1=all [nb] roots
#declare nroot=5;      // number of main roots;
#declare vroot=<1,-0.1,0>; // initial direction of root 
#declare yroot=<0,0.5,0>;   // initial position of root above ground

//-----------------------------------------
// leaf position parameters
//-----------------------------------------
#declare leafproba=1;   // probability of leaf 0=no leaf ; 1=leaf on each segment
#declare leaflevel=4;   // level where the leaves start to appear
#declare alz0=180;       // max z angle for leaf
#declare alx0=90;      // start x angle for leaf
#declare stdalx=60;     // std x angle for leaf
#declare stdlsize=1;  // stddev of leaf size 0=constant size; size = leafsize*(1+stdlsize*rand)

//-----------------------------------------
// leaf structure parameters
//-----------------------------------------
#declare txtLeaf=texture{txtLeaf_3} // Leaf texture
#declare lsize=0.4;     // leaf size
#declare seg=10;        // nb of leaf segments and stalk segments : increase to smooth
#declare ll=3;          // leaf length
#declare wl=0.6;          // leaf width 
#declare fl=0.1;        // depth of leaf fold
#declare lpow=0.3;        // modifies the leaf shape : lpow=3 makes heart-shaped leaf
#declare al=100;        // leaf bending angle : the leaf bends backward until this angle
#declare apow=1;        // curve power, how slow the leaf bends
#declare ndents=0;      // dents in the leaf (8 = "oak" leaf). May require a high seg >20
#declare nlobes=5;      // number of lobes (individual leaves)
#declare alobes=288;    // angle made by all the lobes
#declare qlobes=1;    // size of the farest lobe (0.9 = size will be 0.9*leaf length)                               
#declare ls=0;          // stalk length (0=no stalk)
#declare ws=0.1;        // width of stalk
#declare as=10;         // stalk bending angle : the stalk bends forward
//-----------------------------------------
// end of parameters
//=========================================

//=========================================
// Make the tree now !
//-----------------------------------------

#declare Busch=object{
        #if (leafproba>0)
        #declare Leaf=object{MakeLeaf(lsize,seg,ll,wl,fl,lpow,al,apow,
                 ndents,nlobes,alobes,qlobes,ls,ws,as,dofile,ffname)
                 #if (dotexture=false)  // no texture applied to tree segments, so the leaf texture must be used for the individual leaf
                        texture{txtLeaf}
                 #end
        } 
        
        #end              
        MakeTree()
        
        #if (dotexture = true) // texture is already applied to tree so that we can safely apply the leaf texture to the leaves
                texture {txtLeaf}
        #else

                texture {txtTree} // apply tree texture  regardless of the tree structure
        #end
        scale 1.5}
object {Busch
translate < -130,0,-20>}
object {Busch
translate <  130,0,-20>}
object {Busch
translate < -130,0,-50>}
object {Busch
translate <  130,0,-50>}
object {Busch
translate < -130,0,-80>}
object {Busch
translate <  130,0,-80>}
object {Busch
translate < -130,0,-110>}
object {Busch
translate <  130,0,-110>}
object {Busch
translate < -130,0,-140>}
object {Busch
translate <  130,0,-140>}
object {Busch
translate < -130,0,-170>}
object {Busch
translate <  130,0,-170>}


