/*
 *	Drape.pov
 *
 *	"An Offering to the POV-Ray Gods"
 *
 *	Created for the Jan-Feb 2001 IRTC topic "Worship"
 *	Copyright (c) 2001 Mark Wagner
 */

#declare cm = 1/2.54;		/* 1 POV unit = 1 inch */
#include "units.inc"		/* www.geocities.com/Rengaw03/Pov-Ray.html */

#include "bmpeople.inc"
#include "bm_hands.inc"
#include "OfferingPose.inc"
#include "clothutil.inc"

#macro WriteClothFile(nomfile, n1, n2, nlng, ks)
	#fopen file nomfile write
	#local tempx=0;
	#local tempy=0;
	#local tempz=0;
	#write(file, n1, ",", n2, ",", nlng, ",", ks, ",\n")

	#local l1 = nlng*(n1-1);
	#local l2 = nlng*(n2-1);
	#local h = 3*feet;
	#local st = seed(1234);
	#local i=0;
	#while (i<n1)
		#local j=0;
		#while (j<n2)
			#local tempx = -l1/2 + i*nlng;
			#local tempz = -l2/2 + j*nlng;
			#local tempy = h -.005+.01*rand(st);
			#write(file, tempx, ",", tempy, ",", tempz, ", 0.0, 0.0, 0.0\n")
			#local j=j+1;
		#end
		#local i=i+1;
	#end
	#fclose file
#end


/* The floor -- a checkered plane */
plane{y, 0 
	pigment{checker rgb 0, rgb 1 scale foot}
} 

/*
#declare BM_R_Hand = 0;
#declare BM_L_Hand = 0;
#declare BM_Head_Mass = 0;
#declare BM_R_Upperarm_Mass = 0;  
#declare BM_L_Upperarm_Mass = 0;
#declare BM_R_Forearm_Mass  = 0; 
#declare BM_L_Forearm_Mass  = 0;   
#declare BM_Ears = 0;
#declare BM_Eyes = 0;
#declare BM_Face = 0;
*/


Blob_Man(Male,6*feet)
#declare Figure = object{
	BlobMan
	transform BMO_Knee_R 
	translate <0,1,0>*BM_Scale
	translate y*1*inch
}

//WriteClothFile("outfile.cth",100, 100, 1*inch, 20)
//#declare dummy = clothsim(Figure, -y, -y, 1, .9, .05, 200, "outfile.cth", "outfile.cth");
#undef Points
ReadClothFile("outfile.cth")


union{
	object{Figure}
	mesh{
		DrawTriangles(Points,100,100,off,0,0)
		//translate y*2*inch
		scale 1.1
		pigment{rgb 1}
		//clipped_by{box{<-20,.25,-20>*feet,<20,20,20>*feet}}
	}
}

#declare ViewFromAbove = camera{ /* God-s-eye view */
	location <5,20,10>*feet
	look_at <.3,2.35,-1.2>*feet
	angle 45
}

camera{ViewFromAbove}

light_source{<100,100,100>*feet, 1}
