/*
 *	Offering.pov
 *
 *	"An Offering to the POV-Ray Gods"
 *
 *	Created for the Jan-Feb 2001 IRTC topic "Worship"
 *	Copyright (c) 2001 Mark Wagner
 *
 * Inspired by Thomas Lake's postings on povray.binaries.images
 */

#version unofficial MegaPOV 0.5; // Actually, needs to be POV-Man 0.62 or later

#declare included = true;

#include "colors.inc"
#include "textures.inc"
#include "woods.inc"

#include "clothutil.inc"	/* From ClothRay */

#declare cm = 1/2.54;		/* 1 POV unit = 1 inch */
#include "units.inc"		/* www.geocities.com/Rengaw03/Pov-Ray.html */

//global_settings{assumed_gamma 1}

#include "OfferItems.inc"
#include "OfferingCCP.inc"

/* The floor -- a checkered plane */
plane{y, 0 
	texture{
		checker
		texture{EMBWood1 rotate y*90 scale 1/foot},
		texture{T_Wood14 rotate y*90 scale 1/foot}
		scale foot
	}
}
/*plane{z,-5*feet
	pigment{rgb 1}
	finish{ambient 0 diffuse .8}
}
box{<-20,-1,-5>*feet,<20,0,20>*feet
	pigment{checker rgb 1, rgb 0 scale foot}
	finish{ambient 0 diffuse .8 reflection .1}
}*/


/* Altar */
union{
	union{
		box{<-1.9,2.5,-.9>*feet,<1.9,3,.9>*feet}
		pigment{rgb <1,1,1>}
	}
	#declare TableClothMesh = mesh{#include "Tablclth.msh"}
//	ReadClothFile("box.cth")
//	DrawSmoothTriangles(Points,80,80,off,yes,"Tablclth.msh")
	object{
		TableClothMesh
		clipped_by{box{<-2.5,.65,-1.5>*feet,<2.5,4,1.5>*feet}}
		scale <1.1,1.0,1.1>
		pigment{rgb 1}
		finish{diffuse 1.5}
	}
	object{
		TableClothMesh
		clipped_by{box{<-2.5,.5,-1.5>*feet,<2.5,.65,1.5>*feet}}
		scale <1.1,1.0,1.1>
		//pigment{rgb <1,1,0>}
		pigment{rgb <1,.675,.175>}
		finish{
			ambient .1 
			diffuse 1.5 //.8
			specular 1
		}
	}

	union{
		object{ Candle_Stick1 translate <-1,3,-.25>*feet }
		object{ Candle_Stick1 translate <1,3,-.25>*feet }
	}
	sphere{<0,3.4,-.25>*feet, .3*feet
		pigment{rgb <1,1,1>}
		finish{
			ambient .1
			diffuse 0
			reflection 1
			specular 1
			roughness .01
		}
	} 
	translate z*-4*feet+x*4*inch
}


/* Kneeling blob-man */
#declare BM_Skin_Tex = texture{
	pigment{
		shader{
			shader_file "skin.slp"
			"As"  <1,1,1>*0.4
			"skinColor"  <0.8, 0.65, 0.6>
		}
	}
	finish{
		ambient 1
		diffuse 0
	}
}
#include "bmpeople.inc"
#include "bm_hands.inc"
#include "OfferingPose.inc"
Blob_Man(Male,6*feet)
union{
	object{
		BlobMan
		transform BMO_Knee_R 
		translate <0,1,0>*BM_Scale
		translate y*1*inch
	}
//	#undef Points
//	ReadClothFile("outfile.cth")
//	DrawSmoothTriangles(Points,100,100,off,yes,"Robe.msh")
	/* Robe */
	#declare Robe = mesh{#include "Robe.msh"}
	object{
		Robe
		scale <1.2,1.1,1.1>
		pigment{rgb 1}
		clipped_by{box{<-20,.85,-20>*feet, <20,20,20>*feet}}
	}
	/* Hem */
	object{
		Robe
		scale <1.2,1.1,1.1>
		pigment{SlateBlue}
		clipped_by{box{<-20,.75,-20>*feet, <20,.85,20>*feet}}
	}
}
/* Bowl with offering */
#declare OfferingBowl = intersection{
	difference{
		sphere{0, 6*inch}
		sphere{0, 5*inch}
	}
	box{<-1,-1,-1>*feet, <1,0,1>*feet}
	texture{DMFWood6}
}

/* Fill it with primitives */ /* Cube, torus, cylinder, sphere, cone, superellipsoid */
#declare OfferingTypes = array[5]
{
	sphere{0, 1*inch},
	torus{.75*inch, .25*inch},
	cylinder{y*-1*inch, y*1*inch, 1*inch},
	cone{y*-1*inch, 1*inch, y*1*inch, 0*inch},
	superellipsoid{<.25,.25>}	
}
#declare OfferingColors = array[11]
{
	color SpicyPink,
	color Med_Purple,
	color MediumBlue,
	color NavyBlue,
	color LimeGreen,
	
	color MediumSpringGreen
	color BrightGold,
	color OldGold,
	color Coral,
	color OrangeRed,
	
	color Scarlet
}

#declare Offering = Spherer(sphere{0, 4.5*inch}, 1*inch, OfferingTypes, OfferingColors, 4)

union{
	object{OfferingBowl}
	object{Offering rotate y*15}
	translate y*2.4*feet+z*-1.2*feet+x*4*inches
}

#declare ViewFromBack = camera{
	location <1,1,1>*5*feet
	look_at <0,1.5,0>*feet
}
#declare ViewFromAbove = camera{ /* God-s-eye view */
	location <5,20,10>*feet
	look_at <.3,2.35,-1.2>*feet
	angle 45
}
/*camera{
	location <.5,2,.5>*5*feet
	look_at <.3,2.35,-1.2>*feet
	angle 20
}*/
camera{ViewFromAbove}

//lght_source{<100,100,100>*feet, 1}
/* Large-area light aimed at offering */
light_source{
	<10,100,35>*feet
	rgb .75 //1
	spotlight
	radius 0
	falloff 4
	point_at <.3,2.35,-1.2>*feet
}

/* Light enclosing only blobman */
/*light_source{
	<10,100,35>*feet
	rgb 1
	spotlight
	radius 1
	falloff 1.5
	point_at <.3,2.35,0>*feet
}*/

/* Light aimed exclusively at offering */
light_source{
	//<10,100,35>*feet
	<-30,100,35>*feet
	rgb 1
	spotlight
	radius .22
	falloff .27
	point_at <.3,2.35,-1.2>*feet
}
