// Persistence Of Vision INCLUDE file
// File:    bearchurch.inc
// Vers:    3.1g.r1 Mac PPC
// Desc:    Bears in church
// Uses:    tedbearm.inc
// Auth:    Peter Murray

#debug "\r  bearchurch.inc - Bears in church\r"

//------------------------------------------------------------
/*#declare DirtTouch=
texture{
  pigment{
    spotted
    colour_map{
      [0.00 colour rgbf <.3,.3,.3,0.75>]
      [0.05 colour rgbf <.4,.4,.4,0.75>]
      [0.06 colour rgbf <1,1,1,1>]
      [1.00 colour rgbf <1,1,1,1>]
    }
    rotate y*45
    scale 0.25
  }
}*/

/*#declare DirtSpatter=
texture{
  pigment{
    spotted
    colour_map{
      [0.00 colour rgbf <.3,.3,.3,0.75>]
      [0.15 colour rgbf <.4,.4,.4,0.75>]
      [0.16 colour rgbf <1,1,1,1>]
      [1.00 colour rgbf <1,1,1,1>]
    }
    rotate y*45
    scale 0.25
  }
}*/

/*#declare DirtSmear=
texture{
  pigment{
    spotted
    colour_map{
      [0.00 colour rgbf <.3,.3,.3,0.5>]
      [0.25 colour rgbf <.4,.4,.4,0.5>]
      [0.26 colour rgbf <1,1,1,1>]
      [1.00 colour rgbf <1,1,1,1>]
    }
    rotate y*45
    scale 0.10
  }
}*/

#declare DoorWood=
texture{
	T_Wood32
	pigment{warp{repeat <0,0.5,0>*in offset <0,8,0>*in flip <0,1,1>}}
	normal{gradient x scale 0.5*in
		slope_map{
			[0.00 <0,0>]
			[0.45 <0,0>]
			[0.46 <0,1>]
			[0.50 <1,0>]
			[0.54 <0,1>]
			[0.55 <0,0>]
			[1.00 <0,0>]
		}
	}
}

#declare DoorMetal=
texture{
	pigment{colour rgb <0.1,0.1,0.15>}
	finish{F_MetalA}
	normal{bumps 0.1}
}

#declare InchGridXZ=normal{
	gradient x+z
	slope_map{
		[0.00 <0,0>]
		[0.45 <0,0>]
		[0.46 <0,-1>]
		[0.50 <-1,0>]
		[0.54 <0,-1>]
		[0.55 <0,0>]
		[1.00 <0,0>]
	}
}

/*#declare InchGridY=normal{
	gradient y
	slope_map{
		[0.00 <0,0>]
		[0.45 <0,0>]
		[0.46 <0,1>]
		[0.50 <1,0>]
		[0.54 <0,1>]
		[0.55 <0,0>]
		[1.00 <0,0>]
	}
}*/

//------------------------------------------------------------
// Scenery/utility objects

#declare Marker=
union{
	cylinder{<-6,0,0>*in,<6,0,0>*in,0.25*in}
	cylinder{<0,-6,0>*in,<0,6,0>*in,0.25*in}
	cylinder{<0,0,-6>*in,<0,0,6>*in,0.25*in}
	no_shadow
	texture{RedPt}
}

#declare TextPlaque=
union{
	#local UseFont="timrom.ttf"//"BROKLRC0.ttf"//"palatino.ttf"//"palatii.ttf"//"palatbi.ttf"
	text{
		ttf UseFont,"pdmhoney.jpg",0.2*in,<0.2,0,0> scale <0.5,0.5,0.5>
		rotate y*-90 translate <0,5.75,0>*in texture{Grey25Pt}
	}
	text{
		ttf UseFont,"copyright Peter Murray",0.2*in,<0.1,0,0> scale 0.4
		rotate y*-90 translate <0,5.30,0>*in texture{Grey50Pt}
	}
	text{
		ttf UseFont," 26 Feb 2001",0.2*in,<0.1,0,0> scale <0.3,0.4,0.4>
		rotate y*-90 translate <0,4.85,0>*in texture{Grey50Pt}
	}
	text{
		ttf UseFont,"Worship (Jan-Feb 2001)",0.2*in,<0.1,0,0> scale <0.3,0.4,0.4>
		rotate y*-90 translate <0,4.40,0>*in texture{Grey50Pt}
	}
	text{
		ttf UseFont,"Internet Raytracing Competition",0.2*in,<0.1,0,0> scale <0.3,0.4,0.4>
		rotate y*-90 translate <0,3.95,0>*in texture{Grey50Pt}
	}
}
               
#declare PewEnd=
difference{
	union{
		difference{
			box{<-0.125,0,-1>*in,<0.125,2,1>*in}//start with this
			box{<-0.15,1.25,0.25>*in,<0.15,2.1,1.1>*in}//no side at front
			box{<-0.15,0.25,-0.75>*in,<0.15,0.75,0.75>*in}//only support lower
			box{<-0.15,1,0.75>*in,<0.15,1.5,1.25>*in}//cut out where hand rests
		}
		box{<-0.125,0,-1.5>*in,<0.125,0.25,-1>*in}//add a bit for kneeler
		cylinder{//circular top at side
			<-0.125,0,-0.375>*in,<0.125,0,-0.375>*in,0.625*in
			scale <1,0.5,1> translate <0,2,0>*in
		}
		cylinder{<-0.125,1,0.75>*in,<0.125,1,0.75>*in,0.25*in}//hand rests here
	}
	box{//ornate cutout vertical
		<-0.15,-0.125,-0.125>*in,<0.15,0.125,0.125>*in
		rotate <45,0,0> scale <1,2,1> translate <0,1.75,-0.25>*in
	}
	box{//ornate cutout horizontal
		<-0.15,-0.125,-0.125>*in,<0.15,0.125,0.125>*in
		rotate <45,0,0> scale <1,1,2> translate <0,1.75,-0.25>*in
	}
	texture{T_Wood32 rotate <-15,30,0>}
}
              
#declare Pew=
union{
	object{PewEnd translate <-3.875,0,0>*in}
	object{PewEnd translate <3.875,0,0>*in}
	//seat
	box{<-3.75,0.875,-0.75>*in,<3.75,0.975,0.25>*in texture{T_Wood32 rotate <15,-30,0>}}
	//back
	box{<-3.75,0.75,-0.875>*in,<3.75,1.1,-0.75>*in texture{T_Wood32 rotate <12,12,0>}}
	box{<-3.75,1.65,-0.875>*in,<3.75,2,-0.75>*in texture{T_Wood32 rotate <12,-12,0>}}
	//vertical bars in back
	box{<-2.125,1.1,-0.875>*in,<-1.875,1.65,-0.75>*in texture{T_Wood32 rotate <30,-15,0>}}
	box{<-0.125,1.1,-0.875>*in,<0.125,1.65,-0.75>*in texture{T_Wood32 rotate <30,-15,0>}}
	box{<1.875,1.1,-0.875>*in,<2.125,1.65,-0.75>*in texture{T_Wood32 rotate <30,-15,0>}}
	//shelf for prayer books
	box{<-3.75,1.7,-0.875>*in,<3.75,1.8,-1.125>*in texture{T_Wood32 rotate <-12,12,0>}}
	//kneeler
	box{<-3.75,0.1,-1.4>*in,<3.75,0.2,-1.1>*in texture{T_Wood32 rotate <-12,12,0>}}
}

#declare GothicOpening=
union{
	box{<-3,-0.5,-0.75>*in,<3,3,0.75>*in}
	intersection{
		cylinder{<0,0,-0.75>*in,<0,0,0.75>*in,1*in scale <6,4,1> translate <3,3,0>*in}
		box{<-3,2.9,-1>*in,<0.01,7,1>*in}
	}
	intersection{
		cylinder{<0,0,-0.75>*in,<0,0,0.75>*in,1*in scale <6,4,1> translate <-3,3,0>*in}
		box{<-0.01,2.9,-1>*in,<3,7,1>*in}
	}
}

#declare GothicDoor=
union{
	box{<-3,0,-0.15>*in,<-0.01,3,0.15>*in}
	intersection{
		cylinder{<0,0,-0.15>*in,<0,0,0.15>*in,1*in scale <6,4,1> translate <3,3,0>*in}
		box{<-3,2.9,-0.16>*in,<-0.01,7,0.16>*in}
	}        
	//hinges
	cylinder{<-2.9,0.8,-0.25>*in,<-2.9,1,-0.25>*in,0.1*in texture{DoorMetal}}
	cylinder{<-2.9,2.5,-0.25>*in,<-2.9,2.7,-0.25>*in,0.1*in texture{DoorMetal}}
	//straps
	triangle{<-3,0.8,-0.2>*in,<-3,1,-0.2>*in,<-0.5,0.9,-0.2>*in texture{DoorMetal}}
	cylinder{<-2.5,0.9,-0.25>*in,<-2.5,0.9,0.25>*in,0.05*in texture{DoorMetal}}
	cylinder{<-1.5,0.9,-0.25>*in,<-1.5,0.9,0.25>*in,0.05*in texture{DoorMetal}}
	cylinder{<-0.5,0.9,-0.25>*in,<-0.5,0.9,0.25>*in,0.05*in texture{DoorMetal}}
	triangle{<-3,2.5,-0.2>*in,<-3,2.7,-0.2>*in,<-0.5,2.6,-0.2>*in texture{DoorMetal}}
	cylinder{<-2.5,2.6,-0.25>*in,<-2.5,2.6,0.25>*in,0.05*in texture{DoorMetal}}
	cylinder{<-1.5,2.6,-0.25>*in,<-1.5,2.6,0.25>*in,0.05*in texture{DoorMetal}}
	cylinder{<-0.5,2.6,-0.25>*in,<-0.5,2.6,0.25>*in,0.05*in texture{DoorMetal}}
	//handle
	union{
		cylinder{<-0.4,3,-0.2>*in,<-0.4,3,0.2>*in,0.2*in}
		cylinder{<-0.4,3,-0.5>*in,<-0.4,3,0.5>*in,0.1*in}
		sphere{0,0.15*in scale <1,1,0.5> translate <-0.4,3,-0.5>*in}
		torus{0.25*in,0.075*in rotate <90,0,0> translate <-0.4,2.75,-0.3>*in}
		sphere{0,0.15*in scale <1,1,0.5> translate <-0.4,3,0.5>*in}
		torus{0.25*in,0.075*in rotate <90,0,0> translate <-0.4,2.75,0.3>*in}
		texture{DoorMetal}
	}
	//correct the origin to the hinge axis
	translate <3,0,0>*in
}

#declare Column1=
union{
	box{<-0.5,0,-0.5>*in,<0.5,0.375,0.5>*in}
	cylinder{<0,0.375,0>*in,<0,0.625,0>*in,0.5*in}
	#local Rotn=0;
	#while (Rotn<360)
		cylinder{<0.25,0.625,0>*in,<0.25,9.375,0>*in,0.25*in rotate <0,Rotn,0>}
		#local Rotn=Rotn+60;
	#end
	cylinder{<0,9.375,0>*in,<0,9.625,0>*in,0.5*in}
	box{<-0.5,9.625,-0.5>*in,<0.5,10,0.5>*in}
	texture{ChurchStone translate <0,-10,0>*ft}
}

#declare GothicArch=
difference{
	intersection{
		box{<-0.5,-0.5,-0.5>*in,<0.5,0.5,0.5>*in rotate <0,0,45> scale <25/acos(radians(45)),10,1> translate <0,10,0>*in}
		box{<-12.5,10,-0.6>*in,<12.5,18,0.6>*in}
	}
	cylinder{<0,0,-0.7>*in,<0,0,0.7>*in,0.5*in scale <22,6,1> translate <0,10,0>*in}
	cylinder{<0,0,-0.7>*in,<0,0,0.7>*in,0.5*in scale <14,6,1> translate <0,11.5,0>*in}
	cylinder{<0,0,-0.7>*in,<0,0,0.7>*in,0.5*in scale <6,6,1> translate <0,13,0>*in}
	texture{ChurchStone translate <0,-30,0>*ft}
}

#declare Altar=
union{
	//Wooden frame
	difference{
		box{<-3,0,-1>*in,<3,2,1>*in}
		box{<-3.1,-0.1,-0.75>*in,<3.1,1.75,0.75>*in}
		box{<-2.75,0.25,-1.1>*in,<2.75,1.75,1.1>*in}
		texture{T_Wood33}
	}             
	//Frontal cloth
	union{
		box{<-3.05,0.05,-1.05>*in,<3.05,1.9,1.05>*in}
		box{<-2.9,1.85,-0.9>*in,<2.9,2.05,0.9>*in}
		//smooth the top edges
		cylinder{<-2.9,1.9,-0.9>*in,<-2.9,1.9,0.9>*in,0.15*in}
		cylinder{<2.9,1.9,-0.9>*in,<2.9,1.9,0.9>*in,0.15*in}
		cylinder{<-2.9,1.9,-0.9>*in,<2.9,1.9,-0.9>*in,0.15*in}
		cylinder{<-2.9,1.9,0.9>*in,<2.9,1.9,0.9>*in,0.15*in}
		sphere{<-2.9,1.9,-0.9>*in,0.15*in}
		sphere{<2.9,1.9,-0.9>*in,0.15*in}
		sphere{<-2.9,1.9,0.9>*in,0.15*in}
		sphere{<2.9,1.9,0.9>*in,0.15*in}
		//make the corners look like the photo in the book
		cone{<0,0.05,0>*in,0.5*in,<0,2.05,0>*in,0 scale <0.3,1,1> translate <-2.9,0,-1.05>*in}
		cone{<0,0.05,0>*in,0.5*in,<0,2.05,0>*in,0 scale <0.3,1,1> translate <2.9,0,-1.05>*in}
		cone{<0,0.05,0>*in,0.5*in,<0,2.05,0>*in,0 scale <0.3,1,1> translate <-2.9,0,1.05>*in}
		cone{<0,0.05,0>*in,0.5*in,<0,2.05,0>*in,0 scale <0.3,1,1> translate <2.9,0,1.05>*in}
		cone{<0,0.05,0>*in,0.5*in,<0,2.05,0>*in,0 scale <1,1,0.3> translate <-3.05,0,-0.9>*in}
		cone{<0,0.05,0>*in,0.5*in,<0,2.05,0>*in,0 scale <1,1,0.3> translate <3.05,0,-0.9>*in}
		cone{<0,0.05,0>*in,0.5*in,<0,2.05,0>*in,0 scale <1,1,0.3> translate <-3.05,0,0.9>*in}
		cone{<0,0.05,0>*in,0.5*in,<0,2.05,0>*in,0 scale <1,1,0.3> translate <3.05,0,0.9>*in}
		texture{AltarFrontal}
  }
	//Fair linen, or altar cloth
	union{
		box{<-3.1,0.5,-0.75>*in,<3.1,1.95,0.75>*in}
		box{<-2.95,1.9,-0.75>*in,<2.95,2.1,0.75>*in}
		cylinder{<-2.95,1.95,-0.75>*in,<-2.95,1.95,0.75>*in,0.15*in}
		cylinder{<2.95,1.95,-0.75>*in,<2.95,1.95,0.75>*in,0.15*in}
		texture{AltarCloth}
	}
}

#declare Honeypot=
union{
	union{//the pot                              
		torus{0.15*in,0.05*in translate <0,0.95,0>*in}
		cylinder{<0,0.75,0>*in,<0,0.95,0>*in,0.15*in open}
		torus{0.2*in,0.05*in translate <0,0.75,0>*in}
		cylinder{<0,0.75,0>*in,<0,0.80,0>*in,0.2*in open}
		cylinder{<0,0.05,0>*in,<0,0.75,0>*in,0.25*in open}
		cylinder{<0,0,0>*in,<0,0.05,0>*in,0.2*in}
		torus{0.2*in,0.05*in translate <0,0.05,0>*in}
		texture{pigment{Gold} finish{Metal} normal{crackle scale 0.1}} //{radial frequency 36}}
	}
	difference{//the cap
		cylinder{<0,0.88,0>*in,<0,1.02,0>*in,0.22*in}
		cylinder{<0,0.90,0>*in,<0,1.0,0>*in,0.21*in}
		cylinder{<0,0.86,0>*in,<0,1.0,0>*in,0.19*in}
		texture{pigment{Gold} finish{Metal} normal{radial frequency 36 phase 4}}
	}
	difference{//the "label"
		cylinder{<0,0.3,0>*in,<0,0.6,0>*in,0.265*in}
		box{<-0.3,0.2,0>*in,<0.3,0.7,0.3>*in}
		texture{pigment{Gold} finish{Metal} normal{gradient y scale <0.5,0.05,0.5>}}
	}
}

#declare CarvedPost=
union{
	box{<-0.12,0.25,-0.12>*in,<0.12,0.625,0.12>*in}
	cone{<0,0.625,0>*in,0.12*in,<0,0.75,0>*in,0.06*in}
	cylinder{<0,0.75,0>*in,<0,1.375,0>*in,0.06*in}
	cone{<0,1.375,0>*in,0.06*in,<0,1.5,0>*in,0.12*in}
	box{<-0.12,1.5,-0.12>*in,<0.12,1.75,0.12>*in}
	//texture{T_Wood19 scale 0.1}	
}

#declare WoodenRailings=
union{
	//floor
	box{<-9.875,0,0.125>*in,<-2.25,0.25,0.375>*in texture{T_Wood19 scale 0.1 rotate <30,0,45>}}
	box{<2.25,0,0.125>*in,<9.875,0.25,0.375>*in texture{T_Wood19 scale 0.1 rotate <30,0,45>}}
	box{<-9.875,0,0.375>*in,<-9.625,0.25,9.875>*in texture{T_Wood19 scale 0.1 rotate <45,0,30>}}
	box{<9.875,0,0.375>*in,<9.625,0.25,9.875>*in texture{T_Wood19 scale 0.1 rotate <-15,0,30>}}
	//handrail
	box{<-9.875,1.75,0.125>*in,<-2.25,2,0.375>*in texture{T_Wood19 scale 0.1 rotate <-30,0,45>}}
	box{<2.25,1.75,0.125>*in,<9.875,2,0.375>*in texture{T_Wood19 scale 0.1 rotate <-30,0,45>}}
	box{<-9.875,1.75,0.375>*in,<-9.625,2,9.875>*in texture{T_Wood19 scale 0.1 rotate <-45,0,30>}}
	box{<9.875,1.75,0.375>*in,<9.625,2,9.875>*in texture{T_Wood19 scale 0.1 rotate <15,0,30>}}
	//posts along front
	#local XX=8.75;
	#while (XX>2)
		object{CarvedPost translate <-XX,0,0.25>*in}
		object{CarvedPost translate <XX,0,0.25>*in}
		#local XX=XX-1;
	#end
	//posts along sides
	#local ZZ=0.25;
	#while (ZZ<=10)
		object{CarvedPost translate <-9.75,0,ZZ>*in}
		object{CarvedPost translate <9.75,0,ZZ>*in}
		#local ZZ=ZZ+1;
	#end
	texture{T_Wood19 scale 0.1}
}

#declare TestAltar=
union{
	box{<-10,0,0>*in,<10,1,10>*in texture{ChurchStone translate <0,2,0>*ft}}
	object{Altar translate <0,1,3>*in}
	BeckettCostume()
	object{
		//Baffler(
		TeddyBearRev(
			<0,1,5>*in,<0,190,0>,
			BeckettPose,BeckettTx,BeckettData,BeckettScale
		)
	}
	BavingtonCostume()
	object{
		TeddyBearRev(
			<4,1,6>*in,<0,180,0>,
			BavingtonPose,BavingtonTx,BavingtonData,BavingtonScale
		)
	}
	object{
		TeddyBearRev(
			<-4.5,1,6>*in,<0,165,0>,
			BavingtonPose,BlinkyTx,BlinkyData,BlinkyScale
		)
	}
	object{Honeypot translate <2,3.1,3>*in}
	object{Honeypot translate <-2,3.1,3>*in}
	object{WoodenRailings translate <0,1,0>*in}
	//steps down - added later, hence wood instead of stone
	box{<-3.25,0,-1>*in,<3.25,0.25,0>*in texture{T_Wood19 scale 0.1 rotate <-90,0,-15>}}
	box{<-3,0.25,-0.75>*in,<3,0.5,0>*in texture{T_Wood19 scale 0.1 rotate <-120,0,-15>}}
	box{<-2.75,0.5,-0.5>*in,<2.75,0.75,0>*in texture{T_Wood19 scale 0.1 rotate <-150,0,-15>}}
	box{<-2.5,0.75,-0.25>*in,<2.5,1,0>*in texture{T_Wood19 scale 0.1 rotate <-180,0,-15>}}
}

#declare TestCongregation=
union{
	#local Counter=40;
	//object{Pew translate <0,0,4>*in}
	object{Pew translate <0,0,0>*in}
	object{Parishioner(Counter  ) translate <3,0.25,0>*in}
	object{Parishioner(Counter+1) translate <0,0.25,0>*in}
	object{Parishioner(Counter+2) translate <-3,0.25,0>*in}
	//object{Pew translate <0,0,-4>*in}
	//object{Parishioner(Counter+6) translate <3,0.25,-4>*in}
	//object{Parishioner(Counter+7) translate <0,0.25,-4>*in}
	//object{Parishioner(Counter+8) translate <-3,0.25,-4>*in}
	//rotate <0,180,0>
	rotate <0,210,0>
	//rotate <0,260,0>
	//rotate <0,-60,0>
	//translate <0,0,-4>*in
	translate <0,0,-8>*in
}

#declare GothicFrame=
union{
	box{<-3.5,-0.5,-0.65>*in,<3.5,0,0.15>*in texture{ChurchFloor rotate <0,45,0> scale 0.5}}
	box{<-3.5,0,-0.65>*in,<-2.95,3,0.15>*in texture{ChurchFloor rotate <0,0,45> scale 0.5}}
	box{<-3.6,2.9,-0.75>*in,<-2.95,3.1,0.25>*in texture{ChurchFloor rotate <0,0,-60> scale 0.5}}
	box{<3.5,0,-0.65>*in,<2.95,3,0.15>*in texture{ChurchFloor rotate <0,0,-45> scale 0.5}}
	box{<3.6,2.9,-0.75>*in,<2.95,3.1,0.25>*in texture{ChurchFloor rotate <0,0,60> scale 0.5}}
	difference{
		intersection{
			cylinder{<0,0,-0.65>*in,<0,0,0.15>*in,1*in scale <7,4.5,1> translate <3.5,3,0>*in}
			box{<-3.5,3,-0.651>*in,<0.01,7,0.151>*in}
		}
		cylinder{<0,0,-0.7>*in,<0,0,0.2>*in,1*in scale <5.9,3.9,1> translate <3,3,0>*in}
		texture{ChurchFloor rotate <45,0,-45> scale 0.5}
	}
	difference{
		intersection{
			cylinder{<0,0,-0.65>*in,<0,0,0.15>*in,1*in scale <7,4.5,1> translate <-3.5,3,0>*in}
			box{<3.5,3,-0.651>*in,<-0.01,7,0.151>*in}
		}
		cylinder{<0,0,-0.7>*in,<0,0,0.2>*in,1*in scale <5.9,3.9,1> translate <-3,3,0>*in}
		texture{ChurchFloor rotate <-45,0,45> scale 0.5}
	}
}

#declare BosieGlass=
union{
	object{GothicFrame translate <0,0,0>*in}
	/*
	box{
		<-3,-0.1,-0.3>*in,<3,6.9,-0.2>*in
		interior{I_Glass}
		texture{BosieWindow}
	}
	*/
	object{
		GothicOpening scale <1,1,0.1> translate <0,0,0>*in
		interior{I_Glass}
		texture{BosieWindow}
	}
}

#declare TestWindow=
union{
	difference{//wall opposite priest
		box{<-12.5,-6,-0.5>*in,<12.5,10,0>*in}
		object{GothicOpening translate <0,0,0>*in}
		texture{ChurchStone translate <-10,0,5>*ft}
		//texture{Grey50Pt}
	}
	object{GothicFrame translate <0,0,0>*in}
	object{BosieGlass translate <0,0,0>*in}	
}

//------------------------------------------------------------

#if (Setting=0)
	object{TestCongregation}
	//object{TestWindow}
	/*
	union{
		object{GothicFrame translate <0,0,0>*in} //for door
		object{
			GothicDoor
			texture{DoorWood translate <-3.5,0,0>*in}
			rotate y*45 translate <-3,0,-0.45>*in
		}
		object{
			GothicDoor scale <-1,1,1>
			texture{DoorWood translate <48.5,0,-30>*in}
			rotate y*0 translate <3,0,-0.45>*in
		}
		//rotate y*180
		translate <0,0,-6>*in
	}
	*/
	//object{BosieGlass}
	/*
	#local Test=object{CarvedPost scale 3}
	object{Test translate <4,0,0>*in}
	object{Test rotate y*-90 translate <-4,0,0>*in}
	//object{Test rotate y*-90 rotate x*-90 translate <-6,5,4>*in}
	object{Test rotate y*45 translate <4,5,4>*in}
	*/
#end //of Setting=0

// Build the church
#if (Setting=1)
	//Put a globe around the scene
	sphere{
		<0,0,0>*in,6*ft hollow
		texture{
			pigment{
				colour rgb <0.6,0.6,0.9>
			}
			finish{
				reflection 1
			}
		}
	}
	#if (Hazy=1)
		//media{scattering{2,rgb <0.0025,0.0025,0.0035>}}
		fog{
			distance 500*ft
			colour rgbf <0.5,0.5,0.5,0.75>
		}
		//media{scattering{2,rgb <0.005,0.005,0.005>}}
		//media{scattering{2,rgb <0.01,0.01,0.01>}}
	#end
	//grass all around
	box{<-100,-1,-200>*in,<100,-0.1,200>*in texture{pigment{Green}}}
	//floor
	box{<-12.5,-1,-36.5>*in,<12.5,0,10.5>*in texture{ChurchFloor}}
	object{TestAltar}
	//walls
	difference{//wall opposite priest
		box{<-12.5,0,-36.5>*in,<12.5,10,-36>*in}
		object{GothicOpening translate <0,0,-36>*in}
		texture{ChurchStone translate <-10,0,5>*ft}
	}
	//columns and ledge
	box{<-12.5,9.5,-35>*in,<12.5,10,-36>*in texture{ChurchStone translate <-40,0,25>*ft}}
	object{Column1 translate <-5,0,-35.5>*in}
	object{Column1 translate <5,0,-35.5>*in}
	object{GothicFrame translate <0,0,-36>*in} //for door
	//main church door
	object{
		GothicDoor
		texture{DoorWood}
		rotate y*0 translate <-3,0,-36.45>*in
	}
	object{
		GothicDoor scale <-1,1,1>
		texture{DoorWood translate <48,0,-30>*in}
		rotate y*0 translate <3,0,-36.45>*in
	}
	difference{//wall behind priest
		box{<-12.5,0,10.5>*in,<12.5,10,10>*in}
		object{GothicOpening rotate <0,180,0> scale <2/3,0.9,1> translate <0,1,10>*in}
		texture{ChurchStone translate <-10,0,5>*ft}
	}                                            
	//columns and ledge
	box{<-12.5,9.5,9.5>*in,<12.5,10,10>*in texture{ChurchStone translate <40,0,-25>*ft}}
	object{Column1 translate <-5,0,9.5>*in}
	object{Column1 translate <5,0,9.5>*in}
	object{GothicFrame rotate <0,180,0> scale <2/3,0.9,1> translate <0,1,10>*in} //for door
	//priest's door
	object{
		GothicDoor scale <2/3,0.9,1>
		texture{DoorWood}
		rotate y*180 translate <-2,1,9.55>*in
	}
	object{
		GothicDoor scale <-2/3,0.9,1>
		texture{DoorWood translate <48,0,-30>*in}
		rotate y*180 translate <2,1,9.55>*in
	}
	#if (ViewPoint.x>-12)
		difference{//right wall from priest's view
			box{<-12.5,0,-36.5>*in,<-12,13,10.5>*in}
			object{GothicOpening rotate <0,90,0> scale <1,0.5,2/3> translate <-12,6,5>*in}
			object{GothicOpening rotate <0,90,0> scale <1,0.5,2/3> translate <-12,6,-11>*in}
			object{GothicOpening rotate <0,90,0> scale <1,0.5,2/3> translate <-12,6,-27>*in}
			texture{ChurchStone translate <10,0,-5>*ft}
		}
		object{GothicFrame rotate <0,90,0> scale <1,0.5,2/3> translate <-12,6,5>*in}
		object{BosieGlass rotate <0,90,0> scale <1,0.5,2/3> translate <-12,6,5>*in}
		object{GothicFrame rotate <0,90,0> scale <1,0.5,2/3> translate <-12,6,-11>*in}
		object{BosieGlass rotate <0,90,0> scale <1,0.5,2/3> translate <-12,6,-11>*in}
		object{GothicFrame rotate <0,90,0> scale <1,0.5,2/3> translate <-12,6,-27>*in}
		object{BosieGlass rotate <0,90,0> scale <1,0.5,2/3> translate <-12,6,-27>*in}
	#end
	box{<-12.5,9.5,-36.5>*in,<-11.5,10.25,10.5>*in texture{ChurchStone translate <0,-10,0>*ft}}
	#if (ViewPoint.x<12)
		difference{//left wall from priest's view
			box{<12.5,0,-36.5>*in,<12,13,10.5>*in}
			object{GothicOpening rotate <0,-90,0> scale <1,0.5,2/3> translate <12,6,5>*in}
			object{GothicOpening rotate <0,-90,0> scale <1,0.5,2/3> translate <12,6,-11>*in}
			object{GothicOpening rotate <0,-90,0> scale <1,0.5,2/3> translate <12,6,-27>*in}
			texture{ChurchStone translate <10,0,-5>*ft}
		}
		object{GothicFrame rotate <0,-90,0> scale <1,0.5,2/3> translate <12,6,5>*in}
		object{BosieGlass rotate <0,-90,0> scale <1,0.5,2/3> translate <12,6,5>*in}
		object{GothicFrame rotate <0,-90,0> scale <1,0.5,2/3> translate <12,6,-11>*in}
		object{BosieGlass rotate <0,-90,0> scale <1,0.5,2/3> translate <12,6,-11>*in}
		object{GothicFrame rotate <0,-90,0> scale <1,0.5,2/3> translate <12,6,-27>*in}
		object{BosieGlass rotate <0,-90,0> scale <1,0.5,2/3> translate <12,6,-27>*in}
	#end
	box{<12.5,9.5,-36.5>*in,<11.5,10.25,10.5>*in texture{ChurchStone translate <0,-10,0>*ft}}
	//columns and arches
	#local ZZ=-31;
	#while (ZZ<10)
		object{Column1 translate <-11.5,0,ZZ>*in}
		object{Column1 translate <11.5,0,ZZ>*in}
		//arches are visible even if the roof is removed.
		object{GothicArch translate <0,0,ZZ>*in}
		#local ZZ=ZZ+8;
	#end
	//cylinder{<0,10,10>*in,<0,10,-36>*in,0.125*in texture{RedPt}}
	//cylinder{<-12,13,10>*in,<-12,13,-36>*in,0.125*in texture{RedPt}}
	#if ((ViewPoint.y<14*in)|(ViewPoint.y>35*in))
		//roof - stone structure
		difference{
			intersection{
				box{
					<-0.5,-0.5,-36.5>*in,<0.5,0.5,10.5>*in
					rotate <0,0,45> scale <25/acos(radians(45)),10,1> translate <0,10,0>*in
 				}
				box{<-12.5,10,-36.5>*in,<12.5,18,10.5>*in}
			}
			intersection{
				box{<-0.5,-0.5,-36>*in,<0.5,0.5,10>*in rotate <0,0,45> scale <25/acos(radians(45)),10.25,1> translate <0,10,0>*in}
				box{<-12.5,9,-36.5>*in,<12.5,18,10.5>*in}
			}
			object{GothicOpening rotate <0,180,0> scale <2/3,0.75,1> translate <0,10,10>*in}
			object{GothicOpening scale <2/3,0.75,1> translate <0,10,-36>*in}
			texture{ChurchStone translate <0,30,0>*ft}
		}                      
		object{GothicFrame rotate <0,180,0> scale <2/3,0.75,1> translate <0,10,10>*in}
		object{BosieGlass rotate <0,180,0> scale <2/3,0.75,1> translate <0,10,10>*in}
		object{GothicFrame scale <2/3,0.75,1> translate <0,10,-36>*in}
		object{BosieGlass scale <2/3,0.75,1> translate <0,10,-36>*in}
		//roof - wood structure
		difference{
			intersection{
				box{
					<-0.5,-0.5,-36.5>*in,<0.5,0.5,10.5>*in
					rotate <0,0,45> scale <25/acos(radians(45)),10,1> translate <0,10.25,0>*in
				}
				box{<-12.5,10,-36.5>*in,<12.5,18,10.5>*in}
			}
			intersection{
				box{<-0.5,-0.5,-37>*in,<0.5,0.5,11>*in rotate <0,0,45> scale <22/acos(radians(45)),9.75,1> translate <0,10.25,0>*in}
				box{<-12.5,9,-37>*in,<12.5,18,11>*in}
			}
			texture{RoofWood2 translate <0,30,0>*ft}
		}                      
	#end
	//roof beams
	box{<-0.25,-0.25,-36.25>*in,<0.25,0.25,10.25>*in rotate <0,0,-degrees(atan2(0.4,1))> translate <9,14.5,0>*in texture{RoofWood}}
	box{<-0.25,-0.25,-36.25>*in,<0.25,0.25,10.25>*in rotate <0,0,-degrees(atan2(0.4,1))> translate <6,15.3,0>*in texture{RoofWood}}
	box{<-0.25,-0.25,-36.25>*in,<0.25,0.25,10.25>*in rotate <0,0,-degrees(atan2(0.4,1))> translate <3,16.1,0>*in texture{RoofWood}}
	box{<-0.25,-0.25,-36.25>*in,<0.25,0.25,10.25>*in rotate <0,0,degrees(atan2(0.4,1))> translate <-3,16.1,0>*in texture{RoofWood}}
	box{<-0.25,-0.25,-36.25>*in,<0.25,0.25,10.25>*in rotate <0,0,degrees(atan2(0.4,1))> translate <-6,15.3,0>*in texture{RoofWood}}
	box{<-0.25,-0.25,-36.25>*in,<0.25,0.25,10.25>*in rotate <0,0,degrees(atan2(0.4,1))> translate <-9,14.5,0>*in texture{RoofWood}}
	//empty pews
	/*
	#local ZZ=-5;
	#while (ZZ>-33)
		object{Pew translate <-6,0,ZZ>*in}
		object{Pew translate <6,0,ZZ>*in}
		#local ZZ=ZZ-4;
	#end
	*/
	//congregation
	#local Counter=1;
	#local ZZ=-5;
	#while (ZZ>-33)
		object{Pew translate <-6,0,ZZ>*in}
		object{Pew translate <6,0,ZZ>*in}
		#local XX=9;
		#while (XX>-10)
			#if (XX!=0)
				//#write(DebugFile,Counter,": ",<XX,0.25,ZZ>,"\n")
				object{Parishioner(Counter) translate <XX,0.25,ZZ>*in}
				#local Counter=Counter+1;
			#end
			#local XX=XX-3;
		#end
		#local ZZ=ZZ-4;
	#end

#end //of Setting=1

#if (Setting=2)
	// TeddyBearRev(pWhere,pRotn,pRotations,pTextureA,pHeadvars,pScaled)
	object{//
		TeddyBearRev(
			<-1.75,0,0>*in,<0,15,0>,
			BeckettPose,BeckettTx,BeckettData,BeckettScale
		)
	}
	object{//
		TeddyBearRev(
			<0,0,-1>*in,<0,0,0>,
			CuddyPose,CuddyTx,CuddyData,CuddyScale
		)
	}
	object{//
		TeddyBearRev(
			<1.75,0,0>*in,<0,-15,0>,
			BlipPose,BlipTx,BlipData,BlipScale
		)
	}
#end //of Setting=2



#if (Setting=3)
	BlodwenCostume()
	object{//
		//Baffler(
		TeddyBearRev(
			<0,-0.25,0>*in,<0,0,0>,
			BlodwenPose,BlodwenTx,BlodwenData,BlodwenScale
		)
	}
#end //of Setting=3

#debug "\r--------------------\rend of bearchurch.inc\r--------------------\r"
			