// Persistence Of Vision INCLUDE file
// File:    bearlist.inc
// Vers:    3.1g.r1 Mac PPC
// Desc:    My cast of teddy bears
// Uses:    tedbearm.inc
// Auth:    Peter Murray
// Date:    27 January 2001

#debug "\r  bearlist.inc - My cast of teddy bears\r"

// Bear definitions (Cuddy is real, all others are variations)
// Cuddy
	#declare CuddyPose=array[13]{<0,0,0>,
		<-30,0,0>,<0,0,0>,<0,0,0>,<-30,0,0>,<0,0,0>,<0,0,0>,
		<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>}
	#declare CuddyTx=array[5]{dFurTx,dContrastTx,dEyeTx,dMouthTx,dNoseTx}
	#declare CuddyData=array[9]{1,0,0,0,0,0,0,0,0}
	#declare CuddyScale=<1,1,1>;

//------------------------------------------------------------
// Alphabetical list of bears
//------------------------------------------------------------
// Ardal will be renamed Bardal
// Bacon (writer)
// #declare BaconPose=
// #declare BaconTx=
// #declare BaconData=
// #declare BaconScale=;
// Baffler isn't a bear, he's just clothes posed to look as if a bear is wearing them.
	//Use Baffler instead of TeddyBearRev
// Baleful
	#macro BalefulCostume()
		#include "nothing.cdf"
	#end
	#declare BalefulPose=array[13]{<15,0,0>,
		<-30,0,0>,<30,-150,0>,<0,0,0>,<-45,0,0>,<-40,0,0>,<0,0,0>,
		<-5,0,0>,<0,0,0>,<0,0,0>,<5,0,0>,<0,0,0>,<0,0,0>}
	#declare BalefulTx=array[5]{Fur7Tx,BarryFur,EvilEyeTx,dMouthTx,dNoseTx}
	#declare BalefulData=array[9]{0,0,-0.5,0,0,0.9,0.9,0,0}
	#declare BalefulScale=<1,1,1>;
/*
// #declare Bardal
Pose=
Tx=
Data=
Scale=;  
*/
// Baron
	#macro BaronCostume()
		#declare BearTextureList=array[5]{
			BlueCheck2,WandererGreen,WandererGreen,WandererGreen,WandererGreen
		}
		#include "shirt.cdf"
	#end
	#declare BaronPose=array[13]{<15,0,0>,
		<-30,0,0>,<30,-150,0>,<0,0,0>,<-45,0,0>,<-40,0,0>,<0,0,0>,
		<-5,0,0>,<0,0,0>,<0,0,0>,<5,0,0>,<0,0,0>,<0,0,0>}
	#declare BaronPChurch=array[13]{<0,-20,0>,
		<-30,0,0>,<-65,0,-110>,<0,0,0>,<-45,0,0>,<-50,0,90>,<0,0,0>,
		<-80,0,0>,<80,0,0>,<0,0,0>,<-80,0,0>,<90,0,0>,<0,0,0>}
	#declare BaronTx=array[5]{Fur3Tx,Fur9Tx,EyeBrownTx,dMouthTx,dNoseTx}
	#declare BaronData=array[9]{0,3,-0.25,0,0,0,0,0,0}
	#declare BaronScale=<1,1,1>;
// Barry
// #declare BarryPose=
	#macro BarryCostume()
		#declare PicTx=TShirtPic(BishopAlbTx,"bosie.png",3,4,0)
		#declare BearTextureList=array[5]{
			BishopAlbTx,PicTx,PicTx,WandererGreen,WandererGreen
		}
		#include "tshirt.cdf"
	#end
	#declare BarryPChurch=array[13]{<0,15,0>,
		<-10,0,0>,<0,0,0>,<0,0,0>,<-8,0,0>,<-20,0,0>,<0,0,0>,
		<-80,0,0>,<80,0,0>,<0,0,0>,<-80,0,0>,<90,0,0>,<0,0,0>}
	#declare BarryTx=array[5]{BarryFur,Fur9Tx,EyeBlueTx,dMouthTx,dNoseTx}
	#declare BarryData=array[9]{0,1,0,0,0,0,0,0,0}
	#declare BarryScale=<1,1,1>;
/*
// #declare Barty
Pose=
Tx=
Data=
Scale=;  
// #declare Bauhaus (artist)
Pose=
Tx=
Data=
Scale=;  
*/
// Bavington
	#macro BavingtonCostume()
		#declare BearTextureList=array[5]{
			BishopAlbTx,BishopBeltTx,BishopAlbTx,OrangePt,OrangePt
		}
		#declare BearOptionsList=array[5]{
			1.3,0.8,0,0,0
		}
		#include "priest.cdf"
	#end
	#declare BavingtonPose=array[13]{<0,0,0>,
		<-30,0,0>,<-85,0,0>,<0,0,0>,<-30,0,0>,<-90,0,0>,<0,0,0>,
		<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>}
	#declare BavingtonTx=array[5]{Fur9Tx,Fur9Tx,EyeBlueTx,dMouthTx,dNoseTx}
	#declare BavingtonData=array[9]{0.5,2,-0.25,1,0,0.2,0.3,0,0}
	#declare BavingtonScale=<1,1,1>;
/*
// #declare Beanie
Pose=
Tx=
Data=
Scale=;
// Bearbottle isn't a posable bear, but a separate object.
// Bearskin rug :-( will be a separate object too.
*/
// Beatrice 
	#macro BeatriceCostume()
		#declare BearTextureList=array[5]{
			BishopAlbTx,WandererGreen,WandererGreen,WandererGreen,WandererGreen
		}
		#include "dress2.cdf"
	#end
	#declare BeatricePChurch=array[13]{<8,20,0>,
		<-30,0,0>,<-65,0,-110>,<0,0,0>,<-45,0,0>,<-50,0,90>,<0,0,0>,
		<-40,0,0>,<20,0,0>,<0,0,0>,<-40,0,0>,<30,0,0>,<0,0,0>}
	#declare BeatriceTx=array[5]{BeatriceFur,BeatriceFur,EyeBrownTx,dMouthTx,dNoseTx}
	#declare BeatriceData=array[9]{1,2,-0.25,1,0,0.5,0.5,0,0}
	#declare BeatriceScale=<1,1,1>;
// Beaumont
	#declare BeaumontPose=array[13]{<25,0,0>,
		<0,0,60>,<0,0,50>,<0,0,30>,<0,0,-60>,<0,0,70>,<0,0,-50>,
		<0,0,0>,<0,0,0>,<0,10,0>,<0,0,-20>,<0,0,10>,<0,-10,0>}
	#declare BeaumontTx=array[5]{Fur9Tx,Fur10Tx,EyeLtBrownTx,dMouthTx,dNoseTx}
	#declare BeaumontData=array[9]{0,3,-0.25,1,1,0.3,0.4,0,1}
	#declare BeaumontScale=<1,1.05,1>;
// Beckett
	#macro BeckettCostume()
		#declare BearTextureList=array[5]{
			BishopAlbTx,BishopAlbTx,OrangePt,BishopCopeTx,OrangePt
		}
		#declare BearOptionsList=array[5]{
			1.3,0.8,0,0,0
		}
		#include "bishop.cdf"
	#end
	#declare BeckettPose=array[13]{<15,0,0>,
		<0,0,80>,<0,0,20>,<0,0,30>,<0,0,-80>,<0,0,-20>,<0,0,-30>,
		<0,0,10>,<0,0,0>,<0,0,0>,<0,0,-10>,<0,0,0>,<0,0,0>}
	#declare BeckettTx=array[5]{PaleFur,PolarFur,EyeBlueTx,dMouthTx,dNoseTx}
	#declare BeckettData=array[9]{0.5,3,0.25,3,0,0.4,0.3,0,0}
	#declare BeckettScale=<1,1,1>;
// Bela
	#declare BelaPose=array[13]{<20,-30,0>,
		<-60,0,0>,<30,-150,0>,<0,0,0>,<-45,-20,0>,<-40,0,0>,<0,0,0>,
		<35,0,0>,<20,0,0>,<0,0,0>,<-40,0,0>,<70,0,0>,<0,0,0>}
	#declare BelaTx=array[5]{BelaFur,BelaFur,EyeBlackTx,dMouthTx,dNoseTx}
	#declare BelaData=array[9]{0,2,-1,0,0,0.75,0.5,0,1}
	#declare BelaScale=<0.8,1.05,0.9>;
// Belinda
	#macro BelindaCostume()
		#declare BearTextureList=array[5]{
			PinkDress,WandererGreen,WandererGreen,WandererGreen,WandererGreen
		}
		#include "dress2.cdf"
	#end
	#declare BelindaPose=array[13]{<0,0,0>,
		<-30,0,0>,<0,0,0>,<0,0,0>,<-30,0,0>,<0,0,0>,<0,0,0>,
		<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>}
	#declare BelindaPChurch=array[13]{<8,-20,0>,
		<-30,0,0>,<-65,0,-110>,<0,0,0>,<-45,0,0>,<-50,0,90>,<0,0,0>,
		<-40,0,0>,<20,0,0>,<0,0,0>,<-40,0,0>,<30,0,0>,<0,0,0>}
	#declare BelindaTx=array[5]{Fur3Tx,Fur10Tx,EyeOliveTx,dMouthTx,dNoseTx}
	#declare BelindaData=array[9]{0,5,0.25,2,0,0.15,0.15,0,1}
	#declare BelindaScale=<1,1,1>;
// #declare Bennier (minbeari)
	#declare BennierPose=array[13]{<20,0,0>,
		<-40,0,20>,<20,0,-20>,<0,0,0>,<-40,0,0>,<-40,0,50>,<0,0,0>,
		<20,0,0>,<0,0,0>,<-20,0,0>,<-20,0,0>,<30,0,0>,<-10,0,0>}
	#declare BennierTx=array[5]{PolarFur,Fur10Tx,EyeOliveTx,dMouthTx,dNoseTx}
	#declare BennierData=array[9]{1,2,-0.5,-1,0,0,0,0,1}
	#declare BennierScale=<0.8,1.05,0.8>;
// #declare Benny
	#macro BennyCostume()
		#declare BearTextureList=array[5]{
			WandererBrown,WandererGreen,WandererGreen,WandererGreen,WandererGreen
		}
		#include "shirt.cdf"
	#end
	#declare BennyPose=array[13]{<0,0,0>,
		<0,0,90>,<0,0,30>,<0,0,0>,<0,0,-100>,<0,0,-20>,<0,0,0>,
		<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>}
	#declare BennyPChurch=array[13]{<-40,-20,0>,
		<-30,0,0>,<-65,0,-110>,<0,0,0>,<-45,0,0>,<-50,0,90>,<0,0,0>,
		<-80,0,0>,<80,0,0>,<0,0,0>,<-80,0,0>,<90,0,0>,<0,0,0>}
	#declare BennyTx=array[5]{Fur9Tx,Fur10Tx,EyeOliveTx,dMouthTx,dNoseTx}
	#declare BennyData=array[9]{0,0,0,0,0,0,0,0,1}
	#declare BennyScale=<0.9,0.75,0.9>;
/*
// #declare Beppe
Pose=
Tx=
Data=
Scale=;
*/
// Bernie
	#macro BernieCostume()
		#declare BearTextureList=array[5]{
			Blip2Fur,WandererGreen,WandererGreen,WandererGreen,WandererGreen
		}
		#include "shirt.cdf"
	#end
	#declare BerniePose=array[13]{<0,0,0>,
		<-30,0,30>,<0,0,0>,<0,0,0>,<-30,0,-30>,<0,0,0>,<0,0,0>,
		<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>}
	#declare BerniePChurch=array[13]{<4,-25,0>,
		<-30,0,0>,<-65,0,-110>,<0,0,0>,<-45,0,0>,<-50,0,90>,<0,0,0>,
		<-80,0,0>,<80,0,10>,<0,0,0>,<-80,0,0>,<90,0,-20>,<0,0,0>}
	#declare BernieTx=array[5]{BernieFur,Fur9Tx,dEyeTx,dMouthTx,dNoseTx}
	#declare BernieData=array[9]{0,4,0,0,0,0,0,0,0}
	#declare BernieScale=<1,1,1>;
// Berry
	#macro BerryCostume()
		#declare BearTextureList=array[5]{
			BlipFur,BlipFur,BlipFur,BlipFur,BlipFur
		}
		#include "tshirt.cdf"
	#end
// #declare BerryPose=
	#declare BerryPChurch=array[13]{<5,-10,0>,
		<-30,0,0>,<-30,0,-110>,<0,0,0>,<-45,0,0>,<-30,0,90>,<0,0,0>,
		<-80,0,0>,<10,0,0>,<0,0,0>,<-60,0,0>,<90,0,0>,<0,0,0>}
	#declare BerryTx=array[5]{Fur9Tx,Fur9Tx,dEyeTx,dMouthTx,dNoseTx}
	#declare BerryData=array[9]{0,0,0,0,0,0,0,0,1}
	#declare BerryScale=<0.5,0.6,0.5>;
// Bessy
	#macro BessyCostume()
		#declare BearTextureList=array[5]{
			PinkGingham,WandererGreen,WandererGreen,WandererGreen,WandererGreen
		}
		#include "lildress.cdf"
	#end
	#declare BessyPose=array[13]{<5,0,10>,
		<-30,-60,0>,<0,-90,0>,<0,0,0>,<-70,0,0>,<-70,0,0>,<0,0,0>,
		<-30,20,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>}
	#declare BessyPChurch=array[13]{<8,35,0>,
		<-30,0,0>,<-30,0,-110>,<0,0,0>,<-45,0,0>,<-30,0,90>,<0,0,0>,
		<-10,0,0>,<90,0,0>,<0,0,0>,<-10,0,0>,<10,0,0>,<0,0,0>}
	#declare BessyTx=array[5]{BlossomFur,Blossom2Fur,EyeBlueTx,dMouthTx,dNoseTx}
	#declare BessyData=array[9]{0,2,1,0,0,0,0,0,0}
	#declare BessyScale=<0.9,0.8,0.85>;
/*
// #declare Bethany
Pose=
Tx=
Data=
Scale=;  
// #declare Betty
Pose=
Tx=
Data=
Scale=;  
// #declare Beverley
Pose=
Tx=
Data=
Scale=;  
// #declare Bewdley (chauffeur)
Pose=
Tx=
Data=
Scale=;  
// #declare Bey (sheikh)
Pose=
Tx=
Data=
Scale=;  
*/
// Biddy
	#macro BiddyCostume()
		#declare BearTextureList=array[5]{
			BishopCopeTx,WandererGreen,WandererGreen,WandererGreen,WandererGreen
		}
		#include "dress2.cdf"
	#end
	#declare BiddyPose=array[13]{<0,0,0>,
		<-30,0,0>,<0,0,0>,<0,0,0>,<-30,0,0>,<0,0,0>,<0,0,0>,
		<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>}
	#declare BiddyPChurch=array[13]{<0,15,0>,
		<-30,0,0>,<-65,0,-110>,<0,0,0>,<-45,0,0>,<-50,0,90>,<0,0,0>,
		<-40,0,0>,<20,0,0>,<0,0,0>,<-40,0,0>,<30,0,0>,<0,0,0>}
	#declare BiddyTx=array[5]{Fur6Tx,Fur6Tx,EyeBlueTx,dMouthTx,dNoseTx}
	#declare BiddyData=array[9]{0,2,0,0,0,0,0,0,0}
	#declare BiddyScale=<1,1,1>;
// Billy
	#macro BillyCostume()
		#declare BearTextureList=array[5]{
			BlueCheck,BlueCheck,BlueCheck,WandererGreen,WandererGreen
		}
		#include "tshirt.cdf"
	#end
	#declare BillyPose=array[13]{<5,0,-15>,
		<-70,0,0>,<-70,0,0>,<0,0,0>,<-30,40,0>,<-30,80,0>,<0,0,0>,
		<-40,20,0>,<0,0,0>,<0,0,0>,<0,-50,0>,<0,0,0>,<0,0,0>}
	#declare BillyPChurch=array[13]{<5,-10,0>,
		<-30,0,0>,<-30,0,-110>,<0,0,0>,<-45,0,0>,<-30,0,90>,<0,0,0>,
		<-80,0,0>,<10,0,0>,<0,0,0>,<-60,0,0>,<90,0,0>,<0,0,0>}
	#declare BillyTx=array[5]{BillyFur,PaleFur,EyeGreenTx,dMouthTx,dNoseTx}
	#declare BillyData=array[9]{0,0,0.75,0,0,0,0,0,0}
	#declare BillyScale=<0.9,0.8,0.85>;
/*
// #declare Bix (musician)
Pose=
Tx=
Data=
Scale=;
*/
// Blackie
	#macro BlackieCostume()
		#declare BearTextureList=array[5]{
			BishopRedTx,BishopRedTx,BishopRedTx,BishopRedTx,BishopRedTx
		}
		#include "tshirt.cdf"
	#end
	#declare BlackiePose=array[13]{<0,-15,0>,
		<-30,0,0>,<-65,0,-110>,<0,0,0>,<-45,0,0>,<-50,0,90>,<0,0,0>,
		<-80,0,0>,<80,0,0>,<0,0,0>,<-80,0,0>,<90,0,0>,<0,0,0>}
	#declare BlackieTx=array[5]{Fur8Tx,Fur7Tx,EyeBlueTx,dMouthTx,dNoseTx}
	#declare BlackieData=array[9]{0,0,0,0,0,0,0,0,0}
	#declare BlackieScale=<0.9,1,0.9>;
/*
// #declare Bless
Pose=
Tx=
Data=
Scale=;  
*/
// Blinky
	#macro BlinkyCostume()
		#declare BearTextureList=array[5]{
			BishopRedTx,AltarCloth,AltarCloth,BishopRedTx,BishopRedTx
		}
		#include "shirt.cdf"
	#end
	#declare BlinkyPose=array[13]{<-5,20,0>,
		<-30,0,0>,<-65,0,-110>,<0,0,0>,<-45,0,0>,<-50,0,90>,<0,0,0>,
		<-80,0,0>,<80,0,0>,<0,0,0>,<-80,0,0>,<90,0,0>,<0,0,0>}
	#declare BlinkyTx=array[5]{PaleFur,PolarFur,EyeOliveTx,dMouthTx,dNoseTx}
	#declare BlinkyData=array[9]{0.5,1,0.5,2,0,0.7,0.3,0,1}
	#declare BlinkyScale=<1,1,1>;
// Blip
	#macro BlipCostume()
		#declare BearTextureList=array[5]{
			AltarCloth,AltarCloth,AltarCloth,AltarCloth,AltarCloth
		}
		#include "shirt.cdf"
	#end
	#declare BlipPose=array[13]{<15,0,0>,
		<-30,0,0>,<30,-150,0>,<0,0,0>,<-45,0,0>,<-40,0,0>,<0,0,0>,
		<-5,0,0>,<0,0,0>,<0,0,0>,<5,0,0>,<0,0,0>,<0,0,0>}
	#declare BlipPChurch=array[13]{<5,-20,0>,
		<-30,0,0>,<-65,0,-110>,<0,0,0>,<-45,0,0>,<-50,0,90>,<0,0,0>,
		<-80,0,0>,<80,0,0>,<0,0,0>,<-80,0,0>,<90,0,0>,<0,0,0>}
	#declare BlipTx=array[5]{BlipFur,Blip2Fur,dEyeTx,dMouthTx,dNoseTx}
	#declare BlipData=array[9]{1.2,6,0,1,0,0,0,0,1}
	#declare BlipScale=<1,1,1>;
// Blodwen
	#macro BlodwenCostume()
		#declare BearTextureList=array[5]{
			WandererGreen,WandererGreen,WandererGreen,WandererGreen,WandererGreen
		}
		#include "dress2.cdf"
	#end
	#declare BlodwenPose=array[13]{<-5,20,0>,
		<-30,0,0>,<-65,0,-110>,<0,0,0>,<-45,0,0>,<-50,0,90>,<0,0,0>,
		<-80,0,0>,<40,0,15>,<0,0,0>,<-80,0,0>,<45,0,-15>,<0,0,0>}
	#declare BlodwenTx=array[5]{PolarFur,Blossom2Fur,EyeBlueTx,dMouthTx,dNoseTx}
	#declare BlodwenData=array[9]{1,2,-0.25,3,0.,0.1,0.2,0,1}
	#declare BlodwenScale=<0.9,0.95,0.9>;
// Blondie
	#macro BlondieCostume()
		#declare BearTextureList=array[5]{
			WhiteSilver,WhiteSilver,WhiteSilver,WhiteSilver,WhiteSilver
		}
		#include "dress2.cdf"
	#end
	#declare BlondiePose=array[13]{<-5,-20,0>,
		<-30,0,0>,<-65,0,-110>,<0,0,0>,<-45,0,0>,<-50,0,90>,<0,0,0>,
		<-80,0,0>,<40,0,15>,<0,0,0>,<-80,0,0>,<45,0,-15>,<0,0,0>}
	#declare BlondieTx=array[5]{Fur9Tx,Fur9Tx,EyeBlueTx,dMouthTx,dNoseTx}
	#declare BlondieData=array[9]{0.5,1,0.25,2,0,0.2,0.1,0,1}
	#declare BlondieScale=<1,1,1>;
// Blossom
	#macro BlossomCostume()
		#declare BearTextureList=array[5]{
			BlossomDress,WandererGreen,WandererGreen,WandererGreen,WandererGreen
		}
		#include "dress2.cdf"
	#end
	#declare BlossomPose=array[13]{<15,0,0>,
		<-30,0,0>,<30,-150,0>,<0,0,0>,<-45,0,0>,<-40,0,0>,<0,0,0>,
		<-5,0,0>,<0,0,0>,<0,0,0>,<5,0,0>,<0,0,0>,<0,0,0>}
	#declare BlossomPChurch=array[13]{<-5,20,0>,
		<-30,0,0>,<-65,0,-110>,<0,0,0>,<-45,0,0>,<-50,0,90>,<0,0,0>,
		<-80,0,0>,<40,0,15>,<0,0,0>,<-80,0,0>,<45,0,-15>,<0,0,0>}
	#declare BlossomTx=array[5]{BlossomFur,Blossom2Fur,EyeBlueTx,dMouthTx,dNoseTx}
	#declare BlossomData=array[9]{0,2,1,0,0,0.4,0.4,0,0}
	#declare BlossomScale=<1,1,1>;
/*
// #declare Blundell
Pose=
Tx=
Data=
Scale=;  
// #declare Blush
Pose=
Tx=
Data=
Scale=;
*/
// Bobby
	#macro BobbyCostume()
		#declare PicTx=TShirtPic(WandererYellow,"hogwarts.png",3,4,0)
		#declare BearTextureList=array[5]{
			WandererYellow,PicTx,PicTx,WandererGreen,WandererGreen
		}
		#include "tshirt.cdf"
	#end
	#declare BobbyPose=array[13]{<0,0,0>,
		<-30,0,45>,<0,0,0>,<0,0,0>,<-30,0,-45>,<0,0,0>,<0,0,0>,
		<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>}
	#declare BobbyPChurch=array[13]{<0,20,0>,
		<-30,0,0>,<-65,0,-110>,<0,0,0>,<-45,0,0>,<-50,0,90>,<0,0,0>,
		<-80,0,0>,<80,0,0>,<0,0,0>,<-80,0,0>,<90,0,0>,<0,0,0>}
	#declare BobbyTx=array[5]{dFurTx,Fur2Tx,EyeGreenTx,dMouthTx,dNoseTx}
	#declare BobbyData=array[9]{0,3,0,0,0,0,0,0,0}
	#declare BobbyScale=<1,1,1>;
// Bonnie
	#macro BonnieCostume()
		#declare BearTextureList=array[5]{
			BeatriceFur,BeatriceFur,BeatriceFur,BeatriceFur,BeatriceFur
		}
		#include "tshirt.cdf"
	#end
	#declare BonniePose=array[13]{<10,40,0>,
		<0,0,40>,<0,0,20>,<0,0,0>,<-45,0,0>,<-50,0,90>,<0,0,0>,
		<-80,0,0>,<80,0,0>,<0,0,0>,<-80,0,0>,<90,0,0>,<0,0,0>}
	#declare BonnieTx=array[5]{BonnieFur,Fur2Tx,EyeGreenTx,dMouthTx,dNoseTx}
	#declare BonnieData=array[9]{0,1,0.5,0,0,0,0,0,0}
	#declare BonnieScale=<0.75,0.9,0.8>;
// #declare Boris
	#macro BorisCostume()
		#declare PicTx=TShirtPic(GreenSilver,"slytherin.png",3,4,0)
		#declare BearTextureList=array[5]{
			GreenSilver,PicTx,PicTx,WandererGreen,WandererGreen
		}
		#include "tshirt.cdf"
	#end
	#declare BorisPose=array[13]{<15,0,0>,
		<-30,0,90>,<-60,0,50>,<0,0,0>,<-30,0,-80>,<-70,0,-50>,<0,0,0>,
		<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>}
	#declare BorisPChurch=array[13]{<5,-20,0>,
		<-30,0,0>,<-65,0,-110>,<0,0,0>,<-45,0,0>,<-50,0,90>,<0,0,0>,
		<-80,0,0>,<80,0,0>,<0,0,0>,<-80,0,0>,<90,0,0>,<0,0,0>}
	#declare BorisTx=array[5]{Fur5Tx,Fur6Tx,EyeBrownTx,dMouthTx,dNoseTx}
	#declare BorisData=array[9]{-0.5,3,0,0,0,0,0,0,0}
	#declare BorisScale=<1,1,1>;
// Bosie
	#macro BosieCostume()
		#declare BearTextureList=array[5]{
			BosieRobes,BosieRobes,BosieRobes2,BosieRobes2,BosieRobes
		}
		#declare BearOptionsList=array[5]{
			1.3,0.8,0,0,0
		}
		#include "bishop.cdf"
		#undef TeddyHat
	#end
	#declare BosiePose=array[13]{<15,0,0>,
		<-45,0,0>,<-40,0,0>,<0,0,0>,<-10,0,0>,<10,150,0>,<0,0,0>,
		<-5,0,0>,<0,0,0>,<0,0,0>,<5,0,0>,<0,0,0>,<0,0,0>}
	#declare BosieTx=array[5]{BernieFur,Fur9Tx,EyeOliveTx,dMouthTx,dNoseTx}
	#declare BosieData=array[9]{0,4,0,0,0,0,0,0,0}
	#declare BosieScale=<1,1,1>;
// Boston
	#macro BostonCostume()
		#declare PicTx=TShirtPic(BishopAlbTx,"irtclogo.png",3,4,0)
		#declare BearTextureList=array[5]{
			BishopAlbTx,PicTx,PicTx,BishopAlbTx,BishopAlbTx
		}
		#include "tshirt.cdf"
	#end
	#declare BostonPose=array[13]{<0,0,0>,
		<-30,0,0>,<0,0,0>,<0,0,0>,<-30,0,0>,<0,0,0>,<0,0,0>,
		<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>}
	#declare BostonTx=array[5]{Fur3Tx,Fur6Tx,EyeGreenTx,dMouthTx,dNoseTx}
	#declare BostonData=array[9]{0,4,0.25,0,0,0,0,0,0}
	#declare BostonScale=<1,1.2,1>;  
/*
// #declare Botham (cricketer)
Pose=
Tx=
Data=
Scale=;
*/
// Bower
	#macro BowerCostume()
		#declare PicTx=TShirtPic(RedGold,"gryffindor.png",3,4,0)
		#declare BearTextureList=array[5]{
			RedGold,PicTx,PicTx,WandererGreen,WandererGreen
		}
		#include "tshirt.cdf"
	#end
	#declare BowerPose=array[13]{<15,0,0>,
		<-30,0,15>,<0,0,0>,<0,0,0>,<-130,0,0>,<0,0,0>,<0,0,0>,
		<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>}
	#declare BowerPChurch=array[13]{<6,-20,0>,
		<-30,0,0>,<-65,0,-110>,<0,0,0>,<-45,0,0>,<-50,0,90>,<0,0,0>,
		<-80,0,0>,<80,0,0>,<0,0,0>,<-80,0,0>,<90,0,0>,<0,0,0>}
	#declare BowerTx=array[5]{Fur4Tx,Fur6Tx,dEyeTx,dMouthTx,dNoseTx}
	#declare BowerData=array[9]{1,5,0,0,0,0,0,0,0}
	#declare BowerScale=<1,1,1>;
// Bracken
	#macro BrackenCostume()
		#declare BearTextureList=array[5]{
			BishopAlbTx,WandererGreen,BishopRedTx,WandererGreen,WandererGreen
		}
		#include "weskit.cdf"
	#end
	#declare BrackenPose=array[13]{<15,0,0>,
		<-30,0,15>,<0,0,0>,<0,0,0>,<-130,0,0>,<0,0,0>,<0,0,0>,
		<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>}
	#declare BrackenPChurch=array[13]{<5,-30,0>,
		<20,0,0>,<0,0,0>,<0,0,0>,<15,0,0>,<0,0,0>,<0,0,0>,
		<70,0,0>,<0,0,0>,<0,0,0>,<50,0,0>,<0,0,0>,<0,0,0>}
	#declare BrackenTx=array[5]{dFurTx,Fur2Tx,EyeGreenTx,dMouthTx,dNoseTx}
	#declare BrackenData=array[9]{-0.5,0,0,0,0,1,1,0,0}
	#declare BrackenScale=<1,1,1>;
// Brad
	#macro BradCostume()
		#declare BearTextureList=array[5]{
			BosieRobes2,BosieRobes2,BosieRobes2,WandererGreen,WandererGreen
		}
		#include "tshirt.cdf"
	#end
	#declare BradPose=array[13]{<10,20,0>,
		<-30,0,0>,<0,0,0>,<0,0,0>,<-60,0,0>,<0,0,0>,<0,0,0>,
		<-15,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>}
	#declare BradPChurch=array[13]{<5,-15,0>,
		<-30,0,5>,<-65,0,-110>,<0,0,0>,<-45,0,-5>,<-50,0,90>,<0,0,0>,
		<-40,0,0>,<20,0,0>,<0,0,0>,<-40,0,0>,<30,0,0>,<0,0,0>}
	#declare BradTx=array[5]{PolarFur,Blossom2Fur,EyeBlueTx,dMouthTx,dNoseTx}
	#declare BradData=array[9]{0.2,5,0.25,0,1,0.5,0.5,0,0}
	#declare BradScale=<1,1,1>;
// #declare Bran
	#macro BranCostume()
		#declare BearTextureList=array[5]{
			BeltTx,WandererGreen,WandererGreen,BrownShoe,WandererGreen
		}
		#declare BearOptionsList=array[5]{
			1.3,0.8,0,0,0
		}
		#include "wanderer.cdf"
	#end
	#declare BranPose=array[13]{<0,20,0>,
		<-120,-45,0>,<0,0,0>,<0,0,0>,<30,0,0>,<0,0,0>,<0,0,0>,
		<-15,0,0>,<0,0,0>,<0,0,0>,<15,0,0>,<0,0,0>,<0,0,0>}
	#declare BranPChurch=array[13]{<5,-10,0>,
		<-30,0,5>,<-65,0,-110>,<0,0,0>,<-45,0,-5>,<-50,0,90>,<0,0,0>,
		<-40,0,0>,<20,0,0>,<0,0,0>,<-40,0,0>,<30,0,0>,<0,0,0>}
	#declare BranTx=array[5]{WarmFurTx,WarmFur2Tx,dEyeTx,dMouthTx,dNoseTx}
	#declare BranData=array[9]{0,0,0,0,0,0,0,0,1}
	#declare BranScale=<1,1,1>;
// Brandy
	#macro BrandyCostume()
		#declare BearTextureList=array[5]{
			WandererBrown,WandererBrown,WandererBrown,WandererBrown,WandererBrown
		}
		#include "dress2.cdf"
	#end
// #declare BrandyPose=
	#declare BrandyPChurch=array[13]{<5,-20,0>,
		<-30,0,5>,<-65,0,-110>,<0,0,0>,<-45,0,-5>,<-50,0,90>,<0,0,0>,
		<-40,0,0>,<20,0,0>,<0,0,0>,<-40,0,0>,<30,0,0>,<0,0,0>}
	#declare BrandyTx=array[5]{BrandyFur,Fur2Tx,EyeBrownTx,dMouthTx,dNoseTx}
	#declare BrandyData=array[9]{0,2,0,0,0,0,0,0,1}
	#declare BrandyScale=<1,1,1>;
/*
// #declare Brax
Pose=
Tx=
Data=
Scale=;  
// #declare Brenda
Pose=
Tx=
Data=
Scale=;  
*/
// Bridget
	#macro BridgetCostume()
		#declare BearTextureList=array[5]{
			BosieRobes,BosieRobes,BosieRobes,WandererGreen,WandererGreen
		}
		#include "tshirt.cdf"
	#end
	#declare BridgetPose=array[13]{<5,-15,0>,
		<-30,0,0>,<-30,0,-110>,<0,0,0>,<-45,0,0>,<-30,0,90>,<0,0,0>,
		<-80,0,0>,<80,0,0>,<0,0,0>,<-80,0,0>,<90,0,0>,<0,0,0>}
	#declare BridgetTx=array[5]{Fur9Tx,Fur9Tx,dEyeTx,dMouthTx,dNoseTx}
	#declare BridgetData=array[9]{0,1,0,0,0,0,0,0,0}
	#declare BridgetScale=<1,1,1>;
// Britney
	#macro BritneyCostume()
		#declare BearTextureList=array[5]{
			WandererGreen,WandererGreen,WandererGreen,WandererGreen,WandererGreen
		}
		#include "tshirt.cdf"
	#end
	#declare BritneyPose=array[13]{<5,25,0>,
		<-30,0,0>,<-30,0,-110>,<0,0,0>,<-45,0,0>,<-30,0,90>,<0,0,0>,
		<-80,0,0>,<10,0,0>,<0,0,0>,<-60,0,0>,<90,0,0>,<0,0,0>}
	#declare BritneyTx=array[5]{Fur9Tx,Fur9Tx,EyeBrownTx,dMouthTx,dNoseTx}
	#declare BritneyData=array[9]{0,2,0,0,0,0,0,0,0}
	#declare BritneyScale=<0.75,0.8,0.75>;
// #declare Brock
	#macro BrockCostume()
		#declare PicTx=TShirtPic(BishopAlbTx,"ukflag.png",3,4,0)
		#declare BearTextureList=array[5]{
			BishopAlbTx,PicTx,PicTx,BishopAlbTx,BishopAlbTx
		}
		#include "tshirt.cdf"
	#end
	#declare BrockPose=array[13]{<0,20,0>,
		<-30,0,0>,<-65,0,-110>,<0,0,0>,<-45,0,0>,<-50,0,90>,<0,0,0>,
		<-80,0,0>,<80,0,15>,<0,0,0>,<-80,0,0>,<90,0,-15>,<0,0,0>}
	#declare BrockTx=array[5]{Fur2Tx,Fur2Tx,dEyeTx,dMouthTx,dNoseTx}
	#declare BrockData=array[9]{0,3,0,0,0,0,0,0,0}
	#declare BrockScale=<1.2,1,1.1>;
/*
// #declare Broderick
Pose=
Tx=
Data=
Scale=;  
// #declare Bronwyn
Pose=
Tx=
Data=
Scale=  
// #declare Bucky
Pose=
Tx=
Data=
Scale=;  
// #declare Buddy
Pose=
Tx=
Data=
Scale=;  
// #declare Bulmer
Pose=
Tx=
Data=
Scale=;  
// #declare Bunny
Pose=
Tx=
Data=
Scale=;  
// #declare Burns
Pose=
Tx=
Data=
Scale=;
*/
// Burrell
	#macro BurrellCostume()
		#declare BearTextureList=array[5]{
			RedGold,WandererBrown,WandererGreen,RedPt,RedPt
		}
		#include "weskit.cdf"
	#end
// #declare BurrellPose=
	#declare BurrellPChurch=array[13]{<5,-20,0>,
		<-30,0,5>,<-65,0,-110>,<0,0,0>,<-45,0,-5>,<-50,0,90>,<0,0,0>,
		<-40,0,0>,<20,0,0>,<0,0,0>,<-40,0,0>,<30,0,0>,<0,0,0>}
	#declare BurrellTx=array[5]{Fur9Tx,Fur9Tx,dEyeTx,dMouthTx,dNoseTx}
	#declare BurrellData=array[9]{0,0,0,0,0,0,0,0,1}
	#declare BurrellScale=<1,1,1>;
/*
// #declare Buttons
Pose=
Tx=
Data=
Scale=;  
// #declare Byron
Pose=
Tx=
Data=
Scale=;
// the Invisible Bear will be renamed Baffler :-)
// Janey will be renamed Beanie
*/  

#debug "\r--------------------\rend of bearlist.inc\r--------------------\r"
			