// Persistence Of Vision INCLUDE file
// File:        weskit.cdf
// Vers:        3.1g.r1 Mac PPC
// Desc:        A waistcoat over a short-sleeved shirt for tedbearm.inc to wear
// Auth:        Peter Murray
// Date:        16 February 2001

#debug "\r  weskit.cdf - A waistcoat over a short-sleeved shirt for bears.\r"

// Measurements might already be defined.
#ifndef(in)
	#declare in = 1;
	#declare ft = 12;
#end

// Pick up values/choices from the options arrays.

	// 0 shirt, 1 waistcoat front, 2 waistcoat back, 3 ?, 4 ?
	#local ShirtTx=BearTextureList[0]
	#local WeskitFTx=BearTextureList[1]
	#local WeskitBTx=BearTextureList[2]
	#local UnusedTx=BearTextureList[3]
	#local UnusedTx=BearTextureList[4]
	
#ifdef (TeddyHat) #undef TeddyHat #end

#declare TeddyShirt=
union{
	#local xtnt=1.0;
	union{
		bicubic_patch{//left front panel
			type 1 flatness 0.1
			u_steps 5 v_steps 5
			<-0.7,2.875,0.25>*in <-0.5,2.875,0.25>*in <-0.25,2.875,0.55>*in <-0.075,2.875,0.55>*in
			<-0.75,2.3465,0.25>*in <-0.6,2.3465,0.25>*in <-0.3,2.3465,0.55>*in <0.1,2.3465,0.55>*in
			<-0.85,1.9035,0.25>*in <-0.7,1.9035,0.6>*in <-0.4,1.9035,0.75>*in <0,1.9035,0.75>*in
			<-0.85,1.55,0.25>*in <-0.7,1.55,0.55>*in <-0.45,1.55,0.65>*in <0,1.55,0.65>*in
		}
		bicubic_patch{//right front panel
			type 1 flatness 0.1
			u_steps 5 v_steps 5
			<0.7,2.875,0.25>*in <0.5,2.875,0.25>*in <0.25,2.875,0.55>*in <0.075,2.875,0.55>*in
			<0.75,2.3465,0.25>*in <0.6,2.3465,0.25>*in <0.3,2.3465,0.55>*in <-0.1,2.3465,0.55>*in
			<0.85,1.9035,0.25>*in <0.7,1.9035,0.6>*in <0.4,1.9035,0.75>*in <0,1.9035,0.75>*in
			<0.85,1.55,0.25>*in <0.7,1.55,0.55>*in <0.45,1.55,0.65>*in <0,1.55,0.65>*in
		}
		bicubic_patch{//right panel
			type 1 flatness 0.1
			u_steps 5 v_steps 5
			<0.7,2.875,0.25>*in <0.73,2.875,0.15>*in <0.73,2.875,-0.15>*in <0.7,2.875,-0.25>*in
			<0.75,2.3465,0.25>*in <0.78,2.3465,0.15>*in <0.78,2.3465,-0.15>*in <0.75,2.3465,-0.25>*in
			<0.85,1.9035,0.25>*in <0.88,1.9035,0.15>*in <0.88,1.9035,-0.15>*in <0.85,1.9035,-0.25>*in
			<0.85,1.55,0.25>*in <0.88,1.55,0.15>*in <0.88,1.55,-0.15>*in <0.85,1.55,-0.25>*in
		}
		bicubic_patch{//right back panel
			type 1 flatness 0.1
			u_steps 5 v_steps 5
			<0.65,2.875,-0.25>*in <0.5,2.875,-0.25>*in <0.25,2.875,-0.55>*in <0,2.875,-0.4>*in
			<0.75,2.3465,-0.25>*in <0.5,2.3465,-0.30>*in <0.3,2.3465,-0.55>*in <0,2.3465,-0.5>*in
			<0.85,1.9035,-0.25>*in <0.7,1.9035,-0.58>*in <0.4,1.9035,-0.6>*in <0,1.9035,-0.55>*in
			<0.85,1.55,-0.25>*in <0.7,1.55,-0.57>*in <0.4,1.55,-0.6>*in <0,1.55,-0.6>*in
		}
		bicubic_patch{//left back panel
			type 1 flatness 0.1
			u_steps 5 v_steps 5
			<-0.65,2.875,-0.25>*in <-0.5,2.875,-0.25>*in <-0.25,2.875,-0.55>*in <-0,2.875,-0.4>*in
			<-0.75,2.3465,-0.25>*in <-0.5,2.3465,-0.30>*in <-0.3,2.3465,-0.55>*in <-0,2.3465,-0.5>*in
			<-0.85,1.9035,-0.25>*in <-0.7,1.9035,-0.58>*in <-0.4,1.9035,-0.6>*in <-0,1.9035,-0.55>*in
			<-0.85,1.55,-0.25>*in <-0.7,1.55,-0.57>*in <-0.4,1.55,-0.6>*in <-0,1.55,-0.6>*in
		}
		bicubic_patch{//left panel
			type 1 flatness 0.1
			u_steps 5 v_steps 5
			<-0.7,2.875,0.25>*in <-0.73,2.875,0.15>*in <-0.73,2.875,-0.15>*in <-0.7,2.875,-0.25>*in
			<-0.75,2.3465,0.25>*in <-0.78,2.3465,0.15>*in <-0.78,2.3465,-0.15>*in <-0.75,2.3465,-0.25>*in
			<-0.85,1.9035,0.25>*in <-0.88,1.9035,0.15>*in <-0.88,1.9035,-0.15>*in <-0.85,1.9035,-0.25>*in
			<-0.85,1.55,0.25>*in <-0.88,1.55,0.15>*in <-0.88,1.55,-0.15>*in <-0.85,1.55,-0.25>*in
		}
		bicubic_patch{//left shoulder
			type 1 flatness 0.1
			u_steps 5 v_steps 5
			<-0.65,2.875,-0.25>*in <-0.5,2.875,-0.25>*in <-0.25,2.875,-0.55>*in <-0.1,2.875,-0.4>*in
			<-0.65,3.050,-0.15>*in <-0.5,3.125,-0.15>*in <-0.25,3.125,-0.35>*in <-0.1,3.125,-0.3>*in
			<-0.65,3.050,0.15>*in <-0.5,3.125,0.15>*in <-0.25,3.125,0.35>*in <-0.1,3.125,0.3>*in
			<-0.7,2.875,0.25>*in <-0.5,2.875,0.25>*in <-0.25,2.875,0.55>*in <0,2.875,0.55>*in
		}
		bicubic_patch{//right shoulder
			type 1 flatness 0.1
			u_steps 5 v_steps 5
			<0.65,2.875,-0.25>*in <0.5,2.875,-0.25>*in <0.25,2.875,-0.55>*in <0.1,2.875,-0.4>*in
			<0.65,3.050,-0.15>*in <0.5,3.125,-0.15>*in <0.25,3.125,-0.35>*in <0.1,3.125,-0.3>*in
			<0.65,3.050,0.15>*in <0.5,3.125,0.15>*in <0.25,3.125,0.35>*in <0.1,3.125,0.3>*in
			<0.7,2.875,0.25>*in <0.5,2.875,0.25>*in <0.25,2.875,0.55>*in <0,2.875,0.55>*in
		}
		texture{ShirtTx}
	}
	//now the waistcoat
	union{
		bicubic_patch{//left front panel
			type 1 flatness 0.05
			u_steps 5 v_steps 5
			<-0.7,2.875,0.27>*in <-0.5,2.875,0.30>*in <-0.25,2.875,0.60>*in <-0.2,2.875,0.58>*in
			<-0.75,2.3465,0.27>*in <-0.6,2.3465,0.30>*in <-0.32,2.3465,0.60>*in <-0.001,2.3465,0.58>*in
			<-0.85,1.9035,0.27>*in <-0.7,1.9035,0.65>*in <-0.42,1.9035,0.80>*in <0,1.9035,0.78>*in
			<-0.85,1.55,0.27>*in <-0.7,1.55,0.60>*in <-0.47,1.55,0.70>*in <0,1.55,0.68>*in
		}
		bicubic_patch{//right front panel
			type 1 flatness 0.05
			u_steps 5 v_steps 5
			<0.7,2.875,0.27>*in <0.5,2.875,0.30>*in <0.25,2.875,0.60>*in <0.2,2.875,0.58>*in
			<0.75,2.3465,0.27>*in <0.6,2.3465,0.30>*in <0.32,2.3465,0.60>*in <0.001,2.3465,0.58>*in
			<0.85,1.9035,0.27>*in <0.7,1.9035,0.65>*in <0.42,1.9035,0.80>*in <0,1.9035,0.78>*in
			<0.85,1.55,0.27>*in <0.7,1.55,0.60>*in <0.47,1.55,0.70>*in <0,1.55,0.68>*in
		}
		bicubic_patch{//left panel
			type 1 flatness 0.05
			u_steps 5 v_steps 5
			<-0.7,2.875,0.28>*in <-0.75,2.875,0.15>*in <-0.75,2.875,-0.15>*in <-0.7,2.875,-0.28>*in
			<-0.75,2.3465,0.28>*in <-0.80,2.3465,0.15>*in <-0.80,2.3465,-0.15>*in <-0.75,2.3465,-0.28>*in
			<-0.85,1.9035,0.28>*in <-0.90,1.9035,0.15>*in <-0.90,1.9035,-0.15>*in <-0.85,1.9035,-0.28>*in
			<-0.85,1.55,0.28>*in <-0.90,1.55,0.15>*in <-0.90,1.55,-0.15>*in <-0.85,1.55,-0.28>*in
		}
		bicubic_patch{//right panel
			type 1 flatness 0.05
			u_steps 5 v_steps 5
			<0.7,2.875,0.28>*in <0.75,2.875,0.15>*in <0.75,2.875,-0.15>*in <0.7,2.875,-0.28>*in
			<0.75,2.3465,0.28>*in <0.80,2.3465,0.15>*in <0.80,2.3465,-0.15>*in <0.75,2.3465,-0.28>*in
			<0.85,1.9035,0.28>*in <0.90,1.9035,0.15>*in <0.90,1.9035,-0.15>*in <0.85,1.9035,-0.28>*in
			<0.85,1.55,0.28>*in <0.90,1.55,0.15>*in <0.90,1.55,-0.15>*in <0.85,1.55,-0.28>*in
		}
		bicubic_patch{//left shoulder
			type 1 flatness 0.1
			u_steps 5 v_steps 5
			<-0.65,2.875,-0.27>*in <-0.5,2.875,-0.30>*in <-0.25,2.875,-0.60>*in <-0.1,2.875,-0.4>*in
			<-0.65,3.050,-0.15>*in <-0.5,3.125,-0.15>*in <-0.25,3.125,-0.35>*in <-0.1,3.125,-0.3>*in
			<-0.65,3.050,0.15>*in <-0.5,3.125,0.15>*in <-0.25,3.125,0.35>*in <-0.1,3.125,0.3>*in
			<-0.7,2.875,0.25>*in <-0.5,2.875,0.25>*in <-0.25,2.875,0.55>*in <0,2.875,0.55>*in
		}
		bicubic_patch{//right shoulder
			type 1 flatness 0.1
			u_steps 5 v_steps 5
			<0.65,2.875,-0.27>*in <0.5,2.875,-0.30>*in <0.25,2.875,-0.60>*in <0.1,2.875,-0.4>*in
			<0.65,3.050,-0.15>*in <0.5,3.125,-0.15>*in <0.25,3.125,-0.35>*in <0.1,3.125,-0.3>*in
			<0.65,3.050,0.15>*in <0.5,3.125,0.15>*in <0.25,3.125,0.35>*in <0.1,3.125,0.3>*in
			<0.7,2.875,0.25>*in <0.5,2.875,0.25>*in <0.25,2.875,0.55>*in <0,2.875,0.55>*in
		}
		cone{
			<0,2.00,0>*in,0.2*in,<0,2.25,0>*in,0.25*in hollow
			scale <1,1,0.2>
			rotate y*30 translate <0,0,0.71>*in rotate y*-40
		}
		texture{WeskitFTx}
	}
	union{
		bicubic_patch{//right back panel
			type 1 flatness 0.05
			u_steps 5 v_steps 5
			<0.65,2.875,-0.28>*in <0.5,2.875,-0.28>*in <0.25,2.875,-0.58>*in <0,2.875,-0.43>*in
			<0.75,2.3465,-0.28>*in <0.5,2.3465,-0.33>*in <0.3,2.3465,-0.58>*in <0,2.3465,-0.53>*in
			<0.85,1.9035,-0.28>*in <0.7,1.9035,-0.61>*in <0.4,1.9035,-0.63>*in <0,1.9035,-0.58>*in
			<0.85,1.55,-0.28>*in <0.7,1.55,-0.60>*in <0.4,1.55,-0.63>*in <0,1.55,-0.63>*in
		}
		bicubic_patch{//left back panel
			type 1 flatness 0.05
			u_steps 5 v_steps 5
			<-0.65,2.875,-0.28>*in <-0.5,2.875,-0.28>*in <-0.25,2.875,-0.58>*in <0,2.875,-0.43>*in
			<-0.75,2.3465,-0.28>*in <-0.5,2.3465,-0.33>*in <-0.3,2.3465,-0.58>*in <0,2.3465,-0.53>*in
			<-0.85,1.9035,-0.28>*in <-0.7,1.9035,-0.61>*in <-0.4,1.9035,-0.63>*in <0,1.9035,-0.58>*in
			<-0.85,1.55,-0.28>*in <-0.7,1.55,-0.60>*in <-0.4,1.55,-0.63>*in <0,1.55,-0.63>*in
		}
		texture{WeskitBTx}
	}
}

#declare TeddyLUSleeve=
union{
	sphere{
		< 0.000,0.000,0.000>,0.375*in
	}
	cone{
		< 0.000,0.000,0.000>,0.375*in,<-0.09375,-0.28125,0>*in,0.375*in
	}
	sphere{
		<-0.09375,-0.28125,0>*in,0.375*in
	}
	texture{ShirtTx}
}

#ifdef (TeddyLLSleeve) #undef TeddyLLSleeve #end

#declare TeddyRUSleeve=
union{
	sphere{
		< 0.000,0.000,0.000>,0.375*in
	}
	cone{
		< 0.000,0.000,0.000>,0.375*in,<0.09375,-0.28125,0>*in,0.375*in
	}
	sphere{
		<0.09375,-0.28125,0>*in,0.375*in
	}
	texture{ShirtTx}
}

#ifdef (TeddyRLSleeve) #undef TeddyRLSleeve #end
