// POV-Ray file
// Standard pre-defined colors
#include "colors.inc"
#include "textures.inc"
#include "glass.inc"
#include "metals.inc"
//#include "shapes.inc"
//#include "shapes2.inc"
#include "stones.inc"
#include "woods.inc"

/* Without anti-aliasing:
		19Feb2001: 800x600 AA 0.3:
	Time for parse: 0h 0m 38s (38 seconds)
	Time for trace: 0h 5m 4s (304 seconds)
	Total time: 0h 5m 42s (342 seconds)
*/

global_settings{max_trace_level 10}

// Units
#declare in = 1;// Redefine only this to change scale.
#declare ft = 12*in;
#declare yd = 36*in;
#declare mi = 5280*ft;

//========================================================================
#fopen DebugFile "othern.debug" write

#declare LookAt    = <0,6,0>*in;//scene
#declare ViewPoint = <-3,10,-12>*in;//scene
//development values
#declare Scene=4;
#declare CameraLight=0;
#declare GeneralLight=1;#declare GeneralLightXYZ=<0,12,-4>;
#declare Detailed=1;

//========================================================================
#declare BlackPt=texture{pigment{Black}}
#declare BluePt=texture{pigment{Blue}}
#declare BrassPt=texture{pigment{Brass}}
#declare BronzePt=texture{pigment{Bronze}}
#declare BrownPt=texture{pigment{Brown}}
#declare ClearPt=texture{pigment{Clear}}
#declare CopperPt=texture{pigment{Copper}}
#declare CoralPt=texture{pigment{Coral}}
#declare CyanPt=texture{pigment{Cyan}}
#declare FleshPt=texture{pigment{Flesh}}
#declare GoldPt=texture{pigment{Gold}}
#declare GreenPt=texture{pigment{Green}}
#declare Grey25Pt=texture{pigment{Gray25}}
#declare Grey50Pt=texture{pigment{Gray50}}
#declare Grey75Pt=texture{pigment{Gray75}}
#declare KhakiPt=texture{pigment{Khaki}}
#declare MagentaPt=texture{pigment{Magenta}}
#declare MaroonPt=texture{pigment{Maroon}}
#declare NavyPt=texture{pigment{Navy}}
#declare OrangePt=texture{pigment{Orange}}
#declare OrchidPt=texture{pigment{Orchid}}
#declare PinkPt=texture{pigment{Pink}}
#declare PlumPt=texture{pigment{Plum}}
#declare RedPt=texture{pigment{Red}}
#declare SalmonPt=texture{pigment{Salmon}}
#declare ScarletPt=texture{pigment{Scarlet}}
#declare SiennaPt=texture{pigment{Sienna}}
#declare SilverPt=texture{pigment{Silver}}
#declare TanPt=texture{pigment{Tan}}
#declare TurquoisePt=texture{pigment{Turquoise}}
#declare VioletPt=texture{pigment{Violet}}
#declare WhitePt=texture{pigment{White}}
#declare YellowPt=texture{pigment{Yellow}}
//#declare FeldsparPt=texture{pigment{Feldspar}}
//#declare QuartzPt=texture{pigment{Quartz}}

//========================================================================
//#include "BiCubic.mcr"
//#include "BiCubeDummy.mcr" //temp version

#declare Paper=
texture{
	pigment{colour rgb <1.0,1.0,0.9>}
}

#declare Nothing=
texture{
	pigment{colour rgbt <1.0,1.0,1.0,1.0>}
}
//========================================================================
// sketchy room
/*
plane{y,0    texture{pigment{colour rgb <0.60,0.55,0.35>}}}//bench
plane{z,5*ft texture{pigment{colour rgb <0.90,0.90,0.80>}}}//wall
plane{y,5*ft texture{pigment{colour rgb <0.55,0.55,0.60>}}}//ceiling
*/
background{colour rgb <0.5,0.5,0.8>}//just in case
//========================================================================
// macros
#macro UpTo(Vector1,Vector2,Seed)
	#local TempVector=
		<Vector1.x+(Vector2.x-Vector1.x)*rand(Seed),
		 Vector1.y+(Vector2.y-Vector1.y)*rand(Seed),
		 Vector1.z+(Vector2.z-Vector1.z)*rand(Seed)>;
	#if (Vector1.x=Vector2.x)
		#local TempVector=<Vector1.x,TempVector.y,TempVector.z>;
	#end
	#if (Vector1.y=Vector2.y)
		#local TempVector=<TempVector.x,Vector1.y,TempVector.z>;
	#end
	#if (Vector1.z=Vector2.z)
		#local TempVector=<TempVector.x,TempVector.y,Vector1.z>;
	#end
	TempVector
#end

#macro Flame2(FPos,FSiz)
merge{
  sphere {
    <0,0,0>,FSiz.x/3
  }
  cone {
    <0,0,0>,FSiz.x/3,<0,FSiz.y*2/3,0>,FSiz.x/4
  }
  cone {
    <0,FSiz.y*2/3,0>,FSiz.x/4,<FSiz.x/4,FSiz.y*4/3,0>,0
  }
  interior{
    media{
      emission 1
      density{
        spherical
        color_map {
          [ 0 color rgb <3, 0, 0> ]
          [ 1 color rgb <4, 4, 0>]
        }
      }
    }
  }
  texture{
    pigment{colour rgbt<1,1,1,1>}
  }
  hollow
  scale <1,1.5,1>
  translate FPos
}
#end


/*
	plocn: origin - bottom left front corner of book
	protn: rotation about book origin
	psize: size of book - all values should be positive
	coverimage: map of wraparound cover for book
*/
#macro Book(plocn,protn,psize,coverimage)
union{
	box{<0,0,0>,psize texture{Paper}}//pages
	box{
		<0,0,-0.01>,psize*<1,1,0>
		texture{
			pigment{
				image_map{
					png coverimage
					//sys coverimage
					map_type 0 interpolate 2 //once
				}
				scale <(psize.z+2*psize.x),psize.y,1>
				translate <(-psize.z-psize.x),psize.y,0>
			}
		}
	}//front cover
	box{
		<-0.01,0,0>,psize*<0,1,1>
		texture{
			pigment{
				image_map{
					png coverimage
					//sys coverimage
					map_type 0 interpolate 2 //once
				}
				rotate y*90
				scale <1,psize.y,(psize.z+2*psize.x)>
				translate <0,psize.y,psize.x+psize.z>
			}
		}
	}//spine
	box{
		<0,0,psize.z+0.01>,psize
		texture{
			pigment{
				image_map{
					png coverimage
					//sys coverimage
					map_type 0 interpolate 2 //once
				}
				scale <-(psize.z+2*psize.x),psize.y,1>
				translate <psize.x,psize.y,0>
			}
		}
	}//back cover
	rotate protn
	translate plocn
}
#end
/*
	plocn: origin - bottom left front corner of piece of paper
	protn: rotation about book origin
	psize: size of paper - all values should be positive
	pageimage: map of page contents - shows through on back.
*/
#macro Page(plocn,protn,psize,pageimage)
box{<0,0,0>,psize
	texture{
		pigment{
			image_map{
				sys pageimage
				map_type 0 interpolate 2 //once
			}
			scale <psize.x,psize.y,1>
			translate <0,psize.y,0>
		}
	}
	rotate protn
	translate plocn
}
#end
//========================================================================
//========================================================================
#switch (Scene)
	#case (1)
		//Book(<-2,0,4>*in,<0,0,0>,<4,7,1>,"bookxample.pict")
		//object{Book(<8.5,0,0>*in,<0,180,0>,<4,7,1>,"bookxample.pict") rotate x*90}
		//Book(<-2.5,1,0>*in,<0,-90,90>,<4,7,1>,"bookxample.pict")
		//Page(<-3,0.05,2>*in,<90,50,0>,<8.25,11,0.05>*in,"todo.pict")
		object{Book(0,<0,-90,90>,<5,7.75,0.75>,"HP3book.png") translate <-2.5,0.75,7>*in}
		object{Book(0,<0,-90,90>,<5,7.75,0.5>,"HP2book.png") rotate y*80 translate <-6.3,1.25,5>*in}
		object{Book(0,<0,-90,90>,<5,7.75,0.5>,"HP1book.png") rotate y*70 translate <-5,1.75,6>*in}
		//
		Book(<8,2.75,5>*in,<90,20,0>,<5,7.75,2.75>,"HP4book.png")
	#break
	#case (2)
		#declare SigGlobe=
		union{
			cone{<0,-4.3,0>*in,1.5*in,<0,-4.05,0>*in,1.25*in texture{Brushed_Aluminum rotate z*90}}
			cylinder{<0,-4.05,0>*in,<0,-3.95,0>*in,0.5*in texture{T_Silver_3A}}
			cone{<0,3.2,0>*in,0.125*in,<0,3.4,0>*in,0*in texture{T_Silver_3A}}
			sphere{0,3*in
				texture{//T_Silver_3C
					material_map{
						png "grid2.png"
						map_type 1
						texture{Nothing}//0
						texture{Nothing}//1
						texture{pigment{Black} finish{F_MetalA}}//2
						texture{T_Silver_3C}//3
					}
				}
			}
			sphere{0,2.95*in
				texture{
					material_map{
						png "grid.png"
						map_type 1
						texture{Nothing}
						texture{T_Silver_1A}
					}
				}
			}
			sphere{0,2.75*in
				texture{
					pigment{colour rgbf <1,1,1,0.25>}
				}
			}
			light_source {
		    	<0,0,0>*in
				colour rgb <1.5,1.5,1>
			}
			translate <0,4.3,0>*in
			rotate y*-90
		}
		object{SigGlobe translate <0,0,3>*in}
	#break
	#case (3)
		#declare LookAt    = <0,60,0>*in;//scene
		//#declare LookAt    = <0,120,0>*in;//head
		#declare ViewPoint = <0,96,-168>*in;//scene
		//#declare ViewPoint = <0,64,-84>*in;//human vp
		#declare CameraLight=0;
		#declare GeneralLight=1;#declare GeneralLightXYZ=<0,84,-48>*in;
		#include "idol.inc"
		object{Idol rotate y*0 translate <-4,0,0>*ft}
		object{Idol rotate y*90 translate <4.5,0,0.5>*ft}
		//object{Idol rotate x*-80 translate <4,7,6>*ft}
	#break
	#case (4)
		//#declare LookAt    = <0,60,-72>*in;//developing
		#declare LookAt    = <0,72,-72>*in+<0,0,60>*ft;//scene
		//#declare LookAt    = <0,48,-72>*in+<0,0,35>*ft;//plan view
		//#declare LookAt    = <0,60,60>*in;//in progress
		//#declare LookAt    = <0,120,0>*in;//head
		//#declare ViewPoint = <0,96,-372>*in;//scene
		//#declare ViewPoint = <0,96,-480>*in;//long shot
		//#declare ViewPoint = <0,64,-84>*in;//human vp
		//#declare ViewPoint = <0,480,-72>*in;//overview
		//#declare ViewPoint = <0,564,-552>*in;//long shot - overview
		//#declare ViewPoint = <0,1100,-72>*in+<0,0,35>*ft;//plan view
		#declare ViewPoint = <48,48,-580>*in+<0,0,60>*ft;//scene?
		//#declare ViewPoint = <24,48,-640>*in+<0,0,60>*ft;//scene?
		//#declare ViewPoint = <350,48,-580>*in+<0,0,60>*ft;//scene?
		//#declare ViewPoint = <0,48,-36>*in;
		#declare CameraLight=0.5;
		#declare GeneralLight=0;#declare GeneralLightXYZ=<0,40,-5>*ft;
		//ground
		plane{y,-6*in texture{pigment{colour rgb <0.40,0.65,0.50>}}}
		//#include "dice.inc"
		#include "rpger.inc"
		#include "temple01.inc"
		/*
		union{//LookAt marker
			cylinder{LookAt*<1,0,1>,LookAt*<1,5,1>,3*in}
			sphere{LookAt,6*in}
			texture{OrangePt}
		}
		union{//ViewPoint marker
			cylinder{<350,-12,-580>*in,<350,200,-580>*in,3*in}
			sphere{<350,48,-580>*in,6*in}
			texture{RedPt}
			translate <0,0,60>*ft
		}
		*/
	#break
	#case (5)
		/* GURPS Discworld costume ideas
			Death p157
			Dwarves p65
			guard.cst Guard p43/,83/,91/,96/ female p79/
			Lady p62
			Queen p186
			Susan p182
			Warrior maiden p29
			Witch p21 Witch 2 p49
			Wizard p101
		*/
		#declare LookAt    = <0,36,0>*in;//figure
		#declare ViewPoint = <0,48,-72>*in;//overview of scene
		//#declare ViewPoint = <0,48,-36>*in;
		#declare CameraLight=0.5;
		#declare GeneralLight=0.5;#declare GeneralLightXYZ=<0,10,-2>*ft;
		//#include "BiCubic.mcr"
		//#include "rtd2.inc"
		#local HFlesh=texture{pigment{colour rgb <0.79,0.45,0.31>}}
		#local HHair =texture{pigment{colour rgb <0.40,0.33,0.15>}}
		#local GuardPlate=texture{pigment{P_Brass1} finish{F_MetalC} normal{dents}}
		#local GuardChain=texture{
			pigment{
				leopard scale 0.01 turbulence 0.0
				colour_map{
					[0.00 colour rgbt <1,1,1,0.5>]
					[0.49 colour rgbt <1,1,1,0.5>]
					[0.50 P_Chrome1]
					[0.90 P_Chrome1]
					[0.91 colour rgbt <1,1,1,0.5>]
					[1.00 colour rgbt <1,1,1,0.5>]
				}
			}
			//finish{F_MetalA}
		}
		#local GuardLeather=texture{pigment{colour rgb <0.7,0.4,0.1>}}
		//#local GuardLeather=texture{pigment{colour rgb <0.2,0.4,0.9>}}
		#local GuardSole=texture{pigment{colour rgb <0.4,0.4,0.4>}}
		/*
		#local Furskin=
		texture{
		  pigment{
		    leopard
		    turbulence 0.4 octaves 6 omega 0.3 lambda 1.0
		    colour_map{
		      [0.00 colour rgb <0.66, 0.50, 0.16>]
		      [0.30 colour rgb <0.66, 0.50, 0.16>]
		      [0.31 colour rgb <0.25, 0.25, 0.05>]
		      [1.00 colour rgb <0.18, 0.18, 0.04>]
		    } scale 0.5 rotate <10,0,15>
		  }
			normal{
				wrinkles 0.5 turbulence 0.5
			}
		}
		*/
		//#include "cavekid2.cst"
		//#include "pupil.cst"
		#include "matrix.mcr"
		#include "rtd3.inc"
		#include "guard.cst"
		//RTDH2(<0,0,0>,<0,0,0>,
		RTDH3(<0,0,0>,<0,0,0>,
			array[7]{<1,1,1>,<1,1,1>,<1,1,1>,<1,1,1>,<1,1,1>,<1,1,1>,<1,1,1>},
			array[9]{<0,0,0>,<0,0,-10>,<0,0,0>,<0,0,10>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>},
			array[1]{0},<0,0,0>,<0,0,0>,<0,0,0>
			,<0,0,0>,<0,0,0>
		)
		//RTDH2(<21,0,0>,<0,180,0>,
		RTDH3(<21,0,0>,<0,180,0>,
			array[7]{<1,1,1>,<1,1,1>,<1,1,1>,<1,1,1>,<1,1,1>,<1,1,1>,<1,1,1>},
			array[9]{<0,0,0>,<0,0,-10>,<0,0,0>,<0,0,10>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>},
			array[1]{0},<0,0,0>,<0,0,0>,<0,0,0>
			,<0,0,0>,<0,0,0>
		)
		//RTDH2(<-21,0,0>,<0,-90,0>,
		RTDH3(<-21,0,0>,<0,-90,0>,
			array[7]{<1,1,1>,<1,1,1>,<1,1,1>,<1,1,1>,<1,1,1>,<1,1,1>,<1,1,1>},
			array[9]{<0,0,0>,<0,0,-10>,<0,0,0>,<0,0,10>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>},
			array[1]{0},<0,0,0>,<0,0,0>,<0,0,0>
			,<0,0,0>,<0,0,0>
		)                              
	#break
	#case (6)
		#declare LookAt    = <0,36,0>*in;//figure
		#declare ViewPoint = <0,48,-72>*in;//overview of scene
		#declare CameraLight=0.5;
		#declare GeneralLight=0.5;#declare GeneralLightXYZ=<0,10,-2>*ft;
		#include "rpger.inc"
		//CalmoraCostume()
		NeffyCostume()
		/*
		RTDH3(<0,RPGoffset.y,0>,<0,0*-15,0>,
			RPGBody,RPGPose,
			array[1]{0},<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>
		)
		cylinder{<0,0,RPGoffset.z>*in,<0,-4,RPGoffset.z>*in,1*ft texture{Grey50Pt}}
		*/
		//MencoriCostume()
		//
		RTDH3(<25,RPGoffset.y,0>,<0,0*180,0>,
			RPGBody,RPGPose,
			array[1]{0},<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>
		)
		cylinder{<25,0,-RPGoffset.z>*in,<25,-4,-RPGoffset.z>*in,1*ft texture{Grey50Pt}}
		//
		//FalaneCostume()
		HondyCostume()
		RTDH3(<-32,RPGoffset.y,RPGoffset.z>,<0,0*-90,0>,
			RPGBody,RPGPose,
			array[1]{0},<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>
		)                              
		cylinder{<-32-RPGoffset.z,0,RPGoffset.z>*in,<-32-RPGoffset.z,-4,RPGoffset.z>*in,1*ft texture{Grey50Pt}}
	#break
#end

//========================================================================
#if (CameraLight>0)
  light_source{
    ViewPoint
    colour rgb <1,1,1>*CameraLight
  }
#end
camera{
  //right x
  location  ViewPoint // position of camera <X Y Z>
  look_at   LookAt // point center of view at this point <X Y Z>
}
#if (GeneralLight>0)
  light_source {
    GeneralLightXYZ
    colour rgb <1,1,1>*GeneralLight
  }
#end
#fclose DebugFile
