// Persistence Of Vision INCLUDE file
// File:        temple01.inc
// Vers:        3.1g.r1 Mac PPC
// Desc:        Ancient primitive temple ruins
// Auth:        Peter Murray
// Date:        15th February 2001

#debug "\r  temple01.inc - Ancient primitive temple ruins\r"

//Switches
#declare T01_Version=2;

//Random seeds
#declare StoneRotn=seed(4918);
#declare StoneSlip=seed(5612);
#declare SlabTilt=seed(5244);
#declare BlockTilt=seed(0346);
#declare BlockRotn=seed(2752);
#declare BlockSlip=seed(2504);
#declare BlockShift=seed(1216);

//Textures
#declare OldMortar=
texture{
	pigment{colour rgb <0.9,0.8,0.4>}
	normal{dents 1 scale <6,1,1>}
}

#declare FloorSlab=T_Grnt17
#declare WallBlock=T_Grnt25

//Construction stones:
//T_Grnt17 reasonable
//T_Grnt21 very dark
//T_Grnt25 light
//T_Grnt27 brownish
//T_Stone2 new buildings
//T_Stone14 new buildings
//T_Stone18 temple inlays/detailing
//T_Stone24 ?
//T_Stone36 muddy look
//T_Stone37 looks more like cork!
//T_Stone40 light green
//T_Stone44 better for standing stones

// Objects
#local HFlesh=texture{pigment{colour rgb <0.79,0.45,0.31>}}
#local HHair =texture{pigment{colour rgb <0.40,0.33,0.15>}}
#local GuardPlate=texture{pigment{P_Brass1} finish{F_MetalC} normal{dents}}
#local GuardChain=texture{
	pigment{
		/*spotted*/ leopard scale 0.01 turbulence 0.0
		colour_map{
			[0.00 colour rgbt <1,1,1,0.5>]
			[0.49 colour rgbt <1,1,1,0.5>]
			[0.50 P_Chrome1]
			[0.90 P_Chrome1]
			[0.91 colour rgbt <1,1,1,0.5>]
			[1.00 colour rgbt <1,1,1,0.5>]
		}
	}
	//finish{F_MetalA}
}
#local GuardLeather=texture{pigment{colour rgb <0.7,0.4,0.1>}}
#local GuardSole=texture{pigment{colour rgb <0.4,0.4,0.4>}}

/*
#include "matrix.mcr"
//#include "rtd2.inc"
#include "rtd3.inc"
#include "guard.cst"
#declare HumanFigure=object{
	//RTDH2(<0,0,0>,<0,0,0>,
	RTDH3(<0,0,0>,<0,0,0>,
		array[7]{<1,1,1>,<1,1,1>,<1,1,1>,<1,1,1>,<1,1,1>,<1,1,1>,<1,1,1>},
		array[9]{<15,5,0>,<15,0,-25>,<15,0,65>,<0,0,10>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>},
		array[1]{0},<0,0,0>,<0,0,0>,<0,0,0>
		,<0,0,0>,<0,0,0>
	)
}
*/

#include "idol.inc"

// Macros
/*
	A slab 3feet square and 6 inches thick, with the texture "moved"
	via rotate and translate, and with the slab itself tilted slightly
	due to the long years since it was laid.
*/
#macro PavingSlab(pLocn,pRotn,pTexture)
	#write(DebugFile,"PavingSlab(",pLocn,",",pRotn,",FloorSlab)\n")
	superellipsoid{
		<0.15,0.1> scale <18,1.5,18> translate <0,3,0>*in
		//rotate UpTo(<-5,0,-5>,<5,0,5>,SlabTilt)
		rotate UpTo(<-2,0,-2>,<2,0,2>,SlabTilt)
		rotate pRotn translate pLocn
		texture{
			pTexture rotate UpTo(<-30,-90,-30>,<30,90,30>,StoneRotn)
			translate UpTo(<-100,-100,-100>*ft,<100,100,100>*ft,StoneSlip)
		}
	}
#end

/*
	A large building block, 2 feet square and 6 feet long.  Textures
	are "moved" again, and the block is rotated slightly from its
	original position.
	pStone: Stone texture
	pMortar: Mortar texture
	swMortar: Switch: 0 no mortar, 1 mortar all round, 2 mortar except on top, 3 mortar only underneath
*/
#macro StoneBlock(pLocn,pRotn,pStone,pMortar,swMortar)
union{
	#write(DebugFile,"StoneBlock(",pLocn,",",pRotn,",WallBlock,OldMortar,",swMortar,")\n")
	superellipsoid{
		<0.1,0.1> scale <36,12,12> translate <0,12,0>*in
		texture{
			pStone rotate UpTo(<-30,-90,-30>,<30,90,30>,BlockRotn)
			translate UpTo(<-100,-100,-100>*ft,<100,100,100>*ft,BlockSlip)
		}
	}
	#switch (swMortar)
		#case (1)
			box{
				<-36.75,-0.25,-11.5>*in,<36.75,24.25,11.5>*in
				texture{pMortar}
			}
		#break
		#case (2)
			box{
				<-36.75,-0.25,-11.5>*in,<36.75,23.75,11.5>*in
				texture{pMortar}
			}
		#break
		#case (3)
			box{
				<-36.75,-0.25,-11.5>*in,<36.75,0.25,11.5>*in
				texture{pMortar}
			}
		#break
	#end
	rotate UpTo(<0,-3,0>,<0,3,0>,BlockTilt)
	rotate pRotn
	translate UpTo(<0,0,-1>,<0,0,1>,BlockShift)
	translate pLocn
}
#end

// Smaller block, a cube 2 feet on a side.
#macro StoneSquare(pLocn,pRotn,pStone,pMortar,swMortar)
union{
	#write(DebugFile,"StoneSquare(",pLocn,",",pRotn,",WallBlock,OldMortar,",swMortar,")\n")
	superellipsoid{
		<0.1,0.1> scale <12,12,12> translate <0,12,0>*in
		texture{
			pStone rotate UpTo(<-30,-90,-30>,<30,90,30>,BlockRotn)
			translate UpTo(<-100,-100,-100>*ft,<100,100,100>*ft,BlockSlip)
		}
	}
	#switch (swMortar)
		#case (1)
			box{
				<-12.75,-0.25,-11.5>*in,<12.75,24.25,11.5>*in
				texture{pMortar}
			}
		#break
		#case (2)
			box{
				<-12.75,-0.25,-11.5>*in,<12.75,23.75,11.5>*in
				texture{pMortar}
			}
		#break
		#case (3)
			box{
				<-12.75,-0.25,-11.5>*in,<12.75,0.25,11.5>*in
				texture{pMortar}
			}
		#break
	#end
	rotate UpTo(<0,-3,0>,<0,3,0>,BlockTilt)
	rotate pRotn
	translate UpTo(<0,0,-1>,<0,0,1>,BlockShift)
	translate pLocn
}
#end

// Block of arbitrary length pLength
#macro StoneExtra(pLocn,pRotn,pLength,pStone,pMortar,swMortar)
union{
	#write(DebugFile,"StoneExtra(",pLocn,",",pRotn,",",pLength,",WallBlock,OldMortar,",swMortar,")\n")
	#local uLength=pLength/2;
	superellipsoid{
		<0.1,0.1> scale <uLength,12,12> translate <0,12,0>*in
		texture{
			pStone rotate UpTo(<-30,-90,-30>,<30,90,30>,BlockRotn)
			translate UpTo(<-100,-100,-100>*ft,<100,100,100>*ft,BlockSlip)
		}
	}
	#switch (swMortar)
		#case (1)
			box{
				<-uLength-0.75,-0.25,-11.5>*in,<uLength+0.75,24.25,11.5>*in
				texture{pMortar}
			}
		#break
		#case (2)
			box{
				<-uLength-0.75,-0.25,-11.5>*in,<uLength+0.75,23.75,11.5>*in
				texture{pMortar}
			}
		#break
		#case (3)
			box{
				<-uLength-0.75,-0.25,-11.5>*in,<uLength+0.75,0.25,11.5>*in
				texture{pMortar}
			}
		#break
	#end
	rotate UpTo(<0,-3,0>,<0,3,0>,BlockTilt)
	rotate pRotn
	translate UpTo(<0,0,-1>,<0,0,1>,BlockShift)
	translate pLocn
}
#end

// Arch of arbitrary size pSize, with pArch cut out of it
// Note: pArch.x is complete span, pArch.y is height of arch, pArch.z is ignored.
#macro StoneArch(pLocn,pRotn,pSize,pArch,pStone,pMortar,swMortar)
difference{
	union{
		#write(DebugFile,"StoneArch(",pLocn,",",pRotn,",",pSize,",",pArch,",WallBlock,OldMortar,",swMortar,")\n")
		#local uSize=pSize/2;
		superellipsoid{
			<0.1,0.1> scale uSize translate <0,uSize.y,0>*in
		}
		#switch (swMortar)
			#case (1)
				box{
					(uSize*<-1,0,-1>)+<-0.75,-0.25,+0.5>*in,(uSize*<1,2,1>)+<0.75,0.25,-0.5>*in
					texture{pMortar}
				}
			#break
			#case (2)
				box{
					(uSize*<-1,0,-1>)+<-0.75,-0.25,+0.5>*in,(uSize*<1,2,1>)+<0.75,-0.25,-0.5>*in
					texture{pMortar}
				}
			#break
			#case (3)
				box{
					(uSize*<-1,0,-1>)+<-0.75,-0.25,+0.5>*in,(uSize*<1,0,1>)+<0.75,0.25,-0.5>*in
					texture{pMortar}
				}
			#break
		#end
	}
	cylinder{<0,0,uSize.z*1.1>,<0,0,-uSize.z*1.1>,1 scale <pArch.x/2,pArch.y,1>}
	texture{
		pStone rotate UpTo(<-30,-90,-30>,<30,90,30>,BlockRotn)
		translate UpTo(<-100,-100,-100>*ft,<100,100,100>*ft,BlockSlip)
	}
	rotate UpTo(<0,-3,0>,<0,3,0>,BlockTilt)
	rotate pRotn
	translate UpTo(<0,0,-1>,<0,0,1>,BlockShift)
	translate pLocn
}
#end



#if (T01_Version=0)
	// test floor
	#local ZZ=0;
	#while (ZZ<=6)
		#local XX=-5;
		#while (XX<=5)
			PavingSlab(<XX*36,-6,ZZ*36>*in,<0,0,0>,T_Grnt17)
			#local XX=XX+1;
		#end
		#local ZZ=ZZ+1;
	#end

	// first test of wall
	#local YY=0;
	#while (YY<=2)
		#local XX=-3;
		#while (XX<=3)
			StoneBlock(<XX*72,-6+48*YY,48>*in,<0,0,0>,T_Grnt25,OldMortar)
			StoneBlock(<XX*72-36,18+48*YY,48>*in,<0,0,0>,T_Grnt25,OldMortar)
			#local XX=XX+1;
		#end
		#local YY=YY+1;
	#end

	// second test of wall
	#local YY=0;
	#while (YY<=2)
		#local XX=-3;
		#while (XX<=3)
			StoneBlock(<XX*72,-6+48*YY,48>*in,<0,0,0>,T_Grnt25,OldMortar)
			StoneSquare(<XX*72-12,18+48*YY,48>*in,<0,0,0>,T_Grnt25,OldMortar)
			StoneSquare(<XX*72+12,18+48*YY,48>*in,<0,0,0>,T_Grnt25,OldMortar)
			StoneSquare(<XX*72+36,18+48*YY,48>*in,<0,0,0>,T_Grnt25,OldMortar)
			#local XX=XX+1;
		#end
		#local YY=YY+1;
	#end
#end

// Build temple
#local MaxY=3;

#if (T01_Version=1)
	#declare T01_IdolRoom=
	union{
		//floor
		#local ZZ=1;
		#while (ZZ>=-6)
			#local XX=-5;
			#while (XX<=5)
				PavingSlab(<XX*36,-6,ZZ*36+12>*in,<0,0,0>,FloorSlab)
				#local XX=XX+1;
			#end
			#local ZZ=ZZ-1;
		#end
		//back and front walls of idol room:
		#local YY=0;
		#while (YY<=MaxY)
			#local XX=-2;
			#while (XX<=2)
				StoneBlock(<XX*72,48*YY,72>*in,<0,0,0>,WallBlock,OldMortar,2)
				#if (XX=0)
					StoneSquare(<0,24+48*YY,72>*in,<0,0,0>,WallBlock,OldMortar,2)
					#if (YY=3)
						StoneExtra(<0,24+48*YY,-216>*in,<0,0,0>,10*ft,WallBlock,OldMortar,2)
					#end
				#else
					StoneBlock(<XX*72+(XX>0?-24:24),24+48*YY,72>*in,<0,0,0>,WallBlock,OldMortar,2)
					StoneBlock(<XX*72+(XX>0?24:-24),24+48*YY,-216>*in,<0,0,0>,WallBlock,OldMortar,2)
					#if (abs(XX)=1)
						#if (YY!=3)
							StoneSquare(<XX*72,48*YY,-216>*in,<0,0,0>,WallBlock,OldMortar,2)
						#else
							//StoneBlock(<XX*72+(XX>0?-24:24),48*YY,-216>*in,<0,0,0>,WallBlock,OldMortar,0)
							StoneExtra(<XX*72+(XX>0?-12:12),48*YY,-216>*in,<0,0,0>,4*ft,WallBlock,OldMortar,0)
						#end
					#else
						StoneBlock(<XX*72+(XX>0?-24:24),48*YY,-216>*in,<0,0,0>,WallBlock,OldMortar,2)
					#end
				#end
				#local XX=XX+1;
			#end
			#local YY=YY+1;
		#end
		//side walls of idol room:
		#local YY=0;
		#while (YY<=MaxY)
			#local ZZ=0;
			#while (ZZ>=-3)
				StoneBlock(<-168,48*YY,ZZ*72+24>*in,<0,90,0>,WallBlock,OldMortar,2)
				StoneBlock(<168,48*YY,ZZ*72+24>*in,<0,90,0>,WallBlock,OldMortar,2)
				StoneBlock(<-168,24+48*YY,ZZ*72+48>*in,<0,90,0>,WallBlock,OldMortar,2)
				StoneBlock(<168,24+48*YY,ZZ*72+48>*in,<0,90,0>,WallBlock,OldMortar,2)
				#local ZZ=ZZ-1;
			#end
			#local YY=YY+1;
		#end
		//idol room entrance:
		StoneBlock(<-60,36,-216>*in,<0,0,-90>,WallBlock,OldMortar,2)
		StoneBlock(<60,36,-216>*in,<0,0,90>,WallBlock,OldMortar,2)
		StoneBlock(<-60,108,-216>*in,<0,0,-90>,WallBlock,OldMortar,2)
		StoneBlock(<60,108,-216>*in,<0,0,90>,WallBlock,OldMortar,2)
		//the point of the idol room:
		object{Idol rotate y*0 translate <0,0,1>*ft}	
	}

	#declare T01_MainChamber=
	union{
		//floor
		#local ZZ=-7;
		#while (ZZ>=-17)
			#local XX=-11;
			#while (XX<=11)
				PavingSlab(<XX*36,-6,ZZ*36+12>*in,<0,0,0>,FloorSlab)
				#local XX=XX+1;
			#end
			#local ZZ=ZZ-1;
		#end
		//back wall:
		#local YY=0;
		#while (YY<=MaxY)
			#local XX=3;
			#while (XX<=5)
				StoneBlock(<XX*72,48*YY,-216>*in,<0,0,0>,WallBlock,OldMortar,2)
				StoneBlock(<XX*72+(XX>0?24:-24),24+48*YY,-216>*in,<0,0,0>,WallBlock,OldMortar,2)
				StoneBlock(<-(XX*72),48*YY,-216>*in,<0,0,0>,WallBlock,OldMortar,2)
				StoneBlock(<-(XX*72+(XX>0?24:-24)),24+48*YY,-216>*in,<0,0,0>,WallBlock,OldMortar,2)
				#local XX=XX+1;
			#end
			#local YY=YY+1;
		#end
		//side walls:
		#local YY=0;
		#while (YY<=MaxY)
			#local ZZ=0;
			#while (ZZ>=-5)
				StoneBlock(<-408,48*YY,ZZ*72-240>*in,<0,90,0>,WallBlock,OldMortar,2)
				StoneBlock(<408,48*YY,ZZ*72-240>*in,<0,90,0>,WallBlock,OldMortar,2)
				#if (ZZ>-5)
					StoneBlock(<-408,24+48*YY,ZZ*72-264>*in,<0,90,0>,WallBlock,OldMortar,2)
					StoneBlock(<408,24+48*YY,ZZ*72-264>*in,<0,90,0>,WallBlock,OldMortar,2)
				#end
				#local ZZ=ZZ-1;
			#end
			#local YY=YY+1;
		#end
		//front wall:
		#local YY=0;
		#while (YY<=MaxY)
			#local XX=-5;
			#while (XX<=5)
				#switch (XX)
					#case (0)
						#if (YY=3)
							StoneArch(<0,-72+48*YY,-600>*in,<0,0,0>,<10,6,2>*ft,<6,3,0>*ft,WallBlock,OldMortar,2)
							StoneBlock(<0,48*YY,-600>*in,<0,0,0>,WallBlock,OldMortar,2)
							StoneExtra(<0,24+48*YY,-600>*in,<0,0,0>,10*ft,WallBlock,OldMortar,2)
						#end
					#break
					#case (-1)
						#if (YY=3)
							StoneBlock(<-72,48*YY,-600>*in,<0,0,0>,WallBlock,OldMortar,2)
							StoneBlock(<-96,24+48*YY,-600>*in,<0,0,0>,WallBlock,OldMortar,2)
						#else
							StoneSquare(<-72,48*YY,-600>*in,<0,0,0>,WallBlock,OldMortar,2)
							StoneBlock(<-96,48*YY,-624>*in,<0,90,0>,WallBlock,OldMortar,2)
							StoneBlock(<XX*72+(XX>0?24:-24),24+48*YY,-600>*in,<0,0,0>,WallBlock,OldMortar,2)
						#end
					#break
					#case (1)
						#if (YY=3)
							StoneBlock(<72,48*YY,-600>*in,<0,0,0>,WallBlock,OldMortar,2)
							StoneBlock(<96,24+48*YY,-600>*in,<0,0,0>,WallBlock,OldMortar,2)
						#else
							StoneSquare(<72,48*YY,-600>*in,<0,0,0>,WallBlock,OldMortar,2)
							StoneBlock(<96,48*YY,-624>*in,<0,90,0>,WallBlock,OldMortar,2)
							StoneBlock(<XX*72+(XX>0?24:-24),24+48*YY,-600>*in,<0,0,0>,WallBlock,OldMortar,2)
						#end
					#break
					#case (-3)
						#if (YY=3)
							StoneBlock(<-240,24+48*YY,-600>*in,<0,0,0>,WallBlock,OldMortar,2)
							StoneExtra(<-252,48*YY,-600>*in,<0,0,0>,12*ft,WallBlock,OldMortar,2)
						#else
							StoneExtra(<-204,48*YY,-600>*in,<0,0,0>,4*ft,WallBlock,OldMortar,2)
							#if (YY<2)
								StoneSquare(<-216,24+48*YY,-600>*in,<0,0,0>,WallBlock,OldMortar,2)
							#else
								StoneArch(<-252,24+48*YY,-600>*in,<0,0,0>,<8,2,2>*ft,<4,1,0>*ft,WallBlock,OldMortar,2)
							#end
						#end
					#break
					#case (3)
						#if (YY=3)
							StoneExtra(<252,48*YY,-600>*in,<0,0,0>,12*ft,WallBlock,OldMortar,2)
							StoneBlock(<240,24+48*YY,-600>*in,<0,0,0>,WallBlock,OldMortar,2)
						#else
							StoneExtra(<204,48*YY,-600>*in,<0,0,0>,4*ft,WallBlock,OldMortar,2)
							#if (YY<2)
								StoneSquare(<216,24+48*YY,-600>*in,<0,0,0>,WallBlock,OldMortar,2)
							#else
								StoneArch(<252,24+48*YY,-600>*in,<0,0,0>,<8,2,2>*ft,<4,1,0>*ft,WallBlock,OldMortar,2)
							#end
						#end
					#break
					#case (-4)
						#if (YY=3)
							StoneBlock(<XX*72+(XX>0?24:-24),24+48*YY,-600>*in,<0,0,0>,WallBlock,OldMortar,2)
						#else
							#if (YY<2)
								StoneBlock(<XX*72+(XX>0?24:-24),24+48*YY,-600>*in,<0,0,0>,WallBlock,OldMortar,2)
							#else
								StoneExtra(<XX*72+(XX>0?36:-36),24+48*YY,-600>*in,<0,0,0>,4*ft,WallBlock,OldMortar,2)
							#end
							StoneExtra(<-300,48*YY,-600>*in,<0,0,0>,4*ft,WallBlock,OldMortar,2)
						#end
					#break
					#case (4)
						#if (YY=3)
							StoneBlock(<XX*72+(XX>0?24:-24),24+48*YY,-600>*in,<0,0,0>,WallBlock,OldMortar,2)
						#else
							#if (YY<2)
								StoneBlock(<XX*72+(XX>0?24:-24),24+48*YY,-600>*in,<0,0,0>,WallBlock,OldMortar,2)
							#else
								StoneExtra(<XX*72+(XX>0?36:-36),24+48*YY,-600>*in,<0,0,0>,4*ft,WallBlock,OldMortar,2)
							#end
							StoneExtra(<300,48*YY,-600>*in,<0,0,0>,4*ft,WallBlock,OldMortar,2)
						#end
					#break
					#else
						StoneBlock(<XX*72,48*YY,-600>*in,<0,0,0>,WallBlock,OldMortar,2)
						StoneBlock(<XX*72+(XX>0?24:-24),24+48*YY,-600>*in,<0,0,0>,WallBlock,OldMortar,2)
					#break
				#end
				#local XX=XX+1;
			#end
			#local YY=YY+1;
		#end
		//entrance:
		StoneBlock(<-60,36,-600>*in,<0,0,-90>,WallBlock,OldMortar,2)
		StoneBlock(<60,36,-600>*in,<0,0,90>,WallBlock,OldMortar,2)
	}

	#declare T01_EntranceWay=
	union{
		//floor
		#local ZZ=-18;
		#while (ZZ>=-23)
			#local XX=-11;
			#while (XX<=11)
				PavingSlab(<XX*36,-6,ZZ*36+12>*in,<0,0,0>,FloorSlab)
				#local XX=XX+1;
			#end
			#local ZZ=ZZ-1;
		#end
		//side walls:
		#local YY=0;
		#while (YY<=MaxY)
			#local ZZ=-1;
			#while (ZZ>=-2)
				StoneBlock(<-408,48*YY,ZZ*72-600>*in,<0,90,0>,WallBlock,OldMortar,2)
				StoneBlock(<-96,48*YY,ZZ*72-624>*in,<0,90,0>,WallBlock,OldMortar,2)
				StoneBlock(<96,48*YY,ZZ*72-624>*in,<0,90,0>,WallBlock,OldMortar,2)
				StoneBlock(<408,48*YY,ZZ*72-600>*in,<0,90,0>,WallBlock,OldMortar,2)
				StoneBlock(<-408,24+48*YY,ZZ*72-576>*in,<0,90,0>,WallBlock,OldMortar,2)
				StoneBlock(<-96,24+48*YY,ZZ*72-576>*in,<0,90,0>,WallBlock,OldMortar,2)
				StoneBlock(<96,24+48*YY,ZZ*72-576>*in,<0,90,0>,WallBlock,OldMortar,2)
				StoneBlock(<408,24+48*YY,ZZ*72-576>*in,<0,90,0>,WallBlock,OldMortar,2)
				#local ZZ=ZZ-1;
			#end
			StoneExtra(<-408,24+48*YY,-780>*in,<0,90,0>,4*ft,WallBlock,OldMortar,2)
			StoneSquare(<-96,24+48*YY,-768>*in,<0,90,0>,WallBlock,OldMortar,2)
			StoneSquare(<96,24+48*YY,-768>*in,<0,90,0>,WallBlock,OldMortar,2)
			StoneExtra(<408,24+48*YY,-780>*in,<0,90,0>,4*ft,WallBlock,OldMortar,2)
			#local YY=YY+1;
		#end
		//front wall:
		#local YY=0;
		#while (YY<=MaxY)
			#local XX=-5;
			#while (XX<=5)
				#switch (XX)
					#case (0)
					#break
					#case (-1)
						StoneSquare(<-120,48*YY,-792>*in,<0,0,0>,WallBlock,OldMortar,2)
					#break
					#case (1)
						StoneSquare(<120,48*YY,-792>*in,<0,0,0>,WallBlock,OldMortar,2)
					#break
					#else
						StoneBlock(<XX*72+(XX>0?24:-24),48*YY,-792>*in,<0,0,0>,WallBlock,OldMortar,2)
						StoneBlock(<XX*72+(XX>0?-24:24),24+48*YY,-792>*in,<0,0,0>,WallBlock,OldMortar,2)
					#break
				#end
				#local XX=XX+1;
			#end
			StoneSquare(<-384,24+48*YY,-792>*in,<0,0,0>,WallBlock,OldMortar,2)
			StoneSquare(<384,24+48*YY,-792>*in,<0,0,0>,WallBlock,OldMortar,2)
			#local YY=YY+1;
		#end
		//entrance:
		StoneExtra(<-84,48,-792>*in,<0,0,-90>,8*ft,WallBlock,OldMortar,2)
		StoneExtra(<84,48,-792>*in,<0,0,90>,8*ft,WallBlock,OldMortar,2)
		StoneArch(<0,96,-792>*in,<0,0,0>,<14,8,2>*ft,<10,4,0>*ft,WallBlock,OldMortar,2)
	}
#end

#if (T01_Version=2) //built up from diagnostic output from macro calls in version 1.
	#declare T01_IdolRoom=
	union{
		//the point of the idol room:
		object{Idol rotate y*0 translate <0,0,1>*ft}	
		//lay the floor of this room
		PavingSlab(<-180,-6,48> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-144,-6,48> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-108,-6,48> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-72,-6,48> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-36,-6,48> ,<0,0,0> ,FloorSlab)
		PavingSlab(<0,-6,48> ,<0,0,0> ,FloorSlab)
		PavingSlab(<36,-6,48> ,<0,0,0> ,FloorSlab)
		PavingSlab(<72,-6,48> ,<0,0,0> ,FloorSlab)
		PavingSlab(<108,-6,48> ,<0,0,0> ,FloorSlab)
		PavingSlab(<144,-6,48> ,<0,0,0> ,FloorSlab)
		PavingSlab(<180,-6,48> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-180,-6,12> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-144,-6,12> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-108,-6,12> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-72,-6,12> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-36,-6,12> ,<0,0,0> ,FloorSlab)
		PavingSlab(<0,-6,12> ,<0,0,0> ,FloorSlab)
		PavingSlab(<36,-6,12> ,<0,0,0> ,FloorSlab)
		PavingSlab(<72,-6,12> ,<0,0,0> ,FloorSlab)
		PavingSlab(<108,-6,12> ,<0,0,0> ,FloorSlab)
		PavingSlab(<144,-6,12> ,<0,0,0> ,FloorSlab)
		PavingSlab(<180,-6,12> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-180,-6,-24> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-144,-6,-24> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-108,-6,-24> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-72,-6,-24> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-36,-6,-24> ,<0,0,0> ,FloorSlab)
		PavingSlab(<0,-6,-24> ,<0,0,0> ,FloorSlab)
		PavingSlab(<36,-6,-24> ,<0,0,0> ,FloorSlab)
		PavingSlab(<72,-6,-24> ,<0,0,0> ,FloorSlab)
		PavingSlab(<108,-6,-24> ,<0,0,0> ,FloorSlab)
		PavingSlab(<144,-6,-24> ,<0,0,0> ,FloorSlab)
		PavingSlab(<180,-6,-24> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-180,-6,-60> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-144,-6,-60> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-108,-6,-60> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-72,-6,-60> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-36,-6,-60> ,<0,0,0> ,FloorSlab)
		PavingSlab(<0,-6,-60> ,<0,0,0> ,FloorSlab)
		PavingSlab(<36,-6,-60> ,<0,0,0> ,FloorSlab)
		PavingSlab(<72,-6,-60> ,<0,0,0> ,FloorSlab)
		PavingSlab(<108,-6,-60> ,<0,0,0> ,FloorSlab)
		PavingSlab(<144,-6,-60> ,<0,0,0> ,FloorSlab)
		PavingSlab(<180,-6,-60> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-180,-6,-96> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-144,-6,-96> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-108,-6,-96> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-72,-6,-96> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-36,-6,-96> ,<0,0,0> ,FloorSlab)
		PavingSlab(<0,-6,-96> ,<0,0,0> ,FloorSlab)
		PavingSlab(<36,-6,-96> ,<0,0,0> ,FloorSlab)
		PavingSlab(<72,-6,-96> ,<0,0,0> ,FloorSlab)
		PavingSlab(<108,-6,-96> ,<0,0,0> ,FloorSlab)
		PavingSlab(<144,-6,-96> ,<0,0,0> ,FloorSlab)
		PavingSlab(<180,-6,-96> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-180,-6,-132> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-144,-6,-132> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-108,-6,-132> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-72,-6,-132> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-36,-6,-132> ,<0,0,0> ,FloorSlab)
		PavingSlab(<0,-6,-132> ,<0,0,0> ,FloorSlab)
		PavingSlab(<36,-6,-132> ,<0,0,0> ,FloorSlab)
		PavingSlab(<72,-6,-132> ,<0,0,0> ,FloorSlab)
		PavingSlab(<108,-6,-132> ,<0,0,0> ,FloorSlab)
		PavingSlab(<144,-6,-132> ,<0,0,0> ,FloorSlab)
		PavingSlab(<180,-6,-132> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-180,-6,-168> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-144,-6,-168> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-108,-6,-168> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-72,-6,-168> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-36,-6,-168> ,<0,0,0> ,FloorSlab)
		PavingSlab(<0,-6,-168> ,<0,0,0> ,FloorSlab)
		PavingSlab(<36,-6,-168> ,<0,0,0> ,FloorSlab)
		PavingSlab(<72,-6,-168> ,<0,0,0> ,FloorSlab)
		PavingSlab(<108,-6,-168> ,<0,0,0> ,FloorSlab)
		PavingSlab(<144,-6,-168> ,<0,0,0> ,FloorSlab)
		PavingSlab(<180,-6,-168> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-180,-6,-204> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-144,-6,-204> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-108,-6,-204> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-72,-6,-204> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-36,-6,-204> ,<0,0,0> ,FloorSlab)
		PavingSlab(<0,-6,-204> ,<0,0,0> ,FloorSlab)
		PavingSlab(<36,-6,-204> ,<0,0,0> ,FloorSlab)
		PavingSlab(<72,-6,-204> ,<0,0,0> ,FloorSlab)
		PavingSlab(<108,-6,-204> ,<0,0,0> ,FloorSlab)
		PavingSlab(<144,-6,-204> ,<0,0,0> ,FloorSlab)
		PavingSlab(<180,-6,-204> ,<0,0,0> ,FloorSlab)
		StoneBlock(<-144,0,72> ,<0,0,0> ,WallBlock,OldMortar,3)
		StoneBlock(<-120,24,72> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-72,0,72> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-48,24,72> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<0,0,72> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneSquare(<0,24,72> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<72,0,72> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<48,24,72> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<144,0,72> ,<0,0,0> ,WallBlock,OldMortar,3)
		StoneBlock(<120,24,72> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-144,48,72> ,<0,0,0> ,WallBlock,OldMortar,3)
		StoneBlock(<-120,72,72> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-72,48,72> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-48,72,72> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<0,48,72> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneSquare(<0,72,72> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<72,48,72> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<48,72,72> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<144,48,72> ,<0,0,0> ,WallBlock,OldMortar,3)
		StoneBlock(<120,72,72> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-144,96,72> ,<0,0,0> ,WallBlock,OldMortar,3)
		StoneBlock(<-120,120,72> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-72,96,72> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-48,120,72> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<0,96,72> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneSquare(<0,120,72> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<72,96,72> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<48,120,72> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<144,96,72> ,<0,0,0> ,WallBlock,OldMortar,3)
		StoneBlock(<120,120,72> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-144,144,72> ,<0,0,0> ,WallBlock,OldMortar,3)
		StoneBlock(<-120,168,72> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-72,144,72> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-48,168,72> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<0,144,72> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneSquare(<0,168,72> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<72,144,72> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<48,168,72> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<144,144,72> ,<0,0,0> ,WallBlock,OldMortar,3)
		StoneBlock(<120,168,72> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-168,24,48> ,<0,90,0> ,WallBlock,OldMortar,3)
		StoneBlock(<168,24,48> ,<0,90,0> ,WallBlock,OldMortar,3)
		StoneBlock(<-168,72,48> ,<0,90,0> ,WallBlock,OldMortar,3)
		StoneBlock(<168,72,48> ,<0,90,0> ,WallBlock,OldMortar,3)
		StoneBlock(<-168,120,48> ,<0,90,0> ,WallBlock,OldMortar,3)
		StoneBlock(<168,120,48> ,<0,90,0> ,WallBlock,OldMortar,3)
		StoneBlock(<-168,168,48> ,<0,90,0> ,WallBlock,OldMortar,3)
		StoneBlock(<168,168,48> ,<0,90,0> ,WallBlock,OldMortar,3)
		StoneBlock(<-168,0,24> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<168,0,24> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-168,48,24> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<168,48,24> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-168,96,24> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<168,96,24> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-168,144,24> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<168,144,24> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-168,24,-24> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<168,24,-24> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-168,72,-24> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<168,72,-24> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-168,120,-24> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<168,120,-24> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-168,168,-24> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<168,168,-24> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-168,0,-48> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<168,0,-48> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-168,48,-48> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<168,48,-48> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-168,96,-48> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<168,96,-48> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-168,144,-48> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<168,144,-48> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-168,24,-96> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<168,24,-96> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-168,72,-96> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<168,72,-96> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-168,120,-96> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<168,120,-96> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-168,168,-96> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<168,168,-96> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-168,0,-120> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<168,0,-120> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-168,48,-120> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<168,48,-120> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-168,96,-120> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<168,96,-120> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-168,144,-120> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<168,144,-120> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-168,24,-168> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<168,24,-168> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-168,72,-168> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<168,72,-168> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-168,120,-168> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<168,120,-168> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-168,168,-168> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<168,168,-168> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-168,0,-192> ,<0,90,0> ,WallBlock,OldMortar,3)
		StoneBlock(<168,0,-192> ,<0,90,0> ,WallBlock,OldMortar,3)
		StoneBlock(<-168,48,-192> ,<0,90,0> ,WallBlock,OldMortar,3)
		StoneBlock(<168,48,-192> ,<0,90,0> ,WallBlock,OldMortar,3)
		StoneBlock(<-168,96,-192> ,<0,90,0> ,WallBlock,OldMortar,3)
		StoneBlock(<168,96,-192> ,<0,90,0> ,WallBlock,OldMortar,3)
		StoneBlock(<-168,144,-192> ,<0,90,0> ,WallBlock,OldMortar,3)
		StoneBlock(<168,144,-192> ,<0,90,0> ,WallBlock,OldMortar,3)
		StoneBlock(<-168,24,-216> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-120,0,-216> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-96,24,-216> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneSquare(<-72,0,-216> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<96,24,-216> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneSquare(<72,0,-216> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<168,24,-216> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<120,0,-216> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-168,72,-216> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-120,48,-216> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-96,72,-216> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneSquare(<-72,48,-216> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<96,72,-216> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneSquare(<72,48,-216> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<168,72,-216> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<120,48,-216> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-168,120,-216> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-120,96,-216> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-96,120,-216> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneSquare(<-72,96,-216> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<96,120,-216> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneSquare(<72,96,-216> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<168,120,-216> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<120,96,-216> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-168,168,-216> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-120,144,-216> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-96,168,-216> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneExtra(<-60,144,-216> ,<0,0,0> ,48,WallBlock,OldMortar,0)
		StoneExtra(<0,168,-216> ,<0,0,0> ,120,WallBlock,OldMortar,2)
		StoneBlock(<96,168,-216> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneExtra(<60,144,-216> ,<0,0,0> ,48,WallBlock,OldMortar,0)
		StoneBlock(<168,168,-216> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<120,144,-216> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-60,36,-216> ,<0,0,-90> ,WallBlock,OldMortar,2)
		StoneBlock(<60,36,-216> ,<0,0,90> ,WallBlock,OldMortar,2)
		StoneBlock(<-60,108,-216> ,<0,0,-90> ,WallBlock,OldMortar,2)
		StoneBlock(<60,108,-216> ,<0,0,90> ,WallBlock,OldMortar,2)
	}

	#declare T01_MainChamber=
	union{
		PavingSlab(<-396,-6,-240> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-360,-6,-240> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-324,-6,-240> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-288,-6,-240> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-252,-6,-240> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-216,-6,-240> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-180,-6,-240> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-144,-6,-240> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-108,-6,-240> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-72,-6,-240> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-36,-6,-240> ,<0,0,0> ,FloorSlab)
		PavingSlab(<0,-6,-240> ,<0,0,0> ,FloorSlab)
		PavingSlab(<36,-6,-240> ,<0,0,0> ,FloorSlab)
		PavingSlab(<72,-6,-240> ,<0,0,0> ,FloorSlab)
		PavingSlab(<108,-6,-240> ,<0,0,0> ,FloorSlab)
		PavingSlab(<144,-6,-240> ,<0,0,0> ,FloorSlab)
		PavingSlab(<180,-6,-240> ,<0,0,0> ,FloorSlab)
		PavingSlab(<216,-6,-240> ,<0,0,0> ,FloorSlab)
		PavingSlab(<252,-6,-240> ,<0,0,0> ,FloorSlab)
		PavingSlab(<288,-6,-240> ,<0,0,0> ,FloorSlab)
		PavingSlab(<324,-6,-240> ,<0,0,0> ,FloorSlab)
		PavingSlab(<360,-6,-240> ,<0,0,0> ,FloorSlab)
		PavingSlab(<396,-6,-240> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-396,-6,-276> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-360,-6,-276> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-324,-6,-276> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-288,-6,-276> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-252,-6,-276> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-216,-6,-276> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-180,-6,-276> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-144,-6,-276> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-108,-6,-276> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-72,-6,-276> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-36,-6,-276> ,<0,0,0> ,FloorSlab)
		PavingSlab(<0,-6,-276> ,<0,0,0> ,FloorSlab)
		PavingSlab(<36,-6,-276> ,<0,0,0> ,FloorSlab)
		PavingSlab(<72,-6,-276> ,<0,0,0> ,FloorSlab)
		PavingSlab(<108,-6,-276> ,<0,0,0> ,FloorSlab)
		PavingSlab(<144,-6,-276> ,<0,0,0> ,FloorSlab)
		PavingSlab(<180,-6,-276> ,<0,0,0> ,FloorSlab)
		PavingSlab(<216,-6,-276> ,<0,0,0> ,FloorSlab)
		PavingSlab(<252,-6,-276> ,<0,0,0> ,FloorSlab)
		PavingSlab(<288,-6,-276> ,<0,0,0> ,FloorSlab)
		PavingSlab(<324,-6,-276> ,<0,0,0> ,FloorSlab)
		PavingSlab(<360,-6,-276> ,<0,0,0> ,FloorSlab)
		PavingSlab(<396,-6,-276> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-396,-6,-312> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-360,-6,-312> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-324,-6,-312> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-288,-6,-312> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-252,-6,-312> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-216,-6,-312> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-180,-6,-312> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-144,-6,-312> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-108,-6,-312> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-72,-6,-312> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-36,-6,-312> ,<0,0,0> ,FloorSlab)
		PavingSlab(<0,-6,-312> ,<0,0,0> ,FloorSlab)
		PavingSlab(<36,-6,-312> ,<0,0,0> ,FloorSlab)
		PavingSlab(<72,-6,-312> ,<0,0,0> ,FloorSlab)
		PavingSlab(<108,-6,-312> ,<0,0,0> ,FloorSlab)
		PavingSlab(<144,-6,-312> ,<0,0,0> ,FloorSlab)
		PavingSlab(<180,-6,-312> ,<0,0,0> ,FloorSlab)
		PavingSlab(<216,-6,-312> ,<0,0,0> ,FloorSlab)
		PavingSlab(<252,-6,-312> ,<0,0,0> ,FloorSlab)
		PavingSlab(<288,-6,-312> ,<0,0,0> ,FloorSlab)
		PavingSlab(<324,-6,-312> ,<0,0,0> ,FloorSlab)
		PavingSlab(<360,-6,-312> ,<0,0,0> ,FloorSlab)
		PavingSlab(<396,-6,-312> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-396,-6,-348> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-360,-6,-348> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-324,-6,-348> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-288,-6,-348> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-252,-6,-348> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-216,-6,-348> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-180,-6,-348> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-144,-6,-348> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-108,-6,-348> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-72,-6,-348> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-36,-6,-348> ,<0,0,0> ,FloorSlab)
		PavingSlab(<0,-6,-348> ,<0,0,0> ,FloorSlab)
		PavingSlab(<36,-6,-348> ,<0,0,0> ,FloorSlab)
		PavingSlab(<72,-6,-348> ,<0,0,0> ,FloorSlab)
		PavingSlab(<108,-6,-348> ,<0,0,0> ,FloorSlab)
		PavingSlab(<144,-6,-348> ,<0,0,0> ,FloorSlab)
		PavingSlab(<180,-6,-348> ,<0,0,0> ,FloorSlab)
		PavingSlab(<216,-6,-348> ,<0,0,0> ,FloorSlab)
		PavingSlab(<252,-6,-348> ,<0,0,0> ,FloorSlab)
		PavingSlab(<288,-6,-348> ,<0,0,0> ,FloorSlab)
		PavingSlab(<324,-6,-348> ,<0,0,0> ,FloorSlab)
		PavingSlab(<360,-6,-348> ,<0,0,0> ,FloorSlab)
		PavingSlab(<396,-6,-348> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-396,-6,-384> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-360,-6,-384> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-324,-6,-384> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-288,-6,-384> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-252,-6,-384> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-216,-6,-384> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-180,-6,-384> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-144,-6,-384> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-108,-6,-384> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-72,-6,-384> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-36,-6,-384> ,<0,0,0> ,FloorSlab)
		PavingSlab(<0,-6,-384> ,<0,0,0> ,FloorSlab)
		PavingSlab(<36,-6,-384> ,<0,0,0> ,FloorSlab)
		PavingSlab(<72,-6,-384> ,<0,0,0> ,FloorSlab)
		PavingSlab(<108,-6,-384> ,<0,0,0> ,FloorSlab)
		PavingSlab(<144,-6,-384> ,<0,0,0> ,FloorSlab)
		PavingSlab(<180,-6,-384> ,<0,0,0> ,FloorSlab)
		PavingSlab(<216,-6,-384> ,<0,0,0> ,FloorSlab)
		PavingSlab(<252,-6,-384> ,<0,0,0> ,FloorSlab)
		PavingSlab(<288,-6,-384> ,<0,0,0> ,FloorSlab)
		PavingSlab(<324,-6,-384> ,<0,0,0> ,FloorSlab)
		PavingSlab(<360,-6,-384> ,<0,0,0> ,FloorSlab)
		PavingSlab(<396,-6,-384> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-396,-6,-420> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-360,-6,-420> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-324,-6,-420> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-288,-6,-420> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-252,-6,-420> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-216,-6,-420> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-180,-6,-420> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-144,-6,-420> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-108,-6,-420> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-72,-6,-420> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-36,-6,-420> ,<0,0,0> ,FloorSlab)
		PavingSlab(<0,-6,-420> ,<0,0,0> ,FloorSlab)
		PavingSlab(<36,-6,-420> ,<0,0,0> ,FloorSlab)
		PavingSlab(<72,-6,-420> ,<0,0,0> ,FloorSlab)
		PavingSlab(<108,-6,-420> ,<0,0,0> ,FloorSlab)
		PavingSlab(<144,-6,-420> ,<0,0,0> ,FloorSlab)
		PavingSlab(<180,-6,-420> ,<0,0,0> ,FloorSlab)
		PavingSlab(<216,-6,-420> ,<0,0,0> ,FloorSlab)
		PavingSlab(<252,-6,-420> ,<0,0,0> ,FloorSlab)
		PavingSlab(<288,-6,-420> ,<0,0,0> ,FloorSlab)
		PavingSlab(<324,-6,-420> ,<0,0,0> ,FloorSlab)
		PavingSlab(<360,-6,-420> ,<0,0,0> ,FloorSlab)
		PavingSlab(<396,-6,-420> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-396,-6,-456> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-360,-6,-456> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-324,-6,-456> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-288,-6,-456> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-252,-6,-456> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-216,-6,-456> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-180,-6,-456> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-144,-6,-456> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-108,-6,-456> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-72,-6,-456> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-36,-6,-456> ,<0,0,0> ,FloorSlab)
		PavingSlab(<0,-6,-456> ,<0,0,0> ,FloorSlab)
		PavingSlab(<36,-6,-456> ,<0,0,0> ,FloorSlab)
		PavingSlab(<72,-6,-456> ,<0,0,0> ,FloorSlab)
		PavingSlab(<108,-6,-456> ,<0,0,0> ,FloorSlab)
		PavingSlab(<144,-6,-456> ,<0,0,0> ,FloorSlab)
		PavingSlab(<180,-6,-456> ,<0,0,0> ,FloorSlab)
		PavingSlab(<216,-6,-456> ,<0,0,0> ,FloorSlab)
		PavingSlab(<252,-6,-456> ,<0,0,0> ,FloorSlab)
		PavingSlab(<288,-6,-456> ,<0,0,0> ,FloorSlab)
		PavingSlab(<324,-6,-456> ,<0,0,0> ,FloorSlab)
		PavingSlab(<360,-6,-456> ,<0,0,0> ,FloorSlab)
		PavingSlab(<396,-6,-456> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-396,-6,-492> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-360,-6,-492> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-324,-6,-492> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-288,-6,-492> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-252,-6,-492> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-216,-6,-492> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-180,-6,-492> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-144,-6,-492> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-108,-6,-492> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-72,-6,-492> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-36,-6,-492> ,<0,0,0> ,FloorSlab)
		PavingSlab(<0,-6,-492> ,<0,0,0> ,FloorSlab)
		PavingSlab(<36,-6,-492> ,<0,0,0> ,FloorSlab)
		PavingSlab(<72,-6,-492> ,<0,0,0> ,FloorSlab)
		PavingSlab(<108,-6,-492> ,<0,0,0> ,FloorSlab)
		PavingSlab(<144,-6,-492> ,<0,0,0> ,FloorSlab)
		PavingSlab(<180,-6,-492> ,<0,0,0> ,FloorSlab)
		PavingSlab(<216,-6,-492> ,<0,0,0> ,FloorSlab)
		PavingSlab(<252,-6,-492> ,<0,0,0> ,FloorSlab)
		PavingSlab(<288,-6,-492> ,<0,0,0> ,FloorSlab)
		PavingSlab(<324,-6,-492> ,<0,0,0> ,FloorSlab)
		PavingSlab(<360,-6,-492> ,<0,0,0> ,FloorSlab)
		PavingSlab(<396,-6,-492> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-396,-6,-528> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-360,-6,-528> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-324,-6,-528> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-288,-6,-528> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-252,-6,-528> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-216,-6,-528> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-180,-6,-528> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-144,-6,-528> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-108,-6,-528> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-72,-6,-528> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-36,-6,-528> ,<0,0,0> ,FloorSlab)
		PavingSlab(<0,-6,-528> ,<0,0,0> ,FloorSlab)
		PavingSlab(<36,-6,-528> ,<0,0,0> ,FloorSlab)
		PavingSlab(<72,-6,-528> ,<0,0,0> ,FloorSlab)
		PavingSlab(<108,-6,-528> ,<0,0,0> ,FloorSlab)
		PavingSlab(<144,-6,-528> ,<0,0,0> ,FloorSlab)
		PavingSlab(<180,-6,-528> ,<0,0,0> ,FloorSlab)
		PavingSlab(<216,-6,-528> ,<0,0,0> ,FloorSlab)
		PavingSlab(<252,-6,-528> ,<0,0,0> ,FloorSlab)
		PavingSlab(<288,-6,-528> ,<0,0,0> ,FloorSlab)
		PavingSlab(<324,-6,-528> ,<0,0,0> ,FloorSlab)
		PavingSlab(<360,-6,-528> ,<0,0,0> ,FloorSlab)
		PavingSlab(<396,-6,-528> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-396,-6,-564> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-360,-6,-564> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-324,-6,-564> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-288,-6,-564> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-252,-6,-564> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-216,-6,-564> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-180,-6,-564> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-144,-6,-564> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-108,-6,-564> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-72,-6,-564> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-36,-6,-564> ,<0,0,0> ,FloorSlab)
		PavingSlab(<0,-6,-564> ,<0,0,0> ,FloorSlab)
		PavingSlab(<36,-6,-564> ,<0,0,0> ,FloorSlab)
		PavingSlab(<72,-6,-564> ,<0,0,0> ,FloorSlab)
		PavingSlab(<108,-6,-564> ,<0,0,0> ,FloorSlab)
		PavingSlab(<144,-6,-564> ,<0,0,0> ,FloorSlab)
		PavingSlab(<180,-6,-564> ,<0,0,0> ,FloorSlab)
		PavingSlab(<216,-6,-564> ,<0,0,0> ,FloorSlab)
		PavingSlab(<252,-6,-564> ,<0,0,0> ,FloorSlab)
		PavingSlab(<288,-6,-564> ,<0,0,0> ,FloorSlab)
		PavingSlab(<324,-6,-564> ,<0,0,0> ,FloorSlab)
		PavingSlab(<360,-6,-564> ,<0,0,0> ,FloorSlab)
		PavingSlab(<396,-6,-564> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-396,-6,-600> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-360,-6,-600> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-324,-6,-600> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-288,-6,-600> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-252,-6,-600> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-216,-6,-600> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-180,-6,-600> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-144,-6,-600> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-108,-6,-600> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-72,-6,-600> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-36,-6,-600> ,<0,0,0> ,FloorSlab)
		PavingSlab(<0,-6,-600> ,<0,0,0> ,FloorSlab)
		PavingSlab(<36,-6,-600> ,<0,0,0> ,FloorSlab)
		PavingSlab(<72,-6,-600> ,<0,0,0> ,FloorSlab)
		PavingSlab(<108,-6,-600> ,<0,0,0> ,FloorSlab)
		PavingSlab(<144,-6,-600> ,<0,0,0> ,FloorSlab)
		PavingSlab(<180,-6,-600> ,<0,0,0> ,FloorSlab)
		PavingSlab(<216,-6,-600> ,<0,0,0> ,FloorSlab)
		PavingSlab(<252,-6,-600> ,<0,0,0> ,FloorSlab)
		PavingSlab(<288,-6,-600> ,<0,0,0> ,FloorSlab)
		PavingSlab(<324,-6,-600> ,<0,0,0> ,FloorSlab)
		PavingSlab(<360,-6,-600> ,<0,0,0> ,FloorSlab)
		PavingSlab(<396,-6,-600> ,<0,0,0> ,FloorSlab)
		StoneBlock(<216,0,-216> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<240,24,-216> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-216,0,-216> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-240,24,-216> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<288,0,-216> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<312,24,-216> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-288,0,-216> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-312,24,-216> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<360,0,-216> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-360,0,-216> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<216,48,-216> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<240,72,-216> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-216,48,-216> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-240,72,-216> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<288,48,-216> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<312,72,-216> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-288,48,-216> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-312,72,-216> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<360,48,-216> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-360,48,-216> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<216,96,-216> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<240,120,-216> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-216,96,-216> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-240,120,-216> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<288,96,-216> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<312,120,-216> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-288,96,-216> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-312,120,-216> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<360,96,-216> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-360,96,-216> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<216,144,-216> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<240,168,-216> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-216,144,-216> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-240,168,-216> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<288,144,-216> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<312,168,-216> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-288,144,-216> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-312,168,-216> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<360,144,-216> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-360,144,-216> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<384,24,-216> ,<0,0,0> ,WallBlock,OldMortar,3)
		StoneBlock(<-384,24,-216> ,<0,0,0> ,WallBlock,OldMortar,3)
		StoneBlock(<384,72,-216> ,<0,0,0> ,WallBlock,OldMortar,3)
		StoneBlock(<-384,72,-216> ,<0,0,0> ,WallBlock,OldMortar,3)
		StoneBlock(<384,120,-216> ,<0,0,0> ,WallBlock,OldMortar,3)
		StoneBlock(<-384,120,-216> ,<0,0,0> ,WallBlock,OldMortar,3)
		StoneBlock(<384,168,-216> ,<0,0,0> ,WallBlock,OldMortar,3)
		StoneBlock(<-384,168,-216> ,<0,0,0> ,WallBlock,OldMortar,3)
		StoneBlock(<-408,0,-240> ,<0,90,0> ,WallBlock,OldMortar,3)
		StoneBlock(<408,0,-240> ,<0,90,0> ,WallBlock,OldMortar,3)
		StoneBlock(<-408,48,-240> ,<0,90,0> ,WallBlock,OldMortar,3)
		StoneBlock(<408,48,-240> ,<0,90,0> ,WallBlock,OldMortar,3)
		StoneBlock(<-408,96,-240> ,<0,90,0> ,WallBlock,OldMortar,3)
		StoneBlock(<408,96,-240> ,<0,90,0> ,WallBlock,OldMortar,3)
		StoneBlock(<-408,144,-240> ,<0,90,0> ,WallBlock,OldMortar,3)
		StoneBlock(<408,144,-240> ,<0,90,0> ,WallBlock,OldMortar,3)
		StoneBlock(<-408,24,-264> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<408,24,-264> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-408,72,-264> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<408,72,-264> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-408,120,-264> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<408,120,-264> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-408,168,-264> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<408,168,-264> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-408,0,-312> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<408,0,-312> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-408,48,-312> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<408,48,-312> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-408,96,-312> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<408,96,-312> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-408,144,-312> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<408,144,-312> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-408,24,-336> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<408,24,-336> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-408,72,-336> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<408,72,-336> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-408,120,-336> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<408,120,-336> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-408,168,-336> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<408,168,-336> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-408,0,-384> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<408,0,-384> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-408,48,-384> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<408,48,-384> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-408,96,-384> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<408,96,-384> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-408,144,-384> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<408,144,-384> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-408,24,-408> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<408,24,-408> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-408,72,-408> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<408,72,-408> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-408,120,-408> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<408,120,-408> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-408,168,-408> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<408,168,-408> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-408,0,-456> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<408,0,-456> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-408,48,-456> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<408,48,-456> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-408,96,-456> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<408,96,-456> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-408,144,-456> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<408,144,-456> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-408,24,-480> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<408,24,-480> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-408,72,-480> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<408,72,-480> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-408,120,-480> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<408,120,-480> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-408,168,-480> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<408,168,-480> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-408,0,-528> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<408,0,-528> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-408,48,-528> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<408,48,-528> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-408,96,-528> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<408,96,-528> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-408,144,-528> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<408,144,-528> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-408,24,-552> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<408,24,-552> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-408,72,-552> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<408,72,-552> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-408,120,-552> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<408,120,-552> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-408,168,-552> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<408,168,-552> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-408,0,-600> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<408,0,-600> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-408,48,-600> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<408,48,-600> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-408,96,-600> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<408,96,-600> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-408,144,-600> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<408,144,-600> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-384,24,-600> ,<0,0,0> ,WallBlock,OldMortar,3)
		StoneBlock(<384,24,-600> ,<0,0,0> ,WallBlock,OldMortar,3)
		StoneBlock(<-384,72,-600> ,<0,0,0> ,WallBlock,OldMortar,3)
		StoneBlock(<384,72,-600> ,<0,0,0> ,WallBlock,OldMortar,3)
		StoneBlock(<-384,120,-600> ,<0,0,0> ,WallBlock,OldMortar,3)
		StoneBlock(<384,120,-600> ,<0,0,0> ,WallBlock,OldMortar,3)
		StoneBlock(<-384,168,-600> ,<0,0,0> ,WallBlock,OldMortar,3)
		StoneBlock(<384,168,-600> ,<0,0,0> ,WallBlock,OldMortar,3)
		StoneBlock(<-360,0,-600> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-312,24,-600> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneExtra(<-300,0,-600> ,<0,0,0> ,48,WallBlock,OldMortar,2)
		StoneExtra(<-204,0,-600> ,<0,0,0> ,48,WallBlock,OldMortar,2)
		StoneSquare(<-216,24,-600> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-144,0,-600> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-168,24,-600> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneSquare(<-72,0,-600> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-96,24,-600> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneSquare(<72,0,-600> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<96,24,-600> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<144,0,-600> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<168,24,-600> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneExtra(<204,0,-600> ,<0,0,0> ,48,WallBlock,OldMortar,2)
		StoneSquare(<216,24,-600> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<312,24,-600> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneExtra(<300,0,-600> ,<0,0,0> ,48,WallBlock,OldMortar,2)
		StoneBlock(<360,0,-600> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-360,48,-600> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-312,72,-600> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneExtra(<-300,48,-600> ,<0,0,0> ,48,WallBlock,OldMortar,2)
		StoneExtra(<-204,48,-600> ,<0,0,0> ,48,WallBlock,OldMortar,2)
		StoneSquare(<-216,72,-600> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-144,48,-600> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-168,72,-600> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneSquare(<-72,48,-600> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-96,72,-600> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneSquare(<72,48,-600> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<96,72,-600> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<144,48,-600> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<168,72,-600> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneExtra(<204,48,-600> ,<0,0,0> ,48,WallBlock,OldMortar,2)
		StoneSquare(<216,72,-600> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<312,72,-600> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneExtra(<300,48,-600> ,<0,0,0> ,48,WallBlock,OldMortar,2)
		StoneBlock(<360,48,-600> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-360,96,-600> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneExtra(<-324,120,-600> ,<0,0,0> ,48,WallBlock,OldMortar,2)
		StoneExtra(<-300,96,-600> ,<0,0,0> ,48,WallBlock,OldMortar,2)
		StoneExtra(<-204,96,-600> ,<0,0,0> ,48,WallBlock,OldMortar,2)
		StoneArch(<-252,120,-600> ,<0,0,0> ,<96,24,24> ,<48,12,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-144,96,-600> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-168,120,-600> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneSquare(<-72,96,-600> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-96,120,-600> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneSquare(<72,96,-600> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<96,120,-600> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<144,96,-600> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<168,120,-600> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneExtra(<204,96,-600> ,<0,0,0> ,48,WallBlock,OldMortar,2)
		StoneArch(<252,120,-600> ,<0,0,0> ,<96,24,24> ,<48,12,0> ,WallBlock,OldMortar,2)
		StoneExtra(<324,120,-600> ,<0,0,0> ,48,WallBlock,OldMortar,2)
		StoneExtra(<300,96,-600> ,<0,0,0> ,48,WallBlock,OldMortar,2)
		StoneBlock(<360,96,-600> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-360,144,-600> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-312,168,-600> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-240,168,-600> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneExtra(<-252,144,-600> ,<0,0,0> ,144,WallBlock,OldMortar,2)
		StoneBlock(<-144,144,-600> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-168,168,-600> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-72,144,-600> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-96,168,-600> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneArch(<0,72,-600> ,<0,0,0> ,<120,72,24> ,<72,36,0> ,WallBlock,OldMortar,2)
		StoneBlock(<0,144,-600> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneExtra(<0,168,-600> ,<0,0,0> ,120,WallBlock,OldMortar,2)
		StoneBlock(<72,144,-600> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<96,168,-600> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<144,144,-600> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<168,168,-600> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneExtra(<252,144,-600> ,<0,0,0> ,144,WallBlock,OldMortar,2)
		StoneBlock(<240,168,-600> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<312,168,-600> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<360,144,-600> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-60,36,-600> ,<0,0,-90> ,WallBlock,OldMortar,2)
		StoneBlock(<60,36,-600> ,<0,0,90> ,WallBlock,OldMortar,2)
		StoneBlock(<-96,0,-624> ,<0,90,0> ,WallBlock,OldMortar,3)
		StoneBlock(<96,0,-624> ,<0,90,0> ,WallBlock,OldMortar,3)
		StoneBlock(<-96,48,-624> ,<0,90,0> ,WallBlock,OldMortar,3)
		StoneBlock(<96,48,-624> ,<0,90,0> ,WallBlock,OldMortar,3)
		StoneBlock(<-96,96,-624> ,<0,90,0> ,WallBlock,OldMortar,3)
		StoneBlock(<96,96,-624> ,<0,90,0> ,WallBlock,OldMortar,3)
	}

	#declare T01_EntranceWay=
	union{
		PavingSlab(<-396,-6,-636> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-360,-6,-636> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-324,-6,-636> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-288,-6,-636> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-252,-6,-636> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-216,-6,-636> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-180,-6,-636> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-144,-6,-636> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-108,-6,-636> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-72,-6,-636> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-36,-6,-636> ,<0,0,0> ,FloorSlab)
		PavingSlab(<0,-6,-636> ,<0,0,0> ,FloorSlab)
		PavingSlab(<36,-6,-636> ,<0,0,0> ,FloorSlab)
		PavingSlab(<72,-6,-636> ,<0,0,0> ,FloorSlab)
		PavingSlab(<108,-6,-636> ,<0,0,0> ,FloorSlab)
		PavingSlab(<144,-6,-636> ,<0,0,0> ,FloorSlab)
		PavingSlab(<180,-6,-636> ,<0,0,0> ,FloorSlab)
		PavingSlab(<216,-6,-636> ,<0,0,0> ,FloorSlab)
		PavingSlab(<252,-6,-636> ,<0,0,0> ,FloorSlab)
		PavingSlab(<288,-6,-636> ,<0,0,0> ,FloorSlab)
		PavingSlab(<324,-6,-636> ,<0,0,0> ,FloorSlab)
		PavingSlab(<360,-6,-636> ,<0,0,0> ,FloorSlab)
		PavingSlab(<396,-6,-636> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-396,-6,-672> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-360,-6,-672> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-324,-6,-672> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-288,-6,-672> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-252,-6,-672> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-216,-6,-672> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-180,-6,-672> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-144,-6,-672> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-108,-6,-672> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-72,-6,-672> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-36,-6,-672> ,<0,0,0> ,FloorSlab)
		PavingSlab(<0,-6,-672> ,<0,0,0> ,FloorSlab)
		PavingSlab(<36,-6,-672> ,<0,0,0> ,FloorSlab)
		PavingSlab(<72,-6,-672> ,<0,0,0> ,FloorSlab)
		PavingSlab(<108,-6,-672> ,<0,0,0> ,FloorSlab)
		PavingSlab(<144,-6,-672> ,<0,0,0> ,FloorSlab)
		PavingSlab(<180,-6,-672> ,<0,0,0> ,FloorSlab)
		PavingSlab(<216,-6,-672> ,<0,0,0> ,FloorSlab)
		PavingSlab(<252,-6,-672> ,<0,0,0> ,FloorSlab)
		PavingSlab(<288,-6,-672> ,<0,0,0> ,FloorSlab)
		PavingSlab(<324,-6,-672> ,<0,0,0> ,FloorSlab)
		PavingSlab(<360,-6,-672> ,<0,0,0> ,FloorSlab)
		PavingSlab(<396,-6,-672> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-396,-6,-708> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-360,-6,-708> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-324,-6,-708> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-288,-6,-708> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-252,-6,-708> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-216,-6,-708> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-180,-6,-708> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-144,-6,-708> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-108,-6,-708> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-72,-6,-708> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-36,-6,-708> ,<0,0,0> ,FloorSlab)
		PavingSlab(<0,-6,-708> ,<0,0,0> ,FloorSlab)
		PavingSlab(<36,-6,-708> ,<0,0,0> ,FloorSlab)
		PavingSlab(<72,-6,-708> ,<0,0,0> ,FloorSlab)
		PavingSlab(<108,-6,-708> ,<0,0,0> ,FloorSlab)
		PavingSlab(<144,-6,-708> ,<0,0,0> ,FloorSlab)
		PavingSlab(<180,-6,-708> ,<0,0,0> ,FloorSlab)
		PavingSlab(<216,-6,-708> ,<0,0,0> ,FloorSlab)
		PavingSlab(<252,-6,-708> ,<0,0,0> ,FloorSlab)
		PavingSlab(<288,-6,-708> ,<0,0,0> ,FloorSlab)
		PavingSlab(<324,-6,-708> ,<0,0,0> ,FloorSlab)
		PavingSlab(<360,-6,-708> ,<0,0,0> ,FloorSlab)
		PavingSlab(<396,-6,-708> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-396,-6,-744> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-360,-6,-744> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-324,-6,-744> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-288,-6,-744> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-252,-6,-744> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-216,-6,-744> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-180,-6,-744> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-144,-6,-744> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-108,-6,-744> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-72,-6,-744> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-36,-6,-744> ,<0,0,0> ,FloorSlab)
		PavingSlab(<0,-6,-744> ,<0,0,0> ,FloorSlab)
		PavingSlab(<36,-6,-744> ,<0,0,0> ,FloorSlab)
		PavingSlab(<72,-6,-744> ,<0,0,0> ,FloorSlab)
		PavingSlab(<108,-6,-744> ,<0,0,0> ,FloorSlab)
		PavingSlab(<144,-6,-744> ,<0,0,0> ,FloorSlab)
		PavingSlab(<180,-6,-744> ,<0,0,0> ,FloorSlab)
		PavingSlab(<216,-6,-744> ,<0,0,0> ,FloorSlab)
		PavingSlab(<252,-6,-744> ,<0,0,0> ,FloorSlab)
		PavingSlab(<288,-6,-744> ,<0,0,0> ,FloorSlab)
		PavingSlab(<324,-6,-744> ,<0,0,0> ,FloorSlab)
		PavingSlab(<360,-6,-744> ,<0,0,0> ,FloorSlab)
		PavingSlab(<396,-6,-744> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-396,-6,-780> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-360,-6,-780> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-324,-6,-780> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-288,-6,-780> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-252,-6,-780> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-216,-6,-780> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-180,-6,-780> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-144,-6,-780> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-108,-6,-780> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-72,-6,-780> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-36,-6,-780> ,<0,0,0> ,FloorSlab)
		PavingSlab(<0,-6,-780> ,<0,0,0> ,FloorSlab)
		PavingSlab(<36,-6,-780> ,<0,0,0> ,FloorSlab)
		PavingSlab(<72,-6,-780> ,<0,0,0> ,FloorSlab)
		PavingSlab(<108,-6,-780> ,<0,0,0> ,FloorSlab)
		PavingSlab(<144,-6,-780> ,<0,0,0> ,FloorSlab)
		PavingSlab(<180,-6,-780> ,<0,0,0> ,FloorSlab)
		PavingSlab(<216,-6,-780> ,<0,0,0> ,FloorSlab)
		PavingSlab(<252,-6,-780> ,<0,0,0> ,FloorSlab)
		PavingSlab(<288,-6,-780> ,<0,0,0> ,FloorSlab)
		PavingSlab(<324,-6,-780> ,<0,0,0> ,FloorSlab)
		PavingSlab(<360,-6,-780> ,<0,0,0> ,FloorSlab)
		PavingSlab(<396,-6,-780> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-396,-6,-816> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-360,-6,-816> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-324,-6,-816> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-288,-6,-816> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-252,-6,-816> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-216,-6,-816> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-180,-6,-816> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-144,-6,-816> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-108,-6,-816> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-72,-6,-816> ,<0,0,0> ,FloorSlab)
		PavingSlab(<-36,-6,-816> ,<0,0,0> ,FloorSlab)
		PavingSlab(<0,-6,-816> ,<0,0,0> ,FloorSlab)
		PavingSlab(<36,-6,-816> ,<0,0,0> ,FloorSlab)
		PavingSlab(<72,-6,-816> ,<0,0,0> ,FloorSlab)
		PavingSlab(<108,-6,-816> ,<0,0,0> ,FloorSlab)
		PavingSlab(<144,-6,-816> ,<0,0,0> ,FloorSlab)
		PavingSlab(<180,-6,-816> ,<0,0,0> ,FloorSlab)
		PavingSlab(<216,-6,-816> ,<0,0,0> ,FloorSlab)
		PavingSlab(<252,-6,-816> ,<0,0,0> ,FloorSlab)
		PavingSlab(<288,-6,-816> ,<0,0,0> ,FloorSlab)
		PavingSlab(<324,-6,-816> ,<0,0,0> ,FloorSlab)
		PavingSlab(<360,-6,-816> ,<0,0,0> ,FloorSlab)
		PavingSlab(<396,-6,-816> ,<0,0,0> ,FloorSlab)
		StoneBlock(<-408,0,-672> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-96,0,-696> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<96,0,-696> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<408,0,-672> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-408,24,-648> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-96,24,-648> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<96,24,-648> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<408,24,-648> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-408,48,-672> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-96,48,-696> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<96,48,-696> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<408,48,-672> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-408,72,-648> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-96,72,-648> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<96,72,-648> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<408,72,-648> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-408,96,-672> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-96,96,-696> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<96,96,-696> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<408,96,-672> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-408,120,-648> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-96,120,-648> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<96,120,-648> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<408,120,-648> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-408,144,-672> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-96,144,-696> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<96,144,-696> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<408,144,-672> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-408,168,-648> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-96,168,-648> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<96,168,-648> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<408,168,-648> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-408,24,-720> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-96,24,-720> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<96,24,-720> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<408,24,-720> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-408,72,-720> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-96,72,-720> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<96,72,-720> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<408,72,-720> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-408,120,-720> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-96,120,-720> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<96,120,-720> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<408,120,-720> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-408,168,-720> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-96,168,-720> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<96,168,-720> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<408,168,-720> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-408,0,-744> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<408,0,-744> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-408,48,-744> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<408,48,-744> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-408,96,-744> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<408,96,-744> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-408,144,-744> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<408,144,-744> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-96,0,-768> ,<0,90,0> ,WallBlock,OldMortar,3)
		StoneBlock(<96,0,-768> ,<0,90,0> ,WallBlock,OldMortar,3)
		StoneSquare(<-96,24,-768> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneSquare(<96,24,-768> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-96,48,-768> ,<0,90,0> ,WallBlock,OldMortar,3)
		StoneBlock(<96,48,-768> ,<0,90,0> ,WallBlock,OldMortar,3)
		StoneSquare(<-96,72,-768> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneSquare(<96,72,-768> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-96,96,-768> ,<0,90,0> ,WallBlock,OldMortar,3)
		StoneBlock(<96,96,-768> ,<0,90,0> ,WallBlock,OldMortar,3)
		StoneSquare(<-96,120,-768> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneSquare(<96,120,-768> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-96,144,-768> ,<0,90,0> ,WallBlock,OldMortar,3)
		StoneBlock(<96,144,-768> ,<0,90,0> ,WallBlock,OldMortar,3)
		StoneSquare(<-96,168,-768> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneSquare(<96,168,-768> ,<0,90,0> ,WallBlock,OldMortar,2)
		StoneExtra(<-408,24,-780> ,<0,90,0> ,48,WallBlock,OldMortar,3)
		StoneExtra(<408,24,-780> ,<0,90,0> ,48,WallBlock,OldMortar,3)
		StoneExtra(<-408,72,-780> ,<0,90,0> ,48,WallBlock,OldMortar,3)
		StoneExtra(<408,72,-780> ,<0,90,0> ,48,WallBlock,OldMortar,3)
		StoneExtra(<-408,120,-780> ,<0,90,0> ,48,WallBlock,OldMortar,3)
		StoneExtra(<408,120,-780> ,<0,90,0> ,48,WallBlock,OldMortar,3)
		StoneExtra(<-408,168,-780> ,<0,90,0> ,48,WallBlock,OldMortar,3)
		StoneExtra(<408,168,-780> ,<0,90,0> ,48,WallBlock,OldMortar,3)
		StoneBlock(<-384,0,-792> ,<0,0,0> ,WallBlock,OldMortar,3)
		StoneBlock(<384,0,-792> ,<0,0,0> ,WallBlock,OldMortar,3)
		StoneBlock(<-384,48,-792> ,<0,0,0> ,WallBlock,OldMortar,3)
		StoneBlock(<384,48,-792> ,<0,0,0> ,WallBlock,OldMortar,3)
		StoneBlock(<-384,96,-792> ,<0,0,0> ,WallBlock,OldMortar,3)
		StoneBlock(<384,96,-792> ,<0,0,0> ,WallBlock,OldMortar,3)
		StoneBlock(<-384,144,-792> ,<0,0,0> ,WallBlock,OldMortar,3)
		StoneBlock(<384,144,-792> ,<0,0,0> ,WallBlock,OldMortar,3)
		StoneBlock(<-336,24,-792> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-312,0,-792> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-264,24,-792> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-240,0,-792> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-192,24,-792> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-168,0,-792> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-120,24,-792> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneSquare(<-120,0,-792> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneSquare(<120,0,-792> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<168,0,-792> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<120,24,-792> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<240,0,-792> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<192,24,-792> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<312,0,-792> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<264,24,-792> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<336,24,-792> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneSquare(<-384,24,-792> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneSquare(<384,24,-792> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-336,72,-792> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-312,48,-792> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-264,72,-792> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-240,48,-792> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-192,72,-792> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-168,48,-792> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-120,72,-792> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneSquare(<-120,48,-792> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneSquare(<120,48,-792> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<168,48,-792> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<120,72,-792> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<240,48,-792> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<192,72,-792> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<312,48,-792> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<264,72,-792> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<336,72,-792> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneSquare(<-384,72,-792> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneSquare(<384,72,-792> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-336,120,-792> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-312,96,-792> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-264,120,-792> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-240,96,-792> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-192,120,-792> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-168,96,-792> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-120,120,-792> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneSquare(<-120,96,-792> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneSquare(<120,96,-792> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<168,96,-792> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<120,120,-792> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<240,96,-792> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<192,120,-792> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<312,96,-792> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<264,120,-792> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<336,120,-792> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneSquare(<-384,120,-792> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneSquare(<384,120,-792> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-336,168,-792> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-312,144,-792> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-264,168,-792> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-240,144,-792> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-192,168,-792> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-168,144,-792> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<-120,168,-792> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneSquare(<-120,144,-792> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneSquare(<120,144,-792> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<168,144,-792> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<120,168,-792> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<240,144,-792> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<192,168,-792> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<312,144,-792> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<264,168,-792> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneBlock(<336,168,-792> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneSquare(<-384,168,-792> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneSquare(<384,168,-792> ,<0,0,0> ,WallBlock,OldMortar,2)
		StoneExtra(<-84,48,-792> ,<0,0,-90> ,96,WallBlock,OldMortar,2)
		StoneExtra(<84,48,-792> ,<0,0,90> ,96,WallBlock,OldMortar,2)
		StoneArch(<0,96,-792> ,<0,0,0> ,<168,96,24> ,<120,48,0> ,WallBlock,OldMortar,2)
	}
#end

	// Define this regardless of version - for now
	#declare T01_Roof=
	difference{
		union{                               
			// the idol room
			box{<-186,192,-204>*in,<186,240,84>*in}
			// the main chamber
			box{<-420,192,-204>*in,<420,260,-612>*in}
			// the entranceway and side chambers
			box{<-420,192,-804>*in,<420,240,-612>*in}
		}
		// the idol room
		//cylinder{<-162,192,  60>*in,<-162,224,  60>*in,3*in texture{RedPt}}
		//cylinder{< 162,192,  60>*in,< 162,224,  60>*in,3*in texture{RedPt}}
		//cylinder{<-162,192,-204>*in,<-162,224,-204>*in,3*in texture{RedPt}}
		//cylinder{< 162,192,-204>*in,< 162,224,-204>*in,3*in texture{RedPt}}
		cylinder{<   0,  0,  60>*in,<   0,  0,-204>*in,1*in scale <162,40,1> translate <0,192,0>*in}
		cylinder{<-162,  0,   0>*in,< 162,  0,   0>*in,1*in scale <1,40,132> translate <0,192,-72>*in}
		// the main chamber
		//cylinder{<-396,192,-228>*in,<-396,224,-228>*in,3*in texture{RedPt}}
		//cylinder{< 396,192,-228>*in,< 396,224,-228>*in,3*in texture{RedPt}}
		//cylinder{<-396,192,-588>*in,<-396,224,-588>*in,3*in texture{RedPt}}
		//cylinder{< 396,192,-588>*in,< 396,224,-588>*in,3*in texture{RedPt}}
		//cylinder{<-396,  0,-408>*in,< 396,  0,-408>*in,3*in translate <0,192,0>*in texture{RedPt}}
		cylinder{<-396,  0,   0>*in,< 396,  0,   0>*in,1*in scale <1,60,180> translate <0,192,-408>*in}
		//cylinder{<   0,  0,-228>*in,<   0,  0,-588>*in,3*in translate <0,192,0>*in texture{RedPt}}
		cylinder{<   0,  0,-228>*in,<   0,  0,-588>*in,1*in scale <132,60,1> translate <0,192,0>*in}
		//cylinder{<-264,  0,-228>*in,<-264,  0,-588>*in,3*in translate <0,192,0>*in texture{RedPt}}
		cylinder{<   0,  0,-228>*in,<   0,  0,-588>*in,1*in scale <132,60,1> translate <-264,192,0>*in}
		//cylinder{< 264,  0,-228>*in,< 264,  0,-588>*in,3*in translate <0,192,0>*in texture{RedPt}}
		cylinder{<   0,  0,-228>*in,<   0,  0,-588>*in,1*in scale <132,60,1> translate <264,192,0>*in}
		// the entranceway
		//cylinder{< -84,192,-612>*in,< -84,224,-612>*in,3*in texture{RedPt}}
		//cylinder{<  84,192,-612>*in,<  84,224,-612>*in,3*in texture{RedPt}}
		//cylinder{< -84,192,-780>*in,< -84,224,-780>*in,3*in texture{RedPt}}
		//cylinder{<  84,192,-780>*in,<  84,224,-780>*in,3*in texture{RedPt}}
		//cylinder{<   0,  0,-612>*in,<   0,  0,-780>*in,3*in translate <0,192,0>*in texture{RedPt}}
		cylinder{<   0,  0,-612>*in,<   0,  0,-780>*in,1*in scale <84,40,1> translate <0,192,0>*in}
		// side chambers
		//cylinder{<-396,192,-612>*in,<-396,224,-612>*in,3*in texture{RedPt}}
		//cylinder{<-108,192,-612>*in,<-108,224,-612>*in,3*in texture{RedPt}}
		//cylinder{<-396,192,-780>*in,<-396,224,-780>*in,3*in texture{RedPt}}
		//cylinder{<-108,192,-780>*in,<-108,224,-780>*in,3*in texture{RedPt}}
		//cylinder{<-396,  0,-696>*in,<-108,  0,-696>*in,3*in translate <0,192,0>*in texture{RedPt}}
		cylinder{<-396,  0,   0>*in,<-108,  0,   0>*in,1*in scale <1,40,84> translate <0,192,-696>*in}
		//cylinder{< 396,192,-612>*in,< 396,224,-612>*in,3*in texture{RedPt}}
		//cylinder{< 108,192,-612>*in,< 108,224,-612>*in,3*in texture{RedPt}}
		//cylinder{< 396,192,-780>*in,< 396,224,-780>*in,3*in texture{RedPt}}
		//cylinder{< 108,192,-780>*in,< 108,224,-780>*in,3*in texture{RedPt}}
		//cylinder{< 108,  0,-696>*in,< 396,  0,-696>*in,3*in translate <0,192,0>*in texture{RedPt}}
		cylinder{< 108,  0,   0>*in,< 396,  0,   0>*in,1*in scale <1,40,84> translate <0,192,-696>*in}
		texture{WallBlock}
	}

#declare Temple01=
union{
	object{T01_IdolRoom}
	object{T01_MainChamber}
	object{T01_EntranceWay}
	object{T01_Roof}
	//people for scale
	/*
	object{HumanFigure rotate y*180 translate <0,0,-48>*in}//in front of idol
	object{HumanFigure rotate y*180 translate <0,0,-264>*in}//in front of idol room
	object{HumanFigure rotate y*180 translate <0,0,-600>*in}//entering main chamber
	object{HumanFigure rotate y*0 translate <-252,0,-600>*in}//entering side room
	object{HumanFigure rotate y*0 translate <252,0,-600>*in}//entering side room
	object{HumanFigure rotate y*180 translate <0,0,-792>*in}//entering temple
	object{HumanFigure rotate y*135 translate <48,0,-300>*in}//in main chamber - left
	object{HumanFigure rotate y*-120 translate <-36,0,-324>*in}//in main chamber - right
	*/
	//people for the actual scene
	CalmoraCostume()
	RTDH3(<0,RPGoffset.y,-280>,<0,-170,0>,
		RPGBody,RPGPose,
		array[1]{0},<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>
	)
	NeffyCostume()
	RTDH3(<-84,RPGoffset.y,-370>,<0,-50,0>,
		RPGBody,RPGPose,
		array[1]{0},<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>
	)
	MencoriCostume()
	RTDH3(<84,RPGoffset.y,-420>,<0,120,0>,
		RPGBody,RPGPose,
		array[1]{0},<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>
	)
	FalaneCostume()
	RTDH3(<-48,RPGoffset.y,-336>,<0,-45,0>,
		RPGBody,RPGPose,
		array[1]{0},<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>
	)
	HondyCostume()
	RTDH3(<36,RPGoffset.y,-360>,<0,180,0>,
		RPGBody,RPGPose,
		array[1]{0},<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>
	)
	//test lighting
	light_source {
	  <0,40,-5>*ft
	  colour rgb <1,0.7,0.4>*1.5
	}
	light_source {
	  <-20,40,-25>*ft
	  colour rgb <1,0.7,0.4>*1.5
	}
	light_source {
	  <20,40,-25>*ft
	  colour rgb <1,0.7,0.4>*1.5
	}
	light_source {
	  <-20,40,-55>*ft
	  colour rgb <1,0.7,0.4>*1.5
	}
	light_source {
	  <20,40,-55>*ft
	  colour rgb <1,0.7,0.4>*1.5
	}
	translate <0,0,60>*ft
}

object{Temple01}

/*
//dice
object{Icosahedron scale 2*ft translate <43,2,53>*ft texture{RedPt}}
object{Icosahedron scale 2*ft rotate y*30 translate <52,2,46>*ft texture{GreenPt}}
object{D8die scale 2*ft rotate x*35 translate <45,2,32>*ft texture{BluePt}}

//extra figures
union{
	object{HumanFigure rotate y*180 translate <0,6,0>*in}
	cylinder{<0,0,0>*in,<0,6,0>*in,2*ft texture{Grey50Pt}}
	translate <-29,0,56>*ft
}

union{
	object{HumanFigure rotate y*180 translate <0,6,0>*in}
	cylinder{<0,0,0>*in,<0,6,0>*in,2*ft texture{Grey50Pt}}
	rotate <0,0,-110>
	rotate <0,30,0>
	translate <-27,2,63>*ft
}

union{
	object{HumanFigure rotate y*180 translate <0,6,0>*in}
	cylinder{<0,0,0>*in,<0,6,0>*in,2*ft texture{Grey50Pt}}
	rotate y*-90
	translate <-35,0,65>*ft
}
*/





