#version unofficial MegaPov 0.5;
#include "wrmat.inc"

// used to signal other files that they are called by main file
#declare main = 3;
// 0 for modelling light, 1 for test lights and n (n>1) for n*n area lights
#declare lght = 5;
// 0 for simple room, 1 for complex mesh and 2 for full textures
#declare room = 2;
// 0 for simple throne, 1 for complex throne and 2 for full textures
#declare throne = 2;
// radiosity (on or off)
#declare rad = 1;

global_settings { 
  //ambient_light 0 
#if(rad)
  radiosity { 
    normal on
  #if(rad <2)
    pretrace_start 0.08 pretrace_end 0.04
    count 100 nearest_count 4 error_bound 1.8 recursion_limit 3 brightness 1.75 
  #else
    pretrace_start 0.08 pretrace_end 0.02
    count 100 nearest_count 4 error_bound 1 recursion_limit 3 brightness 1.75
  #end
  }
#end
}

camera { location <.5,1.9,-1.95> look_at <.2,.5,0> }

//*************** Lights ************/
#local col = <1,1,.75>*2.5;
#local loc = <.475,1.75,-2.7>;
#if (lght<1)
  light_source { <0,1.8,0> color rgb 1 }
#else
#if (lght<2)
  light_source { loc color rgb col fade_power 2 fade_distance 1 }
#else
  light_source { loc color rgb col area_light .05*x .05*y lght lght orient circular fade_power 2 fade_distance 1 } 
#end
#end

// "ambient" light
sphere { 0 10 pigment { color rgb <1,1,1.1> } finish { ambient 25 } hollow on }

//************** Scene **************/
#if (room<1)
// floor
box { <-2,-1,-3> <2,0,2> texture { floor_material scale 4 } }
box { <-2,2,-3> <2,2.2,2> texture { floor_material } }

// corridor wall
box { <-2,-1,-3.25> <2,2,-3> pigment { color rgb 2 } }

// front wall
difference {
  box { <-2,-1,-2> <2,2,-2.25> }
  box { <-.5,0,-2.5> <.5,1.5,-1.75> }
  texture { brick_wall }
}

// door
box { 
  <0,0,.0625> <1,1.5,-.0625> texture { dark_wood }  
  rotate y*-65
  translate <-.5,0,-2.125>
}

// left wall
difference {
  box { <-2,-1,-5> <-2.2,20,5> }
  box { <-1.5,1,-.25> <-3,1.5,.25> }
  texture { floor_material rotate z*90 }
}

// right wall
box { <2,-1,-2> <2.5,2,2> texture { floor_material scale 4 rotate z*90 } }

// back wall
box { <-2,-1,2> <2,2,2.25> texture { floor_material scale 4 rotate x*90 } }
#else
#include "dungeon.pov"
#end

#if(throne<1)
// throne
union {
box { <-.75,0,0> <.75,.125,2> }
box { <-.5,.125,.25> <.5,.25,1.75> }
texture { throne_wood }
}
difference { 
  box { <-.25,.25,.85> <.25,1,1.35> }
  box { <-.5,.6,-2> <.5,2,1.2> }
  pigment { color rgb 1 } 
}
      
#else
#include "throne.pov"
#end
