#version unofficial MegaPov 0.6;

#include "robe.inc"

#macro TestGrid()
	#declare ip = -6;
	#declare cl = false;
	#while (ip<=6)
		#declare jp = -6;
		#while (jp<=6)
			#declare cl = (cl ? false : true);
			sphere { <ip*10, 0, jp*10>, 1 pigment { color rgb (cl ? 1 : 0) } }
			#declare jp = jp + 1;
		#end
		#declare ip = ip + 1;
	#end
#end

#declare TestPlane = plane {
	y, 0
	pigment { checker rgb 0.1, rgb 0.9 }
}

#declare view = array[10] {
	camera { location <-35.0, 11.0 ,-15.0> look_at <  0.0,  1.0 ,  2.0>	},	// 0. Primary view
	camera { location <  0.0,115.0 ,-31.0> look_at <  0.0,  1.0 ,-31.0>	},	// 1. Top-down
	camera { location <  1.9,  1.5 ,  1.7> look_at <  0.0,  2.0 ,  0.0>	},	// 2. Small object snapshot
	camera { location < 48.0, 11.0 ,-22.0> look_at < 40.0,  5.0 , 60.0>	},	// 3. Pew view
	camera { location < 43.0, 15.0 ,  8.0> look_at < 65.0, 15.0 ,  2.0>	},	// 4. Wall view
	camera { location <  6.0, 17.0 , -1.5> look_at <  0.5, 18.6 ,  0.0>	},  // 5. Medium object snapshot
	camera { location <-40.0,  8.0 , -9.0> look_at <-50.0,  1.0 ,-55.0>	},  // 6. Room panorama
	camera { location < -3.0,  3.0 , 32.0> look_at <-20.0,  5.0 , 23.0>	}		// 7. Altar view
	camera { location < 23.0, 15.0 , 32.0> look_at <  0.0, 40.0 ,  1.0>	}		// 8. Roof view
	camera { location <  0.0,  2.0 , 18.0> look_at <  0.0,-10.0 ,-21.0>	}		// 9. Organ view
}

camera { view[0] }
background { rgb <0.0, 0.1, 0.8> }

//LightStar( <  5, 44, -15>, 5 )
//Fader( <1.3, 1.8, 0.9>, 19, <  0, -1,   1> )

object { Robe translate < 0.00, 7.18+stgFloor, 2.00> }
object { Cross rotate x*90 translate < 0.00, 7.50+stgFloor, 2.00> }
object { Lectern translate <0, stgAlt, stgBack-6> }
object { Pipes }
object { Room }
object { Stage }
object { Candelabra rotate y* 45 translate <-57, 0, stgBack+3> }
object { Candelabra rotate y*-45 translate < 57, 0, stgBack+3> }

ObjLine ( PewLine, z*24, z*23, 7 )
object { AltarLine }
object { MusicStand }
object { Statue rotate y*180 orgPos(4, 0.5) }
object { RoofLights }
object { WallLights }
object { Organ 	translate <0, stgFloor, 13> }
object { oBench translate <0, stgFloor, 2> }

