#version unofficial MegaPov 0.7;

// Music stand

#macro orgPos(ly, ang)
	swPos(ly, ang)
	translate <0, stgFloor, 13>
#end

#declare msCoil = union {
	#local irad = sin(pi*9.25*.06)*.024;
	#local odis = pow(pi*9.25,.8)*.03;
	#local idis = odis*sqrt(.5);
	#local ptne = < odis+irad, 1.4+odis+irad, 0 >;
	#local ptse = < odis+irad, -odis-irad, 0>;
	#local ptnw = <-odis-irad, 1.4+odis+irad, 0>;
	#local ptsw = <-odis-irad, -odis-irad, 0>;
	#local ptin = <0, -odis+3*irad, -odis>;
	object { #include "mcoilobj.inc" translate y*1.4 }
	object { #include "mcoilobj.inc" scale <-1, -1, 1> }
	cylinder { <idis, idis, 0.00>, <-idis, 1.4-idis, 0.00>, irad }
	cylinder { ptnw, ptne, irad }
	cylinder { ptsw, ptnw, irad }
	cylinder { ptsw, ptse, irad }
	cylinder { ptse, ptne, irad }
	cylinder { ptnw, ptin, irad }
	cylinder { ptne, ptin, irad }
	cylinder { ptse, ptin, irad }
	cylinder { ptsw, ptin, irad }
	cylinder { ptsw, ptse+z*odis*0.4, irad }
	cylinder { ptse, ptse+z*odis*0.4, irad }
	sphere { ptse, irad }
	sphere { ptne, irad }
	sphere { ptnw, irad }
	sphere { ptsw, irad }
	sphere { ptse+z*odis*0.4, irad }
	sphere { ptin, irad }
	
	texture { TestHighlight }
	translate < odis+irad*2, odis+irad*2, 0 >
	rotate -y*15 
	rotate x*-20
}

#declare MusicStand = union {
	object { msCoil }
	object { msCoil scale <-1, 1, 1> }
	scale 2
	orgPos(4, 0)
}

// Organ bench

#declare obSide = difference {
	box { <-15, 0, 0>, < 15, 2.5, 1.0> }
	cylinder { x*16, x*-16, 1 scale <1, 1, .5> translate <0, 2.0, 1.0> }
	cylinder { x*16, x*-16, 1 scale <1, .5, 1> translate <0, 0.0, 1.0> }
	plane { <0, -1,-1>, 0 translate y*2.5 }
}

#declare obLeg = object { #include "blegobj.inc" translate <10.5, 0, 3.5> }

#declare obTop = union {
	box { <-10, 0, -3>, <10, 2.5, 3> }
	object { Mitre(obSide,10) translate  z*3 }
	object { Mitre(obSide,10) rotate y*180 translate -z*3 }
	object { Mitre(obSide, 3) rotate y* 90 translate  x*10 }
	object { Mitre(obSide, 3) rotate y*270 translate -x*10 }
}

#declare oBench = union {
	object { obTop translate y*4.5 }
	object { obLeg }
	object { obLeg scale <-1, 1, 1> }
	object { obLeg scale < 1, 1,-1> }
	object { obLeg scale <-1, 1,-1> }
	texture { obTex }
}

// Statue

#declare AppleBody = lathe {
	cubic_spline
	11,
	<0.0, -.3>, <0.0, -.4>, <0.1, -.5>, <0.3, -.4>, <0.4, -.3>, <0.5, -.1>,
	<0.6, 0.2>, <0.5, 0.4>, <0.3, 0.5>, <0.0, 0.4>, <-.1, 0.4>
}

#declare LeafBody = difference {
	prism {
		linear_sweep
		cubic_spline
		0, 1, 15
		<0.0, -.1>, <0.0, 0.0>, <0.1, 0.1>, <0.2, 0.3>, <0.3, 0.6>, <0.2, 0.9>,
		<0.1, 1.1>, <0.0, 1.2>, <-.1, 1.1>, <-.2, 0.9>, <-.3, 0.6>, <-.2, 0.3>,
		<-.1, 0.1>, <0.0, 0.0>, <0.0, -.1>
	}
	sphere { -y*20.02, 20.5 }
	clipped_by { sphere { -y*20, 20.5 } }
}

#declare Stem = cylinder { <0, .3, 0>, <.1, .6, -.1>, .03 }

#declare Apple = union {
	object { AppleBody }
	object { Stem }
	object { LeafBody scale .5 rotate y*30 translate <.1, .37, -.1> }
	scale 0.30
}

#declare Serpent = union { 
	object { #include "serp0obj.inc" }
	object { #include "serp1obj.inc" }
	object { #include "serp2obj.inc" }
	object { #include "serp3obj.inc" }
	object { #include "serp4obj.inc" }
}

#declare stbGround = function { 
	pigment { 
		granite
		color_map {
			[ 0 rgb 0 ]
			[ 1 rgb 1 ]
		}
		scale .25
	}
}

#declare stbAlt = 3.5;
#declare stsAlt = 0.3;
#declare stbWid0 = 2.0;
#declare stbWid1 = 1.4;

#declare stbCone = function {
	y+stbAlt*((x*x+z*z)^.25/stbWid0^.50-1)
}

#declare stBase = isosurface {
	function { stbCone(x, y, z) + sqr(stbGround(x, y, z))*.35 }
	max_gradient 4.4
	max_trace 2
	contained_by { box { <-stbWid0, 0, -stbWid0>, <stbWid0, stbAlt, stbWid0> } }
}

#declare Statue = union {
	object { Serpent scale 5 translate y*stsAlt }
	object { stBase }
	object { Apple translate <-0.06, 4.30,-0.53 > }
	texture { StatueCol } 
}

// Robe
#declare Robe = union {
	object { #include "robeobj.inc" texture { RobeCol }}
	object { #include "slev0obj.inc" texture { RobeCol }}
	object { #include "slev1obj.inc" texture { RobeCol }}
}

// Pipes

#macro pipTower(rad, hgt)
	#local opLow = rad*2.0;
	#local opHigh = rad*4.5;
	#local opRad = rad*1.6;
	union {
		cone { 0, rad*.42, y*rad, rad*1.01 }
		intersection {
			union {
				cylinder { < 0, opLow, -rad>, < 0, opLow, rad>, opRad scale <rad/opRad, 1, 1> }
				cylinder { < 0, opHigh, -rad>, < 0, opHigh, rad>, opRad scale <rad/opRad, 1, 1> }
				box { <-rad, opLow, -rad*2> <rad*.5, opHigh, rad*2> }
			}
			cylinder { y*opLow, y*opHigh, rad }
		}
		cylinder { y*rad, y*opLow, rad }
		cylinder { y*opHigh, y*(hgt-rad*3), rad }
		cone { y*hgt, rad*.42, y*(hgt-3*rad), rad*1.01 }
		texture { PipeCol }
	}
#end

#macro pbSide(wid, hgt, rad)
	union {
		cylinder { <-wid-rad, rad, wid>, < wid+rad, rad, wid>, rad }
		cylinder { <-wid-rad, hgt-rad, wid>, < wid+rad, hgt-rad, wid>, rad }
		box { <-wid, 0.0, wid-rad>, < wid, hgt, wid> }
		texture { FrameWood }
	}
#end

#macro Pipe16(alt)
	ObjRound( Mitre( pbSide(0.5, 1.5, 0.2), .3 ), y*0, y*90, 4 )
	object { pipTower(1.0, alt) translate y*1.45 }
#end

#macro Pipe8(alt)
	ObjRound( Mitre( pbSide(0.4, 1.0, 0.15), .25 ), y*0, y*90, 4 )
	object { pipTower(0.8, alt) translate y*0.95 }
#end

#macro Pipe4(alt)
	ObjRound( Mitre( pbSide(0.3, 0.5, 0.1), .2 ), y*0, y*90, 4 )
	object { pipTower(0.6, alt) translate y*0.45 }
#end

#macro Pipe2(alt)
	ObjRound( Mitre( pbSide(0.2, 0.3, 0.05), .15 ), y*0, y*90, 4 )
	object { pipTower(0.4, alt) translate y*0.25 }
#end

#macro Pipe1a(alt)
	ObjRound( Mitre( pbSide(0.15, 0.2, 0.03), .12 ), y*0, y*90, 4 )
	object { pipTower(0.2, alt) translate y*0.25 }
#end

#macro Pipe1(alt)
	ObjRound( Mitre( pbSide(0.1, 0.1, 0.02), .08 ), y*0, y*90, 4 )
	object { pipTower(0.1, alt) translate y*0.25 }
#end

#declare PipeHigh = union {
	union { Pipe8(17.0) translate <0, 0, -22> }
	union { Pipe8(17.5) translate <0, 0, -18> }
	union { Pipe8(18.0) translate <0, 0, -14> }
	union { Pipe16(34.0) translate <0, 0, -10> }
	union { Pipe16(35.0) translate <0, 0, -6> }
	union { Pipe16(36.0) translate <0, 0, -2> }
	union { Pipe16(36.0) translate <0, 0, 2> }
	union { Pipe16(35.0) translate <0, 0, 6> }
	union { Pipe16(34.0) translate <0, 0, 10> }
	union { Pipe8(18.0) translate <0, 0, 14> }
	union { Pipe8(17.5) translate <0, 0, 18> }
	union { Pipe8(17.0) translate <0, 0, 22> }
}

#declare PipeLow = union {
	union { Pipe4(9.0) translate <0, 0, -22> }
	union { Pipe4(8.7) translate <0, 0, -18> }
	union { Pipe4(8.5) translate <0, 0, -14> }
	union { Pipe2(4.5) translate <0, 0, -10> }
	union { Pipe2(4.4) translate <0, 0, -6> }
	union { Pipe2(4.3) translate <0, 0, -2> }
	union { Pipe1a(2.30) translate <0, 0, 2> }
	union { Pipe1a(2.25) translate <0, 0, 6> }
	union { Pipe1a(2.20) translate <0, 0, 10> }
	union { Pipe1(1.15) translate <0, 0, 14> }
	union { Pipe1(1.10) translate <0, 0, 18> }
	union { Pipe1(1.05) translate <0, 0, 22> }
}

