#version unofficial MegaPov 0.7;

// Round keys

#declare wKeyH = .21;

#macro KeyRound(phi,ang,hgt,r1,r2,c,m,tex)
	#local hw = phi*.5;
	#local hl1 = r1*sin(radians(hw));
	#local hl2 = r2*sin(radians(hw));
	#local z1 = r1*cos(radians(hw));
	#local z2 = r2*cos(radians(hw));
	#local dz = z2-z1;
	
	#local subbox = box { <-hl2, 0, 0>, <hl2, hgt, dz> }
	#local innercyl = union {
		cylinder { y*-.01, y*(hgt+.01), hl1 }
		cone { y*(hgt-c*m), hl1, y*(hgt+c*m), hl1+2*c }
		scale <1, 1, (r1-z1)/hl1>
	}
	#local outercyl = union {
		cylinder { 0, y*(hgt-c*m), hl2 }
		cone { y*(hgt-c*m), hl2, y*hgt, hl2-c }
		scale <1, 1, (r2-z2)/hl2>
		translate z*dz
	}
	#local lplane = union {
		plane { x, 0 }
		plane { < m,-1, 0 >, 0 translate y*(hgt-c*m) }
		rotate y*-hw
		translate -x*hl1 
	}

	difference {
		union {
			object { subbox }
			object { outercyl }
		}
		object { innercyl }
		object { lplane }
		object { lplane scale <-1, 1, 1> }
		
		translate z*z1
		rotate y*(180+ang)
		texture { tex }
	}
#end

#macro CutRound(phi,ang,hgt,r1,r2)
	#local hw = phi*.5;
	#local hl1 = r1*sin(radians(hw));
	#local hl2 = r2*sin(radians(hw));
	#local z1 = r1*cos(radians(hw));
	#local z2 = r2*cos(radians(hw));
	#local dz = r2-z1+.01;
	
	#local subbox = box { <-hl2, -.01, 0>, <hl2, hgt+.01, dz> }
	#local innercyl = cylinder { 
		y*-.02, y*hgt+.02, hl1
		scale <1, 1.01, (r1-z1)/hl1>
	}
	#local lplane = plane { 
		x, 0
		rotate -y*hw
		translate -x*hl1 
	}

	difference {
		object { subbox }
		object { innercyl }
		object { lplane }
		object { lplane scale <-1, 1, 1> }
		translate z*z1
		rotate y*ang
		pigment { rgb 0 }
	}
#end

#macro rOctave(ly,ang)
	#local ir = 17+ly*3;
	#local or = 20+ly*3;
	#local dphi = 43/(ir+or);
	#local whites = union {
		KeyRound(.98*dphi, -3*dphi, wKeyH, ir, or, .05, 1, owkTex)
		KeyRound(.98*dphi, -2*dphi, wKeyH, ir, or, .05, 1, owkTex)
		KeyRound(.98*dphi, -1*dphi, wKeyH, ir, or, .05, 1, owkTex)
		KeyRound(.98*dphi,  0*dphi, wKeyH, ir, or, .05, 1, owkTex)
		KeyRound(.98*dphi,  1*dphi, wKeyH, ir, or, .05, 1, owkTex)
		KeyRound(.98*dphi,  2*dphi, wKeyH, ir, or, .05, 1, owkTex)
		KeyRound(.98*dphi,  3*dphi, wKeyH, ir, or, .05, 1, owkTex)
	}
	#local blacks = union {
		KeyRound(.5*dphi, -2.6*dphi, wKeyH*2, ir+1, or, .03, 5, obkTex)
		KeyRound(.5*dphi, -1.4*dphi, wKeyH*2, ir+1, or, .03, 5, obkTex)
		KeyRound(.5*dphi,  0.3*dphi, wKeyH*2, ir+1, or, .03, 5, obkTex)
		KeyRound(.5*dphi,  1.5*dphi, wKeyH*2, ir+1, or, .03, 5, obkTex)
		KeyRound(.5*dphi,  2.7*dphi, wKeyH*2, ir+1, or, .03, 5, obkTex)
	}
	#local cuts = union {
		CutRound(.5*dphi, -2.6*dphi, wKeyH, ir+1, or)
		CutRound(.5*dphi, -1.4*dphi, wKeyH, ir+1, or)
		CutRound(.5*dphi,  0.3*dphi, wKeyH, ir+1, or)
		CutRound(.5*dphi,  1.5*dphi, wKeyH, ir+1, or)
		CutRound(.5*dphi,  2.7*dphi, wKeyH, ir+1, or)
	}
	union {
		difference {
			object { whites }
			object { cuts }
		}
		object { blacks }
		rotate y*ang*dphi
	}
#end

#declare rlScale = <1.4, 1.0, 0.8>;

#macro rLayer(ly)
	union {
		object { rOctave(ly,-14) }
		object { rOctave(ly, -7) }
		object { rOctave(ly,  0) }
		object { rOctave(ly,  7) }
		object { rOctave(ly, 14) }
	}
#end

// Organ pedals
               
#declare pKeyH = 0.65;

#macro wPedal(ang)
	KeyRound(1.50, ang, pKeyH, 15, 30, .2, 5, owpTex )
#end

#macro bPedal(ang)
	KeyRound(1.00, ang, pKeyH*1.3, 15, 30, .1, 3, obpTex )
#end

#macro pOctave(ang)
	union {
		wPedal(ang- 9.6) // C
		bPedal(ang- 8.0) // C#
		wPedal(ang- 6.4) // D
		bPedal(ang- 4.8) // Eb
		wPedal(ang- 3.2) // E
		wPedal(ang+ 0.0) // F
		bPedal(ang+ 1.6) // F#
		wPedal(ang+ 3.2) // G
		bPedal(ang+ 4.8) // Ab
		wPedal(ang+ 6.4) // A
		bPedal(ang+ 8.0) // Bb
		wPedal(ang+ 9.6) // B
	}
#end

#declare pLayer = union {
	pOctave(-22.4)
	pOctave(  0.0)
	pOctave( 22.4)
}

// Organ console

#declare oHgtSet = 10;
#declare oHgtMax = oHgtSet+2.1;
#declare oKeyAng = 35;
#declare oConAng = 78;

#macro oLayer(alt,ly)
	#local hgt = ly*.35+.25;
	#local ir = 17+ly*3;
	#local or = 20+ly*3;
	#local dphi = 43/(ir+or);
	#local aphi = (oConAng-dphi*oKeyAng)*.5;
	#local atheta = (oConAng-aphi)*.5;
	
	union {
		object { rLayer(ly) translate y*hgt }
		KeyRound( oKeyAng*dphi, 0, hgt-.05, ir, or, .01, 1, OrganTex )
		KeyRound( aphi, atheta, hgt+.45, ir, or, .01, 1, OrganTex )
		KeyRound( aphi,-atheta, hgt+.45, ir, or, .01, 1, OrganTex )
		translate < 0, alt, 0>
		//scale rlScale
	}
#end

#macro oBlank(alt,ly)
	#local hgt = ly*.35+.25;
	#local ir = 17+ly*3;
	#local or = 20+ly*3;
	union {
		KeyRound( oConAng/3, oConAng/3, hgt+.45, ir, or, .01, 1, OrganTex )
		KeyRound( oConAng/3, 0, hgt+.45, ir, or, .01, 1, OrganTex )
		KeyRound( oConAng/3, -oConAng/3, hgt+.45, ir, or, .01, 1, OrganTex )
		translate < 0, alt, 0>
		//scale rlScale
	}
#end

#macro oBack()
	#local i = 2;
	difference {
		union {
			KeyRound( oConAng/3, oConAng/3,oHgtMax, 32, 33, .01, 1, OrganTex )
			KeyRound( oConAng/3, 0, oHgtMax, 32, 33, .01, 1, OrganTex )
			KeyRound( oConAng/3, -oConAng/3, oHgtMax, 32, 33, .01, 1, OrganTex )
		}
		#while (i<oConAng*.5)
			#local dr = cos(radians(i));
			#local rad = -33;
			cone { 
				<0,-.01, rad>, .7, <0, oHgtMax+.01, rad>, .5 
				rotate y*i
				texture { OrganTex }
			}
			cone { 
				<0,-.01, rad>, .7, <0, oHgtMax+.01, rad>, .5 
				rotate -y*i
				texture { OrganTex }
			}
			#local i = i + 4;
		#end
	}
#end

#declare oSides = union {
	KeyRound( 6, oConAng*.5-3, oHgtSet+.1, 20, 32, .01, 1, OrganTex )
	KeyRound( 6, 3-oConAng*.5, oHgtSet+.1, 20, 32, .01, 1, OrganTex )
}

// Switches

#macro FrameRound(wid, hgt, rad)
	#local wp = wid*.5+rad;
	#local hp = hgt*.5+rad;
	#local wEdge = wp+rad;
	#local hEdge = hp+rad;
	intersection {
		cylinder { -x*wEdge, x*wEdge, rad }
		plane { <-1, 0, 1>, 0 translate x*-wp }
		plane { < 1, 0, 1>, 0 translate x* wp }
		translate z*-hp
	}
	intersection {
		cylinder { -x*wEdge, x*wEdge, rad }
		plane { <-1, 0,-1>, 0 translate x*-wp }
		plane { < 1, 0,-1>, 0 translate x* wp }
		translate z* hp
	}
	intersection {
		cylinder { -z*hEdge, z*hEdge, rad }
		plane { < 1, 0,-1>, 0 translate z*-hp }
		plane { < 1, 0, 1>, 0 translate z* hp }
		translate x*-wp
	}
	intersection {
		cylinder { -z*hEdge, z*hEdge, rad }
		plane { <-1, 0,-1>, 0 translate z*-hp }
		plane { <-1, 0, 1>, 0 translate z* hp }
		translate x* wp
	}
#end

#macro CutCyl(rad, wid, ang0, ang1)
	intersection {
		cylinder { -x*wid*.5, x*wid*.5, rad }
		union {
			plane { y, 0 rotate x*ang0 }
			plane { y, 0 rotate x*-ang1 }
		} 
	}
#end

#macro oSwitch(wid, hgt, ison, tex)
	union {
		object { CutCyl( wid, hgt*.5, ison*20, (1-ison)*20 ) texture { tex } }
		FrameRound( wid, hgt, .04 )
		texture { swBaseCol }
	}
#end

#macro swPos( ly, ang )
	translate <0, oHgtSet+ly*.35+.70, -(ly*3+18.5)>
	rotate y*ang*oConAng*.5
#end

#declare swPedal = union {
	#local shift = 0.045;
	#local endp = 0.970;
	object { oSwitch(.4, .8, 0, swCol0) swPos(2,shift* 0-endp) }
	object { oSwitch(.4, .8, 1, swCol0) swPos(2,shift* 1-endp) }
	object { oSwitch(.4, .8, 0, swCol0) swPos(2,shift* 2-endp) }
	object { oSwitch(.4, .8, 0, swCol0) swPos(2,shift* 3-endp) }
	object { oSwitch(.4, .8, 0, swCol0) swPos(2,shift* 4-endp) }
	object { oSwitch(.4, .8, 0, swCol0) swPos(2,shift* 5-endp) }
	object { oSwitch(.4, .8, 1, swCol0) swPos(2,shift* 6-endp) }
	object { oSwitch(.4, .8, 1, swCol0) swPos(2,shift* 7-endp) }
	object { oSwitch(.4, .8, 0, swCol0) swPos(2,shift* 8-endp) }
	object { oSwitch(.4, .8, 0, swCol0) swPos(2,shift* 9-endp) }
	object { oSwitch(.4, .8, 1, swCol1) swPos(2,shift*10-endp) }
	object { oSwitch(.4, .8, 0, swCol2) swPos(2,shift*11-endp) }
	object { oSwitch(.4, .8, 0, swCol2) swPos(2,shift*12-endp) }
}

#declare swPositiv = union {
	#local shift = 0.045;
	#local endp = 0.970;
	object { oSwitch(.4, .8, 0, swCol0) swPos(2,-shift* 4+endp) }
	object { oSwitch(.4, .8, 0, swCol0) swPos(2,-shift* 3+endp) }
	object { oSwitch(.4, .8, 0, swCol0) swPos(2,-shift* 2+endp) }
	object { oSwitch(.4, .8, 1, swCol0) swPos(2,-shift* 1+endp) }
	object { oSwitch(.4, .8, 0, swCol0) swPos(2,-shift* 0+endp) }
}

#declare swSwell = union {
	#local shift = 0.040;
	#local endp = 0.976;
	object { oSwitch(.4, .8, 0, swCol0) swPos(3,shift* 0-endp) }
	object { oSwitch(.4, .8, 0, swCol0) swPos(3,shift* 1-endp) }
	object { oSwitch(.4, .8, 0, swCol0) swPos(3,shift* 2-endp) }
	object { oSwitch(.4, .8, 1, swCol0) swPos(3,shift* 3-endp) }
	object { oSwitch(.4, .8, 0, swCol0) swPos(3,shift* 4-endp) }
	object { oSwitch(.4, .8, 0, swCol0) swPos(3,shift* 5-endp) }
	object { oSwitch(.4, .8, 0, swCol0) swPos(3,shift* 6-endp) }
	object { oSwitch(.4, .8, 0, swCol0) swPos(3,shift* 7-endp) }
	object { oSwitch(.4, .8, 0, swCol0) swPos(3,shift* 8-endp) }
	object { oSwitch(.4, .8, 0, swCol0) swPos(3,shift* 9-endp) }
	object { oSwitch(.4, .8, 0, swCol0) swPos(3,shift*10-endp) }
	object { oSwitch(.4, .8, 0, swCol1) swPos(3,shift*11-endp) }
	object { oSwitch(.4, .8, 1, swCol1) swPos(3,shift*12-endp) }
	object { oSwitch(.4, .8, 0, swCol1) swPos(3,shift*13-endp) }
	object { oSwitch(.4, .8, 0, swCol0) swPos(3,shift*14-endp) }
	object { oSwitch(.4, .8, 1, swCol0) swPos(3,shift*15-endp) }
}

#declare swGrand = union {
	#local shift = 0.040;
	#local endp = 0.976;
	object { oSwitch(.4, .8, 0, swCol0) swPos(3,-shift*14+endp) }
	object { oSwitch(.4, .8, 0, swCol0) swPos(3,-shift*13+endp) }
	object { oSwitch(.4, .8, 0, swCol0) swPos(3,-shift*12+endp) }
	object { oSwitch(.4, .8, 0, swCol0) swPos(3,-shift*11+endp) }
	object { oSwitch(.4, .8, 0, swCol0) swPos(3,-shift*10+endp) }
	object { oSwitch(.4, .8, 0, swCol0) swPos(3,-shift* 9+endp) }
	object { oSwitch(.4, .8, 0, swCol0) swPos(3,-shift* 8+endp) }
	object { oSwitch(.4, .8, 1, swCol0) swPos(3,-shift* 7+endp) }
	object { oSwitch(.4, .8, 0, swCol0) swPos(3,-shift* 6+endp) }
	object { oSwitch(.4, .8, 0, swCol0) swPos(3,-shift* 5+endp) }
	object { oSwitch(.4, .8, 1, swCol0) swPos(3,-shift* 4+endp) }
	object { oSwitch(.4, .8, 0, swCol1) swPos(3,-shift* 3+endp) }
	object { oSwitch(.4, .8, 0, swCol0) swPos(3,-shift* 2+endp) }
	object { oSwitch(.4, .8, 0, swCol0) swPos(3,-shift* 1+endp) }
	object { oSwitch(.4, .8, 1, swCol2) swPos(3,-shift* 0+endp) }
}

#declare Organ = union {
	oLayer(oHgtSet, 1)
	oLayer(oHgtSet, 2)
	oLayer(oHgtSet, 3)
	oBlank(oHgtSet, 4)
	oBack()
	object { oSides }
	Fader ( <0.4, 2.2, 0.7>, 4, <  0, 9.5, -31> )
	Fader ( <0.4, 2.2, 0.7>, 4, <  9, 9.5, -22> )
	Fader ( <0.4, 2.2, 0.7>, 4, <- 9, 9.5, -22> )
	object { swPedal }
	object { swPositiv }
	object { swSwell }
	object { swGrand }
	object { pLayer translate <0,  0.56,  0.00> }
}

