// Parametric variable form
#version unofficial MegaPov 0.6;

#declare uMin = -1; // Minimum u value
#declare uMax = 1; // Maximum u value
#declare uNum = 40; // Number of points in u direction
#declare uWrap = 0; // u wraps around if != 0
#declare uSeed = 8266; // Random number seed for u parameter

#declare vMin = -1; // Minimum v value
#declare vMax = 1; // Maximum v value
#declare vNum = 40; // Number of points in v direction
#declare vWrap = 0; // v wraps around if != 0
#declare vSeed = 1425; // Random number seed for v parameter

#declare IsRnd = true; // True if random number used

#declare Detail = "Partial"
/* Detail values
  Verbose = Line by line details
  Partial = Operations only
  Other = Filename only
*/

/* For all macro functions
	i = Current value of u parameter
	j = Current value of v parameter
	p = Current value of u variance (0...1)
	q = Current value of v variance (0...1)
	vc= Current 3D point
*/

// Optional functions
/*#macro cen(i)
	#local orad = 2+i/3;
	#local hgt = 4+52*(uMax-i)/uMax;
  <orad*cos(i), hgt, orad*sin(i)>
#end

#macro dir(i)
  vnormalize(cen(i-1e-4)-cen(i+1e-4))
#end

#macro norm(i)
  vnormalize(dir(i-1e-4)-dir(i+1e-4))
#end

#macro ortho(i)
  vcross(dir(i),norm(i))
#end

#macro vturb(vc, siz)
	vc + vturbulence( 2, 0.6, 7, vc )*siz
#end*/

// point function
#macro pnt(i, j, p, q)
	#local dst = (min(1-abs(i),1-abs(j))+.01)*pi;
	
	#local xp = i+(cos(j*pi*8)+q)*.01;
	#local yp = sin(dst);
	#local zp = j+(cos(i*pi*8)+q)*.01;
	
	< xp, yp, zp >
#end

#declare Smooth = 0; // Smooth flag