#version unofficial MegaPov 0.7;

// Church pews
#declare PewPanel = intersection {
	box { <-.5, -.5, .0>, <.5, .5, .1> }
	plane { < 1, 0, 8>, 0 translate < 1, 0, .0> }
	plane { <-1, 0, 8>, 0 translate <-1, 0, .0> }
	plane { < 0, 1, 8>, 0 translate < 0, 1, .0> }
	plane { < 0,-1, 8>, 0 translate < 0,-1, .0> }
}

#declare PewBackFrame = difference {
	box { <0.1, 0.1, -.10>, <6.2, 1.4, .10> }
	box { <0.3, 0.3, -.11>, <1.2, 1.2, .11> }
	box { <1.5, 0.3, -.11>, <2.4, 1.2, .11> }
	box { <2.7, 0.3, -.11>, <3.6, 1.2, .11> }
	box { <3.9, 0.3, -.11>, <4.8, 1.2, .11> }
	box { <5.1, 0.3, -.11>, <6.0, 1.2, .11> }
	texture { FrameWood }
}

#declare PewSlat = union {
	cylinder { <0.25, 0, 0.35>, <6.05, 0, 0.35>, .05 }
	cylinder { <0.25, 0, 0.55>, <6.05, 0, 0.55>, .05 }
	box { <0.25, -.05, .35>, <6.05, .05, .55> }
}

#declare PewSeatFrame = difference {
	box { <0.1, 0.1, -.10>, <6.2, 1.4, .10> }
	box { <0.3, 0.3, -.11>, <6.0, 1.2, .11> }
	texture { FrameWood }
}

#declare OuterFrame = union {
	sphere { <0.1, 0.1, 0.0>, .1 }
	sphere { <0.1, 1.4, 0.0>, .1 }
	sphere { <6.2, 0.1, 0.0>, .1 }
	sphere { <6.2, 1.4, 0.0>, .1 }
	cylinder { <0.1, 0.1, 0.0>, <6.2, 0.1, 0.0>, .1 }
	cylinder { <0.1, 1.4, 0.0>, <6.2, 1.4, 0.0>, .1 }
	cylinder { <0.1, 0.1, 0.0>, <0.1, 1.4, 0.0>, .1 }
	cylinder { <6.2, 0.1, 0.0>, <6.2, 1.4, 0.0>, .1 }
	texture { FrameWood }
}

#declare PewBack = union {
	object { OuterFrame }
	object { PewBackFrame }
	object { PewPanel translate <0.75, 0.75, 0.0> texture { PanelWood } }
	object { PewPanel translate <1.95, 0.75, 0.0> texture { PanelWood } }
	object { PewPanel translate <3.15, 0.75, 0.0> texture { PanelWood } }
	object { PewPanel translate <4.35, 0.75, 0.0> texture { PanelWood } }
	object { PewPanel translate <5.55, 0.75, 0.0> texture { PanelWood } }
	rotate x*-15
	translate <-3.15, 1.8, -1.5>
}

#declare PewSeat = union {
	object { OuterFrame rotate x*90 }
	object { PewSeatFrame rotate x*90 }
	object { PewSlat texture { PanelWood } }
	object { PewSlat translate z*.3 texture { PanelWood } }
	object { PewSlat translate z*.6 texture { PanelWood } }
	translate <-3.15, 1.8, -1.5>
}

#macro BraceDisc(Rad, Ecc)
	union {
		difference {
			cylinder { y*-.05, y*.05, Rad }
			cylinder { y*-.06, y*.06, Rad-.1 }
		}
		torus { Rad-.05, .05 translate y*.05 }
		torus { Rad-.05, .05 translate y*-.05 }
		rotate z*90
		scale <1, 1, Ecc>
	}
#end

#declare PewBrace = intersection {
	union {
		BraceDisc(0.8, 1.8)
		BraceDisc(0.7, 1.7)
		BraceDisc(0.6, 1.6)
		BraceDisc(0.5, 1.5)
		BraceDisc(0.4, 1.4)
	}
	plane { -z, 0 rotate x*-15 }
	plane { -y, 0 }
	texture { FrameWood }
}

#declare LegBase = prism {
	cubic_spline
	linear_sweep
	0, .2, 25,
	<-.08, 0.52>, <-.08, 0.68>, <0.00, 0.68>, <0.12, 0.60>, <0.16, 0.48>, 
	<0.20, 0.32>, <0.24, 0.16>, <0.28, 0.08>, <0.36, 0.08>, <0.38, 0.14>, 
	<0.36, 0.12>, <0.32, 0.16>, <0.36, 0.20>, <0.40, 0.20>, <0.44, 0.12>, 
	<0.40, 0.04>, <0.32, 0.00>, <0.24, 0.04>, <0.12, 0.24>, <0.04, 0.36>, 
	<0.04, 0.48>, <0.00, 0.52>, <-.08, 0.52>, <-.08, 0.68>, <0.00, 0.68>
}

#declare LegJoin = difference {
	box { <0.1, -0.5, -0.45>, <0.5, -0.1, 0.45> }
	cylinder { <0.0, -.5, 0>, <0.6, -.5, 0>, .20 scale <1, 1, 1.5> }
	translate <-2.95, 1.8, -0.75>
	texture { FrameWood }
}

#macro BallCenter(VecA, VecB)
	#local Center = ((VecA)+(VecB))/2;
	#local Rad = vlength(VecB-VecA)/2;
	sphere { Center, Rad }
#end

#declare LegSide = union {
	BallCenter ( <0, .68, .00>, <0, .52, .00> ) //
	BallCenter ( <0, .65, .06>, <0, .51, .03> )
	BallCenter ( <0, .60, .12>, <0, .48, .04> ) //
	BallCenter ( <0, .56, .14>, <0, .42, .04> )
	BallCenter ( <0, .48, .16>, <0, .36, .04> ) //
	BallCenter ( <0, .42, .18>, <0, .32, .10> )
	BallCenter ( <0, .32, .20>, <0, .24, .12> ) //
	BallCenter ( <0, .26, .22>, <0, .20, .15> )
	BallCenter ( <0, .16, .24>, <0, .15, .18> ) //
	BallCenter ( <0, .11, .26>, <0, .08, .21> )
	BallCenter ( <0, .08, .28>, <0, .04, .24> ) //
	BallCenter ( <0, .07, .30>, <0, .01, .28> )
	BallCenter ( <0, .06, .32>, <0, .00, .32> ) //
}

#declare PewLeg = merge {
	object { LegBase rotate <-90, -90, 0> } 
	object { LegSide }
	object { LegSide translate x*.2 }
	translate x*-.1
	scale 2.5
	texture { FrameWood }
}

#declare Pew = union {
	object { PewBack }
	object { PewSeat }
	object { PewBrace translate <-2.95, 1.8, -1.5> }
	object { PewBrace translate < 2.95, 1.8, -1.5> }
	object { LegJoin }
	object { LegJoin scale <-1, 1, 1> }
	object { PewLeg translate <-2.7, 0, -.2> }
	object { PewLeg rotate y*180 translate <-2.7, 0, -1.3>  }
	object { PewLeg translate < 2.7, 0, -.2> }
	object { PewLeg rotate y*180 translate < 2.7, 0, -1.3> }
	scale 3
	rotate y*180
}

// Lectern

#declare lecSide = union {
	difference {
		box { <-3, 0, 2.75>, <3, 1.0, 3> }
		cylinder { 0, z*3.1, .75 scale <3.5, 1, 1> }
	}
	intersection {
		box { <-3, 1.0, 2.5>, <3, 1.5, 3> }
		plane { <0, 1, 1>, 0 translate <0, 1, 3> }
	}
	intersection {
		box { <-3, 8.5, 2.5>, <3, 9.0, 3> }
		plane { <0,-1, 1>, 0 translate <0, 9, 3> }
	}
	cylinder { <-2.7, 1.7, 2.5>, <2.7, 1.7, 2.5>, .2 }
	cylinder { <-2.7, 8.3, 2.5>, <2.7, 8.3, 2.5>, .2 }
	box { <-2.5, 1.5, 2.25>, <2.5, 8.5, 2.5> }
	texture { PanelWood }
}

#declare lecBox = union {
	difference {
		box { <-4.00, 0.00, -3.50>, <4.00, 2.00, 3.50> }
		box { <-3.75, 0.25, -3.75>, <3.75, 1.75, 3.25> }
	}
	box { 
		<-4.25, 0, -0.25>, <4.25, .25, 7.25> 
		texture { PanelWood }
		rotate x*-8
		translate <0, 2, -3.50>
	}
	box { <-4.0, 2, 3.25>, <-3.5, 3, 3.50> }
	box { < 3.5, 2, 3.25>, < 4.0, 3, 3.50> }
	translate y*9
	texture { PanelWood }
}

#declare Lectern = union {
	ObjRound( Mitre( lecSide, 0 ), 0, y*90, 4 )
	object { lecBox }
}

// Roof lamps

#declare rlBrace = difference {
	union {
		box { <-0.50,-0.10,-0.26>, < 0.00, 0.10, 0.26> }
		cylinder { -z*.26, z*.26, 0.10 }
		cylinder { x*-.65, x*-.50, 0.10 }
	}
	sphere { <0.00, 0.00, 0.18>, .05 }
	sphere { <0.00, 0.00, -.18>, .05 }
	box { <-0.49,-0.20,-0.24>, < 0.15, 0.20, 0.24> }
	texture { rLampCol0 }
}

#declare rlCowl = union {
	cone { x*0, 0.10, x*0.6, 0.24 }
	sphere { <0.20, 0.00, 0.18>, .05 }
	sphere { <0.20, 0.00, -.18>, .05 }
	sphere { x*0.8, 0.35 }
	texture { rLampCol0 }
}

#declare rlCut = union {
	cone { x*0.01, 0.10, x*0.61, 0.24 }
	sphere { x*0.8, 0.34 }
	plane { -x, -0.8 }
	ObjRound( cylinder { <-0.10, 0.06, 0.00>, < 0.10, 0.06, 0.00>, 0.01 }, x*0, x*72, 5 )
	texture { rLampCol1 }
}

#declare rlBulb = merge {
	sphere { x*5, 4.5 scale < 0.07, 0.03, 0.03 > }
	sphere { x*.7, .15 scale < 1.0, 2.0, 2.0 > }
	hollow
	no_shadow
	rlBulbCol()
}

#declare rlBody =	union {
	difference {
		object { rlCowl }
		object { rlCut }
		translate -x*0.2
	}
	object { rlBulb translate -x*0.2}
	Fader( 1.0, 25, x*0.3 )
}

#macro RoofLamp(dir, azim)
	union {
		object { rlBody rotate z*azim }
		object { rlBrace }
		rotate x*dir
		translate x*1.15
	}
#end

// Wall sconce

#declare wsCowl = union {
	cone { x*.2, 0.05, <.2, .3, 0>, 0.1 }
	intersection {
		torus { 0.2, 0.05 }
		box { <0, -.1, 0>, <.3, .1, .3> }
		rotate x*90
	}
	texture { rLampCol0 }
}

#declare wsCut = union {
	cone { <0.2, 0.01, 0>, 0.05, <0.2, 0.31, 0>, 0.1 }
	plane { x, -.2 }
	texture { rLampCol1 }
}

#declare wsBulb = sphere { 
	0, 0.15
	scale <.3, 1, .3>
	translate <0.2, 0.2, 0>
	hollow
	no_shadow
	rlBulbCol()
}

#declare wsBody = union {
	difference {
		object { wsCowl }
		object { wsCut }
	}
	object { wsBulb }
	Fader( 1.0, 25, <0.2, 0.2, 0> )
	translate <0.2, 0.2, 0>
	rotate <-25, 25, 0>
}

#declare WallSconce = union {
	object { wsBody }
	object { wsBody scale <1, 1, -1> }
	intersection {
		sphere { 0, .23 }
		plane { -x, 0 }
		texture { rLampCol0 }
	}
	scale 2
}

// Candelabras

#declare cndHolder = difference {
	lathe {
		cubic_spline
		26,
		< 0.08,-1.00 >, < 0.08, 0.00 >, < 0.09, 0.03 >, < 0.12, 0.04 >, < 0.14, 0.05 >, < 0.12, 0.06 >, < 0.14, 0.08 >,
		< 0.17, 0.09 >, < 0.18, 0.12 >, < 0.20, 0.15 >, < 0.23, 0.16 >, < 0.24, 0.19 >, < 0.25, 0.22 >, < 0.26, 0.24 >,
		< 0.27, 0.26 >, < 0.27, 0.28 >, < 0.24, 0.25 >, < 0.23, 0.24 >, < 0.22, 0.21 >, < 0.20, 0.19 >, < 0.17, 0.18 >,
		< 0.16, 0.20 >, < 0.14, 0.21 >, < 0.12, 0.20 >, < 0.10, 0.21 >, < 0.00, 0.21 >
	}
	cylinder { y*0.11, y*0.3, 0.10 }
	cylinder { y*-.10, y*0.06, 0.05 }
	cndGlassTex()
}

#declare fForm0 = function { "Piriform" <0.4> }
#declare fForm1 = function { 
	pigment {
		agate
		agate_turb 0.6
		color_map {
			[ 0 rgb 1 ]
			[ 1 rgb 0 ]
		}
		scale < 0.31, 0.03, 0.31 >
	}
}

#local fSize = < 1, -7, 1 >*0.04;

#declare cndBound = sphere {
	0, 1.8
	hollow
	scale fSize
	translate y*2.45
	pigment { rgbt 0.9 }
}

#declare Candle = union {
	object { cndHolder }
	cylinder { y*1.96, y*2.00, 0.006 texture { cndWick } }
	//object { cndBound }
	isosurface {
		function { fForm0(y, x*7, z) - y*1.4 - fForm1(x, y, z)*.1 }
		threshold 0.1
		method 2
		max_gradient 12.0
		contained_by { sphere { 0, 1.8 } }
		scale fSize
		translate y*2.45
		Flame()
	}
	Fader( <1.5, 1.5, 1.2>, 15, y*2.03 )
	cone { y*0.11, 0.10, y*1.41, 0.08 }
	cone { y*1.41, 0.08, y*1.96, 0.01 }
	texture { cndWax }
}

#macro cndArm(rad, ang, alt)
	union {
		union {
			intersection {
				torus { rad, 0.07 rotate x*90 }
				box { <0, -.1-rad, -.1>, <rad+.1, 0, .1> }
			}
			cylinder { <rad, 0, 0>, <rad, 0.06, 0>, 0.05 }
		}
		object { Candle translate x*rad }
		texture { cndMetal }
		translate y*(rad+alt)
		rotate y*ang
	}
#end

#declare Candelabra = union {
	cndArm(1.40,  65, 16.8)
	cndArm(1.70,  90, 17.0)
	cndArm(1.40, 115, 17.2)
	cndArm(1.40, -65, 16.8)
	cndArm(1.70, -90, 17.0)
	cndArm(1.40,-115, 17.2)
	object { Candle translate y*18.6 }
	cylinder { y*0, y*0.3, 1.5 }
	torus { 1.4, 0.1 translate y*.3 }
	sor { 9,
		< 1.9, 0.29 >, < 1.3, 0.30 >, < 0.7,  2.0 >, < 0.2, 12.0 >, < 0.1, 17.5 >, 
		< 0.4, 18.0 >, < 0.1, 18.5 >, < 0.1, 18.6 >, < 0.0, 18.7 >
		sturm
	}
	texture { cndMetal }
}

// Church altar

#declare Pillow = union {
	object { #include "pillobj.inc" }
	object { #include "pillobj.inc" scale <1, -1, 1> }
	sphere { y*0.3, .2 scale <1,2,1> }
	sphere { y*-.3, .2 scale <1,2,1> }
	texture { RobeCol }
	scale <1.5, 0.3, 1.5>
}

#declare Tassle = object {
	#include "tasslobj.inc"
	//plane { -y, 1.35 }
	scale 0.5
	texture { TassleCol }
}

#local tpsWid = 11.8;
#local tpsDif = tpsWid*2/15;

#declare Tapestry = union {
	object { #include "tapesobj.inc" texture { TapesCol } }
	ObjLine( Tassle, <-tpsWid, -6.87,-1.07>, x*tpsDif, 16 )
	ObjLine( Tassle, <-tpsWid, -6.87, 1.07>, x*tpsDif, 16 )
}

#declare altLenS = 0.42;
#declare altLenH = 8.00;
#declare altRadR = 0.15;
#declare altRadT = 0.50;
#declare altRadB = 3.30;
#declare altRadB1 = altRadB-altRadR;
#declare altNumS = 27;
#declare altWid = (altNumS-1)*altLenS;

#declare altRoundel = merge {
	intersection {
		union {
			torus { altRadB, altRadT }
			torus { altRadB1, altRadT translate y*altLenH }
			cylinder { -y*altRadT, y*altRadT, altRadB }
		}
		plane { -z, 0 }
		plane { x, 0 }
	}
	sphere { <-altRadB, 0.0, 0.0>, altRadT }
	sphere { <-altRadB1, altLenH, 0.0>, altRadT }
	cylinder { <-altRadB, 0, 0.0>, <0.0, 0, 0.0>, altRadT }
	ObjRound ( cylinder { <-altRadB1, 0.0, 0.0>, <-altRadB1, altLenH, 0.0>, altRadR }, y*0, y*14, 7 )
}

#declare altStraight = merge {
	cylinder { <-altLenS, 0, 0.0>, <altLenS, 0, 0.0>, altRadT }
	cylinder { <-altLenS, 0, altRadB>, <altLenS, 0, altRadB>, altRadT }
	cylinder { <-altLenS, altLenH, altRadB1>, <altLenS, altLenH, altRadB1>, altRadT }
	box { <-altLenS,-altRadT, 0.0>, <altLenS, altRadT, altRadB> }
	cylinder { <0.0, 0, altRadB1>, <0.0, altLenH, altRadB1>, altRadR }
}

#declare Altar = union {
	ObjLine( altStraight, x*-altWid, x*altLenS*2, altNumS ) 
	object { altRoundel translate -x*(altWid+altLenS) }
	object { altRoundel translate -x*(altWid+altLenS) scale <-1, 1, 1> }
	ObjLine( Pillow, <-11.2, .3+altRadT*.5, 1.3>, x*3.2, 8 )
	object { Tapestry translate <0, altLenH+altRadT, altRadB1> }
	rotate y*180
	#if (TexTest)	
		pigment { rgb 0.60 }
	#else
		texture { T_Stone58 scale 0.2 }
	#end
}

