//
// Thirst of christ
//    by Robert Fremin 
//  for the 2001 jan-feb IRTC round "Worship"
//
// Dedicated to all who were killed in the name of God,
// and all who have had their money stolen by the men of God.
//

#version 3.1;

#include "colors.inc"	// povray standard colors
#include "units.inc"

// ----------------------------------------------------------------------
//   Global
// ----------------------------------------------------------------------

global_settings {
	assumed_gamma 1.0
}

// ----------------------------------------------------------------------
//   Camera
// ----------------------------------------------------------------------

camera {
	location <0, 1.05, -1>*m
	look_at y*49*cm
	sky y
}

// ----------------------------------------------------------------------
//   Light
// ----------------------------------------------------------------------

light_source { <-10, 50, -40>*m <.75.74.7> area_light x*30*m y*10*m 3 3 jitter }

// ----------------------------------------------------------------------
//   Sky
// ----------------------------------------------------------------------

sky_sphere { pigment { gradient y color_map { [0 White][.5 SkyBlue] } } }

// ----------------------------------------------------------------------
//   Functions
// ----------------------------------------------------------------------

#macro circleColission(where,center,radiuz)
	#local x2 = pow((where).x-(center).x, 2);
	#local z2 = pow((where).z-(center).z, 2);
	(sqrt(x2+z2) < (radiuz))
#end

#macro boxColission(where,boxUL,boxLR)
	((where).x>(boxUL).x & (where).z<(boxUL).z &
	 (where).x<(boxLR).x & (where).z>(boxLR).z)
#end

// ----------------------------------------------------------------------
//   Objects
// ----------------------------------------------------------------------

// A buck
#macro DollarBill(startSeed)
union {
	#local N  = 50;		// division in width
	#local M  = 30;		// division in depth
	#local Wx = 7*cm;
	#local Dz = 2.94*cm;
	#local w  = Wx/N;
	#local d  = Dz/M;
	#local s1 = rand(startSeed)*pi/2;	// add up to 90 degree to phase
	#local s2 = rand(startSeed)*pi/2;	// add up to 90 degree to phase
	#local p1 = rand(startSeed)*pi/2;	// add up to 90 degrees to phase offset
	#local p2 = rand(startSeed)*pi/2;	// add up to 90 degrees to phase offset

	#local i = 1;
	#while (i<=N)
		#local j = 1;
		#while (j<=M)
			//
			// i-1   i
			//   1--4 j
			//   |\B|
			//   |A\|
			//   2--3 j-1
			#local phase1 = (3.5*pi+s1)*(i-1)/N+p1;
			#local phase2 = (3.5*pi+s1)*i/N+p1;
			#local phase3 = (1.9*pi+s2)*j/M+p2;
			#local phase4 = (1.9*pi+s2)*(j-1)/M+p2;
			#local h1 = (.5+j/2/M)*2*mm*sin(phase1)*cos(phase3);
			#local h2 = (.5+j/2/M)*2*mm*sin(phase1)*cos(phase4);
			#local h3 = (.5+j/2/M)*2*mm*sin(phase2)*cos(phase4);
			#local h4 = (.5+j/2/M)*2*mm*sin(phase2)*cos(phase3);

			triangle { <(i-1)*w,h1,j*d> <(i-1)*w,h2,(j-1)*d> <i*w,h3,(j-1)*d> }	// A
			triangle { <(i-1)*w,h1,j*d> <i*w,h3,(j-1)*d> <i*w,h4,j*d> }					// B
			#local j = j + 1;
		#end
		#local i = i + 1;
	#end

	pigment {
		image_map { png "dollar_bill.png" interpolate 2 }		// 700x294pixel
		rotate x*90
		scale <Wx,1,Dz>
	}
	finish { specular .3 diffuse .6 }
	normal { granite scale 2*cm bump_size 4*mm }

	translate -<Wx/2,0,Dz/2>
	scale 2
}
#end

// A grass straw
#macro grassStraw(height,away,tilt,bend,s)
	//     v1   = height/4 (height)
	//    /|\
	//   /A|B\
	//  v2-v5-v3 = height/16 (??)
	//   \C|D/
	//    \|/
	//     v4   = 0 (height/4)
	//     |
	//
	#local h2 = height/2;
	#local h4 = height/4;
	#local h8 = height/8;
	#local v1 = <0,height*3/4,(rand(s)-.5)*height/10>;
	#local v2 = <-height/40,h8,(rand(s)-.5)*height/30>;
	#local v3 = < height/40,h8,(rand(s)-.5)*height/30>;
	#local v4 = <0,0,0>;
	#local v5 = <0,h8+(rand(s)-.5)*height/100,0>;

	#if (away > .5)
		triangle {
			v1 v2 v4
			rotate tilt
			pigment { rgb <rand(s)*.1,.2+rand(s)*.8,0> }
			finish { specular .2+.4*rand(s) phong .2+.4*rand(s) }
		}
	#else
		#if (away > .15)
			union {
				union {
					triangle { v1 v2 v4 }	// AC
					triangle { v1 v4 v3 }	// BD
		#else
			union {
				union {
					triangle { v1 v2 v5 }	// A
					triangle { v1 v5 v3 }	// B
					triangle { v2 v4 v5 }	// C
					triangle { v5 v4 v3 }	// D
		#end
					rotate bend
					translate y*h4
				}
				cylinder { 0 y*h4 height/200 }
				rotate tilt
				pigment { rgb <rand(s)*.1,.2+rand(s)*.8,0> }
				finish { specular .2+.4*rand(s) phong .2+.4*rand(s) }
			}
	#end
#end

// Lots of grass
#macro Grass(height,stoneSize,stonePos)
union {
	#local N      = 400;	// z rows
	#local M      = 400;	// x columns
	#local xSize1 = 2*m;
	#local xSize2 = 25*m;
	#local zSize  = 19*m;
	#local s      = seed(35464);

	#local i = 0;
	#while (i<N)
		#local j = 0;
		#while (j<=M)
			#local leftEdge    = (xSize1/2 + (i/N)*(xSize2-xSize1)/2 );
			#local place       = (j/M)*(2*leftEdge);
			#local where       = <-leftEdge+place,0,(i/N)*zSize-.5*m> + <rand(s)-.5,0,2*rand(s)-.5>*30*cm;
			#local insideHole  = circleColission(where,stonePos,stoneSize/4.25);
			#local insideRing  = (circleColission(where,stonePos,stoneSize/2.55) & !insideHole);
			#local insideHoriz = boxColission(vrotate(where-stonePos,<0,-30,-10>), .6*<-1.1,0,.2>*stoneSize, .6*<1,0,-.2>*stoneSize);
			#local insideVert  = boxColission(vrotate(where-stonePos,<0,-30,-10>), .6*<-.26,0,1.6>*stoneSize, .6*<.2,0,-1.8>*stoneSize);
			#local size        = height*.5+(rand(s)*height*.5);
			#if (insideRing | insideHoriz | insideVert)
				#local size = size * .3;
			#end
			object {
				grassStraw(size,i/N,<(rand(s)-.5)*30,0,(rand(s)-.5)*30>,<(rand(s)-.5)*30,0,(rand(s)-.5)*30>,s)
				translate where
			}
			#local j = j + 1;
		#end
		#local i = i + 1;
	#end
}
#end

// Religous stone cross
#macro Stone(size)
union {
	difference {
		cylinder { y*-size/25 y*size/25 size/2.75 }
		cylinder { y*-size y*size size/4 }
	}
	box { <-.5,-.5,-.5> <.5,.5,.5> scale <1.2,.1,.2>*size }
	box { <-.5,-.5,-.5> <.5,.5,.5> scale <1.7,.1,.2>*size rotate y*90 translate z*-size/10 }

	pigment { granite color_map { [0 Gray40][1 Gray60] } scale 50*cm }
	normal { granite scale 20*cm bump_size 3*cm }
	finish { specular .1 }
}
#end

// Bloooood!
#macro Blood(size)
blob {
	threshold .65
	#local thick = .07;
	#local s = seed(111);

	#local i = 0;
	#while (i<40)
		sphere { 0 size 1 scale <.1+.5*rand(s),thick,.2+.5*rand(s)> translate <rand(s)-.5,0,rand(s)-.5>*size*2 }
		#local i = i + 1;
	#end

	pigment { Red*.8 filter 1 }
	normal { granite scale size bump_size size*.1 }
	finish { specular .4 phong .4 reflection .05 }
}
#end

// ----------------------------------------------------------------------
//   Scene
// ----------------------------------------------------------------------

#declare stoneSize = 150*cm;
#declare stonePos = <0,14,90>*cm;
union {
	object { Stone(stoneSize) }
	object { DollarBill(seed(468)) scale 2 rotate y*-25 translate <-3,8.3,-70>*cm }
	object { DollarBill(seed(4659)) scale 2 rotate y*55  translate <40,8.3,-2>*cm }
	object { Blood(10*cm) rotate y*120 translate <1.5,7.5,-80>*cm }
	rotate <0,30,10>
	translate stonePos
}
object { Grass(30*cm,stoneSize,stonePos) }
plane { y,0*cm pigment { granite color_map { [0 rgb <.3,.1,.05>][.05 rgb <.2,.1,.05>][1 rgb <.05,.025,.0125>] } scale 2*m } normal { granite scale .5*m bump_size 2*dm } }
