#ifndef( CherryTree_inc )
#declare CherryTree_inc = true;
// Persistence of Vision Ray Tracer Scene Description File
// File: CherryTree.inc
// Vers: 3.1
// Desc: 
// Date: 2001.04.07
// Auth: Masanori Imazu

// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
//#include "textures.inc"	// Standard Texture definitions

#local T_Petal =
	texture{
		pigment{ color rgb < 1.0, 0.65, 0.6 > } 
		finish{ ambient 0.5 }
	}

#local PetalSR = 12;
#local PetalT = 3;
#local Petal =
	intersection{
		sphere{ 0, PetalSR translate (PetalSR-PetalT)*y }
		cylinder{ 0, -(PetalT+0.1)*y, PetalSR }
		bounded_by{ cylinder{ 0.1*y, -(PetalT+0.1)*y, PetalSR*8 } }
		texture{ T_Petal }
		translate PetalSR*0.6*x
		scale< 1, 1, 0.8 >
		rotate 20*z
	}

#local CherryBlossome =
	union{
		#local Num = 5;
		#local N = Num;
		#while( N )
			#local N = N - 1;
			object{ Petal rotate N*360/Num*y }
		#end
	}

#declare Petal2 =	// for close up
	intersection{
		difference{
			sphere{ 0, PetalSR }
			sphere{ 0, PetalSR-0.1 }
			cylinder{ 0, -PetalSR*y, PetalSR*0.15 translate PetalSR*0.65*x }
			translate (PetalSR-PetalT)*y
		}
		cylinder{ 0, -(PetalT+0.1)*y, PetalSR }
		bounded_by{ cylinder{ 0.1*y, -(PetalT+0.1)*y, PetalSR*8 } }
		translate PetalT/2*y
		texture{ T_Petal }
		scale< 1, 1, 0.7 >
	}

#macro Branches(
		Obj, Seed, Nest, Seg, MinLen
		, BaseLen, RndRatL, ShortenRat
		, BaseAng, RndRatA
		, BaseTwist, RndRatT
		, BaseRot, RndRatR
		//, BlSeed
		, BlLenCond
		, BlOffset, RndRatO
		, BlBaseNum, RndRatB
	)

	#local CurrentL = ( (1-RndRatL)+2*RndRatL*rand(Seed) )*BaseLen;
	#local Twist0 = ( (1-RndRatT)+2*RndRatT*rand(Seed) )*BaseTwist;
	#local BranchW = object{ Obj scale < BaseLen, CurrentL, BaseLen > }
	#local Branch =
		#if( CurrentL <= BlLenCond )
			#local BlNum = ( (1-RndRatB) + 2*RndRatB*rand(Seed) )*BlBaseNum;
			union{
				object{ BranchW }
				#while( BlNum > 0 )
					#local BlNum = BlNum - 1;
					#local Offset = ( (1-RndRatO)+2*RndRatO*rand(Seed) )*BlOffset;
					object{ CherryBlossome
						rotate -90*z
						//translate < Offset, CurrentL*rand(Seed), 0 >
						translate Offset*x
						rotate (120*rand(Seed)-30)*z
						rotate 360*rand(Seed)*y
						translate CurrentL*y
					}
				#end
			}
		#else
			object{ BranchW }
		#end

	#local Cond = false;
	#if( Nest > 0 )
		#if( CurrentL >= MinLen )
			#local Cond = true;
		#end
	#end

	#if( Cond )
		union{
			object{ Branch }

			#local Twist = ( (1-RndRatT)+2*RndRatT*rand(Seed) )*BaseTwist;
			#local SegC = 0;
			#while( SegC < Seg )
				#local Ang = ( (1-RndRatA)+2*RndRatA*rand(Seed) )*BaseAng;
				#local Rot = Twist + BaseRot*( SegC + ( (1-RndRatR)+2*RndRatR*rand(Seed) ) );
				object{
					Branches(
						Obj, Seed, Nest-1, Seg, MinLen
						, CurrentL*ShortenRat, RndRatL, ShortenRat
						, BaseAng, RndRatA
						, BaseTwist, RndRatT
						, BaseRot, RndRatR
						//, BlSeed
						, BlLenCond
						, BlOffset, RndRatO
						, BlBaseNum, RndRatB
					)
					rotate Ang*z
					rotate Rot*y
					translate CurrentL*y
				}
				#local SegC = SegC + 1;
			#end
		}
	#else
		object{ Branch }
	#end
#end

#local BranchObj = cone { 0, 0.06, 1*y, 0.05 pigment{ MediumWood } }

#local TreeNest = 6;
#local TreeSeg = 3;
#local BranchMinLen = 100;
#local BranchBaseLen = 1000;
#local BranchBaseAng = 50;
#local BranchBaseRot = 360/TreeSeg;
#local BranchBaseTwist = BranchBaseRot/2;

#local BlossomeLenCond = 200;
#local BlossomeBaseNum = 10;
#local BlossomeOffset = 50;

#declare CherryTree =
	Branches(
		BranchObj, seed(0), TreeNest, TreeSeg, BranchMinLen
		//, Org // , Vec
		, BranchBaseLen, 0.3, 0.6
		, BranchBaseAng, 0.5
		, BranchBaseTwist, 0.3
		, BranchBaseRot, 0.7
		//, seed(0)
		, BlossomeLenCond
		, BlossomeOffset, 0.5
		, BlossomeBaseNum, 0.5
	)

#end
