#ifndef( Rack_inc )
#declare Rack_inc = true;
// Persistence of Vision Ray Tracer Scene Description File
// File: Rack.inc
// Vers: 3.1
// Desc: 
// Date: 2001.04.09
// Auth: Masanori Imazu

// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
//#include "textures.inc"	// Standard Texture definitions
#include "woods.inc"

#include "Blocks.inc"

#local RackW = 1000;
#local RackD = 450;
#local BoardT = 18;

#local T_Rack =
	texture{ T_Wood11
		rotate 90*y
		scale 50
		finish{ phong 0.4 }
	}

#local Board =
	box{ 0, 1 translate < -0.5, -1, 0 >
		scale < RackW, BoardT, RackD >
		texture{ T_Rack }
	}

#local BarLen = 1170;
#local BarBase = object{ Box( BarLen, 27, 60, 5 ) translate -< BarLen, 27, 60 >/2 }
#local CutBox = box{ 0, 1 translate < -0.5, 0, -0.5 > scale < BoardT, 20, 61 > }

#local Bar =
	difference{
		object{ BarBase translate < BarLen/2, 27/2-10, 0 > }
		#local Pitch = 100;
		#local Position = 70/2;
		#while( Position < BarLen )
			object{ CutBox translate Position*x }
			#local Position = Position + Pitch;
		#end
		texture{ T_Rack }
		rotate 90*x
		rotate 90*z
	}

#declare TVHeight = 70/2+18/2+5*100;
#local IWidth = 350;
#declare Rack =
	union{
		object{ Bar translate (-RackW/2+30)*x }
		object{ Bar translate ( RackW/2-30)*x }
		object{ Bar rotate 180*y translate < -RackW/2+30, 0, 450 > }
		object{ Bar rotate 180*y translate <  RackW/2-30, 0, 450 > }
		object{ Board translate < 0, TVHeight, 0> }
		object{ Board translate < 0, 70/2+BoardT/2, 0> }
		object{ Board translate < 0, TVHeight+6*100, 0> }
	}

#end
