#ifndef( ToyCar_inc )
#declare ToyCar_inc = true;
// Persistence of Vision Ray Tracer Scene Description File
// File: ToyCar.inc
// Vers: 3.1
// Desc: 
// Date: 2001.03.26
// Auth: Masanori Imazu

// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
//#include "textures.inc"	// Standard Texture definitions

#local TireDiameter = 100;
#local TireWidth = 40;
#local Tire =
	union{
		torus{
			(TireDiameter-TireWidth)/2, TireWidth/2
			pigment{ Black }
			finish{ phong 0.9 }
		}
		sphere{
			0, 0.5
			scale< TireDiameter/2, TireWidth/10, TireDiameter/2 >
			pigment{ Yellow }
			finish{ phong 0.7 }
			translate TireWidth/2*y
		}
	}

#local Wheelbase = 200;
#local Tred = 180;

#local FenderL =
	blob{
		threshold 0.25
		sphere{ 0.05*z, 0.7, 1 }
		sphere{ 0.95*z, 0.7, 1 }
		scale < TireWidth*2.0, TireDiameter*1.5, Wheelbase >
		translate -TireWidth*0.4*x
	}

#local CarBody =
	difference{
		union{
			object{ FenderL translate Tred/2*x }
			object{ FenderL scale < -1, 1, 1 > translate -Tred/2*x }
			blob{
				threshold 0.1
				sphere{ 0, 0.7, 1 scale < Tred, TireDiameter*1.3, Wheelbase*1.0 > rotate -5*x translate Wheelbase*0.05*z }
				sphere{ 0, 0.7, 1 scale < Tred*1.1, TireDiameter*1.5, Wheelbase*0.8 > translate Wheelbase*z }
				//sphere{ 0, 0.5, 1 scale < Tred, Tred*0.9, Tred*1.5 > rotate 5*x translate < 0, TireDiameter*0.6, Wheelbase*0.6 > }
			}
			intersection{
				#local _TempH = TireDiameter*1.1;
				#local _TempR = 200;
				sphere{ -_TempR*y, _TempR translate  _TempH*y }	// Top
				sphere{  _TempR*x, _TempR rotate -30*z translate < -Tred*0.3, _TempH, 0 > pigment{ Cyan } }	// Right
				sphere{ -_TempR*x, _TempR rotate  30*z translate <  Tred*0.3, _TempH, 0 > pigment{ Cyan } }	// Left
				sphere{  _TempR*z, _TempR rotate  60*x translate < 0, _TempH, -Wheelbase*0.1 > pigment{ Cyan } }	// Front
				sphere{ -_TempR*z, _TempR rotate -60*x translate < 0, _TempH,  Wheelbase*0.3 > pigment{ Cyan } }	// Rear
				translate Wheelbase*0.5*z
			}
		}
		sphere{ <  Tred/2, 0, 0 >, TireDiameter*0.6 }
		sphere{ < -Tred/2, 0, 0 >, TireDiameter*0.6 }
		sphere{ <  Tred/2, 0, Wheelbase >, TireDiameter*0.6 }
		sphere{ < -Tred/2, 0, Wheelbase >, TireDiameter*0.6 }
		box{
			0, -1
			translate < 0.5, 0, 0.5 >
			scale < Tred+TireWidth, TireDiameter/2, Wheelbase*2 >
			translate < 0, -TireDiameter/4, Wheelbase/2 >
		}

		pigment{ Red }
		finish{ phong 0.5 }
	}

#local LightSize = TireWidth/3;
#local HeadLight =
	union{
		intersection{
			sphere{ 0, 1 scale < LightSize, LightSize, LightSize*2 > }
			box{ 0, 1 translate < -0.5, -0.5, 0 > scale LightSize*2 }
			pigment{ Cyan }
		}
		sphere{
			0, 1
			scale < LightSize, LightSize, LightSize/2 >
			pigment{ White }
			finish{ ambient 0.5 }
		}
		finish{ phong 0.6 }
	}

#declare ToyCar =
	union{
		object{ CarBody }

		object{ HeadLight translate <  Tred*0.3, TireDiameter*0.3, -TireDiameter*0.9 > }
		object{ HeadLight translate < -Tred*0.3, TireDiameter*0.3, -TireDiameter*0.9 > }

		object{ Tire rotate -90*z translate <  Tred/2, 0, 0 > }
		object{ Tire rotate  90*z translate < -Tred/2, 0, 0 > }
		object{ Tire rotate -90*z translate <  Tred/2, 0, Wheelbase > }
		object{ Tire rotate  90*z translate < -Tred/2, 0, Wheelbase > }

		translate < 0, TireDiameter/2, -Wheelbase/2 >
	}

#end
