/*

  Caracol (Snail)

  Jaime Vives Piqueres, (?)2001.

  IRTC 03-04-2001, topic "FORTRESS".

*/

#version 3.1;

// *** control center ***
#declare use_snail=1;
#declare use_stone=1;
#declare use_sky  =1;
#declare use_terr =1;
#declare use_blur =1;

global_settings{
 max_trace_level 20
}
#include "colors.inc"
#include "textures.inc"
#include "stones.inc"

// *** terrain ***
plane{y,0
 hollow
 pigment{DarkGreen}
}
#if (use_terr)
 #declare r_terr=seed(642);
 #declare r_drops=seed(473);
 #declare gota=
 merge{
  sphere{0,1}
  cone{<0,0,0>,1,<0,1.5,0>,.01}
  scale <1,3,1>
  scale .05
  texture{
   pigment{White*.99 filter 0.9}
   finish{Glass_Finish ior 1.1 reflection .2}
  }
 }
 #declare leaf=
// cylinder{<0,0,0>,<0,10+5*rand(r_terr),0>,.1 scale <1,1,.1>
 intersection{
  difference{
   sphere{0,1}
   sphere{0,.995}
  }
  plane{x,0 rotate 6*z translate .1*x}
  plane{x,0 inverse rotate -6*z translate -.1*x}
  plane{y,0 inverse}
  plane{z,0}
  scale <.25,1,.25>
 }
 #declare cnt_grs=0;
 #declare num_grs=1000;
 #declare grass=
 union{
 #while (cnt_grs<num_grs)
  #declare rsc=(15+7*rand(r_terr));
  #declare rrt=30*rand(r_terr);
  union{
   object{leaf
    scale rsc
    pigment{DarkGreen*.5+Gray*.3+Gold*.5*rand(r_terr)+Green*.3}
   }
   #if (rand(r_drops)>0.91)
   object{gota
    rotate -rrt*x
    translate <0,.94,-.07>*rsc
   }
   #end
   rotate rrt*x
   rotate 360*rand(r_terr)*y
   translate <-40+80*rand(r_terr),0,-20+100*rand(r_terr)>
  }
  #declare cnt_grs=cnt_grs+1;
 #end
 }
 object{grass}
#declare ff=.2;
#declare t_leaf=
texture{
 pigment{
  gradient x
  cubic_wave
  turbulence .1
  color_map{
   [0.00 White filter ff]
   [0.01 DarkGreen filter ff]
   [1.00 Bronze filter ff]
  }
 }
 scale 2
}
#declare t_leaf2=
texture{
 pigment{
  bumps
  color_map{
   [0.0 Gray*.1+DarkGreen*.9 filter ff]
   [1.0 ForestGreen*.5+Gold*.25 filter ff]
  }
 }
 finish{Shiny}
 scale 2
}
#declare t_leaf3=
texture{
 pigment{
  gradient x
  cubic_wave
  turbulence .1
  color_map{
   [0.0 DarkOliveGreen filter ff]
   [0.4 DarkOliveGreen filter ff]
   [0.5 Gold filter ff]
   [0.6 DarkGreen filter ff]
   [1.0 DarkGreen filter ff]
  }
 }
 scale 2
}
#declare t_leaf4=
texture{
 pigment{
  bumps
  color_map{
   [0.0 Gray*.2+DarkGreen*.8 filter ff]
   [1.0 Green*.2+Gold*.5 filter ff]
  }
 }
 finish{Phong_Shiny}
 scale 3
}
#include "i_plants.inc"
#declare r_p1=seed(149);
object{achmea_plant2(10,.1,3,4,8,t_leaf,r_p1)
 scale 1.2
 rotate 360*rand(r_p1)*y
 translate <30,0,60>
}
object{hanging_plant3(16,32,90,t_leaf,r_p1)
 scale .7
 rotate 360*rand(r_p1)*y
 translate <0,0,30>
}
#end

// *** sky ***
#if (use_sky)
 sphere{0,1
  hollow
  texture{
   pigment{SummerSky}
   finish{Luminous}
  }
  scale <200000,30000,200000>
 }
 #include "i_sky.inc"
#end

// *** sunlight ***
light_source{
 29000*y
 White*.8+Gold*.4+SkyBlue*.2
 fade_distance 60000
 fade_power 1
 rotate <-40,30,0>
}
light_source{
 -1000*y
 (White*.2+Gold*.1+SkyBlue*.05)*2
 fade_distance 1100
 fade_power 1
 shadowless
}

// *** snail (caracol) ***
#if (use_snail)
 #include "i_snail.inc"
 object{snail
  rotate -40*y
  translate <1,18.7+2.1,-1>
 }
#end


// *** stone ***
#if (use_stone)
 #declare r_stone=seed(48);
 #declare hfstn=
 height_field{
  png "hf_terr"
  translate -.5
  scale <4.1,.5,4.1>
 }
 difference{
  box{-.5,.5 scale 4}
  object{hfstn rotate 180*x translate 1.5*y}
  object{hfstn rotate 90*x translate -1.5*z}
  object{hfstn rotate -90*z translate -1.5*x}
  object{hfstn rotate 90*z translate 1.5*x}
  texture{
   T_Stone23 normal{granite 1 scale 2} scale 4
  }
  scale 6
//  rotate -40*y
  translate <0,8,0>
 }
#end

// *** distant mountains ***
#declare t_land=
texture{
 pigment{
  gradient y
  turbulence .1 lambda 3
  color_map{
   [0.0 White]
   [0.07 White]
   [0.1 DarkTan*.1+Gray20]
   [0.3 DarkTan*.1+Gray20]
   [0.35 DarkGreen]
   [1.0 DarkGreen]
  }
 }
 translate .1*y
 scale <.01,1,.01>
}
#declare distant_mount=
height_field{
 png "hf_mount"
 translate -.5
 texture{t_land}
 scale <2000,600,800>
}
object{distant_mount translate <-1000,280,2000>}
object{distant_mount translate <1000,250,2000>}
object{distant_mount rotate 180*y translate <0,350,2500>}
fog{
 color White filter 0.5
 distance 9000
 fog_type 2
 fog_offset .1
 fog_alt 1000
}

// *** LLUVIA ***
#declare gota=
merge{
 intersection{
  sphere{0,1}
  plane{y,0}
 }
 cone{<0,0,0>,1,<0,1.5,0>,.01}
 scale <1,3,1>
 scale .5
 texture{
  pigment{White*.99 filter 0.9}
  finish{Glass_Finish ior 1.1 reflection .2}
 }
}
#declare r_ll=seed(96);
#declare ng=20000;
#declare ig=0;
#while (ig<ng)
 object{gota translate <-1000+2000*rand(r_ll),5000*rand(r_ll),-50+2000*rand(r_ll)>}
 #declare ig=ig+1;
#end
#declare r_violet1 = color rgbf<1.0, 0.5, 1.0, 0>;
#declare r_violet2 = color rgbf<1.0, 0.5, 1.0, 0>;
#declare r_indigo  = color rgbf<0.5, 0.5, 1.0, 0>;
#declare r_blue    = color rgbf<0.2, 0.2, 1.0, 0>;
#declare r_cyan    = color rgbf<0.2, 1.0, 1.0, 0>;
#declare r_green   = color rgbf<0.2, 1.0, 0.2, 0>;
#declare r_yellow  = color rgbf<1.0, 1.0, 0.2, 0>;
#declare r_orange  = color rgbf<1.0, 0.5, 0.2, 0>;
#declare r_red1    = color rgbf<1.0, 0.2, 0.2, 0>;
#declare r_red2    = color rgbf<1.0, 0.2, 0.2, 0>;
difference{
 cylinder{<0,0,-.001>,<0,0,.001>,1}
 cylinder{<0,0,-.002>,<0,0,.002>,.9}
 texture{
  pigment{
   spherical
   color_map {
	[0.000  color r_violet1 filter 0.098 transmit .9]
	[0.100  color r_violet2 filter 0.096 transmit .9]
	[0.214  color r_indigo  filter 0.094 transmit .9]
	[0.328  color r_blue    filter 0.092 transmit .9]
	[0.442  color r_cyan    filter 0.090 transmit .9]
	[0.556  color r_green   filter 0.092 transmit .9]
	[0.670  color r_yellow  filter 0.094 transmit .9]
	[0.784  color r_orange  filter 0.096 transmit .9]
	[0.900  color r_red1    filter 0.098 transmit .9]
   }
   frequency 10
  }
  finish{Luminous}
 }
 scale <2000,1300,.1>
 rotate 10*y
 translate <0,0,1500>
}

// *** camera ***
camera{
 location <4,14,-35>
 right 4*x
 up 3*y
 direction 3*z
 #if (use_blur)
 blur_samples 128
 confidence .99
 variance 1/256
 aperture 1
 focal_point <1,20.8,-1>
 #end
 look_at <1.1,20.81,-1.1>
}
