#version unofficial megapov 0.6;


//===================================
//===================================
//	SCENE OPTIONS
//===================================
//===================================

// media settings
#declare Use_media = off;
#declare Med_int = 2;
#declare Med_samp = 80;
#declare Med_thre = .1;
#declare Med_conf = .80;
#declare Med_var = 1/100;

// area_light settings
#declare Use_area = off;
#declare Nb_area1 = 6;
#declare Nb_area2 = 6;
#declare Adap_area = 2;

// radiosity settings
#declare Use_rad = on;
#declare Rad_count = 200;
#declare Rad_error = .05;
#declare Rad_rec = 1;
#declare Rad_bright = 1.0;


#declare Use_Iso = on;
#declare Limite_Iso = 30;
#declare Use_Birguit = on;
#declare Use_Robert = on;
#declare Sea_Surf = 2;
#declare Use_Radeau = off;

#declare Pos_Machin1 = <-1.8, 0, -4>;
#declare Pos_Machin2 = <3, 0, 1>;
#declare Use_Iso_Mines = on;
#declare Use_Mines = on;

#declare Zoom = 0;


//===================================
//===================================
//	SETTINGS
//===================================
//===================================
global_settings {
	max_trace_level 30
	adc_bailout 0.1
#if (Use_rad)
	ini_option "+QR"
//	assumed_gamma 1.5
	radiosity{
		count Rad_count
		nearest_count 3
		error_bound Rad_error
		recursion_limit Rad_rec
		brightness Rad_bright

		pretrace_start  .1
		pretrace_end  .005

		low_error_factor .5
		gray_threshold 0.3
		minimum_reuse 0.015
		normal on

		max_sample 1
		adc_bailout 0.1
	}
	//ambient_light 0.0
#end
}

#if (Use_rad=off)
light_source { <-0.7, .9, -8>*2 color rgb <.8,1,.9>*.5 shadowless }
#end

/* rad */
#default { texture { finish { ambient -.1 diffuse 1.1 } } }
/* no rad */
//#default { texture { finish { ambient .3 diffuse .7 } } }


//===================================
//===================================
// LIGHTS, SKY, FOG, ...
//===================================
//===================================

#declare Nuages = pigment {
	bozo
	warp { turbulence <.7, .3, .3>*2 lambda 9 }
	scale 2 
	warp { turbulence <.7, .3, .3>*1.5 lambda 8 }
	scale 2 
	warp { turbulence <.7, .3, .3> lambda 7 }
	scale <.15,.03,.15>*.05
	pigment_map {
		[.6 rgb <.90, 1, .95>*.98 ]
		[.8 rgb <.90, 1, .95>*.93 ]
	}
}


#declare Sky0 = pigment {
	pigment_pattern {
		bozo
		warp { turbulence .6 lambda 6 }
		scale 2 
		warp { turbulence .3 lambda 7 }
		scale 2 
		warp { turbulence .7 lambda 7 }
		scale <.05,.01,.05>*.4
		color_map {[0 rgb 0][1 rgb 1]}
	}
	pigment_map {
		[.6 rgb <.83, .97, .92>*.95 ]
		[.8 Nuages ]
	}
}

#declare Sky1 = pigment {
	pigment_pattern {
		bozo
		warp { turbulence .6 lambda 6 }
		scale 2 
		warp { turbulence .3 lambda 7 }
		scale 2 
		warp { turbulence .7 lambda 7 }
		scale <.05,.01,.05>*.4
		color_map {[0 rgb 0][1 rgb 1]}
	}
	pigment_map {
		[.6 rgb <.83, .97, .92>*.9 ]
		[.8 Nuages ]
	}
}

#declare Sky2 = pigment {
	pigment_pattern {
		bozo
		warp { turbulence .5 lambda 6 }
		scale 2 
		warp { turbulence .5 lambda 7 }
		scale 2 
		warp { turbulence .5 lambda 7 }
		scale <.1,.05,.1>*.4
		color_map {[0 rgb 0][1 rgb 1]}
	}
	pigment_map {
		[.4 rgb <.45, .9, .6>*.8 ]
		[.6 Nuages ]
	}
}

sky_sphere {
	pigment {
		gradient y
		pigment_map {
			[.00 Sky0 ]
			[.02 Sky1 ]
			[.20 Sky2 ]
			[.50 color rgb <.45, .9, .6>*.8 ]
		}
		//rotate y*60
	}
}


fog {
	fog_type 2
	fog_alt 2
	color rgbt <.83*.8, .97*.8, .92*.8, .2>
	distance 80
	turbulence .5
}


light_source { y*100000 color rgb <1,.80,.50>*1.1 rotate x*40 rotate y*45 }

#switch (Zoom)
#case(1)
camera {
	location <-0.7, .9, -10>
	right x*350
	up y*500
	angle 7
	look_at <-1.5, 1.1, -4>
}
#break
#case(2)
camera {
	location <-0.7, .9, -10>
	right x*500
	up y*250
	angle 10
	look_at <-1.4, 0.2, -2.5>
}
#break
#else
camera {
	location <-0.7, .9, -9>
	right x*800
	up y*400
	angle 52
	look_at <1, 1.2, 20>
}
#end
//===================================
//===================================
// SEA ...
//===================================
//===================================

#include "sea_surface.inc"

#declare RMF = function { "ridgedmf", <1, 1.5, 5, 1.0, 0.6> } 

sphere {
	0, 10000
	#switch (Sea_Surf)
	
		#case (0)
			pigment { color rbg <.4, 1, .7> }
		#break
		
		
		#case (1)

		texture {
			pigment { color rgbt <.95,.95,1,.7> }
			normal {
				average
				normal_map {
					[1 function { RMF } bump_size 2.0 scale <.7, 1, 1>*.7 rotate y*40 ]
					[1 wrinkles 2.5  scale 0.5 ]
					[1 granite  1.0  scale 0.2 ]
				}
			}
			finish {
				ambient 0 diffuse 0.2
				//reflection_type 1
				reflection_max .5
				reflection_min .0
				reflection_falloff 0.5
				reflect_metallic
				conserve_energy
				//specular .1 roughness .02 metallic
			}
		}
		interior {
			ior 1.1
			fade_color <.8, .8, .8>
			fade_distance 10
			fade_power 1000
		}
		#break
		
		#case (2)
		
			texture { sea_surface }
		
		#break
	#end
		
	translate -10000*y
}


sphere {
	0, 9500
	texture {
		pigment { rgb 1 }
		finish { ambient .5 diffuse 0 }
	}
	translate -9500*y
}

//===================================
//===================================
// MACHIN
//===================================
//===================================


#declare Machin0 = union {
	cylinder { -2*y, 1.5*y, .35 }
	cylinder { 1.48*y, 1.52*y, .37 }
	union { 
		#local i=0;
		#while (i<(3/.2))
			box { <0, .1, -.35*.35>, <0.38, .3, .35*.35> }
			#local i=i+1;
		#end
		scale <1, .2, 1>
		translate -2*y
	}
	texture {
		pigment { rgb 1 }
		normal { bumps .2 scale .05 }
		finish { phong .2 phong_size 20 }
	}
	texture {
		pigment {
			planar
			warp { turbulence .3 octaves 2 }
			scale 2
			warp { turbulence .3 octaves 2 }
			scale <.1, .25, .1>
			color_map {
				[0.2 color rgbt<0, 0, 0, 1>]
				[0.7 color rgbt<.4, .3, .2, .7>]
				[1.0 color rgbt<.3, .5, .2, .5>]
			}
		}
	}
}


#if (Use_Iso)

#declare Bfun = function {
	pigment { wrinkles scale .1
		color_map { [0 rgb 0][1 rgb 1] }
	}
}

#declare Marches = function {
	pigment {
		pigment_pattern {
			function { if(x, 1, 0) }
			pigment_map {
				[0.5 planar rotate x*90 scale <1,1,.35> ]
				[0.5 rgb 0]
			}
		}
		pigment_map {
			[0.55 color rgb 0 ]
			[0.70 gradient y scale <1, .2, 1> translate -2*y color_map { [0.08 rgb 0][0.1 rgb 1][0.3 rgb 1][0.32 rgb 0] } ]
		}
	}
}


#declare Machin1 = union {
	isosurface { function { x*x + z*z - .35*.35  + .02*Bfun(x, y, z) - .025*Marches(x,y,z) }
		threshold 0
		//max_gradient 8.0
		eval
		contained_by { box { <-.38, -2, -.38>, <.38, 1.5, .38> } }
	}
	isosurface { function { x*x + z*z - .37*.37  + .02*Bfun(x, y, z) }
		threshold 0
		max_gradient 1.1
		contained_by { box { <-.38, 1.48, -.38>, <.38, 1.52, .38> } }
	}
	texture {
		pigment { rgb 1 }
		finish { phong .2 phong_size 20 }
	}
	texture {
		pigment {
			planar
			warp { turbulence .2 octaves 2 }
			scale 2
			warp { turbulence .2 octaves 2 }
			scale <.1, .25, .1>
			color_map {
				[0.2 color rgbt<0, 0, 0, 1>]
				[0.7 color rgbt<.4, .3, .2, .7>]
				[1.0 color rgbt<.3, .5, .2, .5>]
			}
		}
	}
}

#else
    
#declare Machin1 = object { Machin0 }
    
#end


//===================================
//===================================
// MACHIN
//===================================
//===================================

#local st = seed(4321);
#local st2 = seed(1234);

#local i=8;
#while (i<600)
	#local j=-(i+6)*2;
	#while (j <(i+7)*2)
		#local dep = i -3+6*rand(st);
		#local ht = .2*rand(st); 
		object { #if (i>Limite_Iso) Machin0 #else Machin1 #end
			rotate y*1234*rand(st2)
			translate <j, ht, dep>
			translate -y*10000*(1-sqrt(1-pow(dep/10000,2)))
		}
		#local  j = i/10 + j + 15 + 8*rand(st);
	#end
	#local i = i+10 + i*.1;
#end


object {
	Machin1
	rotate -y*160
	translate Pos_Machin1
}
#if (Use_Birguit)
#include "Birguit.inc"
object {
	Birguit
	rotate -y*91
	translate <.220, .682, 0>
	rotate -y*19
	translate Pos_Machin1 +.5*y
}
#end

object {
	Machin1
	rotate -y*30
	translate Pos_Machin2
}
#if (Use_Robert)
#include "Robert.inc"
object {
	Robert
	rotate y*50
	translate Pos_Machin2 + 1.5*y
}
#end


//===================================
//===================================
// RADEAU
//===================================
//===================================
#if (Use_Radeau)

#include "radeau.inc"

object {
	Radeau
	scale .65/3
	rotate -y*50
	rotate -x*1.5
	translate <-1.4, 0, -2.8>
}

#end


//===================================
//===================================
// MINES
//===================================
//===================================

#if (Use_Mines)

#include "mines.inc"

#local Rayon = 1;
#local rd = seed(1234);

#while (Rayon < 6)
	#local j = 0;
	#while (j<320)
		#local j=j+(40+30*rand(rd))/max(1, min(Rayon*.7, 6));
		#local pos = <Rayon+1*rand(rd), -.02+.03*rand(rd), 0>;
		#local pos = vaxis_rotate(pos, y, j);
		#if ((pos.x > -10) & (pos.x < 20) & (pos.z > -6))
		object {
			TeteMine
			rotate x*1234*rand(rd)
			rotate z*1234*rand(rd)
			texture{ txtMine rotate y*1234*rand(rd) translate <20*rand(rd), 0, 20*rand(rd)>}
			scale .20
			translate pos
			translate Pos_Machin1
			translate -y*10000*(1-sqrt(1-pow((pos.z+Pos_Machin1.z)/10000,2)))
		}
		#end
	#end
	#local Rayon = Rayon + 1;
#end

#end
