/*
Sea Surface
turbulent crackle
by Tek

This defines various component parts as well as a sea texture, allowing hf.pov to use the same texture as the bump map.
Cool eh?
*/


#version unofficial megapov 0.7;


#declare sea_pigment = 
	pigment {
		//very dark green. That's what colour deep sea is without the reflection.
		rgb <0.00, 0.15, 0.10> //note: NOT see thru, 'cause there's nothing to see under it.
	}


#declare BUMPS = 0;
#declare HEIGHT = 1;

#macro sea_height(bump_or_height)
	#if (bump_or_height = HEIGHT)
		crackle
	#else
		crackle 0.6*3
	#end
	scale 0.2
	poly_wave 1.5
  warp
  {
		turbulence 0.7
	}
	scale 20.0
  warp
  {
		turbulence 0.3
	}
	scale 0.25
#end


#declare sea_normal = 
	normal {
		sea_height(BUMPS)
	}


#declare sea_finish = 
	finish {
		reflection_max 0.7
		reflection_min 0.1
		specular 0.8 roughness 0.001
	}



#declare sea_surface = 
	texture {
		pigment { sea_pigment }
		normal { sea_normal }
		finish { sea_finish }
		scale <2,1,1>/3
	}
	

#declare hf_region = 40; //a 40m square region will be on the height field.
	                                                                              
	                                                                              