// IRTC_APRIL 2001 
// Fortress
//
//======================================================================================
#version unofficial MegaPOV 0.7;
//======================================================================================
#declare Med     =1; // Media
#declare Rad     =1; // Radiance 
#declare Hight   =1; // Radiance 

//======================================================================================
#include "colors.inc"	   // Standard Color definitions
#include "textures.inc"	   // Standard Texture definitions
#include "woods.inc"	
#include "stones.inc"	
#include "Metals.inc"	

#include "ColorMapScan.inc"
#declare  m = 1;
#declare cm = 1 /100*m;
#declare mm = 1/1000*m;
#declare RD=seed(126);

//==GLOBAL===================================================================================
global_settings {
assumed_gamma 1.8 ambient_light 0.0
//post_process { find_edges {  1, .3, .15, 1, 1.0, rgb 0}}

//ini_option "+h512 +w256 -a"
//ini_option "+h768 +w384 +a.001 +AM2 +r" // 2
//ini_option "+h1280 +w640"

//ini_option "+h320 +w170"  //    -a
//ini_option "+h640 +w320 "//  +qr   +AM2 +r2
ini_option "+h800 +w400 +a.2"// Good?   +qr    +a.001 +AM2 +r2


#if(Rad)
ini_option "+QR"
#if(Hight)
 radiosity {
             pretrace_start 0.08
             pretrace_end   0.01
             count 50

             nearest_count 10
             error_bound 0.9
             recursion_limit 1

             low_error_factor 0.2
             gray_threshold 0.0
             minimum_reuse 0.015
             brightness 1

             adc_bailout 0.01/2
 }
#else
 radiosity{
    pretrace_start 0.08
    pretrace_end   0.02   
    count 35             // CHANGE range from 20 to 150

    nearest_count 5      // CHANGE range from 3 to 10
    error_bound 1.8      // CHANGE - range from 1 to 3
    recursion_limit 3    // CHANGE
    
    low_error_factor .5  // leave this
    gray_threshold 0.0   // leave this
    minimum_reuse 0.015  // leave this
    brightness 1.005        // leave this
    
    adc_bailout 0.01/2  // CHANGE - use adc_bailout = 0.01 / brightest_ambient_object
    
  }
 #end
#end

}
//==CAMERA==================================================================================== 
#declare Cam01=camera {location <-0,15,-50> up y right x*image_width/image_height look_at <0,10,0> }
#declare Cam02=camera {location <-0,03, -9> up y right x*image_width/image_height look_at <0,10,50> angle 30}
#declare Cam03=camera {location < 3,60,-0> up y right x*image_width/image_height look_at <0,10,0>}
#declare Cam04=camera {location < 3,18,-12> up y right x*image_width/image_height look_at <3,10,50> angle 5}
#declare Cam05=camera {location <.5,16, -9> up y right x*image_width/image_height look_at <0,13,25> angle 10}
#declare CamES=camera {location <.5,18, -9> up y right x*image_width/image_height look_at <0,10,25> angle 10}

camera {CamES}
//==LIGHT====================================================================================
light_source {<40,500,-400> rgb <1,1,1> spotlight radius 1 falloff 20 point_at <3,10,100> media_interaction off}

light_source {<-0,29,0>  rgb <1,1,.98>*0.5  cylinder radius 0.8 falloff 0.8 tightness 3  
      translate  z*8 rotate  y*30  point_at <.0,12,6.5> 
      }
light_source {< 0,29,0>   rgb <1,1,.98>*0.5 cylinder radius 0.8 falloff 0.8 tightness 3 
      translate  z*8 rotate y*30  point_at <.5,11,10> 
      }
#if(!Rad)
light_source {<-0,100,30> rgb <1,1,.98>*.5 shadowless media_interaction off}
light_source {<-0,25,-0> rgb <1,1,.98>*1 media_interaction off}
#end

light_source {<3.5,25,5> rgb <1,1,.98>*.8 
 //  fade_distance 30 fade_power 2 
  // shadowless 
   media_interaction off
   }

light_source {<3.5,8,5> rgb <1,1,.98>*.05 
   fade_distance 5 fade_power 2 
  // shadowless 
   media_interaction off
   }

sky_sphere {pigment {White}}
//plane { y,-20 pigment {Grey} hollow}
//==TEXTURES==================================================================================
#declare BrK_Siz=<3,2.0,10>;
#declare Mortr=.03;
#declare Turb=0.02;
#declare Om=1;
#declare Lmd=1;
#declare Oct=1;

//--Function----------
#declare F0=function{pigment{bumps turbulence 0.1 scale 0.6}}
#declare F1=function{pigment{brick brick_size BrK_Siz mortar Mortr turbulence Turb omega Om lambda Lmd octaves Oct}}//
#declare F2=function{pigment{wood turbulence 0.1 scale .6}}
#declare F3=function{pigment{granite turbulence 0.9 scale .2}}
#declare F4=function{pigment{crackle turbulence 0.9 scale .2}}

//--Pigment----------
#declare P0=pigment { 
                function {F0(x,y,z)*0.5 } 
                color_map {  ColorMapScan ("pierre1",30,.9) }
                turbulence .5 octaves 5 omega .6
        }
//------------        
#declare P1=pigment { 
                  brick   
                  pigment {granite color_map {ColorMapScan ("pierre1", 5,.2) } scale .5}
                  pigment {bumps   color_map {ColorMapScan ("pierre1",20,.9) } turbulence .8 scale .6}  
                  brick_size  BrK_Siz mortar Mortr
                  turbulence Turb omega Om lambda Lmd octaves Oct
}
//------------        
#declare P2=
        pigment {wood
        color_map {ColorMapScan ("bois1",20,.5) }
        turbulence 0.1 scale 0.6 
}
//------------        
#declare P4=pigment {
                  bumps   color_map {ColorMapScan ("pierre1",20,.9) }   
                  turbulence Turb omega Om lambda Lmd octaves Oct
}
#declare P5=pigment {
                  granite color_map {ColorMapScan ("pierre1",20,.9) }   
                  turbulence .002 omega 1 lambda 1 octaves 1
}

//---Normal---------        
#declare N0= normal { function {F0(x,y,z)} scale <1,1,3>}
#declare N1= normal { function {F1(x,y,z)-F3(x,y,z)*.0045}}
//#declare N1= normal { function {F1(x,y,z)-F4(x,y,z)*.005}}
#declare N2= normal { function {F2(x,y,z)-F2(x,y,z)*.09 } scale .6}

//---Finish---------        
#declare Fsh0=  finish { ambient 0.3 diffuse .6  }
#declare Fsh1=  finish { ambient 0.3 diffuse .6  }

//---Texture---------        
#declare T0=texture {pigment { Gray}}
#declare T1=texture { pigment {P1} normal {N1 scale <1,1,20>} finish {Fsh1}}
#declare T2=texture { pigment {P2} normal {N2} finish {Fsh0} scale <.5,.4,1> }

#declare T3=texture {pigment {P4} finish {Fsh0}}
#declare T4=texture {pigment {P4}  normal {N0} finish {Fsh0}}
#declare T5=texture {pigment {P5} }

#declare T_Simple=texture {pigment {SlateBlue}}
//==TOUR====================================================================================
#macro CheminRond(R)
   difference {
    cylinder {<0,-.02,0><0,.05,0>,R}
    cylinder {<0,-.5,0><0,.5,0>,R-.2}
    texture {T2}
   }
#end

#declare CheminRond0=
   union {
      CheminRond(9)
      CheminRond(7.3)
      CheminRond(5.8)
   }
   
#declare CheminRond1=
union {
   #declare i=0;
      #while( i< 360 ) 
         union {   
         box{<-.06,-.06,2.3><.06,.06,-2.3> rotate x*15 translate <0,-.6,-2>}        
         cylinder {<0,0,0><0,0,-4.6>.15  } 
         texture {T2 scale .3 translate x*.05} 
         translate z*10 rotate y*i translate -y*.15 
         }
         #declare i=i+10;
      #end
}

#declare CheminRond2=
   union { 
   #declare i=0;
      #while( i< 359 ) 
         #declare Bt=-4.5-(.08*rand(RD));
         #declare Bt0=-.3-(.20*rand(RD));
         #declare rt=0.5-(1*rand(RD));
         #declare bdf=0.15;
         #declare bdd=0.08;
         prism {
         linear_sweep
         linear_spline
         0,.05,5,<-bdd,Bt><-bdf,Bt0><bdf,Bt0><bdd,Bt><-bdd,Bt>
         texture {T2 scale 1.8 translate i}
         translate z*9.95 rotate z*rt rotate y*i  translate -y*.15// -y*.15
         }
         #declare i=i+2.0;
      #end
    }

#declare CheminRonde=union {
   object { CheminRond0}
   object { CheminRond1}
  object { CheminRond2 translate y*.2}
}
//------------------------------------------------
#declare F_Bumps=function{pigment{bumps turbulence 0.9 scale .2}}
#declare F_Granit=function{pigment{granite turbulence 0.1 scale .6}}

//-------------------------------------------------------------
#macro N_mcr(Tb)
 normal { function {F_Bumps(x,y,z)-F_Granit(x,y,z)*Tb*10 } turbulence 2 scale 0.9}
#end
#declare Seed=seed(13958); 

#macro Pierre1(Scl)
   #local Rnd=.3-(.3*rand(Seed)); 
  // #debug concat(str(Rnd,0,2),"\n")
   #local P_Pierre=pigment {
                     bozo color_map {ColorMapScan ("pierre1",10,.9) }   
                     turbulence 5 omega Rnd lambda 5*Rnd octaves 5
   }
   
#declare T_Pierre=texture {pigment {P_Pierre}}
      isosurface { 
               function {(x^4+y^4+z^4 -.5)}
               threshold 0   
               accuracy .001
               contained_by {box {-1,1}}
              texture {
             T_Pierre  
              //pigment {SlateBlue}
              N_mcr(Rnd)
             finish {ambient .3 diffuse .6}
               }
               scale Scl*.5
}
#end

//-------------------------------------------------------------
#if(1)
#declare PPierre=pigment {
                  granite color_map {ColorMapScan ("pierre1",10,.9) }   
                  turbulence .002 omega 1 lambda 1 octaves 1
}
#declare TPierre=texture {pigment {PPierre} }
#declare Signature=height_field {png "sign4" water_level .001 
    texture {TPierre}
    scale <1,1.2,1>*.6 smooth 
}
#declare TourP=
union {
//---
object {Pierre1 (<1.5,1,1>) translate <0,11,10> rotate y*10}
object {Pierre1 (<1.5,1,1>) translate <0,11,10> rotate y*4.5}
object {Pierre1 (<0.8,1,1>) translate <0,11,10> rotate y*0}
object {Pierre1 (<1.5,1,1>) translate <0,11,10> rotate -y*4.5}
object {Pierre1 (<1.5,1,1>) translate <0,11,10> rotate -y*10}
//---

object {Pierre1 (<1.5,1,1>) translate <0,11.75,10> rotate -y*6}
object {Pierre1 (<1.5,1,1>) translate <0,11.75,10> rotate y*0}
object {Pierre1 (<1.0,1,1>) translate <0,11.75,10> rotate y*4}
object {Pierre1 (<1.5,1,1>) translate <0,11.75,10> rotate y*8}

//-----
object {Pierre1 (<1.5,1,1>) translate <0,12.40,10> rotate y*10}
object {Pierre1 (<1.0,1,1>) translate <0,12.40,10> rotate y*4}
object {Pierre1 (<0.8,1,1>) translate <0,12.40,10> rotate y*0}
object {Pierre1 (<1.0,1,1>) translate <0,12.40,10> rotate -y*4}
object {Pierre1 (<1.5,1,1>) translate <0,12.40,10> rotate -y*10}
//----
object {Pierre1 (<2.0,1,1>) translate <0,13.00,10> rotate  y*9}
object {Pierre1 (<2.0,1,1>) translate <0,13.00,10> rotate y*00}
object {Pierre1 (<2.0,1,1>) translate <0,13.00,10> rotate -y*9}
//-*-*-*-*-*-*-*-*
object {Pierre1 (<1.0,.7,1>) translate <0,13.60,10> rotate -y*8}
object {Pierre1 (<1.3,.7,1>) translate <0,13.60,10> rotate  y*8}
object {Pierre1 (<1.5,.7,1>) translate <0,14.00,10> rotate -y*8}
object {Pierre1 (<1.5,.7,1>) translate <0,14.00,10> rotate  y*8}
object {Pierre1 (<0.8,1.5,1>) translate <0,14.80,10> rotate -y*7}
object {Pierre1 (<0.8,1.5,1>) translate <0,14.80,10> rotate  y*7}
object {Pierre1 (<1.5,1.5,1>) translate <0,14.80,10> rotate  y*12}

object {Pierre1 (<1.2,1.5,1>) translate <0,15.80,10> rotate  -y*7.5}
union {
difference {
object {Pierre1 (<1.4,1.5,1>) }
object {Signature  rotate -x*90 rotate z*20 translate <-.1,-.3,.25> }
}
object {Pierre1 (<1.4,1.5,1>) translate <0,0,0.02> }
translate <0,15.80,9.9> 
rotate   y*8.5
}
object {Pierre1 (<0.0,.7,1>) translate <0,16.60,10> rotate -y*8.5}
object {Pierre1 (<1.3,.7,1>) translate <0,16.60,10> rotate  y*8.5}
//-*-*-*-*-*-*-*-*
object {Pierre1 (<2.5,.7,1>) translate <0.0,13.6,10>}
//-----Meutriere
object {Pierre1 (<.6,1.6,1>)  rotate  y*20 translate <-0.,14.50,10>  rotate -y*3.5}
object {Pierre1 (<.6,1.6,1>)  rotate  y*20 translate <-0.,15.70,10>  rotate -y*3.5}

object {Pierre1 (<.6,1.75,1>) rotate -y*20 translate <0.0,14.55,10> rotate  y*3.5}
object {Pierre1 (<.6,1.5,1>)  rotate -y*20 translate < 0.,15.80,10>  rotate  y*3.5}
//------
object {Pierre1 (<2.7,.75,1>) translate <0.0,16.6,10> }

//---
object {Pierre1 (<1.5,1,1>) translate <0,17.20,10> rotate y*10 }
object {Pierre1 (<1.5,1,1>) translate <0,17.20,10> rotate y*4.5}
object {Pierre1 (<0.8,1,1>) translate <0,17.20,10> rotate y*0}
object {Pierre1 (<1.5,1,1>) translate <0,17.20,10> rotate -y*4.5}
object {Pierre1 (<1.5,1,1>) translate <0,17.20,10> rotate -y*10}
//---
}
#end
//---FIN_MUR

//-------------------------------------------------------------
#declare Tour0=
difference {
cylinder {  y*-0,y*30,10.1}
cylinder {  y*.1,y*32,09.75}
texture{T_Grnt18}
}
//---------------------
#declare Tour=
union {
 cylinder {<0,0,0><0,.1,0>10}
 cylinder {<0,30,0><0,30.1,0>10}
 object {TourP}

difference {
object {Tour0}
box {<-.5,-1,-2><.5,3,2> translate <0,14,10>}
}

object {CheminRonde translate <0,12.5,0>}

texture{pigment {Grey}}
hollow
}

//=======================================================================================
#declare Container=cylinder {<0,0,><0,1,0>1 }
#declare Poussiere=
object {Container pigment {White transmit 1 }
interior { 
          media {   intervals 2
                    samples 1,20
                    method 2    
                    scattering {3,White*.08 extinction .1}
                      } 
      }
                      
hollow
}

//=======MEDIA_FLAMME=============
                            
//==Pieces===============================================================================

#declare Fou=merge {
lathe{
	cubic_spline
	6,
	<0.000000,0.963564>,
	<0.056680,1.001351>,
	<0.132254,0.925777>,
	<0.075574,0.491229>,
	<0.264508,0.000000>,
	<0.075574,-0.094467>
	scale <3.5,3,3.5>
}
sphere {0,.2 translate y*4}
cylinder {<0,0,0><0,0.1,0>.8}
difference {
sphere {0,.6  }
box{<0,-.2,-1><.15,1,1> rotate  -z*120 translate y*.3}
scale <1.1,1.5,1.1>
translate y*3.1
}
texture {T_Stone23 rotate z*-50}  
}
//====================================================================
#declare L=16.2;
#declare l=18.2;
#declare Jeux_Echec=
union {
difference {
box {<-l,0,-l><l,.05,l> }
box {<-L,-1,-L,><L,1,L> }
texture {T_Chrome_2D}
}
box {<-L,0,-L,><L,.05,L> 
texture { 
      checker 
      texture{T_Stone10 rotate y*8},texture{T_Stone9 } 
      scale <1,1,2>*1.8 translate z*2}
      
}
translate <1,10,L+15>
}
//==PLACEMENT=========================================================
object {Tour}
#if(Med)object {Poussiere scale 20 hollow}#end

union {
object {Fou scale .8 rotate y*20 translate <0,10,35>}
object {Jeux_Echec}
translate <-.8,0,0> 
 }
plane {y,9.5 texture{T_Wood35 scale 100 rotate y*45} }
//======================================================================================
