
#declare theMap =
color_map {
    [0.0 rgb <1.0, 1.0, 1.0>]
    [0.5 rgb <0.5, 0.5, 0.5>]
    [1.0 rgb <0.0, 0.0, 0.0>]
}

#declare theTexture=texture{ pigment {
    ripples 
    // turbulence 1
    color_map { theMap }
} scale 2}

#declare elTexture=texture {pigment {colour Green}}

#macro letter(siz)
    text { ttf "arial.ttf"
    #alternative (rand(random_stream))
        #case (0.2) "A" 
        #case (0.2) "B" 
        #case (0.2) "C" 
        #case (0.2) "D" 
        #case (0.2) "E"
    #end
    siz, 0.5 
    texture { pigment { color rgb <0.8,0.8,0.4> }} 
    translate <0,-0.5,0>
    scale 0.125
    }
/*
    sphere {
        <0,0,0>, size
        texture { pigment {colour Green} }
//        texture { pigment {colour Green*layoutColor} }     
//        scale <1,layoutColor.red*3,1>
    }
*/
#end

#macro carrot(siz)
box {
    -siz/2,
    siz/2
    texture { pigment {color <0.9,0.2+rand(random_stream)*0.35,0.03> } }
}
#end

#macro parsley(siz)
#declare i=0;
union {
#while (i < 30)
cone {
   <0,0,0> (0.5+rand(random_stream))*siz/24
   <0,siz*(0.5+rand(random_stream)/2),0> (0.5+rand(random_stream))*siz/44
   rotate x*(rand(random_stream)-0.5)*90
   rotate z*(rand(random_stream)-0.5)*90
}
#declare i=i+1;
#end
sphere {
   <0,0,0> siz/7
}
   texture { pigment {color <0.1,0.3+rand(random_stream)*0.35,0.1> } }
}
#end

#macro soupElement(siz)
    object {
        #alternative (rand(random_stream))
            #case (0.86) letter(siz)
            #case (0.08) carrot(siz)
            #case (0.06) parsley(siz)
        #end
        rotate x*360*rand(random_stream)
        rotate y*360*rand(random_stream)
        rotate z*360*rand(random_stream)
    }
#end

#declare theSphere=
    sphere {
        <0,1,0> 1.5
    }

#declare AreaToFill=
intersection {
    object {
        theSphere
    }
    cylinder {
        <0,0,0> <0,0.3,0> 5
    }
    scale <0.922,1,0.922>
    texture {
         normal { ripples scale <0.2,3,0.2> translate <0.5,0,-0.25> }
         pigment {colour rgbt <1.0,0.8,0.2,0.7>} 
    }
    interior {ior 1.4 fade_distance 0.1 media {samples 5,5}}
}

//#declare layoutColor=rgb<0,0,0>;

#declare random_stream = seed(1);

//object {parsley(1)}


#declare theLayout=
layout {
    object{AreaToFill scale <0.95,0.98,0.95>}// texture {theTexture}}
    layout_inside
    layout_random_stream random_stream
#if (the_soup_easy>0)
    layout_count 15 //15000
#else
    layout_count 1500 //15000
#end
    layout_size 0.07
    layout_distance 0.02
    "soupElement"
}

#declare spoonArraySize=16;
#declare spoonArray=array[spoonArraySize]
/* {
    <0,0.0,0.16>,
    <0,0.07,0.23>,
    <0,0.1,0.30>,
    <0,0.1,0.43>,
    <0,0.06,0.63>,
    <0,0.0,0.80>
} 
*/
#declare i=0;
#while (i < spoonArraySize) 
    #declare spoonArray[i] = <0,sin(2/3*pi*i/spoonArraySize)*0.2,0.15+i/spoonArraySize*0.6>;
    #declare i=i+1;
#end

#declare theSpoon=
union {
    difference {
        sphere {<0,0,0>, 0.2}
        sphere {<0,0.1,0>, 0.2}
        cylinder { <0,0.025,0> <0,2,0> 1}
        scale <0.5,0.2,0.8>
    }
    //cylinder { <0,-0.02,0> <0,0.02,0> 0.08 scale <1,1,2> }
    union {
        #declare i=1;
        #while (i < spoonArraySize) 
            sphere {spoonArray[i] 0.015}
            cylinder {spoonArray[i-1], spoonArray[i] 0.015}
            #declare i=i+1;
        #end
        scale <2,0.6,1>
    }
    /*
    blob{
        threshold 0.3
        #declare i=1;
        #while (i < spoonArraySize) 
            cylinder {spoonArray[i-1], spoonArray[i] 0.015, strength 1.0}
            #declare i=i+1;
        #end
        sturm
        scale <2,1,1>
    }
    */
    texture {
        Brushed_Aluminum
        scale 105
    }
    translate z*-0.2
    scale 2.5
    rotate x*-7
    rotate y*118
    translate <0.4,0.2,-0.3>
}

#declare thePlate=
union {
lathe {
    cubic_spline
    10,
    <0,0>, <0,0>, 
    <1,0>, <1.3,0.35>, <1.6,0.4>, <1.6,0.44>, <1.28,0.39>, <1.0,0.05>, 
    <0,0.05>, <0,0.05>
    //sturm
    texture {
        //Glass
        pigment {color rgb <0.82, 0.82, 0.82> }
        finish {
            specular 0.3
            ambient 0.5
            diffuse 0.2
            reflection .25
            roughness .001
        }
    }
}
torus {
    1.6, 0.01
    translate y*0.435
    texture {
        pigment { color rgb <0.1,0.1,0.6> }
    }
}
}

#declare clbr=0.015;
#declare theCloth=
union {
    cylinder { <0,0,0> <0,clbr,0> 2 }
    #declare i = 0;
    #declare ni = 15;
    #while (i < ni)
        cylinder {
            <0,0,0> <0,clbr,0> 0.4 
            translate <1.9,0,0>
            rotate y*360*i/ni
        }
        torus {
            0.4  clbr*0.9
            //rotate x*90
            translate <1.9,0,0>
            rotate y*360*i/ni
            pigment {color Blue}
        }
        #declare i=i+1;
    #end
    texture {
        pigment {color rgb <0.7,0.8,1.0>}
        normal {crackle turbulence 0.5 scale 0.3 bump_size 0.2}
        //finish {diffuse 0.8 ambient 0.2}
    }
}

/*
difference {
object {thePlate}
cylinder { <0,0,0> <0,0,-10> 10 texture {pigment {color Red}}}
}
difference {
object {AreaToFill}
cylinder { <0,0,0> <0,0,-10> 10 texture {pigment {color Blue}}}
} 
*/
#declare theSoup=union {
object {thePlate}
object {theCloth}
//object {theTable}
object {AreaToFill}
object {theSpoon}
//#if (the_soup_easy==0)
object {theLayout}
//#end             
}
