#render "building boat\n"
#ifndef(main_render)

global_settings {
  assumed_gamma 1.6
  max_intersections 350
  max_trace_level 350
}

#declare cam_pos=<0,3,-6>;
#declare cam_tgt=<0,2,0>;

#declare light_pos=<-1000,1500,-1500>;
#declare pen_light=.2;
#declare amb_light=.15;

camera {
  location cam_pos
  up <0,1,0>
  right <4/3,0,0>
  direction <0,0,1.45>
  look_at cam_tgt
}

light_source {
  light_pos
  1-pen_light
}
light_source {
  light_pos
  pen_light
  shadowless
}

#macro flight_spline(_p1,_p2,_p3,_p4,_sc,_ec,_cc)
  #if (_cc<=_sc)
    (_p1)
  #else
    #if (_cc>=_ec)
      (_p4)
    #else
      #local _ci=(_cc-_sc)/(_ec-_sc);
      #local _co=(1-_ci);
      //  p = (p1*co^3)+(3*p2*co^2*ci)+(3*p3*ci^2*co)+(p4*ci^3) 
         ( ( _p1*pow(_co,3) ) + ( _p2*3*pow(_co,2)*_ci ) + ( _p3*3*pow(_ci,2)*_co ) + ( _p4*pow(_ci,3) ) )
    #end
  #end
#end  

#macro rebt(_threshold)
   #declare reb_thresh=_threshold;
   threshold _threshold
#end
//  
#macro reb(_visibleradius,_blobbiness)
   #local _strength = reb_thresh*(1+1/_blobbiness);
   #local _actualradius =_visibleradius/sqrt(1-sqrt(reb_thresh/_strength));
   _actualradius, _strength
#end

#macro flight_array(_pos,_sc,_ec,_cc) // as-per flight spline, but positions passed as a four element array
  #if (_cc<=_sc)
    (_pos[0])
  #else
    #if (_cc>=_ec)
      (_pos[3])
    #else
      #local _ci=(_cc-_sc)/(_ec-_sc);
      #local _co=(1-_ci);
      //  p = (p1*co^3)+(3*p2*co^2*ci)+(3*p3*ci^2*co)+(p4*ci^3) 
         ( ( _pos[0]*pow(_co,3) ) + ( _pos[1]*3*pow(_co,2)*_ci ) + ( _pos[2]*3*pow(_ci,2)*_co ) + ( _pos[3]*pow(_ci,3) ) )
    #end
  #end
#end  

#end

#macro boat_const(_pos,_sca,_rad,_bb,_neg,_st,_col)
  #local _cs = reb_thresh*(1+1/_bb);
  #local _inc=1/_st;
  #local _step=0;
  #while ( _step < 1+(_inc/2))
    #local _tp=(flight_array(_pos,0,1,_step));
    #local _ts=(flight_array(_sca,0,1,_step));
    #local _tr=(flight_array(_rad,0,1,_step));

    #local _cr =_tr/sqrt(1-sqrt(reb_thresh/_cs));
    sphere { 0,_cr,_cs*_neg scale _ts translate _tp 
      #if (_col>0)
        texture { outer_boat_tex rotate <0,90,0> }//translate <0,3,0> }
      #else
        #if (_col<0)
          texture { inner_boat_tex rotate <0,90,0> }//translate <0,3,0> }
        #else
          texture { pale_boat_tex rotate <0,90,0> }//translate <0,3,0> }
        #end
      #end
    }
    #declare boat_blobs=boat_blobs+1;

    #local _step=_step+_inc;
  #end
  
#end

#declare boat_wood_pig=<.3,.2,.05>;
#declare boat_wood_pig=<.5,.4,.2>;
#declare inner_boat_pig=
  pigment {
    color rgb<0,0,0>
  }
#declare outer_boat_pig=
  pigment {
    wood
    sine_wave
    turbulence .05
    color_map {
      [ 0 color boat_wood_pig*2 ]
      [ 1 color boat_wood_pig*1.75 ]
    }
    scale .02
  }
#declare pale_boat_pig=
  pigment {
    wood
    sine_wave
    turbulence .05
    color_map {
      [ 0 color boat_wood_pig*1.25 ]
      [ 1 color boat_wood_pig*.75 ]
    }
    scale .02
  }
  
#declare boat_nor=
  normal {
    bumps -.2
    scale .05
  }
#declare boat_fin=
  finish { 
    ambient amb_light
    diffuse .8
    roughness .8
    specular .2
  }
#declare inner_boat_tex=
  texture {
    pigment { inner_boat_pig }
    normal { boat_nor }
    finish { boat_fin }
  }
#declare outer_boat_tex=
  texture {
    pigment { outer_boat_pig }
    normal { boat_nor }
    finish { boat_fin }
  }
#declare pale_boat_tex=
  texture {
    pigment { pale_boat_pig }
    normal { boat_nor }
    finish { boat_fin }
  }
#declare boat_blobs=0;


#declare boat_hull=
  blob {
    rebt(.5)
    #local _pos=array[4] { <-6,.75,0>,<-2,.4,0>,<2,.4,0>,<6,.75,0> }
    #local _sca=array[4] { <1,.8,1>,<1,1,2>,<1,1,2>,<1,.8,1> }
    #local _rad=array[4] { .21,.42,.42,.21 }
    #local _bb=5;
    #local _neg=1.95;
    #local _st=120;
    boat_const(_pos,_sca,_rad,_bb,_neg,_st,-1)
    #local _pos=array[4] { <-6,.65,0>,<-2,.3,0>,<2,.3,0>,<6,.65,0> }
    #local _rad=array[4] { .27,.54,.54,.27 }
    #local _neg=.32;
    boat_const(_pos,_sca,_rad,_bb,_neg,_st,1)
    
    #local _neg=-1.25;
    #local _bb=5;
    #local _sca=array[4] { <1,.5,2>,<1,.5,2>,<1,.5,2>,<1,.5,2> }
    #local _pos=array[4] { <-6,1,0>,<-2,1,0>,<2,1,0>,<6,1,0> }
    #local _rad=array[4] { .25,.5,.5,.25 }
    boat_const(_pos,_sca,_rad,_bb,_neg,_st,0)
    
    #local _neg=-2.4;
    #local _bb=5;
    #local _pos=array[4] { <-5.9,.77,0>,<-2,.45,0>,<2,.45,0>,<5.9,.77,0> }
    #local _sca=array[4] { <1,.92,1>,<1,.95,1.9>,<1,.95,1.9>,<1,.92,1> }
    #local _rad=array[4] { .2,.45,.45,.2 }
    boat_const(_pos,_sca,_rad,_bb,_neg,_st,0)
    
  }
#declare or_vblock=
union {
  cylinder { <0,0,-.5>,<0,0,1>,.2 texture { pale_boat_tex } rotate <-80,90,0> translate <.75,0,0> }
  cylinder { <0,0,-.5>,<0,0,1>,.2 texture { pale_boat_tex } rotate <-80,-90,0> translate <-.75,0,0> }
  scale .25
}
#declare out_rigger=
  union {
    object { or_vblock translate <2,.6,1.6> }
    object { or_vblock translate <2,.6,-1.6> }
    object { or_vblock translate <-2,.6,1.6> }
    object { or_vblock translate <-2,.6,-1.6> }
    
    object { or_vblock translate <2,.6,-4.5> }
    object { or_vblock translate <-2,.6,-4.5> }
    
    cylinder { <0,0,1.75>,<0,0,-5>,.15 texture { pale_boat_tex } translate <-2,.6,0> }
    cylinder { <0,0,1.75>,<0,0,-5>,.15 texture { pale_boat_tex } translate <2,.6,0> }
    
    box { <-.5,-.0,-1.25>,<.5,.05,1.25> texture { pale_boat_tex rotate <1,1,1> } rotate <0,0,-3> translate <-3.5,.45,0> }
    box { <-.5,-.0,-1.25>,<.5,.05,1.25> texture { pale_boat_tex rotate <1,1,1> } rotate <0,0,3> translate <3.5,.45,0> }
    box { <-.5,-.05,-1.55>,<.5,.05,1.55> texture { pale_boat_tex rotate <1,1,1> } translate <0,.3,0> }
    
    blob {
      rebt(.5)
      #local _pos=array[4] { <-4,.1,0>,<-2,0,0>,<2,0,0>,<4,.1,0> }
      #local _sca=array[4] { <1,.5,.3>,<1,1,1>,<1,1,1>,<1,.5,.3> }
      #local _rad=array[4] { .08,.1,.1,.08 }
      #local _bb=5;
      #local _neg=.75;
      #local _st=120;
      boat_const(_pos,_sca,_rad,_bb,_neg,_st,0)
      translate <0,.3,-4.5>
    }
  }
#declare boat=
  union {
    object { boat_hull }
    object { out_rigger }
    scale 1.25
  }      
#ifndef(main_render)

object { boat
  scale .5
  rotate <-10,-30,10>
  translate <.5,2,0>
}


plane { -z,0 texture { pigment { color rgb<1,1,1> } } translate <0,0,20> }
plane { y,0 texture { pigment { color rgb<1,1,1> } } }
#end

#render concat("Total boat blob component count = ",str(boat_blobs,0,0),"\n")