  #include "colors.inc"
  #include "stones.inc"
  #include "textures.inc"

//Front Gate +++++++++++++++++++++++++++++++++++++++++
#declare keyStone = 
 difference {
  difference {
    difference {
        cylinder 
        { <0,0,0> <0,2.2,0> 4
        }
        cylinder 
        { <0,-0.1,0> <0,2.3,0> 2.9
        }
    }
    box 
    { <-5,-0.1,-4> 
      <5,2.3,0>
      rotate y*75.5
    }
  }
  box 
  { <-5,-1,-4> 
    <5,2.3,0>
    rotate y*-75
  }
 }
#declare arcStone = difference {
    difference {
        difference {
            cylinder { <0,0,0> <0,2.2,0> 4 }
            cylinder { <0,-0.1,0> <0,2.3,0> 2.9 }
        }
        box { <-4.1,-0.1,-4> 
            <4.1,2.3,0>
            rotate y*75.5
        }
    }
    box { <-4.1,-1,-4> 
        <4.1,2.3,0>
        rotate y*-90
    }
}
#declare arch = union {
    object { keyStone }
    object { arcStone rotate y*30 }
    object { arcStone rotate y*45 }
    object { arcStone rotate y*60 }
    object { arcStone rotate y*75 }
    object { arcStone rotate y*90 }
    object { arcStone rotate y*-15 }
    object { arcStone rotate y*-30 }
    object { arcStone rotate y*-45 }
    object { arcStone rotate y*-60 }
    object { arcStone rotate y*-75 }
}

#declare aBrick = box { <0,0,-2.2> 
    <1.1,1,0>
    texture { T_Stone12 
        finish {phong .1
            ambient .5
        }
    }
    translate -4*x
}
#declare rBrick = box { <-.1,0,-2.2> 
    <1,1,0>
    texture { T_Stone12 
        finish { phong .1
            ambient .5 
        }
    }
    translate 3*x
}
#declare rod = cylinder {
    <0,-2,0>,     // Center of one end
    <0,4,0>,     // Center of other end
    0.1            // Radius
    texture { Rusty_Iron }
}
#declare cap = cone {
    <0, -2, 0>, 0.11    // Center and radius of one end
    <0, -2.6, 0>, 0    // Center and radius of other end
    texture { Rusty_Iron }
}

#declare bar = union {
    object { rod }
    object { cap }
}

#declare grate = union {
    object { bar }
    object { bar translate x * .5 }
    object { bar translate x * 1 }
    object { bar translate x * 1.5 }
    object { bar translate x * 2 }
    object { bar translate x * 2.5 }
    object { bar translate x * 3 }
    object { bar translate x * -0.5 }
    object { bar translate x * -1 }
    object { bar translate x * -1.5 }
    object { bar translate x * -2 }
    object { bar translate x * -2.5 }
    object { bar translate x * -3 }
    object { rod rotate z * 90 translate x * 1 }
    object { rod rotate z * 90 translate <1,1.5,0> }
    object { rod rotate z * 90 translate <1,4,0> }
    object { rod rotate z * 90 translate <1,-1.5,0> }
}

#declare gate = union {
    object { arch
        rotate x*-90
        texture { T_Stone12 
        finish {phong .1
            ambient .5 
            }
        }
    }
    object { aBrick translate -1*y}
    object { aBrick translate -2*y}
    object { aBrick translate -3*y}
    object { rBrick translate -1*y}
    object { rBrick translate -2*y}
    object { rBrick translate -3*y}
    object { grate }
}

//Corner Towers +++++++++++++++++++++++++++++++++++++++++
#declare aBlock = difference {
    difference {
        lathe { linear_spline 6,<0,0>, <2,0>, <2.1,0.1>, <2.1,0.9>, <2,1>, <0,1> }
        box { <-3,-0.1,0> <3,2.1,3> rotate y * -1 }
    }
    box { <-3,-0.1,0> <3,2.1,3>
        rotate y * 136
    }           
}
#declare aCorner = union {
    object { aBlock }
    object { aBlock rotate y * 45 }
    object { aBlock rotate y * 90 }
    object { aBlock rotate y * 135 }
    object { aBlock rotate y * 180 }
    object { aBlock rotate y * 225 }
    object { aBlock rotate y * 270 }
    object { aBlock rotate y * 315 }
    texture { T_Stone12 }
    finish {phong .1
            ambient .5
    }
}
#declare topLevel = difference {
    difference {
        difference {
            difference {
                difference {
                    object { aCorner scale < 1.1,1,1.1>}
                    cylinder { <0,.5,0> <0,2,0> 1.8}
                }
                box { <-3,.7,-.5> <3,2.1,.5> }
            }
            box { <-3,.7,-.5> <3,2.1,.5> rotate y*90}
        }
        box { <-3,.7,-.5> <3,2.1,.5> rotate y*-40}
    }
    box { <-3,.7,-.5> <3,2.1,.5> rotate y*40}
    texture { T_Stone12 }
    finish { phong .1 ambient .5 }
}

#declare aTower = union {
    object { aCorner }
    object { aCorner 
        translate y * 1 
        rotate y * 22.5
    }
    object { aCorner 
        translate y * 2
    }
    object { aCorner 
        translate y * 3 
        rotate y * 22.5
    }
    object { aCorner 
        translate y * 4
    }
    object { aCorner 
        translate y * 5 
        rotate y * 22.5
    }
    object { aCorner 
        translate y * 6
    }
    object { aCorner 
        translate y * 7 
        rotate y * 22.5
    }
    object { aCorner 
        translate y * 8
    }
    object { aCorner 
        translate y * 9 
        rotate y * 22.5
    }
    object { aCorner 
        translate y * 10
    }
    object { topLevel 
        translate y * 11
    }
}
//Front Tower +++++++++++++++++++++++++++++++++++++++++
#declare aBlock = superellipsoid { <0.2, 0.1>
    scale <1, .5, .5>
    texture { T_Stone12 
        finish {phong .1
                ambient .5
        }
    }
}

#declare cnt = 0;
#declare aRow = union {
    #while (cnt < 20)
        object { aBlock translate x*cnt }
        #declare cnt = cnt + 2;
    #end
}
#declare window1Row = union {
    object { aBlock }
    object { aBlock translate x*2 }
    object { aBlock translate x*4 }
    object { aBlock translate x*6 }
    object { aBlock translate x*10 }
    object { aBlock translate x*12 }
    object { aBlock translate x*14 }
    object { aBlock translate x*16 }
    object { aBlock translate x*18 }
}
#declare window2Row = union {
    object { aBlock }
    object { aBlock translate x*2 }
    object { aBlock translate x*4 }
    object { aBlock translate x*10 }
    object { aBlock translate x*12 }
    object { aBlock translate x*14 }
    object { aBlock translate x*16 }
    object { aBlock translate x*18 }
}
#declare window3Row = union {
    object { aBlock }
    object { aBlock translate x*2 }
    object { aBlock translate x*4 }
    object { aBlock translate x*6 }
    object { aBlock translate x*8 }
    object { aBlock translate x*10 }
    object { aBlock translate x*12 }
    object { aBlock translate x*16 }
    object { aBlock translate x*18 }
}
#declare window4Row = union {
    object { aBlock }
    object { aBlock translate x*2 }
    object { aBlock translate x*4 }
    object { aBlock translate x*6 }
    object { aBlock translate x*8 }
    object { aBlock translate x*10 }
    object { aBlock translate x*16 }
    object { aBlock translate x*18 }
}
#declare cnt = 0;
#declare aWall = union {
    #while (cnt < 10)
        object { aRow translate <0,cnt,0> }
        object { aRow translate <1,cnt+1,0> }
        #declare cnt = cnt + 2;
    #end
    object { window1Row translate y*10 }
    object { window2Row translate <1,11,0> }
    object { window1Row translate y*12 }
    object { aRow translate <1,13,0> }
    #declare cnt = 14;
    #while (cnt < 22)
        object { aRow translate <0,cnt,0> }
        object { aRow translate <1,cnt+1,0> }
        #declare cnt = cnt + 2;
    #end
    object { window3Row translate y*22 }
    object { window4Row translate <1,23,0> }
    object { window3Row translate y*24 }
    object { aRow translate <1,25,0> }
    #declare cnt = 26;
    #while (cnt < 40)
        object { aRow translate <0,cnt,0> }
        object { aRow translate <1,cnt+1,0> }
        #declare cnt = cnt + 2;
    #end
}
#declare outerWalls = union {
    object { aWall } // 1
    object { aWall rotate <0,-90,180> translate <-.5,39,.5> } // 2
    object { aWall rotate y*-90 translate <19.5,0,.5> } // 3
    object { aWall translate <20,0,20> } // 4
    object { aWall rotate y*-90 translate <39.5,0,20.5> } // 5
    object { aWall rotate x*180 translate <20,39,40> } // 6
    object { aWall rotate y*-90 translate <19.5,0,40.5> } // 7
    object { aWall rotate x*180 translate <0,39,60> } // 8
    object { aWall rotate y*90 translate <-.5,0,59.5> } // 9
    object { aWall rotate y*180 translate <-1,0,40> } // 10
    object { aWall rotate y*90 translate <-20.5,0,39.5> } // 9
    object { aWall translate <-20,0,20> } // 12
}
#declare aSlat = box {
    <0,0,0> <1,.05,.5>
    texture { T_Stone36 } // or T_Stone31
    finish { phong .1 ambient .5 }
}
#declare cnt = 0;
#declare slats = union {
    #while (cnt < 30)
        object { aSlat translate <cnt,0,0> }
        #declare cnt = cnt + .5;
    #end
}
#declare cnt = 0;
#declare face = union {
    #while (cnt < 36)
        object { slats translate <0,.05*cnt,.24*cnt> }
        #declare cnt = cnt + 1;
    #end
}
#declare aRoof = union {
    object { face scale 2 rotate x*-45 translate <-21,39,20> }
    object { face scale 2 rotate <-45,180,0> translate <40,39,40> }
}
    
#declare aBuilding = union {
    object { outerWalls }
    object { aRoof }
    object { aRoof rotate y*90 translate <-20,0,40>}
    triangle { <0,39,.6><20,39,.6><10,54,.6> pigment { color rgb <.4,.25,.1> }} // 1
    triangle { <-19.6,39,40><-19.6,39,20><-19.6,54,30> pigment { color rgb <.4,.25,.1> }} // 11
    triangle { <39.6,39,20><39.6,39,40><39.6,54,30> pigment { color rgb <.4,.25,.1> }} // 5
    triangle { <0,39,59.6><20,39,59.6><10,54,59.6> pigment { color rgb <.4,.25,.1> }} // 8
}
//object { aBuilding }
