/*

  --------------------------------------------------
    Persistence Of Vision Ray Tracer version 3.1g
    version unofficial MegaPov 0.7
  --------------------------------------------------
    Entry for the Internet Ray Tracing Competition
  --------------------------------------------------        
    TITLE:     Laberinto
    AUTHOR:    Fernando Correa
    COUNTRY:   Mxico
    EMAIL:     majucatur@yahoo.com
    WEBPAGE:   http://povcorn.sitio.net
    FILE:      fc_laber.pov
    TOPIC:     Fortress
    DATE:      30/04/2001
  --------------------------------------------------

*/

#version unofficial MegaPov 0.7;
#include "colors.inc"
#include "skies.inc"
#include "stones.inc"
#include "readcolor.inc"

/* Posiciones definidas de la cmara */
#declare Loc_Cam     = 7;
/* Selecciones */
#declare Niebla      = yes;   //Indica si se debe o no usar niebla
#declare Niebla_Type = 4;     //Cambia entre los tipos de niebla definidos
#declare Polvo       = yes;   //Indica si se debe o no usar polvo 
#declare Mountains   = yes;   //Trazar Montaas
#declare Trace_Maze  = yes;   //Trazar el laberinto
#declare Trace_Floor = yes;   //Trazar el piso del laberinto
#declare Trace_Death = yes;   //Trazar el esqueleto
#declare Thunder     = no;    //Trazar el rayo.
#declare SkyText     = yes;
#declare Max_True    = 2;     //Nivel mximo donde el laberinto tiene bloques reales
#declare Horizont    = 40;    //Profundidad del laberinto


camera {
    #switch (Loc_Cam)
        #case (1)  //Vista Superior
            location <0, 45, 0>
            look_at <0, 0, 0>
        #break
        #case (2)  //Vista recta por el pasillo
            location <-6, 6, -18>
            look_at <-6, 2.5, 18>
        #break
        #case (3)  //Vista estilizada del pasillo
            location <-5, 5, -14>
            look_at <-7, 2.5, 18>
        #break
        #case (4)  //Vista de altura
            location <0, 100, 0>
            look_at <0, 0, 0>
        #break
        #case (5)  //Vista alta del pasillo
            location <-5, 8, -21>
            look_at <-7, 3, 18>
        #break
        #case (6)  // Vista Extraterrestre
            location <0, 2500, 800>
            look_at <0, 0, 800>
        #break
        #case (7)  // Vista alta del pasillo con menos horizonte
            location <-5, 8, -20.5>
            look_at <-7, 0, 13>
        #break
        #case (8)  // Vista del esqueleto
            location <-5, 3, -13>
            look_at <-7, 0, -10>
        #break
        #case (9)  // Vista de tierra del esqueleto
            location <-5, 0.3, -12>
            look_at <-6, 0, -10>
        #break
        #case (10) // Vista lateral
            location <4000, 7, 700>
            look_at <0,0,600>
        #break      
    #end
}

light_source { <0, 1000, -1000> 
    color Gray20
    shadowless    
}
light_source { <-1000, 1000, 1000> 
    color Gray60
    shadowless 
}

/* Cielo */
#if (SkyText = yes)
    plane { z, 2500
        pigment { //color Blue
            image_map { png "Sky.png" }
            
            scale <4500, 2300, 3000>
            translate 1900*x
        }
        finish { ambient 0.7 }
        
        hollow
        no_shadow
        rotate -40*x
    }
#else
    sky_sphere { S_Cloud4 
        translate 5*y
    }
#end


/* Trazado del Laberinto */

#declare Z_Move = 0.03;
#include "mainmaze.inc"
#include "maze1.inc"
#include "maze2.inc"
 
/* Controles del Laberinto */
#if (Trace_Maze = 1)
#debug "\nComenzando la carga del laberinto..."
#debug concat("\n", str(Horizont,1,0), " niveles de profundidad...")
#declare MCont1 = 0;
#declare MCont2 = -1;

#declare MaxLevel = 1;
#while (MCont1 < Horizont)
    #while (MCont2 <= MaxLevel)
        #if (MCont2 = 0 & MCont1 = 0)
            object { MainMaze 
            }
        #else
            #if (MCont1 > Max_True)
                object { Maze2
                    translate <MCont2*40, 0, MCont1*40>
                }
            #else
                object { Maze1
                    translate <MCont2*40, 0, MCont1*40>
                }
            #end
        #end
        #declare MCont2 = MCont2 + 1;
    #end
    #declare MCont1 = MCont1 + 1;
    #if (MCont1 = 2)
    /* Este paso corrige los bloques intiles */    
    #else
        #if (mod(MCont1,4)=0)
        #else
            #declare MaxLevel = MaxLevel + 1;
        #end
    #end
    #debug concat("\nNivel: ", str(MCont1,1,0))
    #declare MCont2 = -MaxLevel;
#end

#end

/* Plano */
#if (Polvo = 1)
#debug "\nPolvo Presente..."
difference {
    plane { y, -0.03 }
    plane { z, 40*Horizont 
        inverse
    }
    
    pigment { 
        granite
        color_map {
            [0.00 rgbt<0.4314, 0.3961, 0.3098, 0.5>]
            [0.50 rgbt<0.3216, 0.2471, 0.0706, 0.5>]
            [1.00 rgbt<0.2863, 0.2902, 0.2667, 0.5>]
        } 
        scale 0.005
    }
}
#else
#debug "\nPolvo Ausente..."
difference {
    plane { y, -0.2 }
    plane { z, 40*Horizont 
        inverse
    }
    
    pigment { color Gray50 }
}
#end

/* Niebla */
#if (Niebla = yes)
#debug "\nNiebla Presente..."
fog{
    #switch (Niebla_Type)
        #case (1) //Niebla Azul
            color rgbt <0.9, 0.9, 1, 0.4>
        #break
        #case (2) //Niebla Verde
            color rgbt <0.7, 0.8, 0.7, 0.4>
        #break
        #case (3) //Niebla Blanca
            color rgbt <1, 1, 1, 0.4>
        #break
        #case (4) //Niebla Gris
            color rgbt <0.25,0.25,0.25,0.4>
        #break
        #else
            color rgbt 1
            #debug "\nValor de Niebla_Type incorrecto, la niebla no ser trazada..."
        #break        
    #end
    fog_type 2
    fog_alt 1
    fog_offset 5
    distance 60
    turbulence <.15, .15, .15>
    omega 0.35
    lambda 1.25
    octaves 5
}
#else
    #debug "\nNiebla Ausente..."
#end


/* Trazado del piso del laberinto */

#if (Trace_Floor = 1)
    #declare Max_X = 40;    
    #declare Max_Z = 45;
    #declare X_Size = 1;
    #declare Z_Size = 1;
    #declare Y_Size = 0.05;
    #include "piso.inc"
    object { Piso
        pigment { color Gray50 }
        translate <-20.5, -0.025, -20.5>
    }
#end

/* Trazado de las Montaas */

#if (Mountains = 1)
#debug "\nTrazando Montaas..."
/* Consideraciones Previas */
#declare Mount_Distance = 1601;
#if (40*Horizont > Mount_Distance)
    #debug "\nRectificando profundidad de montaas..."
    #declare Mount_Distance = 40*Horizont+1;
#end 

height_field {
    png "mountain.png"
        texture { T_Stone6
            scale 0.0001
        }
        texture { pigment { RGB( 32 , 32 , 32 ) transmit 0.5 } /*rgb <0.25, 0.15, 0.15> }*/ }

       
    scale <1600, 110, 100  >
    //rotate 180*y    
    translate <-1220, 0, Mount_Distance>
}
#end

#if (Trace_Death = 1)
    #debug "\nTrazando el esqueleto..."
    #include "death.inc"
    object { DeathMan 
        rotate <90, 38, 0>
        scale 4.5
        translate <-7, 0.2, -10>
    }
#end

/* Rayo */

#if (Thunder = yes)
    box { <-0.5, 100, 0>, <0.5, 0, 0>
        pigment {
            gradient x
            color_map {
                [0 rgbt <0,0,0,1>]
                [0.45 rgbt <0,0,0,1>]
                [0.5 RGB( 136 , 132 , 248 )]
                [0.55 rgbt <0,0,0,1>]
                [1 rgbt <0,0,0,1>]
            }
            turbulence 0.2
            translate <0.3,2,0>        
        }
    
        finish { ambient 1 }    
        scale 240
        translate <1600,-1,3000>    
    } 
    
#end