
#version official 3.1;
#include "colors.inc"
#include "stones.inc"

#declare Wall = union {
    
    /* Definiciones variables para el muro */
    /*Tabiques*/
    #ifndef (Visel)
        #declare Visel = 0.05;          // Es el redondeado que tendr el tabique
    #end
    #ifndef (X_Size)
        #declare X_Size = 2;            // Unidades en X del tabique
    #end
    #ifndef (Y_Size)
        #declare Y_Size = 1;            // Unidades en Y del tabique
    #end
    #ifndef (Z_Size)
        #declare Z_Size = 1;            // Unidades en Z del tabique
    #end
    
    /*Muro*/
    #ifndef (Length)
        #declare Length = 8;            // Longitud del muro en bloques
    #end
    #ifndef (Height)
        #declare Height = 8;            // Altura del muro en bloques
    #end
    #ifndef (Half)
        #declare Half = 0;              // Indica si el primer bloque del primer rengln inicia con medio bloque o no
    #end
    #ifndef (Z_Move)
         #declare Z_Move = 0.05;        // El mximo movimiento aleatorio que tendrn los tabiques en Z
    #end
    #ifndef (HideSBlock)
        #declare HideSBlock = 0;        // Si se activa borra todos los bloques medios del muro
    #end
    
    /*Textura*/
    #ifndef (Text_Piedra)
        #declare Text_Piedra = texture { T_Stone13 }
    #end
    #ifndef (Spec_Index)
        #declare Spec_Index = 0.01;
    #end
    #ifndef (Roug_Index)
        #declare Roug_Index = 10;
    #end
    #ifndef (Norm_Piedra)
        #declare Norm_Piedra = normal{
            agate 01
            scale 0.3
        }
    #end
    
        
    /* Bloque de 1x1x1 con esq. inf. izq. en <0,0,0> */
    #declare S_Block = superellipsoid { <Visel, Visel>

        scale <X_Size/4, Y_Size/2, Z_Size/2>
        translate <X_Size/4, Y_Size/2, Z_Size/2>
    }
    
    /* Bloque de 2x1x1 con esq. inf. izq. en <0,0,0> */
    #declare D_Block = superellipsoid { <Visel, Visel>

        scale <X_Size/2, Y_Size/2, Z_Size/2>
        translate <X_Size/2, Y_Size/2, Z_Size/2>
    }
    
    /* Definiciones estticas para el muro */
    #declare Cont1 = 1;             //Contador 1, controla las filas de tabiques
    #declare Cont2 = 1;             //Contador 2, controla las columnas de tabiques
    #declare InRan = seed(777);     //Inicializador de nmeros aleatorios
    
    /* Ciclo generador del Muro */
    /* Ciclo externo, columnas*/
    #while (Cont1 <= Height)
        #if (Half = 1)
            #if (mod(Cont1, 2) != 0)
                #if (HideSBlock = 0)  // Si esta opcin est en 0 entonces si traza el bloque
                    object { S_Block
                        texture { Text_Piedra                        
                            scale <rand(InRan)*10+5, rand(InRan)*10+5, rand(InRan)*10+5>
                            translate <rand(InRan)*2, rand(InRan)*2, rand(InRan)*2>
                            rotate <rand(InRan)*360, rand(InRan)*360, rand(InRan)*360>
                        }
                        normal { Norm_Piedra
                            scale (rand(InRan)/2)+0.5
                            translate <rand(InRan)*2, rand(InRan)*2, rand(InRan)*2>
                            rotate <rand(InRan)*360, rand(InRan)*360, rand(InRan)*360>                        
                        }
                        /*finish {
                            specular  Spec_Index
                            roughness Roug_Index
                        } */
                        translate <0, (Cont1-1)*Y_Size, pow(-1, int(rand(InRan)/0.5)+1)*mod(rand(InRan), 0.5)*2*Z_Move>
                    }
                #end
                #declare Cont2 = Cont2 + 1;
            #end
        #else
            #if (mod(Cont1, 2) = 0)
                #if (HideSBlock = 0)  // Si esta opcin est en 0 entonces si traza el bloque
                    object { S_Block
                        texture { Text_Piedra                        
                            scale <rand(InRan)*10+5, rand(InRan)*10+5, rand(InRan)*10+5>
                            translate <rand(InRan)*2, rand(InRan)*2, rand(InRan)*2>
                            rotate <rand(InRan)*360, rand(InRan)*360, rand(InRan)*360>
                        }
                        normal { Norm_Piedra
                            scale (rand(InRan)/2)+0.5            
                            translate <rand(InRan)*2, rand(InRan)*2, rand(InRan)*2>
                            rotate <rand(InRan)*360, rand(InRan)*360, rand(InRan)*360>
                        }                    
                        /*finish {
                            specular  Spec_Index
                            roughness Roug_Index
                        } */
                        translate <0, (Cont1-1)*Y_Size, pow(-1, int(rand(InRan)/0.5)+1)*mod(rand(InRan), 0.5)*2*Z_Move>
                    }
                #end
                #declare Cont2 = Cont2 + 1;
            #end
        #end
        /* Ciclo interno, renglones */
        #while (Cont2 <= Length)
            #if (Cont2+1 <= Length)
                object { D_Block
                    texture { Text_Piedra                         
                        scale <rand(InRan)*10+5, rand(InRan)*10+5, rand(InRan)*10+5>
                        translate <rand(InRan)*2, rand(InRan)*2, rand(InRan)*2>
                        rotate <rand(InRan)*360, rand(InRan)*360, rand(InRan)*360>
                    }
                    normal { Norm_Piedra
                        scale (rand(InRan)/2)+0.5
                        translate <rand(InRan)*2, rand(InRan)*2, rand(InRan)*2>
                        rotate <rand(InRan)*360, rand(InRan)*360, rand(InRan)*360>                        
                    }                    
                    /*finish {
                        specular  Spec_Index
                        roughness Roug_Index
                    } */     
                    translate <(Cont2-1)*X_Size/2, (Cont1-1)*Y_Size, pow(-1, int(rand(InRan)/0.5)+1)*mod(rand(InRan), 0.5)*2*Z_Move>
                }
                #declare Cont2 = Cont2 + 2;
            #else
                #if (HideSBlock = 0)  // Si esta opcin est en 0 entonces si traza el bloque
                    object { S_Block
                        texture { Text_Piedra
                            scale <rand(InRan)*10+5, rand(InRan)*10+5, rand(InRan)*10+5>
                            translate <rand(InRan)*2, rand(InRan)*2, rand(InRan)*2>
                            rotate <rand(InRan)*360, rand(InRan)*360, rand(InRan)*360>
                        }
                        normal { Norm_Piedra
                            scale (rand(InRan)/2)+0.5                   
                            translate <rand(InRan)*2, rand(InRan)*2, rand(InRan)*2>
                            rotate <rand(InRan)*360, rand(InRan)*360, rand(InRan)*360>                        
                        }                    
                        /*finish {
                            specular  Spec_Index
                            roughness Roug_Index
                        } */             
                        translate <(Cont2-1)*X_Size/2, (Cont1-1)*Y_Size, pow(-1, int(rand(InRan)/0.5)+1)*mod(rand(InRan), 0.5)*2*Z_Move>
                    }
                #end
                #declare Cont2 = Cont2 + 1;
            #end
        #end
        #declare Cont1 = Cont1 + 1;
        #declare Cont2 = 1;
    #end

    #undef Length
} /* Fin del objeto Wall */