// Persistence of Vision Ray Tracer Scene Description File
// File: LinkGen.Inc
// Vers: 3.1
// Desc: After Declaring ChainBegin and ChainLength, this creates an (almost) fully realistical
//       Chain.
// Date: 6.15.00 
// Auth: Tim Wenclawiak

//Just the Statement that I made this...
#debug "\nLinkGen.inc written by Tim Wenclawiak. Last Update: 6.15.00\n"

/* Default-Setting-Section */
//ChainLink
#ifndef (ChainLink) #declare ChainLink=
merge{intersection{torus{.3,.1 translate z*-.2}box{<-1,-1,-.2>,1}}
cylinder{<.3,0,-.2><.3,0,-.8>,.1}cylinder{<-.3,0,-.2><-.3,0,-.8>,.1}
intersection{torus{.3,.1 translate z*-.8}box{<-1,-1,-.8><1,1,-2>}}pigment{rgb 1}}
#debug "  -No Link declared! Uses Default Link...\n" #end
#ifndef (ChainBegin) #declare ChainBegin=<0,0,0>; #warning "  -No ChainBegin declared! Uses <0,0,0>...\n" #end
#ifndef (ChainLength) #declare ChainLength = 5; #debug "  -ChainLength=Default (5)\n" #end
#ifndef (ChainRot) #declare ChainRot=<0,0,0>; #debug "  -ChainRot=Default (<0,0,0>)\n" #end
#ifndef (ChainScale) #declare ChainScale = 1; #debug "  -ChainScale=Default (1)\n" #end
#ifndef (ChainInitSpin) #declare ChainInitSpin=0; #debug "  -ChainInitSpin=Default (0)\n" #end
#ifndef (TweakLastLink) #declare TweakLastLink=0; #debug "  -TweakLastLink=Default (0)\n" #end
#ifndef (AddLinks) #declare AddLinks = 0; #debug "  -AddLinks=Default (0)\n"#end
#ifndef (KillPrimeLink) #declare KillPrimeLink=off; #debug "  -KillPrimeLink=Default (off)\n" #end
#ifndef (ChainTurb) #declare ChainTurb = off; #debug "  -ChainTurb=Default (off)\n"#end
#ifndef (ChainTurbRot) #declare ChainTurbRot = 20; #debug "  -ChainTurbRot=Default (20)\n"#end
#ifndef (ChainBend) #ifndef (ChainBendTotal) #declare ChainBendTotal = 0; #debug "  -ChainBend=Default (0)\n" #end #end
#ifndef (GenerateChain) #declare GenerateChain=off; #debug "  -GenerateChain=Default (off)\n" #end
#ifndef (DegreeCorrection) #declare DegreeCorrection=off; #debug "  -DegreeCorrection=Default (off)\n" #end
#ifndef (PrimeLinkStraight) #declare PrimeLinkStraight=off; #debug "  -PrimeLinkStraight=Default (off)\n" #end

/* Radius-Setting-Section */
#ifdef (CircleType) #ifndef (Radius) #declare Radius=2; #debug "  -Radius=Default (2)\n" #end #end
#ifdef (Radius) #ifndef (CircleType) #declare CircleType=0; #debug "  -CircleType=Default (0)\n" #end #end
#ifndef (Radius) #ifndef (CircleType) #declare Radius=0; #declare CircleType=0; #end #end

#if (CircleType=90) #undef ChainLength
#debug " *-ChainLength and ChainBendTotal are overriden by Radius!\n"
#declare ChainLength=(2*pi*Radius)/4;
#declare ChainBendTotal=90; #end
#if (CircleType=180) #undef ChainLength
#debug " *-ChainLength and ChainBendTotal are overriden by Radius!\n"
#declare ChainLength=(2*pi*Radius)/2;
#declare ChainBendTotal=180; #end
#if (CircleType=270) #undef ChainLength
#debug " *-ChainLength and ChainBendTotal are overriden by Radius!\n"
#declare ChainLength=(2*pi*Radius)*(3/4);
#declare ChainBendTotal=270; #end
#if (CircleType=360) #undef ChainLength
#debug " *-ChainLength and ChainBendTotal are overriden by Radius!\n"
#declare ChainLength=2*pi*Radius;
#declare ChainBendTotal=360; #end

/* LinkNum-Setting */
#ifdef (LinkNum) #undef ChainScale #undef AddLinks
#declare ChainScale = ChainLength / LinkNum;
#declare AddLinks = 0; #end

//If ChainBendTotal is declared, this will calculate ChainBend using ChainLength and ChainScale.
//Thus, this always has to be placed after all Calculations for ChainScale and -Length
#ifdef (ChainBendTotal) #declare ChainBend=ChainBendTotal/(ChainLength/ChainScale); #end

//The Number of Links is found by simply dividing the length by the Scale and adding
//the AddLinks Value.
#declare LinkNumber=ChainLength/ChainScale+AddLinks;
#debug concat(" There are ",str(LinkNumber,1,0)," Links.\n")

/* ChainEnd-Calculation */
//This is done using a Loop, since the Chain itself is also calculated by a Loop.
#declare ChainEndPro=<0,0,0>; #declare BendCountPro=0;
#while (BendCountPro<LinkNumber)
#declare ChainEndPro=vrotate((y*-ChainScale+ChainEndPro),x*ChainBend);
#declare BendCountPro=BendCountPro+1; #end
//Now, certain Options have to be taken into account:
#if (PrimeLinkStraight=off)
#if (DegreeCorrection=off) #declare ChainEnd=vrotate(ChainEndPro,ChainRot)+ChainBegin; #end
#if (DegreeCorrection=on) 
#declare ChainEnd=vrotate(vrotate(ChainEndPro,ChainRot),x*-ChainBend/2)+ChainBegin; #end #end
#if (PrimeLinkStraight=on)
#declare ChainEnd=vrotate(vrotate(ChainEndPro,ChainRot),x*-ChainBend)+ChainBegin; #end
//And then, we are finished!
#debug concat(" ... ChainEnd successfully calculated!\n")

#declare ChainRand=seed(36728372462);

/* Chain-Calculation */
#if (GenerateChain=on) #declare Chain = union{ #end
//This Chain is a Loop-Sequence, because I simply re-do the whole process for each Link
//again and again...
#declare ChainLinkCount=0; 
#if (KillPrimeLink=on) #declare ChainLinkCount=1; #end
//This has to be done as long as Links (LinkNumber) are left
#while (ChainLinkCount<LinkNumber)
//Place the Link and then Scale it correctly.
object{ChainLink scale ChainScale rotate x*-90
//This is for the Tweak of the Last Link. The first stays unaffected, thus, all but one receive a
//minimal fluctuation in their axis-Spin... Thus, the LinkNumber-1!
#if (ChainLinkCount>=1) rotate y*TweakLastLink/(LinkNumber-1)*ChainLinkCount #end
//Rotates the axis by an amount needed for the Perpendicularity and the InitialSpin
rotate y*90*ChainLinkCount rotate y*ChainInitSpin
//The Follow lines add the Randomization process for the Rotation turbulence...
#if (ChainTurb=on)
 #if (ChainLinkCount>0)
  #if (rand(ChainRand)<=.5) rotate y*-ChainTurbRot*rand(ChainRand) #end
  #if (rand(ChainRand)>.5) rotate y*ChainTurbRot*rand(ChainRand) #end
 #end
#end
//...until here. The Turbulence sequence is finished!
//This is the bend Loop. It calculates a move-and-rotate process as often for chain as required by
//the position and "Number" of the Chain
#declare BendCount=-1;
#while (BendCount<ChainLinkCount)
rotate x*ChainBend translate y*-ChainScale
#declare BendCount=BendCount+1; #end
//Here the Bend Loop ends
//We have to move it a bit back, since the BendLoop does it once too far, but cannot be done in an
//other way.
translate <0,ChainScale,0> 
//The Options for DegreeCorrection and PrimeLinkStraight kill each other, while Prime* is stronger...
#if (PrimeLinkStraight=on) 
#if (DegreeCorrection=on) rotate x*-(ChainBend-(ChainBend/2)) #end
#if (DegreeCorrection=off) rotate x*-ChainBend #end #end
#if (DegreeCorrection=on) rotate x*-ChainBend/2 #end
//And then rotate it at the origin of the Chain, and at last move the origin to the position of ChainBegin
rotate ChainRot translate ChainBegin}
//Just check the beginning of the Loop to understand this line.
 #declare ChainLinkCount=ChainLinkCount+1;
//All done!
#end
//In case the Chain shall be an object, we need the closing bracket...
#if (GenerateChain=on) } #debug " Object Chain created. Place with object{Chain}\n" #end

//Now, I am finished...
#debug "Calculations finished. Objects can now be placed at ChainEnd!\n"