// Persistence of Vision Ray Tracer Scene Description File
// File: castle_tex.inc
// Vers: 3.1g
// Desc: The textures for my castle
// Date: 16.5.00
// Auth: Florian Kastell
// Updt: 29.04.01


#declare Mortar_Color= rgb<.3, .3, .3>;

#declare Tower_Tex=
texture{pigment{brick Mortar_Color, rgb .9 brick_size<3, 1.5, 3> mortar .15 turbulence .002}normal{gradient y normal_map{[.7 brick brick_size<3, 1.5,3> mortar .15][.8 bumps .3][1.0 crackle .2]}}scale .5 finish{roughness .5}}
texture{pigment{bozo color_map{[.6 rgbf <.37, .13, .15, .5>][1.0 rgbf <.38, .5, .31, .15>]} turbulence 1.2 }finish{roughness .7}}
texture{pigment{bozo color_map{[.6 rgbf <.37, .13, .15, .9>][1.0 rgbf <.47, .41, .44, .15>]}scale .4 turbulence .9 }finish{roughness .7}}

#declare Tower_Tex2=
texture{pigment{brick Mortar_Color, rgb 1 brick_size<3, 1.5, 3> mortar .15 turbulence .002}normal{gradient y normal_map{[.7 brick brick_size<3, 1.5,3> mortar .15][.8 bumps .3][1.0 crackle .2]}}scale .5 finish{roughness .5}}
texture{pigment{bozo color_map{[.6 rgbf <.17, .03, .05, .5>][1.0 rgbf <.18, .25, .21, .15>]} turbulence .9 }finish{roughness .4}}
texture{pigment{bozo color_map{[.6 rgbf <.17, .03, .05, .9>][1.0 rgbf <.27, .21, .24, .15>]}scale .9 turbulence .6 }finish{roughness .4}}

#declare Wall_Mortar_Color= rgb<.3, .3, .3>;

#declare Wall_Tex=
texture{pigment{brick Wall_Mortar_Color, rgb<.9, .9, .9> brick_size<3, 1.5, 3> mortar .15 turbulence .002}normal{gradient y normal_map{[.6 brick brick_size<3, 1.5,3> mortar .15][.8 bumps .3][1.0 crackle .2]}}scale .5 finish{roughness .5}}
texture{pigment{bozo color_map{[.6 rgbf <.37, .13, .15, .5>][1.0 rgbf <.38, .5, .31, .15>]} turbulence 1.2 }finish{roughness .7}}
texture{pigment{bozo color_map{[.6 rgbf <.37, .13, .15, .9>][1.0 rgbf <.47, .41, .44, .15>]}scale .4 turbulence .9 }finish{roughness .7}}


#declare Sky_Tex=
 texture{pigment{bozo turbulence .4 lambda 3.5 octaves 6 omega .5 color_map{[0.0 rgbt 1][0.6 rgbt <1,1,1,.9>][1.0 rgbt <1,1,1,.1>]}}}
#declare Sky_Tex1_a=
 texture{pigment{bozo turbulence .6 lambda 3 octaves 6 omega .5 color_map{[0.0 rgbt 1][0.2 rgbt <.4,.4,0,.9>][0.9 rgbt <.7,.2,.1,.2>][1.0 rgbt <1,.2,.05,.2>]}}}
#declare Sky_Tex1_b=
 texture{pigment{bozo turbulence .6 lambda 3 octaves 6 omega .5 color_map{[0.0 rgbt 1][0.2 rgbt <.2,.2,0,.9>][0.9 rgbt <.5,.1,.05,.2>][1.0 rgbt <.7,.2,.05,.2>]}}}

#declare Ground_Tex1=
 texture{pigment{crackle color_map{[0.0 rgb 0.0][1.0 rgb 0.2]}scale 2 turbulence .08}normal{gradient y normal_map{[0.3 bumps][0.7 crackle]}}finish{roughness .3}}
#declare Ground_Tex2=
 texture{pigment{bumps color_map{[0.0 rgb 0.18][1.0 rgb <.25, .2, .2>]}scale 0.9 turbulence .5}normal{bumps 0.6}finish{roughness .2}}
#declare Ground_Tex3=
 texture{pigment{bozo color_map{[0.0 rgb .2][1.0 rgb <.3, .3, .23>]}scale .8 turbulence .01}normal{gradient y normal_map{[0.0 bumps .8][1.0 crackle 1]}}finish{roughness .3}}
#declare Ground_Tex4=
 texture{pigment{wrinkles color_map{[0.0 rgb .2][0.5 rgb <.5, .5, .4>][1 rgb <.8, .8, .7>]}scale .3 turbulence .001}normal{wrinkles 1}finish{roughness .4}}
#declare Ground_Tex5=
 texture{pigment{wrinkles color_map{[0.0 rgb .95][1.0 rgb 1.0]}scale .3 turbulence .01}normal{bumps 1}finish{diffuse .85 roughness .3}}

#declare Sea_Tex=
 texture{pigment{bozo color_map{[0.0 rgbt <.25, .35, .7, .07>][1.0 rgbt <.15, .25, .8, .07>]}}normal{average normal_map{[0.0 bumps .9][1.0 wrinkles 0.4 scale 0.03]}}finish{phong .01 specular .09 ambient .5 reflection .1}}


/*-------------------------------------Wood_Tex--------------------------------------*/
#declare WoodColor1=
 colour_map {
  [0.00 0.25   color rgb < 0.504, 0.310, 0.078> * 0.7
               color rgb < 0.531, 0.325, 0.090> * 0.8 ]
  [0.25 0.40   color rgb < 0.531, 0.325, 0.090> * 0.8
               color rgb < 0.547, 0.333, 0.090> * 0.5 ]
  [0.40 0.50   color rgb < 0.547, 0.333, 0.090> * 0.5
               color rgb < 0.504, 0.310, 0.075> * 0.6 ]
  [0.50 0.70   color rgb < 0.504, 0.310, 0.075> * 0.6
               color rgb < 0.559, 0.322, 0.102> * 0.4 ]
  [0.70 0.98   color rgb < 0.559, 0.322, 0.102> * 0.4
               color rgb < 0.531, 0.325, 0.086> * 0.4 ]
  [0.98 1.00   color rgb < 0.531, 0.325, 0.086> * 0.4
               color rgb < 0.504, 0.310, 0.078> * 0.7 ]
 }
#declare WoodColor2=
 colour_map {
  [0.00 0.25   color rgbf < 0.404, 0.210, 0.078, 0.30>
               color rgbf < 0.431, 0.225, 0.090, 0.60>]
  [0.25 0.40   color rgbf < 0.431, 0.225, 0.090, 0.60>
               color rgbf < 0.447, 0.233, 0.090, 0.30>]
  [0.40 0.50   color rgbf < 0.447, 0.233, 0.090, 0.30>
               color rgbf < 0.404, 0.210, 0.075, 0.40>]
  [0.50 0.70   color rgbf < 0.404, 0.210, 0.075, 0.40>
               color rgbf < 0.459, 0.222, 0.102, 0.20>]
  [0.70 0.98   color rgbf < 0.459, 0.222, 0.102, 0.20>
               color rgbf < 0.431, 0.225, 0.086, 0.50>]
  [0.98 1.00   color rgbf < 0.431, 0.225, 0.086, 0.50>
               color rgbf < 0.404, 0.210, 0.078, 0.30>]
 }
#declare WoodGrain1=
 pigment{bozo colour_map{WoodColor1}turbulence 0.04 scale <0.02 0.02 1>}
#declare WoodGrain2=
 pigment{wood colour_map{WoodColor2}scale <0.075 0.075 1> turbulence 0.035 rotate <-2, 2, 0>}

#declare Wood_Tex= 
 texture{pigment{WoodGrain1 color_map{WoodColor1}}}
 texture{pigment{WoodGrain2 color_map{WoodColor2}}}

/*----------------------------------Wood_Tex End-------------------------------------*/