//****************************************************
// Tree definition Type ver 0.1r000224a include file
// Persistence Of Vision raytracer version 3.1g
// By S.Nishimura
//****************************************************


// parameter
#local T_r1 = 10; #local T_a1 =  90;          //   0<=degrees<= 90
#local T_r2 = 40; #local T_a2 = -45;          // -90<=degrees<=  0
#local T_r3 = 80; #local T_a3 = 180+T_a2- 5;  //   0<=degrees<=180+T_a2
#local T_w0 = 1;  #local Ground_level = 0;
#include "Twig_typeA.def.inc"
//
#include "Leaf_typeA.def.inc"
coordinate_color(30,1,0.5,1,1) // leaf color
#local Twig =
union {
 object { Twig_seg rotate < 0, 2.8, 2.8 > }
 object { Leaf_seg pigment { color rgb < R1, G1, B1 > } 
  rotate 30*y
  translate < Tran_x+T_r1, Tran_y, -3 > }
 object { Leaf_seg pigment { color rgb < R1, G1, B1 > } 
  rotate 150*y
  translate < Tran_x+T_r1, Tran_y, -3 > }
}

// parameter
#local V_r1 =  30; #local V_a1 = 135;  // 90<=degrees<=180
#local V_r2 = 180; #local V_a2 =  15;  //  0<=degrees<= 90
#local T_w0 =   2; #local Ground_level = -40;
#include "Branch_typeA.def.inc"
//
#local Branch =
union {
 object { Twig rotate <0,120,-60> translate <2,30,0> }
 object { Twig rotate <0,240,-60> translate <2,30,0> }
 object { Branch_seg }
 object { Twig rotate <0,120,-60> translate 4*x }
 object { Twig rotate <0,240,-60> translate 4*x }
 rotate 60*z
 translate -35*x
}
// branch color
coordinate_color(0,0.2,0.5,1,2)
coordinate_color(0,  0,0.5,1,3)
coordinate_color(0,  0,0.3,1,4)
//
#local Branch_uni =
union {
 object { Branch rotate 120*0*y }
 object { Branch rotate 120*1*y }
 object { Branch rotate 120*2*y }
 pigment { marble
           turbulence 0.8 
           color_map { [ 0.0 rgb < R2, G2, B2 > ]
                       [ 0.5 rgb < R3, G3, B3 > ]
                       [ 1.0 rgb < R4, G4, B4 > ] } scale 5 }
}

// Tree
#declare Tree =
union {
 object { Branch_seg 
  pigment { wood
            turbulence 0.6
            color_map { [ 0.0 rgb < R2, G2, B2 > ]
                        [ 0.5 rgb < R3, G3, B3 > ]
                        [ 1.0 rgb < R4, G4, B4 > ] } scale 3 }
  translate < -3, -30, 0 > scale 3 }
 object { Branch_uni rotate (180+ 0)*y }
 object { Branch_uni rotate (180+40)*y translate 40*y scale 0.8 }
 object { Branch_uni rotate (180+80)*y translate 80*y scale 0.6 }
 translate 170*y
}
// generate
//object { Tree }
//object { Tree translate < 100, 0, 0 > rotate 20*y }
//object { Tree translate < -100, 0, 0 > rotate 40*y }