// Twig segment definition file (2000/02/24)
// Persistence Of Vision raytracer version 3.1g
// Written by S.Nishimura


//*** twig **************************************************
// input check
#ifndef(T_r1) #local T_r1 = 10;#end
#ifndef(T_a1) #local T_a1 =  90;        #end  //   0<=degrees<= 90
#ifndef(T_r2) #local T_r2 = 40;#end
#ifndef(T_a2) #local T_a2 = -45;        #end  // -90<=degrees<=  0
#ifndef(T_r3) #local T_r3 = 80;#end
#ifndef(T_a3) #local T_a3 = 180+T_a2- 5;#end  //   0<=degrees<=180+T_a2<180
#ifndef(T_w0) #local T_w0 = 4; #end 
#local T_l0 = -T_r3/4;                        //   0>=length
#ifndef(Ground_level) #local Ground_level = 0;#end

// calculation
#local T_x1 = 0;   #local T_y1 = 0;
#local T_x2 = (T_r1+T_r2)*cos(radians(T_a1))+T_x1;
#local T_y2 = (T_r1+T_r2)*sin(radians(T_a1))+T_y1;
#local T_x3 = (T_r2+T_r3)*cos(radians(T_a2))+T_x2; 
#local T_y3 = (T_r2+T_r3)*sin(radians(T_a2))+T_y2;

// definition
#local R_z1 = T_a1; #local R_z2 = T_a2; #local R_z3 = T_a3; 
#local Torus_s1 =
object {
    torus { T_r1,T_w0 sturm rotate -90*x }
    clipped_by { plane { x, 0 } rotate (-90)*z }
    clipped_by { plane { x, 0 } rotate (-90+R_z1)*z }
    translate < T_x1, T_y1, 0  >
}
#local Torus_s2 =
object {
    torus { T_r2,T_w0 sturm rotate -90*x }
    clipped_by { plane { x, 0 } rotate (90+R_z1)*z }
    clipped_by { plane { x, 0 } rotate (90+R_z2)*z }
    translate < T_x2, T_y2, 0 >
}
#local Torus_s3 =
object {
    torus { T_r3,T_w0 sturm rotate -90*x }
    clipped_by { plane { x, 0 } rotate (-90+R_z2)*z }
    clipped_by { plane { x, 0 } rotate (-90+R_z3)*z }
    translate < T_x3, T_y3, 0 >
}
//
#declare Tran_x = T_r3*cos(radians(R_z3)) +T_x3;
#declare Tran_y = T_r3*sin(radians(R_z3)) +T_y3;
#declare Twig_seg =
union {
 object { Torus_s1 }
 object { Torus_s2 }
 object { Torus_s3 }
 cone { < 0, 0, 0 >, T_w0, < 0, T_l0, 0 >, T_w0/2 rotate R_z3*z translate < Tran_x, Tran_y, 0 > }
 translate < T_r1, Ground_level, 0 >
}

