#include "textures.inc"

#declare window = union
{       
        mesh
        {
                triangle{ < -1, -1, -1 >< -1, 1, -1 >< -1, 1, 1 > }
                triangle{ < -1, -1, -1 >< -1, -1, 1 >< -1, 1, 1 > }
                texture{ glass }
        }
        difference
        {
                box
                {
                        < -1, -1, -1 >< 1, 1, 1 >
                        texture{ window_frame }
                }
                box
                {
                        < -2, -0.9, -0.9 >< 2, 0.9, 0.9 >
                        texture{ window_frame }
                }
                translate< -10, 0, 0 >
                scale< 0.1, 1, 1 >
        }
        box
        {
                < -2.5, -1, -1 >< 2.5, 1, 1 >
                translate< -10, -20, 0 >
                scale< 0.1, 0.05, 1 >
                texture{ window_board }
        }
}

#declare chimney = union
{
        box
        {
                <-1, -1, -1><1, 1, 1>
                scale< 0.1, 2.25, 0.1 >
                texture{ chimney_wall }
        }
}

#declare drain_pipe = union
{
        union
        {
                cylinder
                {
                        <0, 0, 0> < 0, 1, 0 >,1
                        scale< 0.05, 1.0, 0.025 >
                }
                cylinder
                {
                        <0, 0, 0> < 0, 1, 0 >,1
                        scale< 0.05, 0.55, 0.025 >
                        rotate< 0, 0, -40 >
                        translate< 0, 1, 0 >
                }
                difference
                {
                        cylinder
                        {
                                <0, 0, 0> < 0, 1, 0 >,1
                        }
                        cylinder
                        {
                                <0, 0, 0> < 0, 1.5, 0 >,0.9
                        }
                        scale< 0.05, 0.2, 0.025 >
                        rotate< 0, 0, -130 >
                        translate< 0, 0, 0 >
                }
        }
}

#declare water_pipe = union
{
        difference
        {       
                cylinder
                {
                        < 0, 0, -1.1 >< 0, 0, 1.1 >,1
                }
                box
                {
                        < -1.5, 0, -1.5 >< 1.5, 1.5, 1.5 >
                }
                scale< 0.05, 0.05, 1 >
                translate< 0.4, 1.4, 0 >
        }/*
        object
        {
                drain_pipe
        }*/
        object
        {
                drain_pipe
                translate< 0, 0, 1 >
        }
        object
        {
                drain_pipe
                translate< 0, 0, -1 >
        }
        object
        {
                drain_pipe
                translate< 0, 0, 0.5 >
        }/*
        object
        {
                drain_pipe
                translate< 0, 0, -0.5 >
        }*/
}

#declare house_body = union
{       
        difference
        {
                union
                {
                        box
                        {
                                < -1, -1, -1 > < 1, 1, 1 >
                        }
                        mesh
                        {
                                triangle{ < 1, 1, 1 >< -1, 1, 1 >< 0, 2.5, 1 > }
                                triangle{ < 1, 1, -1 >< -1, 1, -1 >< 0, 2.5, -1 > }
                        }
                        scale< 1, 1, 2 >
                }
                union
                {
                        cylinder{< 0, 1.5, -1.2 >< 0, 1.5, 1.2 >,0.2}
                        box{< -1.2, -0.7, -0.1 > < 1.2, 0, 0.1 > translate< 0, 0, 0.25 >}
                        box{< -1.2, -0.7, -0.1 > < 1.2, 0, 0.1 > translate< 0, 0, 0.75 >}
                        box{< -1.2, -0.7, -0.1 > < 1.2, 0, 0.1 > translate< 0, 0, -0.25 >}
                        box{< -1.2, -0.7, -0.1 > < 1.2, 0, 0.1 > translate< 0, 0, -0.75 >}
                        box{< -1.2, -0.7, -0.1 > < 1.2, 0, 0.1 > translate< 0, 0.9, 0.25 >}
                        box{< -1.2, -0.7, -0.1 > < 1.2, 0, 0.1 > translate< 0, 0.9, 0.75 >}
                        box{< -1.2, -0.7, -0.1 > < 1.2, 0, 0.1 > translate< 0, 0.9, -0.25 >}
                        box{< -1.2, -0.7, -0.1 > < 1.2, 0, 0.1 > translate< 0, 0.9, -0.75 >}
                        scale< 1, 1, 2 >
                }
                texture{ wall_texture }
        }
        union
        {       
                object
                {
                        window
                        translate< 2.8, 1.6, -2.5 >
                        scale< 0.5, 0.35, 0.1 >
                }
                object
                {
                        window
                        translate< 2.8, 1.6, -7.5 >
                        scale< 0.5, 0.35, 0.1 >
                }
                object
                {
                        window
                        translate< 2.8, 1.6, 2.5 >
                        scale< 0.5, 0.35, 0.1 >
                }
                object
                {
                        window
                        translate< 2.8, 1.6, 7.5 >
                        scale< 0.5, 0.35, 0.1 >
                }
                object
                {
                        window
                        translate< 2.8, -1, -2.5 >
                        scale< 0.5, 0.35, 0.1 >
                }
                object
                {
                        window
                        translate< 2.8, -1, -7.5 >
                        scale< 0.5, 0.35, 0.1 >
                }
                object
                {
                        window
                        translate< 2.8, -1, 2.5 >
                        scale< 0.5, 0.35, 0.1 >
                }
                object
                {
                        window
                        translate< 2.8, -1, 7.5 >
                        scale< 0.5, 0.35, 0.1 >
                }
                scale< 1, 1, 2 >
        }
        union
        {
                object
                {
                        water_pipe
                        translate< 1, -0.8, 0 >
                }
                scale< 1, 1, 2 >
                texture{ drain_metal }
        }
}

#declare house_roof = union
{
        mesh
        {
                triangle{ < -1.5, -1, -1 >< 0, 1, -1 >< 0, 1, 1 > }
                triangle{ < -1.5, -1, -1 >< -1.5, -1, 1 >< 0, 1, 1 > }
                triangle{ < 1.5, -1, -1 >< 0, 1, -1 >< 0, 1, 1 > }
                triangle{ < 1.5, -1, -1 >< 1.5, -1, 1 >< 0, 1, 1 > }
                scale< 0.9, 1, 2.2 >
        }
}


#declare house = union
{       
        object
        {
                house_body
        }
        object
        {
                house_roof
                texture{ roof_texture }
                translate< 0, 1.6, 0 >
        }
        object
        {
                house_roof
                texture{ window_frame }
                translate< 0, 1.59, 0 >
        }
        object
        {
                chimney
                translate< 0.5, 0, -1.0 >
        }
        sphere
        {
                < 0, 0, 0 >,1
                material{ smoke_material }
                scale< 0.15, 0.5, 0.15 >
                translate< 0.45, 2.4, -1.05 >
                hollow
        }
} 
