// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.1
// Desc: Guard Your Heart
// Date: 3/20/01
// Auth: Teri Hoskins (isokesa@yahoo.com)
//

#version 3.1;
#version unofficial MegaPov 0.7;  

#include "colors.inc" 
#include "sword1.inc"
#include "vine.inc"


#declare inches = 0.2;
#declare feet = inches * 12;
#declare yards = feet *3; 


global_settings
{
  assumed_gamma 2.2 
  ambient_light 0.1
} 

//-----------TEXTURES-----------------------

//-------------FLOORING--------------------
   // >>> post_tex (from file "disp2.inc", line 21) <<<
#declare post_tex = texture {
  pigment {
    color red 0.900 green 0.700 blue 0.350 
  }
  finish { 
    ambient 0.5
    reflection 1
    brilliance 2.5
    phong 0.80
    phong_size 15.00
    metallic
  }
}

 // >>> Stone21 (from file "stoneold.inc", line 79) <<<

// Constants from file "stones1.inc"
#declare T_Grnt28 = texture {
  pigment {
    marble
    turbulence 0.7
    color_map {
      [0.000, 0.155 color rgbf <0.686, 0.235, 0.282, 0.000>
      color rgbf <0.686, 0.235, 0.282, 0.000>]
      [0.155, 0.328 color rgbf <0.686, 0.235, 0.282, 0.000>
      color rgbf <0.494, 0.243, 0.294, 0.000>]
      [0.328, 0.474 color rgbf <0.494, 0.243, 0.294, 0.000>
      color rgbf <0.769, 0.329, 0.373, 0.000>]
      [0.474, 0.647 color rgbf <0.769, 0.329, 0.373, 0.000>
      color rgbf <0.769, 0.329, 0.373, 0.000>]
      [0.647, 0.810 color rgbf <0.769, 0.329, 0.373, 0.000>
      color rgbf <0.686, 0.235, 0.282, 0.000>]
      [0.810, 0.922 color rgbf <0.686, 0.235, 0.282, 0.000>
      color rgbf <0.792, 0.388, 0.427, 0.000>]
      [0.922, 1.001 color rgbf <0.792, 0.388, 0.427, 0.000>
      color rgbf <0.686, 0.235, 0.282, 0.000>]
    }
  }
  finish {
    crand 0.03
  }
}

// Constants from file "colors.inc"
#declare White = rgb 1;
#declare DimGray = color red 0.329412 green 0.329412 blue 0.329412;
#declare Clear = rgbf 1;

// Constants from file "stones1.inc"
#declare T_Grnt22 = texture {
  pigment {
    granite
    turbulence 0.0
    color_map {
      [0.0, 0.07 color White color White]
      [0.07, 0.2 color White color DimGray]
      [0.2, 0.3 color DimGray color Clear]
      [0.3, 0.7 color Clear color Clear]
      [0.7, 1.0 color Clear color DimGray]
    }
  }
  finish {
    crand 0.02
  }
}

// Constants from file "colors.inc"
#declare Black = rgb 0;

// Constants from file "stones1.inc"
#declare T_Crack4 = texture {
  pigment {
    marble
    turbulence 0.85
    color_map {
      [0.0, 0.03 color White filter 0.3 color White filter 1.0]
      [0.03, 0.97 color Black filter 0.70 color DimGray filter 0.90]
      [0.97, 1.001 color White filter 0.9 color White filter 1.0]
    }
  }
}
#declare T_Stone21 = texture {
  T_Grnt28 scale <1.3, 2.5, 1.7> rotate <0, 0, 40>
}
texture {
  T_Grnt22 scale <1, 2, 2> rotate <0, 0, 40>
}
texture {
  T_Crack4 scale <1, 0.6, 1> rotate <10, 0, -20>
  finish {
    phong 1.0 phong_size 90
  }
}

#declare Stone21 = texture {
  T_Stone21 
}                                 



// >>> Grnt28 (from file "stoneold.inc", line 50) <<<

// Constants from file "stones1.inc"
#declare T_Grnt28 = texture {
  pigment {
    marble
    turbulence 0.7
    color_map {
      [0.000, 0.155 color rgbf <0.686, 0.235, 0.282, 0.000>
      color rgbf <0.686, 0.235, 0.282, 0.000>]
      [0.155, 0.328 color rgbf <0.686, 0.235, 0.282, 0.000>
      color rgbf <0.494, 0.243, 0.294, 0.000>]
      [0.328, 0.474 color rgbf <0.494, 0.243, 0.294, 0.000>
      color rgbf <0.769, 0.329, 0.373, 0.000>]
      [0.474, 0.647 color rgbf <0.769, 0.329, 0.373, 0.000>
      color rgbf <0.769, 0.329, 0.373, 0.000>]
      [0.647, 0.810 color rgbf <0.769, 0.329, 0.373, 0.000>
      color rgbf <0.686, 0.235, 0.282, 0.000>]
      [0.810, 0.922 color rgbf <0.686, 0.235, 0.282, 0.000>
      color rgbf <0.792, 0.388, 0.427, 0.000>]
      [0.922, 1.001 color rgbf <0.792, 0.388, 0.427, 0.000>
      color rgbf <0.686, 0.235, 0.282, 0.000>]
    }
  }
  finish {
    crand 0.03
  }
}

#declare Grnt28 = texture {
  T_Grnt28 
}

 
//-------------------COLUMNS AND ARCHES TEXTURES---------------   

// >>> Stone8 (from file "stoneold.inc", line 66) <<<

// Constants from file "colors.inc"
#declare White = rgb 1;

// Constants from file "stones1.inc"
#declare T_Grnt0a = texture {
  pigment {
    granite
    turbulence 0.6
    color_map {
      [0.000, 0.153 color rgbf <0.729, 0.502, 0.451, 0.306>
      color rgbf <0.769, 0.686, 0.592, 0.792>]
      [0.153, 0.398 color rgbf <0.769, 0.686, 0.592, 0.792>
      color rgbf <0.843, 0.753, 0.718, 0.396>]
      [0.398, 0.559 color rgbf <0.843, 0.753, 0.718, 0.396>
      color rgbf <0.780, 0.667, 0.561, 0.976>]
      [0.559, 0.729 color rgbf <0.780, 0.667, 0.561, 0.976>
      color rgbf <0.741, 0.659, 0.576, 0.820>]
      [0.729, 1.001 color rgbf <0.741, 0.659, 0.576, 0.820>
      color rgbf <0.729, 0.502, 0.451, 0.306>]
    }
  }
}
#declare T_Grnt9a = texture {
  pigment {
    granite
    turbulence 0.6
    color_map {
      [0.000, 0.216 color rgbf <0.812, 0.812, 0.812, 0.835>
      color rgbf <0.745, 0.843, 0.835, 0.847>]
      [0.216, 0.241 color rgbf <0.745, 0.843, 0.835, 0.847>
      color rgbf <0.404, 0.337, 0.337, 0.463>]
      [0.241, 0.267 color rgbf <0.404, 0.337, 0.337, 0.463>
      color rgbf <0.773, 0.729, 0.745, 0.622>]
      [0.267, 0.759 color rgbf <0.773, 0.729, 0.745, 0.622>
      color rgbf <0.914, 0.843, 0.725, 0.651>]
      [0.759, 0.784 color rgbf <0.914, 0.843, 0.725, 0.651>
      color rgbf <0.153, 0.133, 0.208, 0.437>]
      [0.784, 0.810 color rgbf <0.153, 0.133, 0.208, 0.437>
      color rgbf <0.812, 0.812, 0.812, 0.835>]
      [0.810, 1.001 color rgbf <0.812, 0.812, 0.812, 0.835>
      color rgbf <0.812, 0.812, 0.812, 0.835>]
    }
  }
}
#declare T_Stone8 = texture {
  pigment {
    color White
  }
  finish {
    ambient 0.4 crand 0.06 diffuse 0.7
  }
}
texture {
  T_Grnt0a scale <2, 3, 2> rotate <0, 0, -30>
}
texture {
  T_Grnt9a scale <5, 3, 4> rotate <0, 0, 40>
  finish {
    phong 1.0 ambient 0.2 diffuse 0.5 phong_size 90
  }
}

#declare Stone8 = texture {
  T_Stone8 
}




//----------------------WALL TEXTURE-------------------- 
 // >>> Pink_Alabaster (from file "povlab.inc", line 119) <<<
#declare Pink_Alabaster = texture {
  pigment {
    bozo
    turbulence 0.25
    color_map {
      [0, 1 color rgb <0.9, 0.75, 0.75>
      color rgb <0.6, 0.6, 0.6>]
    }
    scale 0.4
  }
  finish {
    ambient 0.25
  }
}
texture {
  pigment {
    granite
    color_map {
      [0, 0.9 color rgbf <0.52, 0.39, 0.39, 1>
      color rgbf <0.52, 0.39, 0.39, 0.5>]
      [0.9, 1 color rgb <0.184314, 0.309804, 0.309804>
      color rgb <0.184314, 0.309804, 0.309804>]
    }
    scale 0.5 
  }
  finish {
    specular 1
    roughness 0.0001
    phong 0.25
    phong_size 75
    brilliance 4
  }
}

//----------------SKY TEXTURES---------------------

// >>> Stars (from file "povlab.inc", line 6154) <<<
#declare Stars = texture {
  pigment {
    granite
    color_map {
      [0.00 color rgb <0.00, 0.00, 0.00>]
      [0.84 color rgb <0.00, 0.00, 0.00>]
      [0.85 color rgb <0.80, 0.80, 0.80>]
      [0.86 color rgb <0.20, 0.20, 0.20>]
      [0.87 color rgb <0.95, 0.95, 0.95>]
      [0.88 color rgb <0.00, 0.00, 0.00>]
      [0.89 color rgb <1.00, 1.00, 1.00>]
      [0.90 color rgb <0.95, 0.95, 0.95>]
      [0.91 color rgb <0.00, 0.00, 0.00>]
      [1.00 color rgb <0.00, 0.00, 0.00>]
    }
    
  } 
  finish{ ambient 20}
} 

// >>> Starfield (from file "textures.inc", line 1272) <<<
#declare Starfield = texture {
  pigment {
    granite 
    color_map {
      [0.72 rgb 0.00 ] 
      [0.72 rgb 0.20 ] 
      [0.75 rgb 0.40 ] 
      [0.78 rgb 0.60 ] 
      [0.81 rgb 0.80 ] 
      [0.85 rgb 0.95 ] 
      [0.91 rgb 1.00 ] 
      [0.91 rgb 0.00 ] 
    }
    scale .015
  }
  finish {
    ambient 1 diffuse 1
  }
}


// >>> Clouds (from file "povlab.inc", line 6280) <<<
#declare Clouds = texture {
  pigment {
    bozo
    turbulence 0
    color_map {
      [0.0, 0.1 color rgbf <0.8, 0.8, 0.8, 0.0>
      color rgbf <0.8, 0.8, 0.8, 0.0>]
      [0.1, 0.5 color rgbf <0.8, 0.8, 0.8, 0.0>
      color rgbf <1.0, 1.0, 1.0, 1.0>] 
      [0.5, 1.0 color rgbf <1.0, 1.0, 1.0, 1.0>
      color rgbf <1.0, 1.0, 1.0, 1.0>]
    }
  }
}
  
// >>> cl (from file "sky77.inc", line 8) <<<
#declare cl = texture { pigment{
  bozo
  turbulence 0.9
  
  colour_map {
    [0.000 0.112 colour red 0.243 green 0.145 blue 0.275 filter 1
    colour red 0.243 green 0.145 blue 0.275 filter 1]
    [0.112 0.190 colour red 0.243 green 0.145 blue 0.275 filter 1
    colour red 0.243 green 0.145 blue 0.275 filter 0.992]
    [0.190 0.276 colour red 0.243 green 0.145 blue 0.275 filter 0.992
    colour red 0.243 green 0.145 blue 0.275 filter 0.880]
    [0.276 0.483 colour red 0.243 green 0.145 blue 0.275 filter 0.880
    colour red 0.302 green 0.180 blue 0.341 filter 0.804]
    [0.483 0.767 colour red 0.302 green 0.180 blue 0.341 filter 0.804
    colour red 0.271 green 0.278 blue 0.455 filter 0.771]
    [0.767 0.991 colour red 0.271 green 0.278 blue 0.455 filter 0.771
    colour red 0.490 green 0.502 blue 0.631 filter 0.645]
    [0.991 1.001 colour red 0.490 green 0.502 blue 0.631 filter 0.645
    colour red 0.243 green 0.145 blue 0.275 filter 1]
  }   }
}

// >>> P_Cloud3 (from file "skies.inc", line 75) <<<
#declare P_Cloud3 = pigment {
  bozo
  color_map {
    [0.0, 0.1 color red 0.85 green 0.85 blue 0.85
    color red 0.55 green 0.60 blue 0.65]
    [0.1, 0.5 color red 0.55 green 0.60 blue 0.65
    color rgb <0.184, 0.184, 0.309> ]
    [0.5, 1.001 color rgb <0.184, 0.184, 0.309>
    color rgb <0.1, 0.1, 0.2>]
  }
  turbulence 0.65
  octaves 6
  omega 0.707
  lambda 2
  scale <6, 4, 6>
}

// >>> P_Cloud1 (from file "skies.inc", line 40) <<<

// Constants from file "colors.inc"
#declare Clear = rgbf 1;

#declare P_Cloud1 = pigment {
  bozo
  turbulence 0.65
  octaves 6
  omega 0.7
  lambda 2
  color_map {
    [0.0, 0.1 color red 0.85 green 0.85 blue 0.85
    color red 0.75 green 0.75 blue 0.75]
    [0.1, 0.5 color red 0.75 green 0.75 blue 0.75
    color Clear]
    [0.5, 1.001 color Clear
    color Clear]
  }
  
  scale <6, 1, 6>
}


//----------------HEART TEXTURE-----------------

// >>> RED_GLASS (from file "3dsmater.inc", line 16) <<<

// Constants from file "colors.inc"
#declare Red = rgb <1, 0, 0>;

#declare RED_GLASS = texture {
  finish {
    ambient <100,1,1>
    diffuse 0.7
    phong 1.0
    phong_size 70.0
    refraction 1
    ior 1.2 
  }
  pigment {
    color Red filter 0.96 
  }
}


//-------------HEART LEAF TEXTURE---------------

// >>> Green_Vein_Pistachio_Plastic (from file "povlab.inc", line 2893) <<<
#declare Green_Vein_Pistachio_Plastic = texture {
  pigment {
    wood
    turbulence 0.4
    color_map {
      [0 0.81 color rgb <0.1686, 0.3219, 0.0639>
      color rgb <0.1686, 0.3219, 0.0639>]
      [0.81 0.23 color rgb <0.0283, 0.2406, 0.4457>
      color rgb <0.2252, 0.7120, 0.3254>]
      [0.23 0.00 color rgb <0.9740, 0.5141, 0.5747>
      color rgb <0.1422, 0.2789, 0.3231>]
      [0.00 1.001 color rgb <0.1422, 0.2789, 0.3231>
      color rgb <0.3723, 0.7744, 0.0549>]
    }
  }
  finish {
    phong 1.0 ambient 0.4
  }
  normal {
    ripples 0.0
  }
  scale <0.5 1.2 2.6>
  rotate <124 222 358>
}
 

// -------------CODING--------------------------- 

//--------------FLOORING-------------------------- 
   #declare arc2=difference{
   torus{10*feet, 0.2*feet texture{post_tex}}
   box{<0,0,0><30*feet,1,30*feet>texture{post_tex}translate<0,-0.50,-15*feet>} 
   box{<0,0,0><40*feet,1,30*feet>texture{post_tex}translate<-30*feet,-0.5,-30*feet>} 
   box{<0,0,0><40*feet,1,40*feet>texture{post_tex}translate<-20*feet,0,-1*feet>} }
   
   
   

   #declare ray=difference{
   box{<0,0,0><2*feet,0.1, 2*feet> texture{post_tex}rotate<0,45,0>scale<2.1,1,0.35>} 
   box{<0,0,0><6*feet,1*feet,3*feet> texture{post_tex}translate<3*feet,-0.25*feet,-1*feet>} }
   
   #declare ray1=union{
   object{ray}
   object{arc2 rotate<0,-30,0>translate<9*feet,0,5*feet>}  
    object{arc2 rotate<0,-60,0>translate<9*feet,0,-5*feet>}  } 
    
   #declare arc=union{ 
   object{ray1} 
   object{ray1 rotate<0,30,0>translate<0.67*feet,0,2.425*feet> }
   object{ray1 rotate<0,60,0>translate<2.435*feet,0,4.215*feet>} }
    
   #declare sunburst=union{
   object{arc}  
   object{arc rotate<0,90,0>translate<4.87*feet,0,4.87*feet>} 
   object{arc rotate<0,180,0>translate<9.75*feet,0,0>}
   object{arc rotate<0,270,0>translate<4.87*feet,0,-4.87*feet>} 
   cylinder{<0,0,0><0,0.25,0>2*feet texture{post_tex}translate<4.87*feet,-0.05*feet,0>}}
   
   #declare ring1=difference{
   torus{13.8*feet, 0.2*feet texture{post_tex}} 
   box{<0,0,0><40*feet,1*feet,40*feet>texture{post_tex}translate<-20*feet,0,-20*feet>} }   
   
   #declare ring2=difference{
   torus{21.3*feet, 0.2*feet texture{post_tex}}
   box{<0,0,0><50*feet,1*feet, 50*feet>texture{post_tex} translate<-25*feet,0,-25*feet>} }
   
   
   #declare ring3=difference{
   torus{17.8*feet, 0.2*feet texture{post_tex}}
   box{<0,0,0><40*feet,1*feet, 40*feet>texture{post_tex} translate<-20*feet,0,-20*feet>} }     
   
   #declare ring4=difference{
   torus{24.8*feet, 0.2*feet texture{post_tex}}
   box{<0,0,0><60*feet,1*feet, 60*feet>texture{post_tex} translate<-30*feet,0,-30*feet>} }
   
   #declare fill=
   cylinder{<0,0,0><0,0.25,0>30*feet texture{Stone21 }translate<4.85*feet,-0.105*feet,0>}
    
    #declare flooring=union{
   object{sunburst}
   object{ring1  translate<4.85*feet,0,0>}
   object{ring2 translate<4.85*feet,0,0>} 
   object{ring3 translate<4.85*feet,0,0>} 
   object{ring4 translate<4.85*feet,0,0>}
   object{fill}  }
   
   //object{flooring}

     
//-------------------COLUMNS AND ARCHES---------------   

//----------------OUTSIDE COLUMN-------------
   
 #declare outer_column=union{   
 cylinder{<0,0,0><0,8.7*feet,0>0.6*feet texture{Stone8}}
 cylinder{<0,0,0><0,0.4*feet,0>,1.2*feet texture{Stone8}}   
 cylinder{<0,0,0><0,0.4*feet,0>,1.2*feet texture{Stone8}translate<0,8.3*feet,0>}
 torus{0.9*feet,0.1*feet texture{Stone21}translate<0,0.4*feet,0>}   
 torus{0.9*feet,0.1*feet texture{Stone21}translate<0,8.2*feet,0>} 
 torus{0.8*feet,0.1*feet texture{Stone8} translate<0,0.6*feet,0>}   
 torus{0.8*feet,0.1*feet texture{Stone8} translate<0,8*feet,0>}
 torus{0.7*feet 0.1*feet texture{Stone21} translate<0,0.8*feet,0>}  
 torus{0.7*feet 0.1*feet texture{Stone21} translate<0,7.9*feet,0>} }
 
 //object{outer_column}   
 
  #declare outer_column2=union{   
 cylinder{<0,0,0><0,8.7*feet,0>0.6*feet texture{Stone21}}
 cylinder{<0,0,0><0,0.4*feet,0>,1.2*feet texture{Stone21}}   
 cylinder{<0,0,0><0,0.4*feet,0>,1.2*feet texture{Stone21}translate<0,8.3*feet,0>}
 torus{0.9*feet,0.1*feet texture{Stone8}translate<0,0.4*feet,0>}   
 torus{0.9*feet,0.1*feet texture{Stone8}translate<0,8.2*feet,0>} 
 torus{0.8*feet,0.1*feet texture{Stone21} translate<0,0.6*feet,0>}   
 torus{0.8*feet,0.1*feet texture{Stone21} translate<0,8*feet,0>}
 torus{0.7*feet 0.1*feet texture{Stone8} translate<0,0.8*feet,0>}  
 torus{0.7*feet 0.1*feet texture{Stone8} translate<0,7.9*feet,0>} } 
 
 //object{outer_column2}
 
//-----------INSIDE COLUMN---------------

#declare long=difference{
box{<0,0,0><0.8*feet,6*feet,0.8*feet> texture{Stone8}}  
cylinder{<0,0,0><0,7*feet,0>0.05*feet texture{Stone8} translate<0.2*feet,-0.6*feet,0>} 
cylinder{<0,0,0><0,7*feet,0>0.05*feet texture{Stone8} translate<0.4*feet,-0.6*feet,0>}
cylinder{<0,0,0><0,7*feet,0>0.05*feet texture{Stone8} translate<0.6*feet,-0.6*feet,0>}

cylinder{<0,0,0><0,7*feet,0>0.05*feet texture{Stone8} translate<0.8*feet,-0.6*feet,0.2*feet>} 
cylinder{<0,0,0><0,7*feet,0>0.05*feet texture{Stone8} translate<0.8*feet,-0.6*feet,0.4*feet>}
cylinder{<0,0,0><0,7*feet,0>0.05*feet texture{Stone8} translate<0.8*feet,-0.6*feet,0.6*feet>} 

cylinder{<0,0,0><0,7*feet,0>0.05*feet texture{Stone8} translate<0.2*feet,-0.6*feet,0.8*feet>} 
cylinder{<0,0,0><0,7*feet,0>0.05*feet texture{Stone8} translate<0.4*feet,-0.6*feet,0.8*feet>}
cylinder{<0,0,0><0,7*feet,0>0.05*feet texture{Stone8} translate<0.6*feet,-0.6*feet,0.8*feet>} 

cylinder{<0,0,0><0,7*feet,0>0.05*feet texture{Stone8} translate<0*feet,-0.6*feet,0.2*feet>} 
cylinder{<0,0,0><0,7*feet,0>0.05*feet texture{Stone8} translate<0*feet,-0.6*feet,0.4*feet>}
cylinder{<0,0,0><0,7*feet,0>0.05*feet texture{Stone8} translate<0*feet,-0.6*feet,0.6*feet>}}
 
#declare inner_column=union{ 
object{long} 
box{<0,0,0><1*feet,0.4*feet,1*feet> texture{Stone8}translate<-0.1*feet,0,-0.1*feet>}  
box{<0,0,0><1*feet,0.4*feet,1*feet> texture{Stone8}translate<-0.1*feet,5.6*feet,-0.1*feet>}
box{<0,0,0><0.9*feet,0.2*feet,0.9*feet> texture{Stone21} translate<-0.05*feet,0.4*feet,-0.05*feet>} 
box{<0,0,0><0.9*feet,0.2*feet,0.9*feet> texture{Stone21} translate<-0.05*feet,5.4*feet,-0.05*feet>}}



//-----------------ARCH----------------

#declare arch1=difference{ 
cylinder{<0,0,0><0,0,0.8*feet>2.75*feet texture{Stone8}} 
cylinder{<0,0,0><0,0,1.8*feet>1.95*feet texture{Stone8}translate<0,0,-0.6*feet>} 
box{<0,0,0><10*feet,4*feet,2*feet> texture{Stone8} translate<-5*feet,-4*feet,-1*feet>}  
torus{2.15*feet, 0.05*feet texture{Stone8}rotate<90,0,0>} 
torus{2.35*feet, 0.05*feet texture{Stone8}rotate<90,0,0>} 
torus{2.55*feet, 0.05*feet texture{Stone8}rotate<90,0,0>}
 
torus{2.15*feet, 0.05*feet texture{Stone8}rotate<90,0,0>translate<0,0,0.8*feet>} 
torus{2.35*feet, 0.05*feet texture{Stone8}rotate<90,0,0>translate<0,0,0.8*feet>} 
torus{2.55*feet, 0.05*feet texture{Stone8}rotate<90,0,0>translate<0,0,0.8*feet>}
torus{1.95*feet 0.05*feet texture{Stone8} rotate<90,0,0>translate<0,0,0.2*feet>}
torus{1.95*feet 0.05*feet texture{Stone8} rotate<90,0,0>translate<0,0,0.4*feet>}
torus{1.95*feet 0.05*feet texture{Stone8} rotate<90,0,0>translate<0,0,0.6*feet>}} 

//-------------ARCH WITH COLUMNS (DOORWAY)--------------

#declare doorway=union{
object{arch1 translate<0,6*feet,0>}  
object{inner_column translate<-2.75*feet,0>}  
object{inner_column translate<1.95*feet,0>} }

//object{doorway}
 
//--------------WALL--------------  

 #declare wall=union{
 object{doorway translate<0,0,-0.4*feet>}
 object{outer_column translate<-4.25*feet,0,0>}  
 object{outer_column translate<4.25*feet,0,0>} } 
 
 #declare wall2=difference{
 box{<0,0,0><18*feet,9*feet,0.1*feet> texture{Pink_Alabaster }translate<-9*feet,0,0>} 
 object{wall} 
 box{<0,0,0><4.5*feet,7*feet,1*feet>texture{Stone8} translate<-2.25*feet,-1*feet,-0.6*feet>} 
 sphere{<0,0,0>2*feet texture{Stone8}translate<0,6*feet,0>} }
 
 #declare wall3=union{
 object{wall}
 object{wall2} 
 object{sword scale 0.0225 rotate<0,0,180> translate<0.175*feet,7.375*feet,0> }}
 
 
 //object{wall3}
 
//----------------BOTTOM LEVEL------------------ 
 #declare level1=union{
 object{flooring}
 object{wall3 translate<5*feet,0,26.5*feet>}  //12:00   
 object{wall3 translate<5*feet,0,-26.5*feet>} //6:00  
 object{wall3 rotate<0,90,0> translate<-21.5*feet,0,0>} //9:00
 object{wall3 rotate<0,90,0> translate<31.5*feet,0,0>}  //3:00
 object{wall3 rotate<0,60,0> translate<-18*feet,0,-13*feet>} //8:00  
 object{wall3 rotate<0,60,0> translate<28*feet,0,13*feet>}   //2:00
 object{wall3 rotate<0,30,0> translate<-8*feet,0,-23*feet>} //7:00     
 object{wall3 rotate<0,30,0> translate<18*feet,0,23*feet>}  //1:00   
 object{wall3 rotate<0,-60,0>translate<-18*feet,0,13*feet>} //10:00  
 object{wall3 rotate<0,-30,0>translate<-8*feet,0,23*feet>} //11:00 
 object{wall3 rotate<0,-60,0>translate<28*feet,0,-13*feet>} //4:00  
 object{wall3 rotate<0,-30,0>translate<18*feet,0,-23*feet>} //5:00  
  }  
 
 
 //-----------------SECOND FLOORING-----------
 
 #declare round1=
 cylinder{<0,0,0><0,0.43*feet,0>30*feet texture{Stone21} translate<0,0.01*feet,0>}
 //cylinder{<0,0,0><0,0.40*feet,0>17.6*feet texture{post_tex} } 
 //cylinder{<0,0,0><0,0.40*feet,0>,30*feet texture{post_tex}}
 
 #declare flooring2=difference{
 object{round1}
 cylinder{<0,0,0><0,2*feet,0>17.2*feet texture{Stone21}translate<0,-1*feet,0>}  }
 
 
 #declare round2=difference{
 cylinder{<0,0,0><0,0.4*feet,0>19.6*feet texture{Stone21}}
 cylinder{<0,0,0><0,2*feet,0>17.6*feet texture{Stone21}translate<0,-1*feet,0>} } 
 
 #declare ballustrade=difference{
 object{round2} 
 torus{17.4*feet 0.05*feet texture{Stone21} translate<0,0.2*feet,0>}  
 torus{17.4*feet 0.05*feet texture{Stone21} translate<0,0.4*feet,0>}
 torus{17.4*feet 0.05*feet texture{Stone21} translate<0,0.6*feet,0>}   
 torus{19.4*feet 0.05*feet texture{Stone21} translate<0,0.2*feet,0>}  
 torus{19.4*feet 0.05*feet texture{Stone21} translate<0,0.4*feet,0>}
 torus{19.4*feet 0.05*feet texture{Stone21} translate<0,0.6*feet,0>} }  
 
 #declare round3=difference{
 cylinder{<0,0,0><0,1*feet,0>30*feet texture{Stone8}}
 cylinder{<0,0,0><0,3*feet,0>27*feet texture{Stone8}translate<0,-1*feet,0>}}  
 
 //------------------HEART LEAVES------------------------ 

#declare lobea=difference{
sphere{<0,0,0>0.6*feet hollow texture{Green_Vein_Pistachio_Plastic scale 0.25}translate<0,1.125*feet,0>}
cone{<0,0,0>0*feet, <0,1*feet,0>0.605*feet open hollow   texture{Green_Vein_Pistachio_Plastic scale 0.25}} } 

#declare lobe1a=union{
object{lobea } 
cone{<0,0,0>0*feet, <0,1*feet,0>0.605*feet open hollow   texture{Green_Vein_Pistachio_Plastic }}}



#declare lobe2a=difference{
object{lobe1a rotate<0,0,25>}
object{lobe1a rotate<0,0,-25>}}   



#declare lobe3a=difference{ 
object{lobe1a rotate<0,0,-25>}
object{lobe1a rotate<0,0,25>}
}

#declare heart1a=union{ 
object{lobe2a }
object{lobe3a }
scale<1,1,0.5>}  

//-----------------------STEMS----------------------

#declare stem1=difference{
torus{0.6*feet, 0.05*feet texture{Green_Vein_Pistachio_Plastic scale 0.25 }}
box{<0,0,0><3*feet,1*feet,1*feet> texture{Green_Vein_Pistachio_Plastic scale 0.25 } translate<-1.5*feet,-0.6*feet,0*feet>}
//rotate<0,0,30>
} 

#declare leaf=union{
cylinder{<0,0,0><0,0.25*feet,0>0.025 texture{Green_Vein_Pistachio_Plastic scale 0.25}}
object{heart1a scale <0.2,0.2,0.1> rotate<0,0,180>translate<0,0.5*feet,0>}}

#declare stem3=union{
object{stem1}
object{leaf rotate<-140,0,-30> translate<-0.5*feet,0,-0.4*feet>} 
object{leaf rotate<-20,45,0>translate<-0.1*feet,0,-0.55*feet>}
object{leaf rotate<-130,-30,0>translate<0.2*feet,0,-0.5*feet>} 
object{leaf rotate<0,45,-60>translate<0.55*feet,0,-0.2*feet>} 
rotate<0,0,30>}

#declare stem2=union{
object{stem3 }   
object{stem3 rotate<0,180,0>translate<0,0.6*feet,0>}
object{stem3 translate<0,1.2*feet,0>} 
object{stem3 rotate<0,180,0>translate<0,1.8*feet,0>} 
object{stem3 translate<0,2.4*feet,0>} 
object{stem3 rotate<0,180,0>translate<0,3*feet,0>} 
object{stem3 translate<0,3.6*feet,0>} 
object{stem3 rotate<0,180,0>translate<0,4.2*feet,0>}
object{stem3 rotate<0,0,-30>translate<0.05*feet,4.5*feet,0>} }  






#declare outer_column3=union{
object{stem2 scale 0.75 translate<0,0.55*feet,0>}
object{outer_column2 scale 0.5} }
  
  
  
 
 
 #declare level2=union{
 object{flooring2 translate<4.85*feet,9*feet,0>} 
 object{wall3 translate<5*feet,9.5*feet,26.5*feet>}  //12:00   
 object{wall3 translate<5*feet,9.5*feet,-26.5*feet>} //6:00  
 object{wall3 rotate<0,90,0> translate<-21.5*feet,9.5*feet,0>} //9:00
 object{wall3 rotate<0,90,0> translate<31.5*feet,9.5*feet,0>}  //3:00
 object{wall3 rotate<0,60,0> translate<-18*feet,9.5*feet,-13*feet>} //8:00  
 object{wall3 rotate<0,60,0> translate<28*feet,9.5*feet,13*feet>}   //2:00
 object{wall3 rotate<0,30,0> translate<-8*feet,9.5*feet,-23*feet>} //7:00     
 object{wall3 rotate<0,30,0> translate<18*feet,9.5*feet,23*feet>}  //1:00   
 object{wall3 rotate<0,-60,0>translate<-18*feet,9.5*feet,13*feet>} //10:00  
 object{wall3 rotate<0,-30,0>translate<-8*feet,9.5*feet,23*feet>} //11:00 
 object{wall3 rotate<0,-60,0>translate<28*feet,9.5*feet,-13*feet>} //4:00  
 object{wall3 rotate<0,-30,0>translate<18*feet,9.5*feet,-23*feet>} //5:00 
 object{outer_column3 translate<0*feet,9.5*feet,18*feet>} 
 object{outer_column3 translate<5*feet,9.5*feet,19*feet>}    
 object{outer_column3 translate<10*feet,9.5*feet,18*feet>} 
 object{outer_column3 translate<-8.25*feet,9.5*feet,13.25*feet>} 
 object{outer_column3 translate<-4.25*feet,9.5*feet,16.25*feet>} 
 object{outer_column3 translate<14.25*feet,9.5*feet,16.25*feet>} 
 object{outer_column3 translate<18.25*feet,9.5*feet,13.25*feet>}  
 object{outer_column3 translate<-13*feet,9.5*feet,5*feet>} 
 object{outer_column3 translate<-11.5*feet,9.5*feet,9*feet>} 
 object{outer_column3 translate<21.5*feet,9.5*feet,9*feet>}
 object{outer_column3 translate<23*feet,9.5*feet,5*feet>}    
 object{outer_column3 translate<-13*feet,9.5*feet,-5*feet>}  
 object{outer_column3 translate<-13.75*feet,9.5*feet,0*feet>} 
 object{outer_column3 translate<23.75*feet,9.5*feet,0*feet>}
 object{outer_column3 translate<23*feet,9.5*feet,-5*feet>}   
 object{outer_column3 translate<-8.25*feet,9.5*feet,-13.25*feet>} 
 object{outer_column3 translate<-4.25*feet,9.5*feet,-16.25*feet>} 
 object{outer_column3 translate<14.25*feet,9.5*feet,-16.25*feet>} 
 object{outer_column3 translate<18.25*feet,9.5*feet,-13.25*feet>} 
 object{outer_column3 translate<-11*feet,9.5*feet,-10*feet>} 
 object{outer_column3 translate<21*feet,9.5*feet,-10*feet>} 
 object{outer_column3 translate<0*feet,9.5*feet,-18*feet>} 
 object{outer_column3 translate<5*feet,9.5*feet,-19*feet>}    
 object{outer_column3 translate<10*feet,9.5*feet,-18*feet>}  
 object{ballustrade translate<4.85*feet,14*feet,0>} 
 object{round3 translate<4.85*feet,18*feet,0>}
 } 
 
//---------------------DOME ROOF-------------

#declare half1=difference{
sphere{<0,0,0>30*feet  hollow on  texture{Stone8}} 
box{<0,0,0><100*feet,100*feet,100*feet> texture{Stone8} translate<-40*feet,-100*feet,-40*feet>} }

#declare half2=union{
object{half1 } 
torus{30*feet, 0.5*feet texture{Stone21}}  }

#declare half3=difference{
object{half2}
sphere{<0,0,0>,29*feet  texture{Stone8}} 
sphere{<0,0,0>10*feet texture{Stone21}translate<0,30*feet,0>}}

#declare dome=union{
object{half2 }
torus{10*feet,1*feet texture{Stone21}translate<0,30*feet,0>} 
//cylinder{<0,0,0><0,0.1*feet,0>10*feet texture{T_Glass1}translate<0,30*feet,0>} 
}
 
//------------------STAR SPHERE-------------

#declare starry_sky=union{
sphere{<0,0,0>5000*feet hollow texture{Starfield   scale 1} } 
sphere{<0,0,0>1990*feet hollow pigment{P_Cloud1 scale 1000}} 
}

//------------------HEART------------------------ 

#declare lobe=difference{
sphere{<0,0,0>0.6*feet hollow texture{RED_GLASS}translate<0,1.125*feet,0>}
cone{<0,0,0>0*feet, <0,1*feet,0>0.605*feet open hollow   texture{RED_GLASS}} } 

#declare lobe1=union{
object{lobe } 
cone{<0,0,0>0*feet, <0,1*feet,0>0.605*feet open hollow   texture{RED_GLASS}}}



#declare lobe2=difference{
object{lobe1 rotate<0,0,25>}
object{lobe1 rotate<0,0,-25>}}   



#declare lobe3=difference{ 
object{lobe1 rotate<0,0,-25>}
object{lobe1 rotate<0,0,25>}
}

#declare heart1=union{ 
object{lobe2 }
object{lobe3 }
scale<1,1,0.5>}  

//object{heart1}



//-------------------PEDESTAL--------------------

#declare stem=difference{
cylinder{<0,0,0><0,4*feet,0>0.6*feet texture{Stone8}  } 
cylinder{<0,0,0><0,5*feet,0>0.05*feet texture{Stone21} translate<-0.6*feet,-0.6*feet,0>} //9:00
cylinder{<0,0,0><0,5*feet,0>0.05*feet texture{Stone21} translate<0*feet,-0.6*feet,0.6*feet>}//12:00
cylinder{<0,0,0><0,5*feet,0>0.05*feet texture{Stone21} translate<0.6*feet,-0.6*feet,0>} //3:00
cylinder{<0,0,0><0,5*feet,0>0.05*feet texture{Stone21} translate<0*feet,-0.6*feet,-0.6*feet>} //6:00  
cylinder{<0,0,0><0,5*feet,0>0.05*feet texture{Stone21} translate<-0.5*feet,-0.6*feet,0.3*feet>}//10:00
cylinder{<0,0,0><0,5*feet,0>0.05*feet texture{Stone21} translate<-0.3*feet,-0.6*feet,0.5*feet>}//11:00     
cylinder{<0,0,0><0,5*feet,0>0.05*feet texture{Stone21} translate<0.5*feet,-0.6*feet,0.3*feet>}// 2:00
cylinder{<0,0,0><0,5*feet,0>0.05*feet texture{Stone21} translate<0.3*feet,-0.6*feet,0.5*feet>}// 1:00  
cylinder{<0,0,0><0,5*feet,0>0.05*feet texture{Stone21} translate<-0.5*feet,-0.6*feet,-0.3*feet>}// 8:00
cylinder{<0,0,0><0,5*feet,0>0.05*feet texture{Stone21} translate<-0.3*feet,-0.6*feet,-0.5*feet>}//7:00
cylinder{<0,0,0><0,5*feet,0>0.05*feet texture{Stone21} translate<0.5*feet,-0.6*feet,-0.3*feet>}// 4:00
cylinder{<0,0,0><0,5*feet,0>0.05*feet texture{Stone21} translate<0.3*feet,-0.6*feet,-0.5*feet>}// 5:00
}

#declare stem2=union{
object{stem translate<0,0.6*feet,0>} 
cone{<0,0,0>,1*feet <0,0.6*feet,0>0.6*feet texture{Stone8}}
cone{<0,4.6*feet,0>0.6*feet <0,5*feet,0>1*feet texture{Stone8}} }
 
#declare stem3=union{ 
object{stem2 }
torus{0.6*feet,0.1*feet texture{Stone21}translate<0,0.6*feet,0>}   
torus{0.6*feet,0.1*feet texture{Stone21}translate<0,4.6*feet,0>} }

#declare flooring2=union{
   object{sunburst}
   object{ring1  translate<4.85*feet,0,0>}
   object{ring2 translate<4.85*feet,0,0>} 
   object{ring3 translate<4.85*feet,0,0>} 
   object{ring4 translate<4.85*feet,0,0>}}
 
 #declare top=union{
cylinder{<0,0,0><0,0.2*feet,0>2*feet texture{Stone8}translate<0,5.2*feet,0>} 
object{flooring2 scale 0.075 translate<-0.35*feet,5.4*feet,0>}}



#declare pedestal=union{
object{stem3 translate<0,0.2*feet,0>}
torus{1.1*feet, 0.25*feet texture{Stone8}}
object{top scale<0.75,1,0.75>}}  


//------------------PEDESTAL WITH GREENERY----------------

//------------------HEART LEAVES------------------------ 

#declare lobea=difference{
sphere{<0,0,0>0.6*feet hollow texture{Green_Vein_Pistachio_Plastic scale 0.25}translate<0,1.125*feet,0>}
cone{<0,0,0>0*feet, <0,1*feet,0>0.605*feet open hollow   texture{Green_Vein_Pistachio_Plastic scale 0.25}} } 

#declare lobe1a=union{
object{lobea } 
cone{<0,0,0>0*feet, <0,1*feet,0>0.605*feet open hollow   texture{Green_Vein_Pistachio_Plastic }}}



#declare lobe2a=difference{
object{lobe1a rotate<0,0,25>}
object{lobe1a rotate<0,0,-25>}}   



#declare lobe3a=difference{ 
object{lobe1a rotate<0,0,-25>}
object{lobe1a rotate<0,0,25>}
}

#declare heart1a=union{ 
object{lobe2a }
object{lobe3a }
scale<1,1,0.5>}  

//-----------------------STEMS----------------------

#declare stem1=difference{
torus{0.6*feet, 0.05*feet texture{Green_Vein_Pistachio_Plastic scale 0.25 }}
box{<0,0,0><3*feet,1*feet,1*feet> texture{Green_Vein_Pistachio_Plastic scale 0.25 } translate<-1.5*feet,-0.6*feet,0*feet>}
//rotate<0,0,30>
} 

#declare leaf=union{
cylinder{<0,0,0><0,0.25*feet,0>0.025 texture{Green_Vein_Pistachio_Plastic scale 0.25}}
object{heart1a scale <0.2,0.2,0.1> rotate<0,0,180>translate<0,0.5*feet,0>}} 

#declare leaf2=
object{leaf rotate<0,90,-60>}

#declare stem3=union{
object{stem1}
object{leaf rotate<-140,0,-30> translate<-0.5*feet,0,-0.4*feet>} 
object{leaf rotate<-20,45,0>translate<-0.1*feet,0,-0.55*feet>}
object{leaf rotate<-130,-30,0>translate<0.2*feet,0,-0.5*feet>} 
object{leaf rotate<0,45,-60>translate<0.55*feet,0,-0.2*feet>} 
rotate<0,0,30>}

#declare stem2=union{
object{stem3 }   
object{stem3 rotate<0,180,0>translate<0,0.6*feet,0>}
object{stem3 translate<0,1.2*feet,0>} 
object{stem3 rotate<0,180,0>translate<0,1.8*feet,0>} 
object{stem3 translate<0,2.4*feet,0>} 
object{stem3 rotate<0,180,0>translate<0,3*feet,0>} 
object{stem3 translate<0,3.6*feet,0>} 
object{stem3 rotate<0,180,0>translate<0,4.2*feet,0>}
object{stem3 rotate<0,0,-20>translate<0.05*feet,4.5*feet,0>} }  

#declare stem4=difference{ 
object{stem1 rotate<90,0,20>}
box{<0,0,0><1*feet,1*feet,1*feet> texture{Green_Vein_Pistachio_Plastic scale 0.25}translate<-1.3*feet,-0.3*feet,-0.6*feet>}
 }







#declare outer_column3=union{
object{stem2 scale 0.75 translate<0,0.55*feet,0>}
object{outer_column2 scale 0.5} }  


//-------------------Vine and Leaves----------------------------   

#declare vine2= 
 object{vine  scale 0.05 rotate<90,0,0> translate<18*feet,-0.1*feet,-20.5*feet>}  
 
 #declare vine3=union{
 object{vine2}
 object{leaf2 translate<1.5*feet,-0.05*feet,-0.25*feet>}     
 object{leaf2 rotate<60,0,0>translate<2.25*feet,-0.05*feet,-0.2*feet>}    
 object{leaf2 rotate<-50,0,0>translate<3.15*feet,-0.05*feet,-0.25*feet>} 
 object{leaf2 rotate<10,0,0>translate<3.95*feet,-0.05*feet,-0.295*feet>} 
 object{leaf2 rotate<70,0,0>translate<4.5*feet,-0.05*feet,-0.45*feet>} 
 object{leaf2 rotate<-60,0,0>translate<5*feet,-0.05*feet,-0.6*feet>}
 object{leaf2 rotate<0,0,0>translate<5.65*feet,-0.05*feet,-0.35*feet>} 
 object{leaf2 rotate<40,0,0>translate<6.5*feet,-0.05*feet,-0.1*feet>}
 object{leaf2 rotate<-50,0,0>translate<6.95*feet,-0.05*feet,-0.15*feet>} 
 object{leaf2 rotate<-10,0,0>translate<7.5*feet,-0.05*feet,-0.35*feet>} 
 object{leaf2 rotate<70,0,0>translate<8.05*feet,-0.05*feet,-0.55*feet>} 
 object{leaf2 rotate<-60,0,0>translate<8.65*feet,-0.05*feet,-0.975*feet>}
 object{leaf2 rotate<0,0,0>translate<9.25*feet,-0.05*feet,-1 *feet>} 
 object{leaf2 rotate<40,0,0>translate<9.85*feet,-0.05*feet,-1*feet>} 
 object{leaf2 rotate<-50,0,0>translate<10.45*feet,-0.05*feet,-1.2*feet>} 
 object{leaf2 rotate<10,0,0>translate<10.95*feet,-0.05*feet,-1.2*feet>} 
 object{leaf2 rotate<60,0,0>translate<11.5*feet,-0.05*feet,-1.2*feet>} 
 object{leaf2 rotate<-60,0,0>translate<12.2*feet,-0.05*feet,-1.35*feet>} 
 object{leaf2 rotate<-10,0,0>translate<12.9*feet,-0.05*feet,-1.25*feet>}  
 object{leaf2 rotate<70,0,0>translate<13.45*feet,-0.05*feet,-1.1*feet>} 
 object{leaf2 rotate<-50,0,0>translate<14.1*feet,-0.05*feet,-1.1*feet>} 
 object{leaf2 rotate<0,0,0>translate<14.85*feet,-0.05*feet,-0.95*feet>} 
 object{leaf2 rotate<60,0,0>translate<15.35*feet,-0.05*feet,-0.9*feet>} 
 object{leaf2 rotate<-70,0,0>translate<15.95*feet,-0.05*feet,-1.05*feet>} 
 object{leaf2 rotate<10,0,0>translate<16.6*feet,-0.05*feet,-1.05*feet>}
 object{leaf2 rotate<50,0,0>translate<17.25*feet,-0.05*feet,-1.1*feet>} 
 object{leaf2 rotate<-60,0,0>translate<17.9*feet,-0.05*feet,-1.35*feet>} 
 object{leaf2 rotate<0,0,0>translate<18.45*feet,-0.05*feet,-1.35*feet>}
 object{leaf2 rotate<60,0,0>translate<19*feet,-0.05*feet,-1.3*feet>}
 object{leaf2 rotate<-65,0,0>translate<19.5*feet,-0.05*feet,-1.35*feet>} 
 object{leaf2 rotate<-10,0,0>translate<20.1*feet,-0.05*feet,-1.2*feet>}
 object{leaf2 rotate<50,0,0>translate<20.75*feet,-0.05*feet,-1.0*feet>} 
 object{leaf2 rotate<-60,0,0>translate<21.5*feet,-0.05*feet,-0.9*feet>} 
 object{leaf2 rotate<0,0,0>translate<22.25*feet,-0.05*feet,-0.6*feet>} 
 object{leaf2 rotate<60,0,0>translate<23.25*feet,-0.05*feet,-0.3*feet>}
 object{leaf2 rotate<-50,0,0>translate<23.9*feet,-0.05*feet,-0.65*feet>} 
 object{leaf2 rotate<10,0,0>translate<24.9*feet,-0.05*feet,-1.05*feet>} 
 object{leaf2 rotate<70,0,0>translate<25.4*feet,-0.05*feet,-0.95*feet>} 
 object{leaf2 rotate<-60,0,0>translate<26.1*feet,-0.05*feet,-1.05*feet>} 
 object{leaf2 rotate<0,0,0>translate<26.8*feet,-0.05*feet,-1*feet>}
 object{leaf2 rotate<-60,0,0>translate<27.4*feet,-0.05*feet,-0.65*feet>} 
 object{leaf2 rotate<-50,0,0>translate<28.2*feet,-0.05*feet,-0.2*feet>}  
 object{leaf2 rotate<10,0,0>translate<28.6*feet,-0.05*feet,0.1*feet>}
 object{leaf2 rotate<60,0,0>translate<29.3*feet,-0.05*feet,0*feet>} 
 object{leaf2 rotate<-70,0,0>translate<30*feet,-0.05*feet,-0.15*feet>}  
 object{leaf2 rotate<0,0,0>translate<30.75*feet,-0.05*feet,-0.2*feet>}  
 object{leaf2 rotate<40,0,0>translate<31.5*feet,-0.05*feet,-0.25*feet>} 
 object{leaf2 rotate<-60,0,0>translate<32.25*feet,-0.05*feet,-0.4*feet>} 
 object{leaf2 rotate<10,0,0>translate<33.5*feet,-0.05*feet,0*feet>}
 object{leaf2 rotate<60,0,0>translate<34.35*feet,-0.05*feet,0.5*feet>} 
 object{leaf2 rotate<-50,0,0>translate<35*feet,-0.05*feet,0.45*feet>} 
 object{leaf2 rotate<0,0,0>translate<35.9*feet,-0.05*feet,0.5*feet>}
 object{leaf2 rotate<70,0,0>translate<36.5*feet,-0.05*feet,0.5*feet>}
 object{leaf2 rotate<-60,0,0>translate<37.25*feet,-0.05*feet,0.2*feet>} 
 object{leaf2 rotate<0,0,0>translate<38*feet,-0.05*feet,0*feet>} }
 
 #declare top_stem=union{
object{stem3 scale<1.5,0.75,1.25> rotate<0,180,20>translate<0,4.7*feet,0>}
object{stem3 scale <1.25,0.75,1.25>rotate<0,0,-20>translate<0,4.7*feet,0>}}

#declare bottom_stem=union{ 
object{stem3 scale<1.5,0.75,1.25>rotate<0,0,-20>translate<0,0.8*feet,0>}
object{stem3 scale<1.5,0.75,1.25>rotate<0,180,20>translate<0,0.8*feet,0>}} 

#declare bottom2_stem=union{
object{stem3 scale<2.75,1,2.75>rotate<0,0,-12.5>}   
object{stem3 scale<2.75,1,2.75>rotate<0,180,12.5>}}


#declare pedestal2=union{
object{stem2 scale <1.25,0.75,1.25>translate<0,1.25*feet,0>} 
object{top_stem}
object{bottom_stem}
object{bottom2_stem} 
object{pedestal} 
object{vine3 translate<0,0,0.25*feet>} 
object{vine3 rotate<0,30,0> translate<0.45*feet,0,0>}
object{vine3 rotate<0,60,0> translate<0.45*feet,0,0>}
object{vine3 rotate<0,90,0> translate<0.45*feet,0,0>} 
object{vine3 rotate<0,120,0> translate<-0.35*feet,0,0>} 
object{vine3 rotate<0,150,0> translate<-0.3*feet,0,0>}
object{vine3 rotate<0,180,0> translate<-0.35*feet,0,-0.1*feet>}
object{vine3 rotate<0,210,0> translate<-0.25*feet,0,0>}    
object{vine3 rotate<0,240,0> translate<-0.25*feet,0,0>}
object{vine3 rotate<0,270,0> translate<-0.2*feet,0,0>}  
object{vine3 rotate<0,300,0> translate<-0.2*feet,0,0>}  
object{vine3 rotate<0,330,0> translate<-0.2*feet,0,0>}}
  


// ----------------------------------------
camera
{
  location  <4.85*feet, 7*feet, -24.5*feet>
  direction 1.5*z
  right     4/3*x
  look_at   <5.0*feet, 6.0*feet,  0*feet>
}                               

sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <100*feet, 4500*feet, 100*feet>
}  


light_source
{
  0*x // light's position (translated below)
  color red 3.5  green 0.0  blue 0.0  // light's color
  translate <4.85*feet, 5.10*feet, 0*feet> 
  fade_distance 25
 fade_power 3
}  
 

 
 //----------------SCENE----------------------
 
 
 object{starry_sky}
 object{level1}
 object{level2 rotate<0,15,0>translate<0,-0.25*feet,0>} 
 object{dome translate<4.85*feet,19*feet,0>} 
 object{pedestal2 scale <0.6,0.75,0.6> translate<4.85*feet,0.1*feet,0>}
 object{heart1 translate<4.85*feet,4.4*feet,0>} 
 
 
  






















