
// Persistence of Vision Ray Tracer Scene Description File
// File: .inc
// Vers: 3.1
// Desc: a sword include modeled with Amapi and textured from Textureview
// Date: 3/19/01 
// Auth: Teri Hoskins (isokesa@yahoo.com) 

#version 3.1;
#version unofficial MegaPov 0.7;  




// file issue from Amapi  

//-------------------TEXTURES-------------------------

// >>> Brushed_Aluminum (from file "povlab.inc", line 6764) <<<
#declare Brushed_Aluminum = texture {
  pigment {
    rgb <0, 0, 0> 
  }
  finish {
    ambient 1
    diffuse 0.7
    reflection 0.9
    phong 1.0
  }
  normal {
    bumps -0.5
    scale <1, 0.001, 0.001>
  }
}







// >>> wall_tex (from file "world2.inc", line 12) <<<
#declare wall_tex = texture {
  pigment {
    color rgb <0.77,0.74,0.66> 
  }
  finish {
    specular 0.45 roughness 0.3  ambient 0.7
  }
  normal {
    bumps 0.3 scale 1/2 omega 0.75 octaves 5 
  }
}


//-----------------------------------------------------------
 /* camera {
    location <14.3739, -138.8944, 620.7429>
    right -4/3*x
    //up <0.0000, 1.0000, 0.0000>
    look_at <16.9082, 390.9127, -2.4038>
    //angle 1151.6452
  }

  light_source { <14.3739, -138.8944, 2420.7429> color rgb<1, 1, 1> }  
 */ 
  //-----------------SWORD----------------------
  
  #declare sword=union{

  mesh { // Surf2 
    smooth_triangle { <15.7480, 223.1535, 9.5737>, <0.0096, 0.2402, 0.9707>, <30.7036, 223.1564, 5.6865>, <0.5406, 0.2899, 0.7897>, <27.7125, 233.4993, 3.9572>, <0.5392, 0.2899, 0.7907> }
    smooth_triangle { <27.7125, 233.4993, 3.9572>, <0.5392, 0.2899, 0.7907>, <15.7480, 233.4985, 6.9965>, <0.0083, 0.2392, 0.9709>, <15.7480, 223.1535, 9.5737>, <0.0096, 0.2402, 0.9707> }
    smooth_triangle { <30.7036, 223.1564, 5.6865>, <0.5406, 0.2899, 0.7897>, <36.8984, 223.1617, -3.1378>, <0.7763, 0.3151, 0.5459>, <32.6683, 233.5089, -3.0826>, <0.7757, 0.3154, 0.5467> }
    smooth_triangle { <32.6683, 233.5089, -3.0826>, <0.7757, 0.3154, 0.5467>, <27.7125, 233.4993, 3.9572>, <0.5392, 0.2899, 0.7907>, <30.7036, 223.1564, 5.6865>, <0.5406, 0.2899, 0.7897> }
    smooth_triangle { <36.8984, 223.1617, -3.1378>, <0.7762, 0.3212, -0.5425>, <30.7036, 223.2330, -11.9785>, <0.5383, 0.2981, -0.7883>, <27.7125, 233.5772, -10.1146>, <0.5375, 0.2970, -0.7893> }
    smooth_triangle { <27.7125, 233.5772, -10.1146>, <0.5375, 0.2970, -0.7893>, <32.6683, 233.5089, -3.0826>, <0.7758, 0.3207, -0.5435>, <36.8984, 223.1617, -3.1378>, <0.7762, 0.3212, -0.5425> }
    smooth_triangle { <30.7036, 223.2330, -11.9785>, <0.5383, 0.2981, -0.7883>, <15.7480, 223.5412, -15.6868>, <0.0032, 0.2473, -0.9689>, <15.7480, 233.8163, -13.0464>, <0.0030, 0.2454, -0.9694> }
    smooth_triangle { <15.7480, 233.8163, -13.0464>, <0.0030, 0.2454, -0.9694>, <27.7125, 233.5772, -10.1146>, <0.5375, 0.2970, -0.7893>, <30.7036, 223.2330, -11.9785>, <0.5383, 0.2981, -0.7883> }
    smooth_triangle { <15.7480, 223.5412, -15.6868>, <0.0032, 0.2473, -0.9689>, <0.7925, 223.7503, -11.9541>, <-0.5410, 0.3006, -0.7854>, <3.7836, 233.9840, -10.0886>, <-0.5396, 0.2993, -0.7869> }
    smooth_triangle { <3.7836, 233.9840, -10.0886>, <-0.5396, 0.2993, -0.7869>, <15.7480, 233.8163, -13.0464>, <0.0030, 0.2454, -0.9694>, <15.7480, 223.5412, -15.6868>, <0.0032, 0.2473, -0.9689> }
    smooth_triangle { <0.7925, 223.7503, -11.9541>, <-0.5410, 0.3006, -0.7854>, <-5.4023, 223.4327, -2.9423>, <-0.7838, 0.3231, -0.5304>, <-1.1723, 233.7598, -2.9544>, <-0.7823, 0.3226, -0.5329> }
    smooth_triangle { <-1.1723, 233.7598, -2.9544>, <-0.7823, 0.3226, -0.5329>, <3.7836, 233.9840, -10.0886>, <-0.5396, 0.2993, -0.7869>, <0.7925, 223.7503, -11.9541>, <-0.5410, 0.3006, -0.7854> }
    smooth_triangle { <-5.4023, 223.4327, -2.9423>, <-0.7741, 0.3202, 0.5462>, <0.7925, 223.1810, 6.0316>, <-0.5311, 0.2959, 0.7940>, <3.7836, 233.5412, 4.1515>, <-0.5302, 0.2948, 0.7949> }
    smooth_triangle { <3.7836, 233.5412, 4.1515>, <-0.5302, 0.2948, 0.7949>, <-1.1723, 233.7598, -2.9544>, <-0.7728, 0.3196, 0.5483>, <-5.4023, 223.4327, -2.9423>, <-0.7741, 0.3202, 0.5462> }
    smooth_triangle { <0.7925, 223.1810, 6.0316>, <-0.5311, 0.2959, 0.7940>, <15.7480, 223.1535, 9.5737>, <0.0096, 0.2402, 0.9707>, <15.7480, 233.4985, 6.9965>, <0.0083, 0.2392, 0.9709> }
    smooth_triangle { <15.7480, 233.4985, 6.9965>, <0.0083, 0.2392, 0.9709>, <3.7836, 233.5412, 4.1515>, <-0.5302, 0.2948, 0.7949>, <0.7925, 223.1810, 6.0316>, <-0.5311, 0.2959, 0.7940> }
    smooth_triangle { <15.7480, 233.4985, 6.9965>, <0.0083, 0.2392, 0.9709>, <27.7125, 233.4993, 3.9572>, <0.5392, 0.2899, 0.7907>, <24.7214, 243.8393, 2.2135>, <0.5363, 0.2892, 0.7929> }
    smooth_triangle { <24.7214, 243.8393, 2.2135>, <0.5363, 0.2892, 0.7929>, <15.7480, 243.8437, 4.4452>, <0.0060, 0.2367, 0.9716>, <15.7480, 233.4985, 6.9965>, <0.0083, 0.2392, 0.9709> }
    smooth_triangle { <27.7125, 233.4993, 3.9572>, <0.5392, 0.2899, 0.7907>, <32.6683, 233.5089, -3.0826>, <0.7757, 0.3154, 0.5467>, <28.4382, 243.8521, -3.0391>, <0.7743, 0.3153, 0.5487> }
    smooth_triangle { <28.4382, 243.8521, -3.0391>, <0.7743, 0.3153, 0.5487>, <24.7214, 243.8393, 2.2135>, <0.5363, 0.2892, 0.7929>, <27.7125, 233.4993, 3.9572>, <0.5392, 0.2899, 0.7907> }
    smooth_triangle { <32.6683, 233.5089, -3.0826>, <0.7758, 0.3207, -0.5435>, <27.7125, 233.5772, -10.1146>, <0.5375, 0.2970, -0.7893>, <24.7214, 243.9178, -8.2793>, <0.5359, 0.2943, -0.7913> }
    smooth_triangle { <24.7214, 243.9178, -8.2793>, <0.5359, 0.2943, -0.7913>, <28.4382, 243.8521, -3.0391>, <0.7749, 0.3193, -0.5455>, <32.6683, 233.5089, -3.0826>, <0.7758, 0.3207, -0.5435> }
    smooth_triangle { <27.7125, 233.5772, -10.1146>, <0.5375, 0.2970, -0.7893>, <15.7480, 233.8163, -13.0464>, <0.0030, 0.2454, -0.9694>, <15.7480, 244.0924, -10.4533>, <0.0026, 0.2414, -0.9704> }
    smooth_triangle { <15.7480, 244.0924, -10.4533>, <0.0026, 0.2414, -0.9704>, <24.7214, 243.9178, -8.2793>, <0.5359, 0.2943, -0.7913>, <27.7125, 233.5772, -10.1146>, <0.5375, 0.2970, -0.7893> }
    smooth_triangle { <15.7480, 233.8163, -13.0464>, <0.0030, 0.2454, -0.9694>, <3.7836, 233.9840, -10.0886>, <-0.5396, 0.2993, -0.7869>, <6.7747, 244.2079, -8.2571>, <-0.5368, 0.2964, -0.7900> }
    smooth_triangle { <6.7747, 244.2079, -8.2571>, <-0.5368, 0.2964, -0.7900>, <15.7480, 244.0924, -10.4533>, <0.0026, 0.2414, -0.9704>, <15.7480, 233.8163, -13.0464>, <0.0030, 0.2454, -0.9694> }
    smooth_triangle { <3.7836, 233.9840, -10.0886>, <-0.5396, 0.2993, -0.7869>, <-1.1723, 233.7598, -2.9544>, <-0.7823, 0.3226, -0.5329>, <3.0578, 244.0658, -2.9653>, <-0.7792, 0.3212, -0.5381> }
    smooth_triangle { <3.0578, 244.0658, -2.9653>, <-0.7792, 0.3212, -0.5381>, <6.7747, 244.2079, -8.2571>, <-0.5368, 0.2964, -0.7900>, <3.7836, 233.9840, -10.0886>, <-0.5396, 0.2993, -0.7869> }
    smooth_triangle { <-1.1723, 233.7598, -2.9544>, <-0.7728, 0.3196, 0.5483>, <3.7836, 233.5412, 4.1515>, <-0.5302, 0.2948, 0.7949>, <6.7747, 243.8963, 2.3084>, <-0.5286, 0.2922, 0.7970> }
    smooth_triangle { <6.7747, 243.8963, 2.3084>, <-0.5286, 0.2922, 0.7970>, <3.0578, 244.0658, -2.9653>, <-0.7703, 0.3182, 0.5526>, <-1.1723, 233.7598, -2.9544>, <-0.7728, 0.3196, 0.5483> }
    smooth_triangle { <3.7836, 233.5412, 4.1515>, <-0.5302, 0.2948, 0.7949>, <15.7480, 233.4985, 6.9965>, <0.0083, 0.2392, 0.9709>, <15.7480, 243.8437, 4.4452>, <0.0060, 0.2367, 0.9716> }
    smooth_triangle { <15.7480, 243.8437, 4.4452>, <0.0060, 0.2367, 0.9716>, <6.7747, 243.8963, 2.3084>, <-0.5286, 0.2922, 0.7970>, <3.7836, 233.5412, 4.1515>, <-0.5302, 0.2948, 0.7949> }
    smooth_triangle { <15.7480, 243.8437, 4.4452>, <0.0060, 0.2367, 0.9716>, <24.7214, 243.8393, 2.2135>, <0.5363, 0.2892, 0.7929>, <21.7302, 254.1971, 0.4681>, <0.5334, 0.2876, 0.7955> }
    smooth_triangle { <21.7302, 254.1971, 0.4681>, <0.5334, 0.2876, 0.7955>, <15.7480, 254.2068, 1.9272>, <0.0043, 0.2335, 0.9724>, <15.7480, 243.8437, 4.4452>, <0.0060, 0.2367, 0.9716> }
    smooth_triangle { <24.7214, 243.8393, 2.2135>, <0.5363, 0.2892, 0.7929>, <28.4382, 243.8521, -3.0391>, <0.7743, 0.3153, 0.5487>, <24.2082, 254.2122, -3.0077>, <0.7724, 0.3147, 0.5517> }
    smooth_triangle { <24.2082, 254.2122, -3.0077>, <0.7724, 0.3147, 0.5517>, <21.7302, 254.1971, 0.4681>, <0.5334, 0.2876, 0.7955>, <24.7214, 243.8393, 2.2135>, <0.5363, 0.2892, 0.7929> }
    smooth_triangle { <28.4382, 243.8521, -3.0391>, <0.7749, 0.3193, -0.5455>, <24.7214, 243.9178, -8.2793>, <0.5359, 0.2943, -0.7913>, <21.7302, 254.2702, -6.4753>, <0.5344, 0.2914, -0.7934> }
    smooth_triangle { <21.7302, 254.2702, -6.4753>, <0.5344, 0.2914, -0.7934>, <24.2082, 254.2122, -3.0077>, <0.7741, 0.3177, -0.5475>, <28.4382, 243.8521, -3.0391>, <0.7749, 0.3193, -0.5455> }
    smooth_triangle { <24.7214, 243.9178, -8.2793>, <0.5359, 0.2943, -0.7913>, <15.7480, 244.0924, -10.4533>, <0.0026, 0.2414, -0.9704>, <15.7480, 254.3828, -7.9096>, <0.0023, 0.2370, -0.9715> }
    smooth_triangle { <15.7480, 254.3828, -7.9096>, <0.0023, 0.2370, -0.9715>, <21.7302, 254.2702, -6.4753>, <0.5344, 0.2914, -0.7934>, <24.7214, 243.9178, -8.2793>, <0.5359, 0.2943, -0.7913> }
    smooth_triangle { <15.7480, 244.0924, -10.4533>, <0.0026, 0.2414, -0.9704>, <6.7747, 244.2079, -8.2571>, <-0.5368, 0.2964, -0.7900>, <9.7658, 254.4485, -6.4613>, <-0.5340, 0.2930, -0.7931> }
    smooth_triangle { <9.7658, 254.4485, -6.4613>, <-0.5340, 0.2930, -0.7931>, <15.7480, 254.3828, -7.9096>, <0.0023, 0.2370, -0.9715>, <15.7480, 244.0924, -10.4533>, <0.0026, 0.2414, -0.9704> }
    smooth_triangle { <6.7747, 244.2079, -8.2571>, <-0.5368, 0.2964, -0.7900>, <3.0578, 244.0658, -2.9653>, <-0.7792, 0.3212, -0.5381>, <7.2879, 254.3716, -2.9741>, <-0.7762, 0.3195, -0.5435> }
    smooth_triangle { <7.2879, 254.3716, -2.9741>, <-0.7762, 0.3195, -0.5435>, <9.7658, 254.4485, -6.4613>, <-0.5340, 0.2930, -0.7931>, <6.7747, 244.2079, -8.2571>, <-0.5368, 0.2964, -0.7900> }
    smooth_triangle { <3.0578, 244.0658, -2.9653>, <-0.7703, 0.3182, 0.5526>, <6.7747, 243.8963, 2.3084>, <-0.5286, 0.2922, 0.7970>, <9.7658, 254.2593, 0.5042>, <-0.5268, 0.2893, 0.7992> }
    smooth_triangle { <9.7658, 254.2593, 0.5042>, <-0.5268, 0.2893, 0.7992>, <7.2879, 254.3716, -2.9741>, <-0.7681, 0.3166, 0.5566>, <3.0578, 244.0658, -2.9653>, <-0.7703, 0.3182, 0.5526> }
    smooth_triangle { <6.7747, 243.8963, 2.3084>, <-0.5286, 0.2922, 0.7970>, <15.7480, 243.8437, 4.4452>, <0.0060, 0.2367, 0.9716>, <15.7480, 254.2068, 1.9272>, <0.0043, 0.2335, 0.9724> }
    smooth_triangle { <15.7480, 254.2068, 1.9272>, <0.0043, 0.2335, 0.9724>, <9.7658, 254.2593, 0.5042>, <-0.5268, 0.2893, 0.7992>, <6.7747, 243.8963, 2.3084>, <-0.5286, 0.2922, 0.7970> }
    smooth_triangle { <15.7480, 254.2068, 1.9272>, <0.0043, 0.2335, 0.9724>, <21.7302, 254.1971, 0.4681>, <0.5334, 0.2876, 0.7955>, <18.7391, 264.5725, -1.2667>, <0.5309, 0.2853, 0.7980> }
    smooth_triangle { <18.7391, 264.5725, -1.2667>, <0.5309, 0.2853, 0.7980>, <15.7480, 264.5829, -0.5501>, <0.0032, 0.2297, 0.9733>, <15.7480, 254.2068, 1.9272>, <0.0043, 0.2335, 0.9724> }
    smooth_triangle { <21.7302, 254.1971, 0.4681>, <0.5334, 0.2876, 0.7955>, <24.2082, 254.2122, -3.0077>, <0.7724, 0.3147, 0.5517>, <19.9781, 264.5857, -2.9881>, <0.7706, 0.3136, 0.5549> }
    smooth_triangle { <19.9781, 264.5857, -2.9881>, <0.7706, 0.3136, 0.5549>, <18.7391, 264.5725, -1.2667>, <0.5309, 0.2853, 0.7980>, <21.7302, 254.1971, 0.4681>, <0.5334, 0.2876, 0.7955> }
    smooth_triangle { <24.2082, 254.2122, -3.0077>, <0.7741, 0.3177, -0.5475>, <21.7302, 254.2702, -6.4753>, <0.5344, 0.2914, -0.7934>, <18.7391, 264.6242, -4.7071>, <0.5333, 0.2884, -0.7953> }
    smooth_triangle { <18.7391, 264.6242, -4.7071>, <0.5333, 0.2884, -0.7953>, <19.9781, 264.5857, -2.9881>, <0.7735, 0.3161, -0.5494>, <24.2082, 254.2122, -3.0077>, <0.7741, 0.3177, -0.5475> }
    smooth_triangle { <21.7302, 254.2702, -6.4753>, <0.5344, 0.2914, -0.7934>, <15.7480, 254.3828, -7.9096>, <0.0023, 0.2370, -0.9715>, <15.7480, 264.6776, -5.4175>, <0.0022, 0.2326, -0.9726> }
    smooth_triangle { <15.7480, 264.6776, -5.4175>, <0.0022, 0.2326, -0.9726>, <18.7391, 264.6242, -4.7071>, <0.5333, 0.2884, -0.7953>, <21.7302, 254.2702, -6.4753>, <0.5344, 0.2914, -0.7934> }
    smooth_triangle { <15.7480, 254.3828, -7.9096>, <0.0023, 0.2370, -0.9715>, <9.7658, 254.4485, -6.4613>, <-0.5340, 0.2930, -0.7931>, <12.7569, 264.7038, -4.7023>, <-0.5316, 0.2898, -0.7959> }
    smooth_triangle { <12.7569, 264.7038, -4.7023>, <-0.5316, 0.2898, -0.7959>, <15.7480, 264.6776, -5.4175>, <0.0022, 0.2326, -0.9726>, <15.7480, 254.3828, -7.9096>, <0.0023, 0.2370, -0.9715> }
    smooth_triangle { <9.7658, 254.4485, -6.4613>, <-0.5340, 0.2930, -0.7931>, <7.2879, 254.3716, -2.9741>, <-0.7762, 0.3195, -0.5435>, <11.5180, 264.6738, -2.9795>, <-0.7736, 0.3180, -0.5481> }
    smooth_triangle { <11.5180, 264.6738, -2.9795>, <-0.7736, 0.3180, -0.5481>, <12.7569, 264.7038, -4.7023>, <-0.5316, 0.2898, -0.7959>, <9.7658, 254.4485, -6.4613>, <-0.5340, 0.2930, -0.7931> }
    smooth_triangle { <7.2879, 254.3716, -2.9741>, <-0.7681, 0.3166, 0.5566>, <9.7658, 254.2593, 0.5042>, <-0.5268, 0.2893, 0.7992>, <12.7569, 264.6197, -1.2592>, <-0.5253, 0.2864, 0.8013> }
    smooth_triangle { <12.7569, 264.6197, -1.2592>, <-0.5253, 0.2864, 0.8013>, <11.5180, 264.6738, -2.9795>, <-0.7663, 0.3151, 0.5599>, <7.2879, 254.3716, -2.9741>, <-0.7681, 0.3166, 0.5566> }
    smooth_triangle { <9.7658, 254.2593, 0.5042>, <-0.5268, 0.2893, 0.7992>, <15.7480, 254.2068, 1.9272>, <0.0043, 0.2335, 0.9724>, <15.7480, 264.5829, -0.5501>, <0.0032, 0.2297, 0.9733> }
    smooth_triangle { <15.7480, 264.5829, -0.5501>, <0.0032, 0.2297, 0.9733>, <12.7569, 264.6197, -1.2592>, <-0.5253, 0.2864, 0.8013>, <9.7658, 254.2593, 0.5042>, <-0.5268, 0.2893, 0.7992> }
    smooth_triangle { <15.7480, 264.5829, -0.5501>, <0.0032, 0.2297, 0.9733>, <18.7391, 264.5725, -1.2667>, <0.5309, 0.2853, 0.7980>, <15.7480, 274.9749, -2.9796>, <0.0030, 0.3347, 0.9423> }
    smooth_triangle { <18.7391, 264.5725, -1.2667>, <0.5309, 0.2853, 0.7980>, <19.9781, 264.5857, -2.9881>, <0.7706, 0.3136, 0.5549>, <15.7480, 274.9749, -2.9796>, <0.0030, 0.3347, 0.9423> }
    smooth_triangle { <19.9781, 264.5857, -2.9881>, <0.7735, 0.3161, -0.5494>, <18.7391, 264.6242, -4.7071>, <0.5333, 0.2884, -0.7953>, <15.7480, 274.9749, -2.9796>, <0.0015, 0.3395, -0.9406> }
    smooth_triangle { <18.7391, 264.6242, -4.7071>, <0.5333, 0.2884, -0.7953>, <15.7480, 264.6776, -5.4175>, <0.0022, 0.2326, -0.9726>, <15.7480, 274.9749, -2.9796>, <0.0015, 0.3395, -0.9406> }
    smooth_triangle { <15.7480, 264.6776, -5.4175>, <0.0022, 0.2326, -0.9726>, <12.7569, 264.7038, -4.7023>, <-0.5316, 0.2898, -0.7959>, <15.7480, 274.9749, -2.9796>, <0.0015, 0.3395, -0.9406> }
    smooth_triangle { <12.7569, 264.7038, -4.7023>, <-0.5316, 0.2898, -0.7959>, <11.5180, 264.6738, -2.9795>, <-0.7736, 0.3180, -0.5481>, <15.7480, 274.9749, -2.9796>, <0.0015, 0.3395, -0.9406> }
    smooth_triangle { <11.5180, 264.6738, -2.9795>, <-0.7663, 0.3151, 0.5599>, <12.7569, 264.6197, -1.2592>, <-0.5253, 0.2864, 0.8013>, <15.7480, 274.9749, -2.9796>, <0.0030, 0.3347, 0.9423> }
    smooth_triangle { <12.7569, 264.6197, -1.2592>, <-0.5253, 0.2864, 0.8013>, <15.7480, 264.5829, -0.5501>, <0.0032, 0.2297, 0.9733>, <15.7480, 274.9749, -2.9796>, <0.0030, 0.3347, 0.9423> }
    smooth_triangle { <0.7925, 223.1810, 6.0316>, <0.0054, -0.9995, -0.0316>, <0.7925, 223.7503, -11.9541>, <-0.0023, -0.9997, -0.0262>, <15.7480, 223.1535, 9.5737>, <-0.0053, -0.9998, -0.0208> }
    smooth_triangle { <0.7925, 223.1810, 6.0316>, <0.0054, -0.9995, -0.0316>, <-5.4023, 223.4327, -2.9423>, <0.0052, -0.9995, -0.0316>, <0.7925, 223.7503, -11.9541>, <-0.0023, -0.9997, -0.0262> }
    smooth_triangle { <0.7925, 223.7503, -11.9541>, <-0.0023, -0.9997, -0.0262>, <15.7480, 223.5412, -15.6868>, <-0.0137, -0.9998, -0.0117>, <15.7480, 223.1535, 9.5737>, <-0.0053, -0.9998, -0.0208> }
    smooth_triangle { <30.7036, 223.2330, -11.9785>, <-0.0124, -0.9999, -0.0043>, <36.8984, 223.1617, -3.1378>, <-0.0053, -1.0000, -0.0043>, <30.7036, 223.1564, 5.6865>, <-0.0096, -0.9999, -0.0080> }
    smooth_triangle { <15.7480, 223.1535, 9.5737>, <-0.0053, -0.9998, -0.0208>, <15.7480, 223.5412, -15.6868>, <-0.0137, -0.9998, -0.0117>, <30.7036, 223.1564, 5.6865>, <-0.0096, -0.9999, -0.0080> }
    smooth_triangle { <30.7036, 223.1564, 5.6865>, <-0.0096, -0.9999, -0.0080>, <15.7480, 223.5412, -15.6868>, <-0.0137, -0.9998, -0.0117>, <30.7036, 223.2330, -11.9785>, <-0.0124, -0.9999, -0.0043> }
    texture {
      Brushed_Aluminum
    }
  }

  mesh { // Surf1 
    smooth_triangle { <15.7480, 223.1526, 10.8266>, <-0.0146, -0.0062, -0.9999>, <30.7036, 223.1548, 6.9197>, <-0.5734, -0.0024, -0.8193>, <30.7036, 195.5953, 6.9780>, <-0.5760, -0.0019, -0.8175> }
    smooth_triangle { <30.7036, 195.5953, 6.9780>, <-0.5760, -0.0019, -0.8175>, <15.7480, 195.5918, 11.0260>, <-0.0170, -0.0051, -0.9998>, <15.7480, 223.1526, 10.8266>, <-0.0146, -0.0062, -0.9999> }
    smooth_triangle { <30.7036, 223.1548, 6.9197>, <-0.5734, -0.0024, -0.8193>, <36.8984, 223.1601, -1.8973>, <-0.8200, -0.0000, -0.5724>, <36.8984, 195.6070, -1.9537>, <-0.8214, 0.0001, -0.5703> }
    smooth_triangle { <36.8984, 195.6070, -1.9537>, <-0.8214, 0.0001, -0.5703>, <30.7036, 195.5953, 6.9780>, <-0.5760, -0.0019, -0.8175>, <30.7036, 223.1548, 6.9197>, <-0.5734, -0.0024, -0.8193> }
    smooth_triangle { <36.8984, 223.1601, -1.8973>, <-0.8203, -0.0025, 0.5719>, <30.7036, 223.2243, -10.7155>, <-0.5675, -0.0056, 0.8234>, <30.7036, 195.7075, -10.9037>, <-0.5696, -0.0052, 0.8219> }
    smooth_triangle { <30.7036, 195.7075, -10.9037>, <-0.5696, -0.0052, 0.8219>, <36.8984, 195.6070, -1.9537>, <-0.8221, -0.0024, 0.5694>, <36.8984, 223.1601, -1.8973>, <-0.8203, -0.0025, 0.5719> }
    smooth_triangle { <30.7036, 223.2243, -10.7155>, <-0.5675, -0.0056, 0.8234>, <15.7480, 223.5050, -14.4147>, <0.0012, -0.0080, 1.0000>, <15.7480, 195.9568, -14.6772>, <0.0015, -0.0074, 1.0000> }
    smooth_triangle { <15.7480, 195.9568, -14.6772>, <0.0015, -0.0074, 1.0000>, <30.7036, 195.7075, -10.9037>, <-0.5696, -0.0052, 0.8219>, <30.7036, 223.2243, -10.7155>, <-0.5675, -0.0056, 0.8234> }
    smooth_triangle { <15.7480, 223.5050, -14.4147>, <0.0012, -0.0080, 1.0000>, <0.7925, 223.6859, -10.6808>, <0.5735, -0.0048, 0.8192>, <0.7925, 195.9761, -10.8539>, <0.5766, -0.0044, 0.8170> }
    smooth_triangle { <0.7925, 195.9761, -10.8539>, <0.5766, -0.0044, 0.8170>, <15.7480, 195.9568, -14.6772>, <0.0015, -0.0074, 1.0000>, <15.7480, 223.5050, -14.4147>, <0.0012, -0.0080, 1.0000> }
    smooth_triangle { <0.7925, 223.6859, -10.6808>, <0.5735, -0.0048, 0.8192>, <-5.4023, 223.3841, -1.6685>, <0.8272, -0.0013, 0.5619>, <-5.4023, 195.7373, -1.6259>, <0.8300, -0.0012, 0.5578> }
    smooth_triangle { <-5.4023, 195.7373, -1.6259>, <0.8300, -0.0012, 0.5578>, <0.7925, 195.9761, -10.8539>, <0.5766, -0.0044, 0.8170>, <0.7925, 223.6859, -10.6808>, <0.5735, -0.0048, 0.8192> }
    smooth_triangle { <-5.4023, 223.3841, -1.6685>, <0.8255, -0.0027, -0.5644>, <0.7925, 223.1683, 7.3016>, <0.5654, -0.0055, -0.8248>, <0.7925, 195.6032, 7.5249>, <0.5666, -0.0047, -0.8240> }
    smooth_triangle { <0.7925, 195.6032, 7.5249>, <0.5666, -0.0047, -0.8240>, <-5.4023, 195.7373, -1.6259>, <0.8277, -0.0024, -0.5611>, <-5.4023, 223.3841, -1.6685>, <0.8255, -0.0027, -0.5644> }
    smooth_triangle { <0.7925, 223.1683, 7.3016>, <0.5654, -0.0055, -0.8248>, <15.7480, 223.1526, 10.8266>, <-0.0146, -0.0062, -0.9999>, <15.7480, 195.5918, 11.0260>, <-0.0170, -0.0051, -0.9998> }
    smooth_triangle { <15.7480, 195.5918, 11.0260>, <-0.0170, -0.0051, -0.9998>, <0.7925, 195.6032, 7.5249>, <0.5666, -0.0047, -0.8240>, <0.7925, 223.1683, 7.3016>, <0.5654, -0.0055, -0.8248> }
    smooth_triangle { <15.7480, 195.5918, 11.0260>, <-0.0170, -0.0051, -0.9998>, <30.7036, 195.5953, 6.9780>, <-0.5760, -0.0019, -0.8175>, <30.7036, 168.0360, 7.0072>, <-0.5802, -0.0008, -0.8145> }
    smooth_triangle { <30.7036, 168.0360, 7.0072>, <-0.5802, -0.0008, -0.8145>, <15.7480, 168.0306, 11.1528>, <-0.0213, -0.0030, -0.9998>, <15.7480, 195.5918, 11.0260>, <-0.0170, -0.0051, -0.9998> }
    smooth_triangle { <30.7036, 195.5953, 6.9780>, <-0.5760, -0.0019, -0.8175>, <36.8984, 195.6070, -1.9537>, <-0.8214, 0.0001, -0.5703>, <36.8984, 168.0569, -2.0044>, <-0.8238, 0.0003, -0.5669> }
    smooth_triangle { <36.8984, 168.0569, -2.0044>, <-0.8238, 0.0003, -0.5669>, <30.7036, 168.0360, 7.0072>, <-0.5802, -0.0008, -0.8145>, <30.7036, 195.5953, 6.9780>, <-0.5760, -0.0019, -0.8175> }
    smooth_triangle { <36.8984, 195.6070, -1.9537>, <-0.8221, -0.0024, 0.5694>, <30.7036, 195.7075, -10.9037>, <-0.5696, -0.0052, 0.8219>, <30.7036, 168.2139, -11.0631>, <-0.5735, -0.0043, 0.8192> }
    smooth_triangle { <30.7036, 168.2139, -11.0631>, <-0.5735, -0.0043, 0.8192>, <36.8984, 168.0569, -2.0044>, <-0.8253, -0.0020, 0.5647>, <36.8984, 195.6070, -1.9537>, <-0.8221, -0.0024, 0.5694> }
    smooth_triangle { <30.7036, 195.7075, -10.9037>, <-0.5696, -0.0052, 0.8219>, <15.7480, 195.9568, -14.6772>, <0.0015, -0.0074, 1.0000>, <15.7480, 168.4592, -14.8979>, <0.0019, -0.0062, 1.0000> }
    smooth_triangle { <15.7480, 168.4592, -14.8979>, <0.0019, -0.0062, 1.0000>, <30.7036, 168.2139, -11.0631>, <-0.5735, -0.0043, 0.8192>, <30.7036, 195.7075, -10.9037>, <-0.5696, -0.0052, 0.8219> }
    smooth_triangle { <15.7480, 195.9568, -14.6772>, <0.0015, -0.0074, 1.0000>, <0.7925, 195.9761, -10.8539>, <0.5766, -0.0044, 0.8170>, <0.7925, 168.2896, -11.0007>, <0.5821, -0.0037, 0.8131> }
    smooth_triangle { <0.7925, 168.2896, -11.0007>, <0.5821, -0.0037, 0.8131>, <15.7480, 168.4592, -14.8979>, <0.0019, -0.0062, 1.0000>, <15.7480, 195.9568, -14.6772>, <0.0015, -0.0074, 1.0000> }
    smooth_triangle { <0.7925, 195.9761, -10.8539>, <0.5766, -0.0044, 0.8170>, <-5.4023, 195.7373, -1.6259>, <0.8300, -0.0012, 0.5578>, <-5.4023, 168.0935, -1.5938>, <0.8349, -0.0011, 0.5504> }
    smooth_triangle { <-5.4023, 168.0935, -1.5938>, <0.8349, -0.0011, 0.5504>, <0.7925, 168.2896, -11.0007>, <0.5821, -0.0037, 0.8131>, <0.7925, 195.9761, -10.8539>, <0.5766, -0.0044, 0.8170> }
    smooth_triangle { <-5.4023, 195.7373, -1.6259>, <0.8277, -0.0024, -0.5611>, <0.7925, 195.6032, 7.5249>, <0.5666, -0.0047, -0.8240>, <0.7925, 168.0383, 7.6925>, <0.5684, -0.0031, -0.8228> }
    smooth_triangle { <0.7925, 168.0383, 7.6925>, <0.5684, -0.0031, -0.8228>, <-5.4023, 168.0935, -1.5938>, <0.8316, -0.0017, -0.5554>, <-5.4023, 195.7373, -1.6259>, <0.8277, -0.0024, -0.5611> }
    smooth_triangle { <0.7925, 195.6032, 7.5249>, <0.5666, -0.0047, -0.8240>, <15.7480, 195.5918, 11.0260>, <-0.0170, -0.0051, -0.9998>, <15.7480, 168.0306, 11.1528>, <-0.0213, -0.0030, -0.9998> }
    smooth_triangle { <15.7480, 168.0306, 11.1528>, <-0.0213, -0.0030, -0.9998>, <0.7925, 168.0383, 7.6925>, <0.5684, -0.0031, -0.8228>, <0.7925, 195.6032, 7.5249>, <0.5666, -0.0047, -0.8240> }
    smooth_triangle { <15.7480, 168.0306, 11.1528>, <-0.0213, -0.0030, -0.9998>, <30.7036, 168.0360, 7.0072>, <-0.5802, -0.0008, -0.8145>, <30.7036, 140.4761, 7.0075>, <-0.5825, 0.0003, -0.8129> }
    smooth_triangle { <30.7036, 140.4761, 7.0075>, <-0.5825, 0.0003, -0.8129>, <15.7480, 140.4680, 11.2069>, <-0.0248, -0.0010, -0.9997>, <15.7480, 168.0306, 11.1528>, <-0.0213, -0.0030, -0.9998> }
    smooth_triangle { <30.7036, 168.0360, 7.0072>, <-0.5802, -0.0008, -0.8145>, <36.8984, 168.0569, -2.0044>, <-0.8238, 0.0003, -0.5669>, <36.8984, 140.5088, -2.0495>, <-0.8251, 0.0006, -0.5649> }
    smooth_triangle { <36.8984, 140.5088, -2.0495>, <-0.8251, 0.0006, -0.5649>, <30.7036, 140.4761, 7.0075>, <-0.5825, 0.0003, -0.8129>, <30.7036, 168.0360, 7.0072>, <-0.5802, -0.0008, -0.8145> }
    smooth_triangle { <36.8984, 168.0569, -2.0044>, <-0.8253, -0.0020, 0.5647>, <30.7036, 168.2139, -11.0631>, <-0.5735, -0.0043, 0.8192>, <30.7036, 140.7427, -11.1938>, <-0.5765, -0.0034, 0.8171> }
    smooth_triangle { <30.7036, 140.7427, -11.1938>, <-0.5765, -0.0034, 0.8171>, <36.8984, 140.5088, -2.0495>, <-0.8278, -0.0016, 0.5611>, <36.8984, 168.0569, -2.0044>, <-0.8253, -0.0020, 0.5647> }
    smooth_triangle { <30.7036, 168.2139, -11.0631>, <-0.5735, -0.0043, 0.8192>, <15.7480, 168.4592, -14.8979>, <0.0019, -0.0062, 1.0000>, <15.7480, 141.0118, -15.0767>, <0.0023, -0.0049, 1.0000> }
    smooth_triangle { <15.7480, 141.0118, -15.0767>, <0.0023, -0.0049, 1.0000>, <30.7036, 140.7427, -11.1938>, <-0.5765, -0.0034, 0.8171>, <30.7036, 168.2139, -11.0631>, <-0.5735, -0.0043, 0.8192> }
    smooth_triangle { <15.7480, 168.4592, -14.8979>, <0.0019, -0.0062, 1.0000>, <0.7925, 168.2896, -11.0007>, <0.5821, -0.0037, 0.8131>, <0.7925, 140.6253, -11.1212>, <0.5864, -0.0030, 0.8100> }
    smooth_triangle { <0.7925, 140.6253, -11.1212>, <0.5864, -0.0030, 0.8100>, <15.7480, 141.0118, -15.0767>, <0.0023, -0.0049, 1.0000>, <15.7480, 168.4592, -14.8979>, <0.0019, -0.0062, 1.0000> }
    smooth_triangle { <0.7925, 168.2896, -11.0007>, <0.5821, -0.0037, 0.8131>, <-5.4023, 168.0935, -1.5938>, <0.8349, -0.0011, 0.5504>, <-5.4023, 140.4518, -1.5720>, <0.8387, -0.0009, 0.5446> }
    smooth_triangle { <-5.4023, 140.4518, -1.5720>, <0.8387, -0.0009, 0.5446>, <0.7925, 140.6253, -11.1212>, <0.5864, -0.0030, 0.8100>, <0.7925, 168.2896, -11.0007>, <0.5821, -0.0037, 0.8131> }
    smooth_triangle { <-5.4023, 168.0935, -1.5938>, <0.8316, -0.0017, -0.5554>, <0.7925, 168.0383, 7.6925>, <0.5684, -0.0031, -0.8228>, <0.7925, 140.4727, 7.8043>, <0.5687, -0.0015, -0.8226> }
    smooth_triangle { <0.7925, 140.4727, 7.8043>, <0.5687, -0.0015, -0.8226>, <-5.4023, 140.4518, -1.5720>, <0.8340, -0.0010, -0.5517>, <-5.4023, 168.0935, -1.5938>, <0.8316, -0.0017, -0.5554> }
    smooth_triangle { <0.7925, 168.0383, 7.6925>, <0.5684, -0.0031, -0.8228>, <15.7480, 168.0306, 11.1528>, <-0.0213, -0.0030, -0.9998>, <15.7480, 140.4680, 11.2069>, <-0.0248, -0.0010, -0.9997> }
    smooth_triangle { <15.7480, 140.4680, 11.2069>, <-0.0248, -0.0010, -0.9997>, <0.7925, 140.4727, 7.8043>, <0.5687, -0.0015, -0.8226>, <0.7925, 168.0383, 7.6925>, <0.5684, -0.0031, -0.8228> }
    smooth_triangle { <15.7480, 140.4680, 11.2069>, <-0.0248, -0.0010, -0.9997>, <30.7036, 140.4761, 7.0075>, <-0.5825, 0.0003, -0.8129>, <30.7036, 112.9180, 6.9789>, <-0.5830, 0.0013, -0.8125> }
    smooth_triangle { <30.7036, 112.9180, 6.9789>, <-0.5830, 0.0013, -0.8125>, <15.7480, 112.9065, 11.1884>, <-0.0275, 0.0011, -0.9996>, <15.7480, 140.4680, 11.2069>, <-0.0248, -0.0010, -0.9997> }
    smooth_triangle { <30.7036, 140.4761, 7.0075>, <-0.5825, 0.0003, -0.8129>, <36.8984, 140.5088, -2.0495>, <-0.8251, 0.0006, -0.5649>, <36.8984, 112.9653, -2.0889>, <-0.8255, 0.0008, -0.5645> }
    smooth_triangle { <36.8984, 112.9653, -2.0889>, <-0.8255, 0.0008, -0.5645>, <30.7036, 112.9180, 6.9789>, <-0.5830, 0.0013, -0.8125>, <30.7036, 140.4761, 7.0075>, <-0.5825, 0.0003, -0.8129> }
    smooth_triangle { <36.8984, 140.5088, -2.0495>, <-0.8278, -0.0016, 0.5611>, <30.7036, 140.7427, -11.1938>, <-0.5765, -0.0034, 0.8171>, <30.7036, 113.2964, -11.2956>, <-0.5787, -0.0026, 0.8155> }
    smooth_triangle { <30.7036, 113.2964, -11.2956>, <-0.5787, -0.0026, 0.8155>, <36.8984, 112.9653, -2.0889>, <-0.8295, -0.0013, 0.5585>, <36.8984, 140.5088, -2.0495>, <-0.8278, -0.0016, 0.5611> }
    smooth_triangle { <30.7036, 140.7427, -11.1938>, <-0.5765, -0.0034, 0.8171>, <15.7480, 141.0118, -15.0767>, <0.0023, -0.0049, 1.0000>, <15.7480, 113.6169, -15.2136>, <0.0025, -0.0036, 1.0000> }
    smooth_triangle { <15.7480, 113.6169, -15.2136>, <0.0025, -0.0036, 1.0000>, <30.7036, 113.2964, -11.2956>, <-0.5787, -0.0026, 0.8155>, <30.7036, 140.7427, -11.1938>, <-0.5765, -0.0034, 0.8171> }
    smooth_triangle { <15.7480, 141.0118, -15.0767>, <0.0023, -0.0049, 1.0000>, <0.7925, 140.6253, -11.1212>, <0.5864, -0.0030, 0.8100>, <0.7925, 112.9859, -11.2153>, <0.5896, -0.0022, 0.8077> }
    smooth_triangle { <0.7925, 112.9859, -11.2153>, <0.5896, -0.0022, 0.8077>, <15.7480, 113.6169, -15.2136>, <0.0025, -0.0036, 1.0000>, <15.7480, 141.0118, -15.0767>, <0.0023, -0.0049, 1.0000> }
    smooth_triangle { <0.7925, 140.6253, -11.1212>, <0.5864, -0.0030, 0.8100>, <-5.4023, 140.4518, -1.5720>, <0.8387, -0.0009, 0.5446>, <-5.4023, 112.8146, -1.5608>, <0.8414, -0.0007, 0.5404> }
    smooth_triangle { <-5.4023, 112.8146, -1.5608>, <0.8414, -0.0007, 0.5404>, <0.7925, 112.9859, -11.2153>, <0.5896, -0.0022, 0.8077>, <0.7925, 140.6253, -11.1212>, <0.5864, -0.0030, 0.8100> }
    smooth_triangle { <-5.4023, 140.4518, -1.5720>, <0.8340, -0.0010, -0.5517>, <0.7925, 140.4727, 7.8043>, <0.5687, -0.0015, -0.8226>, <0.7925, 112.9089, 7.8603>, <0.5676, 0.0001, -0.8233> }
    smooth_triangle { <0.7925, 112.9089, 7.8603>, <0.5676, 0.0001, -0.8233>, <-5.4023, 112.8146, -1.5608>, <0.8352, -0.0003, -0.5499>, <-5.4023, 140.4518, -1.5720>, <0.8340, -0.0010, -0.5517> }
    smooth_triangle { <0.7925, 140.4727, 7.8043>, <0.5687, -0.0015, -0.8226>, <15.7480, 140.4680, 11.2069>, <-0.0248, -0.0010, -0.9997>, <15.7480, 112.9065, 11.1884>, <-0.0275, 0.0011, -0.9996> }
    smooth_triangle { <15.7480, 112.9065, 11.1884>, <-0.0275, 0.0011, -0.9996>, <0.7925, 112.9089, 7.8603>, <0.5676, 0.0001, -0.8233>, <0.7925, 140.4727, 7.8043>, <0.5687, -0.0015, -0.8226> }
    smooth_triangle { <15.7480, 112.9065, 11.1884>, <-0.0275, 0.0011, -0.9996>, <30.7036, 112.9180, 6.9789>, <-0.5830, 0.0013, -0.8125>, <30.7036, 85.3615, 6.9212>, <-0.5827, 0.0019, -0.8127> }
    smooth_triangle { <30.7036, 85.3615, 6.9212>, <-0.5827, 0.0019, -0.8127>, <15.7480, 85.3459, 11.0972>, <-0.0286, 0.0022, -0.9996>, <15.7480, 112.9065, 11.1884>, <-0.0275, 0.0011, -0.9996> }
    smooth_triangle { <30.7036, 112.9180, 6.9789>, <-0.5830, 0.0013, -0.8125>, <36.8984, 112.9653, -2.0889>, <-0.8255, 0.0008, -0.5645>, <36.8984, 85.4262, -2.1227>, <-0.8254, 0.0009, -0.5646> }
    smooth_triangle { <36.8984, 85.4262, -2.1227>, <-0.8254, 0.0009, -0.5646>, <30.7036, 85.3615, 6.9212>, <-0.5827, 0.0019, -0.8127>, <30.7036, 112.9180, 6.9789>, <-0.5830, 0.0013, -0.8125> }
    smooth_triangle { <36.8984, 112.9653, -2.0889>, <-0.8295, -0.0013, 0.5585>, <30.7036, 113.2964, -11.2956>, <-0.5787, -0.0026, 0.8155>, <30.7036, 85.8747, -11.3687>, <-0.5796, -0.0022, 0.8149> }
    smooth_triangle { <30.7036, 85.8747, -11.3687>, <-0.5796, -0.0022, 0.8149>, <36.8984, 85.4262, -2.1227>, <-0.8302, -0.0011, 0.5574>, <36.8984, 112.9653, -2.0889>, <-0.8295, -0.0013, 0.5585> }
    smooth_triangle { <30.7036, 113.2964, -11.2956>, <-0.5787, -0.0026, 0.8155>, <15.7480, 113.6169, -15.2136>, <0.0025, -0.0036, 1.0000>, <15.7480, 86.2742, -15.3086>, <0.0026, -0.0030, 1.0000> }
    smooth_triangle { <15.7480, 86.2742, -15.3086>, <0.0026, -0.0030, 1.0000>, <30.7036, 85.8747, -11.3687>, <-0.5796, -0.0022, 0.8149>, <30.7036, 113.2964, -11.2956>, <-0.5787, -0.0026, 0.8155> }
    smooth_triangle { <15.7480, 113.6169, -15.2136>, <0.0025, -0.0036, 1.0000>, <0.7925, 112.9859, -11.2153>, <0.5896, -0.0022, 0.8077>, <0.7925, 85.3712, -11.2831>, <0.5908, -0.0019, 0.8068> }
    smooth_triangle { <0.7925, 85.3712, -11.2831>, <0.5908, -0.0019, 0.8068>, <15.7480, 86.2742, -15.3086>, <0.0026, -0.0030, 1.0000>, <15.7480, 113.6169, -15.2136>, <0.0025, -0.0036, 1.0000> }
    smooth_triangle { <0.7925, 112.9859, -11.2153>, <0.5896, -0.0022, 0.8077>, <-5.4023, 112.8146, -1.5608>, <0.8414, -0.0007, 0.5404>, <-5.4023, 85.1818, -1.5599>, <0.8425, -0.0007, 0.5387> }
    smooth_triangle { <-5.4023, 85.1818, -1.5599>, <0.8425, -0.0007, 0.5387>, <0.7925, 85.3712, -11.2831>, <0.5908, -0.0019, 0.8068>, <0.7925, 112.9859, -11.2153>, <0.5896, -0.0022, 0.8077> }
    smooth_triangle { <-5.4023, 112.8146, -1.5608>, <0.8352, -0.0003, -0.5499>, <0.7925, 112.9089, 7.8603>, <0.5676, 0.0001, -0.8233>, <0.7925, 85.3467, 7.8606>, <0.5668, 0.0009, -0.8239> }
    smooth_triangle { <0.7925, 85.3467, 7.8606>, <0.5668, 0.0009, -0.8239>, <-5.4023, 85.1818, -1.5599>, <0.8355, -0.0000, -0.5494>, <-5.4023, 112.8146, -1.5608>, <0.8352, -0.0003, -0.5499> }
    smooth_triangle { <0.7925, 112.9089, 7.8603>, <0.5676, 0.0001, -0.8233>, <15.7480, 112.9065, 11.1884>, <-0.0275, 0.0011, -0.9996>, <15.7480, 85.3459, 11.0972>, <-0.0286, 0.0022, -0.9996> }
    smooth_triangle { <15.7480, 85.3459, 11.0972>, <-0.0286, 0.0022, -0.9996>, <0.7925, 85.3467, 7.8606>, <0.5668, 0.0009, -0.8239>, <0.7925, 112.9089, 7.8603>, <0.5676, 0.0001, -0.8233> }
    smooth_triangle { <0.7925, 223.1683, 7.3016>, <0.0063, -0.9996, -0.0288>, <0.7925, 223.6859, -10.6808>, <-0.0010, -0.9997, -0.0238>, <15.7480, 223.1526, 10.8266>, <-0.0045, -0.9998, -0.0189> }
    smooth_triangle { <0.7925, 223.1683, 7.3016>, <0.0063, -0.9996, -0.0288>, <-5.4023, 223.3841, -1.6685>, <0.0069, -0.9996, -0.0288>, <0.7925, 223.6859, -10.6808>, <-0.0010, -0.9997, -0.0238> }
    smooth_triangle { <0.7925, 223.6859, -10.6808>, <-0.0010, -0.9997, -0.0238>, <15.7480, 223.5050, -14.4147>, <-0.0123, -0.9999, -0.0106>, <15.7480, 223.1526, 10.8266>, <-0.0045, -0.9998, -0.0189> }
    smooth_triangle { <30.7036, 223.2243, -10.7155>, <-0.0113, -0.9999, -0.0039>, <36.8984, 223.1601, -1.8973>, <-0.0047, -1.0000, -0.0039>, <30.7036, 223.1548, 6.9197>, <-0.0087, -0.9999, -0.0073> }
    smooth_triangle { <15.7480, 223.1526, 10.8266>, <-0.0045, -0.9998, -0.0189>, <15.7480, 223.5050, -14.4147>, <-0.0123, -0.9999, -0.0106>, <30.7036, 223.1548, 6.9197>, <-0.0087, -0.9999, -0.0073> }
    smooth_triangle { <30.7036, 223.1548, 6.9197>, <-0.0087, -0.9999, -0.0073>, <15.7480, 223.5050, -14.4147>, <-0.0123, -0.9999, -0.0106>, <30.7036, 223.2243, -10.7155>, <-0.0113, -0.9999, -0.0039> }
    smooth_triangle { <-5.4023, 85.1818, -1.5599>, <-0.0286, 0.9996, 0.0013>, <0.7925, 85.3467, 7.8606>, <-0.0144, 0.9999, 0.0013>, <0.7925, 85.3712, -11.2831>, <-0.0265, 0.9996, 0.0126> }
    smooth_triangle { <15.7480, 85.3459, 11.0972>, <-0.0141, 0.9996, 0.0238>, <15.7480, 86.2742, -15.3086>, <-0.0076, 0.9994, 0.0328>, <0.7925, 85.3712, -11.2831>, <-0.0265, 0.9996, 0.0126> }
    smooth_triangle { <0.7925, 85.3712, -11.2831>, <-0.0265, 0.9996, 0.0126>, <0.7925, 85.3467, 7.8606>, <-0.0144, 0.9999, 0.0013>, <15.7480, 85.3459, 11.0972>, <-0.0141, 0.9996, 0.0238> }
    smooth_triangle { <30.7036, 85.3615, 6.9212>, <0.0195, 0.9993, 0.0304>, <30.7036, 85.8747, -11.3687>, <0.0249, 0.9993, 0.0280>, <15.7480, 86.2742, -15.3086>, <-0.0076, 0.9994, 0.0328> }
    smooth_triangle { <36.8984, 85.4262, -2.1227>, <0.0305, 0.9991, 0.0280>, <30.7036, 85.8747, -11.3687>, <0.0249, 0.9993, 0.0280>, <30.7036, 85.3615, 6.9212>, <0.0195, 0.9993, 0.0304> }
    smooth_triangle { <30.7036, 85.3615, 6.9212>, <0.0195, 0.9993, 0.0304>, <15.7480, 86.2742, -15.3086>, <-0.0076, 0.9994, 0.0328>, <15.7480, 85.3459, 11.0972>, <-0.0141, 0.9996, 0.0238> }
    texture {
      Brushed_Aluminum
    }
  }

  mesh { // Surf1 
    smooth_triangle { <-9.9988, 235.9586, 13.6283>, <-0.0000, 0.0000, 1.0000>, <0.4439, 235.9586, 13.6283>, <0.0000, 0.0000, 1.0000>, <-0.6772, 243.9476, 11.0325>, <0.0000, 0.5878, 0.8090> }
    smooth_triangle { <-0.6772, 243.9476, 11.0325>, <0.0000, 0.5878, 0.8090>, <-11.8735, 243.9476, 11.0325>, <-0.0000, 0.5878, 0.8090>, <-9.9988, 235.9586, 13.6283>, <-0.0000, 0.0000, 1.0000> }
    smooth_triangle { <-11.8735, 243.9476, 11.0325>, <-0.0000, 0.5878, 0.8090>, <-0.6772, 243.9476, 11.0325>, <0.0000, 0.5878, 0.8090>, <0.3699, 248.8850, 4.2366>, <-0.0000, 0.9511, 0.3090> }
    smooth_triangle { <0.3699, 248.8850, 4.2366>, <-0.0000, 0.9511, 0.3090>, <-10.1227, 248.8850, 4.2366>, <0.0000, 0.9511, 0.3090>, <-11.8735, 243.9476, 11.0325>, <-0.0000, 0.5878, 0.8090> }
    smooth_triangle { <-10.1227, 248.8850, 4.2366>, <0.0000, 0.9511, 0.3090>, <0.3699, 248.8850, 4.2366>, <-0.0000, 0.9511, 0.3090>, <0.3715, 248.8850, -4.1635>, <-0.0000, 0.9511, -0.3090> }
    smooth_triangle { <0.3715, 248.8850, -4.1635>, <-0.0000, 0.9511, -0.3090>, <-10.1199, 248.8850, -4.1635>, <0.0000, 0.9511, -0.3090>, <-10.1227, 248.8850, 4.2366>, <0.0000, 0.9511, 0.3090> }
    smooth_triangle { <-10.1199, 248.8850, -4.1635>, <0.0000, 0.9511, -0.3090>, <0.3715, 248.8850, -4.1635>, <-0.0000, 0.9511, -0.3090>, <-0.6112, 243.9476, -10.9594>, <0.0000, 0.5878, -0.8090> }
    smooth_triangle { <-0.6112, 243.9476, -10.9594>, <0.0000, 0.5878, -0.8090>, <-11.7631, 243.9475, -10.9593>, <-0.0000, 0.5878, -0.8090>, <-10.1199, 248.8850, -4.1635>, <0.0000, 0.9511, -0.3090> }
    smooth_triangle { <-11.7631, 243.9475, -10.9593>, <-0.0000, 0.5878, -0.8090>, <-0.6112, 243.9476, -10.9594>, <0.0000, 0.5878, -0.8090>, <0.5718, 235.9586, -13.5551>, <0.0000, 0.0000, -1.0000> }
    smooth_triangle { <0.5718, 235.9586, -13.5551>, <0.0000, 0.0000, -1.0000>, <-9.7851, 235.9586, -13.5551>, <-0.0000, 0.0000, -1.0000>, <-11.7631, 243.9475, -10.9593>, <-0.0000, 0.5878, -0.8090> }
    smooth_triangle { <-9.7851, 235.9586, -13.5551>, <-0.0000, 0.0000, -1.0000>, <0.5718, 235.9586, -13.5551>, <0.0000, 0.0000, -1.0000>, <-0.5640, 227.9696, -10.9594>, <0.0000, -0.5878, -0.8090> }
    smooth_triangle { <-0.5640, 227.9696, -10.9594>, <0.0000, -0.5878, -0.8090>, <-11.6842, 227.9696, -10.9593>, <-0.0000, -0.5878, -0.8090>, <-9.7851, 235.9586, -13.5551>, <-0.0000, 0.0000, -1.0000> }
    smooth_triangle { <-11.6842, 227.9696, -10.9593>, <-0.0000, -0.5878, -0.8090>, <-0.5640, 227.9696, -10.9594>, <0.0000, -0.5878, -0.8090>, <0.5717, 223.0321, -4.1635>, <0.0000, -0.9511, -0.3090> }
    smooth_triangle { <0.5717, 223.0321, -4.1635>, <0.0000, -0.9511, -0.3090>, <-9.7851, 223.0321, -4.1635>, <-0.0000, -0.9511, -0.3090>, <-11.6842, 227.9696, -10.9593>, <-0.0000, -0.5878, -0.8090> }
    smooth_triangle { <-9.7851, 223.0321, -4.1635>, <-0.0000, -0.9511, -0.3090>, <0.5717, 223.0321, -4.1635>, <0.0000, -0.9511, -0.3090>, <0.5718, 223.0321, 4.2366>, <0.0000, -0.9511, 0.3090> }
    smooth_triangle { <0.5718, 223.0321, 4.2366>, <0.0000, -0.9511, 0.3090>, <-9.7851, 223.0321, 4.2366>, <-0.0000, -0.9511, 0.3090>, <-9.7851, 223.0321, -4.1635>, <-0.0000, -0.9511, -0.3090> }
    smooth_triangle { <-9.7851, 223.0321, 4.2366>, <-0.0000, -0.9511, 0.3090>, <0.5718, 223.0321, 4.2366>, <0.0000, -0.9511, 0.3090>, <-0.6274, 227.9696, 11.0325>, <0.0000, -0.5878, 0.8090> }
    smooth_triangle { <-0.6274, 227.9696, 11.0325>, <0.0000, -0.5878, 0.8090>, <-11.7903, 227.9696, 11.0325>, <-0.0000, -0.5878, 0.8090>, <-9.7851, 223.0321, 4.2366>, <-0.0000, -0.9511, 0.3090> }
    smooth_triangle { <-11.7903, 227.9696, 11.0325>, <-0.0000, -0.5878, 0.8090>, <-0.6274, 227.9696, 11.0325>, <0.0000, -0.5878, 0.8090>, <0.4439, 235.9586, 13.6283>, <0.0000, 0.0000, 1.0000> }
    smooth_triangle { <0.4439, 235.9586, 13.6283>, <0.0000, 0.0000, 1.0000>, <-9.9988, 235.9586, 13.6283>, <-0.0000, 0.0000, 1.0000>, <-11.7903, 227.9696, 11.0325>, <-0.0000, -0.5878, 0.8090> }
    smooth_triangle { <0.4439, 235.9586, 13.6283>, <0.0000, 0.0000, 1.0000>, <10.8873, 235.9586, 13.6283>, <-0.0000, 0.0000, 1.0000>, <10.5245, 243.9475, 11.0325>, <-0.0000, 0.5878, 0.8090> }
    smooth_triangle { <10.5245, 243.9475, 11.0325>, <-0.0000, 0.5878, 0.8090>, <-0.6772, 243.9476, 11.0325>, <0.0000, 0.5878, 0.8090>, <0.4439, 235.9586, 13.6283>, <0.0000, 0.0000, 1.0000> }
    smooth_triangle { <-0.6772, 243.9476, 11.0325>, <0.0000, 0.5878, 0.8090>, <10.5245, 243.9475, 11.0325>, <-0.0000, 0.5878, 0.8090>, <10.8633, 248.8850, 4.2366>, <-0.0000, 0.9511, 0.3090> }
    smooth_triangle { <10.8633, 248.8850, 4.2366>, <-0.0000, 0.9511, 0.3090>, <0.3699, 248.8850, 4.2366>, <-0.0000, 0.9511, 0.3090>, <-0.6772, 243.9476, 11.0325>, <0.0000, 0.5878, 0.8090> }
    smooth_triangle { <0.3699, 248.8850, 4.2366>, <-0.0000, 0.9511, 0.3090>, <10.8633, 248.8850, 4.2366>, <-0.0000, 0.9511, 0.3090>, <10.8638, 248.8850, -4.1635>, <-0.0000, 0.9511, -0.3090> }
    smooth_triangle { <10.8638, 248.8850, -4.1635>, <-0.0000, 0.9511, -0.3090>, <0.3715, 248.8850, -4.1635>, <-0.0000, 0.9511, -0.3090>, <0.3699, 248.8850, 4.2366>, <-0.0000, 0.9511, 0.3090> }
    smooth_triangle { <0.3715, 248.8850, -4.1635>, <-0.0000, 0.9511, -0.3090>, <10.8638, 248.8850, -4.1635>, <-0.0000, 0.9511, -0.3090>, <10.5459, 243.9475, -10.9594>, <-0.0000, 0.5878, -0.8090> }
    smooth_triangle { <10.5459, 243.9475, -10.9594>, <-0.0000, 0.5878, -0.8090>, <-0.6112, 243.9476, -10.9594>, <0.0000, 0.5878, -0.8090>, <0.3715, 248.8850, -4.1635>, <-0.0000, 0.9511, -0.3090> }
    smooth_triangle { <-0.6112, 243.9476, -10.9594>, <0.0000, 0.5878, -0.8090>, <10.5459, 243.9475, -10.9594>, <-0.0000, 0.5878, -0.8090>, <10.9286, 235.9586, -13.5551>, <-0.0000, 0.0000, -1.0000> }
    smooth_triangle { <10.9286, 235.9586, -13.5551>, <-0.0000, 0.0000, -1.0000>, <0.5718, 235.9586, -13.5551>, <0.0000, 0.0000, -1.0000>, <-0.6112, 243.9476, -10.9594>, <0.0000, 0.5878, -0.8090> }
    smooth_triangle { <0.5718, 235.9586, -13.5551>, <0.0000, 0.0000, -1.0000>, <10.9286, 235.9586, -13.5551>, <-0.0000, 0.0000, -1.0000>, <10.5611, 227.9696, -10.9594>, <-0.0000, -0.5878, -0.8090> }
    smooth_triangle { <10.5611, 227.9696, -10.9594>, <-0.0000, -0.5878, -0.8090>, <-0.5640, 227.9696, -10.9594>, <0.0000, -0.5878, -0.8090>, <0.5718, 235.9586, -13.5551>, <0.0000, 0.0000, -1.0000> }
    smooth_triangle { <-0.5640, 227.9696, -10.9594>, <0.0000, -0.5878, -0.8090>, <10.5611, 227.9696, -10.9594>, <-0.0000, -0.5878, -0.8090>, <10.9286, 223.0322, -4.1635>, <-0.0000, -0.9511, -0.3090> }
    smooth_triangle { <10.9286, 223.0322, -4.1635>, <-0.0000, -0.9511, -0.3090>, <0.5717, 223.0321, -4.1635>, <0.0000, -0.9511, -0.3090>, <-0.5640, 227.9696, -10.9594>, <0.0000, -0.5878, -0.8090> }
    smooth_triangle { <0.5717, 223.0321, -4.1635>, <0.0000, -0.9511, -0.3090>, <10.9286, 223.0322, -4.1635>, <-0.0000, -0.9511, -0.3090>, <10.9286, 223.0321, 4.2366>, <0.0000, -0.9511, 0.3090> }
    smooth_triangle { <10.9286, 223.0321, 4.2366>, <0.0000, -0.9511, 0.3090>, <0.5718, 223.0321, 4.2366>, <0.0000, -0.9511, 0.3090>, <0.5717, 223.0321, -4.1635>, <0.0000, -0.9511, -0.3090> }
    smooth_triangle { <0.5718, 223.0321, 4.2366>, <0.0000, -0.9511, 0.3090>, <10.9286, 223.0321, 4.2366>, <0.0000, -0.9511, 0.3090>, <10.5406, 227.9696, 11.0325>, <0.0000, -0.5878, 0.8090> }
    smooth_triangle { <10.5406, 227.9696, 11.0325>, <0.0000, -0.5878, 0.8090>, <-0.6274, 227.9696, 11.0325>, <0.0000, -0.5878, 0.8090>, <0.5718, 223.0321, 4.2366>, <0.0000, -0.9511, 0.3090> }
    smooth_triangle { <-0.6274, 227.9696, 11.0325>, <0.0000, -0.5878, 0.8090>, <10.5406, 227.9696, 11.0325>, <0.0000, -0.5878, 0.8090>, <10.8873, 235.9586, 13.6283>, <-0.0000, 0.0000, 1.0000> }
    smooth_triangle { <10.8873, 235.9586, 13.6283>, <-0.0000, 0.0000, 1.0000>, <0.4439, 235.9586, 13.6283>, <0.0000, 0.0000, 1.0000>, <-0.6274, 227.9696, 11.0325>, <0.0000, -0.5878, 0.8090> }
    smooth_triangle { <10.8873, 235.9586, 13.6283>, <-0.0000, 0.0000, 1.0000>, <21.3312, 235.9586, 13.6283>, <0.0000, 0.0000, 1.0000>, <21.7317, 243.9476, 11.0325>, <0.0000, 0.5878, 0.8090> }
    smooth_triangle { <21.7317, 243.9476, 11.0325>, <0.0000, 0.5878, 0.8090>, <10.5245, 243.9475, 11.0325>, <-0.0000, 0.5878, 0.8090>, <10.8873, 235.9586, 13.6283>, <-0.0000, 0.0000, 1.0000> }
    smooth_triangle { <10.5245, 243.9475, 11.0325>, <-0.0000, 0.5878, 0.8090>, <21.7317, 243.9476, 11.0325>, <0.0000, 0.5878, 0.8090>, <21.3576, 248.8850, 4.2366>, <-0.0000, 0.9511, 0.3090> }
    smooth_triangle { <21.3576, 248.8850, 4.2366>, <-0.0000, 0.9511, 0.3090>, <10.8633, 248.8850, 4.2366>, <-0.0000, 0.9511, 0.3090>, <10.5245, 243.9475, 11.0325>, <-0.0000, 0.5878, 0.8090> }
    smooth_triangle { <10.8633, 248.8850, 4.2366>, <-0.0000, 0.9511, 0.3090>, <21.3576, 248.8850, 4.2366>, <-0.0000, 0.9511, 0.3090>, <21.3570, 248.8850, -4.1635>, <-0.0000, 0.9511, -0.3090> }
    smooth_triangle { <21.3570, 248.8850, -4.1635>, <-0.0000, 0.9511, -0.3090>, <10.8638, 248.8850, -4.1635>, <-0.0000, 0.9511, -0.3090>, <10.8633, 248.8850, 4.2366>, <-0.0000, 0.9511, 0.3090> }
    smooth_triangle { <10.8638, 248.8850, -4.1635>, <-0.0000, 0.9511, -0.3090>, <21.3570, 248.8850, -4.1635>, <-0.0000, 0.9511, -0.3090>, <21.7081, 243.9476, -10.9594>, <-0.0000, 0.5878, -0.8090> }
    smooth_triangle { <21.7081, 243.9476, -10.9594>, <-0.0000, 0.5878, -0.8090>, <10.5459, 243.9475, -10.9594>, <-0.0000, 0.5878, -0.8090>, <10.8638, 248.8850, -4.1635>, <-0.0000, 0.9511, -0.3090> }
    smooth_triangle { <10.5459, 243.9475, -10.9594>, <-0.0000, 0.5878, -0.8090>, <21.7081, 243.9476, -10.9594>, <-0.0000, 0.5878, -0.8090>, <21.2855, 235.9586, -13.5551>, <-0.0000, -0.0000, -1.0000> }
    smooth_triangle { <21.2855, 235.9586, -13.5551>, <-0.0000, -0.0000, -1.0000>, <10.9286, 235.9586, -13.5551>, <-0.0000, 0.0000, -1.0000>, <10.5459, 243.9475, -10.9594>, <-0.0000, 0.5878, -0.8090> }
    smooth_triangle { <10.9286, 235.9586, -13.5551>, <-0.0000, 0.0000, -1.0000>, <21.2855, 235.9586, -13.5551>, <-0.0000, -0.0000, -1.0000>, <21.6913, 227.9696, -10.9593>, <-0.0000, -0.5878, -0.8090> }
    smooth_triangle { <21.6913, 227.9696, -10.9593>, <-0.0000, -0.5878, -0.8090>, <10.5611, 227.9696, -10.9594>, <-0.0000, -0.5878, -0.8090>, <10.9286, 235.9586, -13.5551>, <-0.0000, 0.0000, -1.0000> }
    smooth_triangle { <10.5611, 227.9696, -10.9594>, <-0.0000, -0.5878, -0.8090>, <21.6913, 227.9696, -10.9593>, <-0.0000, -0.5878, -0.8090>, <21.2855, 223.0322, -4.1635>, <-0.0000, -0.9511, -0.3090> }
    smooth_triangle { <21.2855, 223.0322, -4.1635>, <-0.0000, -0.9511, -0.3090>, <10.9286, 223.0322, -4.1635>, <-0.0000, -0.9511, -0.3090>, <10.5611, 227.9696, -10.9594>, <-0.0000, -0.5878, -0.8090> }
    smooth_triangle { <10.9286, 223.0322, -4.1635>, <-0.0000, -0.9511, -0.3090>, <21.2855, 223.0322, -4.1635>, <-0.0000, -0.9511, -0.3090>, <21.2855, 223.0321, 4.2366>, <-0.0000, -0.9511, 0.3090> }
    smooth_triangle { <21.2855, 223.0321, 4.2366>, <-0.0000, -0.9511, 0.3090>, <10.9286, 223.0321, 4.2366>, <0.0000, -0.9511, 0.3090>, <10.9286, 223.0322, -4.1635>, <-0.0000, -0.9511, -0.3090> }
    smooth_triangle { <10.9286, 223.0321, 4.2366>, <0.0000, -0.9511, 0.3090>, <21.2855, 223.0321, 4.2366>, <-0.0000, -0.9511, 0.3090>, <21.7140, 227.9696, 11.0325>, <-0.0000, -0.5878, 0.8090> }
    smooth_triangle { <21.7140, 227.9696, 11.0325>, <-0.0000, -0.5878, 0.8090>, <10.5406, 227.9696, 11.0325>, <0.0000, -0.5878, 0.8090>, <10.9286, 223.0321, 4.2366>, <0.0000, -0.9511, 0.3090> }
    smooth_triangle { <10.5406, 227.9696, 11.0325>, <0.0000, -0.5878, 0.8090>, <21.7140, 227.9696, 11.0325>, <-0.0000, -0.5878, 0.8090>, <21.3312, 235.9586, 13.6283>, <0.0000, 0.0000, 1.0000> }
    smooth_triangle { <21.3312, 235.9586, 13.6283>, <0.0000, 0.0000, 1.0000>, <10.8873, 235.9586, 13.6283>, <-0.0000, 0.0000, 1.0000>, <10.5406, 227.9696, 11.0325>, <0.0000, -0.5878, 0.8090> }
    smooth_triangle { <21.3312, 235.9586, 13.6283>, <0.0000, 0.0000, 1.0000>, <31.7756, 235.9586, 13.6283>, <0.0000, 0.0000, 1.0000>, <32.9444, 243.9476, 11.0325>, <0.0000, 0.5878, 0.8090> }
    smooth_triangle { <32.9444, 243.9476, 11.0325>, <0.0000, 0.5878, 0.8090>, <21.7317, 243.9476, 11.0325>, <0.0000, 0.5878, 0.8090>, <21.3312, 235.9586, 13.6283>, <0.0000, 0.0000, 1.0000> }
    smooth_triangle { <21.7317, 243.9476, 11.0325>, <0.0000, 0.5878, 0.8090>, <32.9444, 243.9476, 11.0325>, <0.0000, 0.5878, 0.8090>, <31.8528, 248.8850, 4.2366>, <-0.0000, 0.9511, 0.3090> }
    smooth_triangle { <31.8528, 248.8850, 4.2366>, <-0.0000, 0.9511, 0.3090>, <21.3576, 248.8850, 4.2366>, <-0.0000, 0.9511, 0.3090>, <21.7317, 243.9476, 11.0325>, <0.0000, 0.5878, 0.8090> }
    smooth_triangle { <21.3576, 248.8850, 4.2366>, <-0.0000, 0.9511, 0.3090>, <31.8528, 248.8850, 4.2366>, <-0.0000, 0.9511, 0.3090>, <31.8511, 248.8850, -4.1635>, <-0.0000, 0.9511, -0.3090> }
    smooth_triangle { <31.8511, 248.8850, -4.1635>, <-0.0000, 0.9511, -0.3090>, <21.3570, 248.8850, -4.1635>, <-0.0000, 0.9511, -0.3090>, <21.3576, 248.8850, 4.2366>, <-0.0000, 0.9511, 0.3090> }
    smooth_triangle { <21.3570, 248.8850, -4.1635>, <-0.0000, 0.9511, -0.3090>, <31.8511, 248.8850, -4.1635>, <-0.0000, 0.9511, -0.3090>, <32.8756, 243.9476, -10.9594>, <-0.0000, 0.5878, -0.8090> }
    smooth_triangle { <32.8756, 243.9476, -10.9594>, <-0.0000, 0.5878, -0.8090>, <21.7081, 243.9476, -10.9594>, <-0.0000, 0.5878, -0.8090>, <21.3570, 248.8850, -4.1635>, <-0.0000, 0.9511, -0.3090> }
    smooth_triangle { <21.7081, 243.9476, -10.9594>, <-0.0000, 0.5878, -0.8090>, <32.8756, 243.9476, -10.9594>, <-0.0000, 0.5878, -0.8090>, <31.6424, 235.9586, -13.5551>, <0.0000, 0.0000, -1.0000> }
    smooth_triangle { <31.6424, 235.9586, -13.5551>, <0.0000, 0.0000, -1.0000>, <21.2855, 235.9586, -13.5551>, <-0.0000, -0.0000, -1.0000>, <21.7081, 243.9476, -10.9594>, <-0.0000, 0.5878, -0.8090> }
    smooth_triangle { <21.2855, 235.9586, -13.5551>, <-0.0000, -0.0000, -1.0000>, <31.6424, 235.9586, -13.5551>, <0.0000, 0.0000, -1.0000>, <32.8264, 227.9696, -10.9594>, <0.0000, -0.5878, -0.8090> }
    smooth_triangle { <32.8264, 227.9696, -10.9594>, <0.0000, -0.5878, -0.8090>, <21.6913, 227.9696, -10.9593>, <-0.0000, -0.5878, -0.8090>, <21.2855, 235.9586, -13.5551>, <-0.0000, -0.0000, -1.0000> }
    smooth_triangle { <21.6913, 227.9696, -10.9593>, <-0.0000, -0.5878, -0.8090>, <32.8264, 227.9696, -10.9594>, <0.0000, -0.5878, -0.8090>, <31.6424, 223.0322, -4.1635>, <0.0000, -0.9511, -0.3090> }
    smooth_triangle { <31.6424, 223.0322, -4.1635>, <0.0000, -0.9511, -0.3090>, <21.2855, 223.0322, -4.1635>, <-0.0000, -0.9511, -0.3090>, <21.6913, 227.9696, -10.9593>, <-0.0000, -0.5878, -0.8090> }
    smooth_triangle { <21.2855, 223.0322, -4.1635>, <-0.0000, -0.9511, -0.3090>, <31.6424, 223.0322, -4.1635>, <0.0000, -0.9511, -0.3090>, <31.6424, 223.0321, 4.2366>, <0.0000, -0.9511, 0.3090> }
    smooth_triangle { <31.6424, 223.0321, 4.2366>, <0.0000, -0.9511, 0.3090>, <21.2855, 223.0321, 4.2366>, <-0.0000, -0.9511, 0.3090>, <21.2855, 223.0322, -4.1635>, <-0.0000, -0.9511, -0.3090> }
    smooth_triangle { <21.2855, 223.0321, 4.2366>, <-0.0000, -0.9511, 0.3090>, <31.6424, 223.0321, 4.2366>, <0.0000, -0.9511, 0.3090>, <32.8925, 227.9696, 11.0325>, <-0.0000, -0.5878, 0.8090> }
    smooth_triangle { <32.8925, 227.9696, 11.0325>, <-0.0000, -0.5878, 0.8090>, <21.7140, 227.9696, 11.0325>, <-0.0000, -0.5878, 0.8090>, <21.2855, 223.0321, 4.2366>, <-0.0000, -0.9511, 0.3090> }
    smooth_triangle { <21.7140, 227.9696, 11.0325>, <-0.0000, -0.5878, 0.8090>, <32.8925, 227.9696, 11.0325>, <-0.0000, -0.5878, 0.8090>, <31.7756, 235.9586, 13.6283>, <0.0000, 0.0000, 1.0000> }
    smooth_triangle { <31.7756, 235.9586, 13.6283>, <0.0000, 0.0000, 1.0000>, <21.3312, 235.9586, 13.6283>, <0.0000, 0.0000, 1.0000>, <21.7140, 227.9696, 11.0325>, <-0.0000, -0.5878, 0.8090> }
    smooth_triangle { <31.7756, 235.9586, 13.6283>, <0.0000, 0.0000, 1.0000>, <42.2206, 235.9586, 13.6283>, <0.0000, 0.0000, 1.0000>, <44.1626, 243.9476, 11.0325>, <0.0000, 0.5878, 0.8090> }
    smooth_triangle { <44.1626, 243.9476, 11.0325>, <0.0000, 0.5878, 0.8090>, <32.9444, 243.9476, 11.0325>, <0.0000, 0.5878, 0.8090>, <31.7756, 235.9586, 13.6283>, <0.0000, 0.0000, 1.0000> }
    smooth_triangle { <32.9444, 243.9476, 11.0325>, <0.0000, 0.5878, 0.8090>, <44.1626, 243.9476, 11.0325>, <0.0000, 0.5878, 0.8090>, <42.3489, 248.8850, 4.2366>, <-0.0000, 0.9511, 0.3090> }
    smooth_triangle { <42.3489, 248.8850, 4.2366>, <-0.0000, 0.9511, 0.3090>, <31.8528, 248.8850, 4.2366>, <-0.0000, 0.9511, 0.3090>, <32.9444, 243.9476, 11.0325>, <0.0000, 0.5878, 0.8090> }
    smooth_triangle { <31.8528, 248.8850, 4.2366>, <-0.0000, 0.9511, 0.3090>, <42.3489, 248.8850, 4.2366>, <-0.0000, 0.9511, 0.3090>, <42.3460, 248.8850, -4.1635>, <-0.0000, 0.9511, -0.3090> }
    smooth_triangle { <42.3460, 248.8850, -4.1635>, <-0.0000, 0.9511, -0.3090>, <31.8511, 248.8850, -4.1635>, <-0.0000, 0.9511, -0.3090>, <31.8528, 248.8850, 4.2366>, <-0.0000, 0.9511, 0.3090> }
    smooth_triangle { <31.8511, 248.8850, -4.1635>, <-0.0000, 0.9511, -0.3090>, <42.3460, 248.8850, -4.1635>, <-0.0000, 0.9511, -0.3090>, <44.0482, 243.9476, -10.9594>, <-0.0000, 0.5878, -0.8090> }
    smooth_triangle { <44.0482, 243.9476, -10.9594>, <-0.0000, 0.5878, -0.8090>, <32.8756, 243.9476, -10.9594>, <-0.0000, 0.5878, -0.8090>, <31.8511, 248.8850, -4.1635>, <-0.0000, 0.9511, -0.3090> }
    smooth_triangle { <32.8756, 243.9476, -10.9594>, <-0.0000, 0.5878, -0.8090>, <44.0482, 243.9476, -10.9594>, <-0.0000, 0.5878, -0.8090>, <41.9992, 235.9586, -13.5551>, <0.0000, 0.0000, -1.0000> }
    smooth_triangle { <41.9992, 235.9586, -13.5551>, <0.0000, 0.0000, -1.0000>, <31.6424, 235.9586, -13.5551>, <0.0000, 0.0000, -1.0000>, <32.8756, 243.9476, -10.9594>, <-0.0000, 0.5878, -0.8090> }
    smooth_triangle { <31.6424, 235.9586, -13.5551>, <0.0000, 0.0000, -1.0000>, <41.9992, 235.9586, -13.5551>, <0.0000, 0.0000, -1.0000>, <43.9665, 227.9696, -10.9594>, <0.0000, -0.5878, -0.8090> }
    smooth_triangle { <43.9665, 227.9696, -10.9594>, <0.0000, -0.5878, -0.8090>, <32.8264, 227.9696, -10.9594>, <0.0000, -0.5878, -0.8090>, <31.6424, 235.9586, -13.5551>, <0.0000, 0.0000, -1.0000> }
    smooth_triangle { <32.8264, 227.9696, -10.9594>, <0.0000, -0.5878, -0.8090>, <43.9665, 227.9696, -10.9594>, <0.0000, -0.5878, -0.8090>, <41.9992, 223.0322, -4.1635>, <0.0000, -0.9511, -0.3090> }
    smooth_triangle { <41.9992, 223.0322, -4.1635>, <0.0000, -0.9511, -0.3090>, <31.6424, 223.0322, -4.1635>, <0.0000, -0.9511, -0.3090>, <32.8264, 227.9696, -10.9594>, <0.0000, -0.5878, -0.8090> }
    smooth_triangle { <31.6424, 223.0322, -4.1635>, <0.0000, -0.9511, -0.3090>, <41.9992, 223.0322, -4.1635>, <0.0000, -0.9511, -0.3090>, <41.9992, 223.0322, 4.2366>, <0.0000, -0.9511, 0.3090> }
    smooth_triangle { <41.9992, 223.0322, 4.2366>, <0.0000, -0.9511, 0.3090>, <31.6424, 223.0321, 4.2366>, <0.0000, -0.9511, 0.3090>, <31.6424, 223.0322, -4.1635>, <0.0000, -0.9511, -0.3090> }
    smooth_triangle { <31.6424, 223.0321, 4.2366>, <0.0000, -0.9511, 0.3090>, <41.9992, 223.0322, 4.2366>, <0.0000, -0.9511, 0.3090>, <44.0763, 227.9696, 11.0325>, <-0.0000, -0.5878, 0.8090> }
    smooth_triangle { <44.0763, 227.9696, 11.0325>, <-0.0000, -0.5878, 0.8090>, <32.8925, 227.9696, 11.0325>, <-0.0000, -0.5878, 0.8090>, <31.6424, 223.0321, 4.2366>, <0.0000, -0.9511, 0.3090> }
    smooth_triangle { <32.8925, 227.9696, 11.0325>, <-0.0000, -0.5878, 0.8090>, <44.0763, 227.9696, 11.0325>, <-0.0000, -0.5878, 0.8090>, <42.2206, 235.9586, 13.6283>, <0.0000, 0.0000, 1.0000> }
    smooth_triangle { <42.2206, 235.9586, 13.6283>, <0.0000, 0.0000, 1.0000>, <31.7756, 235.9586, 13.6283>, <0.0000, 0.0000, 1.0000>, <32.8925, 227.9696, 11.0325>, <-0.0000, -0.5878, 0.8090> }
    smooth_triangle { <43.9665, 227.9696, -10.9594>, <0.9968, -0.0640, -0.0478>, <42.2206, 235.9586, 13.6283>, <0.9885, -0.0314, -0.1476>, <44.0763, 227.9696, 11.0325>, <0.9967, -0.0812, -0.0050> }
    smooth_triangle { <42.2206, 235.9586, 13.6283>, <0.9885, -0.0314, -0.1476>, <42.3489, 248.8850, 4.2366>, <0.9860, -0.0839, -0.1444>, <44.1626, 243.9476, 11.0325>, <0.8102, -0.3498, -0.4704> }
    smooth_triangle { <43.9665, 227.9696, -10.9594>, <0.9968, -0.0640, -0.0478>, <42.3489, 248.8850, 4.2366>, <0.9860, -0.0839, -0.1444>, <42.2206, 235.9586, 13.6283>, <0.9885, -0.0314, -0.1476> }
    smooth_triangle { <44.0763, 227.9696, 11.0325>, <0.9967, -0.0812, -0.0050>, <41.9992, 223.0322, 4.2366>, <0.9265, -0.3763, -0.0023>, <43.9665, 227.9696, -10.9594>, <0.9968, -0.0640, -0.0478> }
    smooth_triangle { <43.9665, 227.9696, -10.9594>, <0.9968, -0.0640, -0.0478>, <42.3460, 248.8850, -4.1635>, <0.9916, 0.0365, 0.1241>, <42.3489, 248.8850, 4.2366>, <0.9860, -0.0839, -0.1444> }
    smooth_triangle { <43.9665, 227.9696, -10.9594>, <0.9968, -0.0640, -0.0478>, <44.0482, 243.9476, -10.9594>, <0.9791, -0.0050, -0.2033>, <42.3460, 248.8850, -4.1635>, <0.9916, 0.0365, 0.1241> }
    smooth_triangle { <44.0482, 243.9476, -10.9594>, <0.9791, -0.0050, -0.2033>, <43.9665, 227.9696, -10.9594>, <0.9968, -0.0640, -0.0478>, <41.9992, 235.9586, -13.5551>, <0.7909, -0.0040, -0.6119> }
    smooth_triangle { <43.9665, 227.9696, -10.9594>, <0.9968, -0.0640, -0.0478>, <41.9992, 223.0322, 4.2366>, <0.9265, -0.3763, -0.0023>, <41.9992, 223.0322, -4.1635>, <0.9290, -0.3701, 0.0000> }
    smooth_triangle { <-10.1199, 248.8850, -4.1635>, <-0.9922, 0.0352, 0.1200>, <-11.6842, 227.9696, -10.9593>, <-0.9970, -0.0621, -0.0471>, <-10.1227, 248.8850, 4.2366>, <-0.9866, -0.0822, -0.1409> }
    smooth_triangle { <-11.6842, 227.9696, -10.9593>, <-0.9970, -0.0621, -0.0471>, <-11.7631, 243.9475, -10.9593>, <-0.9800, -0.0048, -0.1991>, <-9.7851, 235.9586, -13.5551>, <-0.8012, -0.0040, -0.5984> }
    smooth_triangle { <-11.7631, 243.9475, -10.9593>, <-0.9800, -0.0048, -0.1991>, <-11.6842, 227.9696, -10.9593>, <-0.9970, -0.0621, -0.0471>, <-10.1199, 248.8850, -4.1635>, <-0.9922, 0.0352, 0.1200> }
    smooth_triangle { <-11.6842, 227.9696, -10.9593>, <-0.9970, -0.0621, -0.0471>, <-9.7851, 223.0321, -4.1635>, <-0.9333, -0.3590, -0.0000>, <-9.7851, 223.0321, 4.2366>, <-0.9310, -0.3650, -0.0022> }
    smooth_triangle { <-9.9988, 235.9586, 13.6283>, <-0.9891, -0.0315, -0.1439>, <-11.6842, 227.9696, -10.9593>, <-0.9970, -0.0621, -0.0471>, <-11.7903, 227.9696, 11.0325>, <-0.9969, -0.0789, -0.0048> }
    smooth_triangle { <-10.1227, 248.8850, 4.2366>, <-0.9866, -0.0822, -0.1409>, <-9.9988, 235.9586, 13.6283>, <-0.9891, -0.0315, -0.1439>, <-11.8735, 243.9476, 11.0325>, <-0.8198, -0.3417, -0.4595> }
    smooth_triangle { <-10.1227, 248.8850, 4.2366>, <-0.9866, -0.0822, -0.1409>, <-11.6842, 227.9696, -10.9593>, <-0.9970, -0.0621, -0.0471>, <-9.9988, 235.9586, 13.6283>, <-0.9891, -0.0315, -0.1439> }
    smooth_triangle { <-11.7903, 227.9696, 11.0325>, <-0.9969, -0.0789, -0.0048>, <-11.6842, 227.9696, -10.9593>, <-0.9970, -0.0621, -0.0471>, <-9.7851, 223.0321, 4.2366>, <-0.9310, -0.3650, -0.0022> }
    texture {
     Brushed_Aluminum
    }
  }

  mesh { // Surf2 
    smooth_triangle { <-9.3774, 236.2304, 13.7914>, <-0.4225, 0.0024, 0.9064>, <-15.6114, 236.2304, 11.0730>, <-0.4219, 0.0033, 0.9066>, <-16.4725, 229.8392, 8.9964>, <-0.4381, -0.5258, 0.7291> }
    smooth_triangle { <-16.4725, 229.8392, 8.9964>, <-0.4381, -0.5258, 0.7291>, <-11.3241, 228.2414, 11.1956>, <-0.4444, -0.5222, 0.7279>, <-9.3774, 236.2304, 13.7914>, <-0.4225, 0.0024, 0.9064> }
    smooth_triangle { <-11.3241, 228.2414, 11.1956>, <-0.4444, -0.5222, 0.7279>, <-16.4725, 229.8392, 8.9964>, <-0.4381, -0.5258, 0.7291>, <-15.6790, 225.8893, 3.5597>, <-0.4202, -0.8710, 0.2546> }
    smooth_triangle { <-15.6790, 225.8893, 3.5597>, <-0.4202, -0.8710, 0.2546>, <-9.7069, 223.3040, 4.3997>, <-0.4221, -0.8723, 0.2469>, <-11.3241, 228.2414, 11.1956>, <-0.4444, -0.5222, 0.7279> }
    smooth_triangle { <-9.7069, 223.3040, 4.3997>, <-0.4221, -0.8723, 0.2469>, <-15.6790, 225.8893, 3.5597>, <-0.4202, -0.8710, 0.2546>, <-15.7013, 225.8893, -3.1604>, <-0.4198, -0.8723, -0.2508> }
    smooth_triangle { <-15.7013, 225.8893, -3.1604>, <-0.4198, -0.8723, -0.2508>, <-9.7096, 223.3040, -4.0004>, <-0.4213, -0.8735, -0.2439>, <-9.7069, 223.3040, 4.3997>, <-0.4221, -0.8723, 0.2469> }
    smooth_triangle { <-9.7096, 223.3040, -4.0004>, <-0.4213, -0.8735, -0.2439>, <-15.7013, 225.8893, -3.1604>, <-0.4198, -0.8723, -0.2508>, <-16.5886, 229.8392, -8.5971>, <-0.4384, -0.5298, -0.7260> }
    smooth_triangle { <-16.5886, 229.8392, -8.5971>, <-0.4384, -0.5298, -0.7260>, <-11.4328, 228.2414, -10.7963>, <-0.4442, -0.5264, -0.7250>, <-9.7096, 223.3040, -4.0004>, <-0.4213, -0.8735, -0.2439> }
    smooth_triangle { <-11.4328, 228.2414, -10.7963>, <-0.4442, -0.5264, -0.7250>, <-16.5886, 229.8392, -8.5971>, <-0.4384, -0.5298, -0.7260>, <-15.7976, 236.2304, -10.6737>, <-0.4233, 0.0034, -0.9060> }
    smooth_triangle { <-15.7976, 236.2304, -10.6737>, <-0.4233, 0.0034, -0.9060>, <-9.5877, 236.2304, -13.3920>, <-0.4235, 0.0025, -0.9059>, <-11.4328, 228.2414, -10.7963>, <-0.4442, -0.5264, -0.7250> }
    smooth_triangle { <-9.5877, 236.2304, -13.3920>, <-0.4235, 0.0025, -0.9059>, <-15.7976, 236.2304, -10.6737>, <-0.4233, 0.0034, -0.9060>, <-16.4699, 242.6216, -8.5971>, <-0.4388, 0.5371, -0.7204> }
    smooth_triangle { <-16.4699, 242.6216, -8.5971>, <-0.4388, 0.5371, -0.7204>, <-11.3509, 244.2194, -10.7962>, <-0.4454, 0.5330, -0.7194>, <-9.5877, 236.2304, -13.3920>, <-0.4235, 0.0025, -0.9059> }
    smooth_triangle { <-11.3509, 244.2194, -10.7962>, <-0.4454, 0.5330, -0.7194>, <-16.4699, 242.6216, -8.5971>, <-0.4388, 0.5371, -0.7204>, <-15.3964, 246.5715, -3.1604>, <-0.4177, 0.8748, -0.2456> }
    smooth_triangle { <-15.3964, 246.5715, -3.1604>, <-0.4177, 0.8748, -0.2456>, <-9.3773, 249.1568, -4.0004>, <-0.4199, 0.8758, -0.2382>, <-11.3509, 244.2194, -10.7962>, <-0.4454, 0.5330, -0.7194> }
    smooth_triangle { <-9.3773, 249.1568, -4.0004>, <-0.4199, 0.8758, -0.2382>, <-15.3964, 246.5715, -3.1604>, <-0.4177, 0.8748, -0.2456>, <-15.3759, 246.5715, 3.5597>, <-0.4182, 0.8735, 0.2492> }
    smooth_triangle { <-15.3759, 246.5715, 3.5597>, <-0.4182, 0.8735, 0.2492>, <-9.3773, 249.1568, 4.3997>, <-0.4207, 0.8746, 0.2411>, <-9.3773, 249.1568, -4.0004>, <-0.4199, 0.8758, -0.2382> }
    smooth_triangle { <-9.3773, 249.1568, 4.3997>, <-0.4207, 0.8746, 0.2411>, <-15.3759, 246.5715, 3.5597>, <-0.4182, 0.8735, 0.2492>, <-16.3568, 242.6216, 8.9964>, <-0.4386, 0.5331, 0.7235> }
    smooth_triangle { <-16.3568, 242.6216, 8.9964>, <-0.4386, 0.5331, 0.7235>, <-11.2465, 244.2194, 11.1956>, <-0.4456, 0.5289, 0.7223>, <-9.3773, 249.1568, 4.3997>, <-0.4207, 0.8746, 0.2411> }
    smooth_triangle { <-11.2465, 244.2194, 11.1956>, <-0.4456, 0.5289, 0.7223>, <-16.3568, 242.6216, 8.9964>, <-0.4386, 0.5331, 0.7235>, <-15.6114, 236.2304, 11.0730>, <-0.4219, 0.0033, 0.9066> }
    smooth_triangle { <-15.6114, 236.2304, 11.0730>, <-0.4219, 0.0033, 0.9066>, <-9.3774, 236.2304, 13.7914>, <-0.4225, 0.0024, 0.9064>, <-11.2465, 244.2194, 11.1956>, <-0.4456, 0.5289, 0.7223> }
    smooth_triangle { <-15.6114, 236.2304, 11.0730>, <-0.4219, 0.0033, 0.9066>, <-21.6717, 236.2304, 8.3547>, <-0.4296, 0.0050, 0.9030>, <-21.9680, 231.4370, 6.7972>, <-0.4369, -0.5284, 0.7279> }
    smooth_triangle { <-21.9680, 231.4370, 6.7972>, <-0.4369, -0.5284, 0.7279>, <-16.4725, 229.8392, 8.9964>, <-0.4381, -0.5258, 0.7291>, <-15.6114, 236.2304, 11.0730>, <-0.4219, 0.0033, 0.9066> }
    smooth_triangle { <-16.4725, 229.8392, 8.9964>, <-0.4381, -0.5258, 0.7291>, <-21.9680, 231.4370, 6.7972>, <-0.4369, -0.5284, 0.7279>, <-21.6583, 228.4745, 2.7197>, <-0.4263, -0.8645, 0.2663> }
    smooth_triangle { <-21.6583, 228.4745, 2.7197>, <-0.4263, -0.8645, 0.2663>, <-15.6790, 225.8893, 3.5597>, <-0.4202, -0.8710, 0.2546>, <-16.4725, 229.8392, 8.9964>, <-0.4381, -0.5258, 0.7291> }
    smooth_triangle { <-15.6790, 225.8893, 3.5597>, <-0.4202, -0.8710, 0.2546>, <-21.6583, 228.4745, 2.7197>, <-0.4263, -0.8645, 0.2663>, <-21.6895, 228.4746, -2.3204>, <-0.4263, -0.8661, -0.2610> }
    smooth_triangle { <-21.6895, 228.4746, -2.3204>, <-0.4263, -0.8661, -0.2610>, <-15.7013, 225.8893, -3.1604>, <-0.4198, -0.8723, -0.2508>, <-15.6790, 225.8893, 3.5597>, <-0.4202, -0.8710, 0.2546> }
    smooth_triangle { <-15.7013, 225.8893, -3.1604>, <-0.4198, -0.8723, -0.2508>, <-21.6895, 228.4746, -2.3204>, <-0.4263, -0.8661, -0.2610>, <-22.0762, 231.4370, -6.3979>, <-0.4381, -0.5322, -0.7245> }
    smooth_triangle { <-22.0762, 231.4370, -6.3979>, <-0.4381, -0.5322, -0.7245>, <-16.5886, 229.8392, -8.5971>, <-0.4384, -0.5298, -0.7260>, <-15.7013, 225.8893, -3.1604>, <-0.4198, -0.8723, -0.2508> }
    smooth_triangle { <-16.5886, 229.8392, -8.5971>, <-0.4384, -0.5298, -0.7260>, <-22.0762, 231.4370, -6.3979>, <-0.4381, -0.5322, -0.7245>, <-21.8249, 236.2304, -7.9554>, <-0.4317, 0.0051, -0.9020> }
    smooth_triangle { <-21.8249, 236.2304, -7.9554>, <-0.4317, 0.0051, -0.9020>, <-15.7976, 236.2304, -10.6737>, <-0.4233, 0.0034, -0.9060>, <-16.5886, 229.8392, -8.5971>, <-0.4384, -0.5298, -0.7260> }
    smooth_triangle { <-15.7976, 236.2304, -10.6737>, <-0.4233, 0.0034, -0.9060>, <-21.8249, 236.2304, -7.9554>, <-0.4317, 0.0051, -0.9020>, <-21.9491, 241.0238, -6.3979>, <-0.4370, 0.5409, -0.7187> }
    smooth_triangle { <-21.9491, 241.0238, -6.3979>, <-0.4370, 0.5409, -0.7187>, <-16.4699, 242.6216, -8.5971>, <-0.4388, 0.5371, -0.7204>, <-15.7976, 236.2304, -10.6737>, <-0.4233, 0.0034, -0.9060> }
    smooth_triangle { <-16.4699, 242.6216, -8.5971>, <-0.4388, 0.5371, -0.7204>, <-21.9491, 241.0238, -6.3979>, <-0.4370, 0.5409, -0.7187>, <-21.4320, 243.9863, -2.3204>, <-0.4229, 0.8691, -0.2563> }
    smooth_triangle { <-21.4320, 243.9863, -2.3204>, <-0.4229, 0.8691, -0.2563>, <-15.3964, 246.5715, -3.1604>, <-0.4177, 0.8748, -0.2456>, <-16.4699, 242.6216, -8.5971>, <-0.4388, 0.5371, -0.7204> }
    smooth_triangle { <-15.3964, 246.5715, -3.1604>, <-0.4177, 0.8748, -0.2456>, <-21.4320, 243.9863, -2.3204>, <-0.4229, 0.8691, -0.2563>, <-21.4019, 243.9863, 2.7197>, <-0.4229, 0.8676, 0.2615> }
    smooth_triangle { <-21.4019, 243.9863, 2.7197>, <-0.4229, 0.8676, 0.2615>, <-15.3759, 246.5715, 3.5597>, <-0.4182, 0.8735, 0.2492>, <-15.3964, 246.5715, -3.1604>, <-0.4177, 0.8748, -0.2456> }
    smooth_triangle { <-15.3759, 246.5715, 3.5597>, <-0.4182, 0.8735, 0.2492>, <-21.4019, 243.9863, 2.7197>, <-0.4229, 0.8676, 0.2615>, <-21.8428, 241.0238, 6.7972>, <-0.4359, 0.5371, 0.7222> }
    smooth_triangle { <-21.8428, 241.0238, 6.7972>, <-0.4359, 0.5371, 0.7222>, <-16.3568, 242.6216, 8.9964>, <-0.4386, 0.5331, 0.7235>, <-15.3759, 246.5715, 3.5597>, <-0.4182, 0.8735, 0.2492> }
    smooth_triangle { <-16.3568, 242.6216, 8.9964>, <-0.4386, 0.5331, 0.7235>, <-21.8428, 241.0238, 6.7972>, <-0.4359, 0.5371, 0.7222>, <-21.6717, 236.2304, 8.3547>, <-0.4296, 0.0050, 0.9030> }
    smooth_triangle { <-21.6717, 236.2304, 8.3547>, <-0.4296, 0.0050, 0.9030>, <-15.6114, 236.2304, 11.0730>, <-0.4219, 0.0033, 0.9066>, <-16.3568, 242.6216, 8.9964>, <-0.4386, 0.5331, 0.7235> }
    smooth_triangle { <-21.6717, 236.2304, 8.3547>, <-0.4296, 0.0050, 0.9030>, <-27.3328, 236.2304, 5.6363>, <-0.4569, 0.0068, 0.8895>, <-27.4106, 233.0348, 4.5980>, <-0.4598, -0.5215, 0.7188> }
    smooth_triangle { <-27.4106, 233.0348, 4.5980>, <-0.4598, -0.5215, 0.7188>, <-21.9680, 231.4370, 6.7972>, <-0.4369, -0.5284, 0.7279>, <-21.6717, 236.2304, 8.3547>, <-0.4296, 0.0050, 0.9030> }
    smooth_triangle { <-21.9680, 231.4370, 6.7972>, <-0.4369, -0.5284, 0.7279>, <-27.4106, 233.0348, 4.5980>, <-0.4598, -0.5215, 0.7188>, <-27.3360, 231.0598, 1.8797>, <-0.4541, -0.8488, 0.2707> }
    smooth_triangle { <-27.3360, 231.0598, 1.8797>, <-0.4541, -0.8488, 0.2707>, <-21.6583, 228.4745, 2.7197>, <-0.4263, -0.8645, 0.2663>, <-21.9680, 231.4370, 6.7972>, <-0.4369, -0.5284, 0.7279> }
    smooth_triangle { <-21.6583, 228.4745, 2.7197>, <-0.4263, -0.8645, 0.2663>, <-27.3360, 231.0598, 1.8797>, <-0.4541, -0.8488, 0.2707>, <-27.3653, 231.0598, -1.4804>, <-0.4547, -0.8507, -0.2636> }
    smooth_triangle { <-27.3653, 231.0598, -1.4804>, <-0.4547, -0.8507, -0.2636>, <-21.6895, 228.4746, -2.3204>, <-0.4263, -0.8661, -0.2610>, <-21.6583, 228.4745, 2.7197>, <-0.4263, -0.8645, 0.2663> }
    smooth_triangle { <-21.6895, 228.4746, -2.3204>, <-0.4263, -0.8661, -0.2610>, <-27.3653, 231.0598, -1.4804>, <-0.4547, -0.8507, -0.2636>, <-27.4955, 233.0348, -4.1987>, <-0.4620, -0.5252, -0.7147> }
    smooth_triangle { <-27.4955, 233.0348, -4.1987>, <-0.4620, -0.5252, -0.7147>, <-22.0762, 231.4370, -6.3979>, <-0.4381, -0.5322, -0.7245>, <-21.6895, 228.4746, -2.3204>, <-0.4263, -0.8661, -0.2610> }
    smooth_triangle { <-22.0762, 231.4370, -6.3979>, <-0.4381, -0.5322, -0.7245>, <-27.4955, 233.0348, -4.1987>, <-0.4620, -0.5252, -0.7147>, <-27.4439, 236.2304, -5.2370>, <-0.4600, 0.0069, -0.8879> }
    smooth_triangle { <-27.4439, 236.2304, -5.2370>, <-0.4600, 0.0069, -0.8879>, <-21.8249, 236.2304, -7.9554>, <-0.4317, 0.0051, -0.9020>, <-22.0762, 231.4370, -6.3979>, <-0.4381, -0.5322, -0.7245> }
    smooth_triangle { <-21.8249, 236.2304, -7.9554>, <-0.4317, 0.0051, -0.9020>, <-27.4439, 236.2304, -5.2370>, <-0.4600, 0.0069, -0.8879>, <-27.3882, 239.4260, -4.1987>, <-0.4593, 0.5359, -0.7084> }
    smooth_triangle { <-27.3882, 239.4260, -4.1987>, <-0.4593, 0.5359, -0.7084>, <-21.9491, 241.0238, -6.3979>, <-0.4370, 0.5409, -0.7187>, <-21.8249, 236.2304, -7.9554>, <-0.4317, 0.0051, -0.9020> }
    smooth_triangle { <-21.9491, 241.0238, -6.3979>, <-0.4370, 0.5409, -0.7187>, <-27.3882, 239.4260, -4.1987>, <-0.4593, 0.5359, -0.7084>, <-27.1750, 241.4010, -1.4804>, <-0.4495, 0.8548, -0.2593> }
    smooth_triangle { <-27.1750, 241.4010, -1.4804>, <-0.4495, 0.8548, -0.2593>, <-21.4320, 243.9863, -2.3204>, <-0.4229, 0.8691, -0.2563>, <-21.9491, 241.0238, -6.3979>, <-0.4370, 0.5409, -0.7187> }
    smooth_triangle { <-21.4320, 243.9863, -2.3204>, <-0.4229, 0.8691, -0.2563>, <-27.1750, 241.4010, -1.4804>, <-0.4495, 0.8548, -0.2593>, <-27.1464, 241.4010, 1.8797>, <-0.4490, 0.8530, 0.2662> }
    smooth_triangle { <-27.1464, 241.4010, 1.8797>, <-0.4490, 0.8530, 0.2662>, <-21.4019, 243.9863, 2.7197>, <-0.4229, 0.8676, 0.2615>, <-21.4320, 243.9863, -2.3204>, <-0.4229, 0.8691, -0.2563> }
    smooth_triangle { <-21.4019, 243.9863, 2.7197>, <-0.4229, 0.8676, 0.2615>, <-27.1464, 241.4010, 1.8797>, <-0.4490, 0.8530, 0.2662>, <-27.3042, 239.4261, 4.5980>, <-0.4571, 0.5321, 0.7126> }
    smooth_triangle { <-27.3042, 239.4261, 4.5980>, <-0.4571, 0.5321, 0.7126>, <-21.8428, 241.0238, 6.7972>, <-0.4359, 0.5371, 0.7222>, <-21.4019, 243.9863, 2.7197>, <-0.4229, 0.8676, 0.2615> }
    smooth_triangle { <-21.8428, 241.0238, 6.7972>, <-0.4359, 0.5371, 0.7222>, <-27.3042, 239.4261, 4.5980>, <-0.4571, 0.5321, 0.7126>, <-27.3328, 236.2304, 5.6363>, <-0.4569, 0.0068, 0.8895> }
    smooth_triangle { <-27.3328, 236.2304, 5.6363>, <-0.4569, 0.0068, 0.8895>, <-21.6717, 236.2304, 8.3547>, <-0.4296, 0.0050, 0.9030>, <-21.8428, 241.0238, 6.7972>, <-0.4359, 0.5371, 0.7222> }
    smooth_triangle { <-27.3328, 236.2304, 5.6363>, <-0.4569, 0.0068, 0.8895>, <-32.3699, 236.2304, 2.9180>, <-0.5105, 0.0088, 0.8598>, <-32.3956, 234.6326, 2.3988>, <-0.5125, -0.5021, 0.6966> }
    smooth_triangle { <-32.3956, 234.6326, 2.3988>, <-0.5125, -0.5021, 0.6966>, <-27.4106, 233.0348, 4.5980>, <-0.4598, -0.5215, 0.7188>, <-27.3328, 236.2304, 5.6363>, <-0.4569, 0.0068, 0.8895> }
    smooth_triangle { <-27.4106, 233.0348, 4.5980>, <-0.4598, -0.5215, 0.7188>, <-32.3956, 234.6326, 2.3988>, <-0.5125, -0.5021, 0.6966>, <-32.4014, 233.6451, 1.0397>, <-0.5111, -0.8171, 0.2669> }
    smooth_triangle { <-32.4014, 233.6451, 1.0397>, <-0.5111, -0.8171, 0.2669>, <-27.3360, 231.0598, 1.8797>, <-0.4541, -0.8488, 0.2707>, <-27.4106, 233.0348, 4.5980>, <-0.4598, -0.5215, 0.7188> }
    smooth_triangle { <-27.3360, 231.0598, 1.8797>, <-0.4541, -0.8488, 0.2707>, <-32.4014, 233.6451, 1.0397>, <-0.5111, -0.8171, 0.2669>, <-32.4193, 233.6451, -0.6404>, <-0.5123, -0.8192, -0.2577> }
    smooth_triangle { <-32.4193, 233.6451, -0.6404>, <-0.5123, -0.8192, -0.2577>, <-27.3653, 231.0598, -1.4804>, <-0.4547, -0.8507, -0.2636>, <-27.3360, 231.0598, 1.8797>, <-0.4541, -0.8488, 0.2707> }
    smooth_triangle { <-27.3653, 231.0598, -1.4804>, <-0.4547, -0.8507, -0.2636>, <-32.4193, 233.6451, -0.6404>, <-0.5123, -0.8192, -0.2577>, <-32.4435, 234.6326, -1.9995>, <-0.5162, -0.5058, -0.6912> }
    smooth_triangle { <-32.4435, 234.6326, -1.9995>, <-0.5162, -0.5058, -0.6912>, <-27.4955, 233.0348, -4.1987>, <-0.4620, -0.5252, -0.7147>, <-27.3653, 231.0598, -1.4804>, <-0.4547, -0.8507, -0.2636> }
    smooth_triangle { <-27.4955, 233.0348, -4.1987>, <-0.4620, -0.5252, -0.7147>, <-32.4435, 234.6326, -1.9995>, <-0.5162, -0.5058, -0.6912>, <-32.4299, 236.2304, -2.5187>, <-0.5152, 0.0090, -0.8571> }
    smooth_triangle { <-32.4299, 236.2304, -2.5187>, <-0.5152, 0.0090, -0.8571>, <-27.4439, 236.2304, -5.2370>, <-0.4600, 0.0069, -0.8879>, <-27.4955, 233.0348, -4.1987>, <-0.4620, -0.5252, -0.7147> }
    smooth_triangle { <-27.4439, 236.2304, -5.2370>, <-0.4600, 0.0069, -0.8879>, <-32.4299, 236.2304, -2.5187>, <-0.5152, 0.0090, -0.8571>, <-32.3806, 237.8282, -1.9995>, <-0.5114, 0.5195, -0.6845> }
    smooth_triangle { <-32.3806, 237.8282, -1.9995>, <-0.5114, 0.5195, -0.6845>, <-27.3882, 239.4260, -4.1987>, <-0.4593, 0.5359, -0.7084>, <-27.4439, 236.2304, -5.2370>, <-0.4600, 0.0069, -0.8879> }
    smooth_triangle { <-27.3882, 239.4260, -4.1987>, <-0.4593, 0.5359, -0.7084>, <-32.3806, 237.8282, -1.9995>, <-0.5114, 0.5195, -0.6845>, <-32.3154, 238.8157, -0.6404>, <-0.5044, 0.8254, -0.2535> }
    smooth_triangle { <-32.3154, 238.8157, -0.6404>, <-0.5044, 0.8254, -0.2535>, <-27.1750, 241.4010, -1.4804>, <-0.4495, 0.8548, -0.2593>, <-27.3882, 239.4260, -4.1987>, <-0.4593, 0.5359, -0.7084> }
    smooth_triangle { <-27.1750, 241.4010, -1.4804>, <-0.4495, 0.8548, -0.2593>, <-32.3154, 238.8157, -0.6404>, <-0.5044, 0.8254, -0.2535>, <-32.2976, 238.8158, 1.0397>, <-0.5032, 0.8234, 0.2625> }
    smooth_triangle { <-32.2976, 238.8158, 1.0397>, <-0.5032, 0.8234, 0.2625>, <-27.1464, 241.4010, 1.8797>, <-0.4490, 0.8530, 0.2662>, <-27.1750, 241.4010, -1.4804>, <-0.4495, 0.8548, -0.2593> }
    smooth_triangle { <-27.1464, 241.4010, 1.8797>, <-0.4490, 0.8530, 0.2662>, <-32.2976, 238.8158, 1.0397>, <-0.5032, 0.8234, 0.2625>, <-32.3330, 237.8282, 2.3988>, <-0.5079, 0.5157, 0.6900> }
    smooth_triangle { <-32.3330, 237.8282, 2.3988>, <-0.5079, 0.5157, 0.6900>, <-27.3042, 239.4261, 4.5980>, <-0.4571, 0.5321, 0.7126>, <-27.1464, 241.4010, 1.8797>, <-0.4490, 0.8530, 0.2662> }
    smooth_triangle { <-27.3042, 239.4261, 4.5980>, <-0.4571, 0.5321, 0.7126>, <-32.3330, 237.8282, 2.3988>, <-0.5079, 0.5157, 0.6900>, <-32.3699, 236.2304, 2.9180>, <-0.5105, 0.0088, 0.8598> }
    smooth_triangle { <-32.3699, 236.2304, 2.9180>, <-0.5105, 0.0088, 0.8598>, <-27.3328, 236.2304, 5.6363>, <-0.4569, 0.0068, 0.8895>, <-27.3042, 239.4261, 4.5980>, <-0.4571, 0.5321, 0.7126> }
    smooth_triangle { <-32.3699, 236.2304, 2.9180>, <-0.5105, 0.0088, 0.8598>, <-36.5588, 236.2304, 0.1997>, <-0.9999, 0.0127, 0.0070>, <-32.3956, 234.6326, 2.3988>, <-0.5125, -0.5021, 0.6966> }
    smooth_triangle { <-32.3956, 234.6326, 2.3988>, <-0.5125, -0.5021, 0.6966>, <-36.5588, 236.2304, 0.1997>, <-0.9999, 0.0127, 0.0070>, <-32.4014, 233.6451, 1.0397>, <-0.5111, -0.8171, 0.2669> }
    smooth_triangle { <-32.4014, 233.6451, 1.0397>, <-0.5111, -0.8171, 0.2669>, <-36.5588, 236.2304, 0.1997>, <-0.9999, 0.0127, 0.0070>, <-32.4193, 233.6451, -0.6404>, <-0.5123, -0.8192, -0.2577> }
    smooth_triangle { <-32.4193, 233.6451, -0.6404>, <-0.5123, -0.8192, -0.2577>, <-36.5588, 236.2304, 0.1997>, <-0.9999, 0.0127, 0.0070>, <-32.4435, 234.6326, -1.9995>, <-0.5162, -0.5058, -0.6912> }
    smooth_triangle { <-32.4435, 234.6326, -1.9995>, <-0.5162, -0.5058, -0.6912>, <-36.5588, 236.2304, 0.1997>, <-0.9999, 0.0127, 0.0070>, <-32.4299, 236.2304, -2.5187>, <-0.5152, 0.0090, -0.8571> }
    smooth_triangle { <-32.4299, 236.2304, -2.5187>, <-0.5152, 0.0090, -0.8571>, <-36.5588, 236.2304, 0.1997>, <-0.9999, 0.0127, 0.0070>, <-32.3806, 237.8282, -1.9995>, <-0.5114, 0.5195, -0.6845> }
    smooth_triangle { <-32.3806, 237.8282, -1.9995>, <-0.5114, 0.5195, -0.6845>, <-36.5588, 236.2304, 0.1997>, <-0.9999, 0.0127, 0.0070>, <-32.3154, 238.8157, -0.6404>, <-0.5044, 0.8254, -0.2535> }
    smooth_triangle { <-32.3154, 238.8157, -0.6404>, <-0.5044, 0.8254, -0.2535>, <-36.5588, 236.2304, 0.1997>, <-0.9999, 0.0127, 0.0070>, <-32.2976, 238.8158, 1.0397>, <-0.5032, 0.8234, 0.2625> }
    smooth_triangle { <-32.2976, 238.8158, 1.0397>, <-0.5032, 0.8234, 0.2625>, <-36.5588, 236.2304, 0.1997>, <-0.9999, 0.0127, 0.0070>, <-32.3330, 237.8282, 2.3988>, <-0.5079, 0.5157, 0.6900> }
    smooth_triangle { <-32.3330, 237.8282, 2.3988>, <-0.5079, 0.5157, 0.6900>, <-36.5588, 236.2304, 0.1997>, <-0.9999, 0.0127, 0.0070>, <-32.3699, 236.2304, 2.9180>, <-0.5105, 0.0088, 0.8598> }
    smooth_triangle { <-11.3241, 228.2414, 11.1956>, <0.9804, -0.0048, -0.1971>, <-9.7069, 223.3040, 4.3997>, <0.9924, 0.0347, 0.1181>, <-11.2465, 244.2194, 11.1956>, <0.9970, -0.0612, -0.0467> }
    smooth_triangle { <-11.3241, 228.2414, 11.1956>, <0.9804, -0.0048, -0.1971>, <-11.2465, 244.2194, 11.1956>, <0.9970, -0.0612, -0.0467>, <-9.3774, 236.2304, 13.7914>, <0.8058, -0.0039, -0.5922> }
    smooth_triangle { <-9.3773, 249.1568, 4.3997>, <0.9352, -0.3540, 0.0000>, <-11.2465, 244.2194, 11.1956>, <0.9970, -0.0612, -0.0467>, <-9.3773, 249.1568, -4.0004>, <0.9330, -0.3600, -0.0022> }
    smooth_triangle { <-11.2465, 244.2194, 11.1956>, <0.9970, -0.0612, -0.0467>, <-9.7069, 223.3040, 4.3997>, <0.9924, 0.0347, 0.1181>, <-9.7096, 223.3040, -4.0004>, <0.9869, -0.0814, -0.1393> }
    smooth_triangle { <-9.7096, 223.3040, -4.0004>, <0.9869, -0.0814, -0.1393>, <-11.4328, 228.2414, -10.7963>, <0.8241, -0.3380, -0.4546>, <-9.5877, 236.2304, -13.3920>, <0.9893, -0.0315, -0.1422> }
    smooth_triangle { <-11.3509, 244.2194, -10.7962>, <0.9970, -0.0779, -0.0047>, <-9.3773, 249.1568, -4.0004>, <0.9330, -0.3600, -0.0022>, <-11.2465, 244.2194, 11.1956>, <0.9970, -0.0612, -0.0467> }
    smooth_triangle { <-11.2465, 244.2194, 11.1956>, <0.9970, -0.0612, -0.0467>, <-9.5877, 236.2304, -13.3920>, <0.9893, -0.0315, -0.1422>, <-11.3509, 244.2194, -10.7962>, <0.9970, -0.0779, -0.0047> }
    smooth_triangle { <-11.2465, 244.2194, 11.1956>, <0.9970, -0.0612, -0.0467>, <-9.7096, 223.3040, -4.0004>, <0.9869, -0.0814, -0.1393>, <-9.5877, 236.2304, -13.3920>, <0.9893, -0.0315, -0.1422> }
    texture {
      Brushed_Aluminum
    }
  }

  mesh { // Surf2 
    smooth_triangle { <42.2755, 236.0130, 13.6283>, <0.4141, -0.0016, 0.9103>, <48.6693, 236.0130, 10.9099>, <0.4141, -0.0021, 0.9102>, <49.4771, 242.4042, 8.8333>, <0.4295, 0.5339, 0.7284> }
    smooth_triangle { <49.4771, 242.4042, 8.8333>, <0.4295, 0.5339, 0.7284>, <44.2044, 244.0019, 11.0325>, <0.4353, 0.5304, 0.7274>, <42.2755, 236.0130, 13.6283>, <0.4141, -0.0016, 0.9103> }
    smooth_triangle { <44.2044, 244.0019, 11.0325>, <0.4353, 0.5304, 0.7274>, <49.4771, 242.4042, 8.8333>, <0.4295, 0.5339, 0.7284>, <48.5041, 246.3541, 3.3966>, <0.4100, 0.8771, 0.2502> }
    smooth_triangle { <48.5041, 246.3541, 3.3966>, <0.4100, 0.8771, 0.2502>, <42.3345, 248.9394, 4.2366>, <0.4115, 0.8784, 0.2430>, <44.2044, 244.0019, 11.0325>, <0.4353, 0.5304, 0.7274> }
    smooth_triangle { <42.3345, 248.9394, 4.2366>, <0.4115, 0.8784, 0.2430>, <48.5041, 246.3541, 3.3966>, <0.4100, 0.8771, 0.2502>, <48.4809, 246.3541, -3.3235>, <0.4105, 0.8757, -0.2541> }
    smooth_triangle { <48.4809, 246.3541, -3.3235>, <0.4105, 0.8757, -0.2541>, <42.3322, 248.9394, -4.1635>, <0.4123, 0.8772, -0.2461>, <42.3345, 248.9394, 4.2366>, <0.4115, 0.8784, 0.2430> }
    smooth_triangle { <42.3322, 248.9394, -4.1635>, <0.4123, 0.8772, -0.2461>, <48.4809, 246.3541, -3.3235>, <0.4105, 0.8757, -0.2541>, <49.3555, 242.4042, -8.7602>, <0.4291, 0.5298, -0.7315> }
    smooth_triangle { <49.3555, 242.4042, -8.7602>, <0.4291, 0.5298, -0.7315>, <44.0907, 244.0020, -10.9593>, <0.4354, 0.5262, -0.7304>, <42.3322, 248.9394, -4.1635>, <0.4123, 0.8772, -0.2461> }
    smooth_triangle { <44.0907, 244.0020, -10.9593>, <0.4354, 0.5262, -0.7304>, <49.3555, 242.4042, -8.7602>, <0.4291, 0.5298, -0.7315>, <48.4732, 236.0130, -10.8368>, <0.4127, -0.0020, -0.9109> }
    smooth_triangle { <48.4732, 236.0130, -10.8368>, <0.4127, -0.0020, -0.9109>, <42.0536, 236.0130, -13.5551>, <0.4130, -0.0015, -0.9107>, <44.0907, 244.0020, -10.9593>, <0.4354, 0.5262, -0.7304> }
    smooth_triangle { <42.0536, 236.0130, -13.5551>, <0.4130, -0.0015, -0.9107>, <48.4732, 236.0130, -10.8368>, <0.4127, -0.0020, -0.9109>, <49.2824, 229.6218, -8.7602>, <0.4294, -0.5343, -0.7281> }
    smooth_triangle { <49.2824, 229.6218, -8.7602>, <0.4294, -0.5343, -0.7281>, <44.0416, 228.0240, -10.9593>, <0.4362, -0.5303, -0.7270>, <42.0536, 236.0130, -13.5551>, <0.4130, -0.0015, -0.9107> }
    smooth_triangle { <44.0416, 228.0240, -10.9593>, <0.4362, -0.5303, -0.7270>, <49.2824, 229.6218, -8.7602>, <0.4294, -0.5343, -0.7281>, <48.2895, 225.6718, -3.3235>, <0.4093, -0.8773, -0.2507> }
    smooth_triangle { <48.2895, 225.6718, -3.3235>, <0.4093, -0.8773, -0.2507>, <42.1237, 223.0865, -4.1635>, <0.4114, -0.8786, -0.2425>, <44.0416, 228.0240, -10.9593>, <0.4362, -0.5303, -0.7270> }
    smooth_triangle { <42.1237, 223.0865, -4.1635>, <0.4114, -0.8786, -0.2425>, <48.2895, 225.6718, -3.3235>, <0.4093, -0.8773, -0.2507>, <48.3116, 225.6718, 3.3966>, <0.4088, -0.8786, 0.2470> }
    smooth_triangle { <48.3116, 225.6718, 3.3966>, <0.4088, -0.8786, 0.2470>, <42.1242, 223.0865, 4.2366>, <0.4106, -0.8798, 0.2395>, <42.1237, 223.0865, -4.1635>, <0.4114, -0.8786, -0.2425> }
    smooth_triangle { <42.1242, 223.0865, 4.2366>, <0.4106, -0.8798, 0.2395>, <48.3116, 225.6718, 3.3966>, <0.4088, -0.8786, 0.2470>, <49.4021, 229.6218, 8.8333>, <0.4297, -0.5384, 0.7249> }
    smooth_triangle { <49.4021, 229.6218, 8.8333>, <0.4297, -0.5384, 0.7249>, <44.1526, 228.0240, 11.0325>, <0.4360, -0.5345, 0.7240>, <42.1242, 223.0865, 4.2366>, <0.4106, -0.8798, 0.2395> }
    smooth_triangle { <44.1526, 228.0240, 11.0325>, <0.4360, -0.5345, 0.7240>, <49.4021, 229.6218, 8.8333>, <0.4297, -0.5384, 0.7249>, <48.6693, 236.0130, 10.9099>, <0.4141, -0.0021, 0.9102> }
    smooth_triangle { <48.6693, 236.0130, 10.9099>, <0.4141, -0.0021, 0.9102>, <42.2755, 236.0130, 13.6283>, <0.4141, -0.0016, 0.9103>, <44.1526, 228.0240, 11.0325>, <0.4360, -0.5345, 0.7240> }
    smooth_triangle { <48.6693, 236.0130, 10.9099>, <0.4141, -0.0021, 0.9102>, <54.8619, 236.0130, 8.1916>, <0.4229, -0.0031, 0.9062>, <55.0995, 240.8064, 6.6341>, <0.4292, 0.5365, 0.7266> }
    smooth_triangle { <55.0995, 240.8064, 6.6341>, <0.4292, 0.5365, 0.7266>, <49.4771, 242.4042, 8.8333>, <0.4295, 0.5339, 0.7284>, <48.6693, 236.0130, 10.9099>, <0.4141, -0.0021, 0.9102> }
    smooth_triangle { <49.4771, 242.4042, 8.8333>, <0.4295, 0.5339, 0.7284>, <55.0995, 240.8064, 6.6341>, <0.4292, 0.5365, 0.7266>, <54.6657, 243.7688, 2.5566>, <0.4167, 0.8708, 0.2608> }
    smooth_triangle { <54.6657, 243.7688, 2.5566>, <0.4167, 0.8708, 0.2608>, <48.5041, 246.3541, 3.3966>, <0.4100, 0.8771, 0.2502>, <49.4771, 242.4042, 8.8333>, <0.4295, 0.5339, 0.7284> }
    smooth_triangle { <48.5041, 246.3541, 3.3966>, <0.4100, 0.8771, 0.2502>, <54.6657, 243.7688, 2.5566>, <0.4167, 0.8708, 0.2608>, <54.6331, 243.7688, -2.4835>, <0.4167, 0.8692, -0.2662> }
    smooth_triangle { <54.6331, 243.7688, -2.4835>, <0.4167, 0.8692, -0.2662>, <48.4809, 246.3541, -3.3235>, <0.4105, 0.8757, -0.2541>, <48.5041, 246.3541, 3.3966>, <0.4100, 0.8771, 0.2502> }
    smooth_triangle { <48.4809, 246.3541, -3.3235>, <0.4105, 0.8757, -0.2541>, <54.6331, 243.7688, -2.4835>, <0.4167, 0.8692, -0.2662>, <54.9862, 240.8064, -6.5610>, <0.4280, 0.5327, -0.7301> }
    smooth_triangle { <54.9862, 240.8064, -6.5610>, <0.4280, 0.5327, -0.7301>, <49.3555, 242.4042, -8.7602>, <0.4291, 0.5298, -0.7315>, <48.4809, 246.3541, -3.3235>, <0.4105, 0.8757, -0.2541> }
    smooth_triangle { <49.3555, 242.4042, -8.7602>, <0.4291, 0.5298, -0.7315>, <54.9862, 240.8064, -6.5610>, <0.4280, 0.5327, -0.7301>, <54.7009, 236.0130, -8.1185>, <0.4207, -0.0031, -0.9072> }
    smooth_triangle { <54.7009, 236.0130, -8.1185>, <0.4207, -0.0031, -0.9072>, <48.4732, 236.0130, -10.8368>, <0.4127, -0.0020, -0.9109>, <49.3555, 242.4042, -8.7602>, <0.4291, 0.5298, -0.7315> }
    smooth_triangle { <48.4732, 236.0130, -10.8368>, <0.4127, -0.0020, -0.9109>, <54.7009, 236.0130, -8.1185>, <0.4207, -0.0031, -0.9072>, <54.9072, 231.2195, -6.5610>, <0.4273, -0.5380, -0.7266> }
    smooth_triangle { <54.9072, 231.2195, -6.5610>, <0.4273, -0.5380, -0.7266>, <49.2824, 229.6218, -8.7602>, <0.4294, -0.5343, -0.7281>, <48.4732, 236.0130, -10.8368>, <0.4127, -0.0020, -0.9109> }
    smooth_triangle { <49.2824, 229.6218, -8.7602>, <0.4294, -0.5343, -0.7281>, <54.9072, 231.2195, -6.5610>, <0.4273, -0.5380, -0.7266>, <54.4714, 228.2571, -2.4835>, <0.4146, -0.8711, -0.2632> }
    smooth_triangle { <54.4714, 228.2571, -2.4835>, <0.4146, -0.8711, -0.2632>, <48.2895, 225.6718, -3.3235>, <0.4093, -0.8773, -0.2507>, <49.2824, 229.6218, -8.7602>, <0.4294, -0.5343, -0.7281> }
    smooth_triangle { <48.2895, 225.6718, -3.3235>, <0.4093, -0.8773, -0.2507>, <54.4714, 228.2571, -2.4835>, <0.4146, -0.8711, -0.2632>, <54.5033, 228.2571, 2.5566>, <0.4147, -0.8727, 0.2579> }
    smooth_triangle { <54.5033, 228.2571, 2.5566>, <0.4147, -0.8727, 0.2579>, <48.3116, 225.6718, 3.3966>, <0.4088, -0.8786, 0.2470>, <48.2895, 225.6718, -3.3235>, <0.4093, -0.8773, -0.2507> }
    smooth_triangle { <48.3116, 225.6718, 3.3966>, <0.4088, -0.8786, 0.2470>, <54.5033, 228.2571, 2.5566>, <0.4147, -0.8727, 0.2579>, <55.0194, 231.2195, 6.6341>, <0.4285, -0.5419, 0.7230> }
    smooth_triangle { <55.0194, 231.2195, 6.6341>, <0.4285, -0.5419, 0.7230>, <49.4021, 229.6218, 8.8333>, <0.4297, -0.5384, 0.7249>, <48.3116, 225.6718, 3.3966>, <0.4088, -0.8786, 0.2470> }
    smooth_triangle { <49.4021, 229.6218, 8.8333>, <0.4297, -0.5384, 0.7249>, <55.0194, 231.2195, 6.6341>, <0.4285, -0.5419, 0.7230>, <54.8619, 236.0130, 8.1916>, <0.4229, -0.0031, 0.9062> }
    smooth_triangle { <54.8619, 236.0130, 8.1916>, <0.4229, -0.0031, 0.9062>, <48.6693, 236.0130, 10.9099>, <0.4141, -0.0021, 0.9102>, <49.4021, 229.6218, 8.8333>, <0.4297, -0.5384, 0.7249> }
    smooth_triangle { <54.8619, 236.0130, 8.1916>, <0.4229, -0.0031, 0.9062>, <60.6220, 236.0130, 5.4732>, <0.4517, -0.0042, 0.8922>, <60.6537, 239.2086, 4.4349>, <0.4532, 0.5300, 0.7167> }
    smooth_triangle { <60.6537, 239.2086, 4.4349>, <0.4532, 0.5300, 0.7167>, <55.0995, 240.8064, 6.6341>, <0.4292, 0.5365, 0.7266>, <54.8619, 236.0130, 8.1916>, <0.4229, -0.0031, 0.9062> }
    smooth_triangle { <55.0995, 240.8064, 6.6341>, <0.4292, 0.5365, 0.7266>, <60.6537, 239.2086, 4.4349>, <0.4532, 0.5300, 0.7167>, <60.4996, 241.1836, 1.7166>, <0.4453, 0.8557, 0.2637> }
    smooth_triangle { <60.4996, 241.1836, 1.7166>, <0.4453, 0.8557, 0.2637>, <54.6657, 243.7688, 2.5566>, <0.4167, 0.8708, 0.2608>, <55.0995, 240.8064, 6.6341>, <0.4292, 0.5365, 0.7266> }
    smooth_triangle { <54.6657, 243.7688, 2.5566>, <0.4167, 0.8708, 0.2608>, <60.4996, 241.1836, 1.7166>, <0.4453, 0.8557, 0.2637>, <60.4690, 241.1836, -1.6435>, <0.4446, 0.8538, -0.2709> }
    smooth_triangle { <60.4690, 241.1836, -1.6435>, <0.4446, 0.8538, -0.2709>, <54.6331, 243.7688, -2.4835>, <0.4167, 0.8692, -0.2662>, <54.6657, 243.7688, 2.5566>, <0.4167, 0.8708, 0.2608> }
    smooth_triangle { <54.6331, 243.7688, -2.4835>, <0.4167, 0.8692, -0.2662>, <60.4690, 241.1836, -1.6435>, <0.4446, 0.8538, -0.2709>, <60.5647, 239.2086, -4.3618>, <0.4509, 0.5262, -0.7210> }
    smooth_triangle { <60.5647, 239.2086, -4.3618>, <0.4509, 0.5262, -0.7210>, <54.9862, 240.8064, -6.5610>, <0.4280, 0.5327, -0.7301>, <54.6331, 243.7688, -2.4835>, <0.4167, 0.8692, -0.2662> }
    smooth_triangle { <54.9862, 240.8064, -6.5610>, <0.4280, 0.5327, -0.7301>, <60.5647, 239.2086, -4.3618>, <0.4509, 0.5262, -0.7210>, <60.5053, 236.0130, -5.4001>, <0.4485, -0.0042, -0.8938> }
    smooth_triangle { <60.5053, 236.0130, -5.4001>, <0.4485, -0.0042, -0.8938>, <54.7009, 236.0130, -8.1185>, <0.4207, -0.0031, -0.9072>, <54.9862, 240.8064, -6.5610>, <0.4280, 0.5327, -0.7301> }
    smooth_triangle { <54.7009, 236.0130, -8.1185>, <0.4207, -0.0031, -0.9072>, <60.5053, 236.0130, -5.4001>, <0.4485, -0.0042, -0.8938>, <60.4976, 232.8174, -4.3618>, <0.4493, -0.5327, -0.7171> }
    smooth_triangle { <60.4976, 232.8174, -4.3618>, <0.4493, -0.5327, -0.7171>, <54.9072, 231.2195, -6.5610>, <0.4273, -0.5380, -0.7266>, <54.7009, 236.0130, -8.1185>, <0.4207, -0.0031, -0.9072> }
    smooth_triangle { <54.9072, 231.2195, -6.5610>, <0.4273, -0.5380, -0.7266>, <60.4976, 232.8174, -4.3618>, <0.4493, -0.5327, -0.7171>, <60.3494, 230.8424, -1.6435>, <0.4415, -0.8563, -0.2681> }
    smooth_triangle { <60.3494, 230.8424, -1.6435>, <0.4415, -0.8563, -0.2681>, <54.4714, 228.2571, -2.4835>, <0.4146, -0.8711, -0.2632>, <54.9072, 231.2195, -6.5610>, <0.4273, -0.5380, -0.7266> }
    smooth_triangle { <54.4714, 228.2571, -2.4835>, <0.4146, -0.8711, -0.2632>, <60.3494, 230.8424, -1.6435>, <0.4415, -0.8563, -0.2681>, <60.3796, 230.8424, 1.7166>, <0.4421, -0.8582, 0.2610> }
    smooth_triangle { <60.3796, 230.8424, 1.7166>, <0.4421, -0.8582, 0.2610>, <54.5033, 228.2571, 2.5566>, <0.4147, -0.8727, 0.2579>, <54.4714, 228.2571, -2.4835>, <0.4146, -0.8711, -0.2632> }
    smooth_triangle { <54.5033, 228.2571, 2.5566>, <0.4147, -0.8727, 0.2579>, <60.3796, 230.8424, 1.7166>, <0.4421, -0.8582, 0.2610>, <60.5861, 232.8174, 4.4349>, <0.4515, -0.5366, 0.7129> }
    smooth_triangle { <60.5861, 232.8174, 4.4349>, <0.4515, -0.5366, 0.7129>, <55.0194, 231.2195, 6.6341>, <0.4285, -0.5419, 0.7230>, <54.5033, 228.2571, 2.5566>, <0.4147, -0.8727, 0.2579> }
    smooth_triangle { <55.0194, 231.2195, 6.6341>, <0.4285, -0.5419, 0.7230>, <60.5861, 232.8174, 4.4349>, <0.4515, -0.5366, 0.7129>, <60.6220, 236.0130, 5.4732>, <0.4517, -0.0042, 0.8922> }
    smooth_triangle { <60.6220, 236.0130, 5.4732>, <0.4517, -0.0042, 0.8922>, <54.8619, 236.0130, 8.1916>, <0.4229, -0.0031, 0.9062>, <55.0194, 231.2195, 6.6341>, <0.4285, -0.5419, 0.7230> }
    smooth_triangle { <60.6220, 236.0130, 5.4732>, <0.4517, -0.0042, 0.8922>, <65.7175, 236.0130, 2.7549>, <0.5080, -0.0055, 0.8613>, <65.7187, 237.6108, 2.2357>, <0.5081, 0.5112, 0.6932> }
    smooth_triangle { <65.7187, 237.6108, 2.2357>, <0.5081, 0.5112, 0.6932>, <60.6537, 239.2086, 4.4349>, <0.4532, 0.5300, 0.7167>, <60.6220, 236.0130, 5.4732>, <0.4517, -0.0042, 0.8922> }
    smooth_triangle { <60.6537, 239.2086, 4.4349>, <0.4532, 0.5300, 0.7167>, <65.7187, 237.6108, 2.2357>, <0.5081, 0.5112, 0.6932>, <65.6846, 238.5983, 0.8766>, <0.5035, 0.8246, 0.2579> }
    smooth_triangle { <65.6846, 238.5983, 0.8766>, <0.5035, 0.8246, 0.2579>, <60.4996, 241.1836, 1.7166>, <0.4453, 0.8557, 0.2637>, <60.6537, 239.2086, 4.4349>, <0.4532, 0.5300, 0.7167> }
    smooth_triangle { <60.4996, 241.1836, 1.7166>, <0.4453, 0.8557, 0.2637>, <65.6846, 238.5983, 0.8766>, <0.5035, 0.8246, 0.2579>, <65.6659, 238.5983, -0.8035>, <0.5022, 0.8224, -0.2673> }
    smooth_triangle { <65.6659, 238.5983, -0.8035>, <0.5022, 0.8224, -0.2673>, <60.4690, 241.1836, -1.6435>, <0.4446, 0.8538, -0.2709>, <60.4996, 241.1836, 1.7166>, <0.4453, 0.8557, 0.2637> }
    smooth_triangle { <60.4690, 241.1836, -1.6435>, <0.4446, 0.8538, -0.2709>, <65.6659, 238.5983, -0.8035>, <0.5022, 0.8224, -0.2673>, <65.6684, 237.6108, -2.1626>, <0.5044, 0.5073, -0.6987> }
    smooth_triangle { <65.6684, 237.6108, -2.1626>, <0.5044, 0.5073, -0.6987>, <60.5647, 239.2086, -4.3618>, <0.4509, 0.5262, -0.7210>, <60.4690, 241.1836, -1.6435>, <0.4446, 0.8538, -0.2709> }
    smooth_triangle { <60.5647, 239.2086, -4.3618>, <0.4509, 0.5262, -0.7210>, <65.6684, 237.6108, -2.1626>, <0.5044, 0.5073, -0.6987>, <65.6546, 236.0130, -2.6818>, <0.5032, -0.0055, -0.8641> }
    smooth_triangle { <65.6546, 236.0130, -2.6818>, <0.5032, -0.0055, -0.8641>, <60.5053, 236.0130, -5.4001>, <0.4485, -0.0042, -0.8938>, <60.5647, 239.2086, -4.3618>, <0.4509, 0.5262, -0.7210> }
    smooth_triangle { <60.5053, 236.0130, -5.4001>, <0.4485, -0.0042, -0.8938>, <65.6546, 236.0130, -2.6818>, <0.5032, -0.0055, -0.8641>, <65.6290, 234.4152, -2.1626>, <0.5015, -0.5157, -0.6946> }
    smooth_triangle { <65.6290, 234.4152, -2.1626>, <0.5015, -0.5157, -0.6946>, <60.4976, 232.8174, -4.3618>, <0.4493, -0.5327, -0.7171>, <60.5053, 236.0130, -5.4001>, <0.4485, -0.0042, -0.8938> }
    smooth_triangle { <60.4976, 232.8174, -4.3618>, <0.4493, -0.5327, -0.7171>, <65.6290, 234.4152, -2.1626>, <0.5015, -0.5157, -0.6946>, <65.6005, 233.4276, -0.8035>, <0.4973, -0.8262, -0.2646> }
    smooth_triangle { <65.6005, 233.4276, -0.8035>, <0.4973, -0.8262, -0.2646>, <60.3494, 230.8424, -1.6435>, <0.4415, -0.8563, -0.2681>, <60.4976, 232.8174, -4.3618>, <0.4493, -0.5327, -0.7171> }
    smooth_triangle { <60.3494, 230.8424, -1.6435>, <0.4415, -0.8563, -0.2681>, <65.6005, 233.4276, -0.8035>, <0.4973, -0.8262, -0.2646>, <65.6192, 233.4277, 0.8766>, <0.4986, -0.8284, 0.2552> }
    smooth_triangle { <65.6192, 233.4277, 0.8766>, <0.4986, -0.8284, 0.2552>, <60.3796, 230.8424, 1.7166>, <0.4421, -0.8582, 0.2610>, <60.3494, 230.8424, -1.6435>, <0.4415, -0.8563, -0.2681> }
    smooth_triangle { <60.3796, 230.8424, 1.7166>, <0.4421, -0.8582, 0.2610>, <65.6192, 233.4277, 0.8766>, <0.4986, -0.8284, 0.2552>, <65.6792, 234.4152, 2.2357>, <0.5051, -0.5197, 0.6890> }
    smooth_triangle { <65.6792, 234.4152, 2.2357>, <0.5051, -0.5197, 0.6890>, <60.5861, 232.8174, 4.4349>, <0.4515, -0.5366, 0.7129>, <60.3796, 230.8424, 1.7166>, <0.4421, -0.8582, 0.2610> }
    smooth_triangle { <60.5861, 232.8174, 4.4349>, <0.4515, -0.5366, 0.7129>, <65.6792, 234.4152, 2.2357>, <0.5051, -0.5197, 0.6890>, <65.7175, 236.0130, 2.7549>, <0.5080, -0.0055, 0.8613> }
    smooth_triangle { <65.7175, 236.0130, 2.7549>, <0.5080, -0.0055, 0.8613>, <60.6220, 236.0130, 5.4732>, <0.4517, -0.0042, 0.8922>, <60.5861, 232.8174, 4.4349>, <0.4515, -0.5366, 0.7129> }
    smooth_triangle { <65.7175, 236.0130, 2.7549>, <0.5080, -0.0055, 0.8613>, <69.9156, 236.0130, 0.0366>, <0.9999, -0.0079, -0.0073>, <65.7187, 237.6108, 2.2357>, <0.5081, 0.5112, 0.6932> }
    smooth_triangle { <65.7187, 237.6108, 2.2357>, <0.5081, 0.5112, 0.6932>, <69.9156, 236.0130, 0.0366>, <0.9999, -0.0079, -0.0073>, <65.6846, 238.5983, 0.8766>, <0.5035, 0.8246, 0.2579> }
    smooth_triangle { <65.6846, 238.5983, 0.8766>, <0.5035, 0.8246, 0.2579>, <69.9156, 236.0130, 0.0366>, <0.9999, -0.0079, -0.0073>, <65.6659, 238.5983, -0.8035>, <0.5022, 0.8224, -0.2673> }
    smooth_triangle { <65.6659, 238.5983, -0.8035>, <0.5022, 0.8224, -0.2673>, <69.9156, 236.0130, 0.0366>, <0.9999, -0.0079, -0.0073>, <65.6684, 237.6108, -2.1626>, <0.5044, 0.5073, -0.6987> }
    smooth_triangle { <65.6684, 237.6108, -2.1626>, <0.5044, 0.5073, -0.6987>, <69.9156, 236.0130, 0.0366>, <0.9999, -0.0079, -0.0073>, <65.6546, 236.0130, -2.6818>, <0.5032, -0.0055, -0.8641> }
    smooth_triangle { <65.6546, 236.0130, -2.6818>, <0.5032, -0.0055, -0.8641>, <69.9156, 236.0130, 0.0366>, <0.9999, -0.0079, -0.0073>, <65.6290, 234.4152, -2.1626>, <0.5015, -0.5157, -0.6946> }
    smooth_triangle { <65.6290, 234.4152, -2.1626>, <0.5015, -0.5157, -0.6946>, <69.9156, 236.0130, 0.0366>, <0.9999, -0.0079, -0.0073>, <65.6005, 233.4276, -0.8035>, <0.4973, -0.8262, -0.2646> }
    smooth_triangle { <65.6005, 233.4276, -0.8035>, <0.4973, -0.8262, -0.2646>, <69.9156, 236.0130, 0.0366>, <0.9999, -0.0079, -0.0073>, <65.6192, 233.4277, 0.8766>, <0.4986, -0.8284, 0.2552> }
    smooth_triangle { <65.6192, 233.4277, 0.8766>, <0.4986, -0.8284, 0.2552>, <69.9156, 236.0130, 0.0366>, <0.9999, -0.0079, -0.0073>, <65.6792, 234.4152, 2.2357>, <0.5051, -0.5197, 0.6890> }
    smooth_triangle { <65.6792, 234.4152, 2.2357>, <0.5051, -0.5197, 0.6890>, <69.9156, 236.0130, 0.0366>, <0.9999, -0.0079, -0.0073>, <65.7175, 236.0130, 2.7549>, <0.5080, -0.0055, 0.8613> }
    smooth_triangle { <42.3322, 248.9394, -4.1635>, <-0.9911, -0.0396, -0.1273>, <44.0416, 228.0240, -10.9593>, <-0.9971, 0.0593, 0.0471>, <42.3345, 248.9394, 4.2366>, <-0.9859, 0.0808, 0.1468> }
    smooth_triangle { <44.0416, 228.0240, -10.9593>, <-0.9971, 0.0593, 0.0471>, <44.0907, 244.0020, -10.9593>, <-0.9796, 0.0030, 0.2007>, <42.0536, 236.0130, -13.5551>, <-0.7903, 0.0024, 0.6127> }
    smooth_triangle { <44.0907, 244.0020, -10.9593>, <-0.9796, 0.0030, 0.2007>, <44.0416, 228.0240, -10.9593>, <-0.9971, 0.0593, 0.0471>, <42.3322, 248.9394, -4.1635>, <-0.9911, -0.0396, -0.1273> }
    smooth_triangle { <44.0416, 228.0240, -10.9593>, <-0.9971, 0.0593, 0.0471>, <42.1237, 223.0865, -4.1635>, <-0.9321, 0.3621, 0.0001>, <42.1242, 223.0865, 4.2366>, <-0.9297, 0.3683, 0.0024> }
    smooth_triangle { <44.1526, 228.0240, 11.0325>, <-0.9971, 0.0757, 0.0050>, <42.2755, 236.0130, 13.6283>, <-0.9883, 0.0288, 0.1501>, <44.0416, 228.0240, -10.9593>, <-0.9971, 0.0593, 0.0471> }
    smooth_triangle { <42.3345, 248.9394, 4.2366>, <-0.9859, 0.0808, 0.1468>, <42.2755, 236.0130, 13.6283>, <-0.9883, 0.0288, 0.1501>, <44.2044, 244.0019, 11.0325>, <-0.8070, 0.3495, 0.4760> }
    smooth_triangle { <42.3345, 248.9394, 4.2366>, <-0.9859, 0.0808, 0.1468>, <44.0416, 228.0240, -10.9593>, <-0.9971, 0.0593, 0.0471>, <42.2755, 236.0130, 13.6283>, <-0.9883, 0.0288, 0.1501> }
    smooth_triangle { <44.0416, 228.0240, -10.9593>, <-0.9971, 0.0593, 0.0471>, <42.1242, 223.0865, 4.2366>, <-0.9297, 0.3683, 0.0024>, <44.1526, 228.0240, 11.0325>, <-0.9971, 0.0757, 0.0050> }
    texture {
     Brushed_Aluminum
    }
  }

  mesh { // Surf2 
    smooth_triangle { <94.3809, 249.6046, 0.0366>, <0.0133, 0.9999, -0.0000>, <94.3809, 249.6046, 0.0366>, <0.0133, 0.9999, -0.0000>, <100.0866, 248.2587, 0.0366>, <0.4314, 0.9022, -0.0000> }
    smooth_triangle { <100.0866, 248.2587, 0.0366>, <0.4314, 0.9022, -0.0000>, <99.4796, 248.2586, -2.5221>, <0.3870, 0.9013, -0.1947>, <94.3809, 249.6046, 0.0366>, <0.0133, 0.9999, -0.0000> }
    smooth_triangle { <99.4796, 248.2586, -2.5221>, <0.3870, 0.9013, -0.1947>, <100.0866, 248.2587, 0.0366>, <0.4314, 0.9022, -0.0000>, <104.9279, 244.4872, 0.0366>, <0.7730, 0.6344, -0.0000> }
    smooth_triangle { <104.9279, 244.4872, 0.0366>, <0.7730, 0.6344, -0.0000>, <103.8185, 244.4872, -4.5741>, <0.6920, 0.6329, -0.3471>, <99.4796, 248.2586, -2.5221>, <0.3870, 0.9013, -0.1947> }
    smooth_triangle { <103.8185, 244.4872, -4.5741>, <0.6920, 0.6329, -0.3471>, <104.9279, 244.4872, 0.0366>, <0.7730, 0.6344, -0.0000>, <107.6317, 239.0374, 0.0366>, <0.9731, 0.2302, -0.0000> }
    smooth_triangle { <107.6317, 239.0374, 0.0366>, <0.9731, 0.2302, -0.0000>, <106.2948, 239.0374, -5.7128>, <0.8714, 0.2304, -0.4332>, <103.8185, 244.4872, -4.5741>, <0.6920, 0.6329, -0.3471> }
    smooth_triangle { <106.2948, 239.0374, -5.7128>, <0.8714, 0.2304, -0.4332>, <107.6317, 239.0374, 0.0366>, <0.9731, 0.2302, -0.0000>, <107.6318, 232.9885, 0.0366>, <0.9731, -0.2302, -0.0000> }
    smooth_triangle { <107.6318, 232.9885, 0.0366>, <0.9731, -0.2302, -0.0000>, <106.2948, 232.9885, -5.7128>, <0.8714, -0.2304, -0.4332>, <106.2948, 239.0374, -5.7128>, <0.8714, 0.2304, -0.4332> }
    smooth_triangle { <106.2948, 232.9885, -5.7128>, <0.8714, -0.2304, -0.4332>, <107.6318, 232.9885, 0.0366>, <0.9731, -0.2302, -0.0000>, <104.9279, 227.5387, 0.0366>, <0.7730, -0.6344, 0.0000> }
    smooth_triangle { <104.9279, 227.5387, 0.0366>, <0.7730, -0.6344, 0.0000>, <103.8185, 227.5387, -4.5741>, <0.6920, -0.6329, -0.3471>, <106.2948, 232.9885, -5.7128>, <0.8714, -0.2304, -0.4332> }
    smooth_triangle { <103.8185, 227.5387, -4.5741>, <0.6920, -0.6329, -0.3471>, <104.9279, 227.5387, 0.0366>, <0.7730, -0.6344, 0.0000>, <100.0866, 223.7673, 0.0366>, <0.4314, -0.9022, 0.0000> }
    smooth_triangle { <100.0866, 223.7673, 0.0366>, <0.4314, -0.9022, 0.0000>, <99.4796, 223.7673, -2.5221>, <0.3870, -0.9013, -0.1947>, <103.8185, 227.5387, -4.5741>, <0.6920, -0.6329, -0.3471> }
    smooth_triangle { <99.4796, 223.7673, -2.5221>, <0.3870, -0.9013, -0.1947>, <100.0866, 223.7673, 0.0366>, <0.4314, -0.9022, 0.0000>, <94.3809, 222.4213, 0.0366>, <0.0133, -0.9999, 0.0000> }
    smooth_triangle { <94.3809, 222.4213, 0.0366>, <0.0133, -0.9999, 0.0000>, <94.3809, 222.4213, 0.0366>, <0.0133, -0.9999, 0.0000>, <99.4796, 223.7673, -2.5221>, <0.3870, -0.9013, -0.1947> }
    smooth_triangle { <94.3809, 249.6046, 0.0366>, <0.0133, 0.9999, -0.0000>, <94.3809, 249.6046, 0.0366>, <0.0133, 0.9999, -0.0000>, <99.4796, 248.2586, -2.5221>, <0.3870, 0.9013, -0.1947> }
    smooth_triangle { <99.4796, 248.2586, -2.5221>, <0.3870, 0.9013, -0.1947>, <97.7739, 248.2586, -4.5741>, <0.2647, 0.8999, -0.3466>, <94.3809, 249.6046, 0.0366>, <0.0133, 0.9999, -0.0000> }
    smooth_triangle { <97.7739, 248.2586, -4.5741>, <0.2647, 0.8999, -0.3466>, <99.4796, 248.2586, -2.5221>, <0.3870, 0.9013, -0.1947>, <103.8185, 244.4872, -4.5741>, <0.6920, 0.6329, -0.3471> }
    smooth_triangle { <103.8185, 244.4872, -4.5741>, <0.6920, 0.6329, -0.3471>, <100.7076, 244.4872, -8.2715>, <0.4744, 0.6306, -0.6142>, <97.7739, 248.2586, -4.5741>, <0.2647, 0.8999, -0.3466> }
    smooth_triangle { <100.7076, 244.4872, -8.2715>, <0.4744, 0.6306, -0.6142>, <103.8185, 244.4872, -4.5741>, <0.6920, 0.6329, -0.3471>, <106.2948, 239.0374, -5.7128>, <0.8714, 0.2304, -0.4332> }
    smooth_triangle { <106.2948, 239.0374, -5.7128>, <0.8714, 0.2304, -0.4332>, <102.4834, 239.0374, -10.3234>, <0.6015, 0.2311, -0.7647>, <100.7076, 244.4872, -8.2715>, <0.4744, 0.6306, -0.6142> }
    smooth_triangle { <102.4834, 239.0374, -10.3234>, <0.6015, 0.2311, -0.7647>, <106.2948, 239.0374, -5.7128>, <0.8714, 0.2304, -0.4332>, <106.2948, 232.9885, -5.7128>, <0.8714, -0.2304, -0.4332> }
    smooth_triangle { <106.2948, 232.9885, -5.7128>, <0.8714, -0.2304, -0.4332>, <102.4834, 232.9885, -10.3234>, <0.6015, -0.2311, -0.7647>, <102.4834, 239.0374, -10.3234>, <0.6015, 0.2311, -0.7647> }
    smooth_triangle { <102.4834, 232.9885, -10.3234>, <0.6015, -0.2311, -0.7647>, <106.2948, 232.9885, -5.7128>, <0.8714, -0.2304, -0.4332>, <103.8185, 227.5387, -4.5741>, <0.6920, -0.6329, -0.3471> }
    smooth_triangle { <103.8185, 227.5387, -4.5741>, <0.6920, -0.6329, -0.3471>, <100.7076, 227.5387, -8.2715>, <0.4744, -0.6306, -0.6142>, <102.4834, 232.9885, -10.3234>, <0.6015, -0.2311, -0.7647> }
    smooth_triangle { <100.7076, 227.5387, -8.2715>, <0.4744, -0.6306, -0.6142>, <103.8185, 227.5387, -4.5741>, <0.6920, -0.6329, -0.3471>, <99.4796, 223.7673, -2.5221>, <0.3870, -0.9013, -0.1947> }
    smooth_triangle { <99.4796, 223.7673, -2.5221>, <0.3870, -0.9013, -0.1947>, <97.7739, 223.7673, -4.5741>, <0.2647, -0.8999, -0.3466>, <100.7076, 227.5387, -8.2715>, <0.4744, -0.6306, -0.6142> }
    smooth_triangle { <97.7739, 223.7673, -4.5741>, <0.2647, -0.8999, -0.3466>, <99.4796, 223.7673, -2.5221>, <0.3870, -0.9013, -0.1947>, <94.3809, 222.4213, 0.0366>, <0.0133, -0.9999, 0.0000> }
    smooth_triangle { <94.3809, 222.4213, 0.0366>, <0.0133, -0.9999, 0.0000>, <94.3809, 222.4213, 0.0366>, <0.0133, -0.9999, 0.0000>, <97.7739, 223.7673, -4.5741>, <0.2647, -0.8999, -0.3466> }
    smooth_triangle { <94.3809, 249.6046, 0.0366>, <0.0133, 0.9999, -0.0000>, <94.3809, 249.6046, 0.0366>, <0.0133, 0.9999, -0.0000>, <97.7739, 248.2586, -4.5741>, <0.2647, 0.8999, -0.3466> }
    smooth_triangle { <97.7739, 248.2586, -4.5741>, <0.2647, 0.8999, -0.3466>, <95.2867, 248.2586, -5.7128>, <0.0934, 0.9002, -0.4253>, <94.3809, 249.6046, 0.0366>, <0.0133, 0.9999, -0.0000> }
    smooth_triangle { <95.2867, 248.2586, -5.7128>, <0.0934, 0.9002, -0.4253>, <97.7739, 248.2586, -4.5741>, <0.2647, 0.8999, -0.3466>, <100.7076, 244.4872, -8.2715>, <0.4744, 0.6306, -0.6142> }
    smooth_triangle { <100.7076, 244.4872, -8.2715>, <0.4744, 0.6306, -0.6142>, <96.2546, 244.4872, -10.3234>, <0.1697, 0.6276, -0.7598>, <95.2867, 248.2586, -5.7128>, <0.0934, 0.9002, -0.4253> }
    smooth_triangle { <96.2546, 244.4872, -10.3234>, <0.1697, 0.6276, -0.7598>, <100.7076, 244.4872, -8.2715>, <0.4744, 0.6306, -0.6142>, <102.4834, 239.0374, -10.3234>, <0.6015, 0.2311, -0.7647> }
    smooth_triangle { <102.4834, 239.0374, -10.3234>, <0.6015, 0.2311, -0.7647>, <97.3294, 239.0374, -12.8821>, <0.2188, 0.2282, -0.9487>, <96.2546, 244.4872, -10.3234>, <0.1697, 0.6276, -0.7598> }
    smooth_triangle { <97.3294, 239.0374, -12.8821>, <0.2188, 0.2282, -0.9487>, <102.4834, 239.0374, -10.3234>, <0.6015, 0.2311, -0.7647>, <102.4834, 232.9885, -10.3234>, <0.6015, -0.2311, -0.7647> }
    smooth_triangle { <102.4834, 232.9885, -10.3234>, <0.6015, -0.2311, -0.7647>, <97.3294, 232.9885, -12.8821>, <0.2188, -0.2282, -0.9487>, <97.3294, 239.0374, -12.8821>, <0.2188, 0.2282, -0.9487> }
    smooth_triangle { <97.3294, 232.9885, -12.8821>, <0.2188, -0.2282, -0.9487>, <102.4834, 232.9885, -10.3234>, <0.6015, -0.2311, -0.7647>, <100.7076, 227.5387, -8.2715>, <0.4744, -0.6306, -0.6142> }
    smooth_triangle { <100.7076, 227.5387, -8.2715>, <0.4744, -0.6306, -0.6142>, <96.2546, 227.5387, -10.3234>, <0.1697, -0.6276, -0.7598>, <97.3294, 232.9885, -12.8821>, <0.2188, -0.2282, -0.9487> }
    smooth_triangle { <96.2546, 227.5387, -10.3234>, <0.1697, -0.6276, -0.7598>, <100.7076, 227.5387, -8.2715>, <0.4744, -0.6306, -0.6142>, <97.7739, 223.7673, -4.5741>, <0.2647, -0.8999, -0.3466> }
    smooth_triangle { <97.7739, 223.7673, -4.5741>, <0.2647, -0.8999, -0.3466>, <95.2867, 223.7673, -5.7128>, <0.0934, -0.9002, -0.4253>, <96.2546, 227.5387, -10.3234>, <0.1697, -0.6276, -0.7598> }
    smooth_triangle { <95.2867, 223.7673, -5.7128>, <0.0934, -0.9002, -0.4253>, <97.7739, 223.7673, -4.5741>, <0.2647, -0.8999, -0.3466>, <94.3809, 222.4213, 0.0366>, <0.0133, -0.9999, 0.0000> }
    smooth_triangle { <94.3809, 222.4213, 0.0366>, <0.0133, -0.9999, 0.0000>, <94.3809, 222.4213, 0.0366>, <0.0133, -0.9999, 0.0000>, <95.2867, 223.7673, -5.7128>, <0.0934, -0.9002, -0.4253> }
    smooth_triangle { <94.3809, 249.6046, 0.0366>, <0.0133, 0.9999, -0.0000>, <94.3809, 249.6046, 0.0366>, <0.0133, 0.9999, -0.0000>, <95.2867, 248.2586, -5.7128>, <0.0934, 0.9002, -0.4253> }
    smooth_triangle { <95.2867, 248.2586, -5.7128>, <0.0934, 0.9002, -0.4253>, <92.4618, 248.2587, -5.7128>, <-0.0754, 0.9052, -0.4183>, <94.3809, 249.6046, 0.0366>, <0.0133, 0.9999, -0.0000> }
    smooth_triangle { <92.4618, 248.2587, -5.7128>, <-0.0754, 0.9052, -0.4183>, <95.2867, 248.2586, -5.7128>, <0.0934, 0.9002, -0.4253>, <96.2546, 244.4872, -10.3234>, <0.1697, 0.6276, -0.7598> }
    smooth_triangle { <96.2546, 244.4872, -10.3234>, <0.1697, 0.6276, -0.7598>, <90.9969, 244.4872, -10.3234>, <-0.1258, 0.6234, -0.7717>, <92.4618, 248.2587, -5.7128>, <-0.0754, 0.9052, -0.4183> }
    smooth_triangle { <90.9969, 244.4872, -10.3234>, <-0.1258, 0.6234, -0.7717>, <96.2546, 244.4872, -10.3234>, <0.1697, 0.6276, -0.7598>, <97.3294, 239.0374, -12.8821>, <0.2188, 0.2282, -0.9487> }
    smooth_triangle { <97.3294, 239.0374, -12.8821>, <0.2188, 0.2282, -0.9487>, <91.4323, 239.0374, -12.8821>, <-0.1469, 0.2151, -0.9655>, <90.9969, 244.4872, -10.3234>, <-0.1258, 0.6234, -0.7717> }
    smooth_triangle { <91.4323, 239.0374, -12.8821>, <-0.1469, 0.2151, -0.9655>, <97.3294, 239.0374, -12.8821>, <0.2188, 0.2282, -0.9487>, <97.3294, 232.9885, -12.8821>, <0.2188, -0.2282, -0.9487> }
    smooth_triangle { <97.3294, 232.9885, -12.8821>, <0.2188, -0.2282, -0.9487>, <91.4323, 232.9885, -12.8821>, <-0.1469, -0.2151, -0.9655>, <91.4323, 239.0374, -12.8821>, <-0.1469, 0.2151, -0.9655> }
    smooth_triangle { <91.4323, 232.9885, -12.8821>, <-0.1469, -0.2151, -0.9655>, <97.3294, 232.9885, -12.8821>, <0.2188, -0.2282, -0.9487>, <96.2546, 227.5387, -10.3234>, <0.1697, -0.6276, -0.7598> }
    smooth_triangle { <96.2546, 227.5387, -10.3234>, <0.1697, -0.6276, -0.7598>, <90.9969, 227.5387, -10.3234>, <-0.1258, -0.6234, -0.7717>, <91.4323, 232.9885, -12.8821>, <-0.1469, -0.2151, -0.9655> }
    smooth_triangle { <90.9969, 227.5387, -10.3234>, <-0.1258, -0.6234, -0.7717>, <96.2546, 227.5387, -10.3234>, <0.1697, -0.6276, -0.7598>, <95.2867, 223.7673, -5.7128>, <0.0934, -0.9002, -0.4253> }
    smooth_triangle { <95.2867, 223.7673, -5.7128>, <0.0934, -0.9002, -0.4253>, <92.4617, 223.7673, -5.7128>, <-0.0754, -0.9052, -0.4183>, <90.9969, 227.5387, -10.3234>, <-0.1258, -0.6234, -0.7717> }
    smooth_triangle { <92.4617, 223.7673, -5.7128>, <-0.0754, -0.9052, -0.4183>, <95.2867, 223.7673, -5.7128>, <0.0934, -0.9002, -0.4253>, <94.3809, 222.4213, 0.0366>, <0.0133, -0.9999, 0.0000> }
    smooth_triangle { <94.3809, 222.4213, 0.0366>, <0.0133, -0.9999, 0.0000>, <94.3809, 222.4213, 0.0366>, <0.0133, -0.9999, 0.0000>, <92.4617, 223.7673, -5.7128>, <-0.0754, -0.9052, -0.4183> }
    smooth_triangle { <94.3809, 249.6046, 0.0366>, <0.0133, 0.9999, -0.0000>, <94.3809, 249.6046, 0.0366>, <0.0133, 0.9999, -0.0000>, <92.4618, 248.2587, -5.7128>, <-0.0754, 0.9052, -0.4183> }
    smooth_triangle { <92.4618, 248.2587, -5.7128>, <-0.0754, 0.9052, -0.4183>, <89.8071, 248.2586, -4.5741>, <-0.1896, 0.9225, -0.3361>, <94.3809, 249.6046, 0.0366>, <0.0133, 0.9999, -0.0000> }
    smooth_triangle { <89.8071, 248.2586, -4.5741>, <-0.1896, 0.9225, -0.3361>, <92.4618, 248.2587, -5.7128>, <-0.0754, 0.9052, -0.4183>, <90.9969, 244.4872, -10.3234>, <-0.1258, 0.6234, -0.7717> }
    smooth_triangle { <90.9969, 244.4872, -10.3234>, <-0.1258, 0.6234, -0.7717>, <84.9498, 244.4872, -8.2715>, <-0.2994, 0.6735, -0.6758>, <89.8071, 248.2586, -4.5741>, <-0.1896, 0.9225, -0.3361> }
    smooth_triangle { <84.9498, 244.4872, -8.2715>, <-0.2994, 0.6735, -0.6758>, <90.9969, 244.4872, -10.3234>, <-0.1258, 0.6234, -0.7717>, <91.4323, 239.0374, -12.8821>, <-0.1469, 0.2151, -0.9655> }
    smooth_triangle { <91.4323, 239.0374, -12.8821>, <-0.1469, 0.2151, -0.9655>, <83.0040, 239.0374, -10.3234>, <-0.3404, 0.2433, -0.9082>, <84.9498, 244.4872, -8.2715>, <-0.2994, 0.6735, -0.6758> }
    smooth_triangle { <83.0040, 239.0374, -10.3234>, <-0.3404, 0.2433, -0.9082>, <91.4323, 239.0374, -12.8821>, <-0.1469, 0.2151, -0.9655>, <91.4323, 232.9885, -12.8821>, <-0.1469, -0.2151, -0.9655> }
    smooth_triangle { <91.4323, 232.9885, -12.8821>, <-0.1469, -0.2151, -0.9655>, <83.0040, 232.9885, -10.3234>, <-0.3404, -0.2433, -0.9082>, <83.0040, 239.0374, -10.3234>, <-0.3404, 0.2433, -0.9082> }
    smooth_triangle { <83.0040, 232.9885, -10.3234>, <-0.3404, -0.2433, -0.9082>, <91.4323, 232.9885, -12.8821>, <-0.1469, -0.2151, -0.9655>, <90.9969, 227.5387, -10.3234>, <-0.1258, -0.6234, -0.7717> }
    smooth_triangle { <90.9969, 227.5387, -10.3234>, <-0.1258, -0.6234, -0.7717>, <84.9498, 227.5387, -8.2715>, <-0.2994, -0.6735, -0.6758>, <83.0040, 232.9885, -10.3234>, <-0.3404, -0.2433, -0.9082> }
    smooth_triangle { <84.9498, 227.5387, -8.2715>, <-0.2994, -0.6735, -0.6758>, <90.9969, 227.5387, -10.3234>, <-0.1258, -0.6234, -0.7717>, <92.4617, 223.7673, -5.7128>, <-0.0754, -0.9052, -0.4183> }
    smooth_triangle { <92.4617, 223.7673, -5.7128>, <-0.0754, -0.9052, -0.4183>, <89.8071, 223.7673, -4.5741>, <-0.1896, -0.9225, -0.3361>, <84.9498, 227.5387, -8.2715>, <-0.2994, -0.6735, -0.6758> }
    smooth_triangle { <89.8071, 223.7673, -4.5741>, <-0.1896, -0.9225, -0.3361>, <92.4617, 223.7673, -5.7128>, <-0.0754, -0.9052, -0.4183>, <94.3809, 222.4213, 0.0366>, <0.0133, -0.9999, 0.0000> }
    smooth_triangle { <94.3809, 222.4213, 0.0366>, <0.0133, -0.9999, 0.0000>, <94.3809, 222.4213, 0.0366>, <0.0133, -0.9999, 0.0000>, <89.8071, 223.7673, -4.5741>, <-0.1896, -0.9225, -0.3361> }
    smooth_triangle { <94.3809, 249.6046, 0.0366>, <0.0133, 0.9999, -0.0000>, <94.3809, 249.6046, 0.0366>, <0.0133, 0.9999, -0.0000>, <89.8071, 248.2586, -4.5741>, <-0.1896, 0.9225, -0.3361> }
    smooth_triangle { <89.8071, 248.2586, -4.5741>, <-0.1896, 0.9225, -0.3361>, <87.8737, 248.2587, -2.5221>, <-0.2463, 0.9498, -0.1931>, <94.3809, 249.6046, 0.0366>, <0.0133, 0.9999, -0.0000> }
    smooth_triangle { <87.8737, 248.2587, -2.5221>, <-0.2463, 0.9498, -0.1931>, <89.8071, 248.2586, -4.5741>, <-0.1896, 0.9225, -0.3361>, <84.9498, 244.4872, -8.2715>, <-0.2994, 0.6735, -0.6758> }
    smooth_triangle { <84.9498, 244.4872, -8.2715>, <-0.2994, 0.6735, -0.6758>, <79.0483, 244.4872, -4.5741>, <-0.3810, 0.8094, -0.4468>, <87.8737, 248.2587, -2.5221>, <-0.2463, 0.9498, -0.1931> }
    smooth_triangle { <79.0483, 244.4872, -4.5741>, <-0.3810, 0.8094, -0.4468>, <84.9498, 244.4872, -8.2715>, <-0.2994, 0.6735, -0.6758>, <83.0040, 239.0374, -10.3234>, <-0.3404, 0.2433, -0.9082> }
    smooth_triangle { <83.0040, 239.0374, -10.3234>, <-0.3404, 0.2433, -0.9082>, <71.7804, 239.0374, -5.7128>, <-0.5197, 0.3665, -0.7717>, <79.0483, 244.4872, -4.5741>, <-0.3810, 0.8094, -0.4468> }
    smooth_triangle { <71.7804, 239.0374, -5.7128>, <-0.5197, 0.3665, -0.7717>, <83.0040, 239.0374, -10.3234>, <-0.3404, 0.2433, -0.9082>, <83.0040, 232.9885, -10.3234>, <-0.3404, -0.2433, -0.9082> }
    smooth_triangle { <83.0040, 232.9885, -10.3234>, <-0.3404, -0.2433, -0.9082>, <71.7804, 232.9885, -5.7128>, <-0.5197, -0.3665, -0.7717>, <71.7804, 239.0374, -5.7128>, <-0.5197, 0.3665, -0.7717> }
    smooth_triangle { <71.7804, 232.9885, -5.7128>, <-0.5197, -0.3665, -0.7717>, <83.0040, 232.9885, -10.3234>, <-0.3404, -0.2433, -0.9082>, <84.9498, 227.5387, -8.2715>, <-0.2994, -0.6735, -0.6758> }
    smooth_triangle { <84.9498, 227.5387, -8.2715>, <-0.2994, -0.6735, -0.6758>, <79.0483, 227.5387, -4.5741>, <-0.3810, -0.8094, -0.4468>, <71.7804, 232.9885, -5.7128>, <-0.5197, -0.3665, -0.7717> }
    smooth_triangle { <79.0483, 227.5387, -4.5741>, <-0.3810, -0.8094, -0.4468>, <84.9498, 227.5387, -8.2715>, <-0.2994, -0.6735, -0.6758>, <89.8071, 223.7673, -4.5741>, <-0.1896, -0.9225, -0.3361> }
    smooth_triangle { <89.8071, 223.7673, -4.5741>, <-0.1896, -0.9225, -0.3361>, <87.8738, 223.7673, -2.5221>, <-0.2463, -0.9498, -0.1931>, <79.0483, 227.5387, -4.5741>, <-0.3810, -0.8094, -0.4468> }
    smooth_triangle { <87.8738, 223.7673, -2.5221>, <-0.2463, -0.9498, -0.1931>, <89.8071, 223.7673, -4.5741>, <-0.1896, -0.9225, -0.3361>, <94.3809, 222.4213, 0.0366>, <0.0133, -0.9999, 0.0000> }
    smooth_triangle { <94.3809, 222.4213, 0.0366>, <0.0133, -0.9999, 0.0000>, <94.3809, 222.4213, 0.0366>, <0.0133, -0.9999, 0.0000>, <87.8738, 223.7673, -2.5221>, <-0.2463, -0.9498, -0.1931> }
    smooth_triangle { <94.3809, 249.6046, 0.0366>, <0.0133, 0.9999, -0.0000>, <94.3809, 249.6046, 0.0366>, <0.0133, 0.9999, -0.0000>, <87.8737, 248.2587, -2.5221>, <-0.2463, 0.9498, -0.1931> }
    smooth_triangle { <87.8737, 248.2587, -2.5221>, <-0.2463, 0.9498, -0.1931>, <87.1586, 248.2587, 0.0366>, <-0.2641, 0.9645, 0.0000>, <94.3809, 249.6046, 0.0366>, <0.0133, 0.9999, -0.0000> }
    smooth_triangle { <87.1586, 248.2587, 0.0366>, <-0.2641, 0.9645, 0.0000>, <87.8737, 248.2587, -2.5221>, <-0.2463, 0.9498, -0.1931>, <79.0483, 244.4872, -4.5741>, <-0.3810, 0.8094, -0.4468> }
    smooth_triangle { <79.0483, 244.4872, -4.5741>, <-0.3810, 0.8094, -0.4468>, <76.3766, 244.4872, 0.0366>, <-0.4198, 0.9076, 0.0000>, <87.1586, 248.2587, 0.0366>, <-0.2641, 0.9645, 0.0000> }
    smooth_triangle { <76.3766, 244.4872, 0.0366>, <-0.4198, 0.9076, 0.0000>, <79.0483, 244.4872, -4.5741>, <-0.3810, 0.8094, -0.4468>, <71.7804, 239.0374, -5.7128>, <-0.5197, 0.3665, -0.7717> }
    smooth_triangle { <71.7804, 239.0374, -5.7128>, <-0.5197, 0.3665, -0.7717>, <65.6272, 239.0374, 0.0366>, <-0.4979, 0.8673, -0.0000>, <76.3766, 244.4872, 0.0366>, <-0.4198, 0.9076, 0.0000> }
    smooth_triangle { <65.6272, 239.0374, 0.0366>, <-0.6827, -0.0000, -0.7307>, <71.7804, 239.0374, -5.7128>, <-0.5197, 0.3665, -0.7717>, <71.7804, 232.9885, -5.7128>, <-0.5197, -0.3665, -0.7717> }
    smooth_triangle { <71.7804, 232.9885, -5.7128>, <-0.5197, -0.3665, -0.7717>, <65.6272, 232.9885, 0.0366>, <-0.6827, -0.0000, -0.7307>, <65.6272, 239.0374, 0.0366>, <-0.6827, -0.0000, -0.7307> }
    smooth_triangle { <65.6272, 232.9885, 0.0366>, <-0.4979, -0.8673, 0.0000>, <71.7804, 232.9885, -5.7128>, <-0.5197, -0.3665, -0.7717>, <79.0483, 227.5387, -4.5741>, <-0.3810, -0.8094, -0.4468> }
    smooth_triangle { <79.0483, 227.5387, -4.5741>, <-0.3810, -0.8094, -0.4468>, <76.3766, 227.5387, 0.0366>, <-0.4198, -0.9076, -0.0000>, <65.6272, 232.9885, 0.0366>, <-0.4979, -0.8673, 0.0000> }
    smooth_triangle { <76.3766, 227.5387, 0.0366>, <-0.4198, -0.9076, -0.0000>, <79.0483, 227.5387, -4.5741>, <-0.3810, -0.8094, -0.4468>, <87.8738, 223.7673, -2.5221>, <-0.2463, -0.9498, -0.1931> }
    smooth_triangle { <87.8738, 223.7673, -2.5221>, <-0.2463, -0.9498, -0.1931>, <87.1586, 223.7673, 0.0366>, <-0.2641, -0.9645, -0.0000>, <76.3766, 227.5387, 0.0366>, <-0.4198, -0.9076, -0.0000> }
    smooth_triangle { <87.1586, 223.7673, 0.0366>, <-0.2641, -0.9645, -0.0000>, <87.8738, 223.7673, -2.5221>, <-0.2463, -0.9498, -0.1931>, <94.3809, 222.4213, 0.0366>, <0.0133, -0.9999, 0.0000> }
    smooth_triangle { <94.3809, 222.4213, 0.0366>, <0.0133, -0.9999, 0.0000>, <94.3809, 222.4213, 0.0366>, <0.0133, -0.9999, 0.0000>, <87.1586, 223.7673, 0.0366>, <-0.2641, -0.9645, -0.0000> }
    smooth_triangle { <94.3809, 249.6046, 0.0366>, <0.0133, 0.9999, -0.0000>, <94.3809, 249.6046, 0.0366>, <0.0133, 0.9999, -0.0000>, <87.1586, 248.2587, 0.0366>, <-0.2641, 0.9645, 0.0000> }
    smooth_triangle { <87.1586, 248.2587, 0.0366>, <-0.2641, 0.9645, 0.0000>, <87.8737, 248.2586, 2.5953>, <-0.2463, 0.9498, 0.1931>, <94.3809, 249.6046, 0.0366>, <0.0133, 0.9999, -0.0000> }
    smooth_triangle { <87.8737, 248.2586, 2.5953>, <-0.2463, 0.9498, 0.1931>, <87.1586, 248.2587, 0.0366>, <-0.2641, 0.9645, 0.0000>, <76.3766, 244.4872, 0.0366>, <-0.4198, 0.9076, 0.0000> }
    smooth_triangle { <76.3766, 244.4872, 0.0366>, <-0.4198, 0.9076, 0.0000>, <79.0483, 244.4872, 4.6472>, <-0.3810, 0.8094, 0.4468>, <87.8737, 248.2586, 2.5953>, <-0.2463, 0.9498, 0.1931> }
    smooth_triangle { <79.0483, 244.4872, 4.6472>, <-0.3810, 0.8094, 0.4468>, <76.3766, 244.4872, 0.0366>, <-0.4198, 0.9076, 0.0000>, <65.6272, 239.0374, 0.0366>, <-0.4979, 0.8673, -0.0000> }
    smooth_triangle { <65.6272, 239.0374, 0.0366>, <-0.4979, 0.8673, -0.0000>, <71.7804, 239.0374, 5.7859>, <-0.5197, 0.3665, 0.7717>, <79.0483, 244.4872, 4.6472>, <-0.3810, 0.8094, 0.4468> }
    smooth_triangle { <71.7804, 239.0374, 5.7859>, <-0.5197, 0.3665, 0.7717>, <65.6272, 239.0374, 0.0366>, <-0.6827, 0.0000, 0.7307>, <65.6272, 232.9885, 0.0366>, <-0.6827, 0.0000, 0.7307> }
    smooth_triangle { <65.6272, 232.9885, 0.0366>, <-0.6827, 0.0000, 0.7307>, <71.7804, 232.9885, 5.7859>, <-0.5197, -0.3665, 0.7717>, <71.7804, 239.0374, 5.7859>, <-0.5197, 0.3665, 0.7717> }
    smooth_triangle { <71.7804, 232.9885, 5.7859>, <-0.5197, -0.3665, 0.7717>, <65.6272, 232.9885, 0.0366>, <-0.4979, -0.8673, 0.0000>, <76.3766, 227.5387, 0.0366>, <-0.4198, -0.9076, -0.0000> }
    smooth_triangle { <76.3766, 227.5387, 0.0366>, <-0.4198, -0.9076, -0.0000>, <79.0483, 227.5387, 4.6472>, <-0.3810, -0.8094, 0.4468>, <71.7804, 232.9885, 5.7859>, <-0.5197, -0.3665, 0.7717> }
    smooth_triangle { <79.0483, 227.5387, 4.6472>, <-0.3810, -0.8094, 0.4468>, <76.3766, 227.5387, 0.0366>, <-0.4198, -0.9076, -0.0000>, <87.1586, 223.7673, 0.0366>, <-0.2641, -0.9645, -0.0000> }
    smooth_triangle { <87.1586, 223.7673, 0.0366>, <-0.2641, -0.9645, -0.0000>, <87.8738, 223.7673, 2.5953>, <-0.2463, -0.9498, 0.1931>, <79.0483, 227.5387, 4.6472>, <-0.3810, -0.8094, 0.4468> }
    smooth_triangle { <87.8738, 223.7673, 2.5953>, <-0.2463, -0.9498, 0.1931>, <87.1586, 223.7673, 0.0366>, <-0.2641, -0.9645, -0.0000>, <94.3809, 222.4213, 0.0366>, <0.0133, -0.9999, 0.0000> }
    smooth_triangle { <94.3809, 222.4213, 0.0366>, <0.0133, -0.9999, 0.0000>, <94.3809, 222.4213, 0.0366>, <0.0133, -0.9999, 0.0000>, <87.8738, 223.7673, 2.5953>, <-0.2463, -0.9498, 0.1931> }
    smooth_triangle { <94.3809, 249.6046, 0.0366>, <0.0133, 0.9999, -0.0000>, <94.3809, 249.6046, 0.0366>, <0.0133, 0.9999, -0.0000>, <87.8737, 248.2586, 2.5953>, <-0.2463, 0.9498, 0.1931> }
    smooth_triangle { <87.8737, 248.2586, 2.5953>, <-0.2463, 0.9498, 0.1931>, <89.8071, 248.2586, 4.6472>, <-0.1896, 0.9225, 0.3361>, <94.3809, 249.6046, 0.0366>, <0.0133, 0.9999, -0.0000> }
    smooth_triangle { <89.8071, 248.2586, 4.6472>, <-0.1896, 0.9225, 0.3361>, <87.8737, 248.2586, 2.5953>, <-0.2463, 0.9498, 0.1931>, <79.0483, 244.4872, 4.6472>, <-0.3810, 0.8094, 0.4468> }
    smooth_triangle { <79.0483, 244.4872, 4.6472>, <-0.3810, 0.8094, 0.4468>, <84.9498, 244.4872, 8.3446>, <-0.2994, 0.6735, 0.6758>, <89.8071, 248.2586, 4.6472>, <-0.1896, 0.9225, 0.3361> }
    smooth_triangle { <84.9498, 244.4872, 8.3446>, <-0.2994, 0.6735, 0.6758>, <79.0483, 244.4872, 4.6472>, <-0.3810, 0.8094, 0.4468>, <71.7804, 239.0374, 5.7859>, <-0.5197, 0.3665, 0.7717> }
    smooth_triangle { <71.7804, 239.0374, 5.7859>, <-0.5197, 0.3665, 0.7717>, <83.0040, 239.0374, 10.3965>, <-0.3404, 0.2433, 0.9082>, <84.9498, 244.4872, 8.3446>, <-0.2994, 0.6735, 0.6758> }
    smooth_triangle { <83.0040, 239.0374, 10.3965>, <-0.3404, 0.2433, 0.9082>, <71.7804, 239.0374, 5.7859>, <-0.5197, 0.3665, 0.7717>, <71.7804, 232.9885, 5.7859>, <-0.5197, -0.3665, 0.7717> }
    smooth_triangle { <71.7804, 232.9885, 5.7859>, <-0.5197, -0.3665, 0.7717>, <83.0040, 232.9885, 10.3965>, <-0.3404, -0.2433, 0.9082>, <83.0040, 239.0374, 10.3965>, <-0.3404, 0.2433, 0.9082> }
    smooth_triangle { <83.0040, 232.9885, 10.3965>, <-0.3404, -0.2433, 0.9082>, <71.7804, 232.9885, 5.7859>, <-0.5197, -0.3665, 0.7717>, <79.0483, 227.5387, 4.6472>, <-0.3810, -0.8094, 0.4468> }
    smooth_triangle { <79.0483, 227.5387, 4.6472>, <-0.3810, -0.8094, 0.4468>, <84.9498, 227.5387, 8.3446>, <-0.2994, -0.6735, 0.6758>, <83.0040, 232.9885, 10.3965>, <-0.3404, -0.2433, 0.9082> }
    smooth_triangle { <84.9498, 227.5387, 8.3446>, <-0.2994, -0.6735, 0.6758>, <79.0483, 227.5387, 4.6472>, <-0.3810, -0.8094, 0.4468>, <87.8738, 223.7673, 2.5953>, <-0.2463, -0.9498, 0.1931> }
    smooth_triangle { <87.8738, 223.7673, 2.5953>, <-0.2463, -0.9498, 0.1931>, <89.8071, 223.7673, 4.6472>, <-0.1896, -0.9225, 0.3361>, <84.9498, 227.5387, 8.3446>, <-0.2994, -0.6735, 0.6758> }
    smooth_triangle { <89.8071, 223.7673, 4.6472>, <-0.1896, -0.9225, 0.3361>, <87.8738, 223.7673, 2.5953>, <-0.2463, -0.9498, 0.1931>, <94.3809, 222.4213, 0.0366>, <0.0133, -0.9999, 0.0000> }
    smooth_triangle { <94.3809, 222.4213, 0.0366>, <0.0133, -0.9999, 0.0000>, <94.3809, 222.4213, 0.0366>, <0.0133, -0.9999, 0.0000>, <89.8071, 223.7673, 4.6472>, <-0.1896, -0.9225, 0.3361> }
    smooth_triangle { <94.3809, 249.6046, 0.0366>, <0.0133, 0.9999, -0.0000>, <94.3809, 249.6046, 0.0366>, <0.0133, 0.9999, -0.0000>, <89.8071, 248.2586, 4.6472>, <-0.1896, 0.9225, 0.3361> }
    smooth_triangle { <89.8071, 248.2586, 4.6472>, <-0.1896, 0.9225, 0.3361>, <92.4618, 248.2586, 5.7859>, <-0.0754, 0.9052, 0.4183>, <94.3809, 249.6046, 0.0366>, <0.0133, 0.9999, -0.0000> }
    smooth_triangle { <92.4618, 248.2586, 5.7859>, <-0.0754, 0.9052, 0.4183>, <89.8071, 248.2586, 4.6472>, <-0.1896, 0.9225, 0.3361>, <84.9498, 244.4872, 8.3446>, <-0.2994, 0.6735, 0.6758> }
    smooth_triangle { <84.9498, 244.4872, 8.3446>, <-0.2994, 0.6735, 0.6758>, <90.9969, 244.4872, 10.3965>, <-0.1258, 0.6234, 0.7717>, <92.4618, 248.2586, 5.7859>, <-0.0754, 0.9052, 0.4183> }
    smooth_triangle { <90.9969, 244.4872, 10.3965>, <-0.1258, 0.6234, 0.7717>, <84.9498, 244.4872, 8.3446>, <-0.2994, 0.6735, 0.6758>, <83.0040, 239.0374, 10.3965>, <-0.3404, 0.2433, 0.9082> }
    smooth_triangle { <83.0040, 239.0374, 10.3965>, <-0.3404, 0.2433, 0.9082>, <91.4323, 239.0374, 12.9553>, <-0.1469, 0.2151, 0.9655>, <90.9969, 244.4872, 10.3965>, <-0.1258, 0.6234, 0.7717> }
    smooth_triangle { <91.4323, 239.0374, 12.9553>, <-0.1469, 0.2151, 0.9655>, <83.0040, 239.0374, 10.3965>, <-0.3404, 0.2433, 0.9082>, <83.0040, 232.9885, 10.3965>, <-0.3404, -0.2433, 0.9082> }
    smooth_triangle { <83.0040, 232.9885, 10.3965>, <-0.3404, -0.2433, 0.9082>, <91.4323, 232.9885, 12.9553>, <-0.1469, -0.2151, 0.9655>, <91.4323, 239.0374, 12.9553>, <-0.1469, 0.2151, 0.9655> }
    smooth_triangle { <91.4323, 232.9885, 12.9553>, <-0.1469, -0.2151, 0.9655>, <83.0040, 232.9885, 10.3965>, <-0.3404, -0.2433, 0.9082>, <84.9498, 227.5387, 8.3446>, <-0.2994, -0.6735, 0.6758> }
    smooth_triangle { <84.9498, 227.5387, 8.3446>, <-0.2994, -0.6735, 0.6758>, <90.9969, 227.5387, 10.3965>, <-0.1258, -0.6234, 0.7717>, <91.4323, 232.9885, 12.9553>, <-0.1469, -0.2151, 0.9655> }
    smooth_triangle { <90.9969, 227.5387, 10.3965>, <-0.1258, -0.6234, 0.7717>, <84.9498, 227.5387, 8.3446>, <-0.2994, -0.6735, 0.6758>, <89.8071, 223.7673, 4.6472>, <-0.1896, -0.9225, 0.3361> }
    smooth_triangle { <89.8071, 223.7673, 4.6472>, <-0.1896, -0.9225, 0.3361>, <92.4617, 223.7673, 5.7859>, <-0.0754, -0.9052, 0.4183>, <90.9969, 227.5387, 10.3965>, <-0.1258, -0.6234, 0.7717> }
    smooth_triangle { <92.4617, 223.7673, 5.7859>, <-0.0754, -0.9052, 0.4183>, <89.8071, 223.7673, 4.6472>, <-0.1896, -0.9225, 0.3361>, <94.3809, 222.4213, 0.0366>, <0.0133, -0.9999, 0.0000> }
    smooth_triangle { <94.3809, 222.4213, 0.0366>, <0.0133, -0.9999, 0.0000>, <94.3809, 222.4213, 0.0366>, <0.0133, -0.9999, 0.0000>, <92.4617, 223.7673, 5.7859>, <-0.0754, -0.9052, 0.4183> }
    smooth_triangle { <94.3809, 249.6046, 0.0366>, <0.0133, 0.9999, -0.0000>, <94.3809, 249.6046, 0.0366>, <0.0133, 0.9999, -0.0000>, <92.4618, 248.2586, 5.7859>, <-0.0754, 0.9052, 0.4183> }
    smooth_triangle { <92.4618, 248.2586, 5.7859>, <-0.0754, 0.9052, 0.4183>, <95.2867, 248.2586, 5.7859>, <0.0934, 0.9002, 0.4253>, <94.3809, 249.6046, 0.0366>, <0.0133, 0.9999, -0.0000> }
    smooth_triangle { <95.2867, 248.2586, 5.7859>, <0.0934, 0.9002, 0.4253>, <92.4618, 248.2586, 5.7859>, <-0.0754, 0.9052, 0.4183>, <90.9969, 244.4872, 10.3965>, <-0.1258, 0.6234, 0.7717> }
    smooth_triangle { <90.9969, 244.4872, 10.3965>, <-0.1258, 0.6234, 0.7717>, <96.2546, 244.4872, 10.3965>, <0.1697, 0.6276, 0.7598>, <95.2867, 248.2586, 5.7859>, <0.0934, 0.9002, 0.4253> }
    smooth_triangle { <96.2546, 244.4872, 10.3965>, <0.1697, 0.6276, 0.7598>, <90.9969, 244.4872, 10.3965>, <-0.1258, 0.6234, 0.7717>, <91.4323, 239.0374, 12.9553>, <-0.1469, 0.2151, 0.9655> }
    smooth_triangle { <91.4323, 239.0374, 12.9553>, <-0.1469, 0.2151, 0.9655>, <97.3294, 239.0374, 12.9553>, <0.2188, 0.2282, 0.9487>, <96.2546, 244.4872, 10.3965>, <0.1697, 0.6276, 0.7598> }
    smooth_triangle { <97.3294, 239.0374, 12.9553>, <0.2188, 0.2282, 0.9487>, <91.4323, 239.0374, 12.9553>, <-0.1469, 0.2151, 0.9655>, <91.4323, 232.9885, 12.9553>, <-0.1469, -0.2151, 0.9655> }
    smooth_triangle { <91.4323, 232.9885, 12.9553>, <-0.1469, -0.2151, 0.9655>, <97.3294, 232.9885, 12.9553>, <0.2188, -0.2282, 0.9487>, <97.3294, 239.0374, 12.9553>, <0.2188, 0.2282, 0.9487> }
    smooth_triangle { <97.3294, 232.9885, 12.9553>, <0.2188, -0.2282, 0.9487>, <91.4323, 232.9885, 12.9553>, <-0.1469, -0.2151, 0.9655>, <90.9969, 227.5387, 10.3965>, <-0.1258, -0.6234, 0.7717> }
    smooth_triangle { <90.9969, 227.5387, 10.3965>, <-0.1258, -0.6234, 0.7717>, <96.2546, 227.5387, 10.3965>, <0.1697, -0.6276, 0.7598>, <97.3294, 232.9885, 12.9553>, <0.2188, -0.2282, 0.9487> }
    smooth_triangle { <96.2546, 227.5387, 10.3965>, <0.1697, -0.6276, 0.7598>, <90.9969, 227.5387, 10.3965>, <-0.1258, -0.6234, 0.7717>, <92.4617, 223.7673, 5.7859>, <-0.0754, -0.9052, 0.4183> }
    smooth_triangle { <92.4617, 223.7673, 5.7859>, <-0.0754, -0.9052, 0.4183>, <95.2867, 223.7673, 5.7859>, <0.0934, -0.9002, 0.4253>, <96.2546, 227.5387, 10.3965>, <0.1697, -0.6276, 0.7598> }
    smooth_triangle { <95.2867, 223.7673, 5.7859>, <0.0934, -0.9002, 0.4253>, <92.4617, 223.7673, 5.7859>, <-0.0754, -0.9052, 0.4183>, <94.3809, 222.4213, 0.0366>, <0.0133, -0.9999, 0.0000> }
    smooth_triangle { <94.3809, 222.4213, 0.0366>, <0.0133, -0.9999, 0.0000>, <94.3809, 222.4213, 0.0366>, <0.0133, -0.9999, 0.0000>, <95.2867, 223.7673, 5.7859>, <0.0934, -0.9002, 0.4253> }
    smooth_triangle { <94.3809, 249.6046, 0.0366>, <0.0133, 0.9999, -0.0000>, <94.3809, 249.6046, 0.0366>, <0.0133, 0.9999, -0.0000>, <95.2867, 248.2586, 5.7859>, <0.0934, 0.9002, 0.4253> }
    smooth_triangle { <95.2867, 248.2586, 5.7859>, <0.0934, 0.9002, 0.4253>, <97.7738, 248.2586, 4.6472>, <0.2647, 0.8999, 0.3466>, <94.3809, 249.6046, 0.0366>, <0.0133, 0.9999, -0.0000> }
    smooth_triangle { <97.7738, 248.2586, 4.6472>, <0.2647, 0.8999, 0.3466>, <95.2867, 248.2586, 5.7859>, <0.0934, 0.9002, 0.4253>, <96.2546, 244.4872, 10.3965>, <0.1697, 0.6276, 0.7598> }
    smooth_triangle { <96.2546, 244.4872, 10.3965>, <0.1697, 0.6276, 0.7598>, <100.7076, 244.4872, 8.3446>, <0.4744, 0.6306, 0.6142>, <97.7738, 248.2586, 4.6472>, <0.2647, 0.8999, 0.3466> }
    smooth_triangle { <100.7076, 244.4872, 8.3446>, <0.4744, 0.6306, 0.6142>, <96.2546, 244.4872, 10.3965>, <0.1697, 0.6276, 0.7598>, <97.3294, 239.0374, 12.9553>, <0.2188, 0.2282, 0.9487> }
    smooth_triangle { <97.3294, 239.0374, 12.9553>, <0.2188, 0.2282, 0.9487>, <102.4834, 239.0374, 10.3965>, <0.6015, 0.2311, 0.7647>, <100.7076, 244.4872, 8.3446>, <0.4744, 0.6306, 0.6142> }
    smooth_triangle { <102.4834, 239.0374, 10.3965>, <0.6015, 0.2311, 0.7647>, <97.3294, 239.0374, 12.9553>, <0.2188, 0.2282, 0.9487>, <97.3294, 232.9885, 12.9553>, <0.2188, -0.2282, 0.9487> }
    smooth_triangle { <97.3294, 232.9885, 12.9553>, <0.2188, -0.2282, 0.9487>, <102.4834, 232.9885, 10.3965>, <0.6015, -0.2311, 0.7647>, <102.4834, 239.0374, 10.3965>, <0.6015, 0.2311, 0.7647> }
    smooth_triangle { <102.4834, 232.9885, 10.3965>, <0.6015, -0.2311, 0.7647>, <97.3294, 232.9885, 12.9553>, <0.2188, -0.2282, 0.9487>, <96.2546, 227.5387, 10.3965>, <0.1697, -0.6276, 0.7598> }
    smooth_triangle { <96.2546, 227.5387, 10.3965>, <0.1697, -0.6276, 0.7598>, <100.7076, 227.5387, 8.3446>, <0.4744, -0.6306, 0.6142>, <102.4834, 232.9885, 10.3965>, <0.6015, -0.2311, 0.7647> }
    smooth_triangle { <100.7076, 227.5387, 8.3446>, <0.4744, -0.6306, 0.6142>, <96.2546, 227.5387, 10.3965>, <0.1697, -0.6276, 0.7598>, <95.2867, 223.7673, 5.7859>, <0.0934, -0.9002, 0.4253> }
    smooth_triangle { <95.2867, 223.7673, 5.7859>, <0.0934, -0.9002, 0.4253>, <97.7739, 223.7673, 4.6472>, <0.2647, -0.8999, 0.3466>, <100.7076, 227.5387, 8.3446>, <0.4744, -0.6306, 0.6142> }
    smooth_triangle { <97.7739, 223.7673, 4.6472>, <0.2647, -0.8999, 0.3466>, <95.2867, 223.7673, 5.7859>, <0.0934, -0.9002, 0.4253>, <94.3809, 222.4213, 0.0366>, <0.0133, -0.9999, 0.0000> }
    smooth_triangle { <94.3809, 222.4213, 0.0366>, <0.0133, -0.9999, 0.0000>, <94.3809, 222.4213, 0.0366>, <0.0133, -0.9999, 0.0000>, <97.7739, 223.7673, 4.6472>, <0.2647, -0.8999, 0.3466> }
    smooth_triangle { <94.3809, 249.6046, 0.0366>, <0.0133, 0.9999, -0.0000>, <94.3809, 249.6046, 0.0366>, <0.0133, 0.9999, -0.0000>, <97.7738, 248.2586, 4.6472>, <0.2647, 0.8999, 0.3466> }
    smooth_triangle { <97.7738, 248.2586, 4.6472>, <0.2647, 0.8999, 0.3466>, <99.4796, 248.2586, 2.5953>, <0.3870, 0.9013, 0.1947>, <94.3809, 249.6046, 0.0366>, <0.0133, 0.9999, -0.0000> }
    smooth_triangle { <99.4796, 248.2586, 2.5953>, <0.3870, 0.9013, 0.1947>, <97.7738, 248.2586, 4.6472>, <0.2647, 0.8999, 0.3466>, <100.7076, 244.4872, 8.3446>, <0.4744, 0.6306, 0.6142> }
    smooth_triangle { <100.7076, 244.4872, 8.3446>, <0.4744, 0.6306, 0.6142>, <103.8185, 244.4872, 4.6472>, <0.6920, 0.6329, 0.3471>, <99.4796, 248.2586, 2.5953>, <0.3870, 0.9013, 0.1947> }
    smooth_triangle { <103.8185, 244.4872, 4.6472>, <0.6920, 0.6329, 0.3471>, <100.7076, 244.4872, 8.3446>, <0.4744, 0.6306, 0.6142>, <102.4834, 239.0374, 10.3965>, <0.6015, 0.2311, 0.7647> }
    smooth_triangle { <102.4834, 239.0374, 10.3965>, <0.6015, 0.2311, 0.7647>, <106.2948, 239.0374, 5.7859>, <0.8714, 0.2304, 0.4332>, <103.8185, 244.4872, 4.6472>, <0.6920, 0.6329, 0.3471> }
    smooth_triangle { <106.2948, 239.0374, 5.7859>, <0.8714, 0.2304, 0.4332>, <102.4834, 239.0374, 10.3965>, <0.6015, 0.2311, 0.7647>, <102.4834, 232.9885, 10.3965>, <0.6015, -0.2311, 0.7647> }
    smooth_triangle { <102.4834, 232.9885, 10.3965>, <0.6015, -0.2311, 0.7647>, <106.2948, 232.9885, 5.7859>, <0.8714, -0.2304, 0.4332>, <106.2948, 239.0374, 5.7859>, <0.8714, 0.2304, 0.4332> }
    smooth_triangle { <106.2948, 232.9885, 5.7859>, <0.8714, -0.2304, 0.4332>, <102.4834, 232.9885, 10.3965>, <0.6015, -0.2311, 0.7647>, <100.7076, 227.5387, 8.3446>, <0.4744, -0.6306, 0.6142> }
    smooth_triangle { <100.7076, 227.5387, 8.3446>, <0.4744, -0.6306, 0.6142>, <103.8185, 227.5387, 4.6472>, <0.6920, -0.6329, 0.3471>, <106.2948, 232.9885, 5.7859>, <0.8714, -0.2304, 0.4332> }
    smooth_triangle { <103.8185, 227.5387, 4.6472>, <0.6920, -0.6329, 0.3471>, <100.7076, 227.5387, 8.3446>, <0.4744, -0.6306, 0.6142>, <97.7739, 223.7673, 4.6472>, <0.2647, -0.8999, 0.3466> }
    smooth_triangle { <97.7739, 223.7673, 4.6472>, <0.2647, -0.8999, 0.3466>, <99.4796, 223.7673, 2.5953>, <0.3870, -0.9013, 0.1947>, <103.8185, 227.5387, 4.6472>, <0.6920, -0.6329, 0.3471> }
    smooth_triangle { <99.4796, 223.7673, 2.5953>, <0.3870, -0.9013, 0.1947>, <97.7739, 223.7673, 4.6472>, <0.2647, -0.8999, 0.3466>, <94.3809, 222.4213, 0.0366>, <0.0133, -0.9999, 0.0000> }
    smooth_triangle { <94.3809, 222.4213, 0.0366>, <0.0133, -0.9999, 0.0000>, <94.3809, 222.4213, 0.0366>, <0.0133, -0.9999, 0.0000>, <99.4796, 223.7673, 2.5953>, <0.3870, -0.9013, 0.1947> }
    smooth_triangle { <94.3809, 249.6046, 0.0366>, <0.0133, 0.9999, -0.0000>, <94.3809, 249.6046, 0.0366>, <0.0133, 0.9999, -0.0000>, <99.4796, 248.2586, 2.5953>, <0.3870, 0.9013, 0.1947> }
    smooth_triangle { <99.4796, 248.2586, 2.5953>, <0.3870, 0.9013, 0.1947>, <100.0866, 248.2587, 0.0366>, <0.4314, 0.9022, -0.0000>, <94.3809, 249.6046, 0.0366>, <0.0133, 0.9999, -0.0000> }
    smooth_triangle { <100.0866, 248.2587, 0.0366>, <0.4314, 0.9022, -0.0000>, <99.4796, 248.2586, 2.5953>, <0.3870, 0.9013, 0.1947>, <103.8185, 244.4872, 4.6472>, <0.6920, 0.6329, 0.3471> }
    smooth_triangle { <103.8185, 244.4872, 4.6472>, <0.6920, 0.6329, 0.3471>, <104.9279, 244.4872, 0.0366>, <0.7730, 0.6344, -0.0000>, <100.0866, 248.2587, 0.0366>, <0.4314, 0.9022, -0.0000> }
    smooth_triangle { <104.9279, 244.4872, 0.0366>, <0.7730, 0.6344, -0.0000>, <103.8185, 244.4872, 4.6472>, <0.6920, 0.6329, 0.3471>, <106.2948, 239.0374, 5.7859>, <0.8714, 0.2304, 0.4332> }
    smooth_triangle { <106.2948, 239.0374, 5.7859>, <0.8714, 0.2304, 0.4332>, <107.6317, 239.0374, 0.0366>, <0.9731, 0.2302, -0.0000>, <104.9279, 244.4872, 0.0366>, <0.7730, 0.6344, -0.0000> }
    smooth_triangle { <107.6317, 239.0374, 0.0366>, <0.9731, 0.2302, -0.0000>, <106.2948, 239.0374, 5.7859>, <0.8714, 0.2304, 0.4332>, <106.2948, 232.9885, 5.7859>, <0.8714, -0.2304, 0.4332> }
    smooth_triangle { <106.2948, 232.9885, 5.7859>, <0.8714, -0.2304, 0.4332>, <107.6318, 232.9885, 0.0366>, <0.9731, -0.2302, -0.0000>, <107.6317, 239.0374, 0.0366>, <0.9731, 0.2302, -0.0000> }
    smooth_triangle { <107.6318, 232.9885, 0.0366>, <0.9731, -0.2302, -0.0000>, <106.2948, 232.9885, 5.7859>, <0.8714, -0.2304, 0.4332>, <103.8185, 227.5387, 4.6472>, <0.6920, -0.6329, 0.3471> }
    smooth_triangle { <103.8185, 227.5387, 4.6472>, <0.6920, -0.6329, 0.3471>, <104.9279, 227.5387, 0.0366>, <0.7730, -0.6344, 0.0000>, <107.6318, 232.9885, 0.0366>, <0.9731, -0.2302, -0.0000> }
    smooth_triangle { <104.9279, 227.5387, 0.0366>, <0.7730, -0.6344, 0.0000>, <103.8185, 227.5387, 4.6472>, <0.6920, -0.6329, 0.3471>, <99.4796, 223.7673, 2.5953>, <0.3870, -0.9013, 0.1947> }
    smooth_triangle { <99.4796, 223.7673, 2.5953>, <0.3870, -0.9013, 0.1947>, <100.0866, 223.7673, 0.0366>, <0.4314, -0.9022, 0.0000>, <104.9279, 227.5387, 0.0366>, <0.7730, -0.6344, 0.0000> }
    smooth_triangle { <100.0866, 223.7673, 0.0366>, <0.4314, -0.9022, 0.0000>, <99.4796, 223.7673, 2.5953>, <0.3870, -0.9013, 0.1947>, <94.3809, 222.4213, 0.0366>, <0.0133, -0.9999, 0.0000> }
    smooth_triangle { <94.3809, 222.4213, 0.0366>, <0.0133, -0.9999, 0.0000>, <94.3809, 222.4213, 0.0366>, <0.0133, -0.9999, 0.0000>, <100.0866, 223.7673, 0.0366>, <0.4314, -0.9022, 0.0000> }
    texture {
      Brushed_Aluminum
    }
  }

  mesh { // Surf2 
    smooth_triangle { <-60.5644, 249.6046, 0.0366>, <-0.0162, 0.9999, -0.0000>, <-60.5644, 249.6046, 0.0366>, <-0.0162, 0.9999, -0.0000>, <-52.9976, 248.2586, 0.0366>, <0.2503, 0.9682, 0.0000> }
    smooth_triangle { <-52.9976, 248.2586, 0.0366>, <0.2503, 0.9682, 0.0000>, <-53.7435, 248.2586, -2.5221>, <0.2335, 0.9534, -0.1912>, <-60.5644, 249.6046, 0.0366>, <-0.0162, 0.9999, -0.0000> }
    smooth_triangle { <-53.7435, 248.2586, -2.5221>, <0.2335, 0.9534, -0.1912>, <-52.9976, 248.2586, 0.0366>, <0.2503, 0.9682, 0.0000>, <-41.5082, 244.4872, 0.0366>, <0.4140, 0.9103, 0.0000> }
    smooth_triangle { <-41.5082, 244.4872, 0.0366>, <0.4140, 0.9103, 0.0000>, <-44.2684, 244.4872, -4.5741>, <0.3718, 0.8139, -0.4465>, <-53.7435, 248.2586, -2.5221>, <0.2335, 0.9534, -0.1912> }
    smooth_triangle { <-44.2684, 244.4872, -4.5741>, <0.3718, 0.8139, -0.4465>, <-41.5082, 244.4872, 0.0366>, <0.4140, 0.9103, 0.0000>, <-31.1655, 239.0374, 0.0366>, <0.5052, 0.8630, -0.0000> }
    smooth_triangle { <-31.1655, 239.0374, 0.0366>, <0.5052, 0.8630, -0.0000>, <-36.9268, 239.0374, -5.7128>, <0.5241, 0.3664, -0.7688>, <-44.2684, 244.4872, -4.5741>, <0.3718, 0.8139, -0.4465> }
    smooth_triangle { <-36.9268, 239.0374, -5.7128>, <0.5241, 0.3664, -0.7688>, <-31.1655, 239.0374, 0.0366>, <0.7064, -0.0000, -0.7078>, <-31.1655, 232.9885, 0.0366>, <0.7064, -0.0000, -0.7078> }
    smooth_triangle { <-31.1655, 232.9885, 0.0366>, <0.7064, -0.0000, -0.7078>, <-36.9268, 232.9885, -5.7128>, <0.5241, -0.3664, -0.7688>, <-36.9268, 239.0374, -5.7128>, <0.5241, 0.3664, -0.7688> }
    smooth_triangle { <-36.9268, 232.9885, -5.7128>, <0.5241, -0.3664, -0.7688>, <-31.1655, 232.9885, 0.0366>, <0.5052, -0.8630, -0.0000>, <-41.5082, 227.5387, 0.0366>, <0.4140, -0.9103, 0.0000> }
    smooth_triangle { <-41.5082, 227.5387, 0.0366>, <0.4140, -0.9103, 0.0000>, <-44.2684, 227.5387, -4.5741>, <0.3718, -0.8139, -0.4465>, <-36.9268, 232.9885, -5.7128>, <0.5241, -0.3664, -0.7688> }
    smooth_triangle { <-44.2684, 227.5387, -4.5741>, <0.3718, -0.8139, -0.4465>, <-41.5082, 227.5387, 0.0366>, <0.4140, -0.9103, 0.0000>, <-52.9976, 223.7673, 0.0366>, <0.2503, -0.9682, 0.0000> }
    smooth_triangle { <-52.9976, 223.7673, 0.0366>, <0.2503, -0.9682, 0.0000>, <-53.7435, 223.7673, -2.5221>, <0.2335, -0.9534, -0.1912>, <-44.2684, 227.5387, -4.5741>, <0.3718, -0.8139, -0.4465> }
    smooth_triangle { <-53.7435, 223.7673, -2.5221>, <0.2335, -0.9534, -0.1912>, <-52.9976, 223.7673, 0.0366>, <0.2503, -0.9682, 0.0000>, <-60.5644, 222.4213, 0.0366>, <-0.0162, -0.9999, 0.0000> }
    smooth_triangle { <-60.5644, 222.4213, 0.0366>, <-0.0162, -0.9999, 0.0000>, <-60.5644, 222.4213, 0.0366>, <-0.0162, -0.9999, 0.0000>, <-53.7435, 223.7673, -2.5221>, <0.2335, -0.9534, -0.1912> }
    smooth_triangle { <-60.5644, 249.6046, 0.0366>, <-0.0162, 0.9999, -0.0000>, <-60.5644, 249.6046, 0.0366>, <-0.0162, 0.9999, -0.0000>, <-53.7435, 248.2586, -2.5221>, <0.2335, 0.9534, -0.1912> }
    smooth_triangle { <-53.7435, 248.2586, -2.5221>, <0.2335, 0.9534, -0.1912>, <-55.7489, 248.2586, -4.5741>, <0.1804, 0.9250, -0.3345>, <-60.5644, 249.6046, 0.0366>, <-0.0162, 0.9999, -0.0000> }
    smooth_triangle { <-55.7489, 248.2586, -4.5741>, <0.1804, 0.9250, -0.3345>, <-53.7435, 248.2586, -2.5221>, <0.2335, 0.9534, -0.1912>, <-44.2684, 244.4872, -4.5741>, <0.3718, 0.8139, -0.4465> }
    smooth_triangle { <-44.2684, 244.4872, -4.5741>, <0.3718, 0.8139, -0.4465>, <-50.5135, 244.4872, -8.2715>, <0.2858, 0.6754, -0.6798>, <-55.7489, 248.2586, -4.5741>, <0.1804, 0.9250, -0.3345> }
    smooth_triangle { <-50.5135, 244.4872, -8.2715>, <0.2858, 0.6754, -0.6798>, <-44.2684, 244.4872, -4.5741>, <0.3718, 0.8139, -0.4465>, <-36.9268, 239.0374, -5.7128>, <0.5241, 0.3664, -0.7688> }
    smooth_triangle { <-36.9268, 239.0374, -5.7128>, <0.5241, 0.3664, -0.7688>, <-48.5052, 239.0374, -10.3234>, <0.3254, 0.2414, -0.9142>, <-50.5135, 244.4872, -8.2715>, <0.2858, 0.6754, -0.6798> }
    smooth_triangle { <-48.5052, 239.0374, -10.3234>, <0.3254, 0.2414, -0.9142>, <-36.9268, 239.0374, -5.7128>, <0.5241, 0.3664, -0.7688>, <-36.9268, 232.9885, -5.7128>, <0.5241, -0.3664, -0.7688> }
    smooth_triangle { <-36.9268, 232.9885, -5.7128>, <0.5241, -0.3664, -0.7688>, <-48.5052, 232.9885, -10.3234>, <0.3254, -0.2414, -0.9142>, <-48.5052, 239.0374, -10.3234>, <0.3254, 0.2414, -0.9142> }
    smooth_triangle { <-48.5052, 232.9885, -10.3234>, <0.3254, -0.2414, -0.9142>, <-36.9268, 232.9885, -5.7128>, <0.5241, -0.3664, -0.7688>, <-44.2684, 227.5387, -4.5741>, <0.3718, -0.8139, -0.4465> }
    smooth_triangle { <-44.2684, 227.5387, -4.5741>, <0.3718, -0.8139, -0.4465>, <-50.5135, 227.5387, -8.2715>, <0.2858, -0.6754, -0.6798>, <-48.5052, 232.9885, -10.3234>, <0.3254, -0.2414, -0.9142> }
    smooth_triangle { <-50.5135, 227.5387, -8.2715>, <0.2858, -0.6754, -0.6798>, <-44.2684, 227.5387, -4.5741>, <0.3718, -0.8139, -0.4465>, <-53.7435, 223.7673, -2.5221>, <0.2335, -0.9534, -0.1912> }
    smooth_triangle { <-53.7435, 223.7673, -2.5221>, <0.2335, -0.9534, -0.1912>, <-55.7489, 223.7673, -4.5741>, <0.1804, -0.9250, -0.3345>, <-50.5135, 227.5387, -8.2715>, <0.2858, -0.6754, -0.6798> }
    smooth_triangle { <-55.7489, 223.7673, -4.5741>, <0.1804, -0.9250, -0.3345>, <-53.7435, 223.7673, -2.5221>, <0.2335, -0.9534, -0.1912>, <-60.5644, 222.4213, 0.0366>, <-0.0162, -0.9999, 0.0000> }
    smooth_triangle { <-60.5644, 222.4213, 0.0366>, <-0.0162, -0.9999, 0.0000>, <-60.5644, 222.4213, 0.0366>, <-0.0162, -0.9999, 0.0000>, <-55.7489, 223.7673, -4.5741>, <0.1804, -0.9250, -0.3345> }
    smooth_triangle { <-60.5644, 249.6046, 0.0366>, <-0.0162, 0.9999, -0.0000>, <-60.5644, 249.6046, 0.0366>, <-0.0162, 0.9999, -0.0000>, <-55.7489, 248.2586, -4.5741>, <0.1804, 0.9250, -0.3345> }
    smooth_triangle { <-55.7489, 248.2586, -4.5741>, <0.1804, 0.9250, -0.3345>, <-58.4777, 248.2586, -5.7128>, <0.0721, 0.9058, -0.4175>, <-60.5644, 249.6046, 0.0366>, <-0.0162, 0.9999, -0.0000> }
    smooth_triangle { <-58.4777, 248.2586, -5.7128>, <0.0721, 0.9058, -0.4175>, <-55.7489, 248.2586, -4.5741>, <0.1804, 0.9250, -0.3345>, <-50.5135, 244.4872, -8.2715>, <0.2858, 0.6754, -0.6798> }
    smooth_triangle { <-50.5135, 244.4872, -8.2715>, <0.2858, 0.6754, -0.6798>, <-56.9130, 244.4872, -10.3234>, <0.1189, 0.6230, -0.7731>, <-58.4777, 248.2586, -5.7128>, <0.0721, 0.9058, -0.4175> }
    smooth_triangle { <-56.9130, 244.4872, -10.3234>, <0.1189, 0.6230, -0.7731>, <-50.5135, 244.4872, -8.2715>, <0.2858, 0.6754, -0.6798>, <-48.5052, 239.0374, -10.3234>, <0.3254, 0.2414, -0.9142> }
    smooth_triangle { <-48.5052, 239.0374, -10.3234>, <0.3254, 0.2414, -0.9142>, <-57.6157, 239.0374, -12.8821>, <0.1372, 0.2137, -0.9672>, <-56.9130, 244.4872, -10.3234>, <0.1189, 0.6230, -0.7731> }
    smooth_triangle { <-57.6157, 239.0374, -12.8821>, <0.1372, 0.2137, -0.9672>, <-48.5052, 239.0374, -10.3234>, <0.3254, 0.2414, -0.9142>, <-48.5052, 232.9885, -10.3234>, <0.3254, -0.2414, -0.9142> }
    smooth_triangle { <-48.5052, 232.9885, -10.3234>, <0.3254, -0.2414, -0.9142>, <-57.6157, 232.9885, -12.8821>, <0.1372, -0.2137, -0.9672>, <-57.6157, 239.0374, -12.8821>, <0.1372, 0.2137, -0.9672> }
    smooth_triangle { <-57.6157, 232.9885, -12.8821>, <0.1372, -0.2137, -0.9672>, <-48.5052, 232.9885, -10.3234>, <0.3254, -0.2414, -0.9142>, <-50.5135, 227.5387, -8.2715>, <0.2858, -0.6754, -0.6798> }
    smooth_triangle { <-50.5135, 227.5387, -8.2715>, <0.2858, -0.6754, -0.6798>, <-56.9130, 227.5387, -10.3234>, <0.1189, -0.6230, -0.7731>, <-57.6157, 232.9885, -12.8821>, <0.1372, -0.2137, -0.9672> }
    smooth_triangle { <-56.9130, 227.5387, -10.3234>, <0.1189, -0.6230, -0.7731>, <-50.5135, 227.5387, -8.2715>, <0.2858, -0.6754, -0.6798>, <-55.7489, 223.7673, -4.5741>, <0.1804, -0.9250, -0.3345> }
    smooth_triangle { <-55.7489, 223.7673, -4.5741>, <0.1804, -0.9250, -0.3345>, <-58.4777, 223.7673, -5.7128>, <0.0721, -0.9058, -0.4175>, <-56.9130, 227.5387, -10.3234>, <0.1189, -0.6230, -0.7731> }
    smooth_triangle { <-58.4777, 223.7673, -5.7128>, <0.0721, -0.9058, -0.4175>, <-55.7489, 223.7673, -4.5741>, <0.1804, -0.9250, -0.3345>, <-60.5644, 222.4213, 0.0366>, <-0.0162, -0.9999, 0.0000> }
    smooth_triangle { <-60.5644, 222.4213, 0.0366>, <-0.0162, -0.9999, 0.0000>, <-60.5644, 222.4213, 0.0366>, <-0.0162, -0.9999, 0.0000>, <-58.4777, 223.7673, -5.7128>, <0.0721, -0.9058, -0.4175> }
    smooth_triangle { <-60.5644, 249.6046, 0.0366>, <-0.0162, 0.9999, -0.0000>, <-60.5644, 249.6046, 0.0366>, <-0.0162, 0.9999, -0.0000>, <-58.4777, 248.2586, -5.7128>, <0.0721, 0.9058, -0.4175> }
    smooth_triangle { <-58.4777, 248.2586, -5.7128>, <0.0721, 0.9058, -0.4175>, <-61.3560, 248.2586, -5.7128>, <-0.0926, 0.8999, -0.4262>, <-60.5644, 249.6046, 0.0366>, <-0.0162, 0.9999, -0.0000> }
    smooth_triangle { <-61.3560, 248.2586, -5.7128>, <-0.0926, 0.8999, -0.4262>, <-58.4777, 248.2586, -5.7128>, <0.0721, 0.9058, -0.4175>, <-56.9130, 244.4872, -10.3234>, <0.1189, 0.6230, -0.7731> }
    smooth_triangle { <-56.9130, 244.4872, -10.3234>, <0.1189, 0.6230, -0.7731>, <-62.3036, 244.4872, -10.3234>, <-0.1687, 0.6285, -0.7593>, <-61.3560, 248.2586, -5.7128>, <-0.0926, 0.8999, -0.4262> }
    smooth_triangle { <-62.3036, 244.4872, -10.3234>, <-0.1687, 0.6285, -0.7593>, <-56.9130, 244.4872, -10.3234>, <0.1189, 0.6230, -0.7731>, <-57.6157, 239.0374, -12.8821>, <0.1372, 0.2137, -0.9672> }
    smooth_triangle { <-57.6157, 239.0374, -12.8821>, <0.1372, 0.2137, -0.9672>, <-63.5130, 239.0374, -12.8821>, <-0.2194, 0.2296, -0.9482>, <-62.3036, 244.4872, -10.3234>, <-0.1687, 0.6285, -0.7593> }
    smooth_triangle { <-63.5130, 239.0374, -12.8821>, <-0.2194, 0.2296, -0.9482>, <-57.6157, 239.0374, -12.8821>, <0.1372, 0.2137, -0.9672>, <-57.6157, 232.9885, -12.8821>, <0.1372, -0.2137, -0.9672> }
    smooth_triangle { <-57.6157, 232.9885, -12.8821>, <0.1372, -0.2137, -0.9672>, <-63.5130, 232.9885, -12.8821>, <-0.2194, -0.2296, -0.9482>, <-63.5130, 239.0374, -12.8821>, <-0.2194, 0.2296, -0.9482> }
    smooth_triangle { <-63.5130, 232.9885, -12.8821>, <-0.2194, -0.2296, -0.9482>, <-57.6157, 232.9885, -12.8821>, <0.1372, -0.2137, -0.9672>, <-56.9130, 227.5387, -10.3234>, <0.1189, -0.6230, -0.7731> }
    smooth_triangle { <-56.9130, 227.5387, -10.3234>, <0.1189, -0.6230, -0.7731>, <-62.3036, 227.5387, -10.3234>, <-0.1687, -0.6285, -0.7593>, <-63.5130, 232.9885, -12.8821>, <-0.2194, -0.2296, -0.9482> }
    smooth_triangle { <-62.3036, 227.5387, -10.3234>, <-0.1687, -0.6285, -0.7593>, <-56.9130, 227.5387, -10.3234>, <0.1189, -0.6230, -0.7731>, <-58.4777, 223.7673, -5.7128>, <0.0721, -0.9058, -0.4175> }
    smooth_triangle { <-58.4777, 223.7673, -5.7128>, <0.0721, -0.9058, -0.4175>, <-61.3560, 223.7673, -5.7128>, <-0.0926, -0.8999, -0.4262>, <-62.3036, 227.5387, -10.3234>, <-0.1687, -0.6285, -0.7593> }
    smooth_triangle { <-61.3560, 223.7673, -5.7128>, <-0.0926, -0.8999, -0.4262>, <-58.4777, 223.7673, -5.7128>, <0.0721, -0.9058, -0.4175>, <-60.5644, 222.4213, 0.0366>, <-0.0162, -0.9999, 0.0000> }
    smooth_triangle { <-60.5644, 222.4213, 0.0366>, <-0.0162, -0.9999, 0.0000>, <-60.5644, 222.4213, 0.0366>, <-0.0162, -0.9999, 0.0000>, <-61.3560, 223.7673, -5.7128>, <-0.0926, -0.8999, -0.4262> }
    smooth_triangle { <-60.5644, 249.6046, 0.0366>, <-0.0162, 0.9999, -0.0000>, <-60.5644, 249.6046, 0.0366>, <-0.0162, 0.9999, -0.0000>, <-61.3560, 248.2586, -5.7128>, <-0.0926, 0.8999, -0.4262> }
    smooth_triangle { <-61.3560, 248.2586, -5.7128>, <-0.0926, 0.8999, -0.4262>, <-63.8770, 248.2586, -4.5741>, <-0.2633, 0.8995, -0.3487>, <-60.5644, 249.6046, 0.0366>, <-0.0162, 0.9999, -0.0000> }
    smooth_triangle { <-63.8770, 248.2586, -4.5741>, <-0.2633, 0.8995, -0.3487>, <-61.3560, 248.2586, -5.7128>, <-0.0926, 0.8999, -0.4262>, <-62.3036, 244.4872, -10.3234>, <-0.1687, 0.6285, -0.7593> }
    smooth_triangle { <-62.3036, 244.4872, -10.3234>, <-0.1687, 0.6285, -0.7593>, <-66.8092, 244.4872, -8.2715>, <-0.4711, 0.6323, -0.6150>, <-63.8770, 248.2586, -4.5741>, <-0.2633, 0.8995, -0.3487> }
    smooth_triangle { <-66.8092, 244.4872, -8.2715>, <-0.4711, 0.6323, -0.6150>, <-62.3036, 244.4872, -10.3234>, <-0.1687, 0.6285, -0.7593>, <-63.5130, 239.0374, -12.8821>, <-0.2194, 0.2296, -0.9482> }
    smooth_triangle { <-63.5130, 239.0374, -12.8821>, <-0.2194, 0.2296, -0.9482>, <-68.6220, 239.0374, -10.3234>, <-0.5999, 0.2332, -0.7654>, <-66.8092, 244.4872, -8.2715>, <-0.4711, 0.6323, -0.6150> }
    smooth_triangle { <-68.6220, 239.0374, -10.3234>, <-0.5999, 0.2332, -0.7654>, <-63.5130, 239.0374, -12.8821>, <-0.2194, 0.2296, -0.9482>, <-63.5130, 232.9885, -12.8821>, <-0.2194, -0.2296, -0.9482> }
    smooth_triangle { <-63.5130, 232.9885, -12.8821>, <-0.2194, -0.2296, -0.9482>, <-68.6220, 232.9885, -10.3234>, <-0.5999, -0.2332, -0.7654>, <-68.6220, 239.0374, -10.3234>, <-0.5999, 0.2332, -0.7654> }
    smooth_triangle { <-68.6220, 232.9885, -10.3234>, <-0.5999, -0.2332, -0.7654>, <-63.5130, 232.9885, -12.8821>, <-0.2194, -0.2296, -0.9482>, <-62.3036, 227.5387, -10.3234>, <-0.1687, -0.6285, -0.7593> }
    smooth_triangle { <-62.3036, 227.5387, -10.3234>, <-0.1687, -0.6285, -0.7593>, <-66.8092, 227.5387, -8.2715>, <-0.4711, -0.6323, -0.6150>, <-68.6220, 232.9885, -10.3234>, <-0.5999, -0.2332, -0.7654> }
    smooth_triangle { <-66.8092, 227.5387, -8.2715>, <-0.4711, -0.6323, -0.6150>, <-62.3036, 227.5387, -10.3234>, <-0.1687, -0.6285, -0.7593>, <-61.3560, 223.7673, -5.7128>, <-0.0926, -0.8999, -0.4262> }
    smooth_triangle { <-61.3560, 223.7673, -5.7128>, <-0.0926, -0.8999, -0.4262>, <-63.8770, 223.7673, -4.5741>, <-0.2633, -0.8995, -0.3487>, <-66.8092, 227.5387, -8.2715>, <-0.4711, -0.6323, -0.6150> }
    smooth_triangle { <-63.8770, 223.7673, -4.5741>, <-0.2633, -0.8995, -0.3487>, <-61.3560, 223.7673, -5.7128>, <-0.0926, -0.8999, -0.4262>, <-60.5644, 222.4213, 0.0366>, <-0.0162, -0.9999, 0.0000> }
    smooth_triangle { <-60.5644, 222.4213, 0.0366>, <-0.0162, -0.9999, 0.0000>, <-60.5644, 222.4213, 0.0366>, <-0.0162, -0.9999, 0.0000>, <-63.8770, 223.7673, -4.5741>, <-0.2633, -0.8995, -0.3487> }
    smooth_triangle { <-60.5644, 249.6046, 0.0366>, <-0.0162, 0.9999, -0.0000>, <-60.5644, 249.6046, 0.0366>, <-0.0162, 0.9999, -0.0000>, <-63.8770, 248.2586, -4.5741>, <-0.2633, 0.8995, -0.3487> }
    smooth_triangle { <-63.8770, 248.2586, -4.5741>, <-0.2633, 0.8995, -0.3487>, <-65.6019, 248.2586, -2.5221>, <-0.3862, 0.9012, -0.1965>, <-60.5644, 249.6046, 0.0366>, <-0.0162, 0.9999, -0.0000> }
    smooth_triangle { <-65.6019, 248.2586, -2.5221>, <-0.3862, 0.9012, -0.1965>, <-63.8770, 248.2586, -4.5741>, <-0.2633, 0.8995, -0.3487>, <-66.8092, 244.4872, -8.2715>, <-0.4711, 0.6323, -0.6150> }
    smooth_triangle { <-66.8092, 244.4872, -8.2715>, <-0.4711, 0.6323, -0.6150>, <-69.9640, 244.4872, -4.5741>, <-0.6888, 0.6353, -0.3492>, <-65.6019, 248.2586, -2.5221>, <-0.3862, 0.9012, -0.1965> }
    smooth_triangle { <-69.9640, 244.4872, -4.5741>, <-0.6888, 0.6353, -0.3492>, <-66.8092, 244.4872, -8.2715>, <-0.4711, 0.6323, -0.6150>, <-68.6220, 239.0374, -10.3234>, <-0.5999, 0.2332, -0.7654> }
    smooth_triangle { <-68.6220, 239.0374, -10.3234>, <-0.5999, 0.2332, -0.7654>, <-72.4712, 239.0374, -5.7128>, <-0.8694, 0.2324, -0.4360>, <-69.9640, 244.4872, -4.5741>, <-0.6888, 0.6353, -0.3492> }
    smooth_triangle { <-72.4712, 239.0374, -5.7128>, <-0.8694, 0.2324, -0.4360>, <-68.6220, 239.0374, -10.3234>, <-0.5999, 0.2332, -0.7654>, <-68.6220, 232.9885, -10.3234>, <-0.5999, -0.2332, -0.7654> }
    smooth_triangle { <-68.6220, 232.9885, -10.3234>, <-0.5999, -0.2332, -0.7654>, <-72.4712, 232.9885, -5.7128>, <-0.8694, -0.2324, -0.4360>, <-72.4712, 239.0374, -5.7128>, <-0.8694, 0.2324, -0.4360> }
    smooth_triangle { <-72.4712, 232.9885, -5.7128>, <-0.8694, -0.2324, -0.4360>, <-68.6220, 232.9885, -10.3234>, <-0.5999, -0.2332, -0.7654>, <-66.8092, 227.5387, -8.2715>, <-0.4711, -0.6323, -0.6150> }
    smooth_triangle { <-66.8092, 227.5387, -8.2715>, <-0.4711, -0.6323, -0.6150>, <-69.9640, 227.5387, -4.5741>, <-0.6888, -0.6353, -0.3492>, <-72.4712, 232.9885, -5.7128>, <-0.8694, -0.2324, -0.4360> }
    smooth_triangle { <-69.9640, 227.5387, -4.5741>, <-0.6888, -0.6353, -0.3492>, <-66.8092, 227.5387, -8.2715>, <-0.4711, -0.6323, -0.6150>, <-63.8770, 223.7673, -4.5741>, <-0.2633, -0.8995, -0.3487> }
    smooth_triangle { <-63.8770, 223.7673, -4.5741>, <-0.2633, -0.8995, -0.3487>, <-65.6019, 223.7673, -2.5221>, <-0.3862, -0.9012, -0.1965>, <-69.9640, 227.5387, -4.5741>, <-0.6888, -0.6353, -0.3492> }
    smooth_triangle { <-65.6019, 223.7673, -2.5221>, <-0.3862, -0.9012, -0.1965>, <-63.8770, 223.7673, -4.5741>, <-0.2633, -0.8995, -0.3487>, <-60.5644, 222.4213, 0.0366>, <-0.0162, -0.9999, 0.0000> }
    smooth_triangle { <-60.5644, 222.4213, 0.0366>, <-0.0162, -0.9999, 0.0000>, <-60.5644, 222.4213, 0.0366>, <-0.0162, -0.9999, 0.0000>, <-65.6019, 223.7673, -2.5221>, <-0.3862, -0.9012, -0.1965> }
    smooth_triangle { <-60.5644, 249.6046, 0.0366>, <-0.0162, 0.9999, -0.0000>, <-60.5644, 249.6046, 0.0366>, <-0.0162, 0.9999, -0.0000>, <-65.6019, 248.2586, -2.5221>, <-0.3862, 0.9012, -0.1965> }
    smooth_triangle { <-65.6019, 248.2586, -2.5221>, <-0.3862, 0.9012, -0.1965>, <-66.2153, 248.2586, 0.0366>, <-0.4310, 0.9024, -0.0000>, <-60.5644, 249.6046, 0.0366>, <-0.0162, 0.9999, -0.0000> }
    smooth_triangle { <-66.2153, 248.2586, 0.0366>, <-0.4310, 0.9024, -0.0000>, <-65.6019, 248.2586, -2.5221>, <-0.3862, 0.9012, -0.1965>, <-69.9640, 244.4872, -4.5741>, <-0.6888, 0.6353, -0.3492> }
    smooth_triangle { <-69.9640, 244.4872, -4.5741>, <-0.6888, 0.6353, -0.3492>, <-71.0889, 244.4872, 0.0366>, <-0.7707, 0.6372, -0.0000>, <-66.2153, 248.2586, 0.0366>, <-0.4310, 0.9024, -0.0000> }
    smooth_triangle { <-71.0889, 244.4872, 0.0366>, <-0.7707, 0.6372, -0.0000>, <-69.9640, 244.4872, -4.5741>, <-0.6888, 0.6353, -0.3492>, <-72.4712, 239.0374, -5.7128>, <-0.8694, 0.2324, -0.4360> }
    smooth_triangle { <-72.4712, 239.0374, -5.7128>, <-0.8694, 0.2324, -0.4360>, <-73.8153, 239.0374, 0.0366>, <-0.9727, 0.2322, -0.0000>, <-71.0889, 244.4872, 0.0366>, <-0.7707, 0.6372, -0.0000> }
    smooth_triangle { <-73.8153, 239.0374, 0.0366>, <-0.9727, 0.2322, -0.0000>, <-72.4712, 239.0374, -5.7128>, <-0.8694, 0.2324, -0.4360>, <-72.4712, 232.9885, -5.7128>, <-0.8694, -0.2324, -0.4360> }
    smooth_triangle { <-72.4712, 232.9885, -5.7128>, <-0.8694, -0.2324, -0.4360>, <-73.8153, 232.9885, 0.0366>, <-0.9727, -0.2322, -0.0000>, <-73.8153, 239.0374, 0.0366>, <-0.9727, 0.2322, -0.0000> }
    smooth_triangle { <-73.8153, 232.9885, 0.0366>, <-0.9727, -0.2322, -0.0000>, <-72.4712, 232.9885, -5.7128>, <-0.8694, -0.2324, -0.4360>, <-69.9640, 227.5387, -4.5741>, <-0.6888, -0.6353, -0.3492> }
    smooth_triangle { <-69.9640, 227.5387, -4.5741>, <-0.6888, -0.6353, -0.3492>, <-71.0889, 227.5387, 0.0366>, <-0.7707, -0.6372, 0.0000>, <-73.8153, 232.9885, 0.0366>, <-0.9727, -0.2322, -0.0000> }
    smooth_triangle { <-71.0889, 227.5387, 0.0366>, <-0.7707, -0.6372, 0.0000>, <-69.9640, 227.5387, -4.5741>, <-0.6888, -0.6353, -0.3492>, <-65.6019, 223.7673, -2.5221>, <-0.3862, -0.9012, -0.1965> }
    smooth_triangle { <-65.6019, 223.7673, -2.5221>, <-0.3862, -0.9012, -0.1965>, <-66.2153, 223.7673, 0.0366>, <-0.4310, -0.9024, 0.0000>, <-71.0889, 227.5387, 0.0366>, <-0.7707, -0.6372, 0.0000> }
    smooth_triangle { <-66.2153, 223.7673, 0.0366>, <-0.4310, -0.9024, 0.0000>, <-65.6019, 223.7673, -2.5221>, <-0.3862, -0.9012, -0.1965>, <-60.5644, 222.4213, 0.0366>, <-0.0162, -0.9999, 0.0000> }
    smooth_triangle { <-60.5644, 222.4213, 0.0366>, <-0.0162, -0.9999, 0.0000>, <-60.5644, 222.4213, 0.0366>, <-0.0162, -0.9999, 0.0000>, <-66.2153, 223.7673, 0.0366>, <-0.4310, -0.9024, 0.0000> }
    smooth_triangle { <-60.5644, 249.6046, 0.0366>, <-0.0162, 0.9999, -0.0000>, <-60.5644, 249.6046, 0.0366>, <-0.0162, 0.9999, -0.0000>, <-66.2153, 248.2586, 0.0366>, <-0.4310, 0.9024, -0.0000> }
    smooth_triangle { <-66.2153, 248.2586, 0.0366>, <-0.4310, 0.9024, -0.0000>, <-65.6019, 248.2586, 2.5953>, <-0.3862, 0.9012, 0.1965>, <-60.5644, 249.6046, 0.0366>, <-0.0162, 0.9999, -0.0000> }
    smooth_triangle { <-65.6019, 248.2586, 2.5953>, <-0.3862, 0.9012, 0.1965>, <-66.2153, 248.2586, 0.0366>, <-0.4310, 0.9024, -0.0000>, <-71.0889, 244.4872, 0.0366>, <-0.7707, 0.6372, -0.0000> }
    smooth_triangle { <-71.0889, 244.4872, 0.0366>, <-0.7707, 0.6372, -0.0000>, <-69.9640, 244.4872, 4.6472>, <-0.6888, 0.6353, 0.3492>, <-65.6019, 248.2586, 2.5953>, <-0.3862, 0.9012, 0.1965> }
    smooth_triangle { <-69.9640, 244.4872, 4.6472>, <-0.6888, 0.6353, 0.3492>, <-71.0889, 244.4872, 0.0366>, <-0.7707, 0.6372, -0.0000>, <-73.8153, 239.0374, 0.0366>, <-0.9727, 0.2322, -0.0000> }
    smooth_triangle { <-73.8153, 239.0374, 0.0366>, <-0.9727, 0.2322, -0.0000>, <-72.4712, 239.0374, 5.7859>, <-0.8694, 0.2324, 0.4360>, <-69.9640, 244.4872, 4.6472>, <-0.6888, 0.6353, 0.3492> }
    smooth_triangle { <-72.4712, 239.0374, 5.7859>, <-0.8694, 0.2324, 0.4360>, <-73.8153, 239.0374, 0.0366>, <-0.9727, 0.2322, -0.0000>, <-73.8153, 232.9885, 0.0366>, <-0.9727, -0.2322, -0.0000> }
    smooth_triangle { <-73.8153, 232.9885, 0.0366>, <-0.9727, -0.2322, -0.0000>, <-72.4712, 232.9885, 5.7859>, <-0.8694, -0.2324, 0.4360>, <-72.4712, 239.0374, 5.7859>, <-0.8694, 0.2324, 0.4360> }
    smooth_triangle { <-72.4712, 232.9885, 5.7859>, <-0.8694, -0.2324, 0.4360>, <-73.8153, 232.9885, 0.0366>, <-0.9727, -0.2322, -0.0000>, <-71.0889, 227.5387, 0.0366>, <-0.7707, -0.6372, 0.0000> }
    smooth_triangle { <-71.0889, 227.5387, 0.0366>, <-0.7707, -0.6372, 0.0000>, <-69.9640, 227.5387, 4.6472>, <-0.6888, -0.6353, 0.3492>, <-72.4712, 232.9885, 5.7859>, <-0.8694, -0.2324, 0.4360> }
    smooth_triangle { <-69.9640, 227.5387, 4.6472>, <-0.6888, -0.6353, 0.3492>, <-71.0889, 227.5387, 0.0366>, <-0.7707, -0.6372, 0.0000>, <-66.2153, 223.7673, 0.0366>, <-0.4310, -0.9024, 0.0000> }
    smooth_triangle { <-66.2153, 223.7673, 0.0366>, <-0.4310, -0.9024, 0.0000>, <-65.6019, 223.7673, 2.5953>, <-0.3862, -0.9012, 0.1965>, <-69.9640, 227.5387, 4.6472>, <-0.6888, -0.6353, 0.3492> }
    smooth_triangle { <-65.6019, 223.7673, 2.5953>, <-0.3862, -0.9012, 0.1965>, <-66.2153, 223.7673, 0.0366>, <-0.4310, -0.9024, 0.0000>, <-60.5644, 222.4213, 0.0366>, <-0.0162, -0.9999, 0.0000> }
    smooth_triangle { <-60.5644, 222.4213, 0.0366>, <-0.0162, -0.9999, 0.0000>, <-60.5644, 222.4213, 0.0366>, <-0.0162, -0.9999, 0.0000>, <-65.6019, 223.7673, 2.5953>, <-0.3862, -0.9012, 0.1965> }
    smooth_triangle { <-60.5644, 249.6046, 0.0366>, <-0.0162, 0.9999, -0.0000>, <-60.5644, 249.6046, 0.0366>, <-0.0162, 0.9999, -0.0000>, <-65.6019, 248.2586, 2.5953>, <-0.3862, 0.9012, 0.1965> }
    smooth_triangle { <-65.6019, 248.2586, 2.5953>, <-0.3862, 0.9012, 0.1965>, <-63.8770, 248.2586, 4.6472>, <-0.2633, 0.8995, 0.3487>, <-60.5644, 249.6046, 0.0366>, <-0.0162, 0.9999, -0.0000> }
    smooth_triangle { <-63.8770, 248.2586, 4.6472>, <-0.2633, 0.8995, 0.3487>, <-65.6019, 248.2586, 2.5953>, <-0.3862, 0.9012, 0.1965>, <-69.9640, 244.4872, 4.6472>, <-0.6888, 0.6353, 0.3492> }
    smooth_triangle { <-69.9640, 244.4872, 4.6472>, <-0.6888, 0.6353, 0.3492>, <-66.8092, 244.4872, 8.3446>, <-0.4711, 0.6323, 0.6150>, <-63.8770, 248.2586, 4.6472>, <-0.2633, 0.8995, 0.3487> }
    smooth_triangle { <-66.8092, 244.4872, 8.3446>, <-0.4711, 0.6323, 0.6150>, <-69.9640, 244.4872, 4.6472>, <-0.6888, 0.6353, 0.3492>, <-72.4712, 239.0374, 5.7859>, <-0.8694, 0.2324, 0.4360> }
    smooth_triangle { <-72.4712, 239.0374, 5.7859>, <-0.8694, 0.2324, 0.4360>, <-68.6220, 239.0374, 10.3965>, <-0.5999, 0.2332, 0.7654>, <-66.8092, 244.4872, 8.3446>, <-0.4711, 0.6323, 0.6150> }
    smooth_triangle { <-68.6220, 239.0374, 10.3965>, <-0.5999, 0.2332, 0.7654>, <-72.4712, 239.0374, 5.7859>, <-0.8694, 0.2324, 0.4360>, <-72.4712, 232.9885, 5.7859>, <-0.8694, -0.2324, 0.4360> }
    smooth_triangle { <-72.4712, 232.9885, 5.7859>, <-0.8694, -0.2324, 0.4360>, <-68.6220, 232.9885, 10.3965>, <-0.5999, -0.2332, 0.7654>, <-68.6220, 239.0374, 10.3965>, <-0.5999, 0.2332, 0.7654> }
    smooth_triangle { <-68.6220, 232.9885, 10.3965>, <-0.5999, -0.2332, 0.7654>, <-72.4712, 232.9885, 5.7859>, <-0.8694, -0.2324, 0.4360>, <-69.9640, 227.5387, 4.6472>, <-0.6888, -0.6353, 0.3492> }
    smooth_triangle { <-69.9640, 227.5387, 4.6472>, <-0.6888, -0.6353, 0.3492>, <-66.8092, 227.5387, 8.3446>, <-0.4711, -0.6323, 0.6150>, <-68.6220, 232.9885, 10.3965>, <-0.5999, -0.2332, 0.7654> }
    smooth_triangle { <-66.8092, 227.5387, 8.3446>, <-0.4711, -0.6323, 0.6150>, <-69.9640, 227.5387, 4.6472>, <-0.6888, -0.6353, 0.3492>, <-65.6019, 223.7673, 2.5953>, <-0.3862, -0.9012, 0.1965> }
    smooth_triangle { <-65.6019, 223.7673, 2.5953>, <-0.3862, -0.9012, 0.1965>, <-63.8770, 223.7673, 4.6472>, <-0.2633, -0.8995, 0.3487>, <-66.8092, 227.5387, 8.3446>, <-0.4711, -0.6323, 0.6150> }
    smooth_triangle { <-63.8770, 223.7673, 4.6472>, <-0.2633, -0.8995, 0.3487>, <-65.6019, 223.7673, 2.5953>, <-0.3862, -0.9012, 0.1965>, <-60.5644, 222.4213, 0.0366>, <-0.0162, -0.9999, 0.0000> }
    smooth_triangle { <-60.5644, 222.4213, 0.0366>, <-0.0162, -0.9999, 0.0000>, <-60.5644, 222.4213, 0.0366>, <-0.0162, -0.9999, 0.0000>, <-63.8770, 223.7673, 4.6472>, <-0.2633, -0.8995, 0.3487> }
    smooth_triangle { <-60.5644, 249.6046, 0.0366>, <-0.0162, 0.9999, -0.0000>, <-60.5644, 249.6046, 0.0366>, <-0.0162, 0.9999, -0.0000>, <-63.8770, 248.2586, 4.6472>, <-0.2633, 0.8995, 0.3487> }
    smooth_triangle { <-63.8770, 248.2586, 4.6472>, <-0.2633, 0.8995, 0.3487>, <-61.3560, 248.2587, 5.7859>, <-0.0926, 0.8999, 0.4262>, <-60.5644, 249.6046, 0.0366>, <-0.0162, 0.9999, -0.0000> }
    smooth_triangle { <-61.3560, 248.2587, 5.7859>, <-0.0926, 0.8999, 0.4262>, <-63.8770, 248.2586, 4.6472>, <-0.2633, 0.8995, 0.3487>, <-66.8092, 244.4872, 8.3446>, <-0.4711, 0.6323, 0.6150> }
    smooth_triangle { <-66.8092, 244.4872, 8.3446>, <-0.4711, 0.6323, 0.6150>, <-62.3036, 244.4872, 10.3965>, <-0.1687, 0.6285, 0.7593>, <-61.3560, 248.2587, 5.7859>, <-0.0926, 0.8999, 0.4262> }
    smooth_triangle { <-62.3036, 244.4872, 10.3965>, <-0.1687, 0.6285, 0.7593>, <-66.8092, 244.4872, 8.3446>, <-0.4711, 0.6323, 0.6150>, <-68.6220, 239.0374, 10.3965>, <-0.5999, 0.2332, 0.7654> }
    smooth_triangle { <-68.6220, 239.0374, 10.3965>, <-0.5999, 0.2332, 0.7654>, <-63.5130, 239.0374, 12.9553>, <-0.2194, 0.2296, 0.9482>, <-62.3036, 244.4872, 10.3965>, <-0.1687, 0.6285, 0.7593> }
    smooth_triangle { <-63.5130, 239.0374, 12.9553>, <-0.2194, 0.2296, 0.9482>, <-68.6220, 239.0374, 10.3965>, <-0.5999, 0.2332, 0.7654>, <-68.6220, 232.9885, 10.3965>, <-0.5999, -0.2332, 0.7654> }
    smooth_triangle { <-68.6220, 232.9885, 10.3965>, <-0.5999, -0.2332, 0.7654>, <-63.5130, 232.9885, 12.9553>, <-0.2194, -0.2296, 0.9482>, <-63.5130, 239.0374, 12.9553>, <-0.2194, 0.2296, 0.9482> }
    smooth_triangle { <-63.5130, 232.9885, 12.9553>, <-0.2194, -0.2296, 0.9482>, <-68.6220, 232.9885, 10.3965>, <-0.5999, -0.2332, 0.7654>, <-66.8092, 227.5387, 8.3446>, <-0.4711, -0.6323, 0.6150> }
    smooth_triangle { <-66.8092, 227.5387, 8.3446>, <-0.4711, -0.6323, 0.6150>, <-62.3036, 227.5387, 10.3965>, <-0.1687, -0.6285, 0.7593>, <-63.5130, 232.9885, 12.9553>, <-0.2194, -0.2296, 0.9482> }
    smooth_triangle { <-62.3036, 227.5387, 10.3965>, <-0.1687, -0.6285, 0.7593>, <-66.8092, 227.5387, 8.3446>, <-0.4711, -0.6323, 0.6150>, <-63.8770, 223.7673, 4.6472>, <-0.2633, -0.8995, 0.3487> }
    smooth_triangle { <-63.8770, 223.7673, 4.6472>, <-0.2633, -0.8995, 0.3487>, <-61.3560, 223.7673, 5.7859>, <-0.0926, -0.8999, 0.4262>, <-62.3036, 227.5387, 10.3965>, <-0.1687, -0.6285, 0.7593> }
    smooth_triangle { <-61.3560, 223.7673, 5.7859>, <-0.0926, -0.8999, 0.4262>, <-63.8770, 223.7673, 4.6472>, <-0.2633, -0.8995, 0.3487>, <-60.5644, 222.4213, 0.0366>, <-0.0162, -0.9999, 0.0000> }
    smooth_triangle { <-60.5644, 222.4213, 0.0366>, <-0.0162, -0.9999, 0.0000>, <-60.5644, 222.4213, 0.0366>, <-0.0162, -0.9999, 0.0000>, <-61.3560, 223.7673, 5.7859>, <-0.0926, -0.8999, 0.4262> }
    smooth_triangle { <-60.5644, 249.6046, 0.0366>, <-0.0162, 0.9999, -0.0000>, <-60.5644, 249.6046, 0.0366>, <-0.0162, 0.9999, -0.0000>, <-61.3560, 248.2587, 5.7859>, <-0.0926, 0.8999, 0.4262> }
    smooth_triangle { <-61.3560, 248.2587, 5.7859>, <-0.0926, 0.8999, 0.4262>, <-58.4777, 248.2586, 5.7859>, <0.0721, 0.9058, 0.4175>, <-60.5644, 249.6046, 0.0366>, <-0.0162, 0.9999, -0.0000> }
    smooth_triangle { <-58.4777, 248.2586, 5.7859>, <0.0721, 0.9058, 0.4175>, <-61.3560, 248.2587, 5.7859>, <-0.0926, 0.8999, 0.4262>, <-62.3036, 244.4872, 10.3965>, <-0.1687, 0.6285, 0.7593> }
    smooth_triangle { <-62.3036, 244.4872, 10.3965>, <-0.1687, 0.6285, 0.7593>, <-56.9130, 244.4872, 10.3965>, <0.1189, 0.6230, 0.7731>, <-58.4777, 248.2586, 5.7859>, <0.0721, 0.9058, 0.4175> }
    smooth_triangle { <-56.9130, 244.4872, 10.3965>, <0.1189, 0.6230, 0.7731>, <-62.3036, 244.4872, 10.3965>, <-0.1687, 0.6285, 0.7593>, <-63.5130, 239.0374, 12.9553>, <-0.2194, 0.2296, 0.9482> }
    smooth_triangle { <-63.5130, 239.0374, 12.9553>, <-0.2194, 0.2296, 0.9482>, <-57.6157, 239.0374, 12.9553>, <0.1372, 0.2137, 0.9672>, <-56.9130, 244.4872, 10.3965>, <0.1189, 0.6230, 0.7731> }
    smooth_triangle { <-57.6157, 239.0374, 12.9553>, <0.1372, 0.2137, 0.9672>, <-63.5130, 239.0374, 12.9553>, <-0.2194, 0.2296, 0.9482>, <-63.5130, 232.9885, 12.9553>, <-0.2194, -0.2296, 0.9482> }
    smooth_triangle { <-63.5130, 232.9885, 12.9553>, <-0.2194, -0.2296, 0.9482>, <-57.6157, 232.9885, 12.9553>, <0.1372, -0.2137, 0.9672>, <-57.6157, 239.0374, 12.9553>, <0.1372, 0.2137, 0.9672> }
    smooth_triangle { <-57.6157, 232.9885, 12.9553>, <0.1372, -0.2137, 0.9672>, <-63.5130, 232.9885, 12.9553>, <-0.2194, -0.2296, 0.9482>, <-62.3036, 227.5387, 10.3965>, <-0.1687, -0.6285, 0.7593> }
    smooth_triangle { <-62.3036, 227.5387, 10.3965>, <-0.1687, -0.6285, 0.7593>, <-56.9130, 227.5387, 10.3965>, <0.1189, -0.6230, 0.7731>, <-57.6157, 232.9885, 12.9553>, <0.1372, -0.2137, 0.9672> }
    smooth_triangle { <-56.9130, 227.5387, 10.3965>, <0.1189, -0.6230, 0.7731>, <-62.3036, 227.5387, 10.3965>, <-0.1687, -0.6285, 0.7593>, <-61.3560, 223.7673, 5.7859>, <-0.0926, -0.8999, 0.4262> }
    smooth_triangle { <-61.3560, 223.7673, 5.7859>, <-0.0926, -0.8999, 0.4262>, <-58.4777, 223.7673, 5.7859>, <0.0721, -0.9058, 0.4175>, <-56.9130, 227.5387, 10.3965>, <0.1189, -0.6230, 0.7731> }
    smooth_triangle { <-58.4777, 223.7673, 5.7859>, <0.0721, -0.9058, 0.4175>, <-61.3560, 223.7673, 5.7859>, <-0.0926, -0.8999, 0.4262>, <-60.5644, 222.4213, 0.0366>, <-0.0162, -0.9999, 0.0000> }
    smooth_triangle { <-60.5644, 222.4213, 0.0366>, <-0.0162, -0.9999, 0.0000>, <-60.5644, 222.4213, 0.0366>, <-0.0162, -0.9999, 0.0000>, <-58.4777, 223.7673, 5.7859>, <0.0721, -0.9058, 0.4175> }
    smooth_triangle { <-60.5644, 249.6046, 0.0366>, <-0.0162, 0.9999, -0.0000>, <-60.5644, 249.6046, 0.0366>, <-0.0162, 0.9999, -0.0000>, <-58.4777, 248.2586, 5.7859>, <0.0721, 0.9058, 0.4175> }
    smooth_triangle { <-58.4777, 248.2586, 5.7859>, <0.0721, 0.9058, 0.4175>, <-55.7489, 248.2586, 4.6472>, <0.1804, 0.9250, 0.3345>, <-60.5644, 249.6046, 0.0366>, <-0.0162, 0.9999, -0.0000> }
    smooth_triangle { <-55.7489, 248.2586, 4.6472>, <0.1804, 0.9250, 0.3345>, <-58.4777, 248.2586, 5.7859>, <0.0721, 0.9058, 0.4175>, <-56.9130, 244.4872, 10.3965>, <0.1189, 0.6230, 0.7731> }
    smooth_triangle { <-56.9130, 244.4872, 10.3965>, <0.1189, 0.6230, 0.7731>, <-50.5135, 244.4872, 8.3446>, <0.2858, 0.6754, 0.6798>, <-55.7489, 248.2586, 4.6472>, <0.1804, 0.9250, 0.3345> }
    smooth_triangle { <-50.5135, 244.4872, 8.3446>, <0.2858, 0.6754, 0.6798>, <-56.9130, 244.4872, 10.3965>, <0.1189, 0.6230, 0.7731>, <-57.6157, 239.0374, 12.9553>, <0.1372, 0.2137, 0.9672> }
    smooth_triangle { <-57.6157, 239.0374, 12.9553>, <0.1372, 0.2137, 0.9672>, <-48.5052, 239.0374, 10.3965>, <0.3254, 0.2414, 0.9142>, <-50.5135, 244.4872, 8.3446>, <0.2858, 0.6754, 0.6798> }
    smooth_triangle { <-48.5052, 239.0374, 10.3965>, <0.3254, 0.2414, 0.9142>, <-57.6157, 239.0374, 12.9553>, <0.1372, 0.2137, 0.9672>, <-57.6157, 232.9885, 12.9553>, <0.1372, -0.2137, 0.9672> }
    smooth_triangle { <-57.6157, 232.9885, 12.9553>, <0.1372, -0.2137, 0.9672>, <-48.5052, 232.9885, 10.3965>, <0.3254, -0.2414, 0.9142>, <-48.5052, 239.0374, 10.3965>, <0.3254, 0.2414, 0.9142> }
    smooth_triangle { <-48.5052, 232.9885, 10.3965>, <0.3254, -0.2414, 0.9142>, <-57.6157, 232.9885, 12.9553>, <0.1372, -0.2137, 0.9672>, <-56.9130, 227.5387, 10.3965>, <0.1189, -0.6230, 0.7731> }
    smooth_triangle { <-56.9130, 227.5387, 10.3965>, <0.1189, -0.6230, 0.7731>, <-50.5135, 227.5387, 8.3446>, <0.2858, -0.6754, 0.6798>, <-48.5052, 232.9885, 10.3965>, <0.3254, -0.2414, 0.9142> }
    smooth_triangle { <-50.5135, 227.5387, 8.3446>, <0.2858, -0.6754, 0.6798>, <-56.9130, 227.5387, 10.3965>, <0.1189, -0.6230, 0.7731>, <-58.4777, 223.7673, 5.7859>, <0.0721, -0.9058, 0.4175> }
    smooth_triangle { <-58.4777, 223.7673, 5.7859>, <0.0721, -0.9058, 0.4175>, <-55.7489, 223.7673, 4.6472>, <0.1804, -0.9250, 0.3345>, <-50.5135, 227.5387, 8.3446>, <0.2858, -0.6754, 0.6798> }
    smooth_triangle { <-55.7489, 223.7673, 4.6472>, <0.1804, -0.9250, 0.3345>, <-58.4777, 223.7673, 5.7859>, <0.0721, -0.9058, 0.4175>, <-60.5644, 222.4213, 0.0366>, <-0.0162, -0.9999, 0.0000> }
    smooth_triangle { <-60.5644, 222.4213, 0.0366>, <-0.0162, -0.9999, 0.0000>, <-60.5644, 222.4213, 0.0366>, <-0.0162, -0.9999, 0.0000>, <-55.7489, 223.7673, 4.6472>, <0.1804, -0.9250, 0.3345> }
    smooth_triangle { <-60.5644, 249.6046, 0.0366>, <-0.0162, 0.9999, -0.0000>, <-60.5644, 249.6046, 0.0366>, <-0.0162, 0.9999, -0.0000>, <-55.7489, 248.2586, 4.6472>, <0.1804, 0.9250, 0.3345> }
    smooth_triangle { <-55.7489, 248.2586, 4.6472>, <0.1804, 0.9250, 0.3345>, <-53.7435, 248.2586, 2.5953>, <0.2335, 0.9534, 0.1912>, <-60.5644, 249.6046, 0.0366>, <-0.0162, 0.9999, -0.0000> }
    smooth_triangle { <-53.7435, 248.2586, 2.5953>, <0.2335, 0.9534, 0.1912>, <-55.7489, 248.2586, 4.6472>, <0.1804, 0.9250, 0.3345>, <-50.5135, 244.4872, 8.3446>, <0.2858, 0.6754, 0.6798> }
    smooth_triangle { <-50.5135, 244.4872, 8.3446>, <0.2858, 0.6754, 0.6798>, <-44.2684, 244.4872, 4.6472>, <0.3718, 0.8139, 0.4465>, <-53.7435, 248.2586, 2.5953>, <0.2335, 0.9534, 0.1912> }
    smooth_triangle { <-44.2684, 244.4872, 4.6472>, <0.3718, 0.8139, 0.4465>, <-50.5135, 244.4872, 8.3446>, <0.2858, 0.6754, 0.6798>, <-48.5052, 239.0374, 10.3965>, <0.3254, 0.2414, 0.9142> }
    smooth_triangle { <-48.5052, 239.0374, 10.3965>, <0.3254, 0.2414, 0.9142>, <-36.9268, 239.0374, 5.7859>, <0.5241, 0.3664, 0.7688>, <-44.2684, 244.4872, 4.6472>, <0.3718, 0.8139, 0.4465> }
    smooth_triangle { <-36.9268, 239.0374, 5.7859>, <0.5241, 0.3664, 0.7688>, <-48.5052, 239.0374, 10.3965>, <0.3254, 0.2414, 0.9142>, <-48.5052, 232.9885, 10.3965>, <0.3254, -0.2414, 0.9142> }
    smooth_triangle { <-48.5052, 232.9885, 10.3965>, <0.3254, -0.2414, 0.9142>, <-36.9268, 232.9885, 5.7859>, <0.5241, -0.3664, 0.7688>, <-36.9268, 239.0374, 5.7859>, <0.5241, 0.3664, 0.7688> }
    smooth_triangle { <-36.9268, 232.9885, 5.7859>, <0.5241, -0.3664, 0.7688>, <-48.5052, 232.9885, 10.3965>, <0.3254, -0.2414, 0.9142>, <-50.5135, 227.5387, 8.3446>, <0.2858, -0.6754, 0.6798> }
    smooth_triangle { <-50.5135, 227.5387, 8.3446>, <0.2858, -0.6754, 0.6798>, <-44.2684, 227.5387, 4.6472>, <0.3718, -0.8139, 0.4465>, <-36.9268, 232.9885, 5.7859>, <0.5241, -0.3664, 0.7688> }
    smooth_triangle { <-44.2684, 227.5387, 4.6472>, <0.3718, -0.8139, 0.4465>, <-50.5135, 227.5387, 8.3446>, <0.2858, -0.6754, 0.6798>, <-55.7489, 223.7673, 4.6472>, <0.1804, -0.9250, 0.3345> }
    smooth_triangle { <-55.7489, 223.7673, 4.6472>, <0.1804, -0.9250, 0.3345>, <-53.7435, 223.7673, 2.5953>, <0.2335, -0.9534, 0.1912>, <-44.2684, 227.5387, 4.6472>, <0.3718, -0.8139, 0.4465> }
    smooth_triangle { <-53.7435, 223.7673, 2.5953>, <0.2335, -0.9534, 0.1912>, <-55.7489, 223.7673, 4.6472>, <0.1804, -0.9250, 0.3345>, <-60.5644, 222.4213, 0.0366>, <-0.0162, -0.9999, 0.0000> }
    smooth_triangle { <-60.5644, 222.4213, 0.0366>, <-0.0162, -0.9999, 0.0000>, <-60.5644, 222.4213, 0.0366>, <-0.0162, -0.9999, 0.0000>, <-53.7435, 223.7673, 2.5953>, <0.2335, -0.9534, 0.1912> }
    smooth_triangle { <-60.5644, 249.6046, 0.0366>, <-0.0162, 0.9999, -0.0000>, <-60.5644, 249.6046, 0.0366>, <-0.0162, 0.9999, -0.0000>, <-53.7435, 248.2586, 2.5953>, <0.2335, 0.9534, 0.1912> }
    smooth_triangle { <-53.7435, 248.2586, 2.5953>, <0.2335, 0.9534, 0.1912>, <-52.9976, 248.2586, 0.0366>, <0.2503, 0.9682, 0.0000>, <-60.5644, 249.6046, 0.0366>, <-0.0162, 0.9999, -0.0000> }
    smooth_triangle { <-52.9976, 248.2586, 0.0366>, <0.2503, 0.9682, 0.0000>, <-53.7435, 248.2586, 2.5953>, <0.2335, 0.9534, 0.1912>, <-44.2684, 244.4872, 4.6472>, <0.3718, 0.8139, 0.4465> }
    smooth_triangle { <-44.2684, 244.4872, 4.6472>, <0.3718, 0.8139, 0.4465>, <-41.5082, 244.4872, 0.0366>, <0.4140, 0.9103, 0.0000>, <-52.9976, 248.2586, 0.0366>, <0.2503, 0.9682, 0.0000> }
    smooth_triangle { <-41.5082, 244.4872, 0.0366>, <0.4140, 0.9103, 0.0000>, <-44.2684, 244.4872, 4.6472>, <0.3718, 0.8139, 0.4465>, <-36.9268, 239.0374, 5.7859>, <0.5241, 0.3664, 0.7688> }
    smooth_triangle { <-36.9268, 239.0374, 5.7859>, <0.5241, 0.3664, 0.7688>, <-31.1655, 239.0374, 0.0366>, <0.5052, 0.8630, -0.0000>, <-41.5082, 244.4872, 0.0366>, <0.4140, 0.9103, 0.0000> }
    smooth_triangle { <-31.1655, 239.0374, 0.0366>, <0.7064, -0.0000, 0.7078>, <-36.9268, 239.0374, 5.7859>, <0.5241, 0.3664, 0.7688>, <-36.9268, 232.9885, 5.7859>, <0.5241, -0.3664, 0.7688> }
    smooth_triangle { <-36.9268, 232.9885, 5.7859>, <0.5241, -0.3664, 0.7688>, <-31.1655, 232.9885, 0.0366>, <0.7064, -0.0000, 0.7078>, <-31.1655, 239.0374, 0.0366>, <0.7064, -0.0000, 0.7078> }
    smooth_triangle { <-31.1655, 232.9885, 0.0366>, <0.5052, -0.8630, -0.0000>, <-36.9268, 232.9885, 5.7859>, <0.5241, -0.3664, 0.7688>, <-44.2684, 227.5387, 4.6472>, <0.3718, -0.8139, 0.4465> }
    smooth_triangle { <-44.2684, 227.5387, 4.6472>, <0.3718, -0.8139, 0.4465>, <-41.5082, 227.5387, 0.0366>, <0.4140, -0.9103, 0.0000>, <-31.1655, 232.9885, 0.0366>, <0.5052, -0.8630, -0.0000> }
    smooth_triangle { <-41.5082, 227.5387, 0.0366>, <0.4140, -0.9103, 0.0000>, <-44.2684, 227.5387, 4.6472>, <0.3718, -0.8139, 0.4465>, <-53.7435, 223.7673, 2.5953>, <0.2335, -0.9534, 0.1912> }
    smooth_triangle { <-53.7435, 223.7673, 2.5953>, <0.2335, -0.9534, 0.1912>, <-52.9976, 223.7673, 0.0366>, <0.2503, -0.9682, 0.0000>, <-41.5082, 227.5387, 0.0366>, <0.4140, -0.9103, 0.0000> }
    smooth_triangle { <-52.9976, 223.7673, 0.0366>, <0.2503, -0.9682, 0.0000>, <-53.7435, 223.7673, 2.5953>, <0.2335, -0.9534, 0.1912>, <-60.5644, 222.4213, 0.0366>, <-0.0162, -0.9999, 0.0000> }
    smooth_triangle { <-60.5644, 222.4213, 0.0366>, <-0.0162, -0.9999, 0.0000>, <-60.5644, 222.4213, 0.0366>, <-0.0162, -0.9999, 0.0000>, <-52.9976, 223.7673, 0.0366>, <0.2503, -0.9682, 0.0000> }
    texture {
      Brushed_Aluminum
    }
  }

  mesh { // Surf3 
    smooth_triangle { <15.7480, 100.2557, -4.2112>, <-0.0052, 0.9994, 0.0332>, <15.7480, 100.2557, -4.2112>, <-0.0052, 0.9994, 0.0332>, <26.7602, 97.2607, -4.3192>, <0.4904, 0.8710, 0.0291> }
    smooth_triangle { <26.7602, 97.2607, -4.3192>, <0.4904, 0.8710, 0.0291>, <25.6696, 97.3886, -7.2875>, <0.4321, 0.8572, -0.2800>, <15.7480, 100.2557, -4.2112>, <-0.0052, 0.9994, 0.0332> }
    smooth_triangle { <25.6696, 97.3886, -7.2875>, <0.4321, 0.8572, -0.2800>, <26.7602, 97.2607, -4.3192>, <0.4904, 0.8710, 0.0291>, <35.5912, 88.7600, -4.4058>, <0.8278, 0.5607, 0.0154> }
    smooth_triangle { <35.5912, 88.7600, -4.4058>, <0.8278, 0.5607, 0.0154>, <33.6261, 88.9574, -9.7420>, <0.6991, 0.5260, -0.4842>, <25.6696, 97.3886, -7.2875>, <0.4321, 0.8572, -0.2800> }
    smooth_triangle { <33.6261, 88.9574, -9.7420>, <0.6991, 0.5260, -0.4842>, <35.5912, 88.7600, -4.4058>, <0.8278, 0.5607, 0.0154>, <40.4921, 76.5232, -4.4510>, <0.9817, 0.1903, 0.0067> }
    smooth_triangle { <40.4921, 76.5232, -4.4510>, <0.9817, 0.1903, 0.0067>, <38.0417, 76.6988, -11.1129>, <0.8027, 0.1733, -0.5706>, <33.6261, 88.9574, -9.7420>, <0.6991, 0.5260, -0.4842> }
    smooth_triangle { <38.0417, 76.6988, -11.1129>, <0.8027, 0.1733, -0.5706>, <40.4921, 76.5232, -4.4510>, <0.9817, 0.1903, 0.0067>, <40.4921, 63.0985, -4.4590>, <0.9808, -0.1948, 0.0003> }
    smooth_triangle { <40.4921, 63.0985, -4.4590>, <0.9808, -0.1948, 0.0003>, <38.0417, 63.2986, -11.1305>, <0.7923, -0.1741, -0.5848>, <38.0417, 76.6988, -11.1129>, <0.8027, 0.1733, -0.5706> }
    smooth_triangle { <38.0417, 63.2986, -11.1305>, <0.7923, -0.1741, -0.5848>, <40.4921, 63.0985, -4.4590>, <0.9808, -0.1948, 0.0003>, <35.5912, 51.2072, -4.4497>, <0.8187, -0.5740, -0.0163> }
    smooth_triangle { <35.5912, 51.2072, -4.4497>, <0.8187, -0.5740, -0.0163>, <33.6261, 51.4913, -9.7945>, <0.6672, -0.5237, -0.5297>, <38.0417, 63.2986, -11.1305>, <0.7923, -0.1741, -0.5848> }
    smooth_triangle { <33.6261, 51.4913, -9.7945>, <0.6672, -0.5237, -0.5297>, <35.5912, 51.2072, -4.4497>, <0.8187, -0.5740, -0.0163>, <26.7602, 43.0915, -4.4198>, <0.4788, -0.8768, -0.0445> }
    smooth_triangle { <26.7602, 43.0915, -4.4198>, <0.4788, -0.8768, -0.0445>, <25.6696, 43.3063, -7.3793>, <0.4027, -0.8369, -0.3707>, <33.6261, 51.4913, -9.7945>, <0.6672, -0.5237, -0.5297> }
    smooth_triangle { <25.6696, 43.3063, -7.3793>, <0.4027, -0.8369, -0.3707>, <26.7602, 43.0915, -4.4198>, <0.4788, -0.8768, -0.0445>, <15.7480, 40.1323, -4.3364>, <0.0138, -0.9988, -0.0477> }
    smooth_triangle { <15.7480, 40.1323, -4.3364>, <0.0138, -0.9988, -0.0477>, <15.7480, 40.1323, -4.3364>, <0.0138, -0.9988, -0.0477>, <25.6696, 43.3063, -7.3793>, <0.4027, -0.8369, -0.3707> }
    smooth_triangle { <15.7480, 100.2557, -4.2112>, <-0.0052, 0.9994, 0.0332>, <15.7480, 100.2557, -4.2112>, <-0.0052, 0.9994, 0.0332>, <25.6696, 97.3886, -7.2875>, <0.4321, 0.8572, -0.2800> }
    smooth_triangle { <25.6696, 97.3886, -7.2875>, <0.4321, 0.8572, -0.2800>, <22.6140, 97.5302, -9.6847>, <0.2825, 0.8220, -0.4944>, <15.7480, 100.2557, -4.2112>, <-0.0052, 0.9994, 0.0332> }
    smooth_triangle { <22.6140, 97.5302, -9.6847>, <0.2825, 0.8220, -0.4944>, <25.6696, 97.3886, -7.2875>, <0.4321, 0.8572, -0.2800>, <33.6261, 88.9574, -9.7420>, <0.6991, 0.5260, -0.4842> }
    smooth_triangle { <33.6261, 88.9574, -9.7420>, <0.6991, 0.5260, -0.4842>, <28.1201, 89.3596, -14.1086>, <0.4286, 0.4675, -0.7731>, <22.6140, 97.5302, -9.6847>, <0.2825, 0.8220, -0.4944> }
    smooth_triangle { <28.1201, 89.3596, -14.1086>, <0.4286, 0.4675, -0.7731>, <33.6261, 88.9574, -9.7420>, <0.6991, 0.5260, -0.4842>, <38.0417, 76.6988, -11.1129>, <0.8027, 0.1733, -0.5706> }
    smooth_triangle { <38.0417, 76.6988, -11.1129>, <0.8027, 0.1733, -0.5706>, <31.1757, 77.3634, -16.6037>, <0.4709, 0.1485, -0.8696>, <28.1201, 89.3596, -14.1086>, <0.4286, 0.4675, -0.7731> }
    smooth_triangle { <31.1757, 77.3634, -16.6037>, <0.4709, 0.1485, -0.8696>, <38.0417, 76.6988, -11.1129>, <0.8027, 0.1733, -0.5706>, <38.0417, 63.2986, -11.1305>, <0.7923, -0.1741, -0.5848> }
    smooth_triangle { <38.0417, 63.2986, -11.1305>, <0.7923, -0.1741, -0.5848>, <31.1757, 64.0549, -16.6295>, <0.4550, -0.1432, -0.8789>, <31.1757, 77.3634, -16.6037>, <0.4709, 0.1485, -0.8696> }
    smooth_triangle { <31.1757, 64.0549, -16.6295>, <0.4550, -0.1432, -0.8789>, <38.0417, 63.2986, -11.1305>, <0.7923, -0.1741, -0.5848>, <33.6261, 51.4913, -9.7945>, <0.6672, -0.5237, -0.5297> }
    smooth_triangle { <33.6261, 51.4913, -9.7945>, <0.6672, -0.5237, -0.5297>, <28.1201, 52.0674, -14.1733>, <0.3906, -0.4468, -0.8049>, <31.1757, 64.0549, -16.6295>, <0.4550, -0.1432, -0.8789> }
    smooth_triangle { <28.1201, 52.0674, -14.1733>, <0.3906, -0.4468, -0.8049>, <33.6261, 51.4913, -9.7945>, <0.6672, -0.5237, -0.5297>, <25.6696, 43.3063, -7.3793>, <0.4027, -0.8369, -0.3707> }
    smooth_triangle { <25.6696, 43.3063, -7.3793>, <0.4027, -0.8369, -0.3707>, <22.6140, 43.5406, -9.7752>, <0.2522, -0.7793, -0.5737>, <28.1201, 52.0674, -14.1733>, <0.3906, -0.4468, -0.8049> }
    smooth_triangle { <22.6140, 43.5406, -9.7752>, <0.2522, -0.7793, -0.5737>, <25.6696, 43.3063, -7.3793>, <0.4027, -0.8369, -0.3707>, <15.7480, 40.1323, -4.3364>, <0.0138, -0.9988, -0.0477> }
    smooth_triangle { <15.7480, 40.1323, -4.3364>, <0.0138, -0.9988, -0.0477>, <15.7480, 40.1323, -4.3364>, <0.0138, -0.9988, -0.0477>, <22.6140, 43.5406, -9.7752>, <0.2522, -0.7793, -0.5737> }
    smooth_triangle { <15.7480, 100.2557, -4.2112>, <-0.0052, 0.9994, 0.0332>, <15.7480, 100.2557, -4.2112>, <-0.0052, 0.9994, 0.0332>, <22.6140, 97.5302, -9.6847>, <0.2825, 0.8220, -0.4944> }
    smooth_triangle { <22.6140, 97.5302, -9.6847>, <0.2825, 0.8220, -0.4944>, <18.1985, 97.6028, -11.0193>, <0.0892, 0.7958, -0.5990>, <15.7480, 100.2557, -4.2112>, <-0.0052, 0.9994, 0.0332> }
    smooth_triangle { <18.1985, 97.6028, -11.0193>, <0.0892, 0.7958, -0.5990>, <22.6140, 97.5302, -9.6847>, <0.2825, 0.8220, -0.4944>, <28.1201, 89.3596, -14.1086>, <0.4286, 0.4675, -0.7731> }
    smooth_triangle { <28.1201, 89.3596, -14.1086>, <0.4286, 0.4675, -0.7731>, <20.1636, 89.6598, -16.5672>, <0.1362, 0.4334, -0.8908>, <18.1985, 97.6028, -11.0193>, <0.0892, 0.7958, -0.5990> }
    smooth_triangle { <20.1636, 89.6598, -16.5672>, <0.1362, 0.4334, -0.8908>, <28.1201, 89.3596, -14.1086>, <0.4286, 0.4675, -0.7731>, <31.1757, 77.3634, -16.6037>, <0.4709, 0.1485, -0.8696> }
    smooth_triangle { <31.1757, 77.3634, -16.6037>, <0.4709, 0.1485, -0.8696>, <21.2541, 77.9612, -19.7070>, <0.1504, 0.1358, -0.9793>, <20.1636, 89.6598, -16.5672>, <0.1362, 0.4334, -0.8908> }
    smooth_triangle { <21.2541, 77.9612, -19.7070>, <0.1504, 0.1358, -0.9793>, <31.1757, 77.3634, -16.6037>, <0.4709, 0.1485, -0.8696>, <31.1757, 64.0549, -16.6295>, <0.4550, -0.1432, -0.8789> }
    smooth_triangle { <31.1757, 64.0549, -16.6295>, <0.4550, -0.1432, -0.8789>, <21.2541, 64.7309, -19.7380>, <0.1481, -0.1277, -0.9807>, <21.2541, 77.9612, -19.7070>, <0.1504, 0.1358, -0.9793> }
    smooth_triangle { <21.2541, 64.7309, -19.7380>, <0.1481, -0.1277, -0.9807>, <31.1757, 64.0549, -16.6295>, <0.4550, -0.1432, -0.8789>, <28.1201, 52.0674, -14.1733>, <0.3906, -0.4468, -0.8049> }
    smooth_triangle { <28.1201, 52.0674, -14.1733>, <0.3906, -0.4468, -0.8049>, <20.1636, 52.4867, -16.6401>, <0.1331, -0.4070, -0.9037>, <21.2541, 64.7309, -19.7380>, <0.1481, -0.1277, -0.9807> }
    smooth_triangle { <20.1636, 52.4867, -16.6401>, <0.1331, -0.4070, -0.9037>, <28.1201, 52.0674, -14.1733>, <0.3906, -0.4468, -0.8049>, <22.6140, 43.5406, -9.7752>, <0.2522, -0.7793, -0.5737> }
    smooth_triangle { <22.6140, 43.5406, -9.7752>, <0.2522, -0.7793, -0.5737>, <18.1985, 43.6525, -11.1106>, <0.0956, -0.7477, -0.6571>, <20.1636, 52.4867, -16.6401>, <0.1331, -0.4070, -0.9037> }
    smooth_triangle { <18.1985, 43.6525, -11.1106>, <0.0956, -0.7477, -0.6571>, <22.6140, 43.5406, -9.7752>, <0.2522, -0.7793, -0.5737>, <15.7480, 40.1323, -4.3364>, <0.0138, -0.9988, -0.0477> }
    smooth_triangle { <15.7480, 40.1323, -4.3364>, <0.0138, -0.9988, -0.0477>, <15.7480, 40.1323, -4.3364>, <0.0138, -0.9988, -0.0477>, <18.1985, 43.6525, -11.1106>, <0.0956, -0.7477, -0.6571> }
    smooth_triangle { <15.7480, 100.2557, -4.2112>, <-0.0052, 0.9994, 0.0332>, <15.7480, 100.2557, -4.2112>, <-0.0052, 0.9994, 0.0332>, <18.1985, 97.6028, -11.0193>, <0.0892, 0.7958, -0.5990> }
    smooth_triangle { <18.1985, 97.6028, -11.0193>, <0.0892, 0.7958, -0.5990>, <13.2976, 97.5354, -11.0046>, <-0.1152, 0.7929, -0.5983>, <15.7480, 100.2557, -4.2112>, <-0.0052, 0.9994, 0.0332> }
    smooth_triangle { <13.2976, 97.5354, -11.0046>, <-0.1152, 0.7929, -0.5983>, <18.1985, 97.6028, -11.0193>, <0.0892, 0.7958, -0.5990>, <20.1636, 89.6598, -16.5672>, <0.1362, 0.4334, -0.8908> }
    smooth_triangle { <20.1636, 89.6598, -16.5672>, <0.1362, 0.4334, -0.8908>, <11.3325, 89.4465, -16.5638>, <-0.1554, 0.4305, -0.8891>, <13.2976, 97.5354, -11.0046>, <-0.1152, 0.7929, -0.5983> }
    smooth_triangle { <11.3325, 89.4465, -16.5638>, <-0.1554, 0.4305, -0.8891>, <20.1636, 89.6598, -16.5672>, <0.1362, 0.4334, -0.8908>, <21.2541, 77.9612, -19.7070>, <0.1504, 0.1358, -0.9793> }
    smooth_triangle { <21.2541, 77.9612, -19.7070>, <0.1504, 0.1358, -0.9793>, <10.2419, 77.5773, -19.7070>, <-0.1580, 0.1348, -0.9782>, <11.3325, 89.4465, -16.5638>, <-0.1554, 0.4305, -0.8891> }
    smooth_triangle { <10.2419, 77.5773, -19.7070>, <-0.1580, 0.1348, -0.9782>, <21.2541, 77.9612, -19.7070>, <0.1504, 0.1358, -0.9793>, <21.2541, 64.7309, -19.7380>, <0.1481, -0.1277, -0.9807> }
    smooth_triangle { <21.2541, 64.7309, -19.7380>, <0.1481, -0.1277, -0.9807>, <10.2419, 64.2831, -19.7380>, <-0.1406, -0.1286, -0.9817>, <10.2419, 77.5773, -19.7070>, <-0.1580, 0.1348, -0.9782> }
    smooth_triangle { <10.2419, 64.2831, -19.7380>, <-0.1406, -0.1286, -0.9817>, <21.2541, 64.7309, -19.7380>, <0.1481, -0.1277, -0.9807>, <20.1636, 52.4867, -16.6401>, <0.1331, -0.4070, -0.9037> }
    smooth_triangle { <20.1636, 52.4867, -16.6401>, <0.1331, -0.4070, -0.9037>, <11.3325, 52.1566, -16.6365>, <-0.1104, -0.4112, -0.9048>, <10.2419, 64.2831, -19.7380>, <-0.1406, -0.1286, -0.9817> }
    smooth_triangle { <11.3325, 52.1566, -16.6365>, <-0.1104, -0.4112, -0.9048>, <20.1636, 52.4867, -16.6401>, <0.1331, -0.4070, -0.9037>, <18.1985, 43.6525, -11.1106>, <0.0956, -0.7477, -0.6571> }
    smooth_triangle { <18.1985, 43.6525, -11.1106>, <0.0956, -0.7477, -0.6571>, <13.2976, 43.5243, -11.0950>, <-0.0599, -0.7519, -0.6566>, <11.3325, 52.1566, -16.6365>, <-0.1104, -0.4112, -0.9048> }
    smooth_triangle { <13.2976, 43.5243, -11.0950>, <-0.0599, -0.7519, -0.6566>, <18.1985, 43.6525, -11.1106>, <0.0956, -0.7477, -0.6571>, <15.7480, 40.1323, -4.3364>, <0.0138, -0.9988, -0.0477> }
    smooth_triangle { <15.7480, 40.1323, -4.3364>, <0.0138, -0.9988, -0.0477>, <15.7480, 40.1323, -4.3364>, <0.0138, -0.9988, -0.0477>, <13.2976, 43.5243, -11.0950>, <-0.0599, -0.7519, -0.6566> }
    smooth_triangle { <15.7480, 100.2557, -4.2112>, <-0.0052, 0.9994, 0.0332>, <15.7480, 100.2557, -4.2112>, <-0.0052, 0.9994, 0.0332>, <13.2976, 97.5354, -11.0046>, <-0.1152, 0.7929, -0.5983> }
    smooth_triangle { <13.2976, 97.5354, -11.0046>, <-0.1152, 0.7929, -0.5983>, <8.8821, 97.3632, -9.6294>, <-0.3024, 0.8141, -0.4957>, <15.7480, 100.2557, -4.2112>, <-0.0052, 0.9994, 0.0332> }
    smooth_triangle { <8.8821, 97.3632, -9.6294>, <-0.3024, 0.8141, -0.4957>, <13.2976, 97.5354, -11.0046>, <-0.1152, 0.7929, -0.5983>, <11.3325, 89.4465, -16.5638>, <-0.1554, 0.4305, -0.8891> }
    smooth_triangle { <11.3325, 89.4465, -16.5638>, <-0.1554, 0.4305, -0.8891>, <3.3760, 88.8610, -14.0774>, <-0.4427, 0.4595, -0.7700>, <8.8821, 97.3632, -9.6294>, <-0.3024, 0.8141, -0.4957> }
    smooth_triangle { <3.3760, 88.8610, -14.0774>, <-0.4427, 0.4595, -0.7700>, <11.3325, 89.4465, -16.5638>, <-0.1554, 0.4305, -0.8891>, <10.2419, 77.5773, -19.7070>, <-0.1580, 0.1348, -0.9782> }
    smooth_triangle { <10.2419, 77.5773, -19.7070>, <-0.1580, 0.1348, -0.9782>, <0.3203, 76.4870, -16.5915>, <-0.4788, 0.1460, -0.8657>, <3.3760, 88.8610, -14.0774>, <-0.4427, 0.4595, -0.7700> }
    smooth_triangle { <0.3203, 76.4870, -16.5915>, <-0.4788, 0.1460, -0.8657>, <10.2419, 77.5773, -19.7070>, <-0.1580, 0.1348, -0.9782>, <10.2419, 64.2831, -19.7380>, <-0.1406, -0.1286, -0.9817> }
    smooth_triangle { <10.2419, 64.2831, -19.7380>, <-0.1406, -0.1286, -0.9817>, <0.3203, 63.0328, -16.6171>, <-0.4575, -0.1464, -0.8771>, <0.3203, 76.4870, -16.5915>, <-0.4788, 0.1460, -0.8657> }
    smooth_triangle { <0.3203, 63.0328, -16.6171>, <-0.4575, -0.1464, -0.8771>, <10.2419, 64.2831, -19.7380>, <-0.1406, -0.1286, -0.9817>, <11.3325, 52.1566, -16.6365>, <-0.1104, -0.4112, -0.9048> }
    smooth_triangle { <11.3325, 52.1566, -16.6365>, <-0.1104, -0.4112, -0.9048>, <3.3760, 51.2956, -14.1407>, <-0.3832, -0.4600, -0.8010>, <0.3203, 63.0328, -16.6171>, <-0.4575, -0.1464, -0.8771> }
    smooth_triangle { <3.3760, 51.2956, -14.1407>, <-0.3832, -0.4600, -0.8010>, <11.3325, 52.1566, -16.6365>, <-0.1104, -0.4112, -0.9048>, <13.2976, 43.5243, -11.0950>, <-0.0599, -0.7519, -0.6566> }
    smooth_triangle { <13.2976, 43.5243, -11.0950>, <-0.0599, -0.7519, -0.6566>, <8.8821, 43.2228, -9.7165>, <-0.2302, -0.7929, -0.5643>, <3.3760, 51.2956, -14.1407>, <-0.3832, -0.4600, -0.8010> }
    smooth_triangle { <8.8821, 43.2228, -9.7165>, <-0.2302, -0.7929, -0.5643>, <13.2976, 43.5243, -11.0950>, <-0.0599, -0.7519, -0.6566>, <15.7480, 40.1323, -4.3364>, <0.0138, -0.9988, -0.0477> }
    smooth_triangle { <15.7480, 40.1323, -4.3364>, <0.0138, -0.9988, -0.0477>, <15.7480, 40.1323, -4.3364>, <0.0138, -0.9988, -0.0477>, <8.8821, 43.2228, -9.7165>, <-0.2302, -0.7929, -0.5643> }
    smooth_triangle { <15.7480, 100.2557, -4.2112>, <-0.0052, 0.9994, 0.0332>, <15.7480, 100.2557, -4.2112>, <-0.0052, 0.9994, 0.0332>, <8.8821, 97.3632, -9.6294>, <-0.3024, 0.8141, -0.4957> }
    smooth_triangle { <8.8821, 97.3632, -9.6294>, <-0.3024, 0.8141, -0.4957>, <5.8264, 97.1993, -7.1633>, <-0.4452, 0.8473, -0.2896>, <15.7480, 100.2557, -4.2112>, <-0.0052, 0.9994, 0.0332> }
    smooth_triangle { <5.8264, 97.1993, -7.1633>, <-0.4452, 0.8473, -0.2896>, <8.8821, 97.3632, -9.6294>, <-0.3024, 0.8141, -0.4957>, <3.3760, 88.8610, -14.0774>, <-0.4427, 0.4595, -0.7700> }
    smooth_triangle { <3.3760, 88.8610, -14.0774>, <-0.4427, 0.4595, -0.7700>, <-2.1301, 88.4620, -9.5956>, <-0.7060, 0.5151, -0.4860>, <5.8264, 97.1993, -7.1633>, <-0.4452, 0.8473, -0.2896> }
    smooth_triangle { <-2.1301, 88.4620, -9.5956>, <-0.7060, 0.5151, -0.4860>, <3.3760, 88.8610, -14.0774>, <-0.4427, 0.4595, -0.7700>, <0.3203, 76.4870, -16.5915>, <-0.4788, 0.1460, -0.8657> }
    smooth_triangle { <0.3203, 76.4870, -16.5915>, <-0.4788, 0.1460, -0.8657>, <-6.5456, 75.8772, -10.9743>, <-0.8087, 0.1697, -0.5633>, <-2.1301, 88.4620, -9.5956>, <-0.7060, 0.5151, -0.4860> }
    smooth_triangle { <-6.5456, 75.8772, -10.9743>, <-0.8087, 0.1697, -0.5633>, <0.3203, 76.4870, -16.5915>, <-0.4788, 0.1460, -0.8657>, <0.3203, 63.0328, -16.6171>, <-0.4575, -0.1464, -0.8771> }
    smooth_triangle { <0.3203, 63.0328, -16.6171>, <-0.4575, -0.1464, -0.8771>, <-6.5456, 62.3403, -10.9899>, <-0.8030, -0.1780, -0.5687>, <-6.5456, 75.8772, -10.9743>, <-0.8087, 0.1697, -0.5633> }
    smooth_triangle { <-6.5456, 62.3403, -10.9899>, <-0.8030, -0.1780, -0.5687>, <0.3203, 63.0328, -16.6171>, <-0.4575, -0.1464, -0.8771>, <3.3760, 51.2956, -14.1407>, <-0.3832, -0.4600, -0.8010> }
    smooth_triangle { <3.3760, 51.2956, -14.1407>, <-0.3832, -0.4600, -0.8010>, <-2.1301, 50.7245, -9.6418>, <-0.6738, -0.5396, -0.5048>, <-6.5456, 62.3403, -10.9899>, <-0.8030, -0.1780, -0.5687> }
    smooth_triangle { <-2.1301, 50.7245, -9.6418>, <-0.6738, -0.5396, -0.5048>, <3.3760, 51.2956, -14.1407>, <-0.3832, -0.4600, -0.8010>, <8.8821, 43.2228, -9.7165>, <-0.2302, -0.7929, -0.5643> }
    smooth_triangle { <8.8821, 43.2228, -9.7165>, <-0.2302, -0.7929, -0.5643>, <5.8264, 42.9462, -7.2472>, <-0.3917, -0.8544, -0.3415>, <-2.1301, 50.7245, -9.6418>, <-0.6738, -0.5396, -0.5048> }
    smooth_triangle { <5.8264, 42.9462, -7.2472>, <-0.3917, -0.8544, -0.3415>, <8.8821, 43.2228, -9.7165>, <-0.2302, -0.7929, -0.5643>, <15.7480, 40.1323, -4.3364>, <0.0138, -0.9988, -0.0477> }
    smooth_triangle { <15.7480, 40.1323, -4.3364>, <0.0138, -0.9988, -0.0477>, <15.7480, 40.1323, -4.3364>, <0.0138, -0.9988, -0.0477>, <5.8264, 42.9462, -7.2472>, <-0.3917, -0.8544, -0.3415> }
    smooth_triangle { <15.7480, 100.2557, -4.2112>, <-0.0052, 0.9994, 0.0332>, <15.7480, 100.2557, -4.2112>, <-0.0052, 0.9994, 0.0332>, <5.8264, 97.1993, -7.1633>, <-0.4452, 0.8473, -0.2896> }
    smooth_triangle { <5.8264, 97.1993, -7.1633>, <-0.4452, 0.8473, -0.2896>, <4.7359, 97.1127, -4.1048>, <-0.4996, 0.8662, 0.0094>, <15.7480, 100.2557, -4.2112>, <-0.0052, 0.9994, 0.0332> }
    smooth_triangle { <4.7359, 97.1127, -4.1048>, <-0.4996, 0.8662, 0.0094>, <5.8264, 97.1993, -7.1633>, <-0.4452, 0.8473, -0.2896>, <-2.1301, 88.4620, -9.5956>, <-0.7060, 0.5151, -0.4860> }
    smooth_triangle { <-2.1301, 88.4620, -9.5956>, <-0.7060, 0.5151, -0.4860>, <-4.0952, 88.4564, -4.0130>, <-0.8314, 0.5556, -0.0038>, <4.7359, 97.1127, -4.1048>, <-0.4996, 0.8662, 0.0094> }
    smooth_triangle { <-4.0952, 88.4564, -4.0130>, <-0.8314, 0.5556, -0.0038>, <-2.1301, 88.4620, -9.5956>, <-0.7060, 0.5151, -0.4860>, <-6.5456, 75.8772, -10.9743>, <-0.8087, 0.1697, -0.5633> }
    smooth_triangle { <-6.5456, 75.8772, -10.9743>, <-0.8087, 0.1697, -0.5633>, <-8.9961, 76.0778, -3.9515>, <-0.9821, 0.1885, -0.0028>, <-4.0952, 88.4564, -4.0130>, <-0.8314, 0.5556, -0.0038> }
    smooth_triangle { <-8.9961, 76.0778, -3.9515>, <-0.9821, 0.1885, -0.0028>, <-6.5456, 75.8772, -10.9743>, <-0.8087, 0.1697, -0.5633>, <-6.5456, 62.3403, -10.9899>, <-0.8030, -0.1780, -0.5687> }
    smooth_triangle { <-6.5456, 62.3403, -10.9899>, <-0.8030, -0.1780, -0.5687>, <-8.9961, 62.5790, -3.9520>, <-0.9805, -0.1961, 0.0082>, <-8.9961, 76.0778, -3.9515>, <-0.9821, 0.1885, -0.0028> }
    smooth_triangle { <-8.9961, 62.5790, -3.9520>, <-0.9805, -0.1961, 0.0082>, <-6.5456, 62.3403, -10.9899>, <-0.8030, -0.1780, -0.5687>, <-2.1301, 50.7245, -9.6418>, <-0.6738, -0.5396, -0.5048> }
    smooth_triangle { <-2.1301, 50.7245, -9.6418>, <-0.6738, -0.5396, -0.5048>, <-4.0952, 50.7371, -4.0401>, <-0.8142, -0.5805, 0.0094>, <-8.9961, 62.5790, -3.9520>, <-0.9805, -0.1961, 0.0082> }
    smooth_triangle { <-4.0952, 50.7371, -4.0401>, <-0.8142, -0.5805, 0.0094>, <-2.1301, 50.7245, -9.6418>, <-0.6738, -0.5396, -0.5048>, <5.8264, 42.9462, -7.2472>, <-0.3917, -0.8544, -0.3415> }
    smooth_triangle { <5.8264, 42.9462, -7.2472>, <-0.3917, -0.8544, -0.3415>, <4.7359, 42.8100, -4.1919>, <-0.4632, -0.8862, -0.0115>, <-4.0952, 50.7371, -4.0401>, <-0.8142, -0.5805, 0.0094> }
    smooth_triangle { <4.7359, 42.8100, -4.1919>, <-0.4632, -0.8862, -0.0115>, <5.8264, 42.9462, -7.2472>, <-0.3917, -0.8544, -0.3415>, <15.7480, 40.1323, -4.3364>, <0.0138, -0.9988, -0.0477> }
    smooth_triangle { <15.7480, 40.1323, -4.3364>, <0.0138, -0.9988, -0.0477>, <15.7480, 40.1323, -4.3364>, <0.0138, -0.9988, -0.0477>, <4.7359, 42.8100, -4.1919>, <-0.4632, -0.8862, -0.0115> }
    smooth_triangle { <15.7480, 100.2557, -4.2112>, <-0.0052, 0.9994, 0.0332>, <15.7480, 100.2557, -4.2112>, <-0.0052, 0.9994, 0.0332>, <4.7359, 97.1127, -4.1048>, <-0.4996, 0.8662, 0.0094> }
    smooth_triangle { <4.7359, 97.1127, -4.1048>, <-0.4996, 0.8662, 0.0094>, <5.8264, 97.0856, -1.0825>, <-0.4284, 0.8442, 0.3220>, <15.7480, 100.2557, -4.2112>, <-0.0052, 0.9994, 0.0332> }
    smooth_triangle { <5.8264, 97.0856, -1.0825>, <-0.4284, 0.8442, 0.3220>, <4.7359, 97.1127, -4.1048>, <-0.4996, 0.8662, 0.0094>, <-4.0952, 88.4564, -4.0130>, <-0.8314, 0.5556, -0.0038> }
    smooth_triangle { <-4.0952, 88.4564, -4.0130>, <-0.8314, 0.5556, -0.0038>, <-2.1301, 88.5815, 1.4996>, <-0.6898, 0.5236, 0.5000>, <5.8264, 97.0856, -1.0825>, <-0.4284, 0.8442, 0.3220> }
    smooth_triangle { <-2.1301, 88.5815, 1.4996>, <-0.6898, 0.5236, 0.5000>, <-4.0952, 88.4564, -4.0130>, <-0.8314, 0.5556, -0.0038>, <-8.9961, 76.0778, -3.9515>, <-0.9821, 0.1885, -0.0028> }
    smooth_triangle { <-8.9961, 76.0778, -3.9515>, <-0.9821, 0.1885, -0.0028>, <-6.5456, 76.4211, 2.9862>, <-0.7984, 0.1740, 0.5764>, <-2.1301, 88.5815, 1.4996>, <-0.6898, 0.5236, 0.5000> }
    smooth_triangle { <-6.5456, 76.4211, 2.9862>, <-0.7984, 0.1740, 0.5764>, <-8.9961, 76.0778, -3.9515>, <-0.9821, 0.1885, -0.0028>, <-8.9961, 62.5790, -3.9520>, <-0.9805, -0.1961, 0.0082> }
    smooth_triangle { <-8.9961, 62.5790, -3.9520>, <-0.9805, -0.1961, 0.0082>, <-6.5456, 62.9785, 2.9892>, <-0.7919, -0.1770, 0.5845>, <-6.5456, 76.4211, 2.9862>, <-0.7984, 0.1740, 0.5764> }
    smooth_triangle { <-6.5456, 62.9785, 2.9892>, <-0.7919, -0.1770, 0.5845>, <-8.9961, 62.5790, -3.9520>, <-0.9805, -0.1961, 0.0082>, <-4.0952, 50.7371, -4.0401>, <-0.8142, -0.5805, 0.0094> }
    smooth_triangle { <-4.0952, 50.7371, -4.0401>, <-0.8142, -0.5805, 0.0094>, <-2.1301, 50.9372, 1.4651>, <-0.6722, -0.5351, 0.5116>, <-6.5456, 62.9785, 2.9892>, <-0.7919, -0.1770, 0.5845> }
    smooth_triangle { <-2.1301, 50.9372, 1.4651>, <-0.6722, -0.5351, 0.5116>, <-4.0952, 50.7371, -4.0401>, <-0.8142, -0.5805, 0.0094>, <4.7359, 42.8100, -4.1919>, <-0.4632, -0.8862, -0.0115> }
    smooth_triangle { <4.7359, 42.8100, -4.1919>, <-0.4632, -0.8862, -0.0115>, <5.8264, 42.7770, -1.1883>, <-0.4000, -0.8637, 0.3066>, <-2.1301, 50.9372, 1.4651>, <-0.6722, -0.5351, 0.5116> }
    smooth_triangle { <5.8264, 42.7770, -1.1883>, <-0.4000, -0.8637, 0.3066>, <4.7359, 42.8100, -4.1919>, <-0.4632, -0.8862, -0.0115>, <15.7480, 40.1323, -4.3364>, <0.0138, -0.9988, -0.0477> }
    smooth_triangle { <15.7480, 40.1323, -4.3364>, <0.0138, -0.9988, -0.0477>, <15.7480, 40.1323, -4.3364>, <0.0138, -0.9988, -0.0477>, <5.8264, 42.7770, -1.1883>, <-0.4000, -0.8637, 0.3066> }
    smooth_triangle { <15.7480, 100.2557, -4.2112>, <-0.0052, 0.9994, 0.0332>, <15.7480, 100.2557, -4.2112>, <-0.0052, 0.9994, 0.0332>, <5.8264, 97.0856, -1.0825>, <-0.4284, 0.8442, 0.3220> }
    smooth_triangle { <5.8264, 97.0856, -1.0825>, <-0.4284, 0.8442, 0.3220>, <8.8821, 97.0773, 1.2823>, <-0.2654, 0.7961, 0.5439>, <15.7480, 100.2557, -4.2112>, <-0.0052, 0.9994, 0.0332> }
    smooth_triangle { <8.8821, 97.0773, 1.2823>, <-0.2654, 0.7961, 0.5439>, <5.8264, 97.0856, -1.0825>, <-0.4284, 0.8442, 0.3220>, <-2.1301, 88.5815, 1.4996>, <-0.6898, 0.5236, 0.5000> }
    smooth_triangle { <-2.1301, 88.5815, 1.4996>, <-0.6898, 0.5236, 0.5000>, <3.3760, 88.6316, 5.7487>, <-0.3931, 0.4519, 0.8008>, <8.8821, 97.0773, 1.2823>, <-0.2654, 0.7961, 0.5439> }
    smooth_triangle { <3.3760, 88.6316, 5.7487>, <-0.3931, 0.4519, 0.8008>, <-2.1301, 88.5815, 1.4996>, <-0.6898, 0.5236, 0.5000>, <-6.5456, 76.4211, 2.9862>, <-0.7984, 0.1740, 0.5764> }
    smooth_triangle { <-6.5456, 76.4211, 2.9862>, <-0.7984, 0.1740, 0.5764>, <0.3203, 76.5227, 8.2646>, <-0.4339, 0.1423, 0.8897>, <3.3760, 88.6316, 5.7487>, <-0.3931, 0.4519, 0.8008> }
    smooth_triangle { <0.3203, 76.5227, 8.2646>, <-0.4339, 0.1423, 0.8897>, <-6.5456, 76.4211, 2.9862>, <-0.7984, 0.1740, 0.5764>, <-6.5456, 62.9785, 2.9892>, <-0.7919, -0.1770, 0.5845> }
    smooth_triangle { <-6.5456, 62.9785, 2.9892>, <-0.7919, -0.1770, 0.5845>, <0.3203, 63.0974, 8.2371>, <-0.4296, -0.1468, 0.8910>, <0.3203, 76.5227, 8.2646>, <-0.4339, 0.1423, 0.8897> }
    smooth_triangle { <0.3203, 63.0974, 8.2371>, <-0.4296, -0.1468, 0.8910>, <-6.5456, 62.9785, 2.9892>, <-0.7919, -0.1770, 0.5845>, <-2.1301, 50.9372, 1.4651>, <-0.6722, -0.5351, 0.5116> }
    smooth_triangle { <-2.1301, 50.9372, 1.4651>, <-0.6722, -0.5351, 0.5116>, <3.3760, 51.0190, 5.6541>, <-0.3828, -0.4599, 0.8012>, <0.3203, 63.0974, 8.2371>, <-0.4296, -0.1468, 0.8910> }
    smooth_triangle { <3.3760, 51.0190, 5.6541>, <-0.3828, -0.4599, 0.8012>, <-2.1301, 50.9372, 1.4651>, <-0.6722, -0.5351, 0.5116>, <5.8264, 42.7770, -1.1883>, <-0.4000, -0.8637, 0.3066> }
    smooth_triangle { <5.8264, 42.7770, -1.1883>, <-0.4000, -0.8637, 0.3066>, <8.8821, 42.7725, 1.1417>, <-0.2476, -0.8174, 0.5201>, <3.3760, 51.0190, 5.6541>, <-0.3828, -0.4599, 0.8012> }
    smooth_triangle { <8.8821, 42.7725, 1.1417>, <-0.2476, -0.8174, 0.5201>, <5.8264, 42.7770, -1.1883>, <-0.4000, -0.8637, 0.3066>, <15.7480, 40.1323, -4.3364>, <0.0138, -0.9988, -0.0477> }
    smooth_triangle { <15.7480, 40.1323, -4.3364>, <0.0138, -0.9988, -0.0477>, <15.7480, 40.1323, -4.3364>, <0.0138, -0.9988, -0.0477>, <8.8821, 42.7725, 1.1417>, <-0.2476, -0.8174, 0.5201> }
    smooth_triangle { <15.7480, 100.2557, -4.2112>, <-0.0052, 0.9994, 0.0332>, <15.7480, 100.2557, -4.2112>, <-0.0052, 0.9994, 0.0332>, <8.8821, 97.0773, 1.2823>, <-0.2654, 0.7961, 0.5439> }
    smooth_triangle { <8.8821, 97.0773, 1.2823>, <-0.2654, 0.7961, 0.5439>, <13.2976, 97.0752, 2.5224>, <-0.0777, 0.7600, 0.6453>, <15.7480, 100.2557, -4.2112>, <-0.0052, 0.9994, 0.0332> }
    smooth_triangle { <13.2976, 97.0752, 2.5224>, <-0.0777, 0.7600, 0.6453>, <8.8821, 97.0773, 1.2823>, <-0.2654, 0.7961, 0.5439>, <3.3760, 88.6316, 5.7487>, <-0.3931, 0.4519, 0.8008> }
    smooth_triangle { <3.3760, 88.6316, 5.7487>, <-0.3931, 0.4519, 0.8008>, <11.3325, 88.6316, 7.8797>, <-0.1033, 0.4020, 0.9098>, <13.2976, 97.0752, 2.5224>, <-0.0777, 0.7600, 0.6453> }
    smooth_triangle { <11.3325, 88.6316, 7.8797>, <-0.1033, 0.4020, 0.9098>, <3.3760, 88.6316, 5.7487>, <-0.3931, 0.4519, 0.8008>, <0.3203, 76.5227, 8.2646>, <-0.4339, 0.1423, 0.8897> }
    smooth_triangle { <0.3203, 76.5227, 8.2646>, <-0.4339, 0.1423, 0.8897>, <10.2419, 76.5235, 10.8100>, <-0.1057, 0.1202, 0.9871>, <11.3325, 88.6316, 7.8797>, <-0.1033, 0.4020, 0.9098> }
    smooth_triangle { <10.2419, 76.5235, 10.8100>, <-0.1057, 0.1202, 0.9871>, <0.3203, 76.5227, 8.2646>, <-0.4339, 0.1423, 0.8897>, <0.3203, 63.0974, 8.2371>, <-0.4296, -0.1468, 0.8910> }
    smooth_triangle { <0.3203, 63.0974, 8.2371>, <-0.4296, -0.1468, 0.8910>, <10.2419, 63.0988, 10.7385>, <-0.1038, -0.1284, 0.9863>, <10.2419, 76.5235, 10.8100>, <-0.1057, 0.1202, 0.9871> }
    smooth_triangle { <10.2419, 63.0988, 10.7385>, <-0.1038, -0.1284, 0.9863>, <0.3203, 63.0974, 8.2371>, <-0.4296, -0.1468, 0.8910>, <3.3760, 51.0190, 5.6541>, <-0.3828, -0.4599, 0.8012> }
    smooth_triangle { <3.3760, 51.0190, 5.6541>, <-0.3828, -0.4599, 0.8012>, <11.3325, 51.0214, 7.7109>, <-0.0987, -0.4104, 0.9065>, <10.2419, 63.0988, 10.7385>, <-0.1038, -0.1284, 0.9863> }
    smooth_triangle { <11.3325, 51.0214, 7.7109>, <-0.0987, -0.4104, 0.9065>, <3.3760, 51.0190, 5.6541>, <-0.3828, -0.4599, 0.8012>, <8.8821, 42.7725, 1.1417>, <-0.2476, -0.8174, 0.5201> }
    smooth_triangle { <8.8821, 42.7725, 1.1417>, <-0.2476, -0.8174, 0.5201>, <13.2976, 42.7740, 2.3491>, <-0.0694, -0.7835, 0.6175>, <11.3325, 51.0214, 7.7109>, <-0.0987, -0.4104, 0.9065> }
    smooth_triangle { <13.2976, 42.7740, 2.3491>, <-0.0694, -0.7835, 0.6175>, <8.8821, 42.7725, 1.1417>, <-0.2476, -0.8174, 0.5201>, <15.7480, 40.1323, -4.3364>, <0.0138, -0.9988, -0.0477> }
    smooth_triangle { <15.7480, 40.1323, -4.3364>, <0.0138, -0.9988, -0.0477>, <15.7480, 40.1323, -4.3364>, <0.0138, -0.9988, -0.0477>, <13.2976, 42.7740, 2.3491>, <-0.0694, -0.7835, 0.6175> }
    smooth_triangle { <15.7480, 100.2557, -4.2112>, <-0.0052, 0.9994, 0.0332>, <15.7480, 100.2557, -4.2112>, <-0.0052, 0.9994, 0.0332>, <13.2976, 97.0752, 2.5224>, <-0.0777, 0.7600, 0.6453> }
    smooth_triangle { <13.2976, 97.0752, 2.5224>, <-0.0777, 0.7600, 0.6453>, <18.1985, 97.0859, 2.4228>, <0.1036, 0.7562, 0.6461>, <15.7480, 100.2557, -4.2112>, <-0.0052, 0.9994, 0.0332> }
    smooth_triangle { <18.1985, 97.0859, 2.4228>, <0.1036, 0.7562, 0.6461>, <13.2976, 97.0752, 2.5224>, <-0.0777, 0.7600, 0.6453>, <11.3325, 88.6316, 7.8797>, <-0.1033, 0.4020, 0.9098> }
    smooth_triangle { <11.3325, 88.6316, 7.8797>, <-0.1033, 0.4020, 0.9098>, <20.1636, 88.6350, 7.5959>, <0.1530, 0.3941, 0.9062>, <18.1985, 97.0859, 2.4228>, <0.1036, 0.7562, 0.6461> }
    smooth_triangle { <20.1636, 88.6350, 7.5959>, <0.1530, 0.3941, 0.9062>, <11.3325, 88.6316, 7.8797>, <-0.1033, 0.4020, 0.9098>, <10.2419, 76.5235, 10.8100>, <-0.1057, 0.1202, 0.9871> }
    smooth_triangle { <10.2419, 76.5235, 10.8100>, <-0.1057, 0.1202, 0.9871>, <21.2541, 76.5236, 10.3654>, <0.1689, 0.1162, 0.9788>, <20.1636, 88.6350, 7.5959>, <0.1530, 0.3941, 0.9062> }
    smooth_triangle { <21.2541, 76.5236, 10.3654>, <0.1689, 0.1162, 0.9788>, <10.2419, 76.5235, 10.8100>, <-0.1057, 0.1202, 0.9871>, <10.2419, 63.0988, 10.7385>, <-0.1038, -0.1284, 0.9863> }
    smooth_triangle { <10.2419, 63.0988, 10.7385>, <-0.1038, -0.1284, 0.9863>, <21.2541, 63.0989, 10.2873>, <0.1681, -0.1251, 0.9778>, <21.2541, 76.5236, 10.3654>, <0.1689, 0.1162, 0.9788> }
    smooth_triangle { <21.2541, 63.0989, 10.2873>, <0.1681, -0.1251, 0.9778>, <10.2419, 63.0988, 10.7385>, <-0.1038, -0.1284, 0.9863>, <11.3325, 51.0214, 7.7109>, <-0.0987, -0.4104, 0.9065> }
    smooth_triangle { <11.3325, 51.0214, 7.7109>, <-0.0987, -0.4104, 0.9065>, <20.1636, 51.0267, 7.4149>, <0.1526, -0.4036, 0.9021>, <21.2541, 63.0989, 10.2873>, <0.1681, -0.1251, 0.9778> }
    smooth_triangle { <20.1636, 51.0267, 7.4149>, <0.1526, -0.4036, 0.9021>, <11.3325, 51.0214, 7.7109>, <-0.0987, -0.4104, 0.9065>, <13.2976, 42.7740, 2.3491>, <-0.0694, -0.7835, 0.6175> }
    smooth_triangle { <13.2976, 42.7740, 2.3491>, <-0.0694, -0.7835, 0.6175>, <18.1985, 42.7943, 2.2433>, <0.1055, -0.7800, 0.6168>, <20.1636, 51.0267, 7.4149>, <0.1526, -0.4036, 0.9021> }
    smooth_triangle { <18.1985, 42.7943, 2.2433>, <0.1055, -0.7800, 0.6168>, <13.2976, 42.7740, 2.3491>, <-0.0694, -0.7835, 0.6175>, <15.7480, 40.1323, -4.3364>, <0.0138, -0.9988, -0.0477> }
    smooth_triangle { <15.7480, 40.1323, -4.3364>, <0.0138, -0.9988, -0.0477>, <15.7480, 40.1323, -4.3364>, <0.0138, -0.9988, -0.0477>, <18.1985, 42.7943, 2.2433>, <0.1055, -0.7800, 0.6168> }
    smooth_triangle { <15.7480, 100.2557, -4.2112>, <-0.0052, 0.9994, 0.0332>, <15.7480, 100.2557, -4.2112>, <-0.0052, 0.9994, 0.0332>, <18.1985, 97.0859, 2.4228>, <0.1036, 0.7562, 0.6461> }
    smooth_triangle { <18.1985, 97.0859, 2.4228>, <0.1036, 0.7562, 0.6461>, <22.6140, 97.1168, 1.0362>, <0.2759, 0.7872, 0.5516>, <15.7480, 100.2557, -4.2112>, <-0.0052, 0.9994, 0.0332> }
    smooth_triangle { <22.6140, 97.1168, 1.0362>, <0.2759, 0.7872, 0.5516>, <18.1985, 97.0859, 2.4228>, <0.1036, 0.7562, 0.6461>, <20.1636, 88.6350, 7.5959>, <0.1530, 0.3941, 0.9062> }
    smooth_triangle { <20.1636, 88.6350, 7.5959>, <0.1530, 0.3941, 0.9062>, <28.1201, 88.6586, 5.0875>, <0.4118, 0.4329, 0.8018>, <22.6140, 97.1168, 1.0362>, <0.2759, 0.7872, 0.5516> }
    smooth_triangle { <28.1201, 88.6586, 5.0875>, <0.4118, 0.4329, 0.8018>, <20.1636, 88.6350, 7.5959>, <0.1530, 0.3941, 0.9062>, <21.2541, 76.5236, 10.3654>, <0.1689, 0.1162, 0.9788> }
    smooth_triangle { <21.2541, 76.5236, 10.3654>, <0.1689, 0.1162, 0.9788>, <31.1757, 76.5365, 7.2535>, <0.4539, 0.1324, 0.8812>, <28.1201, 88.6586, 5.0875>, <0.4118, 0.4329, 0.8018> }
    smooth_triangle { <31.1757, 76.5365, 7.2535>, <0.4539, 0.1324, 0.8812>, <21.2541, 76.5236, 10.3654>, <0.1689, 0.1162, 0.9788>, <21.2541, 63.0989, 10.2873>, <0.1681, -0.1251, 0.9778> }
    smooth_triangle { <21.2541, 63.0989, 10.2873>, <0.1681, -0.1251, 0.9778>, <31.1757, 63.1136, 7.2108>, <0.4522, -0.1388, 0.8810>, <31.1757, 76.5365, 7.2535>, <0.4539, 0.1324, 0.8812> }
    smooth_triangle { <31.1757, 63.1136, 7.2108>, <0.4522, -0.1388, 0.8810>, <21.2541, 63.0989, 10.2873>, <0.1681, -0.1251, 0.9778>, <20.1636, 51.0267, 7.4149>, <0.1526, -0.4036, 0.9021> }
    smooth_triangle { <20.1636, 51.0267, 7.4149>, <0.1526, -0.4036, 0.9021>, <28.1201, 51.0607, 4.9646>, <0.4101, -0.4443, 0.7965>, <31.1757, 63.1136, 7.2108>, <0.4522, -0.1388, 0.8810> }
    smooth_triangle { <28.1201, 51.0607, 4.9646>, <0.4101, -0.4443, 0.7965>, <20.1636, 51.0267, 7.4149>, <0.1526, -0.4036, 0.9021>, <18.1985, 42.7943, 2.2433>, <0.1055, -0.7800, 0.6168> }
    smooth_triangle { <18.1985, 42.7943, 2.2433>, <0.1055, -0.7800, 0.6168>, <22.6140, 42.8476, 0.8802>, <0.2755, -0.8101, 0.5176>, <28.1201, 51.0607, 4.9646>, <0.4101, -0.4443, 0.7965> }
    smooth_triangle { <22.6140, 42.8476, 0.8802>, <0.2755, -0.8101, 0.5176>, <18.1985, 42.7943, 2.2433>, <0.1055, -0.7800, 0.6168>, <15.7480, 40.1323, -4.3364>, <0.0138, -0.9988, -0.0477> }
    smooth_triangle { <15.7480, 40.1323, -4.3364>, <0.0138, -0.9988, -0.0477>, <15.7480, 40.1323, -4.3364>, <0.0138, -0.9988, -0.0477>, <22.6140, 42.8476, 0.8802>, <0.2755, -0.8101, 0.5176> }
    smooth_triangle { <15.7480, 100.2557, -4.2112>, <-0.0052, 0.9994, 0.0332>, <15.7480, 100.2557, -4.2112>, <-0.0052, 0.9994, 0.0332>, <22.6140, 97.1168, 1.0362>, <0.2759, 0.7872, 0.5516> }
    smooth_triangle { <22.6140, 97.1168, 1.0362>, <0.2759, 0.7872, 0.5516>, <25.6696, 97.1726, -1.3597>, <0.4243, 0.8388, 0.3411>, <15.7480, 100.2557, -4.2112>, <-0.0052, 0.9994, 0.0332> }
    smooth_triangle { <25.6696, 97.1726, -1.3597>, <0.4243, 0.8388, 0.3411>, <22.6140, 97.1168, 1.0362>, <0.2759, 0.7872, 0.5516>, <28.1201, 88.6586, 5.0875>, <0.4118, 0.4329, 0.8018> }
    smooth_triangle { <28.1201, 88.6586, 5.0875>, <0.4118, 0.4329, 0.8018>, <33.6261, 88.6987, 0.8480>, <0.6845, 0.5103, 0.5206>, <25.6696, 97.1726, -1.3597>, <0.4243, 0.8388, 0.3411> }
    smooth_triangle { <33.6261, 88.6987, 0.8480>, <0.6845, 0.5103, 0.5206>, <28.1201, 88.6586, 5.0875>, <0.4118, 0.4329, 0.8018>, <31.1757, 76.5365, 7.2535>, <0.4539, 0.1324, 0.8812> }
    smooth_triangle { <31.1757, 76.5365, 7.2535>, <0.4539, 0.1324, 0.8812>, <38.0417, 76.5510, 2.0465>, <0.7893, 0.1668, 0.5910>, <33.6261, 88.6987, 0.8480>, <0.6845, 0.5103, 0.5206> }
    smooth_triangle { <38.0417, 76.5510, 2.0465>, <0.7893, 0.1668, 0.5910>, <31.1757, 76.5365, 7.2535>, <0.4539, 0.1324, 0.8812>, <31.1757, 63.1136, 7.2108>, <0.4522, -0.1388, 0.8810> }
    smooth_triangle { <31.1757, 63.1136, 7.2108>, <0.4522, -0.1388, 0.8810>, <38.0417, 63.1301, 2.0354>, <0.7886, -0.1713, 0.5906>, <38.0417, 76.5510, 2.0465>, <0.7893, 0.1668, 0.5910> }
    smooth_triangle { <38.0417, 63.1301, 2.0354>, <0.7886, -0.1713, 0.5906>, <31.1757, 63.1136, 7.2108>, <0.4522, -0.1388, 0.8810>, <28.1201, 51.0607, 4.9646>, <0.4101, -0.4443, 0.7965> }
    smooth_triangle { <28.1201, 51.0607, 4.9646>, <0.4101, -0.4443, 0.7965>, <33.6261, 51.1187, 0.7855>, <0.6832, -0.5247, 0.5079>, <38.0417, 63.1301, 2.0354>, <0.7886, -0.1713, 0.5906> }
    smooth_triangle { <33.6261, 51.1187, 0.7855>, <0.6832, -0.5247, 0.5079>, <28.1201, 51.0607, 4.9646>, <0.4101, -0.4443, 0.7965>, <22.6140, 42.8476, 0.8802>, <0.2755, -0.8101, 0.5176> }
    smooth_triangle { <22.6140, 42.8476, 0.8802>, <0.2755, -0.8101, 0.5176>, <25.6696, 42.9426, -1.4829>, <0.4223, -0.8579, 0.2926>, <33.6261, 51.1187, 0.7855>, <0.6832, -0.5247, 0.5079> }
    smooth_triangle { <25.6696, 42.9426, -1.4829>, <0.4223, -0.8579, 0.2926>, <22.6140, 42.8476, 0.8802>, <0.2755, -0.8101, 0.5176>, <15.7480, 40.1323, -4.3364>, <0.0138, -0.9988, -0.0477> }
    smooth_triangle { <15.7480, 40.1323, -4.3364>, <0.0138, -0.9988, -0.0477>, <15.7480, 40.1323, -4.3364>, <0.0138, -0.9988, -0.0477>, <25.6696, 42.9426, -1.4829>, <0.4223, -0.8579, 0.2926> }
    smooth_triangle { <15.7480, 100.2557, -4.2112>, <-0.0052, 0.9994, 0.0332>, <15.7480, 100.2557, -4.2112>, <-0.0052, 0.9994, 0.0332>, <25.6696, 97.1726, -1.3597>, <0.4243, 0.8388, 0.3411> }
    smooth_triangle { <25.6696, 97.1726, -1.3597>, <0.4243, 0.8388, 0.3411>, <26.7602, 97.2607, -4.3192>, <0.4904, 0.8710, 0.0291>, <15.7480, 100.2557, -4.2112>, <-0.0052, 0.9994, 0.0332> }
    smooth_triangle { <26.7602, 97.2607, -4.3192>, <0.4904, 0.8710, 0.0291>, <25.6696, 97.1726, -1.3597>, <0.4243, 0.8388, 0.3411>, <33.6261, 88.6987, 0.8480>, <0.6845, 0.5103, 0.5206> }
    smooth_triangle { <33.6261, 88.6987, 0.8480>, <0.6845, 0.5103, 0.5206>, <35.5912, 88.7600, -4.4058>, <0.8278, 0.5607, 0.0154>, <26.7602, 97.2607, -4.3192>, <0.4904, 0.8710, 0.0291> }
    smooth_triangle { <35.5912, 88.7600, -4.4058>, <0.8278, 0.5607, 0.0154>, <33.6261, 88.6987, 0.8480>, <0.6845, 0.5103, 0.5206>, <38.0417, 76.5510, 2.0465>, <0.7893, 0.1668, 0.5910> }
    smooth_triangle { <38.0417, 76.5510, 2.0465>, <0.7893, 0.1668, 0.5910>, <40.4921, 76.5232, -4.4510>, <0.9817, 0.1903, 0.0067>, <35.5912, 88.7600, -4.4058>, <0.8278, 0.5607, 0.0154> }
    smooth_triangle { <40.4921, 76.5232, -4.4510>, <0.9817, 0.1903, 0.0067>, <38.0417, 76.5510, 2.0465>, <0.7893, 0.1668, 0.5910>, <38.0417, 63.1301, 2.0354>, <0.7886, -0.1713, 0.5906> }
    smooth_triangle { <38.0417, 63.1301, 2.0354>, <0.7886, -0.1713, 0.5906>, <40.4921, 63.0985, -4.4590>, <0.9808, -0.1948, 0.0003>, <40.4921, 76.5232, -4.4510>, <0.9817, 0.1903, 0.0067> }
    smooth_triangle { <40.4921, 63.0985, -4.4590>, <0.9808, -0.1948, 0.0003>, <38.0417, 63.1301, 2.0354>, <0.7886, -0.1713, 0.5906>, <33.6261, 51.1187, 0.7855>, <0.6832, -0.5247, 0.5079> }
    smooth_triangle { <33.6261, 51.1187, 0.7855>, <0.6832, -0.5247, 0.5079>, <35.5912, 51.2072, -4.4497>, <0.8187, -0.5740, -0.0163>, <40.4921, 63.0985, -4.4590>, <0.9808, -0.1948, 0.0003> }
    smooth_triangle { <35.5912, 51.2072, -4.4497>, <0.8187, -0.5740, -0.0163>, <33.6261, 51.1187, 0.7855>, <0.6832, -0.5247, 0.5079>, <25.6696, 42.9426, -1.4829>, <0.4223, -0.8579, 0.2926> }
    smooth_triangle { <25.6696, 42.9426, -1.4829>, <0.4223, -0.8579, 0.2926>, <26.7602, 43.0915, -4.4198>, <0.4788, -0.8768, -0.0445>, <35.5912, 51.2072, -4.4497>, <0.8187, -0.5740, -0.0163> }
    smooth_triangle { <26.7602, 43.0915, -4.4198>, <0.4788, -0.8768, -0.0445>, <25.6696, 42.9426, -1.4829>, <0.4223, -0.8579, 0.2926>, <15.7480, 40.1323, -4.3364>, <0.0138, -0.9988, -0.0477> }
    smooth_triangle { <15.7480, 40.1323, -4.3364>, <0.0138, -0.9988, -0.0477>, <15.7480, 40.1323, -4.3364>, <0.0138, -0.9988, -0.0477>, <26.7602, 43.0915, -4.4198>, <0.4788, -0.8768, -0.0445> }
    texture {
      Brushed_Aluminum 
    }
  }

  mesh { // Surf1 
    smooth_triangle { <15.7346, 659.6792, 14.2713>, <0.0000, 0.0859, 0.9963>, <32.3428, 659.6792, 11.4210>, <0.3448, 0.1212, 0.9308>, <29.1879, 676.0796, 10.6629>, <0.3532, 0.1270, 0.9269> }
    smooth_triangle { <29.1879, 676.0796, 10.6629>, <0.3532, 0.1270, 0.9269>, <15.7193, 676.0794, 12.7239>, <-0.0002, 0.0884, 0.9961>, <15.7346, 659.6792, 14.2713>, <0.0000, 0.0859, 0.9963> }
    smooth_triangle { <32.3428, 659.6792, 11.4210>, <0.3448, 0.1212, 0.9308>, <40.6722, 659.6792, 6.6134>, <0.5158, 0.1531, 0.8429>, <35.4089, 676.0795, 6.5657>, <0.5373, 0.1611, 0.8279> }
    smooth_triangle { <35.4089, 676.0795, 6.5657>, <0.5373, 0.1611, 0.8279>, <29.1879, 676.0796, 10.6629>, <0.3532, 0.1270, 0.9269>, <32.3428, 659.6792, 11.4210>, <0.3448, 0.1212, 0.9308> }
    smooth_triangle { <40.6722, 659.6792, 6.6134>, <0.5552, 0.1622, -0.8158>, <32.6908, 659.6792, 1.4545>, <0.3769, 0.1293, -0.9172>, <29.3841, 676.0794, 2.1930>, <0.3828, 0.1342, -0.9140> }
    smooth_triangle { <29.3841, 676.0794, 2.1930>, <0.3828, 0.1342, -0.9140>, <35.4089, 676.0795, 6.5657>, <0.5731, 0.1688, -0.8019>, <40.6722, 659.6792, 6.6134>, <0.5552, 0.1622, -0.8158> }
    smooth_triangle { <32.6908, 659.6792, 1.4545>, <0.3769, 0.1293, -0.9172>, <15.6891, 659.6792, -1.8805>, <-0.0017, 0.0927, -0.9957>, <15.6899, 676.0793, -0.1926>, <-0.0020, 0.0945, -0.9955> }
    smooth_triangle { <15.6899, 676.0793, -0.1926>, <-0.0020, 0.0945, -0.9955>, <29.3841, 676.0794, 2.1930>, <0.3828, 0.1342, -0.9140>, <32.6908, 659.6792, 1.4545>, <0.3769, 0.1293, -0.9172> }
    smooth_triangle { <15.6891, 659.6792, -1.8805>, <-0.0017, 0.0927, -0.9957>, <-1.2809, 659.6792, 1.4976>, <-0.3781, 0.1293, -0.9167>, <2.0132, 676.0794, 2.2500>, <-0.3839, 0.1339, -0.9136> }
    smooth_triangle { <2.0132, 676.0794, 2.2500>, <-0.3839, 0.1339, -0.9136>, <15.6899, 676.0793, -0.1926>, <-0.0020, 0.0945, -0.9955>, <15.6891, 659.6792, -1.8805>, <-0.0017, 0.0927, -0.9957> }
    smooth_triangle { <-1.2809, 659.6792, 1.4976>, <-0.3781, 0.1293, -0.9167>, <-9.2056, 659.6792, 6.6204>, <-0.5544, 0.1617, -0.8164>, <-3.9834, 676.0794, 6.5809>, <-0.5716, 0.1679, -0.8032> }
    smooth_triangle { <-3.9834, 676.0794, 6.5809>, <-0.5716, 0.1679, -0.8032>, <2.0132, 676.0794, 2.2500>, <-0.3839, 0.1339, -0.9136>, <-1.2809, 659.6792, 1.4976>, <-0.3781, 0.1293, -0.9167> }
    smooth_triangle { <-9.2056, 659.6792, 6.6204>, <-0.5152, 0.1522, 0.8435>, <-0.8889, 659.6792, 11.4308>, <-0.3443, 0.1209, 0.9310>, <2.2410, 676.0794, 10.6519>, <-0.3523, 0.1265, 0.9273> }
    smooth_triangle { <2.2410, 676.0794, 10.6519>, <-0.3523, 0.1265, 0.9273>, <-3.9834, 676.0794, 6.5809>, <-0.5352, 0.1599, 0.8295>, <-9.2056, 659.6792, 6.6204>, <-0.5152, 0.1522, 0.8435> }
    smooth_triangle { <-0.8889, 659.6792, 11.4308>, <-0.3443, 0.1209, 0.9310>, <15.7346, 659.6792, 14.2713>, <0.0000, 0.0859, 0.9963>, <15.7193, 676.0794, 12.7239>, <-0.0002, 0.0884, 0.9961> }
    smooth_triangle { <15.7193, 676.0794, 12.7239>, <-0.0002, 0.0884, 0.9961>, <2.2410, 676.0794, 10.6519>, <-0.3523, 0.1265, 0.9273>, <-0.8889, 659.6792, 11.4308>, <-0.3443, 0.1209, 0.9310> }
    smooth_triangle { <15.7193, 676.0794, 12.7239>, <-0.0002, 0.0884, 0.9961>, <29.1879, 676.0796, 10.6629>, <0.3532, 0.1270, 0.9269>, <25.8430, 692.4857, 9.7264>, <0.3687, 0.1367, 0.9194> }
    smooth_triangle { <25.8430, 692.4857, 9.7264>, <0.3687, 0.1367, 0.9194>, <15.7049, 692.4857, 11.1657>, <-0.0007, 0.0927, 0.9957>, <15.7193, 676.0794, 12.7239>, <-0.0002, 0.0884, 0.9961> }
    smooth_triangle { <29.1879, 676.0796, 10.6629>, <0.3532, 0.1270, 0.9269>, <35.4089, 676.0795, 6.5657>, <0.5373, 0.1611, 0.8279>, <30.2666, 692.4857, 6.5072>, <0.5740, 0.1738, 0.8002> }
    smooth_triangle { <30.2666, 692.4857, 6.5072>, <0.5740, 0.1738, 0.8002>, <25.8430, 692.4857, 9.7264>, <0.3687, 0.1367, 0.9194>, <29.1879, 676.0796, 10.6629>, <0.3532, 0.1270, 0.9269> }
    smooth_triangle { <35.4089, 676.0795, 6.5657>, <0.5731, 0.1688, -0.8019>, <29.3841, 676.0794, 2.1930>, <0.3828, 0.1342, -0.9140>, <25.9297, 692.4857, 3.1093>, <0.3924, 0.1417, -0.9088> }
    smooth_triangle { <25.9297, 692.4857, 3.1093>, <0.3924, 0.1417, -0.9088>, <30.2666, 692.4857, 6.5072>, <0.6019, 0.1786, -0.7783>, <35.4089, 676.0795, 6.5657>, <0.5731, 0.1688, -0.8019> }
    smooth_triangle { <29.3841, 676.0794, 2.1930>, <0.3828, 0.1342, -0.9140>, <15.6899, 676.0793, -0.1926>, <-0.0020, 0.0945, -0.9955>, <15.6883, 692.4857, 1.4822>, <-0.0025, 0.0973, -0.9953> }
    smooth_triangle { <15.6883, 692.4857, 1.4822>, <-0.0025, 0.0973, -0.9953>, <25.9297, 692.4857, 3.1093>, <0.3924, 0.1417, -0.9088>, <29.3841, 676.0794, 2.1930>, <0.3828, 0.1342, -0.9140> }
    smooth_triangle { <15.6899, 676.0793, -0.1926>, <-0.0020, 0.0945, -0.9955>, <2.0132, 676.0794, 2.2500>, <-0.3839, 0.1339, -0.9136>, <5.4548, 692.4857, 3.1633>, <-0.3933, 0.1408, -0.9086> }
    smooth_triangle { <5.4548, 692.4857, 3.1633>, <-0.3933, 0.1408, -0.9086>, <15.6883, 692.4857, 1.4822>, <-0.0025, 0.0973, -0.9953>, <15.6899, 676.0793, -0.1926>, <-0.0020, 0.0945, -0.9955> }
    smooth_triangle { <2.0132, 676.0794, 2.2500>, <-0.3839, 0.1339, -0.9136>, <-3.9834, 676.0794, 6.5809>, <-0.5716, 0.1679, -0.8032>, <1.1310, 692.4857, 6.5249>, <-0.5995, 0.1771, -0.7805> }
    smooth_triangle { <1.1310, 692.4857, 6.5249>, <-0.5995, 0.1771, -0.7805>, <5.4548, 692.4857, 3.1633>, <-0.3933, 0.1408, -0.9086>, <2.0132, 676.0794, 2.2500>, <-0.3839, 0.1339, -0.9136> }
    smooth_triangle { <-3.9834, 676.0794, 6.5809>, <-0.5352, 0.1599, 0.8295>, <2.2410, 676.0794, 10.6519>, <-0.3523, 0.1265, 0.9273>, <5.5613, 692.4857, 9.7088>, <-0.3670, 0.1357, 0.9203> }
    smooth_triangle { <5.5613, 692.4857, 9.7088>, <-0.3670, 0.1357, 0.9203>, <1.1310, 692.4857, 6.5249>, <-0.5700, 0.1721, 0.8035>, <-3.9834, 676.0794, 6.5809>, <-0.5352, 0.1599, 0.8295> }
    smooth_triangle { <2.2410, 676.0794, 10.6519>, <-0.3523, 0.1265, 0.9273>, <15.7193, 676.0794, 12.7239>, <-0.0002, 0.0884, 0.9961>, <15.7049, 692.4857, 11.1657>, <-0.0007, 0.0927, 0.9957> }
    smooth_triangle { <15.7049, 692.4857, 11.1657>, <-0.0007, 0.0927, 0.9957>, <5.5613, 692.4857, 9.7088>, <-0.3670, 0.1357, 0.9203>, <2.2410, 676.0794, 10.6519>, <-0.3523, 0.1265, 0.9273> }
    smooth_triangle { <15.7049, 692.4857, 11.1657>, <-0.0007, 0.0927, 0.9957>, <25.8430, 692.4857, 9.7264>, <0.3687, 0.1367, 0.9194>, <22.4193, 708.8863, 8.6649>, <0.3816, 0.1423, 0.9133> }
    smooth_triangle { <22.4193, 708.8863, 8.6649>, <0.3816, 0.1423, 0.9133>, <15.6930, 708.8863, 9.5912>, <-0.0007, 0.0958, 0.9954>, <15.7049, 692.4857, 11.1657>, <-0.0007, 0.0927, 0.9957> }
    smooth_triangle { <25.8430, 692.4857, 9.7264>, <0.3687, 0.1367, 0.9194>, <30.2666, 692.4857, 6.5072>, <0.5740, 0.1738, 0.8002>, <25.2565, 708.8863, 6.4500>, <0.6003, 0.1801, 0.7792> }
    smooth_triangle { <25.2565, 708.8863, 6.4500>, <0.6003, 0.1801, 0.7792>, <22.4193, 708.8863, 8.6649>, <0.3816, 0.1423, 0.9133>, <25.8430, 692.4857, 9.7264>, <0.3687, 0.1367, 0.9194> }
    smooth_triangle { <30.2666, 692.4857, 6.5072>, <0.6019, 0.1786, -0.7783>, <25.9297, 692.4857, 3.1093>, <0.3924, 0.1417, -0.9088>, <22.4443, 708.8863, 4.1479>, <0.3981, 0.1448, -0.9058> }
    smooth_triangle { <22.4443, 708.8863, 4.1479>, <0.3981, 0.1448, -0.9058>, <25.2565, 708.8863, 6.4500>, <0.6192, 0.1822, -0.7638>, <30.2666, 692.4857, 6.5072>, <0.6019, 0.1786, -0.7783> }
    smooth_triangle { <25.9297, 692.4857, 3.1093>, <0.3924, 0.1417, -0.9088>, <15.6883, 692.4857, 1.4822>, <-0.0025, 0.0973, -0.9953>, <15.6855, 708.8863, 3.1382>, <-0.0026, 0.0982, -0.9952> }
    smooth_triangle { <15.6855, 708.8863, 3.1382>, <-0.0026, 0.0982, -0.9952>, <22.4443, 708.8863, 4.1479>, <0.3981, 0.1448, -0.9058>, <25.9297, 692.4857, 3.1093>, <0.3924, 0.1417, -0.9088> }
    smooth_triangle { <15.6883, 692.4857, 1.4822>, <-0.0025, 0.0973, -0.9953>, <5.4548, 692.4857, 3.1633>, <-0.3933, 0.1408, -0.9086>, <8.9295, 708.8863, 4.1851>, <-0.3990, 0.1437, -0.9056> }
    smooth_triangle { <8.9295, 708.8863, 4.1851>, <-0.3990, 0.1437, -0.9056>, <15.6855, 708.8863, 3.1382>, <-0.0026, 0.0982, -0.9952>, <15.6883, 692.4857, 1.4822>, <-0.0025, 0.0973, -0.9953> }
    smooth_triangle { <5.4548, 692.4857, 3.1633>, <-0.3933, 0.1408, -0.9086>, <1.1310, 692.4857, 6.5249>, <-0.5995, 0.1771, -0.7805>, <6.1226, 708.8863, 6.4653>, <-0.6167, 0.1806, -0.7662> }
    smooth_triangle { <6.1226, 708.8863, 6.4653>, <-0.6167, 0.1806, -0.7662>, <8.9295, 708.8863, 4.1851>, <-0.3990, 0.1437, -0.9056>, <5.4548, 692.4857, 3.1633>, <-0.3933, 0.1408, -0.9086> }
    smooth_triangle { <1.1310, 692.4857, 6.5249>, <-0.5700, 0.1721, 0.8035>, <5.5613, 692.4857, 9.7088>, <-0.3670, 0.1357, 0.9203>, <8.9642, 708.8863, 8.6530>, <-0.3795, 0.1412, 0.9143> }
    smooth_triangle { <8.9642, 708.8863, 8.6530>, <-0.3795, 0.1412, 0.9143>, <6.1226, 708.8863, 6.4653>, <-0.5956, 0.1784, 0.7832>, <1.1310, 692.4857, 6.5249>, <-0.5700, 0.1721, 0.8035> }
    smooth_triangle { <5.5613, 692.4857, 9.7088>, <-0.3670, 0.1357, 0.9203>, <15.7049, 692.4857, 11.1657>, <-0.0007, 0.0927, 0.9957>, <15.6930, 708.8863, 9.5912>, <-0.0007, 0.0958, 0.9954> }
    smooth_triangle { <15.6930, 708.8863, 9.5912>, <-0.0007, 0.0958, 0.9954>, <8.9642, 708.8863, 8.6530>, <-0.3795, 0.1412, 0.9143>, <5.5613, 692.4857, 9.7088>, <-0.3670, 0.1357, 0.9203> }
    smooth_triangle { <15.6930, 708.8863, 9.5912>, <-0.0007, 0.0958, 0.9954>, <22.4193, 708.8863, 8.6649>, <0.3816, 0.1423, 0.9133>, <19.0091, 725.2927, 7.5318>, <0.3910, 0.1443, 0.9090> }
    smooth_triangle { <19.0091, 725.2927, 7.5318>, <0.3910, 0.1443, 0.9090>, <15.6846, 725.2930, 7.9945>, <-0.0005, 0.0978, 0.9952>, <15.6930, 708.8863, 9.5912>, <-0.0007, 0.0958, 0.9954> }
    smooth_triangle { <22.4193, 708.8863, 8.6649>, <0.3816, 0.1423, 0.9133>, <25.2565, 708.8863, 6.4500>, <0.6003, 0.1801, 0.7792>, <20.3903, 725.2927, 6.4025>, <0.6168, 0.1811, 0.7660> }
    smooth_triangle { <20.3903, 725.2927, 6.4025>, <0.6168, 0.1811, 0.7660>, <19.0091, 725.2927, 7.5318>, <0.3910, 0.1443, 0.9090>, <22.4193, 708.8863, 8.6649>, <0.3816, 0.1423, 0.9133> }
    smooth_triangle { <25.2565, 708.8863, 6.4500>, <0.6192, 0.1822, -0.7638>, <22.4443, 708.8863, 4.1479>, <0.3981, 0.1448, -0.9058>, <19.0116, 725.2930, 5.2507>, <0.4010, 0.1443, -0.9047> }
    smooth_triangle { <19.0116, 725.2930, 5.2507>, <0.4010, 0.1443, -0.9047>, <20.3903, 725.2927, 6.4025>, <0.6280, 0.1811, -0.7568>, <25.2565, 708.8863, 6.4500>, <0.6192, 0.1822, -0.7638> }
    smooth_triangle { <22.4443, 708.8863, 4.1479>, <0.3981, 0.1448, -0.9058>, <15.6855, 708.8863, 3.1382>, <-0.0026, 0.0982, -0.9952>, <15.6827, 725.2930, 4.7695>, <-0.0024, 0.0977, -0.9952> }
    smooth_triangle { <15.6827, 725.2930, 4.7695>, <-0.0024, 0.0977, -0.9952>, <19.0116, 725.2930, 5.2507>, <0.4010, 0.1443, -0.9047>, <22.4443, 708.8863, 4.1479>, <0.3981, 0.1448, -0.9058> }
    smooth_triangle { <15.6855, 708.8863, 3.1382>, <-0.0026, 0.0982, -0.9952>, <8.9295, 708.8863, 4.1851>, <-0.3990, 0.1437, -0.9056>, <12.3544, 725.2926, 5.2658>, <-0.4020, 0.1433, -0.9043> }
    smooth_triangle { <12.3544, 725.2926, 5.2658>, <-0.4020, 0.1433, -0.9043>, <15.6827, 725.2930, 4.7695>, <-0.0024, 0.0977, -0.9952>, <15.6855, 708.8863, 3.1382>, <-0.0026, 0.0982, -0.9952> }
    smooth_triangle { <8.9295, 708.8863, 4.1851>, <-0.3990, 0.1437, -0.9056>, <6.1226, 708.8863, 6.4653>, <-0.6167, 0.1806, -0.7662>, <10.9770, 725.2928, 6.4114>, <-0.6261, 0.1798, -0.7587> }
    smooth_triangle { <10.9770, 725.2928, 6.4114>, <-0.6261, 0.1798, -0.7587>, <12.3544, 725.2926, 5.2658>, <-0.4020, 0.1433, -0.9043>, <8.9295, 708.8863, 4.1851>, <-0.3990, 0.1437, -0.9056> }
    smooth_triangle { <6.1226, 708.8863, 6.4653>, <-0.5956, 0.1784, 0.7832>, <8.9642, 708.8863, 8.6530>, <-0.3795, 0.1412, 0.9143>, <12.3595, 725.2928, 7.5299>, <-0.3889, 0.1434, 0.9101> }
    smooth_triangle { <12.3595, 725.2928, 7.5299>, <-0.3889, 0.1434, 0.9101>, <10.9770, 725.2928, 6.4114>, <-0.6125, 0.1798, 0.7697>, <6.1226, 708.8863, 6.4653>, <-0.5956, 0.1784, 0.7832> }
    smooth_triangle { <8.9642, 708.8863, 8.6530>, <-0.3795, 0.1412, 0.9143>, <15.6930, 708.8863, 9.5912>, <-0.0007, 0.0958, 0.9954>, <15.6846, 725.2930, 7.9945>, <-0.0005, 0.0978, 0.9952> }
    smooth_triangle { <15.6846, 725.2930, 7.9945>, <-0.0005, 0.0978, 0.9952>, <12.3595, 725.2928, 7.5299>, <-0.3889, 0.1434, 0.9101>, <8.9642, 708.8863, 8.6530>, <-0.3795, 0.1412, 0.9143> }
    smooth_triangle { <15.6846, 725.2930, 7.9945>, <-0.0005, 0.0978, 0.9952>, <19.0091, 725.2927, 7.5318>, <0.3910, 0.1443, 0.9090>, <15.6802, 741.6930, 6.3694>, <0.0009, 0.1567, 0.9876> }
    smooth_triangle { <19.0091, 725.2927, 7.5318>, <0.3910, 0.1443, 0.9090>, <20.3903, 725.2927, 6.4025>, <0.6168, 0.1811, 0.7660>, <15.6802, 741.6930, 6.3694>, <0.0009, 0.1567, 0.9876> }
    smooth_triangle { <20.3903, 725.2927, 6.4025>, <0.6280, 0.1811, -0.7568>, <19.0116, 725.2930, 5.2507>, <0.4010, 0.1443, -0.9047>, <15.6802, 741.6930, 6.3694>, <-0.0008, 0.1561, -0.9877> }
    smooth_triangle { <19.0116, 725.2930, 5.2507>, <0.4010, 0.1443, -0.9047>, <15.6827, 725.2930, 4.7695>, <-0.0024, 0.0977, -0.9952>, <15.6802, 741.6930, 6.3694>, <-0.0008, 0.1561, -0.9877> }
    smooth_triangle { <15.6827, 725.2930, 4.7695>, <-0.0024, 0.0977, -0.9952>, <12.3544, 725.2926, 5.2658>, <-0.4020, 0.1433, -0.9043>, <15.6802, 741.6930, 6.3694>, <-0.0008, 0.1561, -0.9877> }
    smooth_triangle { <12.3544, 725.2926, 5.2658>, <-0.4020, 0.1433, -0.9043>, <10.9770, 725.2928, 6.4114>, <-0.6261, 0.1798, -0.7587>, <15.6802, 741.6930, 6.3694>, <-0.0008, 0.1561, -0.9877> }
    smooth_triangle { <10.9770, 725.2928, 6.4114>, <-0.6125, 0.1798, 0.7697>, <12.3595, 725.2928, 7.5299>, <-0.3889, 0.1434, 0.9101>, <15.6802, 741.6930, 6.3694>, <0.0009, 0.1567, 0.9876> }
    smooth_triangle { <12.3595, 725.2928, 7.5299>, <-0.3889, 0.1434, 0.9101>, <15.6846, 725.2930, 7.9945>, <-0.0005, 0.0978, 0.9952>, <15.6802, 741.6930, 6.3694>, <0.0009, 0.1567, 0.9876> }
    texture {
      wall_tex
    }
  }

  mesh { // Surf0 
    smooth_triangle { <15.7346, 659.6792, 14.2713>, <-0.0035, -0.0008, -1.0000>, <32.3428, 659.6792, 11.4210>, <-0.3255, -0.0017, -0.9455>, <32.3835, 577.6652, 11.2155>, <-0.3155, -0.0008, -0.9489> }
    smooth_triangle { <32.3835, 577.6652, 11.2155>, <-0.3155, -0.0008, -0.9489>, <15.8073, 577.6650, 14.5086>, <-0.0062, -0.0003, -1.0000>, <15.7346, 659.6792, 14.2713>, <-0.0035, -0.0008, -1.0000> }
    smooth_triangle { <32.3428, 659.6792, 11.4210>, <-0.3255, -0.0017, -0.9455>, <40.6722, 659.6792, 6.6134>, <-0.4618, -0.0031, -0.8870>, <42.0518, 577.6652, 6.6537>, <-0.4308, -0.0016, -0.9025> }
    smooth_triangle { <42.0518, 577.6652, 6.6537>, <-0.4308, -0.0016, -0.9025>, <32.3835, 577.6652, 11.2155>, <-0.3155, -0.0008, -0.9489>, <32.3428, 659.6792, 11.4210>, <-0.3255, -0.0017, -0.9455> }
    smooth_triangle { <40.6722, 659.6792, 6.6134>, <-0.5048, -0.0029, 0.8632>, <32.6908, 659.6792, 1.4545>, <-0.3557, 0.0002, 0.9346>, <33.0589, 577.6652, 1.8851>, <-0.3405, 0.0009, 0.9403> }
    smooth_triangle { <33.0589, 577.6652, 1.8851>, <-0.3405, 0.0009, 0.9403>, <42.0518, 577.6652, 6.6537>, <-0.4721, -0.0015, 0.8816>, <40.6722, 659.6792, 6.6134>, <-0.5048, -0.0029, 0.8632> }
    smooth_triangle { <32.6908, 659.6792, 1.4545>, <-0.3557, 0.0002, 0.9346>, <15.6891, 659.6792, -1.8805>, <-0.0022, 0.0027, 1.0000>, <15.7157, 577.6650, -1.6708>, <-0.0053, 0.0027, 1.0000> }
    smooth_triangle { <15.7157, 577.6650, -1.6708>, <-0.0053, 0.0027, 1.0000>, <33.0589, 577.6652, 1.8851>, <-0.3405, 0.0009, 0.9403>, <32.6908, 659.6792, 1.4545>, <-0.3557, 0.0002, 0.9346> }
    smooth_triangle { <15.6891, 659.6792, -1.8805>, <-0.0022, 0.0027, 1.0000>, <-1.2809, 659.6792, 1.4976>, <0.3604, -0.0007, 0.9328>, <-1.5282, 577.6650, 1.6595>, <0.3484, 0.0002, 0.9373> }
    smooth_triangle { <-1.5282, 577.6650, 1.6595>, <0.3484, 0.0002, 0.9373>, <15.7157, 577.6650, -1.6708>, <-0.0053, 0.0027, 1.0000>, <15.6891, 659.6792, -1.8805>, <-0.0022, 0.0027, 1.0000> }
    smooth_triangle { <-1.2809, 659.6792, 1.4976>, <0.3604, -0.0007, 0.9328>, <-9.2056, 659.6792, 6.6204>, <0.5173, -0.0033, 0.8558>, <-10.3284, 577.6650, 6.6467>, <0.4962, -0.0016, 0.8682> }
    smooth_triangle { <-10.3284, 577.6650, 6.6467>, <0.4962, -0.0016, 0.8682>, <-1.5282, 577.6650, 1.6595>, <0.3484, 0.0002, 0.9373>, <-1.2809, 659.6792, 1.4976>, <0.3604, -0.0007, 0.9328> }
    smooth_triangle { <-9.2056, 659.6792, 6.6204>, <0.4729, -0.0030, -0.8811>, <-0.8889, 659.6793, 11.4308>, <0.3281, -0.0022, -0.9446>, <-0.7345, 577.6649, 11.4495>, <0.3202, -0.0010, -0.9474> }
    smooth_triangle { <-0.7345, 577.6649, 11.4495>, <0.3202, -0.0010, -0.9474>, <-10.3284, 577.6650, 6.6467>, <0.4509, -0.0012, -0.8926>, <-9.2056, 659.6792, 6.6204>, <0.4729, -0.0030, -0.8811> }
    smooth_triangle { <-0.8889, 659.6793, 11.4308>, <0.3281, -0.0022, -0.9446>, <15.7346, 659.6792, 14.2713>, <-0.0035, -0.0008, -1.0000>, <15.8073, 577.6650, 14.5086>, <-0.0062, -0.0003, -1.0000> }
    smooth_triangle { <15.8073, 577.6650, 14.5086>, <-0.0062, -0.0003, -1.0000>, <-0.7345, 577.6649, 11.4495>, <0.3202, -0.0010, -0.9474>, <-0.8889, 659.6793, 11.4308>, <0.3281, -0.0022, -0.9446> }
    smooth_triangle { <15.8073, 577.6650, 14.5086>, <-0.0062, -0.0003, -1.0000>, <32.3835, 577.6652, 11.2155>, <-0.3155, -0.0008, -0.9489>, <32.1428, 495.6505, 10.9792>, <-0.3012, 0.0010, -0.9536> }
    smooth_triangle { <32.1428, 495.6505, 10.9792>, <-0.3012, 0.0010, -0.9536>, <15.8950, 495.6505, 14.6932>, <-0.0110, 0.0008, -0.9999>, <15.8073, 577.6650, 14.5086>, <-0.0062, -0.0003, -1.0000> }
    smooth_triangle { <32.3835, 577.6652, 11.2155>, <-0.3155, -0.0008, -0.9489>, <42.0518, 577.6652, 6.6537>, <-0.4308, -0.0016, -0.9025>, <42.8633, 495.6505, 6.6628>, <-0.3769, 0.0011, -0.9262> }
    smooth_triangle { <42.8633, 495.6505, 6.6628>, <-0.3769, 0.0011, -0.9262>, <32.1428, 495.6505, 10.9792>, <-0.3012, 0.0010, -0.9536>, <32.3835, 577.6652, 11.2155>, <-0.3155, -0.0008, -0.9489> }
    smooth_triangle { <42.0518, 577.6652, 6.6537>, <-0.4721, -0.0015, 0.8816>, <33.0589, 577.6652, 1.8851>, <-0.3405, 0.0009, 0.9403>, <33.1045, 495.6505, 2.2794>, <-0.3156, 0.0021, 0.9489> }
    smooth_triangle { <33.1045, 495.6505, 2.2794>, <-0.3156, 0.0021, 0.9489>, <42.8633, 495.6505, 6.6628>, <-0.4132, 0.0011, 0.9106>, <42.0518, 577.6652, 6.6537>, <-0.4721, -0.0015, 0.8816> }
    smooth_triangle { <33.0589, 577.6652, 1.8851>, <-0.3405, 0.0009, 0.9403>, <15.7157, 577.6650, -1.6708>, <-0.0053, 0.0027, 1.0000>, <15.7601, 495.6502, -1.5076>, <-0.0109, 0.0028, 0.9999> }
    smooth_triangle { <15.7601, 495.6502, -1.5076>, <-0.0109, 0.0028, 0.9999>, <33.1045, 495.6505, 2.2794>, <-0.3156, 0.0021, 0.9489>, <33.0589, 577.6652, 1.8851>, <-0.3405, 0.0009, 0.9403> }
    smooth_triangle { <15.7157, 577.6650, -1.6708>, <-0.0053, 0.0027, 1.0000>, <-1.5282, 577.6650, 1.6595>, <0.3484, 0.0002, 0.9373>, <-1.3888, 495.6503, 1.8344>, <0.3300, 0.0021, 0.9440> }
    smooth_triangle { <-1.3888, 495.6503, 1.8344>, <0.3300, 0.0021, 0.9440>, <15.7601, 495.6502, -1.5076>, <-0.0109, 0.0028, 0.9999>, <15.7157, 577.6650, -1.6708>, <-0.0053, 0.0027, 1.0000> }
    smooth_triangle { <-1.5282, 577.6650, 1.6595>, <0.3484, 0.0002, 0.9373>, <-10.3284, 577.6650, 6.6467>, <0.4962, -0.0016, 0.8682>, <-10.7539, 495.6505, 6.6487>, <0.4601, 0.0017, 0.8878> }
    smooth_triangle { <-10.7539, 495.6505, 6.6487>, <0.4601, 0.0017, 0.8878>, <-1.3888, 495.6503, 1.8344>, <0.3300, 0.0021, 0.9440>, <-1.5282, 577.6650, 1.6595>, <0.3484, 0.0002, 0.9373> }
    smooth_triangle { <-10.3284, 577.6650, 6.6467>, <0.4509, -0.0012, -0.8926>, <-0.7345, 577.6649, 11.4495>, <0.3202, -0.0010, -0.9474>, <-0.2159, 495.6505, 11.3940>, <0.3096, 0.0013, -0.9509> }
    smooth_triangle { <-0.2159, 495.6505, 11.3940>, <0.3096, 0.0013, -0.9509>, <-10.7539, 495.6505, 6.6487>, <0.4134, 0.0021, -0.9106>, <-10.3284, 577.6650, 6.6467>, <0.4509, -0.0012, -0.8926> }
    smooth_triangle { <-0.7345, 577.6649, 11.4495>, <0.3202, -0.0010, -0.9474>, <15.8073, 577.6650, 14.5086>, <-0.0062, -0.0003, -1.0000>, <15.8950, 495.6505, 14.6932>, <-0.0110, 0.0008, -0.9999> }
    smooth_triangle { <15.8950, 495.6505, 14.6932>, <-0.0110, 0.0008, -0.9999>, <-0.2159, 495.6505, 11.3940>, <0.3096, 0.0013, -0.9509>, <-0.7345, 577.6649, 11.4495>, <0.3202, -0.0010, -0.9474> }
    smooth_triangle { <15.8950, 495.6505, 14.6932>, <-0.0110, 0.0008, -0.9999>, <32.1428, 495.6505, 10.9792>, <-0.3012, 0.0010, -0.9536>, <31.6053, 413.6354, 10.7252>, <-0.2973, 0.0026, -0.9548> }
    smooth_triangle { <31.6053, 413.6354, 10.7252>, <-0.2973, 0.0026, -0.9548>, <15.9945, 413.6354, 14.8250>, <-0.0144, 0.0019, -0.9999>, <15.8950, 495.6505, 14.6932>, <-0.0110, 0.0008, -0.9999> }
    smooth_triangle { <32.1428, 495.6505, 10.9792>, <-0.3012, 0.0010, -0.9536>, <42.8633, 495.6505, 6.6628>, <-0.3769, 0.0011, -0.9262>, <43.0256, 413.6355, 6.6504>, <-0.3391, 0.0034, -0.9407> }
    smooth_triangle { <43.0256, 413.6355, 6.6504>, <-0.3391, 0.0034, -0.9407>, <31.6053, 413.6354, 10.7252>, <-0.2973, 0.0026, -0.9548>, <32.1428, 495.6505, 10.9792>, <-0.3012, 0.0010, -0.9536> }
    smooth_triangle { <42.8633, 495.6505, 6.6628>, <-0.4132, 0.0011, 0.9106>, <33.1045, 495.6505, 2.2794>, <-0.3156, 0.0021, 0.9489>, <32.7968, 413.6355, 2.6313>, <-0.3014, 0.0032, 0.9535> }
    smooth_triangle { <32.7968, 413.6355, 2.6313>, <-0.3014, 0.0032, 0.9535>, <43.0256, 413.6355, 6.6504>, <-0.3693, 0.0033, 0.9293>, <42.8633, 495.6505, 6.6628>, <-0.4132, 0.0011, 0.9106> }
    smooth_triangle { <33.1045, 495.6505, 2.2794>, <-0.3156, 0.0021, 0.9489>, <15.7601, 495.6502, -1.5076>, <-0.0109, 0.0028, 0.9999>, <15.8222, 413.6354, -1.3910>, <-0.0149, 0.0030, 0.9999> }
    smooth_triangle { <15.8222, 413.6354, -1.3910>, <-0.0149, 0.0030, 0.9999>, <32.7968, 413.6355, 2.6313>, <-0.3014, 0.0032, 0.9535>, <33.1045, 495.6505, 2.2794>, <-0.3156, 0.0021, 0.9489> }
    smooth_triangle { <15.7601, 495.6502, -1.5076>, <-0.0109, 0.0028, 0.9999>, <-1.3888, 495.6503, 1.8344>, <0.3300, 0.0021, 0.9440>, <-0.8409, 413.6353, 2.0225>, <0.3221, 0.0038, 0.9467> }
    smooth_triangle { <-0.8409, 413.6353, 2.0225>, <0.3221, 0.0038, 0.9467>, <15.8222, 413.6354, -1.3910>, <-0.0149, 0.0030, 0.9999>, <15.7601, 495.6502, -1.5076>, <-0.0109, 0.0028, 0.9999> }
    smooth_triangle { <-1.3888, 495.6503, 1.8344>, <0.3300, 0.0021, 0.9440>, <-10.7539, 495.6505, 6.6487>, <0.4601, 0.0017, 0.8878>, <-10.4329, 413.6353, 6.6361>, <0.4364, 0.0049, 0.8997> }
    smooth_triangle { <-10.4329, 413.6353, 6.6361>, <0.4364, 0.0049, 0.8997>, <-0.8409, 413.6353, 2.0225>, <0.3221, 0.0038, 0.9467>, <-1.3888, 495.6503, 1.8344>, <0.3300, 0.0021, 0.9440> }
    smooth_triangle { <-10.7539, 495.6505, 6.6487>, <0.4134, 0.0021, -0.9106>, <-0.2159, 495.6505, 11.3940>, <0.3096, 0.0013, -0.9509>, <0.6574, 413.6354, 11.2757>, <0.3089, 0.0034, -0.9511> }
    smooth_triangle { <0.6574, 413.6354, 11.2757>, <0.3089, 0.0034, -0.9511>, <-10.4329, 413.6353, 6.6361>, <0.3886, 0.0050, -0.9214>, <-10.7539, 495.6505, 6.6487>, <0.4134, 0.0021, -0.9106> }
    smooth_triangle { <-0.2159, 495.6505, 11.3940>, <0.3096, 0.0013, -0.9509>, <15.8950, 495.6505, 14.6932>, <-0.0110, 0.0008, -0.9999>, <15.9945, 413.6354, 14.8250>, <-0.0144, 0.0019, -0.9999> }
    smooth_triangle { <15.9945, 413.6354, 14.8250>, <-0.0144, 0.0019, -0.9999>, <0.6574, 413.6354, 11.2757>, <0.3089, 0.0034, -0.9511>, <-0.2159, 495.6505, 11.3940>, <0.3096, 0.0013, -0.9509> }
    smooth_triangle { <15.9945, 413.6354, 14.8250>, <-0.0144, 0.0019, -0.9999>, <31.6053, 413.6354, 10.7252>, <-0.2973, 0.0026, -0.9548>, <30.7543, 331.6211, 10.4667>, <-0.3030, 0.0041, -0.9530> }
    smooth_triangle { <30.7543, 331.6211, 10.4667>, <-0.3030, 0.0041, -0.9530>, <16.1023, 331.6210, 14.9041>, <-0.0164, 0.0031, -0.9999>, <15.9945, 413.6354, 14.8250>, <-0.0144, 0.0019, -0.9999> }
    smooth_triangle { <31.6053, 413.6354, 10.7252>, <-0.2973, 0.0026, -0.9548>, <43.0256, 413.6355, 6.6504>, <-0.3391, 0.0034, -0.9407>, <42.4602, 331.6211, 6.6266>, <-0.3148, 0.0054, -0.9492> }
    smooth_triangle { <42.4602, 331.6211, 6.6266>, <-0.3148, 0.0054, -0.9492>, <30.7543, 331.6211, 10.4667>, <-0.3030, 0.0041, -0.9530>, <31.6053, 413.6354, 10.7252>, <-0.2973, 0.0026, -0.9548> }
    smooth_triangle { <43.0256, 413.6355, 6.6504>, <-0.3693, 0.0033, 0.9293>, <32.7968, 413.6355, 2.6313>, <-0.3014, 0.0032, 0.9535>, <32.1082, 331.6210, 2.9353>, <-0.2980, 0.0042, 0.9545> }
    smooth_triangle { <32.1082, 331.6210, 2.9353>, <-0.2980, 0.0042, 0.9545>, <42.4602, 331.6211, 6.6266>, <-0.3396, 0.0053, 0.9405>, <43.0256, 413.6355, 6.6504>, <-0.3693, 0.0033, 0.9293> }
    smooth_triangle { <32.7968, 413.6355, 2.6313>, <-0.3014, 0.0032, 0.9535>, <15.8222, 413.6354, -1.3910>, <-0.0149, 0.0030, 0.9999>, <15.9022, 331.6210, -1.3209>, <-0.0176, 0.0033, 0.9998> }
    smooth_triangle { <15.9022, 331.6210, -1.3209>, <-0.0176, 0.0033, 0.9998>, <32.1082, 331.6210, 2.9353>, <-0.2980, 0.0042, 0.9545>, <32.7968, 413.6355, 2.6313>, <-0.3014, 0.0032, 0.9535> }
    smooth_triangle { <15.8222, 413.6354, -1.3910>, <-0.0149, 0.0030, 0.9999>, <-0.8409, 413.6353, 2.0225>, <0.3221, 0.0038, 0.9467>, <0.1321, 331.6210, 2.2212>, <0.3250, 0.0056, 0.9457> }
    smooth_triangle { <0.1321, 331.6210, 2.2212>, <0.3250, 0.0056, 0.9457>, <15.9022, 331.6210, -1.3209>, <-0.0176, 0.0033, 0.9998>, <15.8222, 413.6354, -1.3910>, <-0.0149, 0.0030, 0.9999> }
    smooth_triangle { <-0.8409, 413.6353, 2.0225>, <0.3221, 0.0038, 0.9467>, <-10.4329, 413.6353, 6.6361>, <0.4364, 0.0049, 0.8997>, <-9.3289, 331.6210, 6.6172>, <0.4246, 0.0080, 0.9053> }
    smooth_triangle { <-9.3289, 331.6210, 6.6172>, <0.4246, 0.0080, 0.9053>, <0.1321, 331.6210, 2.2212>, <0.3250, 0.0056, 0.9457>, <-0.8409, 413.6353, 2.0225>, <0.3221, 0.0038, 0.9467> }
    smooth_triangle { <-10.4329, 413.6353, 6.6361>, <0.3886, 0.0050, -0.9214>, <0.6574, 413.6354, 11.2757>, <0.3089, 0.0034, -0.9511>, <1.8728, 331.6210, 11.1088>, <0.3178, 0.0054, -0.9481> }
    smooth_triangle { <1.8728, 331.6210, 11.1088>, <0.3178, 0.0054, -0.9481>, <-9.3289, 331.6210, 6.6172>, <0.3750, 0.0077, -0.9270>, <-10.4329, 413.6353, 6.6361>, <0.3886, 0.0050, -0.9214> }
    smooth_triangle { <0.6574, 413.6354, 11.2757>, <0.3089, 0.0034, -0.9511>, <15.9945, 413.6354, 14.8250>, <-0.0144, 0.0019, -0.9999>, <16.1023, 331.6210, 14.9041>, <-0.0164, 0.0031, -0.9999> }
    smooth_triangle { <16.1023, 331.6210, 14.9041>, <-0.0164, 0.0031, -0.9999>, <1.8728, 331.6210, 11.1088>, <0.3178, 0.0054, -0.9481>, <0.6574, 413.6354, 11.2757>, <0.3089, 0.0034, -0.9511> }
    smooth_triangle { <16.1023, 331.6210, 14.9041>, <-0.0164, 0.0031, -0.9999>, <30.7543, 331.6211, 10.4667>, <-0.3030, 0.0041, -0.9530>, <29.5718, 249.6064, 10.2167>, <-0.3081, 0.0048, -0.9513> }
    smooth_triangle { <29.5718, 249.6064, 10.2167>, <-0.3081, 0.0048, -0.9513>, <16.2155, 249.6064, 14.9305>, <-0.0171, 0.0037, -0.9998>, <16.1023, 331.6210, 14.9041>, <-0.0164, 0.0031, -0.9999> }
    smooth_triangle { <30.7543, 331.6211, 10.4667>, <-0.3030, 0.0041, -0.9530>, <42.4602, 331.6211, 6.6266>, <-0.3148, 0.0054, -0.9492>, <41.0914, 249.6064, 6.5999>, <-0.3057, 0.0064, -0.9521> }
    smooth_triangle { <41.0914, 249.6064, 6.5999>, <-0.3057, 0.0064, -0.9521>, <29.5718, 249.6064, 10.2167>, <-0.3081, 0.0048, -0.9513>, <30.7543, 331.6211, 10.4667>, <-0.3030, 0.0041, -0.9530> }
    smooth_triangle { <42.4602, 331.6211, 6.6266>, <-0.3396, 0.0053, 0.9405>, <32.1082, 331.6210, 2.9353>, <-0.2980, 0.0042, 0.9545>, <31.0130, 249.6064, 3.1873>, <-0.2992, 0.0047, 0.9542> }
    smooth_triangle { <31.0130, 249.6064, 3.1873>, <-0.2992, 0.0047, 0.9542>, <41.0914, 249.6064, 6.5999>, <-0.3284, 0.0062, 0.9445>, <42.4602, 331.6211, 6.6266>, <-0.3396, 0.0053, 0.9405> }
    smooth_triangle { <32.1082, 331.6210, 2.9353>, <-0.2980, 0.0042, 0.9545>, <15.9022, 331.6210, -1.3209>, <-0.0176, 0.0033, 0.9998>, <15.9998, 249.6064, -1.2974>, <-0.0186, 0.0035, 0.9998> }
    smooth_triangle { <15.9998, 249.6064, -1.2974>, <-0.0186, 0.0035, 0.9998>, <31.0130, 249.6064, 3.1873>, <-0.2992, 0.0047, 0.9542>, <32.1082, 331.6210, 2.9353>, <-0.2980, 0.0042, 0.9545> }
    smooth_triangle { <15.9022, 331.6210, -1.3209>, <-0.0176, 0.0033, 0.9998>, <0.1321, 331.6210, 2.2212>, <0.3250, 0.0056, 0.9457>, <1.5417, 249.6064, 2.4257>, <0.3293, 0.0066, 0.9442> }
    smooth_triangle { <1.5417, 249.6064, 2.4257>, <0.3293, 0.0066, 0.9442>, <15.9998, 249.6064, -1.2974>, <-0.0186, 0.0035, 0.9998>, <15.9022, 331.6210, -1.3209>, <-0.0176, 0.0033, 0.9998> }
    smooth_triangle { <0.1321, 331.6210, 2.2212>, <0.3250, 0.0056, 0.9457>, <-9.3289, 331.6210, 6.6172>, <0.4246, 0.0080, 0.9053>, <-7.4182, 249.6064, 6.5977>, <0.4217, 0.0096, 0.9067> }
    smooth_triangle { <-7.4182, 249.6064, 6.5977>, <0.4217, 0.0096, 0.9067>, <1.5417, 249.6064, 2.4257>, <0.3293, 0.0066, 0.9442>, <0.1321, 331.6210, 2.2212>, <0.3250, 0.0056, 0.9457> }
    smooth_triangle { <-9.3289, 331.6210, 6.6172>, <0.3750, 0.0077, -0.9270>, <1.8728, 331.6210, 11.1088>, <0.3178, 0.0054, -0.9481>, <3.4161, 249.6064, 10.9081>, <0.3248, 0.0064, -0.9458> }
    smooth_triangle { <3.4161, 249.6064, 10.9081>, <0.3248, 0.0064, -0.9458>, <-7.4182, 249.6064, 6.5977>, <0.3709, 0.0091, -0.9286>, <-9.3289, 331.6210, 6.6172>, <0.3750, 0.0077, -0.9270> }
    smooth_triangle { <1.8728, 331.6210, 11.1088>, <0.3178, 0.0054, -0.9481>, <16.1023, 331.6210, 14.9041>, <-0.0164, 0.0031, -0.9999>, <16.2155, 249.6064, 14.9305>, <-0.0171, 0.0037, -0.9998> }
    smooth_triangle { <16.2155, 249.6064, 14.9305>, <-0.0171, 0.0037, -0.9998>, <3.4161, 249.6064, 10.9081>, <0.3248, 0.0064, -0.9458>, <1.8728, 331.6210, 11.1088>, <0.3178, 0.0054, -0.9481> }
    smooth_triangle { <-1.2809, 659.6792, 1.4976>, <0.0000, -1.0000, 0.0000>, <15.6891, 659.6792, -1.8805>, <0.0000, -1.0000, -0.0000>, <-0.8889, 659.6793, 11.4308>, <-0.0000, -1.0000, -0.0000> }
    smooth_triangle { <-0.8889, 659.6793, 11.4308>, <-0.0000, -1.0000, -0.0000>, <-9.2056, 659.6792, 6.6204>, <0.0000, -1.0000, 0.0000>, <-1.2809, 659.6792, 1.4976>, <0.0000, -1.0000, 0.0000> }
    smooth_triangle { <15.6891, 659.6792, -1.8805>, <0.0000, -1.0000, -0.0000>, <15.7346, 659.6792, 14.2713>, <0.0000, -1.0000, 0.0000>, <-0.8889, 659.6793, 11.4308>, <-0.0000, -1.0000, -0.0000> }
    smooth_triangle { <32.6908, 659.6792, 1.4545>, <0.0000, -1.0000, -0.0000>, <40.6722, 659.6792, 6.6134>, <0.0000, -1.0000, -0.0000>, <32.3428, 659.6792, 11.4210>, <0.0000, -1.0000, -0.0000> }
    smooth_triangle { <15.7346, 659.6792, 14.2713>, <0.0000, -1.0000, 0.0000>, <15.6891, 659.6792, -1.8805>, <0.0000, -1.0000, -0.0000>, <32.3428, 659.6792, 11.4210>, <0.0000, -1.0000, -0.0000> }
    smooth_triangle { <32.3428, 659.6792, 11.4210>, <0.0000, -1.0000, -0.0000>, <15.6891, 659.6792, -1.8805>, <0.0000, -1.0000, -0.0000>, <32.6908, 659.6792, 1.4545>, <0.0000, -1.0000, -0.0000> }
    smooth_triangle { <-7.4182, 249.6064, 6.5977>, <0.0000, 1.0000, -0.0000>, <3.4161, 249.6064, 10.9081>, <-0.0000, 1.0000, 0.0000>, <1.5417, 249.6064, 2.4257>, <-0.0000, 1.0000, 0.0000> }
    smooth_triangle { <1.5417, 249.6064, 2.4257>, <-0.0000, 1.0000, 0.0000>, <3.4161, 249.6064, 10.9081>, <-0.0000, 1.0000, 0.0000>, <15.9998, 249.6064, -1.2974>, <-0.0000, 1.0000, 0.0000> }
    smooth_triangle { <16.2155, 249.6064, 14.9305>, <-0.0000, 1.0000, 0.0000>, <29.5718, 249.6064, 10.2167>, <-0.0000, 1.0000, -0.0000>, <26.8102, 249.6064, 1.9319>, <-0.0000, 1.0000, -0.0000> }
    smooth_triangle { <26.8102, 249.6064, 1.9319>, <-0.0000, 1.0000, -0.0000>, <15.9998, 249.6064, -1.2974>, <-0.0000, 1.0000, 0.0000>, <16.2155, 249.6064, 14.9305>, <-0.0000, 1.0000, 0.0000> }
    smooth_triangle { <16.2155, 249.6064, 14.9305>, <-0.0000, 1.0000, 0.0000>, <15.9998, 249.6064, -1.2974>, <-0.0000, 1.0000, 0.0000>, <3.4161, 249.6064, 10.9081>, <-0.0000, 1.0000, 0.0000> }
    smooth_triangle { <29.5718, 249.6064, 10.2167>, <-0.0000, 1.0000, -0.0000>, <41.0914, 249.6064, 6.5999>, <-0.0000, 1.0000, -0.0000>, <31.0130, 249.6064, 3.1873>, <-0.0000, 1.0000, -0.0000> }
    smooth_triangle { <31.0130, 249.6064, 3.1873>, <-0.0000, 1.0000, -0.0000>, <26.8102, 249.6064, 1.9319>, <-0.0000, 1.0000, -0.0000>, <29.5718, 249.6064, 10.2167>, <-0.0000, 1.0000, -0.0000> }
    texture {
      wall_tex
    }
  } 
  }

  //object{sword scale 0.25}