#include "colors.inc"   
#include "textures.inc"
#include "metals.inc" 
#include "hosttex.inc"

global_settings{ 
  assumed_gamma 2.5  
}     
    
   
//#declare useLizard=1    
//#declare useHostage=1
#declare useMedia = 0   // off
//#declare useMedia = 1   // lowRes
//#declare useMedia = 2     // hiRes


#if (useMedia != 0) 
  #if (useMedia = 1)
    #declare roomInterior =
        interior {
      media {
        scattering {1, rgb<0.05, 0.05, 0.055>*.8 extinction .1}  
        ratio .999
        confidence .9
        variance 1/1000
        samples 3, 10
        intervals 6
      } 
        }
  #end
    
  #if (useMedia = 2)
    #declare roomInterior =
        interior {
      media {
        scattering {1, rgb<0.05, 0.05, 0.055>*.8 extinction .1}  
        ratio .999
        confidence .9
        variance 1/1000
        samples 20, 100
        intervals 10
      }  
    }  
  #end   
        
  #declare containerTexture =
        texture {
                pigment { color rgbf<1,1,1,1> }
                finish { ambient .1 diffuse 0.7 }
        } 
        
        
  #declare lightRayMaterial =
        material {
                texture {containerTexture  }
                interior {roomInterior} 
        }               
  
  merge{
    box {<2.8,0,0>,<10,9.75,-8>}
    box{<3,9.5,-4>,<7,10.75,-8>}
    hollow 
    material { lightRayMaterial } 
  }  
#end  // #if (useMedia != 0) 


light_source{<-10,100,-35> color White*1.55 media_attenuation off}

light_source{<6,8,-9> color White*.45
  media_interaction off media_attenuation off  
  fade_distance 14 fade_power 3   
}  

camera{
  location <8, 6, -17> 
  direction 1*z
  right     4/3*x
  look_at   <4, 4,  0.0>
}


//=========================================
// Straight wall and round wall macro for Pov-ray 3.1 & higher
// (c) 1999 Gilles Tran tran@inapg.inra.fr
//-----------------------------------------
// The brick can be a box or an ellipsoid
// These macros make quite simplistic walls
// You may need to modify them, particularly the texture part
//-----------------------------------------

//============<<< start right wall >>>======================
#macro 
MakeWall(typeWall,pEllipsoid,xWall,yWall,eMortar,eWall,
         xBrickMin,xBrickMax,yBrickMin,yBrickMax,seedWall,
         srd1,srd2,srdcol,patternWall,pigWall,txtMortar)
// MakeWall : creates a brick wall in the x-y plane, starting at <0,0,0>
// of length xWall and height yWall
//-----------------------------------------
#local R1=seed(seedWall);
#switch (typeWall)
  #case (1)
    #local Brick=box{-1,1}
    #break
  #case (2)
    #local Brick=superellipsoid{<pEllipsoid,pEllipsoid>}
    #break
#end
union{
  box{0,<xWall,yWall,1> texture{txtMortar} translate eWall*z}
  union{
    #local yFlag=0;
    #local yMax=0;
    #local yPos=(yBrickMin+yBrickMax)*0.5+eMortar;
    #local yBrick=0;
    #local nRow=0;
    #while (yPos<=yWall)
      #local nRow=nRow+1;
      #warning concat("row ",str(nRow,0,0),"\n")
      #if (yFlag=0)
        #local xPos=0;
      #else
        #local xPos=0.0001;
      #end
      #while (xPos<=xWall)
        #switch (patternWall)
          #case (1) // no gradient
            #local spatternWall=1;
            #break
          #case (2) // gradient y up
            #local spatternWall=(yPos+0.2)/(yWall-0.2);
            #break
          #case (3) // gradient y down
            #local spatternWall=1-((yPos+0.2)/(yWall-0.2));
            #break 
        #end
        #local txtBrick=texture{
                          pigment{
                            #if (patternWall>0)
                              marble
                              turbulence 1
                              color_map {
                                [0.0 color Gray70]
                                [0.03 color Gray70]
                                [0.1 color rgb <0.9, 0.75, 0.65>*(1 - (.4*rand(R1)))]
                                [1.0 color rgb <0.9, 0.75, 0.65>*(1 - (.4*rand(R1)))]
                              }
                            #else
                              color pigWall   // uniform color
                            #end
                            scale .2
                          }
                          normal {granite 1.8 scale .75}
                          scale<.5,.5,1>
                          finish{ambient 0.05 
                         //   specular 0.1 
                            roughness 0.2 
                            crand .15
                          }
                          scale 12
                          translate<rand(R1)*20,rand(R1)*30,rand(R1)*10>
                          rotate<0,0,rand(R1)*360>
                        }
        #local xBrick=(xBrickMin+xBrickMax)*0.5*(rand(R1)*srd1+1);
        #local xBrick=max(min(xBrick,xBrickMax),xBrickMin);
        #if (xPos+2*xBrick>xWall)
          #local xBrick=(xWall-xPos)*0.5;
        #end
        #local yBrick=(yBrickMin+yBrickMax)*0.5*(rand(R1)*srd1+1);
        #local yBrick=max(min(yBrick,yBrickMax),yBrickMin);
        #local rBrick=<rand(R1)-0.5,rand(R1)-0.5,0>*20*srd2;
        #if (yFlag=0 & xPos=0)
          #local xPos=xBrick*0.5;
          object{Brick rotate rBrick scale <xBrick*0.5,yBrick+eMortar*(rand(R1)-0.5)*srd1*0.5,1> 
                 translate <xPos,yPos,0> texture{txtBrick}}
          #local xPos=xPos+xBrick*0.5 + eMortar*(1+rand(R1)*srd1);
        #else
          #local xPos=xPos+xBrick;
          object{Brick rotate rBrick scale <xBrick,yBrick +eMortar*(rand(R1)-0.5)*srd1*0.5,1> 
                 translate <xPos,yPos,0> texture{txtBrick}}
          #local xPos=xPos+xBrick + eMortar*(1+rand(R1)*srd1);
        #end
      #end
      #if (yPos+yBrick>yMax)
        #local yMax=yPos+yBrick;
      #end
      #local yPos=yPos+(yBrickMin+yBrickMax)+eMortar*(1+rand(R1)*srd1);
      #if (yFlag=0) #local yFlag=1; #else #local yFlag=0; #end
    #end
    scale <1,yWall/yMax,1>
  }
}
#end
//============<<< end right wall >>>======================



//============<<< start floor in hallway >>>======================
#macro //also thanks to Gilles Tran
MakeFloor(typeWall,pEllipsoid,xWall,yWall,eMortar,eWall,
         xBrickMin,xBrickMax,yBrickMin,yBrickMax,seedWall,
         srd1,srd2,srdcol,patternWall,pigWall,txtMortar)

#local R1=seed(seedWall);
#switch (typeWall)
  #case (1)
    #local Brick=box{-1,1}
    #break
  #case (2)
    #local Brick=superellipsoid{<pEllipsoid,pEllipsoid>}
    #break
#end
union{
  box{0,<xWall,yWall,1> texture{txtMortar} translate eWall*z}
  union{
    #local yFlag=0;
    #local yMax=0;
    #local yPos=(yBrickMin+yBrickMax)*0.5+eMortar;
    #local yBrick=0;
    #local nRow=0;
    #while (yPos<=yWall)
      #local nRow=nRow+1;
      #warning concat("row ",str(nRow,0,0),"\n")
      #if (yFlag=0)
        #local xPos=0;
      #else
        #local xPos=0.0001;
      #end
      #while (xPos<=xWall)
        #switch (patternWall)
          #case (1) // no gradient
            #local spatternWall=1;
            #break
          #case (2) // gradient y up
            #local spatternWall=(yPos+0.2)/(yWall-0.2);
            #break
          #case (3) // gradient y down
            #local spatternWall=1-((yPos+0.2)/(yWall-0.2));
            #break 
        #end
        #local txtBrick=texture{
                          pigment{
                            #if (patternWall>0)
                              marble
                              turbulence 1
                              color_map {
                                [0.0 color Gray50]
                                [0.0125 color Gray50]
                                [0.0125 color rgb <0.8, 0.75, 0.8>*(1 - (.3*rand(R1)))]
                                [1.0 color rgb <0.8, 0.75, 0.8>*(1 - (.3*rand(R1)))]
                              }
                            #else
                              color pigWall   // uniform color
                            #end
                            scale .2
                          }
                          normal {granite 1.8}
                          finish{ambient 0.1 specular 0.1 roughness 0.05 crand .2}
                          scale <12,12,18>
                          translate<rand(R1)*10,rand(R1)*10,rand(R1)*10>
                          rotate<0,0,rand(R1)*360>
                        }
        #local xBrick=(xBrickMin+xBrickMax)*0.5*(rand(R1)*srd1+1);
        #local xBrick=max(min(xBrick,xBrickMax),xBrickMin);
        #if (xPos+2*xBrick>xWall)
          #local xBrick=(xWall-xPos)*0.5;
        #end
        #local yBrick=(yBrickMin+yBrickMax)*0.5*(rand(R1)*srd1+1);
        #local yBrick=max(min(yBrick,yBrickMax),yBrickMin);
        #local rBrick=<rand(R1)-0.5,rand(R1)-0.5,0>*20*srd2;
        #if (yFlag=0 & xPos=0)
          #local xPos=xBrick*0.5;
          object{Brick rotate rBrick scale <xBrick*0.5,yBrick+eMortar*(rand(R1)-0.5)*srd1*0.5,1> translate <xPos,yPos,0> texture{txtBrick}}
          #local xPos=xPos+xBrick*0.5 + eMortar*(1+rand(R1)*srd1);
        #else
          #local xPos=xPos+xBrick;
          object{Brick rotate rBrick scale <xBrick,yBrick + eMortar*(rand(R1)-0.5)*srd1*0.5,1> 
                 translate <xPos,yPos,0> texture{txtBrick}}
          #local xPos=xPos+xBrick + eMortar*(1+rand(R1)*srd1);
        #end
      #end
      #if (yPos+yBrick>yMax)
        #local yMax=yPos+yBrick;
      #end
      #local yPos=yPos+(yBrickMin+yBrickMax)+eMortar*(1+rand(R1)*srd1);
      #if (yFlag=0) #local yFlag=1; #else #local yFlag=0; #end
    #end
    scale <1,yWall/yMax,1>
  }
}
#end
//============<<< end floor in hallway >>>======================

#declare pigWall=rgb<0.89,0.9,0.95>*1.8;    // wall main color
#declare txtMortar=texture{pigment{rgb<0.89,0.9,0.95>*1.0}} // mortar texture
//-----------------------------------------


#declare bsize=2.5
#declare typeWall=2;         // 1=box ; 2=ellipsoid
#declare pEllipsoid=0.1;     // usual ellipsoid parameter
#declare xWall=10;           // wall length in x
#declare yWall=10;           // wall height in y
#declare eMortar=.005;       // mortar thickness
#declare eWall=20;           // mortar depth
#declare xBrickMin=1/bsize;      // min brick size
#declare xBrickMax=3/bsize;      // max brick size
#declare yBrickMin=0.75/bsize;   // min brick height
#declare yBrickMax=1.5/bsize;    // max brick height
#declare seedWall=100;       // seed wall
#declare srd1=0.5/2;         // randomness amount for brick position (0=no random)
#declare srd2=0.2/2;         // randomness amount for brick rotation (0=no random)
#declare srdcol=0.5;         // randomness amount for color (0=no random)
#declare patternWall=1;      // y color gradient for wall texture
                             // 0=uniform color
                             // 1=no color gradient
                             // 2=from dark to light
                             // 3=from light to dark


#declare pigWall=rgb<0.89,0.9,0.95>*1.8;    // wall main color
#declare txtMortar=texture{pigment{rgb<0.89,0.9,0.95>*1.0}} // mortar texture
//-----------------------------------------

#declare xWall=12;           // wall length in x
#declare yWall=10;           // wall height in y

//call macro for right wall
object{MakeWall(typeWall,pEllipsoid,xWall,yWall,eMortar,
                eWall,xBrickMin,xBrickMax,yBrickMin,yBrickMax,seedWall,
                srd1,srd2,srdcol,patternWall,pigWall,txtMortar)
             
  rotate<0,90,0>     
  translate<11,-.5,0>
}  
      


#declare txtMortar=texture{pigment{rgb <0.8, 0.75, 0.8>*.6}} // mortar texture
#declare bsize=4 
#declare srd2=0.05;             // randomness amount for brick rotation (0=no random)
#declare xBrickMin=2/bsize;     // min brick size
#declare xBrickMax=3/bsize;     // max brick size
#declare yBrickMin=1.0/bsize;   // min brick height
#declare yBrickMax=1.5/bsize;   // max brick height
#declare eWall=20;              // mortar depth     
#declare eMortar=.001;          // mortar thickness


#declare xWall=11;              // wall length in x
#declare yWall=11;              // wall height in y
#declare srd1=0.2;              // randomness amount for brick position (0=no random)
#declare srd2=0.075;            // randomness amount for brick rotation (0=no random)   
     

#declare pEllipsoid=0.05;       // usual ellipsoid parameter
#declare xWall=8;               // wall length in x
#declare yWall=20;              // wall height in y      

// call macro for hallway floor
object{MakeFloor(typeWall,pEllipsoid,xWall,yWall,eMortar,
                eWall,xBrickMin,xBrickMax,yBrickMin,yBrickMax,seedWall,
                srd1,srd2,srdcol,patternWall,pigWall,txtMortar)
             
  rotate<90,0,0>     
  translate<-9,.5,-9>
}  


//============<<< cell start floor >>>====================
height_field{
  tga               
  "hf_floo2.tga"    
  smooth       
  water_level .001 
  texture{
    pigment{
      image_map { tga "im_floor.tga" map_type 0 interpolate 2 once }  
    }  
      rotate x*90 // lay X-Y image map down onto X-Z height field plan
  }
  scale<10,.3,10> 
      finish{crand .05 } 
      normal { granite -.3 scale <1,1,2>/2000}
      
  translate<0,-.2,-9.875>
}            
//============<<< end cell floor >>>====================


//============<<< start back wall >>>====================
union{   
  height_field{
    tga               
    "hf_brick.tga"    
    smooth       
    water_level .2 
    texture{
      pigment{
        image_map { tga "im_brick.tga" map_type 0 interpolate 2 once }  
      }  
        finish{crand .05} 
        normal { granite -.3 scale <1,1,2>/2000}
        rotate x*90 // lay X-Y image map down onto X-Z height field plan
    }
    rotate<-90,0,0> 
    scale<1,1,1.09> 
  } 
 
  box{<0,0,-.33>,<1,1,1> // add the mortar
    texture{
      pigment{White*.7}
      finish{crand .05} 
      normal { granite -.75 scale <1,1,2>/2000}
    } 
  } 
  
  
  height_field{ //add the plaster
    tga             
    "hf_stuca.tga"    
    rotate<-90,0,0>  
    scale<1,1,1.125>
    translate<0,0,0>
  }
  
  scale <14,10,.15>
  texture{
    pigment{LightWood*.85}    
    finish{ambient .1 crand .04}
    normal{
      crackle .1 
      scale <0.4,.4,.05>*.7
      turbulence .3
    }
  }
 
  translate<0,-.5,-1>
}
//============<<< end back wall >>>====================


//============<<< start left wall >>>====================
difference{
  union{   
    height_field{ //add the bricks
      tga               
      "hf_brick.tga"   
      smooth       
      water_level .2  
      texture{
        pigment{
          image_map { tga "im_brick.tga" map_type 0 interpolate 2 once }  
        }  
        finish{crand .05} 
        normal { granite -.3 scale <1,1,2>/2000}
        rotate x*90 // lay X-Y image map down onto X-Z height field plan
      }
      rotate<-90,0,0> 
      scale<1,1,1.125> 
    } 
   
    box{<0,0,-.55>,<1,1,1> // add mortar 
      texture{
        pigment{White*.7}
        finish{crand .05} 
        normal { granite -.75 scale <1,1,2>/2000}
      } 
    } 
    
    
    height_field{ //add plaster
      tga              
      "hf_stucb.tga"          
      rotate<-90,0,0>  
      scale<1,1,1.125>
      translate<0,0,.05>
    }
    
    scale <14,10,.15>
    rotate<0,-90,0> 
    texture{
      pigment{LightWood*.85}    
      finish{ambient .1 crand .1}
      normal{
        crackle .1 
        scale <0.05,.4,.4>*.7
        turbulence .3
      }
    }
    translate<0,-.5,-15>
  }
  
  box{<-5,1.5,-2.5>,<5,8.5,-6.5> //cut out doorway
      texture{
      pigment{LightWood*.85}    
      finish{ambient .075 crand .1}
      normal{
        crackle .1 
        scale <0.05,.4,.4>*.7
        turbulence .3
      }
    }
  }
  box{<-1,-1,2>,<-5,12,-12> } //cut off the bricks at the hallway
} 
//============<<< end left wall >>>====================


//===========<<< start cell door >>>===========================
union{
  box{<-4,4.7,.15>,<-.2-.1,5.4,-.15>  scale<1,1,.75>}
  box{<-4,8.2,.15>,<-.2-.1,8.4,-.15>   scale<1,1,.75>}
  box{<-4,1.7,.15>,<-.2-.1,1.9,-.15>   scale<1,1,.75>}
  box{<-4,1.7,.15>,<-3.8-.1,8.4,-.15>   scale<1,1,.75>}
  box{<-.4-.1,1.7,.15>,<-.2-.1,8.4,-.15>  scale<1,1,.75> }

  box{<-.1,2.5,.4>,<0,3.5,-.2> }
  box{<-.1,6.75,.4>,<0,7.75,-.2>  }

  cylinder{<-1,1.7,0>,<-1,8.4,0>, .055 translate<-.2,0,0>}
  cylinder{<-1.5,1.7,0>,<-1.5,8.4,0>, .055 translate<-.2,0,0>}
  cylinder{<-2,1.7,0>,<-2,8.4,0>, .055 translate<-.2,0,0>}
  cylinder{<-2.5,1.7,0>,<-2.5,8.4,0>, .055 translate<-.2,0,0>}
  cylinder{<-3,1.7,0>,<-3,8.4,0>, .055 translate<-.2,0,0>}

  texture{RustyIron2 scale<1,2,1>/3}
  rotate<0,-90,0>
  translate<-.375,0,-2.5>
  no_shadow
}
//===========<<< end cell door >>>===========================



//================<start make hole in ceiling >  ===================
#declare xx=0;            
#while (xx < 4) //steel bars
  cylinder{<3.5+xx,10.25+.03,-4>,<3.5+xx,10.25+.03,-8>, .75/12
  texture{RustyIron translate<xx,0,0>}}  
  #declare xx=xx+.875;
#end  

#declare zz=0;            
#while (zz < 4)  //more steel bars
  cylinder{<3,10.25-.03,-4.5-zz>,<7,10.25-.03,-4.5-zz>, .75/12
  texture{RustyIron translate<0,0,zz>}} 
  #declare zz=zz+.875;
#end  

difference{ // make steel frame                   
  box{<2.8,10,-3.8>,<7.2,9.95,-8.2>} 
  box{<3,8,-4>,<7,12,-8>}
  texture{RustyIron2 } 
} 


union{ // make steel frame
  box{<3,10.5,-4>,<3.05,9.96,-8>}
  box{<8,10.5,-4>,<7.9,9.96,-8>}
  box{<3,10.5,-4>,<7,9.96,-4.05>}
  texture {
    gradient y       
    texture_map {
      [0.0  Rusttex  scale<.2,1,.2>]
      [0.15  RustyIron scale<.5,2,.2> translate<1,0,0>]
      [1.0  RustyIron ]                
    }
    translate<0,2,0>
  }
}
//================<end make hole in ceiling >  ===================


// hall ceiling
box{<-100,10.25,100>,<-.25,10.5,-110> 
  texture{
    pigment{LightWood*.85}    
    finish{ambient .4 crand .05}
    normal{
      crackle .05 
      scale <0.1,.3,.3>*.75
      turbulence .3
    }
  }
}  

//left wall in hallway
box{<-9,1.0,-20>,<-10,10,20>
  texture{
    pigment{LightWood*.85}    
    finish{ambient .2 crand .05}
    normal{
      crackle .05 
      scale <0.1,.3,.3>*.75
      turbulence .3
    }
  }
} 

 
#declare hallLight= 
light_source{ 
  <0,-4,0>/12,
  color White*.65
  fade_distance 10 
  fade_power 5 
  media_interaction off 
  looks_like { 
    merge{ 
      cylinder{<0,0,0>,<0,-5.0,0>/12,2/12} 
      sphere{<0,-5,0>/12,2/12} 
      texture {
        pigment { Yellow + White*2.75}
        finish {
          ambient 0.25
        }
      }  
    }    
  }  
}

// add the hall lights  
object{hallLight translate<-6.75,10,20> }
object{hallLight translate<-6.75,10,5> }
object{hallLight translate<-6.75,10,-10> }
     
  
//==============<<< start add wood beams for ceiling >>>=================  
     
box{<-.5,9.5,0>,<10.5,10,.5> texture{oldWood translate<0,5,0>}
  rotate<0,-90,0> translate<.125,0,-10> 
}  

box{<-.5,9.5,0>,<10.5,10,.5> texture{oldWood translate<0,-5,0>}
  rotate<0,90,0> translate<10,0,0>
}


box{<-.5,9.5,-.3>,<10.5,10,.5> texture{oldWood}}
box{<-.5,9.51,0-3.75>,<10.5,10.01,.5-3.75> texture{oldWood}}
box{<-.5,9.5,0-3.73>,<10.5,10,.5-3.73> texture{oldWood rotate<90,0,0>}}


box{<-.5,9.51,0-7.77>,<10.5,10.01,.5-7.77> texture{oldWood}}
box{<-.5,9.5,0-7.75>,<10.5,10,.5-7.75> texture{oldWood rotate<90,0,0>}}
  
superellipsoid{ <0.2,  0.2> translate <1,1,-.90>  scale<.5,.25,11>
  texture{oldWood2 rotate<90,0,0>   rotate<0,90,0>}    translate<0,10,0>
}
superellipsoid{ <0.2,  0.2> translate <1,1,-.90>  scale<.5,.25,11>
  texture{oldWood2 rotate<90,90,0>  translate<1,0,1>}  translate<1,10,0>
} 
superellipsoid{ <0.2,  0.2> translate <1,1,-.90>  scale<.5,.25,11>
  texture{oldWood2 rotate<90,90,0>  translate<2,0,0>}  translate<2,10,0>
}
superellipsoid{ <0.2,  0.2> translate <1,1,-.90>  scale<.5,.25,11>
  texture{oldWood2 rotate<90,90,0>  translate<4,0,0>}  translate<8,10,0>
}
superellipsoid{ <0.2,  0.2> translate <1,1,-.90>  scale<.5,.25,11>
  texture{oldWood2 rotate<90,90,0>  translate<8,0,4>}  translate<9,10,0>
}
superellipsoid{ <0.2,  0.2> translate <1,1,-.90>  scale<.5,.25,11>
  texture{oldWood2 rotate<90,90,0>  translate<5,0,0>}  translate<10,0,0>
}
 
difference{  
  union{
    superellipsoid{ <0.2,  0.2> translate <1,1,-.90>  scale<.5,.25,11>
      texture{oldWood2 rotate<90,90,0>  translate<4,0,2>}  translate<3,10,0>
    }
    superellipsoid{ <0.2,  0.2> translate <1,1,-.90>  scale<.5,.25,11>
      texture{oldWood2 rotate<90,90,0>  translate<6,0,0>}  translate<4,10,0>
    }
    superellipsoid{ <0.2,  0.2> translate <1,1,-.90>  scale<.5,.25,11>
      texture{oldWood2 rotate<90,90,0>  translate<7,0,5>}  translate<5,10,0>
    }
    superellipsoid{ <0.2,  0.2> translate <1,1,-.90>  scale<.5,.25,11>
      texture{oldWood2 rotate<90,90,0>  translate<8,0,8>}  translate<6,10,0>
    }
    superellipsoid{ <0.2,  0.2> translate <1,1,-.90>  scale<.5,.25,11>
      texture{oldWood2 rotate<90,90,0>  translate<2,0,0>}  translate<7,10,0>
    }
  }
  box{<3,9,-4>,<7,15,-8>} //cut hole in ceiling
} 
//==============<<< end add wood beams for ceiling >>>=================  


//========<<< start drain cover >>>========
#declare cutout=
union{
  cylinder{<3.75,.5,0>/12,<3.75,-.5,0>/12, .25/12}
  cylinder{<-3.75,.5,0>/12,<-3.75,-.5,0>/12, .25/12}
  box{<3.75,-.5,.25>/12,<-3.75,.5,-.25>/12}
}
 
#declare drainCover= 
difference{ 
  cylinder{<0,0,0>,<0,.25,0>/12, 4.5/12}
  object{cutout} 
  object{cutout scale<.85,1,1> translate<0,0,1.5>/12} 
  object{cutout scale<.85,1,1> translate<0,0,-1.5>/12} 
  object{cutout scale<.5,1,1> translate<0,0,-3>/12} 
  object{cutout scale<.5,1,1> translate<0,0,3>/12}  
  texture{Rusty_Iron}  
}  
//========<<< end drain cover >>>========


object{drainCover  rotate<0,8,0> translate<5,-.07/12,-5>}  

#ifdef (useLizard) // add lizard on left wall
  #include "lizard.inc"
  object{lizard scale <1/80,1/80,1/100> rotate<30,0,0>
  translate<.25,6.5,-7.5> finish{ambient 1.25}}
#end  


//*************************************************************
//   TRIANGLE MAPPING MACRO FILE FOR PERSISTENCE OF VISION 3.1
//*************************************************************
//Created by Chris Colefax, 1 June 1999;  
#include "Trimap.mcr"  
#declare OBJuvPOVmaxX =  .118046;
#declare OBJuvPOVminX = -.125225;
#declare OBJuvPOVmaxY =  .391451;
#declare OBJuvPOVminY = -.00348002;
#declare OBJuvPOVmaxZ =  .335286;
#declare OBJuvPOVminZ = -.120767;   


#declare Hairsilvx=1;
#declare Hair_Texture = // the man's hair  
texture{
  pigment{
    bozo
    turbulence 0.2 
    omega 0.2
    color_map {    
      [0.0 Silver*Hairsilvx]
      [0.4 Silver]
      [0.45 Black]
      [0.5 Silver*Hairsilvx]
      [0.7 Silver*Hairsilvx]
      [0.75 Black]
      [0.8 Silver*Hairsilvx]
      [1.0 Silver]
    }    
    scale <8,.25,.25> 
  } 
  normal{  
    bump_map { 
      tga "woodmap.tga"
      interpolate 2
      bump_size 9
    }  
    scale 10 //13
  } 
  finish {ambient .1}
  rotate<90,0,0>
  scale <1,1,.01>*5
}  

//textures for the Poser dude
#declare OBJuvPOV_Texture_OBJuvPOVpants = texture {pigment{SteelBlue*.75} normal {granite -.15 scale .1}}
#declare OBJuvPOV_Texture_OBJuvPOVbelt = texture {pigment{Red}}
#declare OBJuvPOV_Texture_OBJuvPOVbuckle = texture {pigment{Yellow}}
#declare OBJuvPOV_Texture_OBJuvPOVshirt = texture {pigment{White*.9} normal {granite -.15 scale .1}}
#declare OBJuvPOV_Texture_OBJuvPOVskin = texture {pigment{Flesh*.9} finish{ambient .15}
                                                  normal {crackle .125 turbulence .2 scale .0001}
                                                  finish {specular 0.25 roughness 0.01}
                                                 }
#declare OBJuvPOV_Texture_OBJuvPOVlashes = texture {pigment{Black}}
#declare OBJuvPOV_Texture_OBJuvPOVtongue = texture {pigment{Red}}
#declare OBJuvPOV_Texture_OBJuvPOVteeth = texture {pigment{White}}
#declare OBJuvPOV_Texture_OBJuvPOVeyeBrows = texture {pigment{Brown}}
#declare OBJuvPOV_Texture_OBJuvPOVlips = texture {pigment{Flesh*.9}}
#declare OBJuvPOV_Texture_OBJuvPOVinnerMouth = texture {pigment{Red}}
#declare OBJuvPOV_Texture_OBJuvPOVpupil = texture {pigment{Black}}
#declare OBJuvPOV_Texture_OBJuvPOViris = texture {pigment{Blue}}
#declare OBJuvPOV_Texture_OBJuvPOVeyeBall = texture {pigment{White}}
#declare OBJuvPOV_Texture_OBJuvPOVnails = texture {pigment{Flesh*.8}}
#declare OBJuvPOV_Texture_OBJuvPOVsocks = texture {pigment{Blue*.5}}
#declare OBJuvPOV_Texture_OBJuvPOVshoes = texture {pigment{SemiSweetChoc}}
#declare OBJuvPOV_Texture_OBJuvPOVsouls = texture {pigment{Black}}
#declare OBJuvPOV_Texture_OBJuvPOVlaces = texture {pigment{VeryDarkBrown}}
#declare OBJuvPOV_Texture_OBJuvPOVhair = texture {Hair_Texture rotate<0,90,0> scale 1 finish{ambient .15}}

#ifdef (useHostage)
  #declare ConvObject =
  union{
    #include "hostage2.inc"
  }
  object {ConvObject  rotate<0,45,0> scale 9.0 translate<7.70,0,-3.5>}
#end
                                                                    
                                                                      
                                                                      
sky_sphere{pigment{ White*.5 + Blue*.75}}

//make sure the sky doesn't come through any cracks in the ceiling
box{<8,10.25,2>,<12,10.5,-12> pigment{Black}}
box{<0,10.25,2>,<12,10.5,-3.7> pigment{Black}}
    
    
//add water for the low areas of the floor     
box{<0,-.035,-5>,<3.25,-.5,-10> 
  texture{Quiet_Water}
}

// water running to the drain
box{<-1,-.035,.5>,<12,-.5,-.5>                 
  rotate<0,26,0> 
  translate<5,0,-5>
  texture{Quiet_Water}
}  

//=============<<< start add dirt in floor >>>=================
difference{  
  union{   
    height_field{
      tga             
      "hf_floo3.tga"    
      smooth       
      water_level .001 
      pigment{DarkBrown}
      scale<10,.9,10> 
      finish{crand .05  } 
      normal { granite -.3 scale <1,1,2>/2000}
    }            
    translate<0,-.78,-10>
  } 

//cutout the water areas
  box{<0,-2,-6>,<3.25,5,-10> }
  box{<3,-2,-8>,<5,5,-10> }
  box{<-1,-2,.5>,<12,5,-.5> 
    rotate<0,26,0> 
    translate<5,0,-5>
  }
}
//=============<<< end add dirt in floor >>>=================
