// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.1
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?[esp]
//

#version 3.1

#include "colors.inc"

global_settings
{                                              
  assumed_gamma 2.2  
}                                                

// ----------------------------------------
camera
{
  location  <0, 750, 0>
  direction 20*y                     
  right     4/4*x
  look_at   <0, 0.0,  0>
}


light_source
{
  0*x // light's position (translated below)
  color White*1.5
  translate <0, 10000, 0>
}

// ----------------------------------------
                          
#declare oneBrick =
  superellipsoid{ <.2,.3> 
    scale<1,1,.5> 
  }     


#declare roty= seed(12345);
#declare randz= seed(125);
#declare bright = seed(315);  
#declare R1 = seed(315);  

                
#declare xoffset = 0;
#declare xx = -20;
#declare zz = -20  
union{
  #while (zz < 20)
    #declare xx = -20;
    #while (xx < 20)
      object{oneBrick 
        rotate<rand(roty)*2,rand(roty)*2,rand(roty)*2>
        translate<xx+xoffset+ rand(randz)*.15,rand(randz)*.05,zz+ rand(randz)*.1>   
        texture{
 //         pigment{White * (1 - (.125*rand(bright))) } 
          pigment{color rgb <0.7, 0.70, 0.85>*(1 - (.2*rand(R1)))}
  //        normal{dents 2 scale .2 } 
  //        scale .75
  //        finish {crand .2 }  
        }       
        
      }
      #declare xx = xx + 2.05;                                               
    #end
    #declare zz = zz + 1.05;                      
    #if (xoffset=1)
      #declare xoffset=0;
    #else
      #declare xoffset=1;
    #end  
  #end  
  

}

