// Persistence of Vision Ray Tracer Scene Description File
// File: IceCastle.inc
// Vers: unofficial megapov 0.7
// Desc:  
// Date: 30 March 2001
// Auth: Gail Shaw

#version unofficial megapov 0.6;

#include "IceCastleTex.inc"  
#include "banner.inc"    
#include "flag.inc"   

#declare rnd=seed(3821); 

#declare Aurora1= 
 isosurface {
  function {((sin(x*1.5 +3.5 )*0.85+sin(x*2.5 + 0.75 )*0.5 +sin(x/2+13.2)*0.15 +sin(x/7+pi/2)*3 + z) & (sin(-x*1.5 -3.5)*0.9 +sin(-x*2.5 -0.75)*0.5+sin(-x/2-13.2)*0.15+sin(-x/7-pi/2)*3 -z)-2)}
  threshold 0        
  method 2
  //eval
  max_gradient 2
  contained_by {
   box {
    <-12.5,-13,-7>,<12.5,12,7>
   }
  }
  scale <2,1,1>
  pigment {rgbf 1} //<1,0,0,0.8>} 
  finish {ambient 0 diffuse 0}  
  no_shadow
  hollow
  interior {
   media {
    emission 0.15      
    absorption 0.2
    intervals 20
    samples 1, 20
    confidence 0.9999
    variance 1/1000
    method 3
    density {
     gradient y 
     turbulence 0.1
     color_map {
      [0.0 rgb 0.6]
      //[0.8 rgb 0.5]
      [1.0 rgb 0]
     }                
     translate y*-0.5
     scale 24
    }
    density {
     planar 
     turbulence 0.2
     color_map {
      [0.0 rgb 0]
      [0.3 rgb 0.5]
      [1.0 rgb 0.6]
     }                
     translate y*0.5
     scale 26
    }
    density {
     gradient x
     triangle_wave  
     turbulence 0.02
     color_map {
      [0.0 rgb 1]
      [0.46 rgb 0.9]
      [0.48 rgb 0.4]
      [0.5 rgb 0.85]
      [0.7 rgb 0.75]
      [1.0 rgb 0]
     }       
     translate x*0.05
     scale <48,5,5>
    }
    density {
     function {((sin(x*1.5 +3.5 )*0.85+sin(x*2.5 + 0.75 )*0.5 +sin(x/2+13.2)*0.15 +sin(x/7+pi/2)*3 + z) & (sin(-x*1.5 -3.5)*0.9 +sin(-x*2.5 -0.75)*0.5+sin(-x/2-13.2)*0.15+sin(-x/7-pi/2)*3 -z)-1)}
     turbulence 0.1
     cubic_wave
     color_map {
      //[0.0 rgb 1]
      //[0.5 rgb 0.3]
      //[1.0 rgb 0]
      [0.0 rgb 0.3]
      [1.0 rgb 0.8]
     }
     //scale <2,2,1>
     scale 2
    }
    density {
     bozo               
     turbulence 0.25
     color_map {
      [0.0 rgb <0.7,1,0.5>]
      [0.1 rgb <0.7,1,0.5>]
      [0.5 rgb <0.5,1,0.5>]
      [0.85 rgb <0.5,1,0.85>]
      [1.0 rgb <0.5,1,0.85>]
     }
     scale <1.5,8,1.5>
    }
   }
  }
 }  

#declare Aurora2=
 isosurface {
  function {((sin(x/1.5 +3.124)*1.5+sin(x*1.2 + 0.71 )*1.25  +sin(x*5+pi/3)*0.2 + z) & (sin(-x/1.5 -3.124)*1.5+sin(-x*1.2 - 0.71 )*1.25  +sin(-x*5-pi/3)*0.2 -z)-2)}
  threshold 0
  method 2
  max_gradient 2
  contained_by {box {<-17.5,-17,-6>,<17.5,15,6>}}
  pigment {rgbf 1}
  finish {ambient 0 diffuse 0}
  hollow                                 
  scale <2,1,1>
  interior {
   media {
    emission 0.6
    absorption 0.75
    intervals 20
    samples 1, 20
    confidence 0.9999
    variance 1/1000
    method 3 
    density {
     planar
     turbulence 0.1
     color_map {
      [0.0 rgb 0]
      [1.0 rgb 0.9]
     }         
     translate y*-0.5
     scale 30
    }
    density {
     planar 
     turbulence 0.05
     color_map {
      [0.0 rgb 0]
      [0.2 rgb 0.7]
      [1.0 rgb 0.9]
     }                
     translate y*0.5
     scale 32
    } 
    density {
     gradient x
     turbulence 0.2
     triangle_wave
     color_map {
      [0.0 rgb 0.7]
      [0.3 rgb 0.9]
      [1.0 rgb 1]
     }
     scale <1,2,1>    
    }  
    density {
     gradient x
     color_map {
      [0.0 rgb 0.4]
      [1.0 rgb 1]
     }
     scale 17.5*2    
    }
    density {
     function {((sin(x/1.5 +3.124)*1.5+sin(x*1.2 + 0.71 )*1.25  +sin(x*10+pi/3)*0.5 + z) & (sin(-x/1.5 -3.124)*1.5+sin(-x*1.2 - 0.71 )*1.25  +sin(-x*10-pi/3)*0.5 -z)-2)}
     turbulence 0.05
     cubic_wave
     color_map {
      [0.0 rgb 0.4]
      [1.0 rgb 0.95]
     }
    }
    density {
     gradient y 
     turbulence 0.1
     color_map {
      [0.0 rgb <1,1,0.4>*1.5]
      [0.8 rgb <1,0.4,0.4>]
      [1.0 rgb <1,0.4,0.4>]
     }
     translate y*-0.5
     scale 30
    }
   }
  }
  scale <2,2.5,1.5>       
  no_shadow
  rotate y*15 
  translate <0,5,50>
 }

 
#macro Tower(Height,Radius,Overhang,OverhangHeight,RoofHeight)
 union {     
  difference {
   cylinder {
    <0,0,0>,<0,Height,0>,Radius
   }
   cylinder {
    <0,-0.1,0>,<0,Height*0.95,0>,Radius*0.95
   }
  } 
  #if (Overhang>0)
   cone {
    <0,Height-OverhangHeight*1.2+1.5,0>,Radius,<0,Height-OverhangHeight+1.5,0>,Radius+Overhang
   }
   difference {
    cylinder {
     <0,Height-OverhangHeight+1.5,0>,<0,Height+0.5,0>,Radius+Overhang
    }
    cylinder {
     <0,Height-OverhangHeight*1.01+0.5,0>,<0,Height+0.7,0>,(Radius+Overhang)*0.9
    }
    #local Around=0;
    #while (Around<180)
     box {
      <-(Radius+Overhang)*1.01,Height+0.2,-0.15>,<(Radius+Overhang)*1.01,Height+0.51,0.15>
      rotate y*Around
     }               
     #local Around=Around+degrees(asin(0.6/(2*Radius+Overhang))*2);
    #end    
   }
  #end //if
  /*union {
   cone {
    <0,Height,0>,Radius*1.075,<0,Height+RoofHeight,0>,0
   }
   difference {
    torus {
     Radius*1.075-RoofHeight*0.025,RoofHeight*0.025
    }
    box {
     <-Radius*1.075-RoofHeight*0.03,0,-Radius*1.075-RoofHeight*0.03>,<Radius*1.075+RoofHeight*0.03,RoofHeight*0.03,Radius*1.075+RoofHeight*0.05>
    }
    scale <1,2,1>
    translate y*(Height)
   }
   texture {Metal}
  }*/
 }
#end 

#macro CentralTower(Height,Radius,Overhang,OverhangHeight,RoofHeight)
 union {     
  difference {
   union {
    cylinder {
     <0,0,0>,<0,Height,0>,Radius
    }
    #if (Overhang>0)
     cone {
      <0,Height-OverhangHeight*1.25,0>,Radius,<0,Height-OverhangHeight,0>,Radius+Overhang
     }
     cylinder {
      <0,Height-OverhangHeight,0>,<0,Height,0>,Radius+Overhang
     }
    #end //if
   }
   cylinder {
    <0,-0.1,0>,<0,Height*1.1,0>,Radius*0.95
   }
   cylinder {
    <0,Height-OverhangHeight*1.01,0>,<0,Height,0>,(Radius+Overhang)*0.93
   }
   #local Around=0;
   #while (Around<180)
    box {
     <-(Radius+Overhang)*1.05,Height-OverhangHeight*2/3,-0.15>,<(Radius+Overhang)*1.05,Height-OverhangHeight/3,0.15>
     rotate y*Around    
    }               
    #local Around=Around+degrees(asin(1.2/(2*Radius+Overhang))*2);
   #end
  }
  union {
   lathe{
  	cubic_spline
  	11,
  	<0.000000,0.002124>,
  	<0.000000,0.002124>,
  	<0.339894,0.002124>,
  	<0.361137,0.002124>,
  	<0.361137,0.023368>,
  	<0.212434,0.172071>,
  	<0.106217,0.384505>,
  	<0.042487,0.703156>,
  	<0.021243,0.915589>,
  	<0.000000,1.000563>,
  	<0.000000,1.000563>
  	scale <(Radius*1.075+Overhang)/0.36,RoofHeight*1.1,(Radius*1.075+Overhang)/0.36>
  	translate y*(Height-RoofHeight*0.025)
   }
   cylinder {
    <0,Height+RoofHeight/2,0>,<0,Height+RoofHeight*1.35,0>,Radius*0.1
   }
   /*object {
    HalfSphere(Radius*1.075+Overhang)
    //scale <1,0.75,1>
    translate y*(Height-RoofHeight*0.025)
   }
   torus {
    Radius/2,RoofHeight*0.025
    translate y*(Height+(Radius*1.075+Overhang)*0.9-RoofHeight*0.025)
   }
   cone {
    <0,Height+(Radius*1.075+Overhang)*0.9-RoofHeight*0.025,0>,Radius/2,<0,Height+RoofHeight+(Radius*1.075+Overhang)*0.975,0>,0
   }
   torus {
    Radius*1.075+Overhang-RoofHeight*0.025,RoofHeight*0.025
    scale <1,3,1>
    translate y*(Height-RoofHeight*0.025)
   }*/
   texture {Metal}
   //pigment {Red}
  }
 }
#end

#declare GateHouse=
 union {
  difference {
   object {Tower(20,3,0.75,3.5,4)}
   box {
    <-0.15,-0.5,-3.1>,<0.15,0.5,-2.8>
    rotate y*-10
    translate y*11
   }
   box {
    <-0.15,-0.5,-3.1>,<0.15,0.5,-2.8>
    rotate y*25
    translate y*15
   }
   box {
    <-0.15,-0.5,-3.1>,<0.15,0.5,-2.8>
    rotate y*40
    translate y*7
   }
   translate z*-25 rotate y*-12 translate <0,-5,-15>
  }
  difference {
   object {Tower(20,3,0.75,3.5,4)} 
   box {
    <-0.15,-0.5,-3.1>,<0.15,0.5,-2.5>
    rotate y*10
    translate y*11
   }
   box {
    <-0.15,-0.5,-3.1>,<0.15,0.5,-2.8>
    rotate y*-25
    translate y*15
   } 
   box {
    <-0.15,-0.5,-3.1>,<0.15,0.5,-2.8>
    rotate y*-45
    translate y*7
   }
   translate z*-25 rotate y*12 translate <0,-5,-15>
  }
  difference {
   box {
    <-7,11.5,-40>,<7,14,-39>
   }
   box {
    <-6.9,13.2,-39.25>,<6.9,14.2,-39.75>
   }                      
   cylinder {
    <0,11.5,-38>,<0,11.5,-41>,1.5
    scale <2,1,1>
   }               
  }
  difference {
   union {
    box {
     <-5.7,11.5,-40>,<-4.7,14,-25>
    }
    box {
     <5.7,11.5,-40>,<4.7,14,-25>
    }              
   }
   cylinder {
    <-6,0,0>,<6,0,0>,1.5
    scale <1,1,3>
    translate <0,11.5,-32.5>
   }
  }
  texture {T_Ice} interior {I_Ice}
 }

#declare OuterWalls=
 union {      
  difference {
   cylinder {
    <0,0,0>,<0,10,0>,26
   }                   
   cylinder {
    <0,-0.1,0>,<0,11,0>,24
   }
   cylinder {
    <0,9.25,0>,<0,11,0>,25.25
   }
   box {
    <-0.8,2,-26.5>,<0.8,4.25,-21>
   }
   cylinder {
    <0,4.25,-26.5>,<0,4.25,-21>,0.8
   }
   #local Around=0;
    #while (Around<180)
     box {
      <-26.5,9.5,-0.25>,<26.5,10.1,0.25>
      rotate y*Around
     }               
     #local Around=Around+degrees(asin(1.25/(2*25))*2);
    #end
  }
  difference {
   object {
    Tower(15,3,0.5,4.5,5)
   }
   box {
    <-0.15,-0.5,-3.1>,<0.15,0.5,-2.5>
    rotate y*4
    translate y*6
   } 
   box {
    <-0.15,-0.5,-3.1>,<0.15,0.5,-2.5>
    rotate y*-18
    translate y*10
   } 
   box {
    <-0.15,-0.5,-3.1>,<0.15,0.5,-2.5>
    rotate y*18
    translate y*10
   }
   translate z*-25
   rotate y*-12
  }
  cylinder {
   <0,12,-25>,<0,18,-25>,0.15
   texture {
    T_Wood8 rotate x*90
   }      
   rotate y*-12
  }
  object {     
   Flag2    
   rotate y*12
   translate <0,18,-25>
   rotate y*-12
  }
  difference {
   object {
    Tower(15,3,0.5,4.5,5)
   }
   box {
    <-0.15,-0.5,-3.1>,<0.15,0.5,-2.5>
    rotate y*4
    translate y*6
   } 
   box {
    <-0.15,-0.5,-3.1>,<0.15,0.5,-2.5>
    rotate y*-18
    translate y*10
   } 
   box {
    <-0.15,-0.5,-3.1>,<0.15,0.5,-2.5>
    rotate y*18
    translate y*10
   }
   translate z*-25
   rotate y*12
  }      
  cylinder {
   <0,12,-25>,<0,18,-25>,0.15
   texture {
    T_Wood8 rotate x*90
   }      
   rotate y*12
  }
  object {     
   Flag2 
   rotate y*-12
   translate <0,18,-25>
   rotate y*12
  }
  difference {
   object {
    Tower(15,3,0.5,4.5,5)
   }
   box {
    <-0.15,-0.5,-3.1>,<0.15,0.5,-2.5>
    rotate y*4
    translate y*6
   } 
   box {
    <-0.15,-0.5,-3.1>,<0.15,0.5,-2.5>
    rotate y*-18
    translate y*10
   } 
   box {
    <-0.15,-0.5,-3.1>,<0.15,0.5,-2.5>
    rotate y*18
    translate y*10
   }
   translate z*-25
   rotate y*65
  }
  difference {
   object {
    Tower(15,3,0.5,4.5,5)
   }
   box {
    <-0.15,-0.5,-3.1>,<0.15,0.5,-2.5>
    rotate y*4
    translate y*6
   } 
   box {
    <-0.15,-0.5,-3.1>,<0.15,0.5,-2.5>
    rotate y*-18
    translate y*10
   } 
   box {
    <-0.15,-0.5,-3.1>,<0.15,0.5,-2.5>
    rotate y*18
    translate y*10
   }
   translate z*-25
   rotate y*-65
  } 
  difference {
   object {
    Tower(15,3,0.5,4.5,5)
   }
   box {
    <-0.15,-0.5,-3.1>,<0.15,0.5,-2.5>
    rotate y*4
    translate y*6
   } 
   box {
    <-0.15,-0.5,-3.1>,<0.15,0.5,-2.5>
    rotate y*-18
    translate y*10
   } 
   box {
    <-0.15,-0.5,-3.1>,<0.15,0.5,-2.5>
    rotate y*18
    translate y*10
   }
   translate z*-25
   rotate y*145
  }           
  difference {
   object {
    Tower(15,3,0.5,4.5,5)
   }
   box {
    <-0.15,-0.5,-3.1>,<0.15,0.5,-2.5>
    rotate y*4
    translate y*6
   } 
   box {
    <-0.15,-0.5,-3.1>,<0.15,0.5,-2.5>
    rotate y*-18
    translate y*10
   } 
   box {
    <-0.15,-0.5,-3.1>,<0.15,0.5,-2.5>
    rotate y*18
    translate y*10
   }
   translate z*-25
   rotate y*-145
  }
  texture {T_Ice} interior {I_Ice}         
 }

#declare SecondWalls=
 union {
  difference {
   cylinder {
    <0,0,0>,<0,15,0>,17
   }                   
   cylinder {
    <0,-0.1,0>,<0,16,0>,14
   }
   cylinder {
    <0,14.25,0>,<0,16,0>,16
   }
   #local Around=0;
    #while (Around<180)
     box {
      <-17.5,14.5,-0.25>,<17.5,15.1,0.25>
      rotate y*Around
     }               
     #local Around=Around+degrees(asin(1.25/(2*16))*2);
    #end 
  }
  object {
   Tower(20,2.5,0.5,4,5.5)
   translate z*-16
  }
  object {
   Tower(20,2.5,0.5,4,5.5)
   translate z*-16
   rotate y*-40
  }
  object {
   Tower(20,2.5,0.5,4,5.5)
   translate z*-16
   rotate y*40
  }
  object {
   Tower(20,2.5,0.5,4,5.5)
   translate z*-16
   rotate y*-100
  }            
  object {
   Tower(20,2.5,0.5,4,5.5)
   translate z*-16
   rotate y*100
  } 
  object {
   Tower(20,2.5,0.5,4,5.5)
   translate z*-16
   rotate y*180
  }
  texture {T_Ice} interior {I_Ice}
 }            
 
#declare InnerWalls=
 union {
  difference {
   cylinder {
    <0,0,0>,<0,20,0>,10
   }                   
   cylinder {
    <0,-0.1,0>,<0,21,0>,7
   }
   cylinder {
    <0,19.25,0>,<0,21,0>,9
   }
   #local Around=0;
    #while (Around<180)
     box {
      <-10.5,19.5,-0.25>,<10.5,20.1,0.25>
      rotate y*Around
     }               
     #local Around=Around+degrees(asin(1.25/(2*10))*2);
    #end 
  }
  object {
   Tower(25,2,0.5,4,6)
   translate z*-9
   rotate y*-20
  }
  object {
   Tower(25,2,0.5,4,6)
   translate z*-9
   rotate y*20
  }
  object {
   Tower(25,2,0.5,4,6)
   translate z*-9
   rotate y*70
  }        
  object {
   Tower(25,2,0.5,4,6)
   translate z*-9
   rotate y*-70
  }
  object {
   Tower(25,2,0.5,4,6)
   translate z*-9
   rotate y*-130
  }            
  object {
   Tower(25,2,0.5,4,6)
   translate z*-9
   rotate y*130
  }
  texture {T_Ice} interior {I_Ice}           
 }

#declare CentralTowers=
 union {           
  object {CentralTower(32,2,0.4,3,7) translate z*-3 rotate y*30}
  object {CentralTower(37,2,0.4,3,7) translate z*-3 rotate y*150}
  object {CentralTower(42,2,0.4,3,7) translate z*-3 rotate y*280}  
  texture {T_Ice} interior {I_Ice}
 }

#declare Bridge=
 intersection {
  merge {
   difference {
    cylinder {
     <-3,0,0>,<3,0,0>,63.6
    }
    cylinder {
     <-4,0,0>,<4,0,0>,62.6
    }
   }
   torus {
    63.1,0.5
    rotate z*90 
    scale <0.5,1,1>
    translate x*-2.6
   }
   torus {
    63.1,0.5
    rotate z*90      
    scale <0.5,1,1>
    translate x*2.6
   }
   box {
    <-3,63.6,0>,<3,62.6,-5>
   }
   cylinder {
    <0,63.1,0>,<0,63.1,-5>,0.5
    scale <0.5,1,1> 
    translate x*-2.6
   }            
   cylinder {
    <0,63.1,0>,<0,63.1,-5>,0.5
    scale <0.5,1,1> 
    translate x*-2.6
   }
  }
  box {
   <-4.5,0,-5>,<4.5,64,-64>
  }               
  no_shadow
  scale <1,1,3>
  material {M_Bridge}
 }
   

#declare Castle= 
 union {   
  //object {GateHouse}   
  object {OuterWalls}
  object {SecondWalls}
  object {InnerWalls}     
  object {CentralTowers}           
  texture {T_Ice} 
  interior {I_Ice}
 }
 
#declare Banner=
 union {
  cylinder {
   <0,-5,0.2>,<0,0.5,0.2>,0.075
   texture {
    T_Wood8 rotate x*90
   }
   rotate z*-10
  }
  cylinder {
   <-1.1,0.075,0>,<1.1,0.075,0>,0.075
   rotate z*-10
   texture {
    T_Wood8 rotate y*90
   }
  }        
 } 
 
#declare Jewel=
 intersection {
  #declare i=0;
  #while (i<8)
   box {
    <0,0,-1>,<1,1,1>
    rotate z*20
    rotate y*45*i
    hollow
    no_shadow
   }             
   #declare i=i+1;
  #end
 }
 
#declare Staff= 
 union { 
  object {
   Jewel 
   pigment {rgbf <0.6,0.6,1,0.6>} 
   interior {
    media {
     emission <0.6,0.6,1>*10 
     absorption <0.4,0.4,0>*7.5
    }
   }         
   scale 0.3
   translate y*1.6
  }
  light_source {
   <0,1.9,0>
   rgb <0.5,0.5,1>*0.5
   fade_distance 5
   fade_power 2
  }   
  cylinder {
   <0,0,0>,<0,1.7,0>,0.05
   pigment {Brown}
  }
  torus {
   0.05,0.01
   translate y*1.7 
  }
  torus {
   0.05,0.01
   translate y*1.72      
  }                    
  cylinder {
   <0,1.4,0>,<0,1.71,0>,0.051
  }
  texture {T_Silver_3D}     
 }
                 
 